%------------------------------------------------------------------------------
% File     : SCT210_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 180
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_180 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  173 (  55 unt;  49 typ;   0 def)
%            Number of atoms       :  256 (  93 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  193 (  61   ~;  12   |;  14   &)
%                                         (  28 <=>;  78  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   48 (  25   >;  23   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-5 aty)
%            Number of functors    :   38 (  38 usr;  13 con; 0-6 aty)
%            Number of variables   :  451 ( 403   !;   8   ?; 451   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:41
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (44)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( fun(B,C) > fun(fun(A,B),fun(A,C)) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,B),bool) * A * B ) > $o ) ).

tff(sy_c_FuncSet_OPi,type,
    pi: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,fun(B,bool)) ) > fun(fun(A,B),bool) ) ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(product_prod(A,A),bool),bool) ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_OPowp,type,
    powp: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(A,bool) ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : ( ( A * A ) > bool ) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_P_H____,type,
    p1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_P____,type,
    p: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_Q____,type,
    q: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_a_H____,type,
    a: arrow_411405190le_alt ).

tff(sy_v_a____,type,
    a1: arrow_411405190le_alt ).

tff(sy_v_b_H____,type,
    b: arrow_411405190le_alt ).

tff(sy_v_b____,type,
    b1: arrow_411405190le_alt ).

%----Relevant facts (99)
tff(fact_0__096P_H_A_058_AProf_096,axiom,
    pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),p1),arrow_610318064e_Prof)) ).

tff(fact_1_d2_I1_J,axiom,
    a1 != b ).

tff(fact_2_d2_I2_J,axiom,
    b1 != a ).

tff(fact_3_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_4_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_5_d1_I2_J,axiom,
    a != b ).

tff(fact_6__096a_A_060_092_060_094bsub_062F_AQ_092_060_094esub_062_Ab_096,axiom,
    pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a1,b1)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,q))) ).

tff(fact_7__096a_A_126_061_Aa_H_A_061_061_062_Aa_H_A_060_092_060_094bsub_062F_AQ_092_060_094esub_062_Aa_096,axiom,
    ( ( a1 != a )
   => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,a1)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,q))) ) ).

tff(fact_8__096b_A_126_061_Ab_H_A_061_061_062_Ab_A_060_092_060_094bsub_062F_AQ_092_060_094esub_062_Ab_H_096,axiom,
    ( ( b1 != b )
   => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,b1,b)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,q))) ) ).

tff(fact_9__096a_A_060_092_060_094bsub_062F_AP_092_060_094esub_062_Ab_096,axiom,
    pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a1,b1)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,p))) ).

tff(fact_10__096Q_A_058_AProf_096,axiom,
    pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),q),arrow_610318064e_Prof)) ).

tff(fact_11__096F_AQ_A_058_ALin_096,axiom,
    pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,q)),arrow_1985332922le_Lin)) ).

tff(fact_12__C1_C,axiom,
    ! [I2: arrow_159774573e_indi] :
      ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a1,b1)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I2)))
    <=> pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p1,I2))) ) ).

tff(fact_13_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A3: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A3,B3))) ) ).

tff(fact_14_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B_a: B,A_a: A,Ba: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,Ba) = product_Pair(A,B,A_a,B_a) )
    <=> ( ( Aa = A_a )
        & ( Ba = B_a ) ) ) ).

tff(fact_15__096ALL_Ai_O_A_Ia_A_060_092_060_094bsub_062P_Ai_092_060_094esub_062_Ab_J_A_061_A_Ia_A_060_092_060_094bsub_062Q_Ai_092_060_094esub_062_Ab_J_096,axiom,
    ! [I2: arrow_159774573e_indi] :
      ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a1,b1)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,I2)))
    <=> pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a1,b1)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),q,I2))) ) ).

tff(fact_16_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X3: arrow_411405190le_alt] :
      ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Y2)),arrow_276188178_mkbot(L1,Z)))
    <=> ( ( Y2 != Z )
        & ( ( X3 = Z )
         => ( X3 != Y2 ) )
        & ( ( X3 != Z )
         => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Y2)),L1)) ) ) ) ).

tff(fact_17_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X3: arrow_411405190le_alt] :
      ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Y2)),arrow_424895264_mktop(L1,Z)))
    <=> ( ( X3 != Z )
        & ( ( Y2 = Z )
         => ( X3 != Y2 ) )
        & ( ( Y2 != Z )
         => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Y2)),L1)) ) ) ) ).

tff(fact_18_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A5: A,B4: B,A4: A] :
      ( ( product_Pair(A,B,A4,B4) = product_Pair(A,B,A5,B5) )
     => ~ ( ( A4 = A5 )
         => ( B4 != B5 ) ) ) ).

tff(fact_19_in__rel__def,axiom,
    ! [B: $tType,A: $tType,Y2: B,X3: A,R1: fun(product_prod(A,B),bool)] :
      ( in_rel(A,B,R1,X3,Y2)
    <=> pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),product_Pair(A,B,X3,Y2)),R1)) ) ).

tff(fact_20_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A3: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A3,B3))) ) ).

tff(fact_21__096P_A_058_AProf_096,axiom,
    pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),p),arrow_610318064e_Prof)) ).

tff(fact_22_d1_I1_J,axiom,
    a1 != b1 ).

tff(fact_23_mkbot__Lin,axiom,
    ! [X3: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin))
     => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot(L1,X3)),arrow_1985332922le_Lin)) ) ).

tff(fact_24_mktop__Lin,axiom,
    ! [X3: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin))
     => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop(L1,X3)),arrow_1985332922le_Lin)) ) ).

tff(fact_25_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin))
     => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba)),L1))
       => ~ pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Aa)),L1)) ) ) ).

tff(fact_26_notin__Lin__iff,axiom,
    ! [Y2: arrow_411405190le_alt,X3: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin))
     => ( ( X3 != Y2 )
       => ( ~ pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Y2)),L1))
        <=> pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Y2,X3)),L1)) ) ) ) ).

tff(fact_27_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),X2),arrow_610318064e_Prof))
         => ! [Xa: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),Xa),arrow_610318064e_Prof))
             => ! [A3: arrow_411405190le_alt,B3: arrow_411405190le_alt] :
                  ( ! [I1: arrow_159774573e_indi] :
                      ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X2,I1)))
                    <=> pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa,I1))) )
                 => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X2)))
                  <=> pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa))) ) ) ) ) ) ).

tff(fact_28_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),X2),arrow_610318064e_Prof))
         => ! [A3: arrow_411405190le_alt,B3: arrow_411405190le_alt] :
              ( ! [I1: arrow_159774573e_indi] : pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X2,I1)))
             => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A3,B3)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X2))) ) ) ) ).

tff(fact_29_complete__Lin,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ? [X4: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
          ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X4),arrow_1985332922le_Lin))
          & pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Ba)),X4)) ) ) ).

tff(fact_30_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F11: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F11,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),F11,Aa),Ba) ) ).

tff(fact_31_Q__def,axiom,
    ! [X1: arrow_159774573e_indi] : ( aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),q,X1) = if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fequal(arrow_411405190le_alt,b1,b),if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fequal(arrow_411405190le_alt,a1,a),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X1),arrow_319942042_below(aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X1),a,a1)),arrow_1158827142_above(if(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fequal(arrow_411405190le_alt,a1,a),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X1),arrow_319942042_below(aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X1),a,a1)),b1,b)) ) ).

tff(fact_32_in__below,axiom,
    ! [Y2: arrow_411405190le_alt,X3: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin))
       => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Y2)),arrow_319942042_below(L1,Aa,Ba)))
        <=> ( ( X3 != Y2 )
            & ( ( Y2 = Aa )
             => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Ba)),L1)) )
            & ( ( Y2 != Aa )
             => ( ( ( X3 = Aa )
                 => ( ( Y2 = Ba )
                    | pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ba,Y2)),L1)) ) )
                & ( ( X3 != Aa )
                 => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Y2)),L1)) ) ) ) ) ) ) ) ).

tff(fact_33_in__above,axiom,
    ! [Y2: arrow_411405190le_alt,X3: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin))
       => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Y2)),arrow_1158827142_above(L1,Aa,Ba)))
        <=> ( ( X3 != Y2 )
            & ( ( X3 = Ba )
             => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Aa,Y2)),L1)) )
            & ( ( X3 != Ba )
             => ( ( ( Y2 = Ba )
                 => ( ( X3 = Aa )
                    | pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Aa)),L1)) ) )
                & ( ( Y2 != Ba )
                 => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X3,Y2)),L1)) ) ) ) ) ) ) ) ).

tff(fact_34_assms_I1_J,axiom,
    pp(aa(fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),f),pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin)))) ).

tff(fact_35_const__Lin__Prof,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin))
     => pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,L1)),arrow_610318064e_Prof)) ) ).

tff(fact_36_below__Lin,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X3: arrow_411405190le_alt] :
      ( ( X3 != Y2 )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin))
       => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_319942042_below(L1,X3,Y2)),arrow_1985332922le_Lin)) ) ) ).

tff(fact_37_above__Lin,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X3: arrow_411405190le_alt] :
      ( ( X3 != Y2 )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin))
       => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1158827142_above(L1,X3,Y2)),arrow_1985332922le_Lin)) ) ) ).

tff(fact_38_dictator__def,axiom,
    ! [I: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I)
    <=> ! [X2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),X2),arrow_610318064e_Prof))
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X2) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X2,I) ) ) ) ).

tff(fact_39_linear__alt,axiom,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin)) ).

tff(fact_40_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S: fun(product_prod(A,B),bool),R1: fun(product_prod(A,B),bool)] :
      ( ! [X2: A,Xa: B] :
          ( pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),product_Pair(A,B,X2,Xa)),R1))
        <=> pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),product_Pair(A,B,X2,Xa)),S)) )
    <=> ( R1 = S ) ) ).

tff(fact_41_prod__induct6,axiom,
    ! [F1: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X3: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool)] :
      ( ! [A2: A,B2: B,C2: C,D1: D,E1: E,F2: F1] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),A2,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1))),B2,product_Pair(C,product_prod(D,product_prod(E,F1)),C2,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,Pa,X3)) ) ).

tff(fact_42_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F1: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))))] :
      ~ ! [A2: A,B2: B,C2: C,D1: D,E1: E,F2: F1] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),A2,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1))),B2,product_Pair(C,product_prod(D,product_prod(E,F1)),C2,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2))))) ) ).

tff(fact_43_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X3: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A2: A,B2: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A2,product_Pair(B,product_prod(C,product_prod(D,E)),B2,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,Pa,X3)) ) ).

tff(fact_44_dictatorI,axiom,
    ! [I: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( pp(aa(fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),Fa),pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin))))
     => ( ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
            ( pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),X4),arrow_610318064e_Prof))
           => ! [A2: arrow_411405190le_alt,B2: arrow_411405190le_alt] :
                ( ( A2 != B2 )
               => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B2)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I)))
                 => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B2)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X4))) ) ) )
       => arrow_987702531ctator(Fa,I) ) ) ).

tff(fact_45_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A2: A,B2: B,C2: C,D1: D,E1: E] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A2,product_Pair(B,product_prod(C,product_prod(D,E)),B2,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_46_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A2: A,B2: B,C2: C,D1: D] : ( Y != product_Pair(A,product_prod(B,product_prod(C,D)),A2,product_Pair(B,product_prod(C,D),B2,product_Pair(C,D,C2,D1))) ) ).

tff(fact_47_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X3: product_prod(A,product_prod(B,product_prod(C,D))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A2: A,B2: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,D)),A2,product_Pair(B,product_prod(C,D),B2,product_Pair(C,D,C2,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,X3)) ) ).

tff(fact_48_PiE,axiom,
    ! [B: $tType,A: $tType,X3: A,B1: fun(A,fun(B,bool)),A1: fun(A,bool),F: fun(A,B)] :
      ( pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A1,B1)))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X3)),aa(A,fun(B,bool),B1,X3)))
       => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1)) ) ) ).

tff(fact_49_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X3: product_prod(A,product_prod(B,C)),Pa: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A2: A,B2: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,product_Pair(A,product_prod(B,C),A2,product_Pair(B,C,B2,C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,X3)) ) ).

tff(fact_50_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A2: A,B2: B,C2: C] : ( Y != product_Pair(A,product_prod(B,C),A2,product_Pair(B,C,B2,C2)) ) ).

tff(fact_51_funcset__id,axiom,
    ! [A: $tType,A1: fun(A,bool)] : pp(aa(fun(fun(A,A),bool),bool,aa(fun(A,A),fun(fun(fun(A,A),bool),bool),member(fun(A,A)),combi(A)),pi(A,A,A1,combk(fun(A,bool),A,A1)))) ).

tff(fact_52_Pi__mem,axiom,
    ! [B: $tType,A: $tType,X3: A,B1: fun(A,fun(B,bool)),A1: fun(A,bool),F: fun(A,B)] :
      ( pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A1,B1)))
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X3)),aa(A,fun(B,bool),B1,X3))) ) ) ).

tff(fact_53_funcset__mem,axiom,
    ! [A: $tType,B: $tType,X3: A,B1: fun(B,bool),A1: fun(A,bool),F: fun(A,B)] :
      ( pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A1,combk(fun(B,bool),A,B1))))
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X3)),B1)) ) ) ).

tff(fact_54_Pi__I,axiom,
    ! [B: $tType,A: $tType,B1: fun(A,fun(B,bool)),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X4: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A1))
         => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X4)),aa(A,fun(B,bool),B1,X4))) )
     => pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A1,B1))) ) ).

tff(fact_55_Pi__def,axiom,
    ! [B: $tType,A: $tType,B1: fun(A,fun(B,bool)),A1: fun(A,bool)] : ( pi(A,B,A1,B1) = collect(fun(A,B),aa(fun(fun(A,B),fun(A,bool)),fun(fun(A,B),bool),combb(fun(A,bool),bool,fun(A,B),fAll(A)),aa(fun(fun(A,B),fun(A,bool)),fun(fun(A,B),fun(A,bool)),combb(fun(A,bool),fun(A,bool),fun(A,B),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),combb(bool,fun(bool,bool),A,fimplies),combc(A,fun(A,bool),bool,member(A),A1)))),combc(fun(A,B),fun(A,fun(B,bool)),fun(A,bool),aa(fun(fun(A,B),fun(A,fun(fun(B,bool),bool))),fun(fun(A,B),fun(fun(A,fun(B,bool)),fun(A,bool))),combb(fun(A,fun(fun(B,bool),bool)),fun(fun(A,fun(B,bool)),fun(A,bool)),fun(A,B),combs(A,fun(B,bool),bool)),combb(B,fun(fun(B,bool),bool),A,member(B))),B1)))) ) ).

tff(fact_56_funcsetI,axiom,
    ! [A: $tType,B: $tType,B1: fun(B,bool),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X4: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A1))
         => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X4)),B1)) )
     => pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A1,combk(fun(B,bool),A,B1)))) ) ).

tff(fact_57_Pi__I_H,axiom,
    ! [B: $tType,A: $tType,B1: fun(A,fun(B,bool)),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X4: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A1))
         => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X4)),aa(A,fun(B,bool),B1,X4))) )
     => pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A1,B1))) ) ).

tff(fact_58_Pi__cong,axiom,
    ! [B: $tType,A: $tType,B1: fun(A,fun(B,bool)),G: fun(A,B),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [W: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),W),A1))
         => ( aa(A,B,F,W) = aa(A,B,G,W) ) )
     => ( pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A1,B1)))
      <=> pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),G),pi(A,B,A1,B1))) ) ) ).

tff(fact_59_PairE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B)] :
      ~ ! [X4: A,Y1: B] : ( P1 != product_Pair(A,B,X4,Y1) ) ).

tff(fact_60_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A2: A,B2: B] : ( Y != product_Pair(A,B,A2,B2) ) ).

tff(fact_61_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,C1: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,C1,product_Pair(B,C,Aa,Ba)) = aa(C,A,aa(B,fun(C,A),C1,Aa),Ba) ) ).

tff(fact_62_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ba: C,Aa: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,Aa,Ba) = aa(product_prod(B,C),A,F,product_Pair(B,C,Aa,Ba)) ) ).

tff(fact_63_top1I,axiom,
    ! [A: $tType,X3: A] : pp(aa(A,bool,top_top(fun(A,bool)),X3)) ).

tff(fact_64_curryI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba)))
     => pp(product_curry(A,B,bool,F,Aa,Ba)) ) ).

tff(fact_65_Pi__UNIV,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool)] : ( pi(A,B,A1,combk(fun(B,bool),A,top_top(fun(B,bool)))) = top_top(fun(fun(A,B),bool)) ) ).

tff(fact_66_curryD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_67_curryE,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,Ba))) ) ).

tff(fact_68_Prof__def,axiom,
    arrow_610318064e_Prof = pi(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),top_top(fun(arrow_159774573e_indi,bool)),combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),arrow_159774573e_indi,arrow_1985332922le_Lin)) ).

tff(fact_69_curry__def,axiom,
    ! [C: $tType,A: $tType,B: $tType,X1: fun(product_prod(A,B),C),Xa1: A,Xb: B] : ( product_curry(A,B,C,X1,Xa1,Xb) = aa(product_prod(A,B),C,X1,product_Pair(A,B,Xa1,Xb)) ) ).

tff(fact_70_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X3: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),top_top(fun(A,bool)))) ).

tff(fact_71_UNIV__I,axiom,
    ! [A: $tType,X3: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),top_top(fun(A,bool)))) ).

tff(fact_72_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X3: B] : ( aa(B,A,top_top(fun(B,A)),X3) = top_top(A) ) ) ).

tff(fact_73_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_74_ball__UNIV,axiom,
    ! [A: $tType,Pa: fun(A,bool)] :
      ( ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),top_top(fun(A,bool))))
         => pp(aa(A,bool,Pa,X2)) )
    <=> ! [X11: A] : pp(aa(A,bool,Pa,X11)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X4: A] : ( aa(A,B,F,X4) = aa(A,B,G,X4) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
    <=> pp(aa(A,bool,A1,X3)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ( collect(A,Pa) = Pa ) ).

tff(fact_78_UNIV__eq__I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X4: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A1))
     => ( top_top(fun(A,bool)) = A1 ) ) ).

tff(fact_79_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X4: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),top_top(fun(A,bool)))) ).

tff(fact_80_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_81_Powp__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: fun(A,bool)] :
      ( powp(A,A1,X1)
    <=> ! [Xa: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),X1))
         => pp(aa(A,bool,A1,Xa)) ) ) ).

tff(fact_82_Pi__empty,axiom,
    ! [B: $tType,A: $tType,B1: fun(A,fun(B,bool))] : ( pi(A,B,bot_bot(fun(A,bool)),B1) = top_top(fun(fun(A,B),bool)) ) ).

tff(fact_83_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_84_empty__Collect__eq,axiom,
    ! [A: $tType,Pa: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,Pa) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,Pa,X2)) ) ).

tff(fact_85_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_86_Collect__empty__eq,axiom,
    ! [A: $tType,Pa: fun(A,bool)] :
      ( ( collect(A,Pa) = bot_bot(fun(A,bool)) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,Pa,X2)) ) ).

tff(fact_87_emptyE,axiom,
    ! [A: $tType,Aa: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),bot_bot(fun(A,bool)))) ).

tff(fact_88_ball__empty,axiom,
    ! [A: $tType,Pa: fun(A,bool),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),bot_bot(fun(A,bool))))
     => pp(aa(A,bool,Pa,X1)) ) ).

tff(fact_89_Collect__const,axiom,
    ! [A: $tType,Pa: bool] :
      ( ( pp(Pa)
       => ( collect(A,combk(bool,A,Pa)) = top_top(fun(A,bool)) ) )
      & ( ~ pp(Pa)
       => ( collect(A,combk(bool,A,Pa)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_90_Pi__eq__empty,axiom,
    ! [A: $tType,B: $tType,B1: fun(A,fun(B,bool)),A1: fun(A,bool)] :
      ( ( pi(A,B,A1,B1) = bot_bot(fun(fun(A,B),bool)) )
    <=> ? [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
          & ( aa(A,fun(B,bool),B1,X2) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_91_UNIV__not__empty,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) != bot_bot(fun(A,bool)) ) ).

tff(fact_92_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X1: A] : ( aa(A,B,bot_bot(fun(A,B)),X1) = bot_bot(B) ) ) ).

tff(fact_93_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_94_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X3: B] : ( aa(B,A,bot_bot(fun(B,A)),X3) = bot_bot(A) ) ) ).

tff(fact_95_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_96_equals0D,axiom,
    ! [A: $tType,Aa: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ).

tff(fact_97_bot__empty__eq,axiom,
    ! [A: $tType,X1: A] :
      ( pp(aa(A,bool,bot_bot(fun(A,bool)),X1))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),bot_bot(fun(A,bool)))) ) ).

tff(fact_98_equals0I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [Y1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),A1))
     => ( A1 = bot_bot(fun(A,bool)) ) ) ).

%----Arities (4)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (20)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),combb(B,C,A,P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(fequal(A,X,Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(fequal(A,X,Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,a,b)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,q))) ).

%------------------------------------------------------------------------------
