%------------------------------------------------------------------------------
% File     : SCT201_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 154
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_154 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  156 (  45 unt;  40 typ;   0 def)
%            Number of atoms       :  259 (  93 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  202 (  59   ~;   9   |;  15   &)
%                                         (  24 <=>;  95  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   42 (  23   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-6 aty)
%            Number of functors    :   30 (  30 usr;   6 con; 0-6 aty)
%            Number of variables   :  568 ( 520   !;   8   ?; 568   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:47
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_FuncSet_OPi,type,
    pi: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,fun(B,bool)) ) > fun(fun(A,B),bool) ) ).

tff(sy_c_FuncSet_Ocompose,type,
    compose: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,bool) * fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_HOL_OThe,type,
    the: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(product_prod(A,A),bool),bool) ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,product_prod(A,B))) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(product_prod(A,B),C) > fun(A,fun(B,C)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(product_prod(A,B),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A: $tType,B: $tType,T: $tType] : fun(fun(A,fun(B,T)),fun(product_prod(A,B),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

%----Relevant facts (100)
tff(fact_0_assms_I3_J,axiom,
    arrow_1958449194le_IIA(f) ).

tff(fact_1_u,axiom,
    arrow_2069624013nimity(f) ).

tff(fact_2_dictator__def,axiom,
    ! [I2: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,I2)
    <=> ! [X1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X1,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X1) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X1,I2) ) ) ) ).

tff(fact_3_assms_I1_J,axiom,
    member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),f,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin))) ).

tff(fact_4_const__Lin__Prof,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,L),arrow_610318064e_Prof) ) ).

tff(fact_5_PiE,axiom,
    ! [B: $tType,A: $tType,X2: A,B1: fun(A,fun(B,bool)),A1: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A1,B1))
     => ( ~ member(B,aa(A,B,F,X2),aa(A,fun(B,bool),B1,X2))
       => ~ member(A,X2,A1) ) ) ).

tff(fact_6_dictatorI,axiom,
    ! [I2: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Fa,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin)))
     => ( ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
            ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X3,arrow_610318064e_Prof)
           => ! [A3: arrow_411405190le_alt,B2: arrow_411405190le_alt] :
                ( ( A3 != B2 )
               => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I2))
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B2),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X3)) ) ) )
       => arrow_987702531ctator(Fa,I2) ) ) ).

tff(fact_7_linear__alt,axiom,
    ? [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin) ).

tff(fact_8_funcset__id,axiom,
    ! [A: $tType,A1: fun(A,bool)] : member(fun(A,A),combi(A),pi(A,A,A1,combk(fun(A,bool),A,A1))) ).

tff(fact_9_funcset__mem,axiom,
    ! [A: $tType,B: $tType,X2: A,B1: fun(B,bool),A1: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A1,combk(fun(B,bool),A,B1)))
     => ( member(A,X2,A1)
       => member(B,aa(A,B,F,X2),B1) ) ) ).

tff(fact_10_above__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( ( X2 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_1158827142_above(L,X2,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_11_below__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( ( X2 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_319942042_below(L,X2,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_12_mkbot__Lin,axiom,
    ! [X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(L,X2),arrow_1985332922le_Lin) ) ).

tff(fact_13_mktop__Lin,axiom,
    ! [X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(L,X2),arrow_1985332922le_Lin) ) ).

tff(fact_14_Pi__mem,axiom,
    ! [B: $tType,A: $tType,X2: A,B1: fun(A,fun(B,bool)),A1: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A1,B1))
     => ( member(A,X2,A1)
       => member(B,aa(A,B,F,X2),aa(A,fun(B,bool),B1,X2)) ) ) ).

tff(fact_15_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X1,arrow_610318064e_Prof)
         => ! [A4: arrow_411405190le_alt,B4: arrow_411405190le_alt] :
              ( ! [I1: arrow_159774573e_indi] : member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B4),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X1,I1))
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B4),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X1)) ) ) ) ).

tff(fact_16_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),arrow_424895264_mktop(L,Z))
    <=> ( ( X2 != Z )
        & ( ( Y1 = Z )
         => ( X2 != Y1 ) )
        & ( ( Y1 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),L) ) ) ) ).

tff(fact_17_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),arrow_276188178_mkbot(L,Z))
    <=> ( ( Y1 != Z )
        & ( ( X2 = Z )
         => ( X2 != Y1 ) )
        & ( ( X2 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),L) ) ) ) ).

tff(fact_18_in__below,axiom,
    ! [Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B3: arrow_411405190le_alt,A2: arrow_411405190le_alt] :
      ( ( A2 != B3 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),arrow_319942042_below(L,A2,B3))
        <=> ( ( X2 != Y1 )
            & ( ( Y1 = A2 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),B3),L) )
            & ( ( Y1 != A2 )
             => ( ( ( X2 = A2 )
                 => ( ( Y1 = B3 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B3),Y1),L) ) )
                & ( ( X2 != A2 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),L) ) ) ) ) ) ) ) ).

tff(fact_19_in__above,axiom,
    ! [Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B3: arrow_411405190le_alt,A2: arrow_411405190le_alt] :
      ( ( A2 != B3 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),arrow_1158827142_above(L,A2,B3))
        <=> ( ( X2 != Y1 )
            & ( ( X2 = B3 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),Y1),L) )
            & ( ( X2 != B3 )
             => ( ( ( Y1 = B3 )
                 => ( ( X2 = A2 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),A2),L) ) )
                & ( ( Y1 != B3 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),L) ) ) ) ) ) ) ) ).

tff(fact_20_Lin__irrefl,axiom,
    ! [B3: arrow_411405190le_alt,A2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),B3),L)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B3),A2),L) ) ) ).

tff(fact_21_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( ( X2 != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),L)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),X2),L) ) ) ) ).

tff(fact_22_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X1,arrow_610318064e_Prof)
         => ! [Xa1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Xa1,arrow_610318064e_Prof)
             => ! [A4: arrow_411405190le_alt,B4: arrow_411405190le_alt] :
                  ( ! [I1: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B4),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X1,I1))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B4),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa1,I1)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B4),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X1))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B4),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa1)) ) ) ) ) ) ).

tff(fact_23_Pi__I,axiom,
    ! [B: $tType,A: $tType,B1: fun(A,fun(B,bool)),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X3: A] :
          ( member(A,X3,A1)
         => member(B,aa(A,B,F,X3),aa(A,fun(B,bool),B1,X3)) )
     => member(fun(A,B),F,pi(A,B,A1,B1)) ) ).

tff(fact_24_complete__Lin,axiom,
    ! [B3: arrow_411405190le_alt,A2: arrow_411405190le_alt] :
      ( ( A2 != B3 )
     => ? [X3: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
          ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,arrow_1985332922le_Lin)
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),B3),X3) ) ) ).

tff(fact_25_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B7: B,A7: A,B3: B,A2: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B3) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A7),B7) )
    <=> ( ( A2 = A7 )
        & ( B3 = B7 ) ) ) ).

tff(fact_26_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ! [A4: A,B4: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B4))) ) ).

tff(fact_27_funcsetI,axiom,
    ! [A: $tType,B: $tType,B1: fun(B,bool),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X3: A] :
          ( member(A,X3,A1)
         => member(B,aa(A,B,F,X3),B1) )
     => member(fun(A,B),F,pi(A,B,A1,combk(fun(B,bool),A,B1))) ) ).

tff(fact_28_Pi__cong,axiom,
    ! [B: $tType,A: $tType,B1: fun(A,fun(B,bool)),G: fun(A,B),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [W: A] :
          ( member(A,W,A1)
         => ( aa(A,B,F,W) = aa(A,B,G,W) ) )
     => ( member(fun(A,B),F,pi(A,B,A1,B1))
      <=> member(fun(A,B),G,pi(A,B,A1,B1)) ) ) ).

tff(fact_29_Pi__I_H,axiom,
    ! [B: $tType,A: $tType,B1: fun(A,fun(B,bool)),F: fun(A,B),A1: fun(A,bool)] :
      ( ! [X3: A] :
          ( member(A,X3,A1)
         => member(B,aa(A,B,F,X3),aa(A,fun(B,bool),B1,X3)) )
     => member(fun(A,B),F,pi(A,B,A1,B1)) ) ).

tff(fact_30_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B6: B,A6: A,B5: B,A5: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B5) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B6) )
     => ~ ( ( A5 = A6 )
         => ( B5 != B6 ) ) ) ).

tff(fact_31_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ? [A4: A,B4: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B4))) ) ).

tff(fact_32_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B3: C,A2: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B3)) = aa(C,A,aa(B,fun(C,A),F1,A2),B3) ) ).

tff(fact_33_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A3: A,B2: B,C3: C,D2: D,E1: E,F3: F2] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C3),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D2),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,X2)) ) ).

tff(fact_34_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A3: A,B2: B,C3: C,D2: D,E1: E,F3: F2] : ( Y != aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C3),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D2),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_35_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A3: A,B2: B,C3: C,D2: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A3),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C3),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D2),E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,X2)) ) ).

tff(fact_36_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A3: A,B2: B,C3: C,D2: D,E1: E] : ( Y != aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A3),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C3),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D2),E1)))) ) ).

tff(fact_37_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A3: A,B2: B,C3: C,D2: D] : ( Y != aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A3),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B2),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C3),D2))) ) ).

tff(fact_38_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,D))),P1: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A3: A,B2: B,C3: C,D2: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A3),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B2),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C3),D2)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,X2)) ) ).

tff(fact_39_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A3: A,B2: B,C3: C] : ( Y != aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A3),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B2),C3)) ) ).

tff(fact_40_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,C)),P1: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A3: A,B2: B,C3: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P1,aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A3),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B2),C3))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P1,X2)) ) ).

tff(fact_41_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S: fun(product_prod(A,B),bool),R2: fun(product_prod(A,B),bool)] :
      ( ! [X1: A,Xa1: B] :
          ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Xa1),R2)
        <=> member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Xa1),S) )
    <=> ( R2 = S ) ) ).

tff(fact_42_PairE,axiom,
    ! [A: $tType,B: $tType,P3: product_prod(A,B)] :
      ~ ! [X3: A,Y2: B] : ( P3 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Y2) ) ).

tff(fact_43_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A3: A,B2: B] : ( Y != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) ) ).

tff(fact_44_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B3: C,A2: B,C1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),produc1605651328_split(B,C,A),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B3)) = aa(C,A,aa(B,fun(C,A),C1,A2),B3) ) ).

tff(fact_45_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,B3: C,A2: B,F: fun(product_prod(B,C),A)] : ( aa(C,A,aa(B,fun(C,A),product_curry(B,C,A,F),A2),B3) = aa(product_prod(B,C),A,F,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B3)) ) ).

tff(fact_46_curry__def,axiom,
    ! [C: $tType,A: $tType,B: $tType,X4: fun(product_prod(A,B),C),Xa: A,Xb: B] : ( aa(B,C,aa(A,fun(B,C),product_curry(A,B,C,X4),Xa),Xb) = aa(product_prod(A,B),C,X4,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Xa),Xb)) ) ).

tff(fact_47_curryI,axiom,
    ! [A: $tType,B: $tType,B3: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B3)))
     => pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B3)) ) ).

tff(fact_48_curryE,axiom,
    ! [A: $tType,B: $tType,B3: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B3))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B3))) ) ).

tff(fact_49_curryD,axiom,
    ! [A: $tType,B: $tType,B3: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B3))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B3))) ) ).

tff(fact_50_Prof__def,axiom,
    arrow_610318064e_Prof = pi(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),top_top(fun(arrow_159774573e_indi,bool)),combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),arrow_159774573e_indi,arrow_1985332922le_Lin)) ).

tff(fact_51_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Y1: B,X2: B,F: fun(B,A),R1: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R1,F,X2,Y1)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R1,aa(B,A,F,X2)),aa(B,A,F,Y1))) ) ).

tff(fact_52_internal__split__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] : ( produc1605651328_split(A,B,C) = product_prod_case(A,B,C) ) ).

tff(fact_53_compose__assoc,axiom,
    ! [C: $tType,D: $tType,B: $tType,A: $tType,D1: fun(D,bool),H: fun(C,D),C2: fun(C,bool),G: fun(B,C),B1: fun(B,bool),A1: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A1,combk(fun(B,bool),A,B1)))
     => ( member(fun(B,C),G,pi(B,C,B1,combk(fun(C,bool),B,C2)))
       => ( member(fun(C,D),H,pi(C,D,C2,combk(fun(D,bool),C,D1)))
         => ( compose(A,C,D,A1,H,compose(A,B,C,A1,G,F)) = compose(A,B,D,A1,compose(B,C,D,B1,H,G),F) ) ) ) ) ).

tff(fact_54_splitI,axiom,
    ! [A: $tType,B: $tType,B3: B,A2: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F,A2),B3))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B3))) ) ).

tff(fact_55_prod__caseI,axiom,
    ! [A: $tType,B: $tType,B3: B,A2: A,F1: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F1,A2),B3))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F1),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B3))) ) ).

tff(fact_56_mem__splitI,axiom,
    ! [A: $tType,B: $tType,C: $tType,B3: C,A2: B,C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,A2),B3))
     => member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B3))) ) ).

tff(fact_57_top1I,axiom,
    ! [A: $tType,X2: A] : pp(aa(A,bool,top_top(fun(A,bool)),X2)) ).

tff(fact_58_split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B3: C,A2: B,F: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B3)) = aa(C,A,aa(B,fun(C,A),F,A2),B3) ) ).

tff(fact_59_Pi__UNIV,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool)] : ( pi(A,B,A1,combk(fun(B,bool),A,top_top(fun(B,bool)))) = top_top(fun(fun(A,B),bool)) ) ).

tff(fact_60_prod_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType,B3: C,A2: B,F1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B3)) = aa(C,A,aa(B,fun(C,A),F1,A2),B3) ) ).

tff(fact_61_splitD,axiom,
    ! [A: $tType,B: $tType,B3: B,A2: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B3)))
     => pp(aa(B,bool,aa(A,fun(B,bool),F,A2),B3)) ) ).

tff(fact_62_compose__eq,axiom,
    ! [B: $tType,C: $tType,A: $tType,F: fun(A,C),G: fun(C,B),A1: fun(A,bool),X2: A] :
      ( member(A,X2,A1)
     => ( aa(A,B,compose(A,C,B,A1,G,F),X2) = aa(C,B,G,aa(A,C,F,X2)) ) ) ).

tff(fact_63_split__weak__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,C)),Q2: product_prod(A,B),P2: product_prod(A,B)] :
      ( ( P2 = Q2 )
     => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),P2) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),Q2) ) ) ).

tff(fact_64_split__twice,axiom,
    ! [B: $tType,C: $tType,A: $tType,E: $tType,D: $tType,P2: product_prod(D,E),G: fun(D,fun(E,product_prod(B,C))),F: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F),aa(product_prod(D,E),product_prod(B,C),aa(fun(D,fun(E,product_prod(B,C))),fun(product_prod(D,E),product_prod(B,C)),product_prod_case(D,E,product_prod(B,C)),G),P2)) = aa(product_prod(D,E),A,aa(fun(D,fun(E,A)),fun(product_prod(D,E),A),product_prod_case(D,E,A),aa(fun(D,fun(E,product_prod(B,C))),fun(D,fun(E,A)),aa(fun(fun(E,product_prod(B,C)),fun(E,A)),fun(fun(D,fun(E,product_prod(B,C))),fun(D,fun(E,A))),combb(fun(E,product_prod(B,C)),fun(E,A),D),aa(fun(product_prod(B,C),A),fun(fun(E,product_prod(B,C)),fun(E,A)),combb(product_prod(B,C),A,E),aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F))),G)),P2) ) ).

tff(fact_65_splitD_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,C1: C,B3: B,A2: A,R2: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),R2),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B3)),C1))
     => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),R2,A2),B3),C1)) ) ).

tff(fact_66_split__eta,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(product_prod(A,B),C)] : ( aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),aa(fun(A,fun(B,product_prod(A,B))),fun(A,fun(B,C)),aa(fun(fun(B,product_prod(A,B)),fun(B,C)),fun(fun(A,fun(B,product_prod(A,B))),fun(A,fun(B,C))),combb(fun(B,product_prod(A,B)),fun(B,C),A),aa(fun(product_prod(A,B),C),fun(fun(B,product_prod(A,B)),fun(B,C)),combb(product_prod(A,B),C,B),F)),product_Pair(A,B))) = F ) ).

tff(fact_67_split__curry,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(product_prod(A,B),C)] : ( aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),product_curry(A,B,C,F)) = F ) ).

tff(fact_68_curry__split,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(A,fun(B,C))] : ( product_curry(A,B,C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F)) = F ) ).

tff(fact_69_inv__imagep__def,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),R1: fun(B,fun(B,bool)),X4: A,Xa: A] :
      ( inv_imagep(B,A,R1,F,X4,Xa)
    <=> pp(aa(B,bool,aa(B,fun(B,bool),R1,aa(A,B,F,X4)),aa(A,B,F,Xa))) ) ).

tff(fact_70_funcset__compose,axiom,
    ! [B: $tType,A: $tType,C: $tType,C2: fun(C,bool),G: fun(B,C),B1: fun(B,bool),A1: fun(A,bool),F: fun(A,B)] :
      ( member(fun(A,B),F,pi(A,B,A1,combk(fun(B,bool),A,B1)))
     => ( member(fun(B,C),G,pi(B,C,B1,combk(fun(C,bool),B,C2)))
       => member(fun(A,C),compose(A,B,C,A1,G,F),pi(A,C,A1,combk(fun(C,bool),A,C2))) ) ) ).

tff(fact_71_splitE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B),C1: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P2))
     => ~ ! [X3: A,Y2: B] :
            ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Y2) )
           => ~ pp(aa(B,bool,aa(A,fun(B,bool),C1,X3),Y2)) ) ) ).

tff(fact_72_splitI2,axiom,
    ! [B: $tType,A: $tType,C1: fun(A,fun(B,bool)),P2: product_prod(A,B)] :
      ( ! [A3: A,B2: B] :
          ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) )
         => pp(aa(B,bool,aa(A,fun(B,bool),C1,A3),B2)) )
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P2)) ) ).

tff(fact_73_mem__splitI2,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,fun(C,bool))),Z: C,P2: product_prod(A,B)] :
      ( ! [A3: A,B2: B] :
          ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) )
         => member(C,Z,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A3),B2)) )
     => member(C,Z,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P2)) ) ).

tff(fact_74_splitI2_H,axiom,
    ! [A: $tType,B: $tType,C: $tType,X2: C,C1: fun(A,fun(B,fun(C,bool))),P2: product_prod(A,B)] :
      ( ! [A3: A,B2: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) = P2 )
         => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A3),B2),X2)) )
     => pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P2),X2)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( member(A,X2,A1)
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_split__part,axiom,
    ! [B: $tType,A: $tType,Q1: fun(A,fun(B,bool)),P1: bool,X4: product_prod(A,B)] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),aa(fun(A,fun(B,bool)),fun(A,fun(B,bool)),aa(fun(fun(B,bool),fun(B,bool)),fun(fun(A,fun(B,bool)),fun(A,fun(B,bool))),combb(fun(B,bool),fun(B,bool),A),aa(fun(bool,bool),fun(fun(B,bool),fun(B,bool)),combb(bool,bool,B),aa(bool,fun(bool,bool),fconj,P1))),Q1)),X4))
    <=> ( pp(P1)
        & pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),Q1),X4)) ) ) ).

tff(fact_79_splitE_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: C,P2: product_prod(A,B),C1: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P2),Z))
     => ~ ! [X3: A,Y2: B] :
            ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Y2) )
           => ~ pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,X3),Y2),Z)) ) ) ).

tff(fact_80_mem__splitE,axiom,
    ! [B: $tType,A: $tType,C: $tType,P2: product_prod(B,C),C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),P2))
     => ~ ! [X3: B,Y2: C] :
            ( ( P2 = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X3),Y2) )
           => ~ member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,X3),Y2)) ) ) ).

tff(fact_81_cond__split__eta,axiom,
    ! [C: $tType,B: $tType,A: $tType,G: fun(product_prod(A,B),C),F: fun(A,fun(B,C))] :
      ( ! [X3: A,Y2: B] : ( aa(B,C,aa(A,fun(B,C),F,X3),Y2) = aa(product_prod(A,B),C,G,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Y2)) )
     => ( aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F) = G ) ) ).

tff(fact_82_UNIV__I,axiom,
    ! [A: $tType,X2: A] : member(A,X2,top_top(fun(A,bool))) ).

tff(fact_83_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_84_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X2: A] : member(A,X2,top_top(fun(A,bool))) ).

tff(fact_85_splitE2,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: product_prod(B,C),P1: fun(B,fun(C,A)),Q1: fun(A,bool)] :
      ( pp(aa(A,bool,Q1,aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),P1),Z)))
     => ~ ! [X3: B,Y2: C] :
            ( ( Z = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X3),Y2) )
           => ~ pp(aa(A,bool,Q1,aa(C,A,aa(B,fun(C,A),P1,X3),Y2))) ) ) ).

tff(fact_86_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X2: B] : ( aa(B,A,top_top(fun(B,A)),X2) = top_top(A) ) ) ).

tff(fact_87_UNIV__eq__I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X3: A] : member(A,X3,A1)
     => ( top_top(fun(A,bool)) = A1 ) ) ).

tff(fact_88_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X3: A] : member(A,X3,top_top(fun(A,bool))) ).

tff(fact_89_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_90_The__split__eq,axiom,
    ! [A: $tType,B: $tType,Y1: B,X2: A] : ( the(product_prod(A,B),aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),combc(A,fun(B,bool),fun(B,bool),aa(fun(A,fun(bool,bool)),fun(A,fun(fun(B,bool),fun(B,bool))),aa(fun(fun(bool,bool),fun(fun(B,bool),fun(B,bool))),fun(fun(A,fun(bool,bool)),fun(A,fun(fun(B,bool),fun(B,bool)))),combb(fun(bool,bool),fun(fun(B,bool),fun(B,bool)),A),combb(bool,bool,B)),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),fequal(A,X2))),fequal(B,Y1)))) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y1) ) ).

tff(fact_91_Pi__empty,axiom,
    ! [B: $tType,A: $tType,B1: fun(A,fun(B,bool))] : ( pi(A,B,bot_bot(fun(A,bool)),B1) = top_top(fun(fun(A,B),bool)) ) ).

tff(fact_92_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X1: A] : ~ member(A,X1,A1)
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_93_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X1: A] : ~ pp(aa(A,bool,P1,X1)) ) ).

tff(fact_94_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ member(A,C1,bot_bot(fun(A,bool))) ).

tff(fact_95_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X1: A] : ~ pp(aa(A,bool,P1,X1)) ) ).

tff(fact_96_emptyE,axiom,
    ! [A: $tType,A2: A] : ~ member(A,A2,bot_bot(fun(A,bool))) ).

tff(fact_97_Collect__const,axiom,
    ! [A: $tType,P1: bool] :
      ( ( pp(P1)
       => ( collect(A,combk(bool,A,P1)) = top_top(fun(A,bool)) ) )
      & ( ~ pp(P1)
       => ( collect(A,combk(bool,A,P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_98_Pi__eq__empty,axiom,
    ! [A: $tType,B: $tType,B1: fun(A,fun(B,bool)),A1: fun(A,bool)] :
      ( ( pi(A,B,A1,B1) = bot_bot(fun(fun(A,B),bool)) )
    <=> ? [X1: A] :
          ( member(A,X1,A1)
          & ( aa(A,fun(B,bool),B1,X1) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_99_UNIV__not__empty,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) != bot_bot(fun(A,bool)) ) ).

%----Arities (2)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

%----Helper facts (13)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,fequal(A,X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,fequal(A,X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ? [I: arrow_159774573e_indi] : arrow_987702531ctator(f,I) ).

%------------------------------------------------------------------------------
