%------------------------------------------------------------------------------
% File     : SCT199_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 146
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_146 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  163 (  43 unt;  43 typ;   0 def)
%            Number of atoms       :  264 (  90 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  202 (  58   ~;   9   |;  15   &)
%                                         (  35 <=>;  85  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   46 (  25   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   1 prp; 0-6 aty)
%            Number of functors    :   31 (  31 usr;   5 con; 0-6 aty)
%            Number of variables   :  517 ( 465   !;   9   ?; 517   :)
%                                         (  43  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:23
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (38)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( fun(B,C) > fun(fun(A,B),fun(A,C)) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_FuncSet_OPi,type,
    pi: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(A,fun(B,bool)) ) > fun(fun(A,B),bool) ) ).

tff(sy_c_FuncSet_Oextensional__funcset,type,
    extensional_funcset: 
      !>[A: $tType,B: $tType] : ( ( fun(A,bool) * fun(B,bool) ) > fun(fun(A,B),bool) ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(product_prod(A,A),bool),bool) ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_Oconversep,type,
    conversep: 
      !>[A: $tType,B: $tType] : ( fun(A,fun(B,bool)) > fun(B,fun(A,bool)) ) ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,product_prod(A,B))) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T1: $tType] : ( ( fun(A,fun(B,T1)) * product_prod(A,B) ) > T1 ) ).

tff(sy_c_Relation_Oconverse,type,
    converse: 
      !>[A: $tType,B: $tType] : ( fun(product_prod(A,B),bool) > fun(product_prod(B,A),bool) ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B: $tType,A: $tType] : ( ( fun(product_prod(B,B),bool) * fun(A,B) ) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_thesis____,type,
    thesis: $o ).

%----Relevant facts (100)
tff(fact_0_linear__alt,axiom,
    ? [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L1),arrow_1985332922le_Lin)) ).

tff(fact_1_above__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y1 )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
       => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1158827142_above(L,X1,Y1)),arrow_1985332922le_Lin)) ) ) ).

tff(fact_2_below__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y1 )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
       => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_319942042_below(L,X1,Y1)),arrow_1985332922le_Lin)) ) ) ).

tff(fact_3_mkbot__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
     => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_276188178_mkbot(L,X1)),arrow_1985332922le_Lin)) ) ).

tff(fact_4_mktop__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
     => pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_424895264_mktop(L,X1)),arrow_1985332922le_Lin)) ) ).

tff(fact_5_converse__in__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),converse(arrow_411405190le_alt,arrow_411405190le_alt,L)),arrow_1985332922le_Lin))
    <=> pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin)) ) ).

tff(fact_6_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
     => ( ( X1 != Y1 )
       => ( ~ pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1)),L))
        <=> pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),X1)),L)) ) ) ) ).

tff(fact_7_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
     => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba)),L))
       => ~ pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Aa)),L)) ) ) ).

tff(fact_8_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_9_in__above,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
       => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1)),arrow_1158827142_above(L,Aa,Ba)))
        <=> ( ( X1 != Y1 )
            & ( ( X1 = Ba )
             => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Y1)),L)) )
            & ( ( X1 != Ba )
             => ( ( ( Y1 = Ba )
                 => ( ( X1 = Aa )
                    | pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Aa)),L)) ) )
                & ( ( Y1 != Ba )
                 => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1)),L)) ) ) ) ) ) ) ) ).

tff(fact_10_in__below,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
       => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1)),arrow_319942042_below(L,Aa,Ba)))
        <=> ( ( X1 != Y1 )
            & ( ( Y1 = Aa )
             => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Ba)),L)) )
            & ( ( Y1 != Aa )
             => ( ( ( X1 = Aa )
                 => ( ( Y1 = Ba )
                    | pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Y1)),L)) ) )
                & ( ( X1 != Aa )
                 => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1)),L)) ) ) ) ) ) ) ) ).

tff(fact_11_const__Lin__Prof,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),L),arrow_1985332922le_Lin))
     => pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),combk(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_159774573e_indi,L)),arrow_610318064e_Prof)) ) ).

tff(fact_12_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1)),arrow_276188178_mkbot(L,Z)))
    <=> ( ( Y1 != Z )
        & ( ( X1 = Z )
         => ( X1 != Y1 ) )
        & ( ( X1 != Z )
         => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1)),L)) ) ) ) ).

tff(fact_13_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1)),arrow_424895264_mktop(L,Z)))
    <=> ( ( X1 != Z )
        & ( ( Y1 = Z )
         => ( X1 != Y1 ) )
        & ( ( Y1 != Z )
         => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1)),L)) ) ) ) ).

tff(fact_14_converse__iff,axiom,
    ! [A: $tType,B: $tType,R2: fun(product_prod(B,A),bool),Ba: B,Aa: A] :
      ( pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba)),converse(B,A,R2)))
    <=> pp(aa(fun(product_prod(B,A),bool),bool,aa(product_prod(B,A),fun(fun(product_prod(B,A),bool),bool),member(product_prod(B,A)),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),Ba),Aa)),R2)) ) ).

tff(fact_15_top1I,axiom,
    ! [A: $tType,X1: A] : pp(aa(A,bool,top_top(fun(A,bool)),X1)) ).

tff(fact_16_UNIV__I,axiom,
    ! [A: $tType,X1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),top_top(fun(A,bool)))) ).

tff(fact_17_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),top_top(fun(A,bool)))) ).

tff(fact_18_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ! [A3: A,B1: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B1))) ) ).

tff(fact_19_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A8: A,Ba: B,Aa: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A8),B6) )
    <=> ( ( Aa = A8 )
        & ( Ba = B6 ) ) ) ).

tff(fact_20_converseI,axiom,
    ! [B: $tType,A: $tType,R2: fun(product_prod(A,B),bool),Ba: B,Aa: A] :
      ( pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba)),R2))
     => pp(aa(fun(product_prod(B,A),bool),bool,aa(product_prod(B,A),fun(fun(product_prod(B,A),bool),bool),member(product_prod(B,A)),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),Ba),Aa)),converse(A,B,R2))) ) ).

tff(fact_21_converseD,axiom,
    ! [A: $tType,B: $tType,R2: fun(product_prod(B,A),bool),Ba: B,Aa: A] :
      ( pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba)),converse(B,A,R2)))
     => pp(aa(fun(product_prod(B,A),bool),bool,aa(product_prod(B,A),fun(fun(product_prod(B,A),bool),bool),member(product_prod(B,A)),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),Ba),Aa)),R2)) ) ).

tff(fact_22_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X1: B] : ( aa(B,A,top_top(fun(B,A)),X1) = top_top(A) ) ) ).

tff(fact_23_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A7: A,B4: B,A6: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B4) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A7),B5) )
     => ~ ( ( A6 = A7 )
         => ( B4 != B5 ) ) ) ).

tff(fact_24_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_25_converse__converse,axiom,
    ! [B: $tType,A: $tType,R2: fun(product_prod(A,B),bool)] : ( converse(B,A,converse(A,B,R2)) = R2 ) ).

tff(fact_26_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S: fun(product_prod(A,B),bool),R3: fun(product_prod(A,B),bool)] :
      ( ! [X3: A,Xa1: B] :
          ( pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Xa1)),R3))
        <=> pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Xa1)),S)) )
    <=> ( R3 = S ) ) ).

tff(fact_27_converseE,axiom,
    ! [A: $tType,B: $tType,R2: fun(product_prod(B,A),bool),Yx: product_prod(A,B)] :
      ( pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),Yx),converse(B,A,R2)))
     => ~ ! [X4: B,Y2: A] :
            ( ( Yx = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Y2),X4) )
           => ~ pp(aa(fun(product_prod(B,A),bool),bool,aa(product_prod(B,A),fun(fun(product_prod(B,A),bool),bool),member(product_prod(B,A)),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),X4),Y2)),R2)) ) ) ).

tff(fact_28_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ? [A3: A,B1: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B1))) ) ).

tff(fact_29_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,F11: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F11,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) = aa(C,A,aa(B,fun(C,A),F11,Aa),Ba) ) ).

tff(fact_30_IIA__def,axiom,
    ! [F3: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(F3)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),X3),arrow_610318064e_Prof))
         => ! [Xa1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),Xa1),arrow_610318064e_Prof))
             => ! [A3: arrow_411405190le_alt,B1: arrow_411405190le_alt] :
                  ( ! [I1: arrow_159774573e_indi] :
                      ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B1)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1)))
                    <=> pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B1)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa1,I1))) )
                 => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B1)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),F3,X3)))
                  <=> pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B1)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),F3,Xa1))) ) ) ) ) ) ).

tff(fact_31_unanimity__def,axiom,
    ! [F3: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(F3)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),X3),arrow_610318064e_Prof))
         => ! [A3: arrow_411405190le_alt,B1: arrow_411405190le_alt] :
              ( ! [I1: arrow_159774573e_indi] : pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B1)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I1)))
             => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B1)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),F3,X3))) ) ) ) ).

tff(fact_32_dictator__def,axiom,
    ! [I: arrow_159774573e_indi,F3: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(F3,I)
    <=> ! [X3: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),X3),arrow_610318064e_Prof))
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),F3,X3) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X3,I) ) ) ) ).

tff(fact_33_UNIV__eq__I,axiom,
    ! [A: $tType,A4: fun(A,bool)] :
      ( ! [X4: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A4))
     => ( top_top(fun(A,bool)) = A4 ) ) ).

tff(fact_34_dictatorI,axiom,
    ! [I: arrow_159774573e_indi,F3: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( pp(aa(fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),F3),pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin))))
     => ( ! [X4: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
            ( pp(aa(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool,aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool),bool),member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))),X4),arrow_610318064e_Prof))
           => ! [A5: arrow_411405190le_alt,B3: arrow_411405190le_alt] :
                ( ( A5 != B3 )
               => ( pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A5),B3)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X4,I)))
                 => pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,aa(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A5),B3)),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),F3,X4))) ) ) )
       => arrow_987702531ctator(F3,I) ) ) ).

tff(fact_35_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X4: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),top_top(fun(A,bool)))) ).

tff(fact_36_prod__induct6,axiom,
    ! [F1: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool)] :
      ( ! [A5: A,B3: B,C2: C,D1: D,E1: E,F2: F1] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),A5),aa(product_prod(C,product_prod(D,product_prod(E,F1))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F1))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1)))),B3),aa(product_prod(D,product_prod(E,F1)),product_prod(C,product_prod(D,product_prod(E,F1))),aa(C,fun(product_prod(D,product_prod(E,F1)),product_prod(C,product_prod(D,product_prod(E,F1)))),product_Pair(C,product_prod(D,product_prod(E,F1))),C2),aa(product_prod(E,F1),product_prod(D,product_prod(E,F1)),aa(D,fun(product_prod(E,F1),product_prod(D,product_prod(E,F1))),product_Pair(D,product_prod(E,F1)),D1),aa(F1,product_prod(E,F1),aa(E,fun(F1,product_prod(E,F1)),product_Pair(E,F1),E1),F2)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P1,X1)) ) ).

tff(fact_37_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F1: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))))] :
      ~ ! [A5: A,B3: B,C2: C,D1: D,E1: E,F2: F1] : ( Y != aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),A5),aa(product_prod(C,product_prod(D,product_prod(E,F1))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F1))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1)))),B3),aa(product_prod(D,product_prod(E,F1)),product_prod(C,product_prod(D,product_prod(E,F1))),aa(C,fun(product_prod(D,product_prod(E,F1)),product_prod(C,product_prod(D,product_prod(E,F1)))),product_Pair(C,product_prod(D,product_prod(E,F1))),C2),aa(product_prod(E,F1),product_prod(D,product_prod(E,F1)),aa(D,fun(product_prod(E,F1),product_prod(D,product_prod(E,F1))),product_Pair(D,product_prod(E,F1)),D1),aa(F1,product_prod(E,F1),aa(E,fun(F1,product_prod(E,F1)),product_Pair(E,F1),E1),F2))))) ) ).

tff(fact_38_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A5: A,B3: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A5),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B3),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,X1)) ) ).

tff(fact_39_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A5: A,B3: B,C2: C,D1: D,E1: E] : ( Y != aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A5),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B3),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_40_Pi__UNIV,axiom,
    ! [B: $tType,A: $tType,A4: fun(A,bool)] : ( pi(A,B,A4,combk(fun(B,bool),A,top_top(fun(B,bool)))) = top_top(fun(fun(A,B),bool)) ) ).

tff(fact_41_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A5: A,B3: B,C2: C,D1: D] : ( Y != aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A5),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B3),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1))) ) ).

tff(fact_42_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,D))),P1: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A5: A,B3: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A5),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B3),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,X1)) ) ).

tff(fact_43_PiE,axiom,
    ! [B: $tType,A: $tType,X1: A,B2: fun(A,fun(B,bool)),A4: fun(A,bool),F: fun(A,B)] :
      ( pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A4,B2)))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X1)),aa(A,fun(B,bool),B2,X1)))
       => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A4)) ) ) ).

tff(fact_44_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A5: A,B3: B,C2: C] : ( Y != aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A5),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B3),C2)) ) ).

tff(fact_45_Prof__def,axiom,
    arrow_610318064e_Prof = pi(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),top_top(fun(arrow_159774573e_indi,bool)),combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),arrow_159774573e_indi,arrow_1985332922le_Lin)) ).

tff(fact_46_Pi__mem,axiom,
    ! [B: $tType,A: $tType,X1: A,B2: fun(A,fun(B,bool)),A4: fun(A,bool),F: fun(A,B)] :
      ( pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A4,B2)))
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A4))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X1)),aa(A,fun(B,bool),B2,X1))) ) ) ).

tff(fact_47_funcset__mem,axiom,
    ! [A: $tType,B: $tType,X1: A,B2: fun(B,bool),A4: fun(A,bool),F: fun(A,B)] :
      ( pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A4,combk(fun(B,bool),A,B2))))
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A4))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X1)),B2)) ) ) ).

tff(fact_48_funcset__id,axiom,
    ! [A: $tType,A4: fun(A,bool)] : pp(aa(fun(fun(A,A),bool),bool,aa(fun(A,A),fun(fun(fun(A,A),bool),bool),member(fun(A,A)),combi(A)),pi(A,A,A4,combk(fun(A,bool),A,A4)))) ).

tff(fact_49_Pi__I,axiom,
    ! [B: $tType,A: $tType,B2: fun(A,fun(B,bool)),F: fun(A,B),A4: fun(A,bool)] :
      ( ! [X4: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A4))
         => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X4)),aa(A,fun(B,bool),B2,X4))) )
     => pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A4,B2))) ) ).

tff(fact_50_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,C)),P1: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A5: A,B3: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P1,aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A5),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B3),C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P1,X1)) ) ).

tff(fact_51_funcsetI,axiom,
    ! [A: $tType,B: $tType,B2: fun(B,bool),F: fun(A,B),A4: fun(A,bool)] :
      ( ! [X4: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A4))
         => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X4)),B2)) )
     => pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A4,combk(fun(B,bool),A,B2)))) ) ).

tff(fact_52_Pi__I_H,axiom,
    ! [B: $tType,A: $tType,B2: fun(A,fun(B,bool)),F: fun(A,B),A4: fun(A,bool)] :
      ( ! [X4: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A4))
         => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X4)),aa(A,fun(B,bool),B2,X4))) )
     => pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A4,B2))) ) ).

tff(fact_53_Pi__cong,axiom,
    ! [B: $tType,A: $tType,B2: fun(A,fun(B,bool)),G: fun(A,B),F: fun(A,B),A4: fun(A,bool)] :
      ( ! [W: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),W),A4))
         => ( aa(A,B,F,W) = aa(A,B,G,W) ) )
     => ( pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),pi(A,B,A4,B2)))
      <=> pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),G),pi(A,B,A4,B2))) ) ) ).

tff(fact_54_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A5: A,B3: B] : ( Y != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B3) ) ).

tff(fact_55_PairE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B)] :
      ~ ! [X4: A,Y2: B] : ( P2 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X4),Y2) ) ).

tff(fact_56_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,Ba: C,Aa: B,C1: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,C1,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) = aa(C,A,aa(B,fun(C,A),C1,Aa),Ba) ) ).

tff(fact_57_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ba: C,Aa: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,Aa,Ba) = aa(product_prod(B,C),A,F,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),Ba)) ) ).

tff(fact_58_curry__def,axiom,
    ! [C: $tType,A: $tType,B: $tType,X2: fun(product_prod(A,B),C),Xa: A,Xb: B] : ( product_curry(A,B,C,X2,Xa,Xb) = aa(product_prod(A,B),C,X2,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Xa),Xb)) ) ).

tff(fact_59_curryI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba)))
     => pp(product_curry(A,B,bool,F,Aa,Ba)) ) ).

tff(fact_60_curryE,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba))) ) ).

tff(fact_61_curryD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,Ba))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba))) ) ).

tff(fact_62_Pi__empty,axiom,
    ! [B: $tType,A: $tType,B2: fun(A,fun(B,bool))] : ( pi(A,B,bot_bot(fun(A,bool)),B2) = top_top(fun(fun(A,B),bool)) ) ).

tff(fact_63_total__on__converse,axiom,
    ! [A: $tType,R2: fun(product_prod(A,A),bool),A4: fun(A,bool)] :
      ( total_on(A,A4,converse(A,A,R2))
    <=> total_on(A,A4,R2) ) ).

tff(fact_64_converse__inv__image,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),R3: fun(product_prod(B,B),bool)] : ( converse(A,A,inv_image(B,A,R3,F)) = inv_image(B,A,converse(B,B,R3),F) ) ).

tff(fact_65_emptyE,axiom,
    ! [A: $tType,Aa: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),bot_bot(fun(A,bool)))) ).

tff(fact_66_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X3: A] : ~ pp(aa(A,bool,P1,X3)) ) ).

tff(fact_67_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_68_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X3: A] : ~ pp(aa(A,bool,P1,X3)) ) ).

tff(fact_69_all__not__in__conv,axiom,
    ! [A: $tType,A4: fun(A,bool)] :
      ( ! [X3: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A4))
    <=> ( A4 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_70_in__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(A,B),R2: fun(product_prod(B,B),bool),Y1: A,X1: A] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X1),Y1)),inv_image(B,A,R2,F)))
    <=> pp(aa(fun(product_prod(B,B),bool),bool,aa(product_prod(B,B),fun(fun(product_prod(B,B),bool),bool),member(product_prod(B,B)),aa(B,product_prod(B,B),aa(B,fun(B,product_prod(B,B)),product_Pair(B,B),aa(A,B,F,X1)),aa(A,B,F,Y1))),R2)) ) ).

tff(fact_71_Collect__const,axiom,
    ! [A: $tType,P1: bool] :
      ( ( pp(P1)
       => ( collect(A,combk(bool,A,P1)) = top_top(fun(A,bool)) ) )
      & ( ~ pp(P1)
       => ( collect(A,combk(bool,A,P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_72_Pi__eq__empty,axiom,
    ! [A: $tType,B: $tType,B2: fun(A,fun(B,bool)),A4: fun(A,bool)] :
      ( ( pi(A,B,A4,B2) = bot_bot(fun(fun(A,B),bool)) )
    <=> ? [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A4))
          & ( aa(A,fun(B,bool),B2,X3) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_73_UNIV__not__empty,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) != bot_bot(fun(A,bool)) ) ).

tff(fact_74_equals0D,axiom,
    ! [A: $tType,Aa: A,A4: fun(A,bool)] :
      ( ( A4 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A4)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X4: A] : ( aa(A,B,F,X4) = aa(A,B,G,X4) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A4: fun(A,bool),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A4))
    <=> pp(aa(A,bool,A4,X1)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_ex__in__conv,axiom,
    ! [A: $tType,A4: fun(A,bool)] :
      ( ? [X3: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A4))
    <=> ( A4 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_79_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X1: B] : ( aa(B,A,bot_bot(fun(B,A)),X1) = bot_bot(A) ) ) ).

tff(fact_80_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_81_bot__empty__eq,axiom,
    ! [A: $tType,X2: A] :
      ( pp(aa(A,bool,bot_bot(fun(A,bool)),X2))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),bot_bot(fun(A,bool)))) ) ).

tff(fact_82_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X2: A] : ( aa(A,B,bot_bot(fun(A,B)),X2) = bot_bot(B) ) ) ).

tff(fact_83_total__on__empty,axiom,
    ! [A: $tType,R2: fun(product_prod(A,A),bool)] : total_on(A,bot_bot(fun(A,bool)),R2) ).

tff(fact_84_total__on__def,axiom,
    ! [A: $tType,R2: fun(product_prod(A,A),bool),A4: fun(A,bool)] :
      ( total_on(A,A4,R2)
    <=> ! [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A4))
         => ! [Xa1: A] :
              ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa1),A4))
             => ( ( X3 != Xa1 )
               => ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X3),Xa1)),R2))
                  | pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Xa1),X3)),R2)) ) ) ) ) ) ).

tff(fact_85_equals0I,axiom,
    ! [A: $tType,A4: fun(A,bool)] :
      ( ! [Y2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),A4))
     => ( A4 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_86_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Y1: B,X1: B,F: fun(B,A),R2: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R2,F,X1,Y1)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R2,aa(B,A,F,X1)),aa(B,A,F,Y1))) ) ).

tff(fact_87_conversep__converse__eq,axiom,
    ! [A: $tType,B: $tType,R2: fun(product_prod(B,A),bool),X2: A,Xa: B] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),conversep(B,A,aa(fun(product_prod(B,A),bool),fun(B,fun(A,bool)),aa(fun(B,fun(fun(product_prod(B,A),bool),fun(A,bool))),fun(fun(product_prod(B,A),bool),fun(B,fun(A,bool))),combc(B,fun(product_prod(B,A),bool),fun(A,bool)),aa(fun(B,fun(A,fun(fun(product_prod(B,A),bool),bool))),fun(B,fun(fun(product_prod(B,A),bool),fun(A,bool))),combb(fun(A,fun(fun(product_prod(B,A),bool),bool)),fun(fun(product_prod(B,A),bool),fun(A,bool)),B,combc(A,fun(product_prod(B,A),bool),bool)),aa(fun(B,fun(A,product_prod(B,A))),fun(B,fun(A,fun(fun(product_prod(B,A),bool),bool))),combb(fun(A,product_prod(B,A)),fun(A,fun(fun(product_prod(B,A),bool),bool)),B,combb(product_prod(B,A),fun(fun(product_prod(B,A),bool),bool),A,member(product_prod(B,A)))),product_Pair(B,A)))),R2)),X2),Xa))
    <=> pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Xa)),converse(B,A,R2))) ) ).

tff(fact_88_conversep__eq,axiom,
    ! [A: $tType] : ( conversep(A,A,fequal(A)) = fequal(A) ) ).

tff(fact_89_conversep__iff,axiom,
    ! [A: $tType,B: $tType,Ba: A,Aa: B,R2: fun(A,fun(B,bool))] :
      ( pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R2),Aa),Ba))
    <=> pp(aa(B,bool,aa(A,fun(B,bool),R2,Ba),Aa)) ) ).

tff(fact_90_conversep__noteq,axiom,
    ! [A: $tType,X2: A,Xa: A] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),conversep(A,A,aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combb(fun(A,bool),fun(A,bool),A,combb(bool,bool,A,fNot)),fequal(A))),X2),Xa))
    <=> ( X2 != Xa ) ) ).

tff(fact_91_bot__empty__eq2,axiom,
    ! [B: $tType,A: $tType,X2: A,Xa: B] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),bot_bot(fun(A,fun(B,bool))),X2),Xa))
    <=> pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Xa)),bot_bot(fun(product_prod(A,B),bool)))) ) ).

tff(fact_92_conversep__conversep,axiom,
    ! [B: $tType,A: $tType,R2: fun(A,fun(B,bool))] : ( conversep(B,A,conversep(A,B,R2)) = R2 ) ).

tff(fact_93_conversep_Ointros,axiom,
    ! [B: $tType,A: $tType,Ba: B,Aa: A,R2: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),R2,Aa),Ba))
     => pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R2),Ba),Aa)) ) ).

tff(fact_94_conversepD,axiom,
    ! [A: $tType,B: $tType,Ba: A,Aa: B,R2: fun(A,fun(B,bool))] :
      ( pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R2),Aa),Ba))
     => pp(aa(B,bool,aa(A,fun(B,bool),R2,Ba),Aa)) ) ).

tff(fact_95_inv__imagep__def,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),R2: fun(B,fun(B,bool)),X2: A,Xa: A] :
      ( inv_imagep(B,A,R2,F,X2,Xa)
    <=> pp(aa(B,bool,aa(B,fun(B,bool),R2,aa(A,B,F,X2)),aa(A,B,F,Xa))) ) ).

tff(fact_96_conversep_Osimps,axiom,
    ! [A: $tType,B: $tType,A2: A,A1: B,R2: fun(A,fun(B,bool))] :
      ( pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R2),A1),A2))
    <=> ? [A3: A,B1: B] :
          ( ( A1 = B1 )
          & ( A2 = A3 )
          & pp(aa(B,bool,aa(A,fun(B,bool),R2,A3),B1)) ) ) ).

tff(fact_97_extensional__funcset__empty__range,axiom,
    ! [B: $tType,A: $tType,S: fun(A,bool)] :
      ( ( S != bot_bot(fun(A,bool)) )
     => ( extensional_funcset(A,B,S,bot_bot(fun(B,bool))) = bot_bot(fun(fun(A,B),bool)) ) ) ).

tff(fact_98_bot2E,axiom,
    ! [A: $tType,B: $tType,Y1: B,X1: A] : ~ pp(aa(B,bool,aa(A,fun(B,bool),bot_bot(fun(A,fun(B,bool))),X1),Y1)) ).

tff(fact_99_extensional__funcset__mem,axiom,
    ! [A: $tType,B: $tType,X1: A,T: fun(B,bool),S: fun(A,bool),F: fun(A,B)] :
      ( pp(aa(fun(fun(A,B),bool),bool,aa(fun(A,B),fun(fun(fun(A,B),bool),bool),member(fun(A,B)),F),extensional_funcset(A,B,S,T)))
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),S))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X1)),T)) ) ) ).

%----Arities (4)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R1: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),combb(B,C,A,P),Q),R1) = aa(B,C,P,aa(A,B,Q,R1)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R1: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R1) = aa(B,C,aa(A,fun(B,C),P,R1),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [R: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( pp(aa(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool,aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),fun(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),bool),member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),R),arrow_1985332922le_Lin))
     => thesis ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
