%------------------------------------------------------------------------------
% File     : SCT198_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 145
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_145 [Bla13]

% Status   : Theorem
% Rating   : 0.67 v9.1.0, 0.33 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  126 (  43 unt;  29 typ;   0 def)
%            Number of atoms       :  200 ( 111 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  150 (  47   ~;   2   |;  14   &)
%                                         (  14 <=>;  73  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   36 (  19   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-5 aty)
%            Number of functors    :   23 (  23 usr;   5 con; 0-6 aty)
%            Number of variables   :  590 ( 546   !;   7   ?; 590   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:21
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (25)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,B),bool) * A * B ) > $o ) ).

tff(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B: $tType,C1: $tType,A: $tType] : ( ( fun(B,C1) * fun(A,B) ) > fun(A,C1) ) ).

tff(sy_c_Nitpick_Orefl_H,type,
    refl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,product_prod(A,B))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A: $tType,C1: $tType,B: $tType] : ( ( fun(A,C1) * product_prod(A,B) ) > product_prod(C1,B) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B: $tType,C1: $tType,A: $tType] : ( ( fun(B,C1) * product_prod(A,B) ) > product_prod(A,C1) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C1: $tType] : ( fun(product_prod(A,B),C1) > fun(A,fun(B,C1)) ) ).

tff(sy_c_Product__Type_Ofst,type,
    product_fst: 
      !>[A: $tType,B: $tType] : ( product_prod(A,B) > A ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C1: $tType] : fun(fun(A,fun(B,C1)),fun(product_prod(A,B),C1)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A: $tType,B: $tType,T2: $tType] : fun(fun(A,fun(B,T2)),fun(product_prod(A,B),T2)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T2: $tType] : ( ( fun(A,fun(B,T2)) * product_prod(A,B) ) > T2 ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A: $tType,B: $tType,C1: $tType,D: $tType] : ( ( fun(A,product_prod(B,C1)) * fun(B,fun(C1,D)) ) > fun(A,D) ) ).

tff(sy_c_Product__Type_Osnd,type,
    product_snd: 
      !>[A: $tType,B: $tType] : ( product_prod(A,B) > B ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b,type,
    b: arrow_411405190le_alt ).

%----Relevant facts (94)
tff(fact_0_assms,axiom,
    a != b ).

tff(fact_1_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( ( X1 != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),L)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),X1),L) ) ) ) ).

tff(fact_2_Lin__irrefl,axiom,
    ! [Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Ba),L)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Aa),L) ) ) ).

tff(fact_3_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P,X11))
    <=> ! [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,P,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3))) ) ).

tff(fact_4_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B5: B,A6: A,Ba: B,Aa: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B5) )
    <=> ( ( Aa = A6 )
        & ( Ba = B5 ) ) ) ).

tff(fact_5_in__above,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),arrow_1158827142_above(L,Aa,Ba))
        <=> ( ( X1 != Y1 )
            & ( ( X1 = Ba )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Aa),Y1),L) )
            & ( ( X1 != Ba )
             => ( ( ( Y1 = Ba )
                 => ( ( X1 = Aa )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Aa),L) ) )
                & ( ( Y1 != Ba )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),L) ) ) ) ) ) ) ) ).

tff(fact_6_in__below,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ba: arrow_411405190le_alt,Aa: arrow_411405190le_alt] :
      ( ( Aa != Ba )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),arrow_319942042_below(L,Aa,Ba))
        <=> ( ( X1 != Y1 )
            & ( ( Y1 = Aa )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Ba),L) )
            & ( ( Y1 != Aa )
             => ( ( ( X1 = Aa )
                 => ( ( Y1 = Ba )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ba),Y1),L) ) )
                & ( ( X1 != Aa )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),L) ) ) ) ) ) ) ) ).

tff(fact_7_linear__alt,axiom,
    ? [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin) ).

tff(fact_8_above__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_1158827142_above(L,X1,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_9_below__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_319942042_below(L,X1,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_10_mkbot__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(L,X1),arrow_1985332922le_Lin) ) ).

tff(fact_11_mktop__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(L,X1),arrow_1985332922le_Lin) ) ).

tff(fact_12_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),arrow_276188178_mkbot(L,Z))
    <=> ( ( Y1 != Z )
        & ( ( X1 = Z )
         => ( X1 != Y1 ) )
        & ( ( X1 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),L) ) ) ) ).

tff(fact_13_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),arrow_424895264_mktop(L,Z))
    <=> ( ( X1 != Z )
        & ( ( Y1 = Z )
         => ( X1 != Y1 ) )
        & ( ( Y1 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),L) ) ) ) ).

tff(fact_14_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B4: B,A5: A,B1: B,A1: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B4) )
     => ~ ( ( A1 = A5 )
         => ( B1 != B4 ) ) ) ).

tff(fact_15_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P,X11))
    <=> ? [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,P,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3))) ) ).

tff(fact_16_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Ba: C1,Aa: B,F11: fun(B,fun(C1,A))] : ( product_prod_rec(B,C1,A,F11,aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),Aa),Ba)) = aa(C1,A,aa(B,fun(C1,A),F11,Aa),Ba) ) ).

tff(fact_17_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y2: product_prod(A,B)] :
      ~ ! [A3: A,B2: B] : ( Y2 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) ) ).

tff(fact_18_PairE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B)] :
      ~ ! [X3: A,Y: B] : ( P2 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Y) ) ).

tff(fact_19_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Y2: product_prod(A,product_prod(B,C1))] :
      ~ ! [A3: A,B2: B,C2: C1] : ( Y2 != aa(product_prod(B,C1),product_prod(A,product_prod(B,C1)),aa(A,fun(product_prod(B,C1),product_prod(A,product_prod(B,C1))),product_Pair(A,product_prod(B,C1)),A3),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),B2),C2)) ) ).

tff(fact_20_prod__induct3,axiom,
    ! [C1: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,C1)),P: fun(product_prod(A,product_prod(B,C1)),bool)] :
      ( ! [A3: A,B2: B,C2: C1] : pp(aa(product_prod(A,product_prod(B,C1)),bool,P,aa(product_prod(B,C1),product_prod(A,product_prod(B,C1)),aa(A,fun(product_prod(B,C1),product_prod(A,product_prod(B,C1))),product_Pair(A,product_prod(B,C1)),A3),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),B2),C2))))
     => pp(aa(product_prod(A,product_prod(B,C1)),bool,P,X1)) ) ).

tff(fact_21_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,Y2: product_prod(A,product_prod(B,product_prod(C1,D)))] :
      ~ ! [A3: A,B2: B,C2: C1,D2: D] : ( Y2 != aa(product_prod(B,product_prod(C1,D)),product_prod(A,product_prod(B,product_prod(C1,D))),aa(A,fun(product_prod(B,product_prod(C1,D)),product_prod(A,product_prod(B,product_prod(C1,D)))),product_Pair(A,product_prod(B,product_prod(C1,D))),A3),aa(product_prod(C1,D),product_prod(B,product_prod(C1,D)),aa(B,fun(product_prod(C1,D),product_prod(B,product_prod(C1,D))),product_Pair(B,product_prod(C1,D)),B2),aa(D,product_prod(C1,D),aa(C1,fun(D,product_prod(C1,D)),product_Pair(C1,D),C2),D2))) ) ).

tff(fact_22_prod__induct4,axiom,
    ! [D: $tType,C1: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C1,D))),P: fun(product_prod(A,product_prod(B,product_prod(C1,D))),bool)] :
      ( ! [A3: A,B2: B,C2: C1,D2: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,D))),bool,P,aa(product_prod(B,product_prod(C1,D)),product_prod(A,product_prod(B,product_prod(C1,D))),aa(A,fun(product_prod(B,product_prod(C1,D)),product_prod(A,product_prod(B,product_prod(C1,D)))),product_Pair(A,product_prod(B,product_prod(C1,D))),A3),aa(product_prod(C1,D),product_prod(B,product_prod(C1,D)),aa(B,fun(product_prod(C1,D),product_prod(B,product_prod(C1,D))),product_Pair(B,product_prod(C1,D)),B2),aa(D,product_prod(C1,D),aa(C1,fun(D,product_prod(C1,D)),product_Pair(C1,D),C2),D2)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,D))),bool,P,X1)) ) ).

tff(fact_23_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C1: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),P: fun(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A3: A,B2: B,C2: C1,D2: D,E1: E,F3: F2] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool,P,aa(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2))),aa(C1,fun(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2)))),product_Pair(C1,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D2),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool,P,X1)) ) ).

tff(fact_24_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,E: $tType,F2: $tType,Y2: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A3: A,B2: B,C2: C1,D2: D,E1: E,F3: F2] : ( Y2 != aa(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2))),aa(C1,fun(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2)))),product_Pair(C1,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D2),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_25_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C1: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),P: fun(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),bool)] :
      ( ! [A3: A,B2: B,C2: C1,D2: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),bool,P,aa(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,E)))),A3),aa(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E))),aa(B,fun(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E)))),product_Pair(B,product_prod(C1,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C1,product_prod(D,E)),aa(C1,fun(product_prod(D,E),product_prod(C1,product_prod(D,E))),product_Pair(C1,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D2),E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),bool,P,X1)) ) ).

tff(fact_26_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,E: $tType,Y2: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E))))] :
      ~ ! [A3: A,B2: B,C2: C1,D2: D,E1: E] : ( Y2 != aa(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,E)))),A3),aa(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E))),aa(B,fun(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E)))),product_Pair(B,product_prod(C1,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C1,product_prod(D,E)),aa(C1,fun(product_prod(D,E),product_prod(C1,product_prod(D,E))),product_Pair(C1,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D2),E1)))) ) ).

tff(fact_27_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Ba: C1,Aa: B,C: fun(B,fun(C1,A))] : ( aa(product_prod(B,C1),A,aa(fun(B,fun(C1,A)),fun(product_prod(B,C1),A),produc1605651328_split(B,C1,A),C),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),Aa),Ba)) = aa(C1,A,aa(B,fun(C1,A),C,Aa),Ba) ) ).

tff(fact_28_curry__conv,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Ba: C1,Aa: B,F: fun(product_prod(B,C1),A)] : ( aa(C1,A,aa(B,fun(C1,A),product_curry(B,C1,A,F),Aa),Ba) = aa(product_prod(B,C1),A,F,aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),Aa),Ba)) ) ).

tff(fact_29_curryI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba)))
     => pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),Aa),Ba)) ) ).

tff(fact_30_curryE,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),Aa),Ba))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba))) ) ).

tff(fact_31_curryD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),Aa),Ba))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba))) ) ).

tff(fact_32_internal__split__def,axiom,
    ! [C1: $tType,B: $tType,A: $tType] : ( produc1605651328_split(A,B,C1) = product_prod_case(A,B,C1) ) ).

tff(fact_33_in__rel__def,axiom,
    ! [B: $tType,A: $tType,Y1: B,X1: A,R: fun(product_prod(A,B),bool)] :
      ( in_rel(A,B,R,X1,Y1)
    <=> member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Y1),R) ) ).

tff(fact_34_apsnd__conv,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Y1: C1,X1: A,F: fun(C1,B)] : ( product_apsnd(C1,B,A,F,aa(C1,product_prod(A,C1),aa(A,fun(C1,product_prod(A,C1)),product_Pair(A,C1),X1),Y1)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),aa(C1,B,F,Y1)) ) ).

tff(fact_35_apfst__conv,axiom,
    ! [C1: $tType,A: $tType,B: $tType,Y1: B,X1: C1,F: fun(C1,A)] : ( product_apfst(C1,A,B,F,aa(B,product_prod(C1,B),aa(C1,fun(B,product_prod(C1,B)),product_Pair(C1,B),X1),Y1)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C1,A,F,X1)),Y1) ) ).

tff(fact_36_surj__pair,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B)] :
    ? [X3: A,Y: B] : ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Y) ) ).

tff(fact_37_Nitpick_Orefl_H__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( refl(A,R1)
    <=> ! [X5: A] : member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X5),X5),R1) ) ).

tff(fact_38_splitI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F,Aa),Ba))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba))) ) ).

tff(fact_39_prod__caseI,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F11: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F11,Aa),Ba))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F11),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba))) ) ).

tff(fact_40_mem__splitI,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Ba: C1,Aa: B,C: fun(B,fun(C1,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(C1,fun(A,bool),aa(B,fun(C1,fun(A,bool)),C,Aa),Ba))
     => member(A,Z,aa(product_prod(B,C1),fun(A,bool),aa(fun(B,fun(C1,fun(A,bool))),fun(product_prod(B,C1),fun(A,bool)),product_prod_case(B,C1,fun(A,bool)),C),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),Aa),Ba))) ) ).

tff(fact_41_split__conv,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Ba: C1,Aa: B,F: fun(B,fun(C1,A))] : ( aa(product_prod(B,C1),A,aa(fun(B,fun(C1,A)),fun(product_prod(B,C1),A),product_prod_case(B,C1,A),F),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),Aa),Ba)) = aa(C1,A,aa(B,fun(C1,A),F,Aa),Ba) ) ).

tff(fact_42_apsnd__apfst__commute,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,P1: product_prod(D,C1),G: fun(D,A),F: fun(C1,B)] : ( product_apsnd(C1,B,A,F,product_apfst(D,A,C1,G,P1)) = product_apfst(D,A,B,G,product_apsnd(C1,B,D,F,P1)) ) ).

tff(fact_43_split__weak__cong,axiom,
    ! [C1: $tType,B: $tType,A: $tType,C: fun(A,fun(B,C1)),Q1: product_prod(A,B),P1: product_prod(A,B)] :
      ( ( P1 = Q1 )
     => ( aa(product_prod(A,B),C1,aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),C),P1) = aa(product_prod(A,B),C1,aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),C),Q1) ) ) ).

tff(fact_44_splitD,axiom,
    ! [A: $tType,B: $tType,Ba: B,Aa: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba)))
     => pp(aa(B,bool,aa(A,fun(B,bool),F,Aa),Ba)) ) ).

tff(fact_45_splitD_H,axiom,
    ! [B: $tType,A: $tType,C1: $tType,C: C1,Ba: B,Aa: A,R: fun(A,fun(B,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A,B),fun(C1,bool),aa(fun(A,fun(B,fun(C1,bool))),fun(product_prod(A,B),fun(C1,bool)),product_prod_case(A,B,fun(C1,bool)),R),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),Ba)),C))
     => pp(aa(C1,bool,aa(B,fun(C1,bool),aa(A,fun(B,fun(C1,bool)),R,Aa),Ba),C)) ) ).

tff(fact_46_prod_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Ba: C1,Aa: B,F11: fun(B,fun(C1,A))] : ( aa(product_prod(B,C1),A,aa(fun(B,fun(C1,A)),fun(product_prod(B,C1),A),product_prod_case(B,C1,A),F11),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),Aa),Ba)) = aa(C1,A,aa(B,fun(C1,A),F11,Aa),Ba) ) ).

tff(fact_47_curry__split,axiom,
    ! [C1: $tType,B: $tType,A: $tType,F: fun(A,fun(B,C1))] : ( product_curry(A,B,C1,aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),F)) = F ) ).

tff(fact_48_split__curry,axiom,
    ! [C1: $tType,B: $tType,A: $tType,F: fun(product_prod(A,B),C1)] : ( aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),product_curry(A,B,C1,F)) = F ) ).

tff(fact_49_splitE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B),C: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C),P1))
     => ~ ! [X3: A,Y: B] :
            ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Y) )
           => ~ pp(aa(B,bool,aa(A,fun(B,bool),C,X3),Y)) ) ) ).

tff(fact_50_splitI2,axiom,
    ! [B: $tType,A: $tType,C: fun(A,fun(B,bool)),P1: product_prod(A,B)] :
      ( ! [A3: A,B2: B] :
          ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) )
         => pp(aa(B,bool,aa(A,fun(B,bool),C,A3),B2)) )
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C),P1)) ) ).

tff(fact_51_mem__splitI2,axiom,
    ! [C1: $tType,B: $tType,A: $tType,C: fun(A,fun(B,fun(C1,bool))),Z: C1,P1: product_prod(A,B)] :
      ( ! [A3: A,B2: B] :
          ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) )
         => member(C1,Z,aa(B,fun(C1,bool),aa(A,fun(B,fun(C1,bool)),C,A3),B2)) )
     => member(C1,Z,aa(product_prod(A,B),fun(C1,bool),aa(fun(A,fun(B,fun(C1,bool))),fun(product_prod(A,B),fun(C1,bool)),product_prod_case(A,B,fun(C1,bool)),C),P1)) ) ).

tff(fact_52_splitI2_H,axiom,
    ! [A: $tType,B: $tType,C1: $tType,X1: C1,C: fun(A,fun(B,fun(C1,bool))),P1: product_prod(A,B)] :
      ( ! [A3: A,B2: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) = P1 )
         => pp(aa(C1,bool,aa(B,fun(C1,bool),aa(A,fun(B,fun(C1,bool)),C,A3),B2),X1)) )
     => pp(aa(C1,bool,aa(product_prod(A,B),fun(C1,bool),aa(fun(A,fun(B,fun(C1,bool))),fun(product_prod(A,B),fun(C1,bool)),product_prod_case(A,B,fun(C1,bool)),C),P1),X1)) ) ).

tff(fact_53_mem__splitE,axiom,
    ! [B: $tType,A: $tType,C1: $tType,P1: product_prod(B,C1),C: fun(B,fun(C1,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(product_prod(B,C1),fun(A,bool),aa(fun(B,fun(C1,fun(A,bool))),fun(product_prod(B,C1),fun(A,bool)),product_prod_case(B,C1,fun(A,bool)),C),P1))
     => ~ ! [X3: B,Y: C1] :
            ( ( P1 = aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),X3),Y) )
           => ~ member(A,Z,aa(C1,fun(A,bool),aa(B,fun(C1,fun(A,bool)),C,X3),Y)) ) ) ).

tff(fact_54_splitE_H,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Z: C1,P1: product_prod(A,B),C: fun(A,fun(B,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A,B),fun(C1,bool),aa(fun(A,fun(B,fun(C1,bool))),fun(product_prod(A,B),fun(C1,bool)),product_prod_case(A,B,fun(C1,bool)),C),P1),Z))
     => ~ ! [X3: A,Y: B] :
            ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Y) )
           => ~ pp(aa(C1,bool,aa(B,fun(C1,bool),aa(A,fun(B,fun(C1,bool)),C,X3),Y),Z)) ) ) ).

tff(fact_55_splitE2,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Z: product_prod(B,C1),P: fun(B,fun(C1,A)),Q: fun(A,bool)] :
      ( pp(aa(A,bool,Q,aa(product_prod(B,C1),A,aa(fun(B,fun(C1,A)),fun(product_prod(B,C1),A),product_prod_case(B,C1,A),P),Z)))
     => ~ ! [X3: B,Y: C1] :
            ( ( Z = aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),X3),Y) )
           => ~ pp(aa(A,bool,Q,aa(C1,A,aa(B,fun(C1,A),P,X3),Y))) ) ) ).

tff(fact_56_split__cong,axiom,
    ! [C1: $tType,B: $tType,A: $tType,P1: product_prod(A,B),G: fun(A,fun(B,C1)),F: fun(A,fun(B,C1)),Q1: product_prod(A,B)] :
      ( ! [X3: A,Y: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Y) = Q1 )
         => ( aa(B,C1,aa(A,fun(B,C1),F,X3),Y) = aa(B,C1,aa(A,fun(B,C1),G,X3),Y) ) )
     => ( ( P1 = Q1 )
       => ( aa(product_prod(A,B),C1,aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),F),P1) = aa(product_prod(A,B),C1,aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),G),Q1) ) ) ) ).

tff(fact_57_apfst__convE,axiom,
    ! [C1: $tType,A: $tType,B: $tType,P1: product_prod(C1,B),F: fun(C1,A),Q1: product_prod(A,B)] :
      ( ( Q1 = product_apfst(C1,A,B,F,P1) )
     => ~ ! [X3: C1,Y: B] :
            ( ( P1 = aa(B,product_prod(C1,B),aa(C1,fun(B,product_prod(C1,B)),product_Pair(C1,B),X3),Y) )
           => ( Q1 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C1,A,F,X3)),Y) ) ) ) ).

tff(fact_58_scomp__apply,axiom,
    ! [A: $tType,C1: $tType,D: $tType,B: $tType,X1: B,G: fun(C1,fun(D,A)),F: fun(B,product_prod(C1,D))] : ( aa(B,A,product_scomp(B,C1,D,A,F,G),X1) = aa(product_prod(C1,D),A,aa(fun(C1,fun(D,A)),fun(product_prod(C1,D),A),product_prod_case(C1,D,A),G),aa(B,product_prod(C1,D),F,X1)) ) ).

tff(fact_59_scomp__def,axiom,
    ! [B: $tType,C1: $tType,D: $tType,A: $tType,G: fun(C1,fun(D,B)),F: fun(A,product_prod(C1,D)),X: A] : ( aa(A,B,product_scomp(A,C1,D,B,F,G),X) = aa(product_prod(C1,D),B,aa(fun(C1,fun(D,B)),fun(product_prod(C1,D),B),product_prod_case(C1,D,B),G),aa(A,product_prod(C1,D),F,X)) ) ).

tff(fact_60_apfst__apsnd,axiom,
    ! [A: $tType,B: $tType,D: $tType,C1: $tType,X1: product_prod(C1,D),G: fun(D,B),F: fun(C1,A)] : ( product_apfst(C1,A,B,F,product_apsnd(D,B,C1,G,X1)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C1,A,F,product_fst(C1,D,X1))),aa(D,B,G,product_snd(C1,D,X1))) ) ).

tff(fact_61_apfst__eq__conv,axiom,
    ! [A: $tType,B: $tType,C1: $tType,G: fun(C1,A),X1: product_prod(C1,B),F: fun(C1,A)] :
      ( ( product_apfst(C1,A,B,F,X1) = product_apfst(C1,A,B,G,X1) )
    <=> ( aa(C1,A,F,product_fst(C1,B,X1)) = aa(C1,A,G,product_fst(C1,B,X1)) ) ) ).

tff(fact_62_fst__apfst,axiom,
    ! [A: $tType,B: $tType,C1: $tType,X1: product_prod(C1,B),F: fun(C1,A)] : ( product_fst(A,B,product_apfst(C1,A,B,F,X1)) = aa(C1,A,F,product_fst(C1,B,X1)) ) ).

tff(fact_63_fst__apsnd,axiom,
    ! [B: $tType,C1: $tType,A: $tType,X1: product_prod(A,C1),F: fun(C1,B)] : ( product_fst(A,B,product_apsnd(C1,B,A,F,X1)) = product_fst(A,C1,X1) ) ).

tff(fact_64_apsnd__eq__conv,axiom,
    ! [B: $tType,C1: $tType,A: $tType,G: fun(C1,B),X1: product_prod(A,C1),F: fun(C1,B)] :
      ( ( product_apsnd(C1,B,A,F,X1) = product_apsnd(C1,B,A,G,X1) )
    <=> ( aa(C1,B,F,product_snd(A,C1,X1)) = aa(C1,B,G,product_snd(A,C1,X1)) ) ) ).

tff(fact_65_snd__apsnd,axiom,
    ! [A: $tType,C1: $tType,B: $tType,X1: product_prod(B,C1),F: fun(C1,A)] : ( product_snd(B,A,product_apsnd(C1,A,B,F,X1)) = aa(C1,A,F,product_snd(B,C1,X1)) ) ).

tff(fact_66_snd__apfst,axiom,
    ! [B: $tType,A: $tType,C1: $tType,X1: product_prod(C1,A),F: fun(C1,B)] : ( product_snd(B,A,product_apfst(C1,B,A,F,X1)) = product_snd(C1,A,X1) ) ).

tff(fact_67_apsnd__apfst,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,X1: product_prod(D,C1),G: fun(D,A),F: fun(C1,B)] : ( product_apsnd(C1,B,A,F,product_apfst(D,A,C1,G,X1)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(D,A,G,product_fst(D,C1,X1))),aa(C1,B,F,product_snd(D,C1,X1))) ) ).

tff(fact_68_prod__eqI,axiom,
    ! [B: $tType,A: $tType,Q2: product_prod(A,B),P2: product_prod(A,B)] :
      ( ( product_fst(A,B,P2) = product_fst(A,B,Q2) )
     => ( ( product_snd(A,B,P2) = product_snd(A,B,Q2) )
       => ( P2 = Q2 ) ) ) ).

tff(fact_69_prod__eq__iff,axiom,
    ! [B: $tType,A: $tType,T1: product_prod(A,B),S: product_prod(A,B)] :
      ( ( S = T1 )
    <=> ( ( product_fst(A,B,S) = product_fst(A,B,T1) )
        & ( product_snd(A,B,S) = product_snd(A,B,T1) ) ) ) ).

tff(fact_70_pair__collapse,axiom,
    ! [B: $tType,A: $tType,P2: product_prod(A,B)] : ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),product_fst(A,B,P2)),product_snd(A,B,P2)) = P2 ) ).

tff(fact_71_surjective__pairing,axiom,
    ! [B: $tType,A: $tType,T: product_prod(A,B)] : ( T = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),product_fst(A,B,T)),product_snd(A,B,T)) ) ).

tff(fact_72_snd__conv,axiom,
    ! [B: $tType,A: $tType,B1: A,A1: B] : ( product_snd(B,A,aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),A1),B1)) = B1 ) ).

tff(fact_73_snd__eqD,axiom,
    ! [B: $tType,A: $tType,A1: A,Y2: A,X4: B] :
      ( ( product_snd(B,A,aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),X4),Y2)) = A1 )
     => ( Y2 = A1 ) ) ).

tff(fact_74_fst__conv,axiom,
    ! [B: $tType,A: $tType,B1: B,A1: A] : ( product_fst(A,B,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1)) = A1 ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X1: A] :
      ( member(A,X1,A2)
    <=> pp(aa(A,bool,A2,X1)) ) ).

tff(fact_77_fst__eqD,axiom,
    ! [B: $tType,A: $tType,A1: A,Y2: B,X4: A] :
      ( ( product_fst(A,B,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X4),Y2)) = A1 )
     => ( X4 = A1 ) ) ).

tff(fact_78_prod__case__beta,axiom,
    ! [A: $tType,C1: $tType,B: $tType,P1: product_prod(B,C1),F: fun(B,fun(C1,A))] : ( aa(product_prod(B,C1),A,aa(fun(B,fun(C1,A)),fun(product_prod(B,C1),A),product_prod_case(B,C1,A),F),P1) = aa(C1,A,aa(B,fun(C1,A),F,product_fst(B,C1,P1)),product_snd(B,C1,P1)) ) ).

tff(fact_79_scomp__Pair,axiom,
    ! [C1: $tType,B: $tType,A: $tType,X1: fun(A,product_prod(B,C1))] : ( product_scomp(A,B,C1,product_prod(B,C1),X1,product_Pair(B,C1)) = X1 ) ).

tff(fact_80_Pair__scomp,axiom,
    ! [A: $tType,B: $tType,C1: $tType,F: fun(C1,fun(A,B)),X1: C1] : ( product_scomp(A,C1,A,B,aa(C1,fun(A,product_prod(C1,A)),product_Pair(C1,A),X1),F) = aa(C1,fun(A,B),F,X1) ) ).

tff(fact_81_exI__realizer,axiom,
    ! [B: $tType,A: $tType,X1: B,Y1: A,P: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),P,Y1),X1))
     => pp(aa(B,bool,aa(A,fun(B,bool),P,product_snd(B,A,aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),X1),Y1))),product_fst(B,A,aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),X1),Y1)))) ) ).

tff(fact_82_conjI__realizer,axiom,
    ! [A: $tType,B: $tType,Q1: B,Q: fun(B,bool),P1: A,P: fun(A,bool)] :
      ( pp(aa(A,bool,P,P1))
     => ( pp(aa(B,bool,Q,Q1))
       => ( pp(aa(A,bool,P,product_fst(A,B,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),P1),Q1))))
          & pp(aa(B,bool,Q,product_snd(A,B,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),P1),Q1)))) ) ) ) ).

tff(fact_83_exE__realizer_H,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(B,A),P: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),P,product_snd(B,A,P1)),product_fst(B,A,P1)))
     => ~ ! [X3: B,Y: A] : ~ pp(aa(B,bool,aa(A,fun(B,bool),P,Y),X3)) ) ).

tff(fact_84_split__comp,axiom,
    ! [D: $tType,A: $tType,C1: $tType,B: $tType,X1: product_prod(B,C1),G: fun(B,D),F: fun(D,fun(C1,A))] : ( aa(product_prod(B,C1),A,aa(fun(B,fun(C1,A)),fun(product_prod(B,C1),A),product_prod_case(B,C1,A),comp(D,fun(C1,A),B,F,G)),X1) = aa(C1,A,aa(D,fun(C1,A),F,aa(B,D,G,product_fst(B,C1,X1))),product_snd(B,C1,X1)) ) ).

tff(fact_85_comp__cong,axiom,
    ! [C1: $tType,B: $tType,D: $tType,A: $tType,E: $tType,X2: E,G1: fun(E,D),F1: fun(D,A),X1: C1,G: fun(C1,B),F: fun(B,A)] :
      ( ( aa(B,A,F,aa(C1,B,G,X1)) = aa(D,A,F1,aa(E,D,G1,X2)) )
     => ( aa(C1,A,comp(B,A,C1,F,G),X1) = aa(E,A,comp(D,A,E,F1,G1),X2) ) ) ).

tff(fact_86_apfst__compose,axiom,
    ! [C1: $tType,A: $tType,B: $tType,D: $tType,X1: product_prod(D,B),G: fun(D,C1),F: fun(C1,A)] : ( product_apfst(C1,A,B,F,product_apfst(D,C1,B,G,X1)) = product_apfst(D,A,B,comp(C1,A,D,F,G),X1) ) ).

tff(fact_87_apsnd__compose,axiom,
    ! [C1: $tType,B: $tType,D: $tType,A: $tType,X1: product_prod(A,D),G: fun(D,C1),F: fun(C1,B)] : ( product_apsnd(C1,B,A,F,product_apsnd(D,C1,A,G,X1)) = product_apsnd(D,B,A,comp(C1,B,D,F,G),X1) ) ).

tff(fact_88_o__apply,axiom,
    ! [A: $tType,B: $tType,C1: $tType,X1: C1,G: fun(C1,B),F: fun(B,A)] : ( aa(C1,A,comp(B,A,C1,F,G),X1) = aa(B,A,F,aa(C1,B,G,X1)) ) ).

tff(fact_89_o__def,axiom,
    ! [B: $tType,C1: $tType,A: $tType,G: fun(A,C1),F: fun(C1,B),X: A] : ( aa(A,B,comp(C1,B,A,F,G),X) = aa(C1,B,F,aa(A,C1,G,X)) ) ).

tff(fact_90_o__eq__elim,axiom,
    ! [C1: $tType,B: $tType,D: $tType,A: $tType,D1: fun(A,D),C: fun(D,B),Ba: fun(A,C1),Aa: fun(C1,B)] :
      ( ( comp(C1,B,A,Aa,Ba) = comp(D,B,A,C,D1) )
     => ! [V1: A] : ( aa(C1,B,Aa,aa(A,C1,Ba,V1)) = aa(D,B,C,aa(A,D,D1,V1)) ) ) ).

tff(fact_91_o__eq__dest,axiom,
    ! [C1: $tType,B: $tType,D: $tType,A: $tType,V: A,D1: fun(A,D),C: fun(D,B),Ba: fun(A,C1),Aa: fun(C1,B)] :
      ( ( comp(C1,B,A,Aa,Ba) = comp(D,B,A,C,D1) )
     => ( aa(C1,B,Aa,aa(A,C1,Ba,V)) = aa(D,B,C,aa(A,D,D1,V)) ) ) ).

tff(fact_92_o__assoc,axiom,
    ! [C1: $tType,B: $tType,D: $tType,A: $tType,H: fun(A,D),G: fun(D,C1),F: fun(C1,B)] : ( comp(C1,B,A,F,comp(D,C1,A,G,H)) = comp(D,B,A,comp(C1,B,D,F,G),H) ) ).

tff(fact_93_o__eq__dest__lhs,axiom,
    ! [C1: $tType,B: $tType,A: $tType,V: A,C: fun(A,B),Ba: fun(A,C1),Aa: fun(C1,B)] :
      ( ( comp(C1,B,A,Aa,Ba) = C )
     => ( aa(C1,B,Aa,aa(A,C1,Ba,V)) = aa(A,B,C,V) ) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ? [X: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X,arrow_1985332922le_Lin)
      & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),a),b),X) ) ).

%------------------------------------------------------------------------------
