%------------------------------------------------------------------------------
% File     : SCT195_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 137
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_137 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.33 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  114 (  27 unt;  35 typ;   0 def)
%            Number of atoms       :  198 (  76 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  170 (  51   ~;   6   |;  18   &)
%                                         (  16 <=>;  79  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   42 (  22   >;  20   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-5 aty)
%            Number of functors    :   25 (  25 usr;   7 con; 0-6 aty)
%            Number of variables   :  467 ( 424   !;   6   ?; 467   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:35
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (30)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A2: $tType,B1: $tType] : ( ( fun(product_prod(A2,B1),bool) * A2 * B1 ) > $o ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A2: $tType] : ( ( fun(A2,bool) * fun(product_prod(A2,A2),bool) ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A2: $tType,B1: $tType] : fun(A2,fun(B1,product_prod(A2,B1))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A2: $tType,C: $tType,B1: $tType] : ( ( fun(A2,C) * product_prod(A2,B1) ) > product_prod(C,B1) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B1: $tType,C: $tType,A2: $tType] : ( ( fun(B1,C) * product_prod(A2,B1) ) > product_prod(A2,C) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A2: $tType,B1: $tType,C: $tType] : ( fun(product_prod(A2,B1),C) > fun(A2,fun(B1,C)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A2: $tType,B1: $tType,C: $tType] : fun(fun(A2,fun(B1,C)),fun(product_prod(A2,B1),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A2: $tType,B1: $tType,T: $tType] : fun(fun(A2,fun(B1,T)),fun(product_prod(A2,B1),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A2: $tType,B1: $tType,T: $tType] : ( ( fun(A2,fun(B1,T)) * product_prod(A2,B1) ) > T ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A2: $tType,B1: $tType,C: $tType,D: $tType] : ( ( fun(A2,product_prod(B1,C)) * fun(B1,fun(C,D)) ) > fun(A2,D) ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B1: $tType,A2: $tType] : ( ( fun(product_prod(B1,B1),bool) * fun(A2,B1) ) > fun(product_prod(A2,A2),bool) ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A2: $tType] : ( fun(product_prod(A2,A2),bool) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A2: $tType] : ( ( fun(A2,bool) * fun(product_prod(A2,A2),bool) ) > $o ) ).

tff(sy_c_Relation_Otrans,type,
    trans: 
      !>[A2: $tType] : ( fun(product_prod(A2,A2),bool) > $o ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A2: $tType,B1: $tType] : ( ( fun(product_prod(A2,A2),bool) * fun(product_prod(B1,B1),bool) ) > fun(product_prod(product_prod(A2,B1),product_prod(A2,B1)),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A2: $tType,B1: $tType] : ( ( fun(A2,B1) * A2 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A2: $tType] : ( ( A2 * fun(A2,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_P,type,
    p: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_a,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b,type,
    b: arrow_411405190le_alt ).

tff(sy_v_i,type,
    i: arrow_159774573e_indi ).

%----Relevant facts (72)
tff(fact_0_split__paired__All,axiom,
    ! [A2: $tType,B1: $tType,P1: fun(product_prod(A2,B1),bool)] :
      ( ! [X11: product_prod(A2,B1)] : pp(aa(product_prod(A2,B1),bool,P1,X11))
    <=> ! [A6: A2,B5: B1] : pp(aa(product_prod(A2,B1),bool,P1,aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A6),B5))) ) ).

tff(fact_1_Pair__eq,axiom,
    ! [A2: $tType,B1: $tType,B4: B1,A5: A2,B3: B1,A4: A2] :
      ( ( aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A4),B3) = aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A5),B4) )
    <=> ( ( A4 = A5 )
        & ( B3 = B4 ) ) ) ).

tff(fact_2_trans__def,axiom,
    ! [A2: $tType,R: fun(product_prod(A2,A2),bool)] :
      ( trans(A2,R)
    <=> ! [X3: A2,Y4: A2,Z2: A2] :
          ( member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),X3),Y4),R)
         => ( member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),Y4),Z2),R)
           => member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),X3),Z2),R) ) ) ) ).

tff(fact_3_transD,axiom,
    ! [A2: $tType,C1: A2,B3: A2,A4: A2,R: fun(product_prod(A2,A2),bool)] :
      ( trans(A2,R)
     => ( member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),A4),B3),R)
       => ( member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),B3),C1),R)
         => member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),A4),C1),R) ) ) ) ).

tff(fact_4_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y2),arrow_276188178_mkbot(L,Z))
    <=> ( ( Y2 != Z )
        & ( ( X1 = Z )
         => ( X1 != Y2 ) )
        & ( ( X1 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y2),L) ) ) ) ).

tff(fact_5_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y2),arrow_424895264_mktop(L,Z))
    <=> ( ( X1 != Z )
        & ( ( Y2 = Z )
         => ( X1 != Y2 ) )
        & ( ( Y2 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y2),L) ) ) ) ).

tff(fact_6_transI,axiom,
    ! [A2: $tType,R: fun(product_prod(A2,A2),bool)] :
      ( ! [X2: A2,Y1: A2,Z1: A2] :
          ( member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),X2),Y1),R)
         => ( member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),Y1),Z1),R)
           => member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),X2),Z1),R) ) )
     => trans(A2,R) ) ).

tff(fact_7_Pair__inject,axiom,
    ! [A2: $tType,B1: $tType,B7: B1,A8: A2,B6: B1,A7: A2] :
      ( ( aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A7),B6) = aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A8),B7) )
     => ~ ( ( A7 = A8 )
         => ( B6 != B7 ) ) ) ).

tff(fact_8_trans__lex__prod,axiom,
    ! [A2: $tType,B1: $tType,R2: fun(product_prod(B1,B1),bool),R11: fun(product_prod(A2,A2),bool)] :
      ( trans(A2,R11)
     => ( trans(B1,R2)
       => trans(product_prod(A2,B1),lex_prod(A2,B1,R11,R2)) ) ) ).

tff(fact_9_in__rel__def,axiom,
    ! [B1: $tType,A2: $tType,Y2: B1,X1: A2,R1: fun(product_prod(A2,B1),bool)] :
      ( in_rel(A2,B1,R1,X1,Y2)
    <=> member(product_prod(A2,B1),aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),X1),Y2),R1) ) ).

tff(fact_10_split__paired__Ex,axiom,
    ! [A2: $tType,B1: $tType,P1: fun(product_prod(A2,B1),bool)] :
      ( ? [X11: product_prod(A2,B1)] : pp(aa(product_prod(A2,B1),bool,P1,X11))
    <=> ? [A6: A2,B5: B1] : pp(aa(product_prod(A2,B1),bool,P1,aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A6),B5))) ) ).

tff(fact_11_notin__Lin__iff,axiom,
    ! [Y2: arrow_411405190le_alt,X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( ( X1 != Y2 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y2),L)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y2),X1),L) ) ) ) ).

tff(fact_12_in__lex__prod,axiom,
    ! [A2: $tType,B1: $tType,S: fun(product_prod(B1,B1),bool),R: fun(product_prod(A2,A2),bool),B4: B1,A5: A2,B3: B1,A4: A2] :
      ( member(product_prod(product_prod(A2,B1),product_prod(A2,B1)),aa(product_prod(A2,B1),product_prod(product_prod(A2,B1),product_prod(A2,B1)),aa(product_prod(A2,B1),fun(product_prod(A2,B1),product_prod(product_prod(A2,B1),product_prod(A2,B1))),product_Pair(product_prod(A2,B1),product_prod(A2,B1)),aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A4),B3)),aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A5),B4)),lex_prod(A2,B1,R,S))
    <=> ( member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),A4),A5),R)
        | ( ( A4 = A5 )
          & member(product_prod(B1,B1),aa(B1,product_prod(B1,B1),aa(B1,fun(B1,product_prod(B1,B1)),product_Pair(B1,B1),B3),B4),S) ) ) ) ).

tff(fact_13_mkbot__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(L,X1),arrow_1985332922le_Lin) ) ).

tff(fact_14_mktop__Lin,axiom,
    ! [X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(L,X1),arrow_1985332922le_Lin) ) ).

tff(fact_15_Lin__irrefl,axiom,
    ! [B3: arrow_411405190le_alt,A4: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B3),L)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B3),A4),L) ) ) ).

tff(fact_16_in__below,axiom,
    ! [Y2: arrow_411405190le_alt,X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B3: arrow_411405190le_alt,A4: arrow_411405190le_alt] :
      ( ( A4 != B3 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y2),arrow_319942042_below(L,A4,B3))
        <=> ( ( X1 != Y2 )
            & ( ( Y2 = A4 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),B3),L) )
            & ( ( Y2 != A4 )
             => ( ( ( X1 = A4 )
                 => ( ( Y2 = B3 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B3),Y2),L) ) )
                & ( ( X1 != A4 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y2),L) ) ) ) ) ) ) ) ).

tff(fact_17_in__above,axiom,
    ! [Y2: arrow_411405190le_alt,X1: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B3: arrow_411405190le_alt,A4: arrow_411405190le_alt] :
      ( ( A4 != B3 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y2),arrow_1158827142_above(L,A4,B3))
        <=> ( ( X1 != Y2 )
            & ( ( X1 = B3 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),Y2),L) )
            & ( ( X1 != B3 )
             => ( ( ( Y2 = B3 )
                 => ( ( X1 = A4 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),A4),L) ) )
                & ( ( Y2 != B3 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y2),L) ) ) ) ) ) ) ) ).

tff(fact_18_prod_Orecs,axiom,
    ! [B1: $tType,A2: $tType,C: $tType,B3: C,A4: B1,F1: fun(B1,fun(C,A2))] : ( product_prod_rec(B1,C,A2,F1,aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3)) = aa(C,A2,aa(B1,fun(C,A2),F1,A4),B3) ) ).

tff(fact_19_linear__alt,axiom,
    ? [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin) ).

tff(fact_20_above__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y2 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_1158827142_above(L,X1,Y2),arrow_1985332922le_Lin) ) ) ).

tff(fact_21_below__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X1: arrow_411405190le_alt] :
      ( ( X1 != Y2 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_319942042_below(L,X1,Y2),arrow_1985332922le_Lin) ) ) ).

tff(fact_22_prod_Oexhaust,axiom,
    ! [A2: $tType,B1: $tType,Y3: product_prod(A2,B1)] :
      ~ ! [A3: A2,B2: B1] : ( Y3 != aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A3),B2) ) ).

tff(fact_23_PairE,axiom,
    ! [A2: $tType,B1: $tType,P2: product_prod(A2,B1)] :
      ~ ! [X2: A2,Y1: B1] : ( P2 != aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),X2),Y1) ) ).

tff(fact_24_prod__cases3,axiom,
    ! [A2: $tType,B1: $tType,C: $tType,Y3: product_prod(A2,product_prod(B1,C))] :
      ~ ! [A3: A2,B2: B1,C2: C] : ( Y3 != aa(product_prod(B1,C),product_prod(A2,product_prod(B1,C)),aa(A2,fun(product_prod(B1,C),product_prod(A2,product_prod(B1,C))),product_Pair(A2,product_prod(B1,C)),A3),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),B2),C2)) ) ).

tff(fact_25_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B1: $tType,A2: $tType,X1: product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),P1: fun(product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A3: A2,B2: B1,C2: C,D1: D,E1: E,F3: F2] : pp(aa(product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,aa(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A2,fun(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B1,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,X1)) ) ).

tff(fact_26_prod__cases6,axiom,
    ! [A2: $tType,B1: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y3: product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A3: A2,B2: B1,C2: C,D1: D,E1: E,F3: F2] : ( Y3 != aa(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A2,fun(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A2,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B1,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_27_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B1: $tType,A2: $tType,X1: product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A3: A2,B2: B1,C2: C,D1: D,E1: E] : pp(aa(product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,E)))),bool,P1,aa(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,E)))),aa(A2,fun(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,E))))),product_Pair(A2,product_prod(B1,product_prod(C,product_prod(D,E)))),A3),aa(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E))),aa(B1,fun(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E)))),product_Pair(B1,product_prod(C,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,E)))),bool,P1,X1)) ) ).

tff(fact_28_prod__cases5,axiom,
    ! [A2: $tType,B1: $tType,C: $tType,D: $tType,E: $tType,Y3: product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,E))))] :
      ~ ! [A3: A2,B2: B1,C2: C,D1: D,E1: E] : ( Y3 != aa(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,E)))),aa(A2,fun(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A2,product_prod(B1,product_prod(C,product_prod(D,E))))),product_Pair(A2,product_prod(B1,product_prod(C,product_prod(D,E)))),A3),aa(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E))),aa(B1,fun(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E)))),product_Pair(B1,product_prod(C,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_29_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B1: $tType,A2: $tType,X1: product_prod(A2,product_prod(B1,product_prod(C,D))),P1: fun(product_prod(A2,product_prod(B1,product_prod(C,D))),bool)] :
      ( ! [A3: A2,B2: B1,C2: C,D1: D] : pp(aa(product_prod(A2,product_prod(B1,product_prod(C,D))),bool,P1,aa(product_prod(B1,product_prod(C,D)),product_prod(A2,product_prod(B1,product_prod(C,D))),aa(A2,fun(product_prod(B1,product_prod(C,D)),product_prod(A2,product_prod(B1,product_prod(C,D)))),product_Pair(A2,product_prod(B1,product_prod(C,D))),A3),aa(product_prod(C,D),product_prod(B1,product_prod(C,D)),aa(B1,fun(product_prod(C,D),product_prod(B1,product_prod(C,D))),product_Pair(B1,product_prod(C,D)),B2),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1)))))
     => pp(aa(product_prod(A2,product_prod(B1,product_prod(C,D))),bool,P1,X1)) ) ).

tff(fact_30_prod__cases4,axiom,
    ! [A2: $tType,B1: $tType,C: $tType,D: $tType,Y3: product_prod(A2,product_prod(B1,product_prod(C,D)))] :
      ~ ! [A3: A2,B2: B1,C2: C,D1: D] : ( Y3 != aa(product_prod(B1,product_prod(C,D)),product_prod(A2,product_prod(B1,product_prod(C,D))),aa(A2,fun(product_prod(B1,product_prod(C,D)),product_prod(A2,product_prod(B1,product_prod(C,D)))),product_Pair(A2,product_prod(B1,product_prod(C,D))),A3),aa(product_prod(C,D),product_prod(B1,product_prod(C,D)),aa(B1,fun(product_prod(C,D),product_prod(B1,product_prod(C,D))),product_Pair(B1,product_prod(C,D)),B2),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1))) ) ).

tff(fact_31_prod__induct3,axiom,
    ! [C: $tType,B1: $tType,A2: $tType,X1: product_prod(A2,product_prod(B1,C)),P1: fun(product_prod(A2,product_prod(B1,C)),bool)] :
      ( ! [A3: A2,B2: B1,C2: C] : pp(aa(product_prod(A2,product_prod(B1,C)),bool,P1,aa(product_prod(B1,C),product_prod(A2,product_prod(B1,C)),aa(A2,fun(product_prod(B1,C),product_prod(A2,product_prod(B1,C))),product_Pair(A2,product_prod(B1,C)),A3),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),B2),C2))))
     => pp(aa(product_prod(A2,product_prod(B1,C)),bool,P1,X1)) ) ).

tff(fact_32_internal__split__conv,axiom,
    ! [B1: $tType,A2: $tType,C: $tType,B3: C,A4: B1,C1: fun(B1,fun(C,A2))] : ( aa(product_prod(B1,C),A2,aa(fun(B1,fun(C,A2)),fun(product_prod(B1,C),A2),produc1605651328_split(B1,C,A2),C1),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3)) = aa(C,A2,aa(B1,fun(C,A2),C1,A4),B3) ) ).

tff(fact_33_curry__conv,axiom,
    ! [A2: $tType,B1: $tType,C: $tType,B3: C,A4: B1,F: fun(product_prod(B1,C),A2)] : ( aa(C,A2,aa(B1,fun(C,A2),product_curry(B1,C,A2,F),A4),B3) = aa(product_prod(B1,C),A2,F,aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3)) ) ).

tff(fact_34_curryI,axiom,
    ! [A2: $tType,B1: $tType,B3: B1,A4: A2,F: fun(product_prod(A2,B1),bool)] :
      ( pp(aa(product_prod(A2,B1),bool,F,aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A4),B3)))
     => pp(aa(B1,bool,aa(A2,fun(B1,bool),product_curry(A2,B1,bool,F),A4),B3)) ) ).

tff(fact_35_irrefl__def,axiom,
    ! [A2: $tType,R: fun(product_prod(A2,A2),bool)] :
      ( irrefl(A2,R)
    <=> ! [X3: A2] : ~ member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),X3),X3),R) ) ).

tff(fact_36_in__inv__image,axiom,
    ! [A2: $tType,B1: $tType,F: fun(A2,B1),R: fun(product_prod(B1,B1),bool),Y2: A2,X1: A2] :
      ( member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),X1),Y2),inv_image(B1,A2,R,F))
    <=> member(product_prod(B1,B1),aa(B1,product_prod(B1,B1),aa(B1,fun(B1,product_prod(B1,B1)),product_Pair(B1,B1),aa(A2,B1,F,X1)),aa(A2,B1,F,Y2)),R) ) ).

tff(fact_37_trans__inv__image,axiom,
    ! [A2: $tType,B1: $tType,F: fun(B1,A2),R: fun(product_prod(A2,A2),bool)] :
      ( trans(A2,R)
     => trans(B1,inv_image(A2,B1,R,F)) ) ).

tff(fact_38_curryD,axiom,
    ! [A2: $tType,B1: $tType,B3: B1,A4: A2,F: fun(product_prod(A2,B1),bool)] :
      ( pp(aa(B1,bool,aa(A2,fun(B1,bool),product_curry(A2,B1,bool,F),A4),B3))
     => pp(aa(product_prod(A2,B1),bool,F,aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A4),B3))) ) ).

tff(fact_39_curryE,axiom,
    ! [A2: $tType,B1: $tType,B3: B1,A4: A2,F: fun(product_prod(A2,B1),bool)] :
      ( pp(aa(B1,bool,aa(A2,fun(B1,bool),product_curry(A2,B1,bool,F),A4),B3))
     => pp(aa(product_prod(A2,B1),bool,F,aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A4),B3))) ) ).

tff(fact_40_internal__split__def,axiom,
    ! [C: $tType,B1: $tType,A2: $tType] : ( produc1605651328_split(A2,B1,C) = product_prod_case(A2,B1,C) ) ).

tff(fact_41_apsnd__conv,axiom,
    ! [A2: $tType,B1: $tType,C: $tType,Y2: C,X1: A2,F: fun(C,B1)] : ( product_apsnd(C,B1,A2,F,aa(C,product_prod(A2,C),aa(A2,fun(C,product_prod(A2,C)),product_Pair(A2,C),X1),Y2)) = aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),X1),aa(C,B1,F,Y2)) ) ).

tff(fact_42_strict__linear__order__on__def,axiom,
    ! [A2: $tType,R: fun(product_prod(A2,A2),bool),A1: fun(A2,bool)] :
      ( order_215145569der_on(A2,A1,R)
    <=> ( trans(A2,R)
        & irrefl(A2,R)
        & total_on(A2,A1,R) ) ) ).

tff(fact_43_apfst__conv,axiom,
    ! [C: $tType,A2: $tType,B1: $tType,Y2: B1,X1: C,F: fun(C,A2)] : ( product_apfst(C,A2,B1,F,aa(B1,product_prod(C,B1),aa(C,fun(B1,product_prod(C,B1)),product_Pair(C,B1),X1),Y2)) = aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),aa(C,A2,F,X1)),Y2) ) ).

tff(fact_44_surj__pair,axiom,
    ! [A2: $tType,B1: $tType,P2: product_prod(A2,B1)] :
    ? [X2: A2,Y1: B1] : ( P2 = aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),X2),Y1) ) ).

tff(fact_45_prod__caseI,axiom,
    ! [A2: $tType,B1: $tType,B3: B1,A4: A2,F1: fun(A2,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A2,fun(B1,bool),F1,A4),B3))
     => pp(aa(product_prod(A2,B1),bool,aa(fun(A2,fun(B1,bool)),fun(product_prod(A2,B1),bool),product_prod_case(A2,B1,bool),F1),aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A4),B3))) ) ).

tff(fact_46_splitI,axiom,
    ! [A2: $tType,B1: $tType,B3: B1,A4: A2,F: fun(A2,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A2,fun(B1,bool),F,A4),B3))
     => pp(aa(product_prod(A2,B1),bool,aa(fun(A2,fun(B1,bool)),fun(product_prod(A2,B1),bool),product_prod_case(A2,B1,bool),F),aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A4),B3))) ) ).

tff(fact_47_mem__splitI,axiom,
    ! [A2: $tType,B1: $tType,C: $tType,B3: C,A4: B1,C1: fun(B1,fun(C,fun(A2,bool))),Z: A2] :
      ( member(A2,Z,aa(C,fun(A2,bool),aa(B1,fun(C,fun(A2,bool)),C1,A4),B3))
     => member(A2,Z,aa(product_prod(B1,C),fun(A2,bool),aa(fun(B1,fun(C,fun(A2,bool))),fun(product_prod(B1,C),fun(A2,bool)),product_prod_case(B1,C,fun(A2,bool)),C1),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3))) ) ).

tff(fact_48_split__conv,axiom,
    ! [B1: $tType,A2: $tType,C: $tType,B3: C,A4: B1,F: fun(B1,fun(C,A2))] : ( aa(product_prod(B1,C),A2,aa(fun(B1,fun(C,A2)),fun(product_prod(B1,C),A2),product_prod_case(B1,C,A2),F),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3)) = aa(C,A2,aa(B1,fun(C,A2),F,A4),B3) ) ).

tff(fact_49_splitD,axiom,
    ! [A2: $tType,B1: $tType,B3: B1,A4: A2,F: fun(A2,fun(B1,bool))] :
      ( pp(aa(product_prod(A2,B1),bool,aa(fun(A2,fun(B1,bool)),fun(product_prod(A2,B1),bool),product_prod_case(A2,B1,bool),F),aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A4),B3)))
     => pp(aa(B1,bool,aa(A2,fun(B1,bool),F,A4),B3)) ) ).

tff(fact_50_split__weak__cong,axiom,
    ! [C: $tType,B1: $tType,A2: $tType,C1: fun(A2,fun(B1,C)),Q: product_prod(A2,B1),P: product_prod(A2,B1)] :
      ( ( P = Q )
     => ( aa(product_prod(A2,B1),C,aa(fun(A2,fun(B1,C)),fun(product_prod(A2,B1),C),product_prod_case(A2,B1,C),C1),P) = aa(product_prod(A2,B1),C,aa(fun(A2,fun(B1,C)),fun(product_prod(A2,B1),C),product_prod_case(A2,B1,C),C1),Q) ) ) ).

tff(fact_51_apsnd__apfst__commute,axiom,
    ! [A2: $tType,B1: $tType,C: $tType,D: $tType,P: product_prod(D,C),G: fun(D,A2),F: fun(C,B1)] : ( product_apsnd(C,B1,A2,F,product_apfst(D,A2,C,G,P)) = product_apfst(D,A2,B1,G,product_apsnd(C,B1,D,F,P)) ) ).

tff(fact_52_splitD_H,axiom,
    ! [B1: $tType,A2: $tType,C: $tType,C1: C,B3: B1,A4: A2,R1: fun(A2,fun(B1,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A2,B1),fun(C,bool),aa(fun(A2,fun(B1,fun(C,bool))),fun(product_prod(A2,B1),fun(C,bool)),product_prod_case(A2,B1,fun(C,bool)),R1),aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A4),B3)),C1))
     => pp(aa(C,bool,aa(B1,fun(C,bool),aa(A2,fun(B1,fun(C,bool)),R1,A4),B3),C1)) ) ).

tff(fact_53_prod_Osimps_I2_J,axiom,
    ! [B1: $tType,A2: $tType,C: $tType,B3: C,A4: B1,F1: fun(B1,fun(C,A2))] : ( aa(product_prod(B1,C),A2,aa(fun(B1,fun(C,A2)),fun(product_prod(B1,C),A2),product_prod_case(B1,C,A2),F1),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3)) = aa(C,A2,aa(B1,fun(C,A2),F1,A4),B3) ) ).

tff(fact_54_split__curry,axiom,
    ! [C: $tType,B1: $tType,A2: $tType,F: fun(product_prod(A2,B1),C)] : ( aa(fun(A2,fun(B1,C)),fun(product_prod(A2,B1),C),product_prod_case(A2,B1,C),product_curry(A2,B1,C,F)) = F ) ).

tff(fact_55_curry__split,axiom,
    ! [C: $tType,B1: $tType,A2: $tType,F: fun(A2,fun(B1,C))] : ( product_curry(A2,B1,C,aa(fun(A2,fun(B1,C)),fun(product_prod(A2,B1),C),product_prod_case(A2,B1,C),F)) = F ) ).

tff(fact_56_total__on__def,axiom,
    ! [A2: $tType,R: fun(product_prod(A2,A2),bool),A1: fun(A2,bool)] :
      ( total_on(A2,A1,R)
    <=> ! [X3: A2] :
          ( member(A2,X3,A1)
         => ! [Xa1: A2] :
              ( member(A2,Xa1,A1)
             => ( ( X3 != Xa1 )
               => ( member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),X3),Xa1),R)
                  | member(product_prod(A2,A2),aa(A2,product_prod(A2,A2),aa(A2,fun(A2,product_prod(A2,A2)),product_Pair(A2,A2),Xa1),X3),R) ) ) ) ) ) ).

tff(fact_57_mem__splitI2,axiom,
    ! [C: $tType,B1: $tType,A2: $tType,C1: fun(A2,fun(B1,fun(C,bool))),Z: C,P: product_prod(A2,B1)] :
      ( ! [A3: A2,B2: B1] :
          ( ( P = aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A3),B2) )
         => member(C,Z,aa(B1,fun(C,bool),aa(A2,fun(B1,fun(C,bool)),C1,A3),B2)) )
     => member(C,Z,aa(product_prod(A2,B1),fun(C,bool),aa(fun(A2,fun(B1,fun(C,bool))),fun(product_prod(A2,B1),fun(C,bool)),product_prod_case(A2,B1,fun(C,bool)),C1),P)) ) ).

tff(fact_58_splitI2_H,axiom,
    ! [A2: $tType,B1: $tType,C: $tType,X1: C,C1: fun(A2,fun(B1,fun(C,bool))),P: product_prod(A2,B1)] :
      ( ! [A3: A2,B2: B1] :
          ( ( aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A3),B2) = P )
         => pp(aa(C,bool,aa(B1,fun(C,bool),aa(A2,fun(B1,fun(C,bool)),C1,A3),B2),X1)) )
     => pp(aa(C,bool,aa(product_prod(A2,B1),fun(C,bool),aa(fun(A2,fun(B1,fun(C,bool))),fun(product_prod(A2,B1),fun(C,bool)),product_prod_case(A2,B1,fun(C,bool)),C1),P),X1)) ) ).

tff(fact_59_mem__splitE,axiom,
    ! [B1: $tType,A2: $tType,C: $tType,P: product_prod(B1,C),C1: fun(B1,fun(C,fun(A2,bool))),Z: A2] :
      ( member(A2,Z,aa(product_prod(B1,C),fun(A2,bool),aa(fun(B1,fun(C,fun(A2,bool))),fun(product_prod(B1,C),fun(A2,bool)),product_prod_case(B1,C,fun(A2,bool)),C1),P))
     => ~ ! [X2: B1,Y1: C] :
            ( ( P = aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),X2),Y1) )
           => ~ member(A2,Z,aa(C,fun(A2,bool),aa(B1,fun(C,fun(A2,bool)),C1,X2),Y1)) ) ) ).

tff(fact_60_splitE_H,axiom,
    ! [B1: $tType,A2: $tType,C: $tType,Z: C,P: product_prod(A2,B1),C1: fun(A2,fun(B1,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A2,B1),fun(C,bool),aa(fun(A2,fun(B1,fun(C,bool))),fun(product_prod(A2,B1),fun(C,bool)),product_prod_case(A2,B1,fun(C,bool)),C1),P),Z))
     => ~ ! [X2: A2,Y1: B1] :
            ( ( P = aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),X2),Y1) )
           => ~ pp(aa(C,bool,aa(B1,fun(C,bool),aa(A2,fun(B1,fun(C,bool)),C1,X2),Y1),Z)) ) ) ).

tff(fact_61_splitE,axiom,
    ! [A2: $tType,B1: $tType,P: product_prod(A2,B1),C1: fun(A2,fun(B1,bool))] :
      ( pp(aa(product_prod(A2,B1),bool,aa(fun(A2,fun(B1,bool)),fun(product_prod(A2,B1),bool),product_prod_case(A2,B1,bool),C1),P))
     => ~ ! [X2: A2,Y1: B1] :
            ( ( P = aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),X2),Y1) )
           => ~ pp(aa(B1,bool,aa(A2,fun(B1,bool),C1,X2),Y1)) ) ) ).

tff(fact_62_splitI2,axiom,
    ! [B1: $tType,A2: $tType,C1: fun(A2,fun(B1,bool)),P: product_prod(A2,B1)] :
      ( ! [A3: A2,B2: B1] :
          ( ( P = aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),A3),B2) )
         => pp(aa(B1,bool,aa(A2,fun(B1,bool),C1,A3),B2)) )
     => pp(aa(product_prod(A2,B1),bool,aa(fun(A2,fun(B1,bool)),fun(product_prod(A2,B1),bool),product_prod_case(A2,B1,bool),C1),P)) ) ).

tff(fact_63_splitE2,axiom,
    ! [B1: $tType,A2: $tType,C: $tType,Z: product_prod(B1,C),P1: fun(B1,fun(C,A2)),Q1: fun(A2,bool)] :
      ( pp(aa(A2,bool,Q1,aa(product_prod(B1,C),A2,aa(fun(B1,fun(C,A2)),fun(product_prod(B1,C),A2),product_prod_case(B1,C,A2),P1),Z)))
     => ~ ! [X2: B1,Y1: C] :
            ( ( Z = aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),X2),Y1) )
           => ~ pp(aa(A2,bool,Q1,aa(C,A2,aa(B1,fun(C,A2),P1,X2),Y1))) ) ) ).

tff(fact_64_split__cong,axiom,
    ! [C: $tType,B1: $tType,A2: $tType,P: product_prod(A2,B1),G: fun(A2,fun(B1,C)),F: fun(A2,fun(B1,C)),Q: product_prod(A2,B1)] :
      ( ! [X2: A2,Y1: B1] :
          ( ( aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),X2),Y1) = Q )
         => ( aa(B1,C,aa(A2,fun(B1,C),F,X2),Y1) = aa(B1,C,aa(A2,fun(B1,C),G,X2),Y1) ) )
     => ( ( P = Q )
       => ( aa(product_prod(A2,B1),C,aa(fun(A2,fun(B1,C)),fun(product_prod(A2,B1),C),product_prod_case(A2,B1,C),F),P) = aa(product_prod(A2,B1),C,aa(fun(A2,fun(B1,C)),fun(product_prod(A2,B1),C),product_prod_case(A2,B1,C),G),Q) ) ) ) ).

tff(fact_65_apfst__convE,axiom,
    ! [C: $tType,A2: $tType,B1: $tType,P: product_prod(C,B1),F: fun(C,A2),Q: product_prod(A2,B1)] :
      ( ( Q = product_apfst(C,A2,B1,F,P) )
     => ~ ! [X2: C,Y1: B1] :
            ( ( P = aa(B1,product_prod(C,B1),aa(C,fun(B1,product_prod(C,B1)),product_Pair(C,B1),X2),Y1) )
           => ( Q != aa(B1,product_prod(A2,B1),aa(A2,fun(B1,product_prod(A2,B1)),product_Pair(A2,B1),aa(C,A2,F,X2)),Y1) ) ) ) ).

tff(fact_66_scomp__apply,axiom,
    ! [A2: $tType,C: $tType,D: $tType,B1: $tType,X1: B1,G: fun(C,fun(D,A2)),F: fun(B1,product_prod(C,D))] : ( aa(B1,A2,product_scomp(B1,C,D,A2,F,G),X1) = aa(product_prod(C,D),A2,aa(fun(C,fun(D,A2)),fun(product_prod(C,D),A2),product_prod_case(C,D,A2),G),aa(B1,product_prod(C,D),F,X1)) ) ).

tff(fact_67_scomp__Pair,axiom,
    ! [C: $tType,B1: $tType,A2: $tType,X1: fun(A2,product_prod(B1,C))] : ( product_scomp(A2,B1,C,product_prod(B1,C),X1,product_Pair(B1,C)) = X1 ) ).

tff(fact_68_Pair__scomp,axiom,
    ! [A2: $tType,B1: $tType,C: $tType,F: fun(C,fun(A2,B1)),X1: C] : ( product_scomp(A2,C,A2,B1,aa(C,fun(A2,product_prod(C,A2)),product_Pair(C,A2),X1),F) = aa(C,fun(A2,B1),F,X1) ) ).

tff(fact_69_scomp__def,axiom,
    ! [B1: $tType,C: $tType,D: $tType,A2: $tType,G: fun(C,fun(D,B1)),F: fun(A2,product_prod(C,D)),X: A2] : ( aa(A2,B1,product_scomp(A2,C,D,B1,F,G),X) = aa(product_prod(C,D),B1,aa(fun(C,fun(D,B1)),fun(product_prod(C,D),B1),product_prod_case(C,D,B1),G),aa(A2,product_prod(C,D),F,X)) ) ).

tff(fact_70_ext,axiom,
    ! [B1: $tType,A2: $tType,G: fun(A2,B1),F: fun(A2,B1)] :
      ( ! [X2: A2] : ( aa(A2,B1,F,X2) = aa(A2,B1,G,X2) )
     => ( F = G ) ) ).

tff(fact_71_mem__def,axiom,
    ! [A2: $tType,A1: fun(A2,bool),X1: A2] :
      ( member(A2,X1,A1)
    <=> pp(aa(A2,bool,A1,X1)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (5)
tff(conj_0,hypothesis,
    ! [X: arrow_159774573e_indi] :
      ( trans(arrow_411405190le_alt,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X))
      & ! [Xa: arrow_411405190le_alt] : ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Xa),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X))
      & ! [Xa: arrow_411405190le_alt,Y: arrow_411405190le_alt] :
          ( ( Xa != Y )
         => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Y),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X))
            | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),Xa),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X)) ) ) ) ).

tff(conj_1,hypothesis,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),a),b),f(p)) ).

tff(conj_2,hypothesis,
    ( trans(arrow_411405190le_alt,f(p))
    & ! [X: arrow_411405190le_alt] : ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),X),f(p))
    & ! [X: arrow_411405190le_alt,Y: arrow_411405190le_alt] :
        ( ( X != Y )
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y),f(p))
          | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),X),f(p)) ) ) ) ).

tff(conj_3,hypothesis,
    ! [A: arrow_411405190le_alt,B: arrow_411405190le_alt] :
      ( ( A != B )
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A),B),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,i))
       => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A),B),f(p)) ) ) ).

tff(conj_4,conjecture,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),a),b),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,i)) ).

%------------------------------------------------------------------------------
