%------------------------------------------------------------------------------
% File     : SCT194_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 136
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_136 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.75 v7.3.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  133 (  36 unt;  40 typ;   0 def)
%            Number of atoms       :  219 (  81 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  173 (  47   ~;   5   |;  22   &)
%                                         (  17 <=>;  82  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   47 (  25   >;  22   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-6 aty)
%            Number of functors    :   29 (  29 usr;   7 con; 0-6 aty)
%            Number of variables   :  495 ( 446   !;   5   ?; 495   :)
%                                         (  44  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:18
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A1: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A1: $tType,B1: $tType] : ( A1 > fun(B1,A1) ) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A1: $tType,B1: $tType] : ( ( fun(product_prod(A1,B1),bool) * A1 * B1 ) > $o ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A1: $tType] : ( fun(A1,bool) > fun(fun(product_prod(A1,A1),bool),bool) ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A1: $tType] : A1 ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B1: $tType,A1: $tType] : ( ( fun(B1,fun(B1,bool)) * fun(A1,B1) * A1 * A1 ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A1: $tType,B1: $tType] : fun(A1,fun(B1,product_prod(A1,B1))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A1: $tType,C: $tType,B1: $tType] : ( ( fun(A1,C) * product_prod(A1,B1) ) > product_prod(C,B1) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B1: $tType,C: $tType,A1: $tType] : ( ( fun(B1,C) * product_prod(A1,B1) ) > product_prod(A1,C) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A1: $tType,B1: $tType,C: $tType] : ( fun(product_prod(A1,B1),C) > fun(A1,fun(B1,C)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A1: $tType,B1: $tType,C: $tType] : fun(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A1: $tType,B1: $tType,T: $tType] : fun(fun(A1,fun(B1,T)),fun(product_prod(A1,B1),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A1: $tType,B1: $tType,T: $tType] : ( ( fun(A1,fun(B1,T)) * product_prod(A1,B1) ) > T ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A1: $tType,B1: $tType,C: $tType,D: $tType] : ( ( fun(A1,product_prod(B1,C)) * fun(B1,fun(C,D)) ) > fun(A1,D) ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B1: $tType,A1: $tType] : ( ( fun(product_prod(B1,B1),bool) * fun(A1,B1) ) > fun(product_prod(A1,A1),bool) ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A1: $tType] : ( ( fun(A1,bool) * fun(product_prod(A1,A1),bool) ) > $o ) ).

tff(sy_c_Relation_Otrans,type,
    trans: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A1: $tType] : ( fun(A1,bool) > fun(A1,bool) ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A1: $tType,B1: $tType] : ( ( fun(product_prod(A1,A1),bool) * fun(product_prod(B1,B1),bool) ) > fun(product_prod(product_prod(A1,B1),product_prod(A1,B1)),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B1: $tType] : ( ( fun(A1,B1) * A1 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_P,type,
    p: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_a,type,
    a: arrow_411405190le_alt ).

tff(sy_v_b,type,
    b: arrow_411405190le_alt ).

tff(sy_v_i,type,
    i: arrow_159774573e_indi ).

%----Relevant facts (81)
tff(fact_0_irrefl__def,axiom,
    ! [A1: $tType,R1: fun(product_prod(A1,A1),bool)] :
      ( irrefl(A1,R1)
    <=> ! [X3: A1] : ~ member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X3),X3),R1) ) ).

tff(fact_1_top1I,axiom,
    ! [A1: $tType,X2: A1] : pp(aa(A1,bool,top_top(fun(A1,bool)),X2)) ).

tff(fact_2_UNIV__I,axiom,
    ! [A1: $tType,X2: A1] : member(A1,X2,top_top(fun(A1,bool))) ).

tff(fact_3_iso__tuple__UNIV__I,axiom,
    ! [A1: $tType,X2: A1] : member(A1,X2,top_top(fun(A1,bool))) ).

tff(fact_4_split__paired__All,axiom,
    ! [A1: $tType,B1: $tType,P2: fun(product_prod(A1,B1),bool)] :
      ( ! [X11: product_prod(A1,B1)] : pp(aa(product_prod(A1,B1),bool,P2,X11))
    <=> ! [A6: A1,B5: B1] : pp(aa(product_prod(A1,B1),bool,P2,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A6),B5))) ) ).

tff(fact_5_Pair__eq,axiom,
    ! [A1: $tType,B1: $tType,B4: B1,A5: A1,B3: B1,A4: A1] :
      ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A5),B4) )
    <=> ( ( A4 = A5 )
        & ( B3 = B4 ) ) ) ).

tff(fact_6_total__on__def,axiom,
    ! [A1: $tType,R1: fun(product_prod(A1,A1),bool),A2: fun(A1,bool)] :
      ( total_on(A1,A2,R1)
    <=> ! [X3: A1] :
          ( member(A1,X3,A2)
         => ! [Xa: A1] :
              ( member(A1,Xa,A2)
             => ( ( X3 != Xa )
               => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X3),Xa),R1)
                  | member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),Xa),X3),R1) ) ) ) ) ) ).

tff(fact_7_trans__def,axiom,
    ! [A1: $tType,R1: fun(product_prod(A1,A1),bool)] :
      ( trans(A1,R1)
    <=> ! [X3: A1,Y3: A1,Z2: A1] :
          ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X3),Y3),R1)
         => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),Y3),Z2),R1)
           => member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X3),Z2),R1) ) ) ) ).

tff(fact_8_transD,axiom,
    ! [A1: $tType,C1: A1,B3: A1,A4: A1,R1: fun(product_prod(A1,A1),bool)] :
      ( trans(A1,R1)
     => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),A4),B3),R1)
       => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),B3),C1),R1)
         => member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),A4),C1),R1) ) ) ) ).

tff(fact_9_strict__linear__order__on__def,axiom,
    ! [A1: $tType,R1: fun(product_prod(A1,A1),bool),A2: fun(A1,bool)] :
      ( pp(aa(fun(product_prod(A1,A1),bool),bool,order_215145569der_on(A1,A2),R1))
    <=> ( trans(A1,R1)
        & irrefl(A1,R1)
        & total_on(A1,A2,R1) ) ) ).

tff(fact_10_top__apply,axiom,
    ! [B1: $tType,A1: $tType] :
      ( top(A1)
     => ! [X2: B1] : ( aa(B1,A1,top_top(fun(B1,A1)),X2) = top_top(A1) ) ) ).

tff(fact_11_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),arrow_276188178_mkbot(L,Z))
    <=> ( ( Y1 != Z )
        & ( ( X2 = Z )
         => ( X2 != Y1 ) )
        & ( ( X2 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),L) ) ) ) ).

tff(fact_12_Pair__inject,axiom,
    ! [A1: $tType,B1: $tType,B7: B1,A8: A1,B6: B1,A7: A1] :
      ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A7),B6) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A8),B7) )
     => ~ ( ( A7 = A8 )
         => ( B6 != B7 ) ) ) ).

tff(fact_13_UNIV__def,axiom,
    ! [A1: $tType] : ( top_top(fun(A1,bool)) = collect(A1,combk(bool,A1,fTrue)) ) ).

tff(fact_14_split__paired__Ex,axiom,
    ! [A1: $tType,B1: $tType,P2: fun(product_prod(A1,B1),bool)] :
      ( ? [X11: product_prod(A1,B1)] : pp(aa(product_prod(A1,B1),bool,P2,X11))
    <=> ? [A6: A1,B5: B1] : pp(aa(product_prod(A1,B1),bool,P2,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A6),B5))) ) ).

tff(fact_15_transI,axiom,
    ! [A1: $tType,R1: fun(product_prod(A1,A1),bool)] :
      ( ! [X: A1,Y: A1,Z1: A1] :
          ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X),Y),R1)
         => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),Y),Z1),R1)
           => member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X),Z1),R1) ) )
     => trans(A1,R1) ) ).

tff(fact_16_prod_Orecs,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,B3: C,A4: B1,F1: fun(B1,fun(C,A1))] : ( product_prod_rec(B1,C,A1,F1,aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3)) = aa(C,A1,aa(B1,fun(C,A1),F1,A4),B3) ) ).

tff(fact_17_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_18_UNIV__eq__I,axiom,
    ! [A1: $tType,A2: fun(A1,bool)] :
      ( ! [X: A1] : member(A1,X,A2)
     => ( top_top(fun(A1,bool)) = A2 ) ) ).

tff(fact_19_UNIV__witness,axiom,
    ! [A1: $tType] :
    ? [X: A1] : member(A1,X,top_top(fun(A1,bool))) ).

tff(fact_20_prod_Oexhaust,axiom,
    ! [A1: $tType,B1: $tType,Y2: product_prod(A1,B1)] :
      ~ ! [A3: A1,B2: B1] : ( Y2 != aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B2) ) ).

tff(fact_21_PairE,axiom,
    ! [A1: $tType,B1: $tType,P3: product_prod(A1,B1)] :
      ~ ! [X: A1,Y: B1] : ( P3 != aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X),Y) ) ).

tff(fact_22_prod__cases3,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,Y2: product_prod(A1,product_prod(B1,C))] :
      ~ ! [A3: A1,B2: B1,C2: C] : ( Y2 != aa(product_prod(B1,C),product_prod(A1,product_prod(B1,C)),aa(A1,fun(product_prod(B1,C),product_prod(A1,product_prod(B1,C))),product_Pair(A1,product_prod(B1,C)),A3),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),B2),C2)) ) ).

tff(fact_23_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( ( X2 != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),L)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),X2),L) ) ) ) ).

tff(fact_24_Lin__irrefl,axiom,
    ! [B3: arrow_411405190le_alt,A4: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),B3),L)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B3),A4),L) ) ) ).

tff(fact_25_mkbot__Lin,axiom,
    ! [X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(L,X2),arrow_1985332922le_Lin) ) ).

tff(fact_26_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B1: $tType,A1: $tType,X2: product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),P2: fun(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A3: A1,B2: B1,C2: C,D1: D,E1: E,F3: F2] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P2,aa(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A1,fun(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B1,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P2,X2)) ) ).

tff(fact_27_prod__cases6,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y2: product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A3: A1,B2: B1,C2: C,D1: D,E1: E,F3: F2] : ( Y2 != aa(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A1,fun(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B1,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_28_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B1: $tType,A1: $tType,X2: product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),P2: fun(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A3: A1,B2: B1,C2: C,D1: D,E1: E] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),bool,P2,aa(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),aa(A1,fun(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E))))),product_Pair(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),A3),aa(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E))),aa(B1,fun(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E)))),product_Pair(B1,product_prod(C,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),bool,P2,X2)) ) ).

tff(fact_29_prod__cases5,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,D: $tType,E: $tType,Y2: product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E))))] :
      ~ ! [A3: A1,B2: B1,C2: C,D1: D,E1: E] : ( Y2 != aa(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),aa(A1,fun(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E))))),product_Pair(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),A3),aa(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E))),aa(B1,fun(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E)))),product_Pair(B1,product_prod(C,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_30_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B1: $tType,A1: $tType,X2: product_prod(A1,product_prod(B1,product_prod(C,D))),P2: fun(product_prod(A1,product_prod(B1,product_prod(C,D))),bool)] :
      ( ! [A3: A1,B2: B1,C2: C,D1: D] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C,D))),bool,P2,aa(product_prod(B1,product_prod(C,D)),product_prod(A1,product_prod(B1,product_prod(C,D))),aa(A1,fun(product_prod(B1,product_prod(C,D)),product_prod(A1,product_prod(B1,product_prod(C,D)))),product_Pair(A1,product_prod(B1,product_prod(C,D))),A3),aa(product_prod(C,D),product_prod(B1,product_prod(C,D)),aa(B1,fun(product_prod(C,D),product_prod(B1,product_prod(C,D))),product_Pair(B1,product_prod(C,D)),B2),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1)))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C,D))),bool,P2,X2)) ) ).

tff(fact_31_prod__cases4,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,D: $tType,Y2: product_prod(A1,product_prod(B1,product_prod(C,D)))] :
      ~ ! [A3: A1,B2: B1,C2: C,D1: D] : ( Y2 != aa(product_prod(B1,product_prod(C,D)),product_prod(A1,product_prod(B1,product_prod(C,D))),aa(A1,fun(product_prod(B1,product_prod(C,D)),product_prod(A1,product_prod(B1,product_prod(C,D)))),product_Pair(A1,product_prod(B1,product_prod(C,D))),A3),aa(product_prod(C,D),product_prod(B1,product_prod(C,D)),aa(B1,fun(product_prod(C,D),product_prod(B1,product_prod(C,D))),product_Pair(B1,product_prod(C,D)),B2),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1))) ) ).

tff(fact_32_prod__induct3,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,X2: product_prod(A1,product_prod(B1,C)),P2: fun(product_prod(A1,product_prod(B1,C)),bool)] :
      ( ! [A3: A1,B2: B1,C2: C] : pp(aa(product_prod(A1,product_prod(B1,C)),bool,P2,aa(product_prod(B1,C),product_prod(A1,product_prod(B1,C)),aa(A1,fun(product_prod(B1,C),product_prod(A1,product_prod(B1,C))),product_Pair(A1,product_prod(B1,C)),A3),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),B2),C2))))
     => pp(aa(product_prod(A1,product_prod(B1,C)),bool,P2,X2)) ) ).

tff(fact_33_in__below,axiom,
    ! [Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B3: arrow_411405190le_alt,A4: arrow_411405190le_alt] :
      ( ( A4 != B3 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),arrow_319942042_below(L,A4,B3))
        <=> ( ( X2 != Y1 )
            & ( ( Y1 = A4 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),B3),L) )
            & ( ( Y1 != A4 )
             => ( ( ( X2 = A4 )
                 => ( ( Y1 = B3 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B3),Y1),L) ) )
                & ( ( X2 != A4 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),L) ) ) ) ) ) ) ) ).

tff(fact_34_in__above,axiom,
    ! [Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B3: arrow_411405190le_alt,A4: arrow_411405190le_alt] :
      ( ( A4 != B3 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),arrow_1158827142_above(L,A4,B3))
        <=> ( ( X2 != Y1 )
            & ( ( X2 = B3 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A4),Y1),L) )
            & ( ( X2 != B3 )
             => ( ( ( Y1 = B3 )
                 => ( ( X2 = A4 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),A4),L) ) )
                & ( ( Y1 != B3 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),L) ) ) ) ) ) ) ) ).

tff(fact_35_linear__alt,axiom,
    ? [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin) ).

tff(fact_36_above__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( ( X2 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_1158827142_above(L,X2,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_37_below__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( ( X2 != Y1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_319942042_below(L,X2,Y1),arrow_1985332922le_Lin) ) ) ).

tff(fact_38_mktop__Lin,axiom,
    ! [X2: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(L,X2),arrow_1985332922le_Lin) ) ).

tff(fact_39_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y1: arrow_411405190le_alt,X2: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),arrow_424895264_mktop(L,Z))
    <=> ( ( X2 != Z )
        & ( ( Y1 = Z )
         => ( X2 != Y1 ) )
        & ( ( Y1 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X2),Y1),L) ) ) ) ).

tff(fact_40_internal__split__conv,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,B3: C,A4: B1,C1: fun(B1,fun(C,A1))] : ( aa(product_prod(B1,C),A1,aa(fun(B1,fun(C,A1)),fun(product_prod(B1,C),A1),produc1605651328_split(B1,C,A1),C1),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3)) = aa(C,A1,aa(B1,fun(C,A1),C1,A4),B3) ) ).

tff(fact_41_curry__conv,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,B3: C,A4: B1,F: fun(product_prod(B1,C),A1)] : ( aa(C,A1,aa(B1,fun(C,A1),product_curry(B1,C,A1,F),A4),B3) = aa(product_prod(B1,C),A1,F,aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3)) ) ).

tff(fact_42_curryI,axiom,
    ! [A1: $tType,B1: $tType,B3: B1,A4: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(product_prod(A1,B1),bool,F,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3)))
     => pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A4),B3)) ) ).

tff(fact_43_in__inv__imagep,axiom,
    ! [A1: $tType,B1: $tType,Y1: B1,X2: B1,F: fun(B1,A1),R1: fun(A1,fun(A1,bool))] :
      ( inv_imagep(A1,B1,R1,F,X2,Y1)
    <=> pp(aa(A1,bool,aa(A1,fun(A1,bool),R1,aa(B1,A1,F,X2)),aa(B1,A1,F,Y1))) ) ).

tff(fact_44_in__inv__image,axiom,
    ! [A1: $tType,B1: $tType,F: fun(A1,B1),R1: fun(product_prod(B1,B1),bool),Y1: A1,X2: A1] :
      ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X2),Y1),inv_image(B1,A1,R1,F))
    <=> member(product_prod(B1,B1),aa(B1,product_prod(B1,B1),aa(B1,fun(B1,product_prod(B1,B1)),product_Pair(B1,B1),aa(A1,B1,F,X2)),aa(A1,B1,F,Y1)),R1) ) ).

tff(fact_45_curryE,axiom,
    ! [A1: $tType,B1: $tType,B3: B1,A4: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A4),B3))
     => pp(aa(product_prod(A1,B1),bool,F,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3))) ) ).

tff(fact_46_curryD,axiom,
    ! [A1: $tType,B1: $tType,B3: B1,A4: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A4),B3))
     => pp(aa(product_prod(A1,B1),bool,F,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3))) ) ).

tff(fact_47_trans__inv__image,axiom,
    ! [A1: $tType,B1: $tType,F: fun(B1,A1),R1: fun(product_prod(A1,A1),bool)] :
      ( trans(A1,R1)
     => trans(B1,inv_image(A1,B1,R1,F)) ) ).

tff(fact_48_internal__split__def,axiom,
    ! [C: $tType,B1: $tType,A1: $tType] : ( produc1605651328_split(A1,B1,C) = product_prod_case(A1,B1,C) ) ).

tff(fact_49_trans__lex__prod,axiom,
    ! [A1: $tType,B1: $tType,R2: fun(product_prod(B1,B1),bool),R11: fun(product_prod(A1,A1),bool)] :
      ( trans(A1,R11)
     => ( trans(B1,R2)
       => trans(product_prod(A1,B1),lex_prod(A1,B1,R11,R2)) ) ) ).

tff(fact_50_in__rel__def,axiom,
    ! [B1: $tType,A1: $tType,Y1: B1,X2: A1,R: fun(product_prod(A1,B1),bool)] :
      ( in_rel(A1,B1,R,X2,Y1)
    <=> member(product_prod(A1,B1),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X2),Y1),R) ) ).

tff(fact_51_apsnd__conv,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,Y1: C,X2: A1,F: fun(C,B1)] : ( product_apsnd(C,B1,A1,F,aa(C,product_prod(A1,C),aa(A1,fun(C,product_prod(A1,C)),product_Pair(A1,C),X2),Y1)) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X2),aa(C,B1,F,Y1)) ) ).

tff(fact_52_prod__caseI,axiom,
    ! [A1: $tType,B1: $tType,B3: B1,A4: A1,F1: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),F1,A4),B3))
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F1),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3))) ) ).

tff(fact_53_splitI,axiom,
    ! [A1: $tType,B1: $tType,B3: B1,A4: A1,F: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),F,A4),B3))
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3))) ) ).

tff(fact_54_mem__splitI,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,B3: C,A4: B1,C1: fun(B1,fun(C,fun(A1,bool))),Z: A1] :
      ( member(A1,Z,aa(C,fun(A1,bool),aa(B1,fun(C,fun(A1,bool)),C1,A4),B3))
     => member(A1,Z,aa(product_prod(B1,C),fun(A1,bool),aa(fun(B1,fun(C,fun(A1,bool))),fun(product_prod(B1,C),fun(A1,bool)),product_prod_case(B1,C,fun(A1,bool)),C1),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3))) ) ).

tff(fact_55_split__conv,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,B3: C,A4: B1,F: fun(B1,fun(C,A1))] : ( aa(product_prod(B1,C),A1,aa(fun(B1,fun(C,A1)),fun(product_prod(B1,C),A1),product_prod_case(B1,C,A1),F),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3)) = aa(C,A1,aa(B1,fun(C,A1),F,A4),B3) ) ).

tff(fact_56_in__lex__prod,axiom,
    ! [A1: $tType,B1: $tType,S: fun(product_prod(B1,B1),bool),R1: fun(product_prod(A1,A1),bool),B4: B1,A5: A1,B3: B1,A4: A1] :
      ( member(product_prod(product_prod(A1,B1),product_prod(A1,B1)),aa(product_prod(A1,B1),product_prod(product_prod(A1,B1),product_prod(A1,B1)),aa(product_prod(A1,B1),fun(product_prod(A1,B1),product_prod(product_prod(A1,B1),product_prod(A1,B1))),product_Pair(product_prod(A1,B1),product_prod(A1,B1)),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3)),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A5),B4)),lex_prod(A1,B1,R1,S))
    <=> ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),A4),A5),R1)
        | ( ( A4 = A5 )
          & member(product_prod(B1,B1),aa(B1,product_prod(B1,B1),aa(B1,fun(B1,product_prod(B1,B1)),product_Pair(B1,B1),B3),B4),S) ) ) ) ).

tff(fact_57_splitD_H,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,C1: C,B3: B1,A4: A1,R: fun(A1,fun(B1,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A1,B1),fun(C,bool),aa(fun(A1,fun(B1,fun(C,bool))),fun(product_prod(A1,B1),fun(C,bool)),product_prod_case(A1,B1,fun(C,bool)),R),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3)),C1))
     => pp(aa(C,bool,aa(B1,fun(C,bool),aa(A1,fun(B1,fun(C,bool)),R,A4),B3),C1)) ) ).

tff(fact_58_prod_Osimps_I2_J,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,B3: C,A4: B1,F1: fun(B1,fun(C,A1))] : ( aa(product_prod(B1,C),A1,aa(fun(B1,fun(C,A1)),fun(product_prod(B1,C),A1),product_prod_case(B1,C,A1),F1),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A4),B3)) = aa(C,A1,aa(B1,fun(C,A1),F1,A4),B3) ) ).

tff(fact_59_split__weak__cong,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,C1: fun(A1,fun(B1,C)),Q1: product_prod(A1,B1),P1: product_prod(A1,B1)] :
      ( ( P1 = Q1 )
     => ( aa(product_prod(A1,B1),C,aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),C1),P1) = aa(product_prod(A1,B1),C,aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),C1),Q1) ) ) ).

tff(fact_60_splitD,axiom,
    ! [A1: $tType,B1: $tType,B3: B1,A4: A1,F: fun(A1,fun(B1,bool))] :
      ( pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3)))
     => pp(aa(B1,bool,aa(A1,fun(B1,bool),F,A4),B3)) ) ).

tff(fact_61_curry__split,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,F: fun(A1,fun(B1,C))] : ( product_curry(A1,B1,C,aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),F)) = F ) ).

tff(fact_62_split__curry,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,F: fun(product_prod(A1,B1),C)] : ( aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),product_curry(A1,B1,C,F)) = F ) ).

tff(fact_63_splitE,axiom,
    ! [A1: $tType,B1: $tType,P1: product_prod(A1,B1),C1: fun(A1,fun(B1,bool))] :
      ( pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),C1),P1))
     => ~ ! [X: A1,Y: B1] :
            ( ( P1 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X),Y) )
           => ~ pp(aa(B1,bool,aa(A1,fun(B1,bool),C1,X),Y)) ) ) ).

tff(fact_64_splitI2,axiom,
    ! [B1: $tType,A1: $tType,C1: fun(A1,fun(B1,bool)),P1: product_prod(A1,B1)] :
      ( ! [A3: A1,B2: B1] :
          ( ( P1 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B2) )
         => pp(aa(B1,bool,aa(A1,fun(B1,bool),C1,A3),B2)) )
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),C1),P1)) ) ).

tff(fact_65_splitE_H,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,Z: C,P1: product_prod(A1,B1),C1: fun(A1,fun(B1,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A1,B1),fun(C,bool),aa(fun(A1,fun(B1,fun(C,bool))),fun(product_prod(A1,B1),fun(C,bool)),product_prod_case(A1,B1,fun(C,bool)),C1),P1),Z))
     => ~ ! [X: A1,Y: B1] :
            ( ( P1 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X),Y) )
           => ~ pp(aa(C,bool,aa(B1,fun(C,bool),aa(A1,fun(B1,fun(C,bool)),C1,X),Y),Z)) ) ) ).

tff(fact_66_mem__splitE,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,P1: product_prod(B1,C),C1: fun(B1,fun(C,fun(A1,bool))),Z: A1] :
      ( member(A1,Z,aa(product_prod(B1,C),fun(A1,bool),aa(fun(B1,fun(C,fun(A1,bool))),fun(product_prod(B1,C),fun(A1,bool)),product_prod_case(B1,C,fun(A1,bool)),C1),P1))
     => ~ ! [X: B1,Y: C] :
            ( ( P1 = aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),X),Y) )
           => ~ member(A1,Z,aa(C,fun(A1,bool),aa(B1,fun(C,fun(A1,bool)),C1,X),Y)) ) ) ).

tff(fact_67_mem__splitI2,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,C1: fun(A1,fun(B1,fun(C,bool))),Z: C,P1: product_prod(A1,B1)] :
      ( ! [A3: A1,B2: B1] :
          ( ( P1 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B2) )
         => member(C,Z,aa(B1,fun(C,bool),aa(A1,fun(B1,fun(C,bool)),C1,A3),B2)) )
     => member(C,Z,aa(product_prod(A1,B1),fun(C,bool),aa(fun(A1,fun(B1,fun(C,bool))),fun(product_prod(A1,B1),fun(C,bool)),product_prod_case(A1,B1,fun(C,bool)),C1),P1)) ) ).

tff(fact_68_splitI2_H,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,X2: C,C1: fun(A1,fun(B1,fun(C,bool))),P1: product_prod(A1,B1)] :
      ( ! [A3: A1,B2: B1] :
          ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B2) = P1 )
         => pp(aa(C,bool,aa(B1,fun(C,bool),aa(A1,fun(B1,fun(C,bool)),C1,A3),B2),X2)) )
     => pp(aa(C,bool,aa(product_prod(A1,B1),fun(C,bool),aa(fun(A1,fun(B1,fun(C,bool))),fun(product_prod(A1,B1),fun(C,bool)),product_prod_case(A1,B1,fun(C,bool)),C1),P1),X2)) ) ).

tff(fact_69_splitE2,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,Z: product_prod(B1,C),P2: fun(B1,fun(C,A1)),Q2: fun(A1,bool)] :
      ( pp(aa(A1,bool,Q2,aa(product_prod(B1,C),A1,aa(fun(B1,fun(C,A1)),fun(product_prod(B1,C),A1),product_prod_case(B1,C,A1),P2),Z)))
     => ~ ! [X: B1,Y: C] :
            ( ( Z = aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),X),Y) )
           => ~ pp(aa(A1,bool,Q2,aa(C,A1,aa(B1,fun(C,A1),P2,X),Y))) ) ) ).

tff(fact_70_split__cong,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,P1: product_prod(A1,B1),G: fun(A1,fun(B1,C)),F: fun(A1,fun(B1,C)),Q1: product_prod(A1,B1)] :
      ( ! [X: A1,Y: B1] :
          ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X),Y) = Q1 )
         => ( aa(B1,C,aa(A1,fun(B1,C),F,X),Y) = aa(B1,C,aa(A1,fun(B1,C),G,X),Y) ) )
     => ( ( P1 = Q1 )
       => ( aa(product_prod(A1,B1),C,aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),F),P1) = aa(product_prod(A1,B1),C,aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),G),Q1) ) ) ) ).

tff(fact_71_scomp__apply,axiom,
    ! [A1: $tType,C: $tType,D: $tType,B1: $tType,X2: B1,G: fun(C,fun(D,A1)),F: fun(B1,product_prod(C,D))] : ( aa(B1,A1,product_scomp(B1,C,D,A1,F,G),X2) = aa(product_prod(C,D),A1,aa(fun(C,fun(D,A1)),fun(product_prod(C,D),A1),product_prod_case(C,D,A1),G),aa(B1,product_prod(C,D),F,X2)) ) ).

tff(fact_72_apfst__conv,axiom,
    ! [C: $tType,A1: $tType,B1: $tType,Y1: B1,X2: C,F: fun(C,A1)] : ( product_apfst(C,A1,B1,F,aa(B1,product_prod(C,B1),aa(C,fun(B1,product_prod(C,B1)),product_Pair(C,B1),X2),Y1)) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),aa(C,A1,F,X2)),Y1) ) ).

tff(fact_73_scomp__def,axiom,
    ! [B1: $tType,C: $tType,D: $tType,A1: $tType,G: fun(C,fun(D,B1)),F: fun(A1,product_prod(C,D)),X1: A1] : ( aa(A1,B1,product_scomp(A1,C,D,B1,F,G),X1) = aa(product_prod(C,D),B1,aa(fun(C,fun(D,B1)),fun(product_prod(C,D),B1),product_prod_case(C,D,B1),G),aa(A1,product_prod(C,D),F,X1)) ) ).

tff(fact_74_apsnd__apfst__commute,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,D: $tType,P1: product_prod(D,C),G: fun(D,A1),F: fun(C,B1)] : ( product_apsnd(C,B1,A1,F,product_apfst(D,A1,C,G,P1)) = product_apfst(D,A1,B1,G,product_apsnd(C,B1,D,F,P1)) ) ).

tff(fact_75_ext,axiom,
    ! [B1: $tType,A1: $tType,G: fun(A1,B1),F: fun(A1,B1)] :
      ( ! [X: A1] : ( aa(A1,B1,F,X) = aa(A1,B1,G,X) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A1: $tType,A2: fun(A1,bool),X2: A1] :
      ( member(A1,X2,A2)
    <=> pp(aa(A1,bool,A2,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A1: $tType,P2: fun(A1,bool)] : ( collect(A1,P2) = P2 ) ).

tff(fact_78_Pair__scomp,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,F: fun(C,fun(A1,B1)),X2: C] : ( product_scomp(A1,C,A1,B1,aa(C,fun(A1,product_prod(C,A1)),product_Pair(C,A1),X2),F) = aa(C,fun(A1,B1),F,X2) ) ).

tff(fact_79_scomp__Pair,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,X2: fun(A1,product_prod(B1,C))] : ( product_scomp(A1,B1,C,product_prod(B1,C),X2,product_Pair(B1,C)) = X2 ) ).

tff(fact_80_apfst__convE,axiom,
    ! [C: $tType,A1: $tType,B1: $tType,P1: product_prod(C,B1),F: fun(C,A1),Q1: product_prod(A1,B1)] :
      ( ( Q1 = product_apfst(C,A1,B1,F,P1) )
     => ~ ! [X: C,Y: B1] :
            ( ( P1 = aa(B1,product_prod(C,B1),aa(C,fun(B1,product_prod(C,B1)),product_Pair(C,B1),X),Y) )
           => ( Q1 != aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),aa(C,A1,F,X)),Y) ) ) ) ).

%----Arities (2)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B1: $tType,A1: $tType,Q: B1,P: A1] : ( aa(B1,A1,combk(A1,B1,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (5)
tff(conj_0,hypothesis,
    ! [X1: arrow_159774573e_indi] :
      ( trans(arrow_411405190le_alt,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X1))
      & irrefl(arrow_411405190le_alt,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X1))
      & total_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X1)) ) ).

tff(conj_1,hypothesis,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),a),b),f(p)) ).

tff(conj_2,hypothesis,
    ( ! [X: arrow_159774573e_indi] :
        ( trans(arrow_411405190le_alt,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X))
        & irrefl(arrow_411405190le_alt,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X))
        & total_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X)) )
   => ( trans(arrow_411405190le_alt,f(p))
      & irrefl(arrow_411405190le_alt,f(p))
      & total_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)),f(p)) ) ) ).

tff(conj_3,hypothesis,
    ( ! [X: arrow_159774573e_indi] :
        ( trans(arrow_411405190le_alt,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X))
        & irrefl(arrow_411405190le_alt,aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X))
        & total_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,X)) )
   => ! [A: arrow_411405190le_alt,B: arrow_411405190le_alt] :
        ( ( A != B )
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A),B),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,i))
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A),B),f(p)) ) ) ) ).

tff(conj_4,conjecture,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),a),b),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),p,i)) ).

%------------------------------------------------------------------------------
