%------------------------------------------------------------------------------
% File     : SCT190_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 132
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_132 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  168 (  46 unt;  44 typ;   0 def)
%            Number of atoms       :  282 ( 103 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  220 (  62   ~;  15   |;  15   &)
%                                         (  23 <=>; 105  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   45 (  25   >;  20   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-6 aty)
%            Number of functors    :   34 (  34 usr;   7 con; 0-6 aty)
%            Number of variables   :  607 ( 557   !;   7   ?; 607   :)
%                                         (  43  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:24
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oindi,type,
    arrow_159774573e_indi: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (39)
tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A1: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OIIA,type,
    arrow_1958449194le_IIA: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OProf,type,
    arrow_610318064e_Prof: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Odictator,type,
    arrow_987702531ctator: ( fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) * arrow_159774573e_indi ) > $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Ounanimity,type,
    arrow_2069624013nimity: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B1: $tType,C: $tType,A1: $tType] : fun(fun(B1,C),fun(fun(A1,B1),fun(A1,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A1: $tType,B1: $tType,C: $tType] : ( ( fun(A1,fun(B1,C)) * B1 ) > fun(A1,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A1: $tType] : fun(A1,A1) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A1: $tType,B1: $tType] : ( A1 > fun(B1,A1) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A1: $tType,B1: $tType,C: $tType] : ( ( fun(A1,fun(B1,C)) * fun(A1,B1) ) > fun(A1,C) ) ).

tff(sy_c_FuncSet_OPi,type,
    pi: 
      !>[A1: $tType,B1: $tType] : ( ( fun(A1,bool) * fun(A1,fun(B1,bool)) ) > fun(fun(A1,B1),bool) ) ).

tff(sy_c_FuncSet_Ocompose,type,
    compose: 
      !>[A1: $tType,B1: $tType,C: $tType] : ( ( fun(A1,bool) * fun(B1,C) * fun(A1,B1) ) > fun(A1,C) ) ).

tff(sy_c_HOL_OThe,type,
    the: 
      !>[A1: $tType] : ( fun(A1,bool) > A1 ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A1: $tType] : ( fun(A1,bool) > fun(fun(product_prod(A1,A1),bool),bool) ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A1: $tType] : A1 ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A1: $tType] : A1 ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B1: $tType,A1: $tType] : ( ( fun(B1,fun(B1,bool)) * fun(A1,B1) * A1 * A1 ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A1: $tType,B1: $tType] : fun(A1,fun(B1,product_prod(A1,B1))) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A1: $tType,B1: $tType,C: $tType] : ( fun(product_prod(A1,B1),C) > fun(A1,fun(B1,C)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A1: $tType,B1: $tType,C: $tType] : fun(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A1: $tType,B1: $tType,T: $tType] : fun(fun(A1,fun(B1,T)),fun(product_prod(A1,B1),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A1: $tType,B1: $tType,T: $tType] : ( ( fun(A1,fun(B1,T)) * product_prod(A1,B1) ) > T ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A1: $tType] : ( fun(A1,bool) > fun(A1,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B1: $tType] : ( ( fun(A1,B1) * A1 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: bool > bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A1: $tType] : fun(A1,fun(A1,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: bool > fun(bool,bool) ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_F,type,
    f: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)) ).

tff(sy_v_i,type,
    i: arrow_159774573e_indi ).

%----Relevant facts (100)
tff(fact_0_notin__Lin__iff,axiom,
    ! [Y2: arrow_411405190le_alt,X4: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( ( X4 != Y2 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),Y2),L)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y2),X4),L) ) ) ) ).

tff(fact_1_Lin__irrefl,axiom,
    ! [B4: arrow_411405190le_alt,A3: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B4),L)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B4),A3),L) ) ) ).

tff(fact_2_dictator__def,axiom,
    ! [Ia: arrow_159774573e_indi,Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_987702531ctator(Fa,Ia)
    <=> ! [X2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X2,arrow_610318064e_Prof)
         => ( aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X2) = aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X2,Ia) ) ) ) ).

tff(fact_3_PiE,axiom,
    ! [B1: $tType,A1: $tType,X4: A1,B2: fun(A1,fun(B1,bool)),A2: fun(A1,bool),F: fun(A1,B1)] :
      ( member(fun(A1,B1),F,pi(A1,B1,A2,B2))
     => ( ~ member(B1,aa(A1,B1,F,X4),aa(A1,fun(B1,bool),B2,X4))
       => ~ member(A1,X4,A2) ) ) ).

tff(fact_4_split__paired__All,axiom,
    ! [A1: $tType,B1: $tType,P1: fun(product_prod(A1,B1),bool)] :
      ( ! [X11: product_prod(A1,B1)] : pp(aa(product_prod(A1,B1),bool,P1,X11))
    <=> ! [A5: A1,B5: B1] : pp(aa(product_prod(A1,B1),bool,P1,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A5),B5))) ) ).

tff(fact_5_Pair__eq,axiom,
    ! [A1: $tType,B1: $tType,B8: B1,A8: A1,B4: B1,A3: A1] :
      ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B4) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A8),B8) )
    <=> ( ( A3 = A8 )
        & ( B4 = B8 ) ) ) ).

tff(fact_6_in__above,axiom,
    ! [Y2: arrow_411405190le_alt,X4: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B4: arrow_411405190le_alt,A3: arrow_411405190le_alt] :
      ( ( A3 != B4 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),Y2),arrow_1158827142_above(L,A3,B4))
        <=> ( ( X4 != Y2 )
            & ( ( X4 = B4 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),Y2),L) )
            & ( ( X4 != B4 )
             => ( ( ( Y2 = B4 )
                 => ( ( X4 = A3 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),A3),L) ) )
                & ( ( Y2 != B4 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),Y2),L) ) ) ) ) ) ) ) ).

tff(fact_7_in__below,axiom,
    ! [Y2: arrow_411405190le_alt,X4: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B4: arrow_411405190le_alt,A3: arrow_411405190le_alt] :
      ( ( A3 != B4 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),Y2),arrow_319942042_below(L,A3,B4))
        <=> ( ( X4 != Y2 )
            & ( ( Y2 = A3 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),B4),L) )
            & ( ( Y2 != A3 )
             => ( ( ( X4 = A3 )
                 => ( ( Y2 = B4 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B4),Y2),L) ) )
                & ( ( X4 != A3 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),Y2),L) ) ) ) ) ) ) ) ).

tff(fact_8_unanimity__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_2069624013nimity(Fa)
    <=> ! [X2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X2,arrow_610318064e_Prof)
         => ! [A5: arrow_411405190le_alt,B5: arrow_411405190le_alt] :
              ( ! [I: arrow_159774573e_indi] : member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A5),B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X2,I))
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A5),B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X2)) ) ) ) ).

tff(fact_9_IIA__def,axiom,
    ! [Fa: fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( arrow_1958449194le_IIA(Fa)
    <=> ! [X2: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
          ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X2,arrow_610318064e_Prof)
         => ! [Xa1: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
              ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),Xa1,arrow_610318064e_Prof)
             => ! [A5: arrow_411405190le_alt,B5: arrow_411405190le_alt] :
                  ( ! [I: arrow_159774573e_indi] :
                      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A5),B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X2,I))
                    <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A5),B5),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Xa1,I)) )
                 => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A5),B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,X2))
                  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A5),B5),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Fa,Xa1)) ) ) ) ) ) ).

tff(fact_10_linear__alt,axiom,
    ? [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin) ).

tff(fact_11_funcset__id,axiom,
    ! [A1: $tType,A2: fun(A1,bool)] : member(fun(A1,A1),combi(A1),pi(A1,A1,A2,combk(fun(A1,bool),A1,A2))) ).

tff(fact_12_funcset__mem,axiom,
    ! [A1: $tType,B1: $tType,X4: A1,B2: fun(B1,bool),A2: fun(A1,bool),F: fun(A1,B1)] :
      ( member(fun(A1,B1),F,pi(A1,B1,A2,combk(fun(B1,bool),A1,B2)))
     => ( member(A1,X4,A2)
       => member(B1,aa(A1,B1,F,X4),B2) ) ) ).

tff(fact_13_above__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X4: arrow_411405190le_alt] :
      ( ( X4 != Y2 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_1158827142_above(L,X4,Y2),arrow_1985332922le_Lin) ) ) ).

tff(fact_14_below__Lin,axiom,
    ! [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X4: arrow_411405190le_alt] :
      ( ( X4 != Y2 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_319942042_below(L,X4,Y2),arrow_1985332922le_Lin) ) ) ).

tff(fact_15_Pair__inject,axiom,
    ! [A1: $tType,B1: $tType,B7: B1,A7: A1,B6: B1,A6: A1] :
      ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A6),B6) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A7),B7) )
     => ~ ( ( A6 = A7 )
         => ( B6 != B7 ) ) ) ).

tff(fact_16_Pi__mem,axiom,
    ! [B1: $tType,A1: $tType,X4: A1,B2: fun(A1,fun(B1,bool)),A2: fun(A1,bool),F: fun(A1,B1)] :
      ( member(fun(A1,B1),F,pi(A1,B1,A2,B2))
     => ( member(A1,X4,A2)
       => member(B1,aa(A1,B1,F,X4),aa(A1,fun(B1,bool),B2,X4)) ) ) ).

tff(fact_17_Pi__I,axiom,
    ! [B1: $tType,A1: $tType,B2: fun(A1,fun(B1,bool)),F: fun(A1,B1),A2: fun(A1,bool)] :
      ( ! [X3: A1] :
          ( member(A1,X3,A2)
         => member(B1,aa(A1,B1,F,X3),aa(A1,fun(B1,bool),B2,X3)) )
     => member(fun(A1,B1),F,pi(A1,B1,A2,B2)) ) ).

tff(fact_18_split__paired__Ex,axiom,
    ! [A1: $tType,B1: $tType,P1: fun(product_prod(A1,B1),bool)] :
      ( ? [X11: product_prod(A1,B1)] : pp(aa(product_prod(A1,B1),bool,P1,X11))
    <=> ? [A5: A1,B5: B1] : pp(aa(product_prod(A1,B1),bool,P1,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A5),B5))) ) ).

tff(fact_19_prod_Orecs,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,B4: C,A3: B1,F1: fun(B1,fun(C,A1))] : ( product_prod_rec(B1,C,A1,F1,aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A3),B4)) = aa(C,A1,aa(B1,fun(C,A1),F1,A3),B4) ) ).

tff(fact_20_funcsetI,axiom,
    ! [A1: $tType,B1: $tType,B2: fun(B1,bool),F: fun(A1,B1),A2: fun(A1,bool)] :
      ( ! [X3: A1] :
          ( member(A1,X3,A2)
         => member(B1,aa(A1,B1,F,X3),B2) )
     => member(fun(A1,B1),F,pi(A1,B1,A2,combk(fun(B1,bool),A1,B2))) ) ).

tff(fact_21_Pi__cong,axiom,
    ! [B1: $tType,A1: $tType,B2: fun(A1,fun(B1,bool)),G: fun(A1,B1),F: fun(A1,B1),A2: fun(A1,bool)] :
      ( ! [W: A1] :
          ( member(A1,W,A2)
         => ( aa(A1,B1,F,W) = aa(A1,B1,G,W) ) )
     => ( member(fun(A1,B1),F,pi(A1,B1,A2,B2))
      <=> member(fun(A1,B1),G,pi(A1,B1,A2,B2)) ) ) ).

tff(fact_22_Pi__I_H,axiom,
    ! [B1: $tType,A1: $tType,B2: fun(A1,fun(B1,bool)),F: fun(A1,B1),A2: fun(A1,bool)] :
      ( ! [X3: A1] :
          ( member(A1,X3,A2)
         => member(B1,aa(A1,B1,F,X3),aa(A1,fun(B1,bool),B2,X3)) )
     => member(fun(A1,B1),F,pi(A1,B1,A2,B2)) ) ).

tff(fact_23_mktop__Lin,axiom,
    ! [X4: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(L,X4),arrow_1985332922le_Lin) ) ).

tff(fact_24_mkbot__Lin,axiom,
    ! [X4: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(L,X4),arrow_1985332922le_Lin) ) ).

tff(fact_25_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X4: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),Y2),arrow_276188178_mkbot(L,Z))
    <=> ( ( Y2 != Z )
        & ( ( X4 = Z )
         => ( X4 != Y2 ) )
        & ( ( X4 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),Y2),L) ) ) ) ).

tff(fact_26_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y2: arrow_411405190le_alt,X4: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),Y2),arrow_424895264_mktop(L,Z))
    <=> ( ( X4 != Z )
        & ( ( Y2 = Z )
         => ( X4 != Y2 ) )
        & ( ( Y2 != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X4),Y2),L) ) ) ) ).

tff(fact_27_pred__equals__eq2,axiom,
    ! [B1: $tType,A1: $tType,S: fun(product_prod(A1,B1),bool),R2: fun(product_prod(A1,B1),bool)] :
      ( ! [X2: A1,Xa1: B1] :
          ( member(product_prod(A1,B1),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X2),Xa1),R2)
        <=> member(product_prod(A1,B1),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X2),Xa1),S) )
    <=> ( R2 = S ) ) ).

tff(fact_28_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B1: $tType,A1: $tType,X4: product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),P1: fun(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A4: A1,B3: B1,C3: C,D2: D,E1: E,F3: F2] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,aa(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A1,fun(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),A4),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B1,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),B3),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C3),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D2),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,X4)) ) ).

tff(fact_29_prod__cases6,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y: product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A4: A1,B3: B1,C3: C,D2: D,E1: E,F3: F2] : ( Y != aa(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A1,fun(product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A1,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),A4),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B1,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B1,product_prod(C,product_prod(D,product_prod(E,F2)))),B3),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C3),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D2),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_30_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B1: $tType,A1: $tType,X4: product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A4: A1,B3: B1,C3: C,D2: D,E1: E] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),bool,P1,aa(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),aa(A1,fun(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E))))),product_Pair(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),A4),aa(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E))),aa(B1,fun(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E)))),product_Pair(B1,product_prod(C,product_prod(D,E))),B3),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C3),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D2),E1))))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),bool,P1,X4)) ) ).

tff(fact_31_prod__cases5,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E))))] :
      ~ ! [A4: A1,B3: B1,C3: C,D2: D,E1: E] : ( Y != aa(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),aa(A1,fun(product_prod(B1,product_prod(C,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C,product_prod(D,E))))),product_Pair(A1,product_prod(B1,product_prod(C,product_prod(D,E)))),A4),aa(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E))),aa(B1,fun(product_prod(C,product_prod(D,E)),product_prod(B1,product_prod(C,product_prod(D,E)))),product_Pair(B1,product_prod(C,product_prod(D,E))),B3),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C3),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D2),E1)))) ) ).

tff(fact_32_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B1: $tType,A1: $tType,X4: product_prod(A1,product_prod(B1,product_prod(C,D))),P1: fun(product_prod(A1,product_prod(B1,product_prod(C,D))),bool)] :
      ( ! [A4: A1,B3: B1,C3: C,D2: D] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C,D))),bool,P1,aa(product_prod(B1,product_prod(C,D)),product_prod(A1,product_prod(B1,product_prod(C,D))),aa(A1,fun(product_prod(B1,product_prod(C,D)),product_prod(A1,product_prod(B1,product_prod(C,D)))),product_Pair(A1,product_prod(B1,product_prod(C,D))),A4),aa(product_prod(C,D),product_prod(B1,product_prod(C,D)),aa(B1,fun(product_prod(C,D),product_prod(B1,product_prod(C,D))),product_Pair(B1,product_prod(C,D)),B3),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C3),D2)))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C,D))),bool,P1,X4)) ) ).

tff(fact_33_prod__cases4,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,D: $tType,Y: product_prod(A1,product_prod(B1,product_prod(C,D)))] :
      ~ ! [A4: A1,B3: B1,C3: C,D2: D] : ( Y != aa(product_prod(B1,product_prod(C,D)),product_prod(A1,product_prod(B1,product_prod(C,D))),aa(A1,fun(product_prod(B1,product_prod(C,D)),product_prod(A1,product_prod(B1,product_prod(C,D)))),product_Pair(A1,product_prod(B1,product_prod(C,D))),A4),aa(product_prod(C,D),product_prod(B1,product_prod(C,D)),aa(B1,fun(product_prod(C,D),product_prod(B1,product_prod(C,D))),product_Pair(B1,product_prod(C,D)),B3),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C3),D2))) ) ).

tff(fact_34_prod__cases3,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,Y: product_prod(A1,product_prod(B1,C))] :
      ~ ! [A4: A1,B3: B1,C3: C] : ( Y != aa(product_prod(B1,C),product_prod(A1,product_prod(B1,C)),aa(A1,fun(product_prod(B1,C),product_prod(A1,product_prod(B1,C))),product_Pair(A1,product_prod(B1,C)),A4),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),B3),C3)) ) ).

tff(fact_35_prod__induct3,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,X4: product_prod(A1,product_prod(B1,C)),P1: fun(product_prod(A1,product_prod(B1,C)),bool)] :
      ( ! [A4: A1,B3: B1,C3: C] : pp(aa(product_prod(A1,product_prod(B1,C)),bool,P1,aa(product_prod(B1,C),product_prod(A1,product_prod(B1,C)),aa(A1,fun(product_prod(B1,C),product_prod(A1,product_prod(B1,C))),product_Pair(A1,product_prod(B1,C)),A4),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),B3),C3))))
     => pp(aa(product_prod(A1,product_prod(B1,C)),bool,P1,X4)) ) ).

tff(fact_36_prod_Oexhaust,axiom,
    ! [A1: $tType,B1: $tType,Y: product_prod(A1,B1)] :
      ~ ! [A4: A1,B3: B1] : ( Y != aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3) ) ).

tff(fact_37_PairE,axiom,
    ! [A1: $tType,B1: $tType,P3: product_prod(A1,B1)] :
      ~ ! [X3: A1,Y1: B1] : ( P3 != aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X3),Y1) ) ).

tff(fact_38_internal__split__conv,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,B4: C,A3: B1,C1: fun(B1,fun(C,A1))] : ( aa(product_prod(B1,C),A1,aa(fun(B1,fun(C,A1)),fun(product_prod(B1,C),A1),produc1605651328_split(B1,C,A1),C1),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A3),B4)) = aa(C,A1,aa(B1,fun(C,A1),C1,A3),B4) ) ).

tff(fact_39_curry__conv,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,B4: C,A3: B1,F: fun(product_prod(B1,C),A1)] : ( aa(C,A1,aa(B1,fun(C,A1),product_curry(B1,C,A1,F),A3),B4) = aa(product_prod(B1,C),A1,F,aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A3),B4)) ) ).

tff(fact_40_curryI,axiom,
    ! [A1: $tType,B1: $tType,B4: B1,A3: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(product_prod(A1,B1),bool,F,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B4)))
     => pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A3),B4)) ) ).

tff(fact_41_curryD,axiom,
    ! [A1: $tType,B1: $tType,B4: B1,A3: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A3),B4))
     => pp(aa(product_prod(A1,B1),bool,F,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B4))) ) ).

tff(fact_42_curryE,axiom,
    ! [A1: $tType,B1: $tType,B4: B1,A3: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A3),B4))
     => pp(aa(product_prod(A1,B1),bool,F,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B4))) ) ).

tff(fact_43_curry__def,axiom,
    ! [C: $tType,A1: $tType,B1: $tType,X: fun(product_prod(A1,B1),C),Xa: A1,Xb: B1] : ( aa(B1,C,aa(A1,fun(B1,C),product_curry(A1,B1,C,X),Xa),Xb) = aa(product_prod(A1,B1),C,X,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),Xa),Xb)) ) ).

tff(fact_44_Prof__def,axiom,
    arrow_610318064e_Prof = pi(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),top_top(fun(arrow_159774573e_indi,bool)),combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),arrow_159774573e_indi,arrow_1985332922le_Lin)) ).

tff(fact_45_in__inv__imagep,axiom,
    ! [A1: $tType,B1: $tType,Y2: B1,X4: B1,F: fun(B1,A1),R1: fun(A1,fun(A1,bool))] :
      ( inv_imagep(A1,B1,R1,F,X4,Y2)
    <=> pp(aa(A1,bool,aa(A1,fun(A1,bool),R1,aa(B1,A1,F,X4)),aa(B1,A1,F,Y2))) ) ).

tff(fact_46_internal__split__def,axiom,
    ! [C: $tType,B1: $tType,A1: $tType] : ( produc1605651328_split(A1,B1,C) = product_prod_case(A1,B1,C) ) ).

tff(fact_47_funcset__compose,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,C2: fun(C,bool),G: fun(B1,C),B2: fun(B1,bool),A2: fun(A1,bool),F: fun(A1,B1)] :
      ( member(fun(A1,B1),F,pi(A1,B1,A2,combk(fun(B1,bool),A1,B2)))
     => ( member(fun(B1,C),G,pi(B1,C,B2,combk(fun(C,bool),B1,C2)))
       => member(fun(A1,C),compose(A1,B1,C,A2,G,F),pi(A1,C,A2,combk(fun(C,bool),A1,C2))) ) ) ).

tff(fact_48_compose__assoc,axiom,
    ! [C: $tType,D: $tType,B1: $tType,A1: $tType,D1: fun(D,bool),H: fun(C,D),C2: fun(C,bool),G: fun(B1,C),B2: fun(B1,bool),A2: fun(A1,bool),F: fun(A1,B1)] :
      ( member(fun(A1,B1),F,pi(A1,B1,A2,combk(fun(B1,bool),A1,B2)))
     => ( member(fun(B1,C),G,pi(B1,C,B2,combk(fun(C,bool),B1,C2)))
       => ( member(fun(C,D),H,pi(C,D,C2,combk(fun(D,bool),C,D1)))
         => ( compose(A1,C,D,A2,H,compose(A1,B1,C,A2,G,F)) = compose(A1,B1,D,A2,compose(B1,C,D,B2,H,G),F) ) ) ) ) ).

tff(fact_49_prod__caseI,axiom,
    ! [A1: $tType,B1: $tType,B4: B1,A3: A1,F1: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),F1,A3),B4))
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F1),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B4))) ) ).

tff(fact_50_splitI,axiom,
    ! [A1: $tType,B1: $tType,B4: B1,A3: A1,F: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),F,A3),B4))
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B4))) ) ).

tff(fact_51_mem__splitI,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,B4: C,A3: B1,C1: fun(B1,fun(C,fun(A1,bool))),Z: A1] :
      ( member(A1,Z,aa(C,fun(A1,bool),aa(B1,fun(C,fun(A1,bool)),C1,A3),B4))
     => member(A1,Z,aa(product_prod(B1,C),fun(A1,bool),aa(fun(B1,fun(C,fun(A1,bool))),fun(product_prod(B1,C),fun(A1,bool)),product_prod_case(B1,C,fun(A1,bool)),C1),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A3),B4))) ) ).

tff(fact_52_top1I,axiom,
    ! [A1: $tType,X4: A1] : pp(aa(A1,bool,top_top(fun(A1,bool)),X4)) ).

tff(fact_53_split__conv,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,B4: C,A3: B1,F: fun(B1,fun(C,A1))] : ( aa(product_prod(B1,C),A1,aa(fun(B1,fun(C,A1)),fun(product_prod(B1,C),A1),product_prod_case(B1,C,A1),F),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A3),B4)) = aa(C,A1,aa(B1,fun(C,A1),F,A3),B4) ) ).

tff(fact_54_Pi__UNIV,axiom,
    ! [B1: $tType,A1: $tType,A2: fun(A1,bool)] : ( pi(A1,B1,A2,combk(fun(B1,bool),A1,top_top(fun(B1,bool)))) = top_top(fun(fun(A1,B1),bool)) ) ).

tff(fact_55_compose__eq,axiom,
    ! [B1: $tType,C: $tType,A1: $tType,F: fun(A1,C),G: fun(C,B1),A2: fun(A1,bool),X4: A1] :
      ( member(A1,X4,A2)
     => ( aa(A1,B1,compose(A1,C,B1,A2,G,F),X4) = aa(C,B1,G,aa(A1,C,F,X4)) ) ) ).

tff(fact_56_split__weak__cong,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,C1: fun(A1,fun(B1,C)),Q1: product_prod(A1,B1),P2: product_prod(A1,B1)] :
      ( ( P2 = Q1 )
     => ( aa(product_prod(A1,B1),C,aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),C1),P2) = aa(product_prod(A1,B1),C,aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),C1),Q1) ) ) ).

tff(fact_57_split__twice,axiom,
    ! [B1: $tType,C: $tType,A1: $tType,E: $tType,D: $tType,P2: product_prod(D,E),G: fun(D,fun(E,product_prod(B1,C))),F: fun(B1,fun(C,A1))] : ( aa(product_prod(B1,C),A1,aa(fun(B1,fun(C,A1)),fun(product_prod(B1,C),A1),product_prod_case(B1,C,A1),F),aa(product_prod(D,E),product_prod(B1,C),aa(fun(D,fun(E,product_prod(B1,C))),fun(product_prod(D,E),product_prod(B1,C)),product_prod_case(D,E,product_prod(B1,C)),G),P2)) = aa(product_prod(D,E),A1,aa(fun(D,fun(E,A1)),fun(product_prod(D,E),A1),product_prod_case(D,E,A1),aa(fun(D,fun(E,product_prod(B1,C))),fun(D,fun(E,A1)),aa(fun(fun(E,product_prod(B1,C)),fun(E,A1)),fun(fun(D,fun(E,product_prod(B1,C))),fun(D,fun(E,A1))),combb(fun(E,product_prod(B1,C)),fun(E,A1),D),aa(fun(product_prod(B1,C),A1),fun(fun(E,product_prod(B1,C)),fun(E,A1)),combb(product_prod(B1,C),A1,E),aa(fun(B1,fun(C,A1)),fun(product_prod(B1,C),A1),product_prod_case(B1,C,A1),F))),G)),P2) ) ).

tff(fact_58_splitD,axiom,
    ! [A1: $tType,B1: $tType,B4: B1,A3: A1,F: fun(A1,fun(B1,bool))] :
      ( pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B4)))
     => pp(aa(B1,bool,aa(A1,fun(B1,bool),F,A3),B4)) ) ).

tff(fact_59_splitD_H,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,C1: C,B4: B1,A3: A1,R2: fun(A1,fun(B1,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A1,B1),fun(C,bool),aa(fun(A1,fun(B1,fun(C,bool))),fun(product_prod(A1,B1),fun(C,bool)),product_prod_case(A1,B1,fun(C,bool)),R2),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A3),B4)),C1))
     => pp(aa(C,bool,aa(B1,fun(C,bool),aa(A1,fun(B1,fun(C,bool)),R2,A3),B4),C1)) ) ).

tff(fact_60_prod_Osimps_I2_J,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,B4: C,A3: B1,F1: fun(B1,fun(C,A1))] : ( aa(product_prod(B1,C),A1,aa(fun(B1,fun(C,A1)),fun(product_prod(B1,C),A1),product_prod_case(B1,C,A1),F1),aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),A3),B4)) = aa(C,A1,aa(B1,fun(C,A1),F1,A3),B4) ) ).

tff(fact_61_split__eta,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,F: fun(product_prod(A1,B1),C)] : ( aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),aa(fun(A1,fun(B1,product_prod(A1,B1))),fun(A1,fun(B1,C)),aa(fun(fun(B1,product_prod(A1,B1)),fun(B1,C)),fun(fun(A1,fun(B1,product_prod(A1,B1))),fun(A1,fun(B1,C))),combb(fun(B1,product_prod(A1,B1)),fun(B1,C),A1),aa(fun(product_prod(A1,B1),C),fun(fun(B1,product_prod(A1,B1)),fun(B1,C)),combb(product_prod(A1,B1),C,B1),F)),product_Pair(A1,B1))) = F ) ).

tff(fact_62_split__curry,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,F: fun(product_prod(A1,B1),C)] : ( aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),product_curry(A1,B1,C,F)) = F ) ).

tff(fact_63_curry__split,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,F: fun(A1,fun(B1,C))] : ( product_curry(A1,B1,C,aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),F)) = F ) ).

tff(fact_64_inv__imagep__def,axiom,
    ! [B1: $tType,A1: $tType,F: fun(A1,B1),R1: fun(B1,fun(B1,bool)),X: A1,Xa: A1] :
      ( inv_imagep(B1,A1,R1,F,X,Xa)
    <=> pp(aa(B1,bool,aa(B1,fun(B1,bool),R1,aa(A1,B1,F,X)),aa(A1,B1,F,Xa))) ) ).

tff(fact_65_mem__splitI2,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,C1: fun(A1,fun(B1,fun(C,bool))),Z: C,P2: product_prod(A1,B1)] :
      ( ! [A4: A1,B3: B1] :
          ( ( P2 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3) )
         => member(C,Z,aa(B1,fun(C,bool),aa(A1,fun(B1,fun(C,bool)),C1,A4),B3)) )
     => member(C,Z,aa(product_prod(A1,B1),fun(C,bool),aa(fun(A1,fun(B1,fun(C,bool))),fun(product_prod(A1,B1),fun(C,bool)),product_prod_case(A1,B1,fun(C,bool)),C1),P2)) ) ).

tff(fact_66_splitI2_H,axiom,
    ! [A1: $tType,B1: $tType,C: $tType,X4: C,C1: fun(A1,fun(B1,fun(C,bool))),P2: product_prod(A1,B1)] :
      ( ! [A4: A1,B3: B1] :
          ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3) = P2 )
         => pp(aa(C,bool,aa(B1,fun(C,bool),aa(A1,fun(B1,fun(C,bool)),C1,A4),B3),X4)) )
     => pp(aa(C,bool,aa(product_prod(A1,B1),fun(C,bool),aa(fun(A1,fun(B1,fun(C,bool))),fun(product_prod(A1,B1),fun(C,bool)),product_prod_case(A1,B1,fun(C,bool)),C1),P2),X4)) ) ).

tff(fact_67_mem__splitE,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,P2: product_prod(B1,C),C1: fun(B1,fun(C,fun(A1,bool))),Z: A1] :
      ( member(A1,Z,aa(product_prod(B1,C),fun(A1,bool),aa(fun(B1,fun(C,fun(A1,bool))),fun(product_prod(B1,C),fun(A1,bool)),product_prod_case(B1,C,fun(A1,bool)),C1),P2))
     => ~ ! [X3: B1,Y1: C] :
            ( ( P2 = aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),X3),Y1) )
           => ~ member(A1,Z,aa(C,fun(A1,bool),aa(B1,fun(C,fun(A1,bool)),C1,X3),Y1)) ) ) ).

tff(fact_68_splitE_H,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,Z: C,P2: product_prod(A1,B1),C1: fun(A1,fun(B1,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A1,B1),fun(C,bool),aa(fun(A1,fun(B1,fun(C,bool))),fun(product_prod(A1,B1),fun(C,bool)),product_prod_case(A1,B1,fun(C,bool)),C1),P2),Z))
     => ~ ! [X3: A1,Y1: B1] :
            ( ( P2 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X3),Y1) )
           => ~ pp(aa(C,bool,aa(B1,fun(C,bool),aa(A1,fun(B1,fun(C,bool)),C1,X3),Y1),Z)) ) ) ).

tff(fact_69_split__part,axiom,
    ! [B1: $tType,A1: $tType,Q2: fun(A1,fun(B1,bool)),P1: bool,X: product_prod(A1,B1)] :
      ( pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),aa(fun(A1,fun(B1,bool)),fun(A1,fun(B1,bool)),aa(fun(fun(B1,bool),fun(B1,bool)),fun(fun(A1,fun(B1,bool)),fun(A1,fun(B1,bool))),combb(fun(B1,bool),fun(B1,bool),A1),aa(fun(bool,bool),fun(fun(B1,bool),fun(B1,bool)),combb(bool,bool,B1),aa(bool,fun(bool,bool),fconj,P1))),Q2)),X))
    <=> ( pp(P1)
        & pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),Q2),X)) ) ) ).

tff(fact_70_splitE,axiom,
    ! [A1: $tType,B1: $tType,P2: product_prod(A1,B1),C1: fun(A1,fun(B1,bool))] :
      ( pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),C1),P2))
     => ~ ! [X3: A1,Y1: B1] :
            ( ( P2 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X3),Y1) )
           => ~ pp(aa(B1,bool,aa(A1,fun(B1,bool),C1,X3),Y1)) ) ) ).

tff(fact_71_splitI2,axiom,
    ! [B1: $tType,A1: $tType,C1: fun(A1,fun(B1,bool)),P2: product_prod(A1,B1)] :
      ( ! [A4: A1,B3: B1] :
          ( ( P2 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3) )
         => pp(aa(B1,bool,aa(A1,fun(B1,bool),C1,A4),B3)) )
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),C1),P2)) ) ).

tff(fact_72_cond__split__eta,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,G: fun(product_prod(A1,B1),C),F: fun(A1,fun(B1,C))] :
      ( ! [X3: A1,Y1: B1] : ( aa(B1,C,aa(A1,fun(B1,C),F,X3),Y1) = aa(product_prod(A1,B1),C,G,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X3),Y1)) )
     => ( aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),F) = G ) ) ).

tff(fact_73_UNIV__I,axiom,
    ! [A1: $tType,X4: A1] : member(A1,X4,top_top(fun(A1,bool))) ).

tff(fact_74_iso__tuple__UNIV__I,axiom,
    ! [A1: $tType,X4: A1] : member(A1,X4,top_top(fun(A1,bool))) ).

tff(fact_75_ext,axiom,
    ! [B1: $tType,A1: $tType,G: fun(A1,B1),F: fun(A1,B1)] :
      ( ! [X3: A1] : ( aa(A1,B1,F,X3) = aa(A1,B1,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A1: $tType,A2: fun(A1,bool),X4: A1] :
      ( member(A1,X4,A2)
    <=> pp(aa(A1,bool,A2,X4)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A1: $tType,P1: fun(A1,bool)] : ( collect(A1,P1) = P1 ) ).

tff(fact_78_UNIV__def,axiom,
    ! [A1: $tType] : ( top_top(fun(A1,bool)) = collect(A1,combk(bool,A1,fTrue)) ) ).

tff(fact_79_splitE2,axiom,
    ! [B1: $tType,A1: $tType,C: $tType,Z: product_prod(B1,C),P1: fun(B1,fun(C,A1)),Q2: fun(A1,bool)] :
      ( pp(aa(A1,bool,Q2,aa(product_prod(B1,C),A1,aa(fun(B1,fun(C,A1)),fun(product_prod(B1,C),A1),product_prod_case(B1,C,A1),P1),Z)))
     => ~ ! [X3: B1,Y1: C] :
            ( ( Z = aa(C,product_prod(B1,C),aa(B1,fun(C,product_prod(B1,C)),product_Pair(B1,C),X3),Y1) )
           => ~ pp(aa(A1,bool,Q2,aa(C,A1,aa(B1,fun(C,A1),P1,X3),Y1))) ) ) ).

tff(fact_80_top__apply,axiom,
    ! [B1: $tType,A1: $tType] :
      ( top(A1)
     => ! [X4: B1] : ( aa(B1,A1,top_top(fun(B1,A1)),X4) = top_top(A1) ) ) ).

tff(fact_81_UNIV__eq__I,axiom,
    ! [A1: $tType,A2: fun(A1,bool)] :
      ( ! [X3: A1] : member(A1,X3,A2)
     => ( top_top(fun(A1,bool)) = A2 ) ) ).

tff(fact_82_UNIV__witness,axiom,
    ! [A1: $tType] :
    ? [X3: A1] : member(A1,X3,top_top(fun(A1,bool))) ).

tff(fact_83_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_84_The__split__eq,axiom,
    ! [A1: $tType,B1: $tType,Y2: B1,X4: A1] : ( the(product_prod(A1,B1),aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),combc(A1,fun(B1,bool),fun(B1,bool),aa(fun(A1,fun(bool,bool)),fun(A1,fun(fun(B1,bool),fun(B1,bool))),aa(fun(fun(bool,bool),fun(fun(B1,bool),fun(B1,bool))),fun(fun(A1,fun(bool,bool)),fun(A1,fun(fun(B1,bool),fun(B1,bool)))),combb(fun(bool,bool),fun(fun(B1,bool),fun(B1,bool)),A1),combb(bool,bool,B1)),aa(fun(A1,bool),fun(A1,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A1,bool),fun(A1,fun(bool,bool))),combb(bool,fun(bool,bool),A1),fconj),aa(A1,fun(A1,bool),fequal(A1),X4))),aa(B1,fun(B1,bool),fequal(B1),Y2)))) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X4),Y2) ) ).

tff(fact_85_split__paired__The,axiom,
    ! [B1: $tType,A1: $tType,P1: fun(product_prod(A1,B1),bool)] : ( the(product_prod(A1,B1),P1) = the(product_prod(A1,B1),aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),aa(fun(A1,fun(B1,product_prod(A1,B1))),fun(A1,fun(B1,bool)),aa(fun(fun(B1,product_prod(A1,B1)),fun(B1,bool)),fun(fun(A1,fun(B1,product_prod(A1,B1))),fun(A1,fun(B1,bool))),combb(fun(B1,product_prod(A1,B1)),fun(B1,bool),A1),aa(fun(product_prod(A1,B1),bool),fun(fun(B1,product_prod(A1,B1)),fun(B1,bool)),combb(product_prod(A1,B1),bool,B1),P1)),product_Pair(A1,B1)))) ) ).

tff(fact_86_If__def,axiom,
    ! [A1: $tType,Y2: A1,X4: A1,P1: bool] :
      ( ( pp(P1)
       => ( X4 = the(A1,combs(A1,bool,bool,aa(fun(A1,bool),fun(A1,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A1,bool),fun(A1,fun(bool,bool))),combb(bool,fun(bool,bool),A1),fconj),aa(fun(A1,bool),fun(A1,bool),aa(fun(bool,bool),fun(fun(A1,bool),fun(A1,bool)),combb(bool,bool,A1),fimplies(P1)),combc(A1,A1,bool,fequal(A1),X4))),aa(fun(A1,bool),fun(A1,bool),aa(fun(bool,bool),fun(fun(A1,bool),fun(A1,bool)),combb(bool,bool,A1),fimplies(fNot(P1))),combc(A1,A1,bool,fequal(A1),Y2)))) ) )
      & ( ~ pp(P1)
       => ( Y2 = the(A1,combs(A1,bool,bool,aa(fun(A1,bool),fun(A1,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A1,bool),fun(A1,fun(bool,bool))),combb(bool,fun(bool,bool),A1),fconj),aa(fun(A1,bool),fun(A1,bool),aa(fun(bool,bool),fun(fun(A1,bool),fun(A1,bool)),combb(bool,bool,A1),fimplies(P1)),combc(A1,A1,bool,fequal(A1),X4))),aa(fun(A1,bool),fun(A1,bool),aa(fun(bool,bool),fun(fun(A1,bool),fun(A1,bool)),combb(bool,bool,A1),fimplies(fNot(P1))),combc(A1,A1,bool,fequal(A1),Y2)))) ) ) ) ).

tff(fact_87_the__eq__trivial,axiom,
    ! [A1: $tType,A3: A1] : ( the(A1,combc(A1,A1,bool,fequal(A1),A3)) = A3 ) ).

tff(fact_88_the__sym__eq__trivial,axiom,
    ! [A1: $tType,X4: A1] : ( the(A1,aa(A1,fun(A1,bool),fequal(A1),X4)) = X4 ) ).

tff(fact_89_the__equality,axiom,
    ! [A1: $tType,A3: A1,P1: fun(A1,bool)] :
      ( pp(aa(A1,bool,P1,A3))
     => ( ! [X3: A1] :
            ( pp(aa(A1,bool,P1,X3))
           => ( X3 = A3 ) )
       => ( the(A1,P1) = A3 ) ) ) ).

tff(fact_90_theI,axiom,
    ! [A1: $tType,A3: A1,P1: fun(A1,bool)] :
      ( pp(aa(A1,bool,P1,A3))
     => ( ! [X3: A1] :
            ( pp(aa(A1,bool,P1,X3))
           => ( X3 = A3 ) )
       => pp(aa(A1,bool,P1,the(A1,P1))) ) ) ).

tff(fact_91_theI_H,axiom,
    ! [A1: $tType,P1: fun(A1,bool)] :
      ( ? [X: A1] :
          ( pp(aa(A1,bool,P1,X))
          & ! [Y1: A1] :
              ( pp(aa(A1,bool,P1,Y1))
             => ( Y1 = X ) ) )
     => pp(aa(A1,bool,P1,the(A1,P1))) ) ).

tff(fact_92_the1__equality,axiom,
    ! [A1: $tType,A3: A1,P1: fun(A1,bool)] :
      ( ? [X: A1] :
          ( pp(aa(A1,bool,P1,X))
          & ! [Y1: A1] :
              ( pp(aa(A1,bool,P1,Y1))
             => ( Y1 = X ) ) )
     => ( pp(aa(A1,bool,P1,A3))
       => ( the(A1,P1) = A3 ) ) ) ).

tff(fact_93_Pi__empty,axiom,
    ! [B1: $tType,A1: $tType,B2: fun(A1,fun(B1,bool))] : ( pi(A1,B1,bot_bot(fun(A1,bool)),B2) = top_top(fun(fun(A1,B1),bool)) ) ).

tff(fact_94_split__cong,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,P2: product_prod(A1,B1),G: fun(A1,fun(B1,C)),F: fun(A1,fun(B1,C)),Q1: product_prod(A1,B1)] :
      ( ! [X3: A1,Y1: B1] :
          ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X3),Y1) = Q1 )
         => ( aa(B1,C,aa(A1,fun(B1,C),F,X3),Y1) = aa(B1,C,aa(A1,fun(B1,C),G,X3),Y1) ) )
     => ( ( P2 = Q1 )
       => ( aa(product_prod(A1,B1),C,aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),F),P2) = aa(product_prod(A1,B1),C,aa(fun(A1,fun(B1,C)),fun(product_prod(A1,B1),C),product_prod_case(A1,B1,C),G),Q1) ) ) ) ).

tff(fact_95_emptyE,axiom,
    ! [A1: $tType,A3: A1] : ~ member(A1,A3,bot_bot(fun(A1,bool))) ).

tff(fact_96_Collect__empty__eq,axiom,
    ! [A1: $tType,P1: fun(A1,bool)] :
      ( ( collect(A1,P1) = bot_bot(fun(A1,bool)) )
    <=> ! [X2: A1] : ~ pp(aa(A1,bool,P1,X2)) ) ).

tff(fact_97_empty__iff,axiom,
    ! [A1: $tType,C1: A1] : ~ member(A1,C1,bot_bot(fun(A1,bool))) ).

tff(fact_98_empty__Collect__eq,axiom,
    ! [A1: $tType,P1: fun(A1,bool)] :
      ( ( bot_bot(fun(A1,bool)) = collect(A1,P1) )
    <=> ! [X2: A1] : ~ pp(aa(A1,bool,P1,X2)) ) ).

tff(fact_99_all__not__in__conv,axiom,
    ! [A1: $tType,A2: fun(A1,bool)] :
      ( ! [X2: A1] : ~ member(A1,X2,A2)
    <=> ( A2 = bot_bot(fun(A1,bool)) ) ) ).

%----Arities (2)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

%----Helper facts (19)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(fNot(P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(fNot(P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,R: A1,Q: fun(A1,B1),P: fun(B1,C)] : ( aa(A1,C,aa(fun(A1,B1),fun(A1,C),aa(fun(B1,C),fun(fun(A1,B1),fun(A1,C)),combb(B1,C,A1),P),Q),R) = aa(B1,C,P,aa(A1,B1,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A1: $tType,C: $tType,B1: $tType,R: A1,Q: B1,P: fun(A1,fun(B1,C))] : ( aa(A1,C,combc(A1,B1,C,P,Q),R) = aa(B1,C,aa(A1,fun(B1,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A1: $tType,P: A1] : ( aa(A1,A1,combi(A1),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B1: $tType,A1: $tType,Q: B1,P: A1] : ( aa(B1,A1,combk(A1,B1,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B1: $tType,A1: $tType,R: A1,Q: fun(A1,B1),P: fun(A1,fun(B1,C))] : ( aa(A1,C,combs(A1,B1,C,P,Q),R) = aa(B1,C,aa(A1,fun(B1,C),P,R),aa(A1,B1,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A1: $tType,Y: A1,X1: A1] :
      ( ~ pp(aa(A1,bool,aa(A1,fun(A1,bool),fequal(A1),X1),Y))
      | ( X1 = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A1: $tType,Y: A1,X1: A1] :
      ( ( X1 != Y )
      | pp(aa(A1,bool,aa(A1,fun(A1,bool),fequal(A1),X1),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fimplies(P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,fimplies(P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,fimplies(P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    member(fun(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),f,pi(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_610318064e_Prof,combk(fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool),fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),arrow_1985332922le_Lin))) ).

tff(conj_1,hypothesis,
    ! [X: fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool))] :
      ( member(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),X,arrow_610318064e_Prof)
     => ! [A: arrow_411405190le_alt,B: arrow_411405190le_alt] :
          ( ( A != B )
         => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A),B),aa(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),X,i))
           => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A),B),aa(fun(arrow_159774573e_indi,fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)),fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),f,X)) ) ) ) ).

tff(conj_2,conjecture,
    arrow_987702531ctator(f,i) ).

%------------------------------------------------------------------------------
