%------------------------------------------------------------------------------
% File     : SCT189_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 111
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_111 [Bla13]

% Status   : Theorem
% Rating   : 0.67 v9.1.0, 0.33 v7.4.0, 1.00 v7.3.0, 0.75 v7.1.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  129 (  43 unt;  31 typ;   0 def)
%            Number of atoms       :  259 ( 146 equ)
%            Maximal formula atoms :   53 (   2 avg)
%            Number of connectives :  233 (  72   ~;  35   |;  37   &)
%                                         (  15 <=>;  74  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   38 (  20   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-5 aty)
%            Number of functors    :   25 (  25 usr;   6 con; 0-6 aty)
%            Number of variables   :  609 ( 564   !;   6   ?; 609   :)
%                                         (  39  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:16
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (27)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A1: $tType,B1: $tType] : ( ( fun(product_prod(A1,B1),bool) * A1 * B1 ) > $o ) ).

tff(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B1: $tType,C1: $tType,A1: $tType] : ( ( fun(B1,C1) * fun(A1,B1) ) > fun(A1,C1) ) ).

tff(sy_c_Nitpick_Orefl_H,type,
    refl: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A1: $tType,B1: $tType] : fun(A1,fun(B1,product_prod(A1,B1))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A1: $tType,C1: $tType,B1: $tType] : ( ( fun(A1,C1) * product_prod(A1,B1) ) > product_prod(C1,B1) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B1: $tType,C1: $tType,A1: $tType] : ( ( fun(B1,C1) * product_prod(A1,B1) ) > product_prod(A1,C1) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A1: $tType,B1: $tType,C1: $tType] : ( fun(product_prod(A1,B1),C1) > fun(A1,fun(B1,C1)) ) ).

tff(sy_c_Product__Type_Ofst,type,
    product_fst: 
      !>[A1: $tType,B1: $tType] : ( product_prod(A1,B1) > A1 ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A1: $tType,B1: $tType,C1: $tType] : fun(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A1: $tType,B1: $tType,T2: $tType] : fun(fun(A1,fun(B1,T2)),fun(product_prod(A1,B1),T2)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A1: $tType,B1: $tType,T2: $tType] : ( ( fun(A1,fun(B1,T2)) * product_prod(A1,B1) ) > T2 ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A1: $tType,B1: $tType,C1: $tType,D: $tType] : ( ( fun(A1,product_prod(B1,C1)) * fun(B1,fun(C1,D)) ) > fun(A1,D) ) ).

tff(sy_c_Product__Type_Osnd,type,
    product_snd: 
      !>[A1: $tType,B1: $tType] : ( product_prod(A1,B1) > B1 ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A1: $tType,B1: $tType] : ( ( fun(product_prod(A1,A1),bool) * fun(product_prod(B1,B1),bool) ) > fun(product_prod(product_prod(A1,B1),product_prod(A1,B1)),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B1: $tType] : ( ( fun(A1,B1) * A1 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_L,type,
    l: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_x,type,
    x: arrow_411405190le_alt ).

tff(sy_v_y,type,
    y: arrow_411405190le_alt ).

%----Relevant facts (93)
tff(fact_0_split__paired__All,axiom,
    ! [A1: $tType,B1: $tType,P: fun(product_prod(A1,B1),bool)] :
      ( ! [X11: product_prod(A1,B1)] : pp(aa(product_prod(A1,B1),bool,P,X11))
    <=> ! [A6: A1,B5: B1] : pp(aa(product_prod(A1,B1),bool,P,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A6),B5))) ) ).

tff(fact_1_Pair__eq,axiom,
    ! [A1: $tType,B1: $tType,B4: B1,A5: A1,B: B1,A: A1] :
      ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A),B) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A5),B4) )
    <=> ( ( A = A5 )
        & ( B = B4 ) ) ) ).

tff(fact_2_in__mkbot,axiom,
    ! [Z2: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),arrow_276188178_mkbot(La,Z2))
    <=> ( ( Ya != Z2 )
        & ( ( Xa = Z2 )
         => ( Xa != Ya ) )
        & ( ( Xa != Z2 )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La) ) ) ) ).

tff(fact_3_in__mktop,axiom,
    ! [Z2: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),arrow_424895264_mktop(La,Z2))
    <=> ( ( Xa != Z2 )
        & ( ( Ya = Z2 )
         => ( Xa != Ya ) )
        & ( ( Ya != Z2 )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La) ) ) ) ).

tff(fact_4_Pair__inject,axiom,
    ! [A1: $tType,B1: $tType,B6: B1,A7: A1,B2: B1,A2: A1] :
      ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A2),B2) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A7),B6) )
     => ~ ( ( A2 = A7 )
         => ( B2 != B6 ) ) ) ).

tff(fact_5_in__rel__def,axiom,
    ! [B1: $tType,A1: $tType,Ya: B1,Xa: A1,R: fun(product_prod(A1,B1),bool)] :
      ( in_rel(A1,B1,R,Xa,Ya)
    <=> member(product_prod(A1,B1),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),Xa),Ya),R) ) ).

tff(fact_6_notin__Lin__iff,axiom,
    ! [Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( ( Xa != Ya )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ya),Xa),La) ) ) ) ).

tff(fact_7_Lin__irrefl,axiom,
    ! [B: arrow_411405190le_alt,A: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A),B),La)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B),A),La) ) ) ).

tff(fact_8_split__paired__Ex,axiom,
    ! [A1: $tType,B1: $tType,P: fun(product_prod(A1,B1),bool)] :
      ( ? [X11: product_prod(A1,B1)] : pp(aa(product_prod(A1,B1),bool,P,X11))
    <=> ? [A6: A1,B5: B1] : pp(aa(product_prod(A1,B1),bool,P,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A6),B5))) ) ).

tff(fact_9_Nitpick_Orefl_H__def,axiom,
    ! [A1: $tType,R1: fun(product_prod(A1,A1),bool)] :
      ( refl(A1,R1)
    <=> ! [X4: A1] : member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X4),X4),R1) ) ).

tff(fact_10_in__lex__prod,axiom,
    ! [A1: $tType,B1: $tType,S: fun(product_prod(B1,B1),bool),R1: fun(product_prod(A1,A1),bool),B4: B1,A5: A1,B: B1,A: A1] :
      ( member(product_prod(product_prod(A1,B1),product_prod(A1,B1)),aa(product_prod(A1,B1),product_prod(product_prod(A1,B1),product_prod(A1,B1)),aa(product_prod(A1,B1),fun(product_prod(A1,B1),product_prod(product_prod(A1,B1),product_prod(A1,B1))),product_Pair(product_prod(A1,B1),product_prod(A1,B1)),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A),B)),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A5),B4)),lex_prod(A1,B1,R1,S))
    <=> ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),A),A5),R1)
        | ( ( A = A5 )
          & member(product_prod(B1,B1),aa(B1,product_prod(B1,B1),aa(B1,fun(B1,product_prod(B1,B1)),product_Pair(B1,B1),B),B4),S) ) ) ) ).

tff(fact_11_prod_Orecs,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,B: C1,A: B1,F11: fun(B1,fun(C1,A1))] : ( product_prod_rec(B1,C1,A1,F11,aa(C1,product_prod(B1,C1),aa(B1,fun(C1,product_prod(B1,C1)),product_Pair(B1,C1),A),B)) = aa(C1,A1,aa(B1,fun(C1,A1),F11,A),B) ) ).

tff(fact_12_mkbot__Lin,axiom,
    ! [Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(La,Xa),arrow_1985332922le_Lin) ) ).

tff(fact_13_mktop__Lin,axiom,
    ! [Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(La,Xa),arrow_1985332922le_Lin) ) ).

tff(fact_14_in__above,axiom,
    ! [Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B: arrow_411405190le_alt,A: arrow_411405190le_alt] :
      ( ( A != B )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),arrow_1158827142_above(La,A,B))
        <=> ( ( Xa != Ya )
            & ( ( Xa = B )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A),Ya),La) )
            & ( ( Xa != B )
             => ( ( ( Ya = B )
                 => ( ( Xa = A )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),A),La) ) )
                & ( ( Ya != B )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La) ) ) ) ) ) ) ) ).

tff(fact_15_prod__cases3,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,Y2: product_prod(A1,product_prod(B1,C1))] :
      ~ ! [A4: A1,B3: B1,C2: C1] : ( Y2 != aa(product_prod(B1,C1),product_prod(A1,product_prod(B1,C1)),aa(A1,fun(product_prod(B1,C1),product_prod(A1,product_prod(B1,C1))),product_Pair(A1,product_prod(B1,C1)),A4),aa(C1,product_prod(B1,C1),aa(B1,fun(C1,product_prod(B1,C1)),product_Pair(B1,C1),B3),C2)) ) ).

tff(fact_16_prod__induct3,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B1,C1)),P: fun(product_prod(A1,product_prod(B1,C1)),bool)] :
      ( ! [A4: A1,B3: B1,C2: C1] : pp(aa(product_prod(A1,product_prod(B1,C1)),bool,P,aa(product_prod(B1,C1),product_prod(A1,product_prod(B1,C1)),aa(A1,fun(product_prod(B1,C1),product_prod(A1,product_prod(B1,C1))),product_Pair(A1,product_prod(B1,C1)),A4),aa(C1,product_prod(B1,C1),aa(B1,fun(C1,product_prod(B1,C1)),product_Pair(B1,C1),B3),C2))))
     => pp(aa(product_prod(A1,product_prod(B1,C1)),bool,P,Xa)) ) ).

tff(fact_17_prod__cases4,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,D: $tType,Y2: product_prod(A1,product_prod(B1,product_prod(C1,D)))] :
      ~ ! [A4: A1,B3: B1,C2: C1,D2: D] : ( Y2 != aa(product_prod(B1,product_prod(C1,D)),product_prod(A1,product_prod(B1,product_prod(C1,D))),aa(A1,fun(product_prod(B1,product_prod(C1,D)),product_prod(A1,product_prod(B1,product_prod(C1,D)))),product_Pair(A1,product_prod(B1,product_prod(C1,D))),A4),aa(product_prod(C1,D),product_prod(B1,product_prod(C1,D)),aa(B1,fun(product_prod(C1,D),product_prod(B1,product_prod(C1,D))),product_Pair(B1,product_prod(C1,D)),B3),aa(D,product_prod(C1,D),aa(C1,fun(D,product_prod(C1,D)),product_Pair(C1,D),C2),D2))) ) ).

tff(fact_18_prod__induct4,axiom,
    ! [D: $tType,C1: $tType,B1: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B1,product_prod(C1,D))),P: fun(product_prod(A1,product_prod(B1,product_prod(C1,D))),bool)] :
      ( ! [A4: A1,B3: B1,C2: C1,D2: D] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,D))),bool,P,aa(product_prod(B1,product_prod(C1,D)),product_prod(A1,product_prod(B1,product_prod(C1,D))),aa(A1,fun(product_prod(B1,product_prod(C1,D)),product_prod(A1,product_prod(B1,product_prod(C1,D)))),product_Pair(A1,product_prod(B1,product_prod(C1,D))),A4),aa(product_prod(C1,D),product_prod(B1,product_prod(C1,D)),aa(B1,fun(product_prod(C1,D),product_prod(B1,product_prod(C1,D))),product_Pair(B1,product_prod(C1,D)),B3),aa(D,product_prod(C1,D),aa(C1,fun(D,product_prod(C1,D)),product_Pair(C1,D),C2),D2)))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,D))),bool,P,Xa)) ) ).

tff(fact_19_prod__cases5,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,D: $tType,E: $tType,Y2: product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,E))))] :
      ~ ! [A4: A1,B3: B1,C2: C1,D2: D,E1: E] : ( Y2 != aa(product_prod(B1,product_prod(C1,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,E)))),aa(A1,fun(product_prod(B1,product_prod(C1,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,E))))),product_Pair(A1,product_prod(B1,product_prod(C1,product_prod(D,E)))),A4),aa(product_prod(C1,product_prod(D,E)),product_prod(B1,product_prod(C1,product_prod(D,E))),aa(B1,fun(product_prod(C1,product_prod(D,E)),product_prod(B1,product_prod(C1,product_prod(D,E)))),product_Pair(B1,product_prod(C1,product_prod(D,E))),B3),aa(product_prod(D,E),product_prod(C1,product_prod(D,E)),aa(C1,fun(product_prod(D,E),product_prod(C1,product_prod(D,E))),product_Pair(C1,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D2),E1)))) ) ).

tff(fact_20_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C1: $tType,B1: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,E)))),P: fun(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,E)))),bool)] :
      ( ! [A4: A1,B3: B1,C2: C1,D2: D,E1: E] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,E)))),bool,P,aa(product_prod(B1,product_prod(C1,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,E)))),aa(A1,fun(product_prod(B1,product_prod(C1,product_prod(D,E))),product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,E))))),product_Pair(A1,product_prod(B1,product_prod(C1,product_prod(D,E)))),A4),aa(product_prod(C1,product_prod(D,E)),product_prod(B1,product_prod(C1,product_prod(D,E))),aa(B1,fun(product_prod(C1,product_prod(D,E)),product_prod(B1,product_prod(C1,product_prod(D,E)))),product_Pair(B1,product_prod(C1,product_prod(D,E))),B3),aa(product_prod(D,E),product_prod(C1,product_prod(D,E)),aa(C1,fun(product_prod(D,E),product_prod(C1,product_prod(D,E))),product_Pair(C1,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D2),E1))))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,E)))),bool,P,Xa)) ) ).

tff(fact_21_prod__cases6,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,D: $tType,E: $tType,F2: $tType,Y2: product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A4: A1,B3: B1,C2: C1,D2: D,E1: E,F3: F2] : ( Y2 != aa(product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2))))),aa(A1,fun(product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))))),product_Pair(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2))))),A4),aa(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))),aa(B1,fun(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2))))),product_Pair(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))),B3),aa(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2))),aa(C1,fun(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2)))),product_Pair(C1,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D2),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_22_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C1: $tType,B1: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2))))),P: fun(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A4: A1,B3: B1,C2: C1,D2: D,E1: E,F3: F2] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool,P,aa(product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2))))),aa(A1,fun(product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))))),product_Pair(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2))))),A4),aa(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))),aa(B1,fun(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2))))),product_Pair(B1,product_prod(C1,product_prod(D,product_prod(E,F2)))),B3),aa(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2))),aa(C1,fun(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2)))),product_Pair(C1,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D2),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool,P,Xa)) ) ).

tff(fact_23_in__below,axiom,
    ! [Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B: arrow_411405190le_alt,A: arrow_411405190le_alt] :
      ( ( A != B )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),arrow_319942042_below(La,A,B))
        <=> ( ( Xa != Ya )
            & ( ( Ya = A )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),B),La) )
            & ( ( Ya != A )
             => ( ( ( Xa = A )
                 => ( ( Ya = B )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B),Ya),La) ) )
                & ( ( Xa != A )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La) ) ) ) ) ) ) ) ).

tff(fact_24_linear__alt,axiom,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin) ).

tff(fact_25_below__Lin,axiom,
    ! [La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt] :
      ( ( Xa != Ya )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
       => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_319942042_below(La,Xa,Ya),arrow_1985332922le_Lin) ) ) ).

tff(fact_26_PairE,axiom,
    ! [A1: $tType,B1: $tType,P2: product_prod(A1,B1)] :
      ~ ! [X: A1,Y: B1] : ( P2 != aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X),Y) ) ).

tff(fact_27_prod_Oexhaust,axiom,
    ! [A1: $tType,B1: $tType,Y2: product_prod(A1,B1)] :
      ~ ! [A4: A1,B3: B1] : ( Y2 != aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3) ) ).

tff(fact_28_internal__split__conv,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,B: C1,A: B1,C: fun(B1,fun(C1,A1))] : ( aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),produc1605651328_split(B1,C1,A1),C),aa(C1,product_prod(B1,C1),aa(B1,fun(C1,product_prod(B1,C1)),product_Pair(B1,C1),A),B)) = aa(C1,A1,aa(B1,fun(C1,A1),C,A),B) ) ).

tff(fact_29_curry__conv,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,B: C1,A: B1,F: fun(product_prod(B1,C1),A1)] : ( aa(C1,A1,aa(B1,fun(C1,A1),product_curry(B1,C1,A1,F),A),B) = aa(product_prod(B1,C1),A1,F,aa(C1,product_prod(B1,C1),aa(B1,fun(C1,product_prod(B1,C1)),product_Pair(B1,C1),A),B)) ) ).

tff(fact_30_curryI,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(product_prod(A1,B1),bool,F,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A),B)))
     => pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A),B)) ) ).

tff(fact_31_curryE,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A),B))
     => pp(aa(product_prod(A1,B1),bool,F,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A),B))) ) ).

tff(fact_32_curryD,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A),B))
     => pp(aa(product_prod(A1,B1),bool,F,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A),B))) ) ).

tff(fact_33_internal__split__def,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType] : ( produc1605651328_split(A1,B1,C1) = product_prod_case(A1,B1,C1) ) ).

tff(fact_34_apsnd__conv,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,Ya: C1,Xa: A1,F: fun(C1,B1)] : ( product_apsnd(C1,B1,A1,F,aa(C1,product_prod(A1,C1),aa(A1,fun(C1,product_prod(A1,C1)),product_Pair(A1,C1),Xa),Ya)) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),Xa),aa(C1,B1,F,Ya)) ) ).

tff(fact_35_apfst__conv,axiom,
    ! [C1: $tType,A1: $tType,B1: $tType,Ya: B1,Xa: C1,F: fun(C1,A1)] : ( product_apfst(C1,A1,B1,F,aa(B1,product_prod(C1,B1),aa(C1,fun(B1,product_prod(C1,B1)),product_Pair(C1,B1),Xa),Ya)) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),aa(C1,A1,F,Xa)),Ya) ) ).

tff(fact_36_surj__pair,axiom,
    ! [A1: $tType,B1: $tType,P2: product_prod(A1,B1)] :
    ? [X: A1,Y: B1] : ( P2 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X),Y) ) ).

tff(fact_37_Pair__scomp,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,F: fun(C1,fun(A1,B1)),Xa: C1] : ( product_scomp(A1,C1,A1,B1,aa(C1,fun(A1,product_prod(C1,A1)),product_Pair(C1,A1),Xa),F) = aa(C1,fun(A1,B1),F,Xa) ) ).

tff(fact_38_split__curry,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,F: fun(product_prod(A1,B1),C1)] : ( aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),product_curry(A1,B1,C1,F)) = F ) ).

tff(fact_39_splitI,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),F,A),B))
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A),B))) ) ).

tff(fact_40_prod__caseI,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F11: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),F11,A),B))
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F11),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A),B))) ) ).

tff(fact_41_mem__splitI,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,B: C1,A: B1,C: fun(B1,fun(C1,fun(A1,bool))),Z2: A1] :
      ( member(A1,Z2,aa(C1,fun(A1,bool),aa(B1,fun(C1,fun(A1,bool)),C,A),B))
     => member(A1,Z2,aa(product_prod(B1,C1),fun(A1,bool),aa(fun(B1,fun(C1,fun(A1,bool))),fun(product_prod(B1,C1),fun(A1,bool)),product_prod_case(B1,C1,fun(A1,bool)),C),aa(C1,product_prod(B1,C1),aa(B1,fun(C1,product_prod(B1,C1)),product_Pair(B1,C1),A),B))) ) ).

tff(fact_42_split__conv,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,B: C1,A: B1,F: fun(B1,fun(C1,A1))] : ( aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),product_prod_case(B1,C1,A1),F),aa(C1,product_prod(B1,C1),aa(B1,fun(C1,product_prod(B1,C1)),product_Pair(B1,C1),A),B)) = aa(C1,A1,aa(B1,fun(C1,A1),F,A),B) ) ).

tff(fact_43_scomp__apply,axiom,
    ! [A1: $tType,C1: $tType,D: $tType,B1: $tType,Xa: B1,G: fun(C1,fun(D,A1)),F: fun(B1,product_prod(C1,D))] : ( aa(B1,A1,product_scomp(B1,C1,D,A1,F,G),Xa) = aa(product_prod(C1,D),A1,aa(fun(C1,fun(D,A1)),fun(product_prod(C1,D),A1),product_prod_case(C1,D,A1),G),aa(B1,product_prod(C1,D),F,Xa)) ) ).

tff(fact_44_scomp__def,axiom,
    ! [B1: $tType,C1: $tType,D: $tType,A1: $tType,G: fun(C1,fun(D,B1)),F: fun(A1,product_prod(C1,D)),X1: A1] : ( aa(A1,B1,product_scomp(A1,C1,D,B1,F,G),X1) = aa(product_prod(C1,D),B1,aa(fun(C1,fun(D,B1)),fun(product_prod(C1,D),B1),product_prod_case(C1,D,B1),G),aa(A1,product_prod(C1,D),F,X1)) ) ).

tff(fact_45_apsnd__apfst__commute,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,D: $tType,P1: product_prod(D,C1),G: fun(D,A1),F: fun(C1,B1)] : ( product_apsnd(C1,B1,A1,F,product_apfst(D,A1,C1,G,P1)) = product_apfst(D,A1,B1,G,product_apsnd(C1,B1,D,F,P1)) ) ).

tff(fact_46_split__weak__cong,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,C: fun(A1,fun(B1,C1)),Q1: product_prod(A1,B1),P1: product_prod(A1,B1)] :
      ( ( P1 = Q1 )
     => ( aa(product_prod(A1,B1),C1,aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),C),P1) = aa(product_prod(A1,B1),C1,aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),C),Q1) ) ) ).

tff(fact_47_splitD,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F: fun(A1,fun(B1,bool))] :
      ( pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A),B)))
     => pp(aa(B1,bool,aa(A1,fun(B1,bool),F,A),B)) ) ).

tff(fact_48_splitD_H,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,C: C1,B: B1,A: A1,R: fun(A1,fun(B1,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A1,B1),fun(C1,bool),aa(fun(A1,fun(B1,fun(C1,bool))),fun(product_prod(A1,B1),fun(C1,bool)),product_prod_case(A1,B1,fun(C1,bool)),R),aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A),B)),C))
     => pp(aa(C1,bool,aa(B1,fun(C1,bool),aa(A1,fun(B1,fun(C1,bool)),R,A),B),C)) ) ).

tff(fact_49_prod_Osimps_I2_J,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,B: C1,A: B1,F11: fun(B1,fun(C1,A1))] : ( aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),product_prod_case(B1,C1,A1),F11),aa(C1,product_prod(B1,C1),aa(B1,fun(C1,product_prod(B1,C1)),product_Pair(B1,C1),A),B)) = aa(C1,A1,aa(B1,fun(C1,A1),F11,A),B) ) ).

tff(fact_50_scomp__Pair,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,Xa: fun(A1,product_prod(B1,C1))] : ( product_scomp(A1,B1,C1,product_prod(B1,C1),Xa,product_Pair(B1,C1)) = Xa ) ).

tff(fact_51_curry__split,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,F: fun(A1,fun(B1,C1))] : ( product_curry(A1,B1,C1,aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),F)) = F ) ).

tff(fact_52_splitE,axiom,
    ! [A1: $tType,B1: $tType,P1: product_prod(A1,B1),C: fun(A1,fun(B1,bool))] :
      ( pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),C),P1))
     => ~ ! [X: A1,Y: B1] :
            ( ( P1 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X),Y) )
           => ~ pp(aa(B1,bool,aa(A1,fun(B1,bool),C,X),Y)) ) ) ).

tff(fact_53_splitI2,axiom,
    ! [B1: $tType,A1: $tType,C: fun(A1,fun(B1,bool)),P1: product_prod(A1,B1)] :
      ( ! [A4: A1,B3: B1] :
          ( ( P1 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3) )
         => pp(aa(B1,bool,aa(A1,fun(B1,bool),C,A4),B3)) )
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),C),P1)) ) ).

tff(fact_54_mem__splitI2,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,C: fun(A1,fun(B1,fun(C1,bool))),Z2: C1,P1: product_prod(A1,B1)] :
      ( ! [A4: A1,B3: B1] :
          ( ( P1 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3) )
         => member(C1,Z2,aa(B1,fun(C1,bool),aa(A1,fun(B1,fun(C1,bool)),C,A4),B3)) )
     => member(C1,Z2,aa(product_prod(A1,B1),fun(C1,bool),aa(fun(A1,fun(B1,fun(C1,bool))),fun(product_prod(A1,B1),fun(C1,bool)),product_prod_case(A1,B1,fun(C1,bool)),C),P1)) ) ).

tff(fact_55_splitI2_H,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,Xa: C1,C: fun(A1,fun(B1,fun(C1,bool))),P1: product_prod(A1,B1)] :
      ( ! [A4: A1,B3: B1] :
          ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A4),B3) = P1 )
         => pp(aa(C1,bool,aa(B1,fun(C1,bool),aa(A1,fun(B1,fun(C1,bool)),C,A4),B3),Xa)) )
     => pp(aa(C1,bool,aa(product_prod(A1,B1),fun(C1,bool),aa(fun(A1,fun(B1,fun(C1,bool))),fun(product_prod(A1,B1),fun(C1,bool)),product_prod_case(A1,B1,fun(C1,bool)),C),P1),Xa)) ) ).

tff(fact_56_mem__splitE,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,P1: product_prod(B1,C1),C: fun(B1,fun(C1,fun(A1,bool))),Z2: A1] :
      ( member(A1,Z2,aa(product_prod(B1,C1),fun(A1,bool),aa(fun(B1,fun(C1,fun(A1,bool))),fun(product_prod(B1,C1),fun(A1,bool)),product_prod_case(B1,C1,fun(A1,bool)),C),P1))
     => ~ ! [X: B1,Y: C1] :
            ( ( P1 = aa(C1,product_prod(B1,C1),aa(B1,fun(C1,product_prod(B1,C1)),product_Pair(B1,C1),X),Y) )
           => ~ member(A1,Z2,aa(C1,fun(A1,bool),aa(B1,fun(C1,fun(A1,bool)),C,X),Y)) ) ) ).

tff(fact_57_splitE_H,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,Z2: C1,P1: product_prod(A1,B1),C: fun(A1,fun(B1,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A1,B1),fun(C1,bool),aa(fun(A1,fun(B1,fun(C1,bool))),fun(product_prod(A1,B1),fun(C1,bool)),product_prod_case(A1,B1,fun(C1,bool)),C),P1),Z2))
     => ~ ! [X: A1,Y: B1] :
            ( ( P1 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X),Y) )
           => ~ pp(aa(C1,bool,aa(B1,fun(C1,bool),aa(A1,fun(B1,fun(C1,bool)),C,X),Y),Z2)) ) ) ).

tff(fact_58_splitE2,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,Z2: product_prod(B1,C1),P: fun(B1,fun(C1,A1)),Q: fun(A1,bool)] :
      ( pp(aa(A1,bool,Q,aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),product_prod_case(B1,C1,A1),P),Z2)))
     => ~ ! [X: B1,Y: C1] :
            ( ( Z2 = aa(C1,product_prod(B1,C1),aa(B1,fun(C1,product_prod(B1,C1)),product_Pair(B1,C1),X),Y) )
           => ~ pp(aa(A1,bool,Q,aa(C1,A1,aa(B1,fun(C1,A1),P,X),Y))) ) ) ).

tff(fact_59_split__cong,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,P1: product_prod(A1,B1),G: fun(A1,fun(B1,C1)),F: fun(A1,fun(B1,C1)),Q1: product_prod(A1,B1)] :
      ( ! [X: A1,Y: B1] :
          ( ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X),Y) = Q1 )
         => ( aa(B1,C1,aa(A1,fun(B1,C1),F,X),Y) = aa(B1,C1,aa(A1,fun(B1,C1),G,X),Y) ) )
     => ( ( P1 = Q1 )
       => ( aa(product_prod(A1,B1),C1,aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),F),P1) = aa(product_prod(A1,B1),C1,aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),G),Q1) ) ) ) ).

tff(fact_60_apfst__convE,axiom,
    ! [C1: $tType,A1: $tType,B1: $tType,P1: product_prod(C1,B1),F: fun(C1,A1),Q1: product_prod(A1,B1)] :
      ( ( Q1 = product_apfst(C1,A1,B1,F,P1) )
     => ~ ! [X: C1,Y: B1] :
            ( ( P1 = aa(B1,product_prod(C1,B1),aa(C1,fun(B1,product_prod(C1,B1)),product_Pair(C1,B1),X),Y) )
           => ( Q1 != aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),aa(C1,A1,F,X)),Y) ) ) ) ).

tff(fact_61_apsnd__apfst,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,D: $tType,Xa: product_prod(D,C1),G: fun(D,A1),F: fun(C1,B1)] : ( product_apsnd(C1,B1,A1,F,product_apfst(D,A1,C1,G,Xa)) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),aa(D,A1,G,product_fst(D,C1,Xa))),aa(C1,B1,F,product_snd(D,C1,Xa))) ) ).

tff(fact_62_apfst__apsnd,axiom,
    ! [A1: $tType,B1: $tType,D: $tType,C1: $tType,Xa: product_prod(C1,D),G: fun(D,B1),F: fun(C1,A1)] : ( product_apfst(C1,A1,B1,F,product_apsnd(D,B1,C1,G,Xa)) = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),aa(C1,A1,F,product_fst(C1,D,Xa))),aa(D,B1,G,product_snd(C1,D,Xa))) ) ).

tff(fact_63_fst__apsnd,axiom,
    ! [B1: $tType,C1: $tType,A1: $tType,Xa: product_prod(A1,C1),F: fun(C1,B1)] : ( product_fst(A1,B1,product_apsnd(C1,B1,A1,F,Xa)) = product_fst(A1,C1,Xa) ) ).

tff(fact_64_fst__apfst,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,Xa: product_prod(C1,B1),F: fun(C1,A1)] : ( product_fst(A1,B1,product_apfst(C1,A1,B1,F,Xa)) = aa(C1,A1,F,product_fst(C1,B1,Xa)) ) ).

tff(fact_65_apfst__eq__conv,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,G: fun(C1,A1),Xa: product_prod(C1,B1),F: fun(C1,A1)] :
      ( ( product_apfst(C1,A1,B1,F,Xa) = product_apfst(C1,A1,B1,G,Xa) )
    <=> ( aa(C1,A1,F,product_fst(C1,B1,Xa)) = aa(C1,A1,G,product_fst(C1,B1,Xa)) ) ) ).

tff(fact_66_apsnd__eq__conv,axiom,
    ! [B1: $tType,C1: $tType,A1: $tType,G: fun(C1,B1),Xa: product_prod(A1,C1),F: fun(C1,B1)] :
      ( ( product_apsnd(C1,B1,A1,F,Xa) = product_apsnd(C1,B1,A1,G,Xa) )
    <=> ( aa(C1,B1,F,product_snd(A1,C1,Xa)) = aa(C1,B1,G,product_snd(A1,C1,Xa)) ) ) ).

tff(fact_67_snd__apsnd,axiom,
    ! [A1: $tType,C1: $tType,B1: $tType,Xa: product_prod(B1,C1),F: fun(C1,A1)] : ( product_snd(B1,A1,product_apsnd(C1,A1,B1,F,Xa)) = aa(C1,A1,F,product_snd(B1,C1,Xa)) ) ).

tff(fact_68_snd__apfst,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,Xa: product_prod(C1,A1),F: fun(C1,B1)] : ( product_snd(B1,A1,product_apfst(C1,B1,A1,F,Xa)) = product_snd(C1,A1,Xa) ) ).

tff(fact_69_fst__conv,axiom,
    ! [B1: $tType,A1: $tType,B2: B1,A2: A1] : ( product_fst(A1,B1,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),A2),B2)) = A2 ) ).

tff(fact_70_fst__eqD,axiom,
    ! [B1: $tType,A1: $tType,A2: A1,Y2: B1,X3: A1] :
      ( ( product_fst(A1,B1,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),X3),Y2)) = A2 )
     => ( X3 = A2 ) ) ).

tff(fact_71_surjective__pairing,axiom,
    ! [B1: $tType,A1: $tType,T1: product_prod(A1,B1)] : ( T1 = aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),product_fst(A1,B1,T1)),product_snd(A1,B1,T1)) ) ).

tff(fact_72_pair__collapse,axiom,
    ! [B1: $tType,A1: $tType,P2: product_prod(A1,B1)] : ( aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),product_fst(A1,B1,P2)),product_snd(A1,B1,P2)) = P2 ) ).

tff(fact_73_prod__eqI,axiom,
    ! [B1: $tType,A1: $tType,Q2: product_prod(A1,B1),P2: product_prod(A1,B1)] :
      ( ( product_fst(A1,B1,P2) = product_fst(A1,B1,Q2) )
     => ( ( product_snd(A1,B1,P2) = product_snd(A1,B1,Q2) )
       => ( P2 = Q2 ) ) ) ).

tff(fact_74_prod__eq__iff,axiom,
    ! [B1: $tType,A1: $tType,T: product_prod(A1,B1),S: product_prod(A1,B1)] :
      ( ( S = T )
    <=> ( ( product_fst(A1,B1,S) = product_fst(A1,B1,T) )
        & ( product_snd(A1,B1,S) = product_snd(A1,B1,T) ) ) ) ).

tff(fact_75_ext,axiom,
    ! [B1: $tType,A1: $tType,G: fun(A1,B1),F: fun(A1,B1)] :
      ( ! [X: A1] : ( aa(A1,B1,F,X) = aa(A1,B1,G,X) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A1: $tType,A3: fun(A1,bool),Xa: A1] :
      ( member(A1,Xa,A3)
    <=> pp(aa(A1,bool,A3,Xa)) ) ).

tff(fact_77_snd__conv,axiom,
    ! [B1: $tType,A1: $tType,B2: A1,A2: B1] : ( product_snd(B1,A1,aa(A1,product_prod(B1,A1),aa(B1,fun(A1,product_prod(B1,A1)),product_Pair(B1,A1),A2),B2)) = B2 ) ).

tff(fact_78_snd__eqD,axiom,
    ! [B1: $tType,A1: $tType,A2: A1,Y2: A1,X3: B1] :
      ( ( product_snd(B1,A1,aa(A1,product_prod(B1,A1),aa(B1,fun(A1,product_prod(B1,A1)),product_Pair(B1,A1),X3),Y2)) = A2 )
     => ( Y2 = A2 ) ) ).

tff(fact_79_prod__case__beta,axiom,
    ! [A1: $tType,C1: $tType,B1: $tType,P1: product_prod(B1,C1),F: fun(B1,fun(C1,A1))] : ( aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),product_prod_case(B1,C1,A1),F),P1) = aa(C1,A1,aa(B1,fun(C1,A1),F,product_fst(B1,C1,P1)),product_snd(B1,C1,P1)) ) ).

tff(fact_80_conjI__realizer,axiom,
    ! [A1: $tType,B1: $tType,Q1: B1,Q: fun(B1,bool),P1: A1,P: fun(A1,bool)] :
      ( pp(aa(A1,bool,P,P1))
     => ( pp(aa(B1,bool,Q,Q1))
       => ( pp(aa(A1,bool,P,product_fst(A1,B1,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),P1),Q1))))
          & pp(aa(B1,bool,Q,product_snd(A1,B1,aa(B1,product_prod(A1,B1),aa(A1,fun(B1,product_prod(A1,B1)),product_Pair(A1,B1),P1),Q1)))) ) ) ) ).

tff(fact_81_exI__realizer,axiom,
    ! [B1: $tType,A1: $tType,Xa: B1,Ya: A1,P: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),P,Ya),Xa))
     => pp(aa(B1,bool,aa(A1,fun(B1,bool),P,product_snd(B1,A1,aa(A1,product_prod(B1,A1),aa(B1,fun(A1,product_prod(B1,A1)),product_Pair(B1,A1),Xa),Ya))),product_fst(B1,A1,aa(A1,product_prod(B1,A1),aa(B1,fun(A1,product_prod(B1,A1)),product_Pair(B1,A1),Xa),Ya)))) ) ).

tff(fact_82_exE__realizer_H,axiom,
    ! [A1: $tType,B1: $tType,P1: product_prod(B1,A1),P: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),P,product_snd(B1,A1,P1)),product_fst(B1,A1,P1)))
     => ~ ! [X: B1,Y: A1] : ~ pp(aa(B1,bool,aa(A1,fun(B1,bool),P,Y),X)) ) ).

tff(fact_83_split__comp,axiom,
    ! [D: $tType,A1: $tType,C1: $tType,B1: $tType,Xa: product_prod(B1,C1),G: fun(B1,D),F: fun(D,fun(C1,A1))] : ( aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),product_prod_case(B1,C1,A1),comp(D,fun(C1,A1),B1,F,G)),Xa) = aa(C1,A1,aa(D,fun(C1,A1),F,aa(B1,D,G,product_fst(B1,C1,Xa))),product_snd(B1,C1,Xa)) ) ).

tff(fact_84_comp__cong,axiom,
    ! [C1: $tType,B1: $tType,D: $tType,A1: $tType,E: $tType,X2: E,G1: fun(E,D),F1: fun(D,A1),Xa: C1,G: fun(C1,B1),F: fun(B1,A1)] :
      ( ( aa(B1,A1,F,aa(C1,B1,G,Xa)) = aa(D,A1,F1,aa(E,D,G1,X2)) )
     => ( aa(C1,A1,comp(B1,A1,C1,F,G),Xa) = aa(E,A1,comp(D,A1,E,F1,G1),X2) ) ) ).

tff(fact_85_apfst__compose,axiom,
    ! [C1: $tType,A1: $tType,B1: $tType,D: $tType,Xa: product_prod(D,B1),G: fun(D,C1),F: fun(C1,A1)] : ( product_apfst(C1,A1,B1,F,product_apfst(D,C1,B1,G,Xa)) = product_apfst(D,A1,B1,comp(C1,A1,D,F,G),Xa) ) ).

tff(fact_86_apsnd__compose,axiom,
    ! [C1: $tType,B1: $tType,D: $tType,A1: $tType,Xa: product_prod(A1,D),G: fun(D,C1),F: fun(C1,B1)] : ( product_apsnd(C1,B1,A1,F,product_apsnd(D,C1,A1,G,Xa)) = product_apsnd(D,B1,A1,comp(C1,B1,D,F,G),Xa) ) ).

tff(fact_87_o__apply,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,Xa: C1,G: fun(C1,B1),F: fun(B1,A1)] : ( aa(C1,A1,comp(B1,A1,C1,F,G),Xa) = aa(B1,A1,F,aa(C1,B1,G,Xa)) ) ).

tff(fact_88_o__def,axiom,
    ! [B1: $tType,C1: $tType,A1: $tType,G: fun(A1,C1),F: fun(C1,B1),X1: A1] : ( aa(A1,B1,comp(C1,B1,A1,F,G),X1) = aa(C1,B1,F,aa(A1,C1,G,X1)) ) ).

tff(fact_89_o__eq__elim,axiom,
    ! [C1: $tType,B1: $tType,D: $tType,A1: $tType,D1: fun(A1,D),C: fun(D,B1),B: fun(A1,C1),A: fun(C1,B1)] :
      ( ( comp(C1,B1,A1,A,B) = comp(D,B1,A1,C,D1) )
     => ! [V1: A1] : ( aa(C1,B1,A,aa(A1,C1,B,V1)) = aa(D,B1,C,aa(A1,D,D1,V1)) ) ) ).

tff(fact_90_o__eq__dest,axiom,
    ! [C1: $tType,B1: $tType,D: $tType,A1: $tType,V: A1,D1: fun(A1,D),C: fun(D,B1),B: fun(A1,C1),A: fun(C1,B1)] :
      ( ( comp(C1,B1,A1,A,B) = comp(D,B1,A1,C,D1) )
     => ( aa(C1,B1,A,aa(A1,C1,B,V)) = aa(D,B1,C,aa(A1,D,D1,V)) ) ) ).

tff(fact_91_o__assoc,axiom,
    ! [C1: $tType,B1: $tType,D: $tType,A1: $tType,H: fun(A1,D),G: fun(D,C1),F: fun(C1,B1)] : ( comp(C1,B1,A1,F,comp(D,C1,A1,G,H)) = comp(D,B1,A1,comp(C1,B1,D,F,G),H) ) ).

tff(fact_92_o__eq__dest__lhs,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,V: A1,C: fun(A1,B1),B: fun(A1,C1),A: fun(C1,B1)] :
      ( ( comp(C1,B1,A1,A,B) = C )
     => ( aa(C1,B1,A,aa(A1,C1,B,V)) = aa(A1,B1,C,V) ) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    x != y ).

tff(conj_1,hypothesis,
    ( ! [X1: arrow_411405190le_alt,Y1: arrow_411405190le_alt] :
        ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),l)
       => ! [Z1: arrow_411405190le_alt] :
            ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),Z1),l)
           => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Z1),l) ) )
    & ! [X1: arrow_411405190le_alt] : ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),X1),l)
    & ! [X1: arrow_411405190le_alt,Y1: arrow_411405190le_alt] :
        ( ( X1 != Y1 )
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),l)
          | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),X1),l) ) ) ) ).

tff(conj_2,conjecture,
    ( ! [X: arrow_411405190le_alt,Y: arrow_411405190le_alt] :
        ( ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y),l)
          | ( X = y )
          | ( Y = y )
          | ! [Z: arrow_411405190le_alt] :
              ( ( ( Y != x )
                | ( Z != y )
                | ( X = x )
                | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),x),l) )
              & ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),Z),l)
                | ( Z = y )
                | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Z),l) )
              & ( ( Z != y )
                | ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),x),l)
                | ( X = x )
                | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),x),l) ) ) )
        & ( ( Y != y )
          | ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),x),l)
          | ( X = y )
          | ! [Z: arrow_411405190le_alt] :
              ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),x),Z),l)
              | ( Z = y )
              | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Z),l) ) )
        & ( ( X != y )
          | ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),x),Y),l)
          | ( Y = y )
          | ! [Z: arrow_411405190le_alt] :
              ( ( ( Y != x )
                | ( Z != y ) )
              & ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),Z),l)
                | ( Z = y )
                | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),x),Z),l) )
              & ( ( Z != y )
                | ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),x),l) ) ) ) )
    & ! [X: arrow_411405190le_alt,Y: arrow_411405190le_alt] :
        ( ( X = Y )
        | ( ( X = x )
          & ( Y = y ) )
        | ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y),l)
          & ( X != y )
          & ( Y != y ) )
        | ( ( Y = y )
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),x),l)
          & ( X != y ) )
        | ( ( X = y )
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),x),Y),l)
          & ( Y != y ) )
        | ( ( Y = x )
          & ( X = y ) )
        | ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),X),l)
          & ( Y != y )
          & ( X != y ) )
        | ( ( X = y )
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),x),l)
          & ( Y != y ) )
        | ( ( Y = y )
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),x),X),l)
          & ( X != y ) ) ) ) ).

%------------------------------------------------------------------------------
