%------------------------------------------------------------------------------
% File     : SCT187_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 105
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_105 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.33 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  129 (  31 unt;  35 typ;   0 def)
%            Number of atoms       :  269 ( 113 equ)
%            Maximal formula atoms :   47 (   2 avg)
%            Number of connectives :  246 (  71   ~;  32   |;  34   &)
%                                         (  24 <=>;  85  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   43 (  24   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-5 aty)
%            Number of functors    :   25 (  25 usr;   6 con; 0-6 aty)
%            Number of variables   :  530 ( 483   !;   6   ?; 530   :)
%                                         (  41  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:19
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (31)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A: $tType,B2: $tType] : ( ( fun(product_prod(A,B2),bool) * A * B2 ) > $o ) ).

tff(sy_c_Nitpick_Orefl_H,type,
    refl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B2: $tType] : fun(A,fun(B2,product_prod(A,B2))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A: $tType,C1: $tType,B2: $tType] : ( ( fun(A,C1) * product_prod(A,B2) ) > product_prod(C1,B2) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B2: $tType,C1: $tType,A: $tType] : ( ( fun(B2,C1) * product_prod(A,B2) ) > product_prod(A,C1) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B2: $tType,C1: $tType] : ( fun(product_prod(A,B2),C1) > fun(A,fun(B2,C1)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B2: $tType,C1: $tType] : fun(fun(A,fun(B2,C1)),fun(product_prod(A,B2),C1)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A: $tType,B2: $tType,T: $tType] : fun(fun(A,fun(B2,T)),fun(product_prod(A,B2),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B2: $tType,T: $tType] : ( ( fun(A,fun(B2,T)) * product_prod(A,B2) ) > T ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A: $tType,B2: $tType,C1: $tType,D: $tType] : ( ( fun(A,product_prod(B2,C1)) * fun(B2,fun(C1,D)) ) > fun(A,D) ) ).

tff(sy_c_Relation_OId__on,type,
    id_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oantisym,type,
    antisym: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Oconverse,type,
    converse: 
      !>[A: $tType,B2: $tType] : ( fun(product_prod(A,B2),bool) > fun(product_prod(B2,A),bool) ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B2: $tType,A: $tType] : ( ( fun(product_prod(B2,B2),bool) * fun(A,B2) ) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Osym,type,
    sym: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A: $tType,B2: $tType] : ( ( fun(product_prod(A,A),bool) * fun(product_prod(B2,B2),bool) ) > fun(product_prod(product_prod(A,B2),product_prod(A,B2)),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_L,type,
    l: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_x,type,
    x: arrow_411405190le_alt ).

tff(sy_v_y,type,
    y: arrow_411405190le_alt ).

%----Relevant facts (89)
tff(fact_0_split__paired__All,axiom,
    ! [A: $tType,B2: $tType,P1: fun(product_prod(A,B2),bool)] :
      ( ! [X11: product_prod(A,B2)] : pp(aa(product_prod(A,B2),bool,P1,X11))
    <=> ! [A5: A,B4: B2] : pp(aa(product_prod(A,B2),bool,P1,aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A5),B4))) ) ).

tff(fact_1_Pair__eq,axiom,
    ! [A: $tType,B2: $tType,B3: B2,A4: A,B1: B2,A3: A] :
      ( ( aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1) = aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A4),B3) )
    <=> ( ( A3 = A4 )
        & ( B1 = B3 ) ) ) ).

tff(fact_2_in__mkbot,axiom,
    ! [Z2: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),arrow_276188178_mkbot(La,Z2))
    <=> ( ( Ya != Z2 )
        & ( ( Xa = Z2 )
         => ( Xa != Ya ) )
        & ( ( Xa != Z2 )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La) ) ) ) ).

tff(fact_3_in__mktop,axiom,
    ! [Z2: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),arrow_424895264_mktop(La,Z2))
    <=> ( ( Xa != Z2 )
        & ( ( Ya = Z2 )
         => ( Xa != Ya ) )
        & ( ( Ya != Z2 )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La) ) ) ) ).

tff(fact_4_Pair__inject,axiom,
    ! [A: $tType,B2: $tType,B6: B2,A7: A,B5: B2,A6: A] :
      ( ( aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A6),B5) = aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A7),B6) )
     => ~ ( ( A6 = A7 )
         => ( B5 != B6 ) ) ) ).

tff(fact_5_notin__Lin__iff,axiom,
    ! [Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( ( Xa != Ya )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ya),Xa),La) ) ) ) ).

tff(fact_6_Lin__irrefl,axiom,
    ! [B1: arrow_411405190le_alt,A3: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),B1),La)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B1),A3),La) ) ) ).

tff(fact_7_in__rel__def,axiom,
    ! [B2: $tType,A: $tType,Ya: B2,Xa: A,R1: fun(product_prod(A,B2),bool)] :
      ( in_rel(A,B2,R1,Xa,Ya)
    <=> member(product_prod(A,B2),aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),Xa),Ya),R1) ) ).

tff(fact_8_split__paired__Ex,axiom,
    ! [A: $tType,B2: $tType,P1: fun(product_prod(A,B2),bool)] :
      ( ? [X11: product_prod(A,B2)] : pp(aa(product_prod(A,B2),bool,P1,X11))
    <=> ? [A5: A,B4: B2] : pp(aa(product_prod(A,B2),bool,P1,aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A5),B4))) ) ).

tff(fact_9_Nitpick_Orefl_H__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( refl(A,R)
    <=> ! [X2: A] : member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),X2),R) ) ).

tff(fact_10_in__lex__prod,axiom,
    ! [A: $tType,B2: $tType,S: fun(product_prod(B2,B2),bool),R: fun(product_prod(A,A),bool),B3: B2,A4: A,B1: B2,A3: A] :
      ( member(product_prod(product_prod(A,B2),product_prod(A,B2)),aa(product_prod(A,B2),product_prod(product_prod(A,B2),product_prod(A,B2)),aa(product_prod(A,B2),fun(product_prod(A,B2),product_prod(product_prod(A,B2),product_prod(A,B2))),product_Pair(product_prod(A,B2),product_prod(A,B2)),aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1)),aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A4),B3)),lex_prod(A,B2,R,S))
    <=> ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A3),A4),R)
        | ( ( A3 = A4 )
          & member(product_prod(B2,B2),aa(B2,product_prod(B2,B2),aa(B2,fun(B2,product_prod(B2,B2)),product_Pair(B2,B2),B1),B3),S) ) ) ) ).

tff(fact_11_prod_Orecs,axiom,
    ! [B2: $tType,A: $tType,C1: $tType,B1: C1,A3: B2,F1: fun(B2,fun(C1,A))] : ( product_prod_rec(B2,C1,A,F1,aa(C1,product_prod(B2,C1),aa(B2,fun(C1,product_prod(B2,C1)),product_Pair(B2,C1),A3),B1)) = aa(C1,A,aa(B2,fun(C1,A),F1,A3),B1) ) ).

tff(fact_12_mkbot__Lin,axiom,
    ! [Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_276188178_mkbot(La,Xa),arrow_1985332922le_Lin) ) ).

tff(fact_13_mktop__Lin,axiom,
    ! [Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(La,Xa),arrow_1985332922le_Lin) ) ).

tff(fact_14_in__below,axiom,
    ! [Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B1: arrow_411405190le_alt,A3: arrow_411405190le_alt] :
      ( ( A3 != B1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),arrow_319942042_below(La,A3,B1))
        <=> ( ( Xa != Ya )
            & ( ( Ya = A3 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),B1),La) )
            & ( ( Ya != A3 )
             => ( ( ( Xa = A3 )
                 => ( ( Ya = B1 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B1),Ya),La) ) )
                & ( ( Xa != A3 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La) ) ) ) ) ) ) ) ).

tff(fact_15_in__above,axiom,
    ! [Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B1: arrow_411405190le_alt,A3: arrow_411405190le_alt] :
      ( ( A3 != B1 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),arrow_1158827142_above(La,A3,B1))
        <=> ( ( Xa != Ya )
            & ( ( Xa = B1 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A3),Ya),La) )
            & ( ( Xa != B1 )
             => ( ( ( Ya = B1 )
                 => ( ( Xa = A3 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),A3),La) ) )
                & ( ( Ya != B1 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La) ) ) ) ) ) ) ) ).

tff(fact_16_prod__cases3,axiom,
    ! [A: $tType,B2: $tType,C1: $tType,Y3: product_prod(A,product_prod(B2,C1))] :
      ~ ! [A1: A,B: B2,C2: C1] : ( Y3 != aa(product_prod(B2,C1),product_prod(A,product_prod(B2,C1)),aa(A,fun(product_prod(B2,C1),product_prod(A,product_prod(B2,C1))),product_Pair(A,product_prod(B2,C1)),A1),aa(C1,product_prod(B2,C1),aa(B2,fun(C1,product_prod(B2,C1)),product_Pair(B2,C1),B),C2)) ) ).

tff(fact_17_prod__induct3,axiom,
    ! [C1: $tType,B2: $tType,A: $tType,Xa: product_prod(A,product_prod(B2,C1)),P1: fun(product_prod(A,product_prod(B2,C1)),bool)] :
      ( ! [A1: A,B: B2,C2: C1] : pp(aa(product_prod(A,product_prod(B2,C1)),bool,P1,aa(product_prod(B2,C1),product_prod(A,product_prod(B2,C1)),aa(A,fun(product_prod(B2,C1),product_prod(A,product_prod(B2,C1))),product_Pair(A,product_prod(B2,C1)),A1),aa(C1,product_prod(B2,C1),aa(B2,fun(C1,product_prod(B2,C1)),product_Pair(B2,C1),B),C2))))
     => pp(aa(product_prod(A,product_prod(B2,C1)),bool,P1,Xa)) ) ).

tff(fact_18_prod__cases4,axiom,
    ! [A: $tType,B2: $tType,C1: $tType,D: $tType,Y3: product_prod(A,product_prod(B2,product_prod(C1,D)))] :
      ~ ! [A1: A,B: B2,C2: C1,D1: D] : ( Y3 != aa(product_prod(B2,product_prod(C1,D)),product_prod(A,product_prod(B2,product_prod(C1,D))),aa(A,fun(product_prod(B2,product_prod(C1,D)),product_prod(A,product_prod(B2,product_prod(C1,D)))),product_Pair(A,product_prod(B2,product_prod(C1,D))),A1),aa(product_prod(C1,D),product_prod(B2,product_prod(C1,D)),aa(B2,fun(product_prod(C1,D),product_prod(B2,product_prod(C1,D))),product_Pair(B2,product_prod(C1,D)),B),aa(D,product_prod(C1,D),aa(C1,fun(D,product_prod(C1,D)),product_Pair(C1,D),C2),D1))) ) ).

tff(fact_19_prod__induct4,axiom,
    ! [D: $tType,C1: $tType,B2: $tType,A: $tType,Xa: product_prod(A,product_prod(B2,product_prod(C1,D))),P1: fun(product_prod(A,product_prod(B2,product_prod(C1,D))),bool)] :
      ( ! [A1: A,B: B2,C2: C1,D1: D] : pp(aa(product_prod(A,product_prod(B2,product_prod(C1,D))),bool,P1,aa(product_prod(B2,product_prod(C1,D)),product_prod(A,product_prod(B2,product_prod(C1,D))),aa(A,fun(product_prod(B2,product_prod(C1,D)),product_prod(A,product_prod(B2,product_prod(C1,D)))),product_Pair(A,product_prod(B2,product_prod(C1,D))),A1),aa(product_prod(C1,D),product_prod(B2,product_prod(C1,D)),aa(B2,fun(product_prod(C1,D),product_prod(B2,product_prod(C1,D))),product_Pair(B2,product_prod(C1,D)),B),aa(D,product_prod(C1,D),aa(C1,fun(D,product_prod(C1,D)),product_Pair(C1,D),C2),D1)))))
     => pp(aa(product_prod(A,product_prod(B2,product_prod(C1,D))),bool,P1,Xa)) ) ).

tff(fact_20_prod__cases5,axiom,
    ! [A: $tType,B2: $tType,C1: $tType,D: $tType,E: $tType,Y3: product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,E))))] :
      ~ ! [A1: A,B: B2,C2: C1,D1: D,E1: E] : ( Y3 != aa(product_prod(B2,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,E)))),aa(A,fun(product_prod(B2,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,E))))),product_Pair(A,product_prod(B2,product_prod(C1,product_prod(D,E)))),A1),aa(product_prod(C1,product_prod(D,E)),product_prod(B2,product_prod(C1,product_prod(D,E))),aa(B2,fun(product_prod(C1,product_prod(D,E)),product_prod(B2,product_prod(C1,product_prod(D,E)))),product_Pair(B2,product_prod(C1,product_prod(D,E))),B),aa(product_prod(D,E),product_prod(C1,product_prod(D,E)),aa(C1,fun(product_prod(D,E),product_prod(C1,product_prod(D,E))),product_Pair(C1,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_21_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C1: $tType,B2: $tType,A: $tType,Xa: product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,E)))),bool)] :
      ( ! [A1: A,B: B2,C2: C1,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,E)))),bool,P1,aa(product_prod(B2,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,E)))),aa(A,fun(product_prod(B2,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,E))))),product_Pair(A,product_prod(B2,product_prod(C1,product_prod(D,E)))),A1),aa(product_prod(C1,product_prod(D,E)),product_prod(B2,product_prod(C1,product_prod(D,E))),aa(B2,fun(product_prod(C1,product_prod(D,E)),product_prod(B2,product_prod(C1,product_prod(D,E)))),product_Pair(B2,product_prod(C1,product_prod(D,E))),B),aa(product_prod(D,E),product_prod(C1,product_prod(D,E)),aa(C1,fun(product_prod(D,E),product_prod(C1,product_prod(D,E))),product_Pair(C1,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,E)))),bool,P1,Xa)) ) ).

tff(fact_22_prod__cases6,axiom,
    ! [A: $tType,B2: $tType,C1: $tType,D: $tType,E: $tType,F2: $tType,Y3: product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A1: A,B: B2,C2: C1,D1: D,E1: E,F3: F2] : ( Y3 != aa(product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2))))),A1),aa(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))),aa(B2,fun(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2))))),product_Pair(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))),B),aa(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2))),aa(C1,fun(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2)))),product_Pair(C1,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_23_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C1: $tType,B2: $tType,A: $tType,Xa: product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2))))),P1: fun(product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A1: A,B: B2,C2: C1,D1: D,E1: E,F3: F2] : pp(aa(product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool,P1,aa(product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2))))),A1),aa(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))),aa(B2,fun(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2))))),product_Pair(B2,product_prod(C1,product_prod(D,product_prod(E,F2)))),B),aa(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2))),aa(C1,fun(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2)))),product_Pair(C1,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A,product_prod(B2,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool,P1,Xa)) ) ).

tff(fact_24_linear__alt,axiom,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin) ).

tff(fact_25_PairE,axiom,
    ! [A: $tType,B2: $tType,P2: product_prod(A,B2)] :
      ~ ! [X: A,Y: B2] : ( P2 != aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),X),Y) ) ).

tff(fact_26_prod_Oexhaust,axiom,
    ! [A: $tType,B2: $tType,Y3: product_prod(A,B2)] :
      ~ ! [A1: A,B: B2] : ( Y3 != aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A1),B) ) ).

tff(fact_27_internal__split__conv,axiom,
    ! [B2: $tType,A: $tType,C1: $tType,B1: C1,A3: B2,C: fun(B2,fun(C1,A))] : ( aa(product_prod(B2,C1),A,aa(fun(B2,fun(C1,A)),fun(product_prod(B2,C1),A),produc1605651328_split(B2,C1,A),C),aa(C1,product_prod(B2,C1),aa(B2,fun(C1,product_prod(B2,C1)),product_Pair(B2,C1),A3),B1)) = aa(C1,A,aa(B2,fun(C1,A),C,A3),B1) ) ).

tff(fact_28_curry__conv,axiom,
    ! [A: $tType,B2: $tType,C1: $tType,B1: C1,A3: B2,F: fun(product_prod(B2,C1),A)] : ( aa(C1,A,aa(B2,fun(C1,A),product_curry(B2,C1,A,F),A3),B1) = aa(product_prod(B2,C1),A,F,aa(C1,product_prod(B2,C1),aa(B2,fun(C1,product_prod(B2,C1)),product_Pair(B2,C1),A3),B1)) ) ).

tff(fact_29_curryI,axiom,
    ! [A: $tType,B2: $tType,B1: B2,A3: A,F: fun(product_prod(A,B2),bool)] :
      ( pp(aa(product_prod(A,B2),bool,F,aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1)))
     => pp(aa(B2,bool,aa(A,fun(B2,bool),product_curry(A,B2,bool,F),A3),B1)) ) ).

tff(fact_30_curryE,axiom,
    ! [A: $tType,B2: $tType,B1: B2,A3: A,F: fun(product_prod(A,B2),bool)] :
      ( pp(aa(B2,bool,aa(A,fun(B2,bool),product_curry(A,B2,bool,F),A3),B1))
     => pp(aa(product_prod(A,B2),bool,F,aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1))) ) ).

tff(fact_31_curryD,axiom,
    ! [A: $tType,B2: $tType,B1: B2,A3: A,F: fun(product_prod(A,B2),bool)] :
      ( pp(aa(B2,bool,aa(A,fun(B2,bool),product_curry(A,B2,bool,F),A3),B1))
     => pp(aa(product_prod(A,B2),bool,F,aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1))) ) ).

tff(fact_32_internal__split__def,axiom,
    ! [C1: $tType,B2: $tType,A: $tType] : ( produc1605651328_split(A,B2,C1) = product_prod_case(A,B2,C1) ) ).

tff(fact_33_apsnd__conv,axiom,
    ! [A: $tType,B2: $tType,C1: $tType,Ya: C1,Xa: A,F: fun(C1,B2)] : ( product_apsnd(C1,B2,A,F,aa(C1,product_prod(A,C1),aa(A,fun(C1,product_prod(A,C1)),product_Pair(A,C1),Xa),Ya)) = aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),Xa),aa(C1,B2,F,Ya)) ) ).

tff(fact_34_apfst__conv,axiom,
    ! [C1: $tType,A: $tType,B2: $tType,Ya: B2,Xa: C1,F: fun(C1,A)] : ( product_apfst(C1,A,B2,F,aa(B2,product_prod(C1,B2),aa(C1,fun(B2,product_prod(C1,B2)),product_Pair(C1,B2),Xa),Ya)) = aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),aa(C1,A,F,Xa)),Ya) ) ).

tff(fact_35_surj__pair,axiom,
    ! [A: $tType,B2: $tType,P2: product_prod(A,B2)] :
    ? [X: A,Y: B2] : ( P2 = aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),X),Y) ) ).

tff(fact_36_Pair__scomp,axiom,
    ! [A: $tType,B2: $tType,C1: $tType,F: fun(C1,fun(A,B2)),Xa: C1] : ( product_scomp(A,C1,A,B2,aa(C1,fun(A,product_prod(C1,A)),product_Pair(C1,A),Xa),F) = aa(C1,fun(A,B2),F,Xa) ) ).

tff(fact_37_converse__in__Lin,axiom,
    ! [La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),converse(arrow_411405190le_alt,arrow_411405190le_alt,La),arrow_1985332922le_Lin)
    <=> member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin) ) ).

tff(fact_38_splitI,axiom,
    ! [A: $tType,B2: $tType,B1: B2,A3: A,F: fun(A,fun(B2,bool))] :
      ( pp(aa(B2,bool,aa(A,fun(B2,bool),F,A3),B1))
     => pp(aa(product_prod(A,B2),bool,aa(fun(A,fun(B2,bool)),fun(product_prod(A,B2),bool),product_prod_case(A,B2,bool),F),aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1))) ) ).

tff(fact_39_prod__caseI,axiom,
    ! [A: $tType,B2: $tType,B1: B2,A3: A,F1: fun(A,fun(B2,bool))] :
      ( pp(aa(B2,bool,aa(A,fun(B2,bool),F1,A3),B1))
     => pp(aa(product_prod(A,B2),bool,aa(fun(A,fun(B2,bool)),fun(product_prod(A,B2),bool),product_prod_case(A,B2,bool),F1),aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1))) ) ).

tff(fact_40_mem__splitI,axiom,
    ! [A: $tType,B2: $tType,C1: $tType,B1: C1,A3: B2,C: fun(B2,fun(C1,fun(A,bool))),Z2: A] :
      ( member(A,Z2,aa(C1,fun(A,bool),aa(B2,fun(C1,fun(A,bool)),C,A3),B1))
     => member(A,Z2,aa(product_prod(B2,C1),fun(A,bool),aa(fun(B2,fun(C1,fun(A,bool))),fun(product_prod(B2,C1),fun(A,bool)),product_prod_case(B2,C1,fun(A,bool)),C),aa(C1,product_prod(B2,C1),aa(B2,fun(C1,product_prod(B2,C1)),product_Pair(B2,C1),A3),B1))) ) ).

tff(fact_41_split__conv,axiom,
    ! [B2: $tType,A: $tType,C1: $tType,B1: C1,A3: B2,F: fun(B2,fun(C1,A))] : ( aa(product_prod(B2,C1),A,aa(fun(B2,fun(C1,A)),fun(product_prod(B2,C1),A),product_prod_case(B2,C1,A),F),aa(C1,product_prod(B2,C1),aa(B2,fun(C1,product_prod(B2,C1)),product_Pair(B2,C1),A3),B1)) = aa(C1,A,aa(B2,fun(C1,A),F,A3),B1) ) ).

tff(fact_42_scomp__apply,axiom,
    ! [A: $tType,C1: $tType,D: $tType,B2: $tType,Xa: B2,G: fun(C1,fun(D,A)),F: fun(B2,product_prod(C1,D))] : ( aa(B2,A,product_scomp(B2,C1,D,A,F,G),Xa) = aa(product_prod(C1,D),A,aa(fun(C1,fun(D,A)),fun(product_prod(C1,D),A),product_prod_case(C1,D,A),G),aa(B2,product_prod(C1,D),F,Xa)) ) ).

tff(fact_43_scomp__def,axiom,
    ! [B2: $tType,C1: $tType,D: $tType,A: $tType,G: fun(C1,fun(D,B2)),F: fun(A,product_prod(C1,D)),X1: A] : ( aa(A,B2,product_scomp(A,C1,D,B2,F,G),X1) = aa(product_prod(C1,D),B2,aa(fun(C1,fun(D,B2)),fun(product_prod(C1,D),B2),product_prod_case(C1,D,B2),G),aa(A,product_prod(C1,D),F,X1)) ) ).

tff(fact_44_apsnd__apfst__commute,axiom,
    ! [A: $tType,B2: $tType,C1: $tType,D: $tType,P: product_prod(D,C1),G: fun(D,A),F: fun(C1,B2)] : ( product_apsnd(C1,B2,A,F,product_apfst(D,A,C1,G,P)) = product_apfst(D,A,B2,G,product_apsnd(C1,B2,D,F,P)) ) ).

tff(fact_45_split__weak__cong,axiom,
    ! [C1: $tType,B2: $tType,A: $tType,C: fun(A,fun(B2,C1)),Q: product_prod(A,B2),P: product_prod(A,B2)] :
      ( ( P = Q )
     => ( aa(product_prod(A,B2),C1,aa(fun(A,fun(B2,C1)),fun(product_prod(A,B2),C1),product_prod_case(A,B2,C1),C),P) = aa(product_prod(A,B2),C1,aa(fun(A,fun(B2,C1)),fun(product_prod(A,B2),C1),product_prod_case(A,B2,C1),C),Q) ) ) ).

tff(fact_46_splitD,axiom,
    ! [A: $tType,B2: $tType,B1: B2,A3: A,F: fun(A,fun(B2,bool))] :
      ( pp(aa(product_prod(A,B2),bool,aa(fun(A,fun(B2,bool)),fun(product_prod(A,B2),bool),product_prod_case(A,B2,bool),F),aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1)))
     => pp(aa(B2,bool,aa(A,fun(B2,bool),F,A3),B1)) ) ).

tff(fact_47_splitD_H,axiom,
    ! [B2: $tType,A: $tType,C1: $tType,C: C1,B1: B2,A3: A,R1: fun(A,fun(B2,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A,B2),fun(C1,bool),aa(fun(A,fun(B2,fun(C1,bool))),fun(product_prod(A,B2),fun(C1,bool)),product_prod_case(A,B2,fun(C1,bool)),R1),aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1)),C))
     => pp(aa(C1,bool,aa(B2,fun(C1,bool),aa(A,fun(B2,fun(C1,bool)),R1,A3),B1),C)) ) ).

tff(fact_48_prod_Osimps_I2_J,axiom,
    ! [B2: $tType,A: $tType,C1: $tType,B1: C1,A3: B2,F1: fun(B2,fun(C1,A))] : ( aa(product_prod(B2,C1),A,aa(fun(B2,fun(C1,A)),fun(product_prod(B2,C1),A),product_prod_case(B2,C1,A),F1),aa(C1,product_prod(B2,C1),aa(B2,fun(C1,product_prod(B2,C1)),product_Pair(B2,C1),A3),B1)) = aa(C1,A,aa(B2,fun(C1,A),F1,A3),B1) ) ).

tff(fact_49_scomp__Pair,axiom,
    ! [C1: $tType,B2: $tType,A: $tType,Xa: fun(A,product_prod(B2,C1))] : ( product_scomp(A,B2,C1,product_prod(B2,C1),Xa,product_Pair(B2,C1)) = Xa ) ).

tff(fact_50_curry__split,axiom,
    ! [C1: $tType,B2: $tType,A: $tType,F: fun(A,fun(B2,C1))] : ( product_curry(A,B2,C1,aa(fun(A,fun(B2,C1)),fun(product_prod(A,B2),C1),product_prod_case(A,B2,C1),F)) = F ) ).

tff(fact_51_split__curry,axiom,
    ! [C1: $tType,B2: $tType,A: $tType,F: fun(product_prod(A,B2),C1)] : ( aa(fun(A,fun(B2,C1)),fun(product_prod(A,B2),C1),product_prod_case(A,B2,C1),product_curry(A,B2,C1,F)) = F ) ).

tff(fact_52_converse__iff,axiom,
    ! [A: $tType,B2: $tType,R: fun(product_prod(B2,A),bool),B1: B2,A3: A] :
      ( member(product_prod(A,B2),aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1),converse(B2,A,R))
    <=> member(product_prod(B2,A),aa(A,product_prod(B2,A),aa(B2,fun(A,product_prod(B2,A)),product_Pair(B2,A),B1),A3),R) ) ).

tff(fact_53_splitE,axiom,
    ! [A: $tType,B2: $tType,P: product_prod(A,B2),C: fun(A,fun(B2,bool))] :
      ( pp(aa(product_prod(A,B2),bool,aa(fun(A,fun(B2,bool)),fun(product_prod(A,B2),bool),product_prod_case(A,B2,bool),C),P))
     => ~ ! [X: A,Y: B2] :
            ( ( P = aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),X),Y) )
           => ~ pp(aa(B2,bool,aa(A,fun(B2,bool),C,X),Y)) ) ) ).

tff(fact_54_splitI2,axiom,
    ! [B2: $tType,A: $tType,C: fun(A,fun(B2,bool)),P: product_prod(A,B2)] :
      ( ! [A1: A,B: B2] :
          ( ( P = aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A1),B) )
         => pp(aa(B2,bool,aa(A,fun(B2,bool),C,A1),B)) )
     => pp(aa(product_prod(A,B2),bool,aa(fun(A,fun(B2,bool)),fun(product_prod(A,B2),bool),product_prod_case(A,B2,bool),C),P)) ) ).

tff(fact_55_mem__splitI2,axiom,
    ! [C1: $tType,B2: $tType,A: $tType,C: fun(A,fun(B2,fun(C1,bool))),Z2: C1,P: product_prod(A,B2)] :
      ( ! [A1: A,B: B2] :
          ( ( P = aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A1),B) )
         => member(C1,Z2,aa(B2,fun(C1,bool),aa(A,fun(B2,fun(C1,bool)),C,A1),B)) )
     => member(C1,Z2,aa(product_prod(A,B2),fun(C1,bool),aa(fun(A,fun(B2,fun(C1,bool))),fun(product_prod(A,B2),fun(C1,bool)),product_prod_case(A,B2,fun(C1,bool)),C),P)) ) ).

tff(fact_56_splitI2_H,axiom,
    ! [A: $tType,B2: $tType,C1: $tType,Xa: C1,C: fun(A,fun(B2,fun(C1,bool))),P: product_prod(A,B2)] :
      ( ! [A1: A,B: B2] :
          ( ( aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A1),B) = P )
         => pp(aa(C1,bool,aa(B2,fun(C1,bool),aa(A,fun(B2,fun(C1,bool)),C,A1),B),Xa)) )
     => pp(aa(C1,bool,aa(product_prod(A,B2),fun(C1,bool),aa(fun(A,fun(B2,fun(C1,bool))),fun(product_prod(A,B2),fun(C1,bool)),product_prod_case(A,B2,fun(C1,bool)),C),P),Xa)) ) ).

tff(fact_57_converse__converse,axiom,
    ! [B2: $tType,A: $tType,R: fun(product_prod(A,B2),bool)] : ( converse(B2,A,converse(A,B2,R)) = R ) ).

tff(fact_58_converseD,axiom,
    ! [A: $tType,B2: $tType,R: fun(product_prod(B2,A),bool),B1: B2,A3: A] :
      ( member(product_prod(A,B2),aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1),converse(B2,A,R))
     => member(product_prod(B2,A),aa(A,product_prod(B2,A),aa(B2,fun(A,product_prod(B2,A)),product_Pair(B2,A),B1),A3),R) ) ).

tff(fact_59_converseI,axiom,
    ! [B2: $tType,A: $tType,R: fun(product_prod(A,B2),bool),B1: B2,A3: A] :
      ( member(product_prod(A,B2),aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),A3),B1),R)
     => member(product_prod(B2,A),aa(A,product_prod(B2,A),aa(B2,fun(A,product_prod(B2,A)),product_Pair(B2,A),B1),A3),converse(A,B2,R)) ) ).

tff(fact_60_splitE_H,axiom,
    ! [B2: $tType,A: $tType,C1: $tType,Z2: C1,P: product_prod(A,B2),C: fun(A,fun(B2,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A,B2),fun(C1,bool),aa(fun(A,fun(B2,fun(C1,bool))),fun(product_prod(A,B2),fun(C1,bool)),product_prod_case(A,B2,fun(C1,bool)),C),P),Z2))
     => ~ ! [X: A,Y: B2] :
            ( ( P = aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),X),Y) )
           => ~ pp(aa(C1,bool,aa(B2,fun(C1,bool),aa(A,fun(B2,fun(C1,bool)),C,X),Y),Z2)) ) ) ).

tff(fact_61_mem__splitE,axiom,
    ! [B2: $tType,A: $tType,C1: $tType,P: product_prod(B2,C1),C: fun(B2,fun(C1,fun(A,bool))),Z2: A] :
      ( member(A,Z2,aa(product_prod(B2,C1),fun(A,bool),aa(fun(B2,fun(C1,fun(A,bool))),fun(product_prod(B2,C1),fun(A,bool)),product_prod_case(B2,C1,fun(A,bool)),C),P))
     => ~ ! [X: B2,Y: C1] :
            ( ( P = aa(C1,product_prod(B2,C1),aa(B2,fun(C1,product_prod(B2,C1)),product_Pair(B2,C1),X),Y) )
           => ~ member(A,Z2,aa(C1,fun(A,bool),aa(B2,fun(C1,fun(A,bool)),C,X),Y)) ) ) ).

tff(fact_62_converseE,axiom,
    ! [A: $tType,B2: $tType,R: fun(product_prod(B2,A),bool),Yx: product_prod(A,B2)] :
      ( member(product_prod(A,B2),Yx,converse(B2,A,R))
     => ~ ! [X: B2,Y: A] :
            ( ( Yx = aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),Y),X) )
           => ~ member(product_prod(B2,A),aa(A,product_prod(B2,A),aa(B2,fun(A,product_prod(B2,A)),product_Pair(B2,A),X),Y),R) ) ) ).

tff(fact_63_split__cong,axiom,
    ! [C1: $tType,B2: $tType,A: $tType,P: product_prod(A,B2),G: fun(A,fun(B2,C1)),F: fun(A,fun(B2,C1)),Q: product_prod(A,B2)] :
      ( ! [X: A,Y: B2] :
          ( ( aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),X),Y) = Q )
         => ( aa(B2,C1,aa(A,fun(B2,C1),F,X),Y) = aa(B2,C1,aa(A,fun(B2,C1),G,X),Y) ) )
     => ( ( P = Q )
       => ( aa(product_prod(A,B2),C1,aa(fun(A,fun(B2,C1)),fun(product_prod(A,B2),C1),product_prod_case(A,B2,C1),F),P) = aa(product_prod(A,B2),C1,aa(fun(A,fun(B2,C1)),fun(product_prod(A,B2),C1),product_prod_case(A,B2,C1),G),Q) ) ) ) ).

tff(fact_64_splitE2,axiom,
    ! [B2: $tType,A: $tType,C1: $tType,Z2: product_prod(B2,C1),P1: fun(B2,fun(C1,A)),Q1: fun(A,bool)] :
      ( pp(aa(A,bool,Q1,aa(product_prod(B2,C1),A,aa(fun(B2,fun(C1,A)),fun(product_prod(B2,C1),A),product_prod_case(B2,C1,A),P1),Z2)))
     => ~ ! [X: B2,Y: C1] :
            ( ( Z2 = aa(C1,product_prod(B2,C1),aa(B2,fun(C1,product_prod(B2,C1)),product_Pair(B2,C1),X),Y) )
           => ~ pp(aa(A,bool,Q1,aa(C1,A,aa(B2,fun(C1,A),P1,X),Y))) ) ) ).

tff(fact_65_apfst__convE,axiom,
    ! [C1: $tType,A: $tType,B2: $tType,P: product_prod(C1,B2),F: fun(C1,A),Q: product_prod(A,B2)] :
      ( ( Q = product_apfst(C1,A,B2,F,P) )
     => ~ ! [X: C1,Y: B2] :
            ( ( P = aa(B2,product_prod(C1,B2),aa(C1,fun(B2,product_prod(C1,B2)),product_Pair(C1,B2),X),Y) )
           => ( Q != aa(B2,product_prod(A,B2),aa(A,fun(B2,product_prod(A,B2)),product_Pair(A,B2),aa(C1,A,F,X)),Y) ) ) ) ).

tff(fact_66_total__on__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( total_on(A,A2,converse(A,A,R))
    <=> total_on(A,A2,R) ) ).

tff(fact_67_converse__inv__image,axiom,
    ! [B2: $tType,A: $tType,F: fun(A,B2),R1: fun(product_prod(B2,B2),bool)] : ( converse(A,A,inv_image(B2,A,R1,F)) = inv_image(B2,A,converse(B2,B2,R1),F) ) ).

tff(fact_68_irrefl__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( irrefl(A,R)
    <=> ! [X2: A] : ~ member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),X2),R) ) ).

tff(fact_69_in__inv__image,axiom,
    ! [A: $tType,B2: $tType,F: fun(A,B2),R: fun(product_prod(B2,B2),bool),Ya: A,Xa: A] :
      ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Xa),Ya),inv_image(B2,A,R,F))
    <=> member(product_prod(B2,B2),aa(B2,product_prod(B2,B2),aa(B2,fun(B2,product_prod(B2,B2)),product_Pair(B2,B2),aa(A,B2,F,Xa)),aa(A,B2,F,Ya)),R) ) ).

tff(fact_70_total__on__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( total_on(A,A2,R)
    <=> ! [X2: A] :
          ( member(A,X2,A2)
         => ! [Xa1: A] :
              ( member(A,Xa1,A2)
             => ( ( X2 != Xa1 )
               => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),Xa1),R)
                  | member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Xa1),X2),R) ) ) ) ) ) ).

tff(fact_71_antisym__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( antisym(A,converse(A,A,R))
    <=> antisym(A,R) ) ).

tff(fact_72_converse__Id__on,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( converse(A,A,id_on(A,A2)) = id_on(A,A2) ) ).

tff(fact_73_sym__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( sym(A,converse(A,A,R))
    <=> sym(A,R) ) ).

tff(fact_74_sym__inv__image,axiom,
    ! [A: $tType,B2: $tType,F: fun(B2,A),R: fun(product_prod(A,A),bool)] :
      ( sym(A,R)
     => sym(B2,inv_image(A,B2,R,F)) ) ).

tff(fact_75_ext,axiom,
    ! [B2: $tType,A: $tType,G: fun(A,B2),F: fun(A,B2)] :
      ( ! [X: A] : ( aa(A,B2,F,X) = aa(A,B2,G,X) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),Xa: A] :
      ( member(A,Xa,A2)
    <=> pp(aa(A,bool,A2,Xa)) ) ).

tff(fact_77_Id__on__eqI,axiom,
    ! [A: $tType,A2: fun(A,bool),B1: A,A3: A] :
      ( ( A3 = B1 )
     => ( member(A,A3,A2)
       => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A3),B1),id_on(A,A2)) ) ) ).

tff(fact_78_Id__on__iff,axiom,
    ! [A: $tType,A2: fun(A,bool),Ya: A,Xa: A] :
      ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Xa),Ya),id_on(A,A2))
    <=> ( ( Xa = Ya )
        & member(A,Xa,A2) ) ) ).

tff(fact_79_antisymD,axiom,
    ! [A: $tType,B1: A,A3: A,R: fun(product_prod(A,A),bool)] :
      ( antisym(A,R)
     => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A3),B1),R)
       => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),B1),A3),R)
         => ( A3 = B1 ) ) ) ) ).

tff(fact_80_antisym__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( antisym(A,R)
    <=> ! [X2: A,Y2: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),Y2),R)
         => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y2),X2),R)
           => ( X2 = Y2 ) ) ) ) ).

tff(fact_81_antisym__Id__on,axiom,
    ! [A: $tType,A2: fun(A,bool)] : antisym(A,id_on(A,A2)) ).

tff(fact_82_sym__Id__on,axiom,
    ! [A: $tType,A2: fun(A,bool)] : sym(A,id_on(A,A2)) ).

tff(fact_83_symD,axiom,
    ! [A: $tType,B1: A,A3: A,R: fun(product_prod(A,A),bool)] :
      ( sym(A,R)
     => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A3),B1),R)
       => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),B1),A3),R) ) ) ).

tff(fact_84_sym__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( sym(A,R)
    <=> ! [X2: A,Y2: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),Y2),R)
         => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y2),X2),R) ) ) ).

tff(fact_85_sym__conv__converse__eq,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( sym(A,R)
    <=> ( converse(A,A,R) = R ) ) ).

tff(fact_86_Id__onE,axiom,
    ! [A: $tType,A2: fun(A,bool),C: product_prod(A,A)] :
      ( member(product_prod(A,A),C,id_on(A,A2))
     => ~ ! [X: A] :
            ( member(A,X,A2)
           => ( C != aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X),X) ) ) ) ).

tff(fact_87_antisymI,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( ! [X: A,Y: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X),Y),R)
         => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y),X),R)
           => ( X = Y ) ) )
     => antisym(A,R) ) ).

tff(fact_88_symI,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( ! [A1: A,B: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A1),B),R)
         => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),B),A1),R) )
     => sym(A,R) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    x != y ).

tff(conj_1,hypothesis,
    ( ! [X1: arrow_411405190le_alt,Y1: arrow_411405190le_alt] :
        ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),l)
       => ! [Z1: arrow_411405190le_alt] :
            ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),Z1),l)
           => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Z1),l) ) )
    & ! [X1: arrow_411405190le_alt] : ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),X1),l)
    & ! [X1: arrow_411405190le_alt,Y1: arrow_411405190le_alt] :
        ( ( X1 != Y1 )
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),l)
          | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),X1),l) ) ) ) ).

tff(conj_2,conjecture,
    ( ! [X: arrow_411405190le_alt,Y: arrow_411405190le_alt] :
        ( ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y),l)
          | ( X = x )
          | ( Y = x )
          | ! [Z: arrow_411405190le_alt] :
              ( ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),Z),l)
                | ( Z = x )
                | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Z),l) )
              & ( ( Z != x )
                | ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),y),l)
                | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),y),l) ) ) )
        & ( ( Y != x )
          | ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),y),l)
          | ( X = x )
          | ! [Z: arrow_411405190le_alt] :
              ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),y),Z),l)
              | ( Z = x )
              | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Z),l) ) )
        & ( ( X != x )
          | ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),y),Y),l)
          | ( Y = x )
          | ! [Z: arrow_411405190le_alt] :
              ( ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),Z),l)
                | ( Z = x )
                | ( Z = y )
                | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),y),Z),l) )
              & ( ( Z != x )
                | ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),y),l) ) ) ) )
    & ! [X: arrow_411405190le_alt,Y: arrow_411405190le_alt] :
        ( ( X = Y )
        | ( ( X = x )
          & ( Y = y ) )
        | ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y),l)
          & ( X != x )
          & ( Y != x ) )
        | ( ( Y = x )
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),y),l)
          & ( X != x ) )
        | ( ( X = x )
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),y),Y),l)
          & ( Y != x ) )
        | ( ( Y = x )
          & ( X = y ) )
        | ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),X),l)
          & ( Y != x )
          & ( X != x ) )
        | ( ( X = x )
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),y),l)
          & ( Y != x ) )
        | ( ( Y = x )
          & member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),y),X),l)
          & ( X != x ) ) ) ) ).

%------------------------------------------------------------------------------
