%------------------------------------------------------------------------------
% File     : SCT184_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 98
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_98 [Bla13]

% Status   : Theorem
% Rating   : 1.00 v9.1.0, 0.67 v8.2.0, 1.00 v8.1.0, 0.67 v7.4.0, 0.75 v7.2.0
% Syntax   : Number of formulae    :  145 (  35 unt;  39 typ;   0 def)
%            Number of atoms       :  247 (  77 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  187 (  46   ~;   4   |;  17   &)
%                                         (  30 <=>;  90  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   51 (  28   >;  23   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-6 aty)
%            Number of functors    :   24 (  24 usr;   5 con; 0-5 aty)
%            Number of variables   :  517 ( 472   !;   5   ?; 517   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:20
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Oabove,type,
    arrow_1158827142_above: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Obelow,type,
    arrow_319942042_below: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,B),bool) * A * B ) > $o ) ).

tff(sy_c_Order__Relation_Olinear__order__on,type,
    order_1409979114der_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Opartial__order__on,type,
    order_915043626der_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Opreorder__on,type,
    order_preorder_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(product_prod(A,A),bool),bool) ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(product_prod(A,B),C) > fun(A,fun(B,C)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(product_prod(A,B),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A: $tType,B: $tType,T: $tType] : fun(fun(A,fun(B,T)),fun(product_prod(A,B),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Relation_OId__on,type,
    id_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oantisym,type,
    antisym: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Oconverse,type,
    converse: 
      !>[A: $tType,B: $tType] : ( fun(product_prod(A,B),bool) > fun(product_prod(B,A),bool) ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B: $tType,A: $tType] : ( ( fun(product_prod(B,B),bool) * fun(A,B) ) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Orefl__on,type,
    refl_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Relation_Otrans,type,
    trans: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_L,type,
    l: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_x,type,
    x: arrow_411405190le_alt ).

%----Relevant facts (97)
tff(fact_0_linear__alt,axiom,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin) ).

tff(fact_1_in__mktop,axiom,
    ! [Z: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y: arrow_411405190le_alt,Xa: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,Y),arrow_424895264_mktop(La,Z))
    <=> ( ( Xa != Z )
        & ( ( Y = Z )
         => ( Xa != Y ) )
        & ( ( Y != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,Y),La) ) ) ) ).

tff(fact_2_converse__in__Lin,axiom,
    ! [La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),converse(arrow_411405190le_alt,arrow_411405190le_alt,La),arrow_1985332922le_Lin)
    <=> member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin) ) ).

tff(fact_3_notin__Lin__iff,axiom,
    ! [Y: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( ( Xa != Y )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,Y),La)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Y,Xa),La) ) ) ) ).

tff(fact_4_Lin__irrefl,axiom,
    ! [B2: arrow_411405190le_alt,A2: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,B2),La)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,B2,A2),La) ) ) ).

tff(fact_5_in__above,axiom,
    ! [Y: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B2: arrow_411405190le_alt,A2: arrow_411405190le_alt] :
      ( ( A2 != B2 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,Y),arrow_1158827142_above(La,A2,B2))
        <=> ( ( Xa != Y )
            & ( ( Xa = B2 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A2,Y),La) )
            & ( ( Xa != B2 )
             => ( ( ( Y = B2 )
                 => ( ( Xa = A2 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,A2),La) ) )
                & ( ( Y != B2 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,Y),La) ) ) ) ) ) ) ) ).

tff(fact_6_in__below,axiom,
    ! [Y: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),B2: arrow_411405190le_alt,A2: arrow_411405190le_alt] :
      ( ( A2 != B2 )
     => ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
       => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,Y),arrow_319942042_below(La,A2,B2))
        <=> ( ( Xa != Y )
            & ( ( Y = A2 )
             => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,B2),La) )
            & ( ( Y != A2 )
             => ( ( ( Xa = A2 )
                 => ( ( Y = B2 )
                    | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,B2,Y),La) ) )
                & ( ( Xa != A2 )
                 => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,Y),La) ) ) ) ) ) ) ) ).

tff(fact_7_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_8_converse__iff,axiom,
    ! [A: $tType,B: $tType,R1: fun(product_prod(B,A),bool),B2: B,A2: A] :
      ( member(product_prod(A,B),product_Pair(A,B,A2,B2),converse(B,A,R1))
    <=> member(product_prod(B,A),product_Pair(B,A,B2,A2),R1) ) ).

tff(fact_9_top1I,axiom,
    ! [A: $tType,Xa: A] : pp(aa(A,bool,top_top(fun(A,bool)),Xa)) ).

tff(fact_10_UNIV__I,axiom,
    ! [A: $tType,Xa: A] : member(A,Xa,top_top(fun(A,bool))) ).

tff(fact_11_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,Xa: A] : member(A,Xa,top_top(fun(A,bool))) ).

tff(fact_12_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P2: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P2,X11))
    <=> ! [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,P2,product_Pair(A,B,A4,B3))) ) ).

tff(fact_13_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A7: A,B2: B,A2: A] :
      ( ( product_Pair(A,B,A2,B2) = product_Pair(A,B,A7,B6) )
    <=> ( ( A2 = A7 )
        & ( B2 = B6 ) ) ) ).

tff(fact_14_converseI,axiom,
    ! [B: $tType,A: $tType,R1: fun(product_prod(A,B),bool),B2: B,A2: A] :
      ( member(product_prod(A,B),product_Pair(A,B,A2,B2),R1)
     => member(product_prod(B,A),product_Pair(B,A,B2,A2),converse(A,B,R1)) ) ).

tff(fact_15_converseD,axiom,
    ! [A: $tType,B: $tType,R1: fun(product_prod(B,A),bool),B2: B,A2: A] :
      ( member(product_prod(A,B),product_Pair(A,B,A2,B2),converse(B,A,R1))
     => member(product_prod(B,A),product_Pair(B,A,B2,A2),R1) ) ).

tff(fact_16_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [Xa: B] : ( aa(B,A,top_top(fun(B,A)),Xa) = top_top(A) ) ) ).

tff(fact_17_in__mkbot,axiom,
    ! [Z: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Y: arrow_411405190le_alt,Xa: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,Y),arrow_276188178_mkbot(La,Z))
    <=> ( ( Y != Z )
        & ( ( Xa = Z )
         => ( Xa != Y ) )
        & ( ( Xa != Z )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,Y),La) ) ) ) ).

tff(fact_18_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A6: A,B4: B,A5: A] :
      ( ( product_Pair(A,B,A5,B4) = product_Pair(A,B,A6,B5) )
     => ~ ( ( A5 = A6 )
         => ( B4 != B5 ) ) ) ).

tff(fact_19_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_20_converse__converse,axiom,
    ! [B: $tType,A: $tType,R1: fun(product_prod(A,B),bool)] : ( converse(B,A,converse(A,B,R1)) = R1 ) ).

tff(fact_21_converseE,axiom,
    ! [A: $tType,B: $tType,R1: fun(product_prod(B,A),bool),Yx: product_prod(A,B)] :
      ( member(product_prod(A,B),Yx,converse(B,A,R1))
     => ~ ! [X: B,Y1: A] :
            ( ( Yx = product_Pair(A,B,Y1,X) )
           => ~ member(product_prod(B,A),product_Pair(B,A,X,Y1),R1) ) ) ).

tff(fact_22_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P2: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P2,X11))
    <=> ? [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,P2,product_Pair(A,B,A4,B3))) ) ).

tff(fact_23_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A2: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,product_Pair(B,C,A2,B2)) = aa(C,A,aa(B,fun(C,A),F1,A2),B2) ) ).

tff(fact_24_UNIV__eq__I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X: A] : member(A,X,A1)
     => ( top_top(fun(A,bool)) = A1 ) ) ).

tff(fact_25_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X: A] : member(A,X,top_top(fun(A,bool))) ).

tff(fact_26_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y3: product_prod(A,B)] :
      ~ ! [A3: A,B1: B] : ( Y3 != product_Pair(A,B,A3,B1) ) ).

tff(fact_27_PairE,axiom,
    ! [A: $tType,B: $tType,P3: product_prod(A,B)] :
      ~ ! [X: A,Y1: B] : ( P3 != product_Pair(A,B,X,Y1) ) ).

tff(fact_28_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y3: product_prod(A,product_prod(B,C))] :
      ~ ! [A3: A,B1: B,C2: C] : ( Y3 != product_Pair(A,product_prod(B,C),A3,product_Pair(B,C,B1,C2)) ) ).

tff(fact_29_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),P2: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A3: A,B1: B,C2: C,D1: D,E1: E,F3: F2] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P2,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),A3,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2))),B1,product_Pair(C,product_prod(D,product_prod(E,F2)),C2,product_Pair(D,product_prod(E,F2),D1,product_Pair(E,F2,E1,F3)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P2,Xa)) ) ).

tff(fact_30_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y3: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A3: A,B1: B,C2: C,D1: D,E1: E,F3: F2] : ( Y3 != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),A3,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2))),B1,product_Pair(C,product_prod(D,product_prod(E,F2)),C2,product_Pair(D,product_prod(E,F2),D1,product_Pair(E,F2,E1,F3))))) ) ).

tff(fact_31_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P2: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A3: A,B1: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P2,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A3,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P2,Xa)) ) ).

tff(fact_32_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y3: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A3: A,B1: B,C2: C,D1: D,E1: E] : ( Y3 != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A3,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_33_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,D))),P2: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A3: A,B1: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P2,product_Pair(A,product_prod(B,product_prod(C,D)),A3,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C2,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P2,Xa)) ) ).

tff(fact_34_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y3: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A3: A,B1: B,C2: C,D1: D] : ( Y3 != product_Pair(A,product_prod(B,product_prod(C,D)),A3,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C2,D1))) ) ).

tff(fact_35_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,C)),P2: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A3: A,B1: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P2,product_Pair(A,product_prod(B,C),A3,product_Pair(B,C,B1,C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P2,Xa)) ) ).

tff(fact_36_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A2: B,C1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),produc1605651328_split(B,C,A),C1),product_Pair(B,C,A2,B2)) = aa(C,A,aa(B,fun(C,A),C1,A2),B2) ) ).

tff(fact_37_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,B2: C,A2: B,F: fun(product_prod(B,C),A)] : ( aa(C,A,aa(B,fun(C,A),product_curry(B,C,A,F),A2),B2) = aa(product_prod(B,C),A,F,product_Pair(B,C,A2,B2)) ) ).

tff(fact_38_curryI,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A2,B2)))
     => pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B2)) ) ).

tff(fact_39_total__on__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( total_on(A,A1,converse(A,A,R1))
    <=> total_on(A,A1,R1) ) ).

tff(fact_40_total__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( total_on(A,A1,R1)
    <=> ! [X1: A] :
          ( member(A,X1,A1)
         => ! [Xa1: A] :
              ( member(A,Xa1,A1)
             => ( ( X1 != Xa1 )
               => ( member(product_prod(A,A),product_Pair(A,A,X1,Xa1),R1)
                  | member(product_prod(A,A),product_Pair(A,A,Xa1,X1),R1) ) ) ) ) ) ).

tff(fact_41_curryD,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B2))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A2,B2))) ) ).

tff(fact_42_curryE,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B2))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A2,B2))) ) ).

tff(fact_43_converse__inv__image,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),R: fun(product_prod(B,B),bool)] : ( converse(A,A,inv_image(B,A,R,F)) = inv_image(B,A,converse(B,B,R),F) ) ).

tff(fact_44_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Y: B,Xa: B,F: fun(B,A),R1: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R1,F,Xa,Y)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R1,aa(B,A,F,Xa)),aa(B,A,F,Y))) ) ).

tff(fact_45_irrefl__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( irrefl(A,R1)
    <=> ! [X1: A] : ~ member(product_prod(A,A),product_Pair(A,A,X1,X1),R1) ) ).

tff(fact_46_in__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(A,B),R1: fun(product_prod(B,B),bool),Y: A,Xa: A] :
      ( member(product_prod(A,A),product_Pair(A,A,Xa,Y),inv_image(B,A,R1,F))
    <=> member(product_prod(B,B),product_Pair(B,B,aa(A,B,F,Xa),aa(A,B,F,Y)),R1) ) ).

tff(fact_47_antisym__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( antisym(A,converse(A,A,R1))
    <=> antisym(A,R1) ) ).

tff(fact_48_antisymD,axiom,
    ! [A: $tType,B2: A,A2: A,R1: fun(product_prod(A,A),bool)] :
      ( antisym(A,R1)
     => ( member(product_prod(A,A),product_Pair(A,A,A2,B2),R1)
       => ( member(product_prod(A,A),product_Pair(A,A,B2,A2),R1)
         => ( A2 = B2 ) ) ) ) ).

tff(fact_49_antisym__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( antisym(A,R1)
    <=> ! [X1: A,Y2: A] :
          ( member(product_prod(A,A),product_Pair(A,A,X1,Y2),R1)
         => ( member(product_prod(A,A),product_Pair(A,A,Y2,X1),R1)
           => ( X1 = Y2 ) ) ) ) ).

tff(fact_50_antisymI,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( ! [X: A,Y1: A] :
          ( member(product_prod(A,A),product_Pair(A,A,X,Y1),R1)
         => ( member(product_prod(A,A),product_Pair(A,A,Y1,X),R1)
           => ( X = Y1 ) ) )
     => antisym(A,R1) ) ).

tff(fact_51_strict__linear__order__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,order_215145569der_on(A,A1),R1))
    <=> ( trans(A,R1)
        & irrefl(A,R1)
        & total_on(A,A1,R1) ) ) ).

tff(fact_52_converse__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( converse(A,A,id_on(A,A1)) = id_on(A,A1) ) ).

tff(fact_53_internal__split__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] : ( produc1605651328_split(A,B,C) = product_prod_case(A,B,C) ) ).

tff(fact_54_prod__caseI,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F1: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F1,A2),B2))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F1),product_Pair(A,B,A2,B2))) ) ).

tff(fact_55_splitI,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F,A2),B2))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),product_Pair(A,B,A2,B2))) ) ).

tff(fact_56_mem__splitI,axiom,
    ! [A: $tType,B: $tType,C: $tType,B2: C,A2: B,C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,A2),B2))
     => member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),product_Pair(B,C,A2,B2))) ) ).

tff(fact_57_split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A2: B,F: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F),product_Pair(B,C,A2,B2)) = aa(C,A,aa(B,fun(C,A),F,A2),B2) ) ).

tff(fact_58_trans__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( trans(A,converse(A,A,R1))
    <=> trans(A,R1) ) ).

tff(fact_59_splitD_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,C1: C,B2: B,A2: A,R: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),R),product_Pair(A,B,A2,B2)),C1))
     => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),R,A2),B2),C1)) ) ).

tff(fact_60_prod_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A2: B,F1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F1),product_Pair(B,C,A2,B2)) = aa(C,A,aa(B,fun(C,A),F1,A2),B2) ) ).

tff(fact_61_splitD,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),product_Pair(A,B,A2,B2)))
     => pp(aa(B,bool,aa(A,fun(B,bool),F,A2),B2)) ) ).

tff(fact_62_split__weak__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,C)),Q1: product_prod(A,B),P1: product_prod(A,B)] :
      ( ( P1 = Q1 )
     => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),P1) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),Q1) ) ) ).

tff(fact_63_trans__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : trans(A,id_on(A,A1)) ).

tff(fact_64_trans__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( trans(A,R1)
    <=> ! [X1: A,Y2: A,Z2: A] :
          ( member(product_prod(A,A),product_Pair(A,A,X1,Y2),R1)
         => ( member(product_prod(A,A),product_Pair(A,A,Y2,Z2),R1)
           => member(product_prod(A,A),product_Pair(A,A,X1,Z2),R1) ) ) ) ).

tff(fact_65_transD,axiom,
    ! [A: $tType,C1: A,B2: A,A2: A,R1: fun(product_prod(A,A),bool)] :
      ( trans(A,R1)
     => ( member(product_prod(A,A),product_Pair(A,A,A2,B2),R1)
       => ( member(product_prod(A,A),product_Pair(A,A,B2,C1),R1)
         => member(product_prod(A,A),product_Pair(A,A,A2,C1),R1) ) ) ) ).

tff(fact_66_Id__on__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),Y: A,Xa: A] :
      ( member(product_prod(A,A),product_Pair(A,A,Xa,Y),id_on(A,A1))
    <=> ( ( Xa = Y )
        & member(A,Xa,A1) ) ) ).

tff(fact_67_Id__on__eqI,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,A2: A] :
      ( ( A2 = B2 )
     => ( member(A,A2,A1)
       => member(product_prod(A,A),product_Pair(A,A,A2,B2),id_on(A,A1)) ) ) ).

tff(fact_68_split__curry,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(product_prod(A,B),C)] : ( aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),product_curry(A,B,C,F)) = F ) ).

tff(fact_69_curry__split,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(A,fun(B,C))] : ( product_curry(A,B,C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F)) = F ) ).

tff(fact_70_trans__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(B,A),R1: fun(product_prod(A,A),bool)] :
      ( trans(A,R1)
     => trans(B,inv_image(A,B,R1,F)) ) ).

tff(fact_71_antisym__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : antisym(A,id_on(A,A1)) ).

tff(fact_72_Id__onE,axiom,
    ! [A: $tType,A1: fun(A,bool),C1: product_prod(A,A)] :
      ( member(product_prod(A,A),C1,id_on(A,A1))
     => ~ ! [X: A] :
            ( member(A,X,A1)
           => ( C1 != product_Pair(A,A,X,X) ) ) ) ).

tff(fact_73_splitE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B),C1: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P1))
     => ~ ! [X: A,Y1: B] :
            ( ( P1 = product_Pair(A,B,X,Y1) )
           => ~ pp(aa(B,bool,aa(A,fun(B,bool),C1,X),Y1)) ) ) ).

tff(fact_74_splitI2,axiom,
    ! [B: $tType,A: $tType,C1: fun(A,fun(B,bool)),P1: product_prod(A,B)] :
      ( ! [A3: A,B1: B] :
          ( ( P1 = product_Pair(A,B,A3,B1) )
         => pp(aa(B,bool,aa(A,fun(B,bool),C1,A3),B1)) )
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P1)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] :
      ( member(A,Xa,A1)
    <=> pp(aa(A,bool,A1,Xa)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P2: fun(A,bool)] : ( collect(A,P2) = P2 ) ).

tff(fact_78_splitE_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: C,P1: product_prod(A,B),C1: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P1),Z))
     => ~ ! [X: A,Y1: B] :
            ( ( P1 = product_Pair(A,B,X,Y1) )
           => ~ pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,X),Y1),Z)) ) ) ).

tff(fact_79_mem__splitI2,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,fun(C,bool))),Z: C,P1: product_prod(A,B)] :
      ( ! [A3: A,B1: B] :
          ( ( P1 = product_Pair(A,B,A3,B1) )
         => member(C,Z,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A3),B1)) )
     => member(C,Z,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P1)) ) ).

tff(fact_80_splitI2_H,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xa: C,C1: fun(A,fun(B,fun(C,bool))),P1: product_prod(A,B)] :
      ( ! [A3: A,B1: B] :
          ( ( product_Pair(A,B,A3,B1) = P1 )
         => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A3),B1),Xa)) )
     => pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P1),Xa)) ) ).

tff(fact_81_mem__splitE,axiom,
    ! [B: $tType,A: $tType,C: $tType,P1: product_prod(B,C),C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),P1))
     => ~ ! [X: B,Y1: C] :
            ( ( P1 = product_Pair(B,C,X,Y1) )
           => ~ member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,X),Y1)) ) ) ).

tff(fact_82_transI,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( ! [X: A,Y1: A,Z1: A] :
          ( member(product_prod(A,A),product_Pair(A,A,X,Y1),R1)
         => ( member(product_prod(A,A),product_Pair(A,A,Y1,Z1),R1)
           => member(product_prod(A,A),product_Pair(A,A,X,Z1),R1) ) )
     => trans(A,R1) ) ).

tff(fact_83_splitE2,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: product_prod(B,C),P2: fun(B,fun(C,A)),Q2: fun(A,bool)] :
      ( pp(aa(A,bool,Q2,aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),P2),Z)))
     => ~ ! [X: B,Y1: C] :
            ( ( Z = product_Pair(B,C,X,Y1) )
           => ~ pp(aa(A,bool,Q2,aa(C,A,aa(B,fun(C,A),P2,X),Y1))) ) ) ).

tff(fact_84_linear__order__on__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_1409979114der_on(A,A1,converse(A,A,R1))
    <=> order_1409979114der_on(A,A1,R1) ) ).

tff(fact_85_linear__order__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_1409979114der_on(A,A1,R1)
    <=> ( order_915043626der_on(A,A1,R1)
        & total_on(A,A1,R1) ) ) ).

tff(fact_86_preorder__on__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_preorder_on(A,A1,converse(A,A,R1))
    <=> order_preorder_on(A,A1,R1) ) ).

tff(fact_87_partial__order__on__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_915043626der_on(A,A1,converse(A,A,R1))
    <=> order_915043626der_on(A,A1,R1) ) ).

tff(fact_88_partial__order__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_915043626der_on(A,A1,R1)
    <=> ( order_preorder_on(A,A1,R1)
        & antisym(A,R1) ) ) ).

tff(fact_89_split__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,P1: product_prod(A,B),G: fun(A,fun(B,C)),F: fun(A,fun(B,C)),Q1: product_prod(A,B)] :
      ( ! [X: A,Y1: B] :
          ( ( product_Pair(A,B,X,Y1) = Q1 )
         => ( aa(B,C,aa(A,fun(B,C),F,X),Y1) = aa(B,C,aa(A,fun(B,C),G,X),Y1) ) )
     => ( ( P1 = Q1 )
       => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F),P1) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),G),Q1) ) ) ) ).

tff(fact_90_preorder__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_preorder_on(A,A1,R1)
    <=> ( refl_on(A,A1,R1)
        & trans(A,R1) ) ) ).

tff(fact_91_refl__on__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( refl_on(A,A1,converse(A,A,R1))
    <=> refl_on(A,A1,R1) ) ).

tff(fact_92_refl__on__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : refl_on(A,A1,id_on(A,A1)) ).

tff(fact_93_refl__onD2,axiom,
    ! [A: $tType,Y: A,Xa: A,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( refl_on(A,A1,R1)
     => ( member(product_prod(A,A),product_Pair(A,A,Xa,Y),R1)
       => member(A,Y,A1) ) ) ).

tff(fact_94_refl__onD1,axiom,
    ! [A: $tType,Y: A,Xa: A,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( refl_on(A,A1,R1)
     => ( member(product_prod(A,A),product_Pair(A,A,Xa,Y),R1)
       => member(A,Xa,A1) ) ) ).

tff(fact_95_refl__onD,axiom,
    ! [A: $tType,A2: A,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( refl_on(A,A1,R1)
     => ( member(A,A2,A1)
       => member(product_prod(A,A),product_Pair(A,A,A2,A2),R1) ) ) ).

tff(fact_96_in__rel__def,axiom,
    ! [B: $tType,A: $tType,Y: B,Xa: A,R: fun(product_prod(A,B),bool)] :
      ( in_rel(A,B,R,Xa,Y)
    <=> member(product_prod(A,B),product_Pair(A,B,Xa,Y),R) ) ).

%----Arities (2)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),l,arrow_1985332922le_Lin) ).

tff(conj_1,conjecture,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),arrow_424895264_mktop(l,x),arrow_1985332922le_Lin) ).

%------------------------------------------------------------------------------
