%------------------------------------------------------------------------------
% File     : SCT181_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 81
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_81 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  118 (  30 unt;  34 typ;   0 def)
%            Number of atoms       :  183 (  70 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  141 (  42   ~;   2   |;   7   &)
%                                         (  20 <=>;  70  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   37 (  22   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-5 aty)
%            Number of functors    :   24 (  24 usr;   7 con; 0-6 aty)
%            Number of variables   :  498 ( 450   !;   6   ?; 498   :)
%                                         (  42  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:14
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (30)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omkbot,type,
    arrow_276188178_mkbot: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,B),bool) * A * B ) > $o ) ).

tff(sy_c_Nitpick_Orefl_H,type,
    refl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,product_prod(A,B))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A: $tType,C1: $tType,B: $tType] : ( ( fun(A,C1) * product_prod(A,B) ) > product_prod(C1,B) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B: $tType,C1: $tType,A: $tType] : ( ( fun(B,C1) * product_prod(A,B) ) > product_prod(A,C1) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C1: $tType] : ( fun(product_prod(A,B),C1) > fun(A,fun(B,C1)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C1: $tType] : fun(fun(A,fun(B,C1)),fun(product_prod(A,B),C1)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A: $tType,B: $tType,T: $tType] : fun(fun(A,fun(B,T)),fun(product_prod(A,B),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A: $tType,B: $tType,C1: $tType,D: $tType] : ( ( fun(A,product_prod(B,C1)) * fun(B,fun(C1,D)) ) > fun(A,D) ) ).

tff(sy_c_Relation_OId__on,type,
    id_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oantisym,type,
    antisym: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Oconverse,type,
    converse: 
      !>[A: $tType,B: $tType] : ( fun(product_prod(A,B),bool) > fun(product_prod(B,A),bool) ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B: $tType,A: $tType] : ( ( fun(product_prod(B,B),bool) * fun(A,B) ) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Osingle__valued,type,
    single_valued: 
      !>[A: $tType,B: $tType] : ( fun(product_prod(A,B),bool) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,A),bool) * fun(product_prod(B,B),bool) ) > fun(product_prod(product_prod(A,B),product_prod(A,B)),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_L,type,
    l: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_x,type,
    x: arrow_411405190le_alt ).

tff(sy_v_y,type,
    y: arrow_411405190le_alt ).

tff(sy_v_z,type,
    z: arrow_411405190le_alt ).

%----Relevant facts (81)
tff(fact_0_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ! [A5: A,B4: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B4))) ) ).

tff(fact_1_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B3: B,A4: A,B1: B,A2: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3) )
    <=> ( ( A2 = A4 )
        & ( B1 = B3 ) ) ) ).

tff(fact_2_in__mktop,axiom,
    ! [Za: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt] :
      ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),arrow_424895264_mktop(La,Za))
    <=> ( ( Xa != Za )
        & ( ( Ya = Za )
         => ( Xa != Ya ) )
        & ( ( Ya != Za )
         => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La) ) ) ) ).

tff(fact_3_notin__Lin__iff,axiom,
    ! [Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( ( Xa != Ya )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Xa),Ya),La)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Ya),Xa),La) ) ) ) ).

tff(fact_4_Lin__irrefl,axiom,
    ! [B1: arrow_411405190le_alt,A2: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),B1),La)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B1),A2),La) ) ) ).

tff(fact_5_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B6: B,A7: A,B5: B,A6: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B5) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A7),B6) )
     => ~ ( ( A6 = A7 )
         => ( B5 != B6 ) ) ) ).

tff(fact_6_in__rel__def,axiom,
    ! [B: $tType,A: $tType,Ya: B,Xa: A,R1: fun(product_prod(A,B),bool)] :
      ( in_rel(A,B,R1,Xa,Ya)
    <=> member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Xa),Ya),R1) ) ).

tff(fact_7_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ? [A5: A,B4: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B4))) ) ).

tff(fact_8_Nitpick_Orefl_H__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( refl(A,R)
    <=> ! [X1: A] : member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X1),X1),R) ) ).

tff(fact_9_in__lex__prod,axiom,
    ! [A: $tType,B: $tType,S: fun(product_prod(B,B),bool),R: fun(product_prod(A,A),bool),B3: B,A4: A,B1: B,A2: A] :
      ( member(product_prod(product_prod(A,B),product_prod(A,B)),aa(product_prod(A,B),product_prod(product_prod(A,B),product_prod(A,B)),aa(product_prod(A,B),fun(product_prod(A,B),product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3)),lex_prod(A,B,R,S))
    <=> ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A2),A4),R)
        | ( ( A2 = A4 )
          & member(product_prod(B,B),aa(B,product_prod(B,B),aa(B,fun(B,product_prod(B,B)),product_Pair(B,B),B1),B3),S) ) ) ) ).

tff(fact_10_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C1: $tType,B1: C1,A2: B,F1: fun(B,fun(C1,A))] : ( product_prod_rec(B,C1,A,F1,aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1)) = aa(C1,A,aa(B,fun(C1,A),F1,A2),B1) ) ).

tff(fact_11_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C1: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),P1: fun(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A3: A,B2: B,C2: C1,D1: D,E1: E,F3: F2] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool,P1,aa(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2))),aa(C1,fun(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2)))),product_Pair(C1,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool,P1,Xa)) ) ).

tff(fact_12_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,E: $tType,F2: $tType,Y2: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A3: A,B2: B,C2: C1,D1: D,E1: E,F3: F2] : ( Y2 != aa(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2))),aa(C1,fun(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2)))),product_Pair(C1,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_13_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,E: $tType,Y2: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E))))] :
      ~ ! [A3: A,B2: B,C2: C1,D1: D,E1: E] : ( Y2 != aa(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,E)))),A3),aa(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E))),aa(B,fun(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E)))),product_Pair(B,product_prod(C1,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C1,product_prod(D,E)),aa(C1,fun(product_prod(D,E),product_prod(C1,product_prod(D,E))),product_Pair(C1,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_14_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C1: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),bool)] :
      ( ! [A3: A,B2: B,C2: C1,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),bool,P1,aa(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C1,product_prod(D,E)))),A3),aa(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E))),aa(B,fun(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E)))),product_Pair(B,product_prod(C1,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C1,product_prod(D,E)),aa(C1,fun(product_prod(D,E),product_prod(C1,product_prod(D,E))),product_Pair(C1,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,product_prod(D,E)))),bool,P1,Xa)) ) ).

tff(fact_15_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,Y2: product_prod(A,product_prod(B,product_prod(C1,D)))] :
      ~ ! [A3: A,B2: B,C2: C1,D1: D] : ( Y2 != aa(product_prod(B,product_prod(C1,D)),product_prod(A,product_prod(B,product_prod(C1,D))),aa(A,fun(product_prod(B,product_prod(C1,D)),product_prod(A,product_prod(B,product_prod(C1,D)))),product_Pair(A,product_prod(B,product_prod(C1,D))),A3),aa(product_prod(C1,D),product_prod(B,product_prod(C1,D)),aa(B,fun(product_prod(C1,D),product_prod(B,product_prod(C1,D))),product_Pair(B,product_prod(C1,D)),B2),aa(D,product_prod(C1,D),aa(C1,fun(D,product_prod(C1,D)),product_Pair(C1,D),C2),D1))) ) ).

tff(fact_16_prod__induct4,axiom,
    ! [D: $tType,C1: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C1,D))),P1: fun(product_prod(A,product_prod(B,product_prod(C1,D))),bool)] :
      ( ! [A3: A,B2: B,C2: C1,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C1,D))),bool,P1,aa(product_prod(B,product_prod(C1,D)),product_prod(A,product_prod(B,product_prod(C1,D))),aa(A,fun(product_prod(B,product_prod(C1,D)),product_prod(A,product_prod(B,product_prod(C1,D)))),product_Pair(A,product_prod(B,product_prod(C1,D))),A3),aa(product_prod(C1,D),product_prod(B,product_prod(C1,D)),aa(B,fun(product_prod(C1,D),product_prod(B,product_prod(C1,D))),product_Pair(B,product_prod(C1,D)),B2),aa(D,product_prod(C1,D),aa(C1,fun(D,product_prod(C1,D)),product_Pair(C1,D),C2),D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C1,D))),bool,P1,Xa)) ) ).

tff(fact_17_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Y2: product_prod(A,product_prod(B,C1))] :
      ~ ! [A3: A,B2: B,C2: C1] : ( Y2 != aa(product_prod(B,C1),product_prod(A,product_prod(B,C1)),aa(A,fun(product_prod(B,C1),product_prod(A,product_prod(B,C1))),product_Pair(A,product_prod(B,C1)),A3),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),B2),C2)) ) ).

tff(fact_18_prod__induct3,axiom,
    ! [C1: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,C1)),P1: fun(product_prod(A,product_prod(B,C1)),bool)] :
      ( ! [A3: A,B2: B,C2: C1] : pp(aa(product_prod(A,product_prod(B,C1)),bool,P1,aa(product_prod(B,C1),product_prod(A,product_prod(B,C1)),aa(A,fun(product_prod(B,C1),product_prod(A,product_prod(B,C1))),product_Pair(A,product_prod(B,C1)),A3),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),B2),C2))))
     => pp(aa(product_prod(A,product_prod(B,C1)),bool,P1,Xa)) ) ).

tff(fact_19_linear__alt,axiom,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin) ).

tff(fact_20_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y2: product_prod(A,B)] :
      ~ ! [A3: A,B2: B] : ( Y2 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) ) ).

tff(fact_21_PairE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B)] :
      ~ ! [X: A,Y: B] : ( P2 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X),Y) ) ).

tff(fact_22_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C1: $tType,B1: C1,A2: B,C: fun(B,fun(C1,A))] : ( aa(product_prod(B,C1),A,aa(fun(B,fun(C1,A)),fun(product_prod(B,C1),A),produc1605651328_split(B,C1,A),C),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1)) = aa(C1,A,aa(B,fun(C1,A),C,A2),B1) ) ).

tff(fact_23_curry__conv,axiom,
    ! [A: $tType,B: $tType,C1: $tType,B1: C1,A2: B,F: fun(product_prod(B,C1),A)] : ( aa(C1,A,aa(B,fun(C1,A),product_curry(B,C1,A,F),A2),B1) = aa(product_prod(B,C1),A,F,aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1)) ) ).

tff(fact_24_curryI,axiom,
    ! [A: $tType,B: $tType,B1: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1)))
     => pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B1)) ) ).

tff(fact_25_curryD,axiom,
    ! [A: $tType,B: $tType,B1: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B1))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1))) ) ).

tff(fact_26_curryE,axiom,
    ! [A: $tType,B: $tType,B1: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B1))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1))) ) ).

tff(fact_27_apsnd__conv,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Ya: C1,Xa: A,F: fun(C1,B)] : ( product_apsnd(C1,B,A,F,aa(C1,product_prod(A,C1),aa(A,fun(C1,product_prod(A,C1)),product_Pair(A,C1),Xa),Ya)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Xa),aa(C1,B,F,Ya)) ) ).

tff(fact_28_internal__split__def,axiom,
    ! [C1: $tType,B: $tType,A: $tType] : ( produc1605651328_split(A,B,C1) = product_prod_case(A,B,C1) ) ).

tff(fact_29_apfst__conv,axiom,
    ! [C1: $tType,A: $tType,B: $tType,Ya: B,Xa: C1,F: fun(C1,A)] : ( product_apfst(C1,A,B,F,aa(B,product_prod(C1,B),aa(C1,fun(B,product_prod(C1,B)),product_Pair(C1,B),Xa),Ya)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C1,A,F,Xa)),Ya) ) ).

tff(fact_30_surj__pair,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B)] :
    ? [X: A,Y: B] : ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X),Y) ) ).

tff(fact_31_apsnd__apfst__commute,axiom,
    ! [A: $tType,B: $tType,C1: $tType,D: $tType,P: product_prod(D,C1),G: fun(D,A),F: fun(C1,B)] : ( product_apsnd(C1,B,A,F,product_apfst(D,A,C1,G,P)) = product_apfst(D,A,B,G,product_apsnd(C1,B,D,F,P)) ) ).

tff(fact_32_converse__in__Lin,axiom,
    ! [La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),converse(arrow_411405190le_alt,arrow_411405190le_alt,La),arrow_1985332922le_Lin)
    <=> member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin) ) ).

tff(fact_33_Pair__scomp,axiom,
    ! [A: $tType,B: $tType,C1: $tType,F: fun(C1,fun(A,B)),Xa: C1] : ( product_scomp(A,C1,A,B,aa(C1,fun(A,product_prod(C1,A)),product_Pair(C1,A),Xa),F) = aa(C1,fun(A,B),F,Xa) ) ).

tff(fact_34_splitI,axiom,
    ! [A: $tType,B: $tType,B1: B,A2: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F,A2),B1))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1))) ) ).

tff(fact_35_prod__caseI,axiom,
    ! [A: $tType,B: $tType,B1: B,A2: A,F1: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F1,A2),B1))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F1),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1))) ) ).

tff(fact_36_mem__splitI,axiom,
    ! [A: $tType,B: $tType,C1: $tType,B1: C1,A2: B,C: fun(B,fun(C1,fun(A,bool))),Za: A] :
      ( member(A,Za,aa(C1,fun(A,bool),aa(B,fun(C1,fun(A,bool)),C,A2),B1))
     => member(A,Za,aa(product_prod(B,C1),fun(A,bool),aa(fun(B,fun(C1,fun(A,bool))),fun(product_prod(B,C1),fun(A,bool)),product_prod_case(B,C1,fun(A,bool)),C),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1))) ) ).

tff(fact_37_split__conv,axiom,
    ! [B: $tType,A: $tType,C1: $tType,B1: C1,A2: B,F: fun(B,fun(C1,A))] : ( aa(product_prod(B,C1),A,aa(fun(B,fun(C1,A)),fun(product_prod(B,C1),A),product_prod_case(B,C1,A),F),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1)) = aa(C1,A,aa(B,fun(C1,A),F,A2),B1) ) ).

tff(fact_38_scomp__apply,axiom,
    ! [A: $tType,C1: $tType,D: $tType,B: $tType,Xa: B,G: fun(C1,fun(D,A)),F: fun(B,product_prod(C1,D))] : ( aa(B,A,product_scomp(B,C1,D,A,F,G),Xa) = aa(product_prod(C1,D),A,aa(fun(C1,fun(D,A)),fun(product_prod(C1,D),A),product_prod_case(C1,D,A),G),aa(B,product_prod(C1,D),F,Xa)) ) ).

tff(fact_39_scomp__def,axiom,
    ! [B: $tType,C1: $tType,D: $tType,A: $tType,G: fun(C1,fun(D,B)),F: fun(A,product_prod(C1,D)),X2: A] : ( aa(A,B,product_scomp(A,C1,D,B,F,G),X2) = aa(product_prod(C1,D),B,aa(fun(C1,fun(D,B)),fun(product_prod(C1,D),B),product_prod_case(C1,D,B),G),aa(A,product_prod(C1,D),F,X2)) ) ).

tff(fact_40_split__weak__cong,axiom,
    ! [C1: $tType,B: $tType,A: $tType,C: fun(A,fun(B,C1)),Q: product_prod(A,B),P: product_prod(A,B)] :
      ( ( P = Q )
     => ( aa(product_prod(A,B),C1,aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),C),P) = aa(product_prod(A,B),C1,aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),C),Q) ) ) ).

tff(fact_41_splitD,axiom,
    ! [A: $tType,B: $tType,B1: B,A2: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1)))
     => pp(aa(B,bool,aa(A,fun(B,bool),F,A2),B1)) ) ).

tff(fact_42_splitD_H,axiom,
    ! [B: $tType,A: $tType,C1: $tType,C: C1,B1: B,A2: A,R1: fun(A,fun(B,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A,B),fun(C1,bool),aa(fun(A,fun(B,fun(C1,bool))),fun(product_prod(A,B),fun(C1,bool)),product_prod_case(A,B,fun(C1,bool)),R1),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1)),C))
     => pp(aa(C1,bool,aa(B,fun(C1,bool),aa(A,fun(B,fun(C1,bool)),R1,A2),B1),C)) ) ).

tff(fact_43_prod_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C1: $tType,B1: C1,A2: B,F1: fun(B,fun(C1,A))] : ( aa(product_prod(B,C1),A,aa(fun(B,fun(C1,A)),fun(product_prod(B,C1),A),product_prod_case(B,C1,A),F1),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1)) = aa(C1,A,aa(B,fun(C1,A),F1,A2),B1) ) ).

tff(fact_44_scomp__Pair,axiom,
    ! [C1: $tType,B: $tType,A: $tType,Xa: fun(A,product_prod(B,C1))] : ( product_scomp(A,B,C1,product_prod(B,C1),Xa,product_Pair(B,C1)) = Xa ) ).

tff(fact_45_curry__split,axiom,
    ! [C1: $tType,B: $tType,A: $tType,F: fun(A,fun(B,C1))] : ( product_curry(A,B,C1,aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),F)) = F ) ).

tff(fact_46_split__curry,axiom,
    ! [C1: $tType,B: $tType,A: $tType,F: fun(product_prod(A,B),C1)] : ( aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),product_curry(A,B,C1,F)) = F ) ).

tff(fact_47_converse__iff,axiom,
    ! [A: $tType,B: $tType,R: fun(product_prod(B,A),bool),B1: B,A2: A] :
      ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1),converse(B,A,R))
    <=> member(product_prod(B,A),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),B1),A2),R) ) ).

tff(fact_48_splitI2,axiom,
    ! [B: $tType,A: $tType,C: fun(A,fun(B,bool)),P: product_prod(A,B)] :
      ( ! [A3: A,B2: B] :
          ( ( P = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) )
         => pp(aa(B,bool,aa(A,fun(B,bool),C,A3),B2)) )
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C),P)) ) ).

tff(fact_49_splitE,axiom,
    ! [A: $tType,B: $tType,P: product_prod(A,B),C: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C),P))
     => ~ ! [X: A,Y: B] :
            ( ( P = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X),Y) )
           => ~ pp(aa(B,bool,aa(A,fun(B,bool),C,X),Y)) ) ) ).

tff(fact_50_mem__splitI2,axiom,
    ! [C1: $tType,B: $tType,A: $tType,C: fun(A,fun(B,fun(C1,bool))),Za: C1,P: product_prod(A,B)] :
      ( ! [A3: A,B2: B] :
          ( ( P = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) )
         => member(C1,Za,aa(B,fun(C1,bool),aa(A,fun(B,fun(C1,bool)),C,A3),B2)) )
     => member(C1,Za,aa(product_prod(A,B),fun(C1,bool),aa(fun(A,fun(B,fun(C1,bool))),fun(product_prod(A,B),fun(C1,bool)),product_prod_case(A,B,fun(C1,bool)),C),P)) ) ).

tff(fact_51_splitI2_H,axiom,
    ! [A: $tType,B: $tType,C1: $tType,Xa: C1,C: fun(A,fun(B,fun(C1,bool))),P: product_prod(A,B)] :
      ( ! [A3: A,B2: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) = P )
         => pp(aa(C1,bool,aa(B,fun(C1,bool),aa(A,fun(B,fun(C1,bool)),C,A3),B2),Xa)) )
     => pp(aa(C1,bool,aa(product_prod(A,B),fun(C1,bool),aa(fun(A,fun(B,fun(C1,bool))),fun(product_prod(A,B),fun(C1,bool)),product_prod_case(A,B,fun(C1,bool)),C),P),Xa)) ) ).

tff(fact_52_mem__splitE,axiom,
    ! [B: $tType,A: $tType,C1: $tType,P: product_prod(B,C1),C: fun(B,fun(C1,fun(A,bool))),Za: A] :
      ( member(A,Za,aa(product_prod(B,C1),fun(A,bool),aa(fun(B,fun(C1,fun(A,bool))),fun(product_prod(B,C1),fun(A,bool)),product_prod_case(B,C1,fun(A,bool)),C),P))
     => ~ ! [X: B,Y: C1] :
            ( ( P = aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),X),Y) )
           => ~ member(A,Za,aa(C1,fun(A,bool),aa(B,fun(C1,fun(A,bool)),C,X),Y)) ) ) ).

tff(fact_53_converse__converse,axiom,
    ! [B: $tType,A: $tType,R: fun(product_prod(A,B),bool)] : ( converse(B,A,converse(A,B,R)) = R ) ).

tff(fact_54_converseI,axiom,
    ! [B: $tType,A: $tType,R: fun(product_prod(A,B),bool),B1: B,A2: A] :
      ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1),R)
     => member(product_prod(B,A),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),B1),A2),converse(A,B,R)) ) ).

tff(fact_55_converseD,axiom,
    ! [A: $tType,B: $tType,R: fun(product_prod(B,A),bool),B1: B,A2: A] :
      ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1),converse(B,A,R))
     => member(product_prod(B,A),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),B1),A2),R) ) ).

tff(fact_56_splitE_H,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Za: C1,P: product_prod(A,B),C: fun(A,fun(B,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A,B),fun(C1,bool),aa(fun(A,fun(B,fun(C1,bool))),fun(product_prod(A,B),fun(C1,bool)),product_prod_case(A,B,fun(C1,bool)),C),P),Za))
     => ~ ! [X: A,Y: B] :
            ( ( P = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X),Y) )
           => ~ pp(aa(C1,bool,aa(B,fun(C1,bool),aa(A,fun(B,fun(C1,bool)),C,X),Y),Za)) ) ) ).

tff(fact_57_converseE,axiom,
    ! [A: $tType,B: $tType,R: fun(product_prod(B,A),bool),Yx: product_prod(A,B)] :
      ( member(product_prod(A,B),Yx,converse(B,A,R))
     => ~ ! [X: B,Y: A] :
            ( ( Yx = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Y),X) )
           => ~ member(product_prod(B,A),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),X),Y),R) ) ) ).

tff(fact_58_splitE2,axiom,
    ! [B: $tType,A: $tType,C1: $tType,Za: product_prod(B,C1),P1: fun(B,fun(C1,A)),Q1: fun(A,bool)] :
      ( pp(aa(A,bool,Q1,aa(product_prod(B,C1),A,aa(fun(B,fun(C1,A)),fun(product_prod(B,C1),A),product_prod_case(B,C1,A),P1),Za)))
     => ~ ! [X: B,Y: C1] :
            ( ( Za = aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),X),Y) )
           => ~ pp(aa(A,bool,Q1,aa(C1,A,aa(B,fun(C1,A),P1,X),Y))) ) ) ).

tff(fact_59_split__cong,axiom,
    ! [C1: $tType,B: $tType,A: $tType,P: product_prod(A,B),G: fun(A,fun(B,C1)),F: fun(A,fun(B,C1)),Q: product_prod(A,B)] :
      ( ! [X: A,Y: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X),Y) = Q )
         => ( aa(B,C1,aa(A,fun(B,C1),F,X),Y) = aa(B,C1,aa(A,fun(B,C1),G,X),Y) ) )
     => ( ( P = Q )
       => ( aa(product_prod(A,B),C1,aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),F),P) = aa(product_prod(A,B),C1,aa(fun(A,fun(B,C1)),fun(product_prod(A,B),C1),product_prod_case(A,B,C1),G),Q) ) ) ) ).

tff(fact_60_apfst__convE,axiom,
    ! [C1: $tType,A: $tType,B: $tType,P: product_prod(C1,B),F: fun(C1,A),Q: product_prod(A,B)] :
      ( ( Q = product_apfst(C1,A,B,F,P) )
     => ~ ! [X: C1,Y: B] :
            ( ( P = aa(B,product_prod(C1,B),aa(C1,fun(B,product_prod(C1,B)),product_Pair(C1,B),X),Y) )
           => ( Q != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C1,A,F,X)),Y) ) ) ) ).

tff(fact_61_total__on__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( total_on(A,A1,converse(A,A,R))
    <=> total_on(A,A1,R) ) ).

tff(fact_62_converse__inv__image,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),R1: fun(product_prod(B,B),bool)] : ( converse(A,A,inv_image(B,A,R1,F)) = inv_image(B,A,converse(B,B,R1),F) ) ).

tff(fact_63_in__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(A,B),R: fun(product_prod(B,B),bool),Ya: A,Xa: A] :
      ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Xa),Ya),inv_image(B,A,R,F))
    <=> member(product_prod(B,B),aa(B,product_prod(B,B),aa(B,fun(B,product_prod(B,B)),product_Pair(B,B),aa(A,B,F,Xa)),aa(A,B,F,Ya)),R) ) ).

tff(fact_64_total__on__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( total_on(A,A1,R)
    <=> ! [X1: A] :
          ( member(A,X1,A1)
         => ! [Xa1: A] :
              ( member(A,Xa1,A1)
             => ( ( X1 != Xa1 )
               => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X1),Xa1),R)
                  | member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Xa1),X1),R) ) ) ) ) ) ).

tff(fact_65_irrefl__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( irrefl(A,R)
    <=> ! [X1: A] : ~ member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X1),X1),R) ) ).

tff(fact_66_antisym__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( antisym(A,converse(A,A,R))
    <=> antisym(A,R) ) ).

tff(fact_67_converse__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( converse(A,A,id_on(A,A1)) = id_on(A,A1) ) ).

tff(fact_68_antisym__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : antisym(A,id_on(A,A1)) ).

tff(fact_69_antisym__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( antisym(A,R)
    <=> ! [X1: A,Y1: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X1),Y1),R)
         => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y1),X1),R)
           => ( X1 = Y1 ) ) ) ) ).

tff(fact_70_antisymD,axiom,
    ! [A: $tType,B1: A,A2: A,R: fun(product_prod(A,A),bool)] :
      ( antisym(A,R)
     => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A2),B1),R)
       => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),B1),A2),R)
         => ( A2 = B1 ) ) ) ) ).

tff(fact_71_Id__on__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),Ya: A,Xa: A] :
      ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Xa),Ya),id_on(A,A1))
    <=> ( ( Xa = Ya )
        & member(A,Xa,A1) ) ) ).

tff(fact_72_Id__on__eqI,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: A,A2: A] :
      ( ( A2 = B1 )
     => ( member(A,A2,A1)
       => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A2),B1),id_on(A,A1)) ) ) ).

tff(fact_73_Id__onE,axiom,
    ! [A: $tType,A1: fun(A,bool),C: product_prod(A,A)] :
      ( member(product_prod(A,A),C,id_on(A,A1))
     => ~ ! [X: A] :
            ( member(A,X,A1)
           => ( C != aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X),X) ) ) ) ).

tff(fact_74_antisymI,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( ! [X: A,Y: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X),Y),R)
         => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y),X),R)
           => ( X = Y ) ) )
     => antisym(A,R) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] :
      ( member(A,Xa,A1)
    <=> pp(aa(A,bool,A1,Xa)) ) ).

tff(fact_77_single__valued__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : single_valued(A,A,id_on(A,A1)) ).

tff(fact_78_single__valuedD,axiom,
    ! [A: $tType,B: $tType,Za: B,Ya: B,Xa: A,R: fun(product_prod(A,B),bool)] :
      ( single_valued(A,B,R)
     => ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Xa),Ya),R)
       => ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Xa),Za),R)
         => ( Ya = Za ) ) ) ) ).

tff(fact_79_single__valued__def,axiom,
    ! [A: $tType,B: $tType,R: fun(product_prod(A,B),bool)] :
      ( single_valued(A,B,R)
    <=> ! [X1: A,Y1: B] :
          ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Y1),R)
         => ! [Z1: B] :
              ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Z1),R)
             => ( Y1 = Z1 ) ) ) ) ).

tff(fact_80_single__valuedI,axiom,
    ! [B: $tType,A: $tType,R: fun(product_prod(A,B),bool)] :
      ( ! [X: A,Y: B] :
          ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X),Y),R)
         => ! [Z: B] :
              ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X),Z),R)
             => ( Y = Z ) ) )
     => single_valued(A,B,R) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ~ ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),x),y),arrow_276188178_mkbot(l,z))
    <=> ~ ( ( y != z )
          & ( ( x = z )
           => ( x != y ) )
          & ( ( x != z )
           => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),x),y),l) ) ) ) ).

%------------------------------------------------------------------------------
