%------------------------------------------------------------------------------
% File     : SCT180_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 78
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_78 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  128 (  40 unt;  32 typ;   0 def)
%            Number of atoms       :  182 (  91 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  125 (  39   ~;   2   |;   6   &)
%                                         (  18 <=>;  60  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   36 (  21   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-5 aty)
%            Number of functors    :   24 (  24 usr;   7 con; 0-5 aty)
%            Number of variables   :  596 ( 549   !;   6   ?; 596   :)
%                                         (  41  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:12
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (28)
tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_Omktop,type,
    arrow_424895264_mktop: ( fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) * arrow_411405190le_alt ) > fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A1: $tType,B1: $tType] : ( ( fun(product_prod(A1,B1),bool) * A1 * B1 ) > $o ) ).

tff(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B1: $tType,C1: $tType,A1: $tType] : ( ( fun(B1,C1) * fun(A1,B1) ) > fun(A1,C1) ) ).

tff(sy_c_Nitpick_Orefl_H,type,
    refl: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A1: $tType,B1: $tType] : ( ( A1 * B1 ) > product_prod(A1,B1) ) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A1: $tType,C1: $tType,B1: $tType] : ( ( fun(A1,C1) * product_prod(A1,B1) ) > product_prod(C1,B1) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B1: $tType,C1: $tType,A1: $tType] : ( ( fun(B1,C1) * product_prod(A1,B1) ) > product_prod(A1,C1) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A1: $tType,B1: $tType,C1: $tType] : ( fun(product_prod(A1,B1),C1) > fun(A1,fun(B1,C1)) ) ).

tff(sy_c_Product__Type_Ofst,type,
    product_fst: 
      !>[A1: $tType,B1: $tType] : ( product_prod(A1,B1) > A1 ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A1: $tType,B1: $tType,C1: $tType] : fun(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A1: $tType,B1: $tType,T2: $tType] : fun(fun(A1,fun(B1,T2)),fun(product_prod(A1,B1),T2)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A1: $tType,B1: $tType,T2: $tType] : ( ( fun(A1,fun(B1,T2)) * product_prod(A1,B1) ) > T2 ) ).

tff(sy_c_Product__Type_Osnd,type,
    product_snd: 
      !>[A1: $tType,B1: $tType] : ( product_prod(A1,B1) > B1 ) ).

tff(sy_c_Relation_Oconverse,type,
    converse: 
      !>[A1: $tType,B1: $tType] : ( fun(product_prod(A1,B1),bool) > fun(product_prod(B1,A1),bool) ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B1: $tType,A1: $tType] : ( ( fun(product_prod(B1,B1),bool) * fun(A1,B1) ) > fun(product_prod(A1,A1),bool) ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A1: $tType] : ( ( fun(A1,bool) * fun(product_prod(A1,A1),bool) ) > $o ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A1: $tType,B1: $tType] : ( ( fun(product_prod(A1,A1),bool) * fun(product_prod(B1,B1),bool) ) > fun(product_prod(product_prod(A1,B1),product_prod(A1,B1)),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B1: $tType] : ( ( fun(A1,B1) * A1 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_L,type,
    l: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_x,type,
    x: arrow_411405190le_alt ).

tff(sy_v_y,type,
    y: arrow_411405190le_alt ).

tff(sy_v_z,type,
    z: arrow_411405190le_alt ).

%----Relevant facts (93)
tff(fact_0_split__paired__All,axiom,
    ! [A1: $tType,B1: $tType,P: fun(product_prod(A1,B1),bool)] :
      ( ! [X11: product_prod(A1,B1)] : pp(aa(product_prod(A1,B1),bool,P,X11))
    <=> ! [A6: A1,B5: B1] : pp(aa(product_prod(A1,B1),bool,P,product_Pair(A1,B1,A6,B5))) ) ).

tff(fact_1_Pair__eq,axiom,
    ! [A1: $tType,B1: $tType,B4: B1,A5: A1,B: B1,A: A1] :
      ( ( product_Pair(A1,B1,A,B) = product_Pair(A1,B1,A5,B4) )
    <=> ( ( A = A5 )
        & ( B = B4 ) ) ) ).

tff(fact_2_notin__Lin__iff,axiom,
    ! [Ya: arrow_411405190le_alt,Xa: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( ( Xa != Ya )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Xa,Ya),La)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Ya,Xa),La) ) ) ) ).

tff(fact_3_Lin__irrefl,axiom,
    ! [B: arrow_411405190le_alt,A: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,A,B),La)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,B,A),La) ) ) ).

tff(fact_4_Pair__inject,axiom,
    ! [A1: $tType,B1: $tType,B6: B1,A7: A1,B3: B1,A4: A1] :
      ( ( product_Pair(A1,B1,A4,B3) = product_Pair(A1,B1,A7,B6) )
     => ~ ( ( A4 = A7 )
         => ( B3 != B6 ) ) ) ).

tff(fact_5_in__rel__def,axiom,
    ! [B1: $tType,A1: $tType,Ya: B1,Xa: A1,R1: fun(product_prod(A1,B1),bool)] :
      ( in_rel(A1,B1,R1,Xa,Ya)
    <=> member(product_prod(A1,B1),product_Pair(A1,B1,Xa,Ya),R1) ) ).

tff(fact_6_split__paired__Ex,axiom,
    ! [A1: $tType,B1: $tType,P: fun(product_prod(A1,B1),bool)] :
      ( ? [X11: product_prod(A1,B1)] : pp(aa(product_prod(A1,B1),bool,P,X11))
    <=> ? [A6: A1,B5: B1] : pp(aa(product_prod(A1,B1),bool,P,product_Pair(A1,B1,A6,B5))) ) ).

tff(fact_7_Nitpick_Orefl_H__def,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool)] :
      ( refl(A1,R)
    <=> ! [X2: A1] : member(product_prod(A1,A1),product_Pair(A1,A1,X2,X2),R) ) ).

tff(fact_8_in__lex__prod,axiom,
    ! [A1: $tType,B1: $tType,S: fun(product_prod(B1,B1),bool),R: fun(product_prod(A1,A1),bool),B4: B1,A5: A1,B: B1,A: A1] :
      ( member(product_prod(product_prod(A1,B1),product_prod(A1,B1)),product_Pair(product_prod(A1,B1),product_prod(A1,B1),product_Pair(A1,B1,A,B),product_Pair(A1,B1,A5,B4)),lex_prod(A1,B1,R,S))
    <=> ( member(product_prod(A1,A1),product_Pair(A1,A1,A,A5),R)
        | ( ( A = A5 )
          & member(product_prod(B1,B1),product_Pair(B1,B1,B,B4),S) ) ) ) ).

tff(fact_9_prod_Orecs,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,B: C1,A: B1,F11: fun(B1,fun(C1,A1))] : ( product_prod_rec(B1,C1,A1,F11,product_Pair(B1,C1,A,B)) = aa(C1,A1,aa(B1,fun(C1,A1),F11,A),B) ) ).

tff(fact_10_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D1: $tType,C1: $tType,B1: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D1,product_prod(E,F2))))),P: fun(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D1,product_prod(E,F2))))),bool)] :
      ( ! [A3: A1,B2: B1,C2: C1,D2: D1,E1: E,F3: F2] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D1,product_prod(E,F2))))),bool,P,product_Pair(A1,product_prod(B1,product_prod(C1,product_prod(D1,product_prod(E,F2)))),A3,product_Pair(B1,product_prod(C1,product_prod(D1,product_prod(E,F2))),B2,product_Pair(C1,product_prod(D1,product_prod(E,F2)),C2,product_Pair(D1,product_prod(E,F2),D2,product_Pair(E,F2,E1,F3)))))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D1,product_prod(E,F2))))),bool,P,Xa)) ) ).

tff(fact_11_prod__cases6,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,D1: $tType,E: $tType,F2: $tType,Y1: product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D1,product_prod(E,F2)))))] :
      ~ ! [A3: A1,B2: B1,C2: C1,D2: D1,E1: E,F3: F2] : ( Y1 != product_Pair(A1,product_prod(B1,product_prod(C1,product_prod(D1,product_prod(E,F2)))),A3,product_Pair(B1,product_prod(C1,product_prod(D1,product_prod(E,F2))),B2,product_Pair(C1,product_prod(D1,product_prod(E,F2)),C2,product_Pair(D1,product_prod(E,F2),D2,product_Pair(E,F2,E1,F3))))) ) ).

tff(fact_12_prod__cases5,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,D1: $tType,E: $tType,Y1: product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D1,E))))] :
      ~ ! [A3: A1,B2: B1,C2: C1,D2: D1,E1: E] : ( Y1 != product_Pair(A1,product_prod(B1,product_prod(C1,product_prod(D1,E))),A3,product_Pair(B1,product_prod(C1,product_prod(D1,E)),B2,product_Pair(C1,product_prod(D1,E),C2,product_Pair(D1,E,D2,E1)))) ) ).

tff(fact_13_prod__induct5,axiom,
    ! [E: $tType,D1: $tType,C1: $tType,B1: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D1,E)))),P: fun(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D1,E)))),bool)] :
      ( ! [A3: A1,B2: B1,C2: C1,D2: D1,E1: E] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D1,E)))),bool,P,product_Pair(A1,product_prod(B1,product_prod(C1,product_prod(D1,E))),A3,product_Pair(B1,product_prod(C1,product_prod(D1,E)),B2,product_Pair(C1,product_prod(D1,E),C2,product_Pair(D1,E,D2,E1))))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,product_prod(D1,E)))),bool,P,Xa)) ) ).

tff(fact_14_prod__cases4,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,D1: $tType,Y1: product_prod(A1,product_prod(B1,product_prod(C1,D1)))] :
      ~ ! [A3: A1,B2: B1,C2: C1,D2: D1] : ( Y1 != product_Pair(A1,product_prod(B1,product_prod(C1,D1)),A3,product_Pair(B1,product_prod(C1,D1),B2,product_Pair(C1,D1,C2,D2))) ) ).

tff(fact_15_prod__induct4,axiom,
    ! [D1: $tType,C1: $tType,B1: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B1,product_prod(C1,D1))),P: fun(product_prod(A1,product_prod(B1,product_prod(C1,D1))),bool)] :
      ( ! [A3: A1,B2: B1,C2: C1,D2: D1] : pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,D1))),bool,P,product_Pair(A1,product_prod(B1,product_prod(C1,D1)),A3,product_Pair(B1,product_prod(C1,D1),B2,product_Pair(C1,D1,C2,D2)))))
     => pp(aa(product_prod(A1,product_prod(B1,product_prod(C1,D1))),bool,P,Xa)) ) ).

tff(fact_16_prod__cases3,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,Y1: product_prod(A1,product_prod(B1,C1))] :
      ~ ! [A3: A1,B2: B1,C2: C1] : ( Y1 != product_Pair(A1,product_prod(B1,C1),A3,product_Pair(B1,C1,B2,C2)) ) ).

tff(fact_17_prod__induct3,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B1,C1)),P: fun(product_prod(A1,product_prod(B1,C1)),bool)] :
      ( ! [A3: A1,B2: B1,C2: C1] : pp(aa(product_prod(A1,product_prod(B1,C1)),bool,P,product_Pair(A1,product_prod(B1,C1),A3,product_Pair(B1,C1,B2,C2))))
     => pp(aa(product_prod(A1,product_prod(B1,C1)),bool,P,Xa)) ) ).

tff(fact_18_linear__alt,axiom,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin) ).

tff(fact_19_prod_Oexhaust,axiom,
    ! [A1: $tType,B1: $tType,Y1: product_prod(A1,B1)] :
      ~ ! [A3: A1,B2: B1] : ( Y1 != product_Pair(A1,B1,A3,B2) ) ).

tff(fact_20_PairE,axiom,
    ! [A1: $tType,B1: $tType,P2: product_prod(A1,B1)] :
      ~ ! [X3: A1,Y: B1] : ( P2 != product_Pair(A1,B1,X3,Y) ) ).

tff(fact_21_internal__split__conv,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,B: C1,A: B1,C: fun(B1,fun(C1,A1))] : ( aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),produc1605651328_split(B1,C1,A1),C),product_Pair(B1,C1,A,B)) = aa(C1,A1,aa(B1,fun(C1,A1),C,A),B) ) ).

tff(fact_22_curry__conv,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,B: C1,A: B1,F: fun(product_prod(B1,C1),A1)] : ( aa(C1,A1,aa(B1,fun(C1,A1),product_curry(B1,C1,A1,F),A),B) = aa(product_prod(B1,C1),A1,F,product_Pair(B1,C1,A,B)) ) ).

tff(fact_23_curryI,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(product_prod(A1,B1),bool,F,product_Pair(A1,B1,A,B)))
     => pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A),B)) ) ).

tff(fact_24_curryD,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A),B))
     => pp(aa(product_prod(A1,B1),bool,F,product_Pair(A1,B1,A,B))) ) ).

tff(fact_25_curryE,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F: fun(product_prod(A1,B1),bool)] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),product_curry(A1,B1,bool,F),A),B))
     => pp(aa(product_prod(A1,B1),bool,F,product_Pair(A1,B1,A,B))) ) ).

tff(fact_26_apsnd__conv,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,Ya: C1,Xa: A1,F: fun(C1,B1)] : ( product_apsnd(C1,B1,A1,F,product_Pair(A1,C1,Xa,Ya)) = product_Pair(A1,B1,Xa,aa(C1,B1,F,Ya)) ) ).

tff(fact_27_apfst__conv,axiom,
    ! [C1: $tType,A1: $tType,B1: $tType,Ya: B1,Xa: C1,F: fun(C1,A1)] : ( product_apfst(C1,A1,B1,F,product_Pair(C1,B1,Xa,Ya)) = product_Pair(A1,B1,aa(C1,A1,F,Xa),Ya) ) ).

tff(fact_28_apsnd__apfst__commute,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,D1: $tType,P1: product_prod(D1,C1),G: fun(D1,A1),F: fun(C1,B1)] : ( product_apsnd(C1,B1,A1,F,product_apfst(D1,A1,C1,G,P1)) = product_apfst(D1,A1,B1,G,product_apsnd(C1,B1,D1,F,P1)) ) ).

tff(fact_29_apfst__convE,axiom,
    ! [C1: $tType,A1: $tType,B1: $tType,P1: product_prod(C1,B1),F: fun(C1,A1),Q1: product_prod(A1,B1)] :
      ( ( Q1 = product_apfst(C1,A1,B1,F,P1) )
     => ~ ! [X3: C1,Y: B1] :
            ( ( P1 = product_Pair(C1,B1,X3,Y) )
           => ( Q1 != product_Pair(A1,B1,aa(C1,A1,F,X3),Y) ) ) ) ).

tff(fact_30_internal__split__def,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType] : ( produc1605651328_split(A1,B1,C1) = product_prod_case(A1,B1,C1) ) ).

tff(fact_31_surj__pair,axiom,
    ! [A1: $tType,B1: $tType,P2: product_prod(A1,B1)] :
    ? [X3: A1,Y: B1] : ( P2 = product_Pair(A1,B1,X3,Y) ) ).

tff(fact_32_converse__in__Lin,axiom,
    ! [La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),converse(arrow_411405190le_alt,arrow_411405190le_alt,La),arrow_1985332922le_Lin)
    <=> member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin) ) ).

tff(fact_33_apsnd__apfst,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,D1: $tType,Xa: product_prod(D1,C1),G: fun(D1,A1),F: fun(C1,B1)] : ( product_apsnd(C1,B1,A1,F,product_apfst(D1,A1,C1,G,Xa)) = product_Pair(A1,B1,aa(D1,A1,G,product_fst(D1,C1,Xa)),aa(C1,B1,F,product_snd(D1,C1,Xa))) ) ).

tff(fact_34_apfst__apsnd,axiom,
    ! [A1: $tType,B1: $tType,D1: $tType,C1: $tType,Xa: product_prod(C1,D1),G: fun(D1,B1),F: fun(C1,A1)] : ( product_apfst(C1,A1,B1,F,product_apsnd(D1,B1,C1,G,Xa)) = product_Pair(A1,B1,aa(C1,A1,F,product_fst(C1,D1,Xa)),aa(D1,B1,G,product_snd(C1,D1,Xa))) ) ).

tff(fact_35_splitI,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),F,A),B))
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F),product_Pair(A1,B1,A,B))) ) ).

tff(fact_36_prod__caseI,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F11: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),F11,A),B))
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F11),product_Pair(A1,B1,A,B))) ) ).

tff(fact_37_mem__splitI,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,B: C1,A: B1,C: fun(B1,fun(C1,fun(A1,bool))),Za: A1] :
      ( member(A1,Za,aa(C1,fun(A1,bool),aa(B1,fun(C1,fun(A1,bool)),C,A),B))
     => member(A1,Za,aa(product_prod(B1,C1),fun(A1,bool),aa(fun(B1,fun(C1,fun(A1,bool))),fun(product_prod(B1,C1),fun(A1,bool)),product_prod_case(B1,C1,fun(A1,bool)),C),product_Pair(B1,C1,A,B))) ) ).

tff(fact_38_split__conv,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,B: C1,A: B1,F: fun(B1,fun(C1,A1))] : ( aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),product_prod_case(B1,C1,A1),F),product_Pair(B1,C1,A,B)) = aa(C1,A1,aa(B1,fun(C1,A1),F,A),B) ) ).

tff(fact_39_fst__apsnd,axiom,
    ! [B1: $tType,C1: $tType,A1: $tType,Xa: product_prod(A1,C1),F: fun(C1,B1)] : ( product_fst(A1,B1,product_apsnd(C1,B1,A1,F,Xa)) = product_fst(A1,C1,Xa) ) ).

tff(fact_40_fst__apfst,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,Xa: product_prod(C1,B1),F: fun(C1,A1)] : ( product_fst(A1,B1,product_apfst(C1,A1,B1,F,Xa)) = aa(C1,A1,F,product_fst(C1,B1,Xa)) ) ).

tff(fact_41_apfst__eq__conv,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,G: fun(C1,A1),Xa: product_prod(C1,B1),F: fun(C1,A1)] :
      ( ( product_apfst(C1,A1,B1,F,Xa) = product_apfst(C1,A1,B1,G,Xa) )
    <=> ( aa(C1,A1,F,product_fst(C1,B1,Xa)) = aa(C1,A1,G,product_fst(C1,B1,Xa)) ) ) ).

tff(fact_42_snd__apfst,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,Xa: product_prod(C1,A1),F: fun(C1,B1)] : ( product_snd(B1,A1,product_apfst(C1,B1,A1,F,Xa)) = product_snd(C1,A1,Xa) ) ).

tff(fact_43_snd__apsnd,axiom,
    ! [A1: $tType,C1: $tType,B1: $tType,Xa: product_prod(B1,C1),F: fun(C1,A1)] : ( product_snd(B1,A1,product_apsnd(C1,A1,B1,F,Xa)) = aa(C1,A1,F,product_snd(B1,C1,Xa)) ) ).

tff(fact_44_apsnd__eq__conv,axiom,
    ! [B1: $tType,C1: $tType,A1: $tType,G: fun(C1,B1),Xa: product_prod(A1,C1),F: fun(C1,B1)] :
      ( ( product_apsnd(C1,B1,A1,F,Xa) = product_apsnd(C1,B1,A1,G,Xa) )
    <=> ( aa(C1,B1,F,product_snd(A1,C1,Xa)) = aa(C1,B1,G,product_snd(A1,C1,Xa)) ) ) ).

tff(fact_45_surjective__pairing,axiom,
    ! [B1: $tType,A1: $tType,T1: product_prod(A1,B1)] : ( T1 = product_Pair(A1,B1,product_fst(A1,B1,T1),product_snd(A1,B1,T1)) ) ).

tff(fact_46_prod__eq__iff,axiom,
    ! [B1: $tType,A1: $tType,T: product_prod(A1,B1),S: product_prod(A1,B1)] :
      ( ( S = T )
    <=> ( ( product_fst(A1,B1,S) = product_fst(A1,B1,T) )
        & ( product_snd(A1,B1,S) = product_snd(A1,B1,T) ) ) ) ).

tff(fact_47_prod__case__beta,axiom,
    ! [A1: $tType,C1: $tType,B1: $tType,P1: product_prod(B1,C1),F: fun(B1,fun(C1,A1))] : ( aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),product_prod_case(B1,C1,A1),F),P1) = aa(C1,A1,aa(B1,fun(C1,A1),F,product_fst(B1,C1,P1)),product_snd(B1,C1,P1)) ) ).

tff(fact_48_pair__collapse,axiom,
    ! [B1: $tType,A1: $tType,P2: product_prod(A1,B1)] : ( product_Pair(A1,B1,product_fst(A1,B1,P2),product_snd(A1,B1,P2)) = P2 ) ).

tff(fact_49_split__weak__cong,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,C: fun(A1,fun(B1,C1)),Q1: product_prod(A1,B1),P1: product_prod(A1,B1)] :
      ( ( P1 = Q1 )
     => ( aa(product_prod(A1,B1),C1,aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),C),P1) = aa(product_prod(A1,B1),C1,aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),C),Q1) ) ) ).

tff(fact_50_prod__eqI,axiom,
    ! [B1: $tType,A1: $tType,Q2: product_prod(A1,B1),P2: product_prod(A1,B1)] :
      ( ( product_fst(A1,B1,P2) = product_fst(A1,B1,Q2) )
     => ( ( product_snd(A1,B1,P2) = product_snd(A1,B1,Q2) )
       => ( P2 = Q2 ) ) ) ).

tff(fact_51_splitD,axiom,
    ! [A1: $tType,B1: $tType,B: B1,A: A1,F: fun(A1,fun(B1,bool))] :
      ( pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),F),product_Pair(A1,B1,A,B)))
     => pp(aa(B1,bool,aa(A1,fun(B1,bool),F,A),B)) ) ).

tff(fact_52_fst__conv,axiom,
    ! [B1: $tType,A1: $tType,B3: B1,A4: A1] : ( product_fst(A1,B1,product_Pair(A1,B1,A4,B3)) = A4 ) ).

tff(fact_53_fst__eqD,axiom,
    ! [B1: $tType,A1: $tType,A4: A1,Y1: B1,X4: A1] :
      ( ( product_fst(A1,B1,product_Pair(A1,B1,X4,Y1)) = A4 )
     => ( X4 = A4 ) ) ).

tff(fact_54_splitD_H,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,C: C1,B: B1,A: A1,R1: fun(A1,fun(B1,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A1,B1),fun(C1,bool),aa(fun(A1,fun(B1,fun(C1,bool))),fun(product_prod(A1,B1),fun(C1,bool)),product_prod_case(A1,B1,fun(C1,bool)),R1),product_Pair(A1,B1,A,B)),C))
     => pp(aa(C1,bool,aa(B1,fun(C1,bool),aa(A1,fun(B1,fun(C1,bool)),R1,A),B),C)) ) ).

tff(fact_55_snd__conv,axiom,
    ! [B1: $tType,A1: $tType,B3: A1,A4: B1] : ( product_snd(B1,A1,product_Pair(B1,A1,A4,B3)) = B3 ) ).

tff(fact_56_snd__eqD,axiom,
    ! [B1: $tType,A1: $tType,A4: A1,Y1: A1,X4: B1] :
      ( ( product_snd(B1,A1,product_Pair(B1,A1,X4,Y1)) = A4 )
     => ( Y1 = A4 ) ) ).

tff(fact_57_prod_Osimps_I2_J,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,B: C1,A: B1,F11: fun(B1,fun(C1,A1))] : ( aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),product_prod_case(B1,C1,A1),F11),product_Pair(B1,C1,A,B)) = aa(C1,A1,aa(B1,fun(C1,A1),F11,A),B) ) ).

tff(fact_58_curry__split,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,F: fun(A1,fun(B1,C1))] : ( product_curry(A1,B1,C1,aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),F)) = F ) ).

tff(fact_59_split__curry,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,F: fun(product_prod(A1,B1),C1)] : ( aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),product_curry(A1,B1,C1,F)) = F ) ).

tff(fact_60_converse__iff,axiom,
    ! [A1: $tType,B1: $tType,R: fun(product_prod(B1,A1),bool),B: B1,A: A1] :
      ( member(product_prod(A1,B1),product_Pair(A1,B1,A,B),converse(B1,A1,R))
    <=> member(product_prod(B1,A1),product_Pair(B1,A1,B,A),R) ) ).

tff(fact_61_splitI2,axiom,
    ! [B1: $tType,A1: $tType,C: fun(A1,fun(B1,bool)),P1: product_prod(A1,B1)] :
      ( ! [A3: A1,B2: B1] :
          ( ( P1 = product_Pair(A1,B1,A3,B2) )
         => pp(aa(B1,bool,aa(A1,fun(B1,bool),C,A3),B2)) )
     => pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),C),P1)) ) ).

tff(fact_62_splitE,axiom,
    ! [A1: $tType,B1: $tType,P1: product_prod(A1,B1),C: fun(A1,fun(B1,bool))] :
      ( pp(aa(product_prod(A1,B1),bool,aa(fun(A1,fun(B1,bool)),fun(product_prod(A1,B1),bool),product_prod_case(A1,B1,bool),C),P1))
     => ~ ! [X3: A1,Y: B1] :
            ( ( P1 = product_Pair(A1,B1,X3,Y) )
           => ~ pp(aa(B1,bool,aa(A1,fun(B1,bool),C,X3),Y)) ) ) ).

tff(fact_63_mem__splitI2,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,C: fun(A1,fun(B1,fun(C1,bool))),Za: C1,P1: product_prod(A1,B1)] :
      ( ! [A3: A1,B2: B1] :
          ( ( P1 = product_Pair(A1,B1,A3,B2) )
         => member(C1,Za,aa(B1,fun(C1,bool),aa(A1,fun(B1,fun(C1,bool)),C,A3),B2)) )
     => member(C1,Za,aa(product_prod(A1,B1),fun(C1,bool),aa(fun(A1,fun(B1,fun(C1,bool))),fun(product_prod(A1,B1),fun(C1,bool)),product_prod_case(A1,B1,fun(C1,bool)),C),P1)) ) ).

tff(fact_64_splitI2_H,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,Xa: C1,C: fun(A1,fun(B1,fun(C1,bool))),P1: product_prod(A1,B1)] :
      ( ! [A3: A1,B2: B1] :
          ( ( product_Pair(A1,B1,A3,B2) = P1 )
         => pp(aa(C1,bool,aa(B1,fun(C1,bool),aa(A1,fun(B1,fun(C1,bool)),C,A3),B2),Xa)) )
     => pp(aa(C1,bool,aa(product_prod(A1,B1),fun(C1,bool),aa(fun(A1,fun(B1,fun(C1,bool))),fun(product_prod(A1,B1),fun(C1,bool)),product_prod_case(A1,B1,fun(C1,bool)),C),P1),Xa)) ) ).

tff(fact_65_converse__converse,axiom,
    ! [B1: $tType,A1: $tType,R: fun(product_prod(A1,B1),bool)] : ( converse(B1,A1,converse(A1,B1,R)) = R ) ).

tff(fact_66_converseI,axiom,
    ! [B1: $tType,A1: $tType,R: fun(product_prod(A1,B1),bool),B: B1,A: A1] :
      ( member(product_prod(A1,B1),product_Pair(A1,B1,A,B),R)
     => member(product_prod(B1,A1),product_Pair(B1,A1,B,A),converse(A1,B1,R)) ) ).

tff(fact_67_converseD,axiom,
    ! [A1: $tType,B1: $tType,R: fun(product_prod(B1,A1),bool),B: B1,A: A1] :
      ( member(product_prod(A1,B1),product_Pair(A1,B1,A,B),converse(B1,A1,R))
     => member(product_prod(B1,A1),product_Pair(B1,A1,B,A),R) ) ).

tff(fact_68_splitE_H,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,Za: C1,P1: product_prod(A1,B1),C: fun(A1,fun(B1,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A1,B1),fun(C1,bool),aa(fun(A1,fun(B1,fun(C1,bool))),fun(product_prod(A1,B1),fun(C1,bool)),product_prod_case(A1,B1,fun(C1,bool)),C),P1),Za))
     => ~ ! [X3: A1,Y: B1] :
            ( ( P1 = product_Pair(A1,B1,X3,Y) )
           => ~ pp(aa(C1,bool,aa(B1,fun(C1,bool),aa(A1,fun(B1,fun(C1,bool)),C,X3),Y),Za)) ) ) ).

tff(fact_69_mem__splitE,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,P1: product_prod(B1,C1),C: fun(B1,fun(C1,fun(A1,bool))),Za: A1] :
      ( member(A1,Za,aa(product_prod(B1,C1),fun(A1,bool),aa(fun(B1,fun(C1,fun(A1,bool))),fun(product_prod(B1,C1),fun(A1,bool)),product_prod_case(B1,C1,fun(A1,bool)),C),P1))
     => ~ ! [X3: B1,Y: C1] :
            ( ( P1 = product_Pair(B1,C1,X3,Y) )
           => ~ member(A1,Za,aa(C1,fun(A1,bool),aa(B1,fun(C1,fun(A1,bool)),C,X3),Y)) ) ) ).

tff(fact_70_converseE,axiom,
    ! [A1: $tType,B1: $tType,R: fun(product_prod(B1,A1),bool),Yx: product_prod(A1,B1)] :
      ( member(product_prod(A1,B1),Yx,converse(B1,A1,R))
     => ~ ! [X3: B1,Y: A1] :
            ( ( Yx = product_Pair(A1,B1,Y,X3) )
           => ~ member(product_prod(B1,A1),product_Pair(B1,A1,X3,Y),R) ) ) ).

tff(fact_71_conjI__realizer,axiom,
    ! [A1: $tType,B1: $tType,Q1: B1,Q: fun(B1,bool),P1: A1,P: fun(A1,bool)] :
      ( pp(aa(A1,bool,P,P1))
     => ( pp(aa(B1,bool,Q,Q1))
       => ( pp(aa(A1,bool,P,product_fst(A1,B1,product_Pair(A1,B1,P1,Q1))))
          & pp(aa(B1,bool,Q,product_snd(A1,B1,product_Pair(A1,B1,P1,Q1)))) ) ) ) ).

tff(fact_72_exI__realizer,axiom,
    ! [B1: $tType,A1: $tType,Xa: B1,Ya: A1,P: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),P,Ya),Xa))
     => pp(aa(B1,bool,aa(A1,fun(B1,bool),P,product_snd(B1,A1,product_Pair(B1,A1,Xa,Ya))),product_fst(B1,A1,product_Pair(B1,A1,Xa,Ya)))) ) ).

tff(fact_73_split__cong,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,P1: product_prod(A1,B1),G: fun(A1,fun(B1,C1)),F: fun(A1,fun(B1,C1)),Q1: product_prod(A1,B1)] :
      ( ! [X3: A1,Y: B1] :
          ( ( product_Pair(A1,B1,X3,Y) = Q1 )
         => ( aa(B1,C1,aa(A1,fun(B1,C1),F,X3),Y) = aa(B1,C1,aa(A1,fun(B1,C1),G,X3),Y) ) )
     => ( ( P1 = Q1 )
       => ( aa(product_prod(A1,B1),C1,aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),F),P1) = aa(product_prod(A1,B1),C1,aa(fun(A1,fun(B1,C1)),fun(product_prod(A1,B1),C1),product_prod_case(A1,B1,C1),G),Q1) ) ) ) ).

tff(fact_74_exE__realizer_H,axiom,
    ! [A1: $tType,B1: $tType,P1: product_prod(B1,A1),P: fun(A1,fun(B1,bool))] :
      ( pp(aa(B1,bool,aa(A1,fun(B1,bool),P,product_snd(B1,A1,P1)),product_fst(B1,A1,P1)))
     => ~ ! [X3: B1,Y: A1] : ~ pp(aa(B1,bool,aa(A1,fun(B1,bool),P,Y),X3)) ) ).

tff(fact_75_ext,axiom,
    ! [B1: $tType,A1: $tType,G: fun(A1,B1),F: fun(A1,B1)] :
      ( ! [X3: A1] : ( aa(A1,B1,F,X3) = aa(A1,B1,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A1: $tType,A2: fun(A1,bool),Xa: A1] :
      ( member(A1,Xa,A2)
    <=> pp(aa(A1,bool,A2,Xa)) ) ).

tff(fact_77_splitE2,axiom,
    ! [B1: $tType,A1: $tType,C1: $tType,Za: product_prod(B1,C1),P: fun(B1,fun(C1,A1)),Q: fun(A1,bool)] :
      ( pp(aa(A1,bool,Q,aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),product_prod_case(B1,C1,A1),P),Za)))
     => ~ ! [X3: B1,Y: C1] :
            ( ( Za = product_Pair(B1,C1,X3,Y) )
           => ~ pp(aa(A1,bool,Q,aa(C1,A1,aa(B1,fun(C1,A1),P,X3),Y))) ) ) ).

tff(fact_78_total__on__converse,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),A2: fun(A1,bool)] :
      ( total_on(A1,A2,converse(A1,A1,R))
    <=> total_on(A1,A2,R) ) ).

tff(fact_79_converse__inv__image,axiom,
    ! [B1: $tType,A1: $tType,F: fun(A1,B1),R1: fun(product_prod(B1,B1),bool)] : ( converse(A1,A1,inv_image(B1,A1,R1,F)) = inv_image(B1,A1,converse(B1,B1,R1),F) ) ).

tff(fact_80_in__inv__image,axiom,
    ! [A1: $tType,B1: $tType,F: fun(A1,B1),R: fun(product_prod(B1,B1),bool),Ya: A1,Xa: A1] :
      ( member(product_prod(A1,A1),product_Pair(A1,A1,Xa,Ya),inv_image(B1,A1,R,F))
    <=> member(product_prod(B1,B1),product_Pair(B1,B1,aa(A1,B1,F,Xa),aa(A1,B1,F,Ya)),R) ) ).

tff(fact_81_total__on__def,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),A2: fun(A1,bool)] :
      ( total_on(A1,A2,R)
    <=> ! [X2: A1] :
          ( member(A1,X2,A2)
         => ! [Xa1: A1] :
              ( member(A1,Xa1,A2)
             => ( ( X2 != Xa1 )
               => ( member(product_prod(A1,A1),product_Pair(A1,A1,X2,Xa1),R)
                  | member(product_prod(A1,A1),product_Pair(A1,A1,Xa1,X2),R) ) ) ) ) ) ).

tff(fact_82_irrefl__def,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool)] :
      ( irrefl(A1,R)
    <=> ! [X2: A1] : ~ member(product_prod(A1,A1),product_Pair(A1,A1,X2,X2),R) ) ).

tff(fact_83_split__comp,axiom,
    ! [D1: $tType,A1: $tType,C1: $tType,B1: $tType,Xa: product_prod(B1,C1),G: fun(B1,D1),F: fun(D1,fun(C1,A1))] : ( aa(product_prod(B1,C1),A1,aa(fun(B1,fun(C1,A1)),fun(product_prod(B1,C1),A1),product_prod_case(B1,C1,A1),comp(D1,fun(C1,A1),B1,F,G)),Xa) = aa(C1,A1,aa(D1,fun(C1,A1),F,aa(B1,D1,G,product_fst(B1,C1,Xa))),product_snd(B1,C1,Xa)) ) ).

tff(fact_84_apsnd__compose,axiom,
    ! [C1: $tType,B1: $tType,D1: $tType,A1: $tType,Xa: product_prod(A1,D1),G: fun(D1,C1),F: fun(C1,B1)] : ( product_apsnd(C1,B1,A1,F,product_apsnd(D1,C1,A1,G,Xa)) = product_apsnd(D1,B1,A1,comp(C1,B1,D1,F,G),Xa) ) ).

tff(fact_85_apfst__compose,axiom,
    ! [C1: $tType,A1: $tType,B1: $tType,D1: $tType,Xa: product_prod(D1,B1),G: fun(D1,C1),F: fun(C1,A1)] : ( product_apfst(C1,A1,B1,F,product_apfst(D1,C1,B1,G,Xa)) = product_apfst(D1,A1,B1,comp(C1,A1,D1,F,G),Xa) ) ).

tff(fact_86_comp__cong,axiom,
    ! [C1: $tType,B1: $tType,D1: $tType,A1: $tType,E: $tType,X1: E,G1: fun(E,D1),F1: fun(D1,A1),Xa: C1,G: fun(C1,B1),F: fun(B1,A1)] :
      ( ( aa(B1,A1,F,aa(C1,B1,G,Xa)) = aa(D1,A1,F1,aa(E,D1,G1,X1)) )
     => ( aa(C1,A1,comp(B1,A1,C1,F,G),Xa) = aa(E,A1,comp(D1,A1,E,F1,G1),X1) ) ) ).

tff(fact_87_o__apply,axiom,
    ! [A1: $tType,B1: $tType,C1: $tType,Xa: C1,G: fun(C1,B1),F: fun(B1,A1)] : ( aa(C1,A1,comp(B1,A1,C1,F,G),Xa) = aa(B1,A1,F,aa(C1,B1,G,Xa)) ) ).

tff(fact_88_o__eq__elim,axiom,
    ! [C1: $tType,B1: $tType,D1: $tType,A1: $tType,D: fun(A1,D1),C: fun(D1,B1),B: fun(A1,C1),A: fun(C1,B1)] :
      ( ( comp(C1,B1,A1,A,B) = comp(D1,B1,A1,C,D) )
     => ! [V1: A1] : ( aa(C1,B1,A,aa(A1,C1,B,V1)) = aa(D1,B1,C,aa(A1,D1,D,V1)) ) ) ).

tff(fact_89_o__def,axiom,
    ! [B1: $tType,C1: $tType,A1: $tType,G: fun(A1,C1),F: fun(C1,B1),X: A1] : ( aa(A1,B1,comp(C1,B1,A1,F,G),X) = aa(C1,B1,F,aa(A1,C1,G,X)) ) ).

tff(fact_90_o__assoc,axiom,
    ! [C1: $tType,B1: $tType,D1: $tType,A1: $tType,H: fun(A1,D1),G: fun(D1,C1),F: fun(C1,B1)] : ( comp(C1,B1,A1,F,comp(D1,C1,A1,G,H)) = comp(D1,B1,A1,comp(C1,B1,D1,F,G),H) ) ).

tff(fact_91_o__eq__dest,axiom,
    ! [C1: $tType,B1: $tType,D1: $tType,A1: $tType,V: A1,D: fun(A1,D1),C: fun(D1,B1),B: fun(A1,C1),A: fun(C1,B1)] :
      ( ( comp(C1,B1,A1,A,B) = comp(D1,B1,A1,C,D) )
     => ( aa(C1,B1,A,aa(A1,C1,B,V)) = aa(D1,B1,C,aa(A1,D1,D,V)) ) ) ).

tff(fact_92_o__eq__dest__lhs,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,V: A1,C: fun(A1,B1),B: fun(A1,C1),A: fun(C1,B1)] :
      ( ( comp(C1,B1,A1,A,B) = C )
     => ( aa(C1,B1,A,aa(A1,C1,B,V)) = aa(A1,B1,C,V) ) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ~ ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,x,y),arrow_424895264_mktop(l,z))
    <=> ~ ( ( x != z )
          & ( ( y = z )
           => ( x != y ) )
          & ( ( y != z )
           => member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,x,y),l) ) ) ) ).

%------------------------------------------------------------------------------
