%------------------------------------------------------------------------------
% File     : SCT179_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 56
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_56 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.5.0, 0.00 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  173 (  59 unt;  47 typ;   0 def)
%            Number of atoms       :  224 (  57 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  119 (  21   ~;   8   |;   8   &)
%                                         (  22 <=>;  60  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   4 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   46 (  28   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-6 aty)
%            Number of functors    :   25 (  25 usr;   6 con; 0-5 aty)
%            Number of variables   :  354 ( 303   !;   4   ?; 354   :)
%                                         (  47  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:10
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (42)
tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Order__Relation_Olinear__order__on,type,
    order_1409979114der_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Opartial__order__on,type,
    order_915043626der_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Opreorder__on,type,
    order_preorder_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(product_prod(A,A),bool),bool) ) ).

tff(sy_c_Order__Relation_Owell__order__on,type,
    order_well_order_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Relation_ODomain,type,
    domain: 
      !>[A: $tType,B: $tType] : ( fun(product_prod(A,B),bool) > fun(A,bool) ) ).

tff(sy_c_Relation_OId,type,
    id: 
      !>[A: $tType] : fun(product_prod(A,A),bool) ).

tff(sy_c_Relation_OId__on,type,
    id_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_ORange,type,
    range: 
      !>[A: $tType,B: $tType] : ( fun(product_prod(A,B),bool) > fun(B,bool) ) ).

tff(sy_c_Relation_Oantisym,type,
    antisym: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Orefl__on,type,
    refl_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Relation_Otrans,type,
    trans: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,A),bool) * fun(product_prod(B,B),bool) ) > fun(product_prod(product_prod(A,B),product_prod(A,B)),bool) ) ).

tff(sy_c_Wellfounded_Omeasure,type,
    measure: 
      !>[A: $tType] : ( fun(A,nat) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Wellfounded_Owf,type,
    wf: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_r,type,
    r: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

%----Relevant facts (100)
tff(fact_0_strict__linear__order__on__diff__Id,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_1409979114der_on(A,A1,R1)
     => pp(aa(fun(product_prod(A,A),bool),bool,order_215145569der_on(A,A1),minus_minus(fun(product_prod(A,A),bool),R1,id(A)))) ) ).

tff(fact_1_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_2_Diff__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),minus_minus(fun(A,bool),A1,B1)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A1))
        & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1)) ) ) ).

tff(fact_3_Diff__idemp,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( minus_minus(fun(A,bool),minus_minus(fun(A,bool),A1,B1),B1) = minus_minus(fun(A,bool),A1,B1) ) ).

tff(fact_4_DiffI,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),minus_minus(fun(A,bool),A1,B1))) ) ) ).

tff(fact_5_DiffE,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),minus_minus(fun(A,bool),A1,B1)))
     => ~ ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A1))
         => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1)) ) ) ).

tff(fact_6_top1I,axiom,
    ! [A: $tType,X: A] : pp(aa(A,bool,top_top(fun(A,bool)),X)) ).

tff(fact_7_UNIV__I,axiom,
    ! [A: $tType,X: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),top_top(fun(A,bool)))) ).

tff(fact_8_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),top_top(fun(A,bool)))) ).

tff(fact_9_well__order__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_well_order_on(A,A1,R1)
    <=> ( order_1409979114der_on(A,A1,R1)
        & wf(A,minus_minus(fun(product_prod(A,A),bool),R1,id(A))) ) ) ).

tff(fact_10_fun__diff__def,axiom,
    ! [B: $tType,A: $tType] :
      ( cl_Groups_Ominus(B)
     => ! [B1: fun(A,B),A1: fun(A,B),X3: A] : ( aa(A,B,minus_minus(fun(A,B),A1,B1),X3) = minus_minus(B,aa(A,B,A1,X3),aa(A,B,B1,X3)) ) ) ).

tff(fact_11_minus__apply,axiom,
    ! [A: $tType,B: $tType] :
      ( cl_Groups_Ominus(A)
     => ! [X: B,B1: fun(B,A),A1: fun(B,A)] : ( aa(B,A,minus_minus(fun(B,A),A1,B1),X) = minus_minus(A,aa(B,A,A1,X),aa(B,A,B1,X)) ) ) ).

tff(fact_12_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_13_DiffD2,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),minus_minus(fun(A,bool),A1,B1)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1)) ) ).

tff(fact_14_DiffD1,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),minus_minus(fun(A,bool),A1,B1)))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A1)) ) ).

tff(fact_15_set__diff__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( minus_minus(fun(A,bool),A1,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,fun(A,bool),bool,member(A),A1)),combb(bool,bool,A,fNot,combc(A,fun(A,bool),bool,member(A),B1)))) ) ).

tff(fact_16_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X: B] : ( aa(B,A,top_top(fun(B,A)),X) = top_top(A) ) ) ).

tff(fact_17_UNIV__eq__I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
     => ( top_top(fun(A,bool)) = A1 ) ) ).

tff(fact_18_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),top_top(fun(A,bool)))) ).

tff(fact_19_irrefl__diff__Id,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] : irrefl(A,minus_minus(fun(product_prod(A,A),bool),R1,id(A))) ).

tff(fact_20_total__on__diff__Id,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( total_on(A,A1,minus_minus(fun(product_prod(A,A),bool),R1,id(A)))
    <=> total_on(A,A1,R1) ) ).

tff(fact_21_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D1: A,C2: A,B2: A,A3: A] :
          ( ( minus_minus(A,A3,B2) = minus_minus(A,C2,D1) )
         => ( ( A3 = B2 )
          <=> ( C2 = D1 ) ) ) ) ).

tff(fact_22_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Y1: B,X: B,F: fun(B,A),R1: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R1,F,X,Y1)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R1,aa(B,A,F,X)),aa(B,A,F,Y1))) ) ).

tff(fact_23_well__order__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
    ? [X11: fun(product_prod(A,A),bool)] : order_well_order_on(A,A1,X11) ).

tff(fact_24_Diff__UNIV,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( minus_minus(fun(A,bool),A1,top_top(fun(A,bool))) = bot_bot(fun(A,bool)) ) ).

tff(fact_25_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X4: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_26_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X4: A] : ~ pp(aa(A,bool,P1,X4)) ) ).

tff(fact_27_empty__iff,axiom,
    ! [A: $tType,C2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),bot_bot(fun(A,bool)))) ).

tff(fact_28_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X4: A] : ~ pp(aa(A,bool,P1,X4)) ) ).

tff(fact_29_emptyE,axiom,
    ! [A: $tType,A3: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),bot_bot(fun(A,bool)))) ).

tff(fact_30_empty__Diff,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( minus_minus(fun(A,bool),bot_bot(fun(A,bool)),A1) = bot_bot(fun(A,bool)) ) ).

tff(fact_31_Diff__cancel,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( minus_minus(fun(A,bool),A1,A1) = bot_bot(fun(A,bool)) ) ).

tff(fact_32_bot__empty__eq,axiom,
    ! [A: $tType,X3: A] :
      ( pp(aa(A,bool,bot_bot(fun(A,bool)),X3))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),bot_bot(fun(A,bool)))) ) ).

tff(fact_33_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_34_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X4: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_35_equals0D,axiom,
    ! [A: $tType,A3: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1)) ) ).

tff(fact_36_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X: B] : ( aa(B,A,bot_bot(fun(B,A)),X) = bot_bot(A) ) ) ).

tff(fact_37_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X3: A] : ( aa(A,B,bot_bot(fun(A,B)),X3) = bot_bot(B) ) ) ).

tff(fact_38_total__on__empty,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] : total_on(A,bot_bot(fun(A,bool)),R1) ).

tff(fact_39_lnear__order__on__empty,axiom,
    ! [A: $tType] : order_1409979114der_on(A,bot_bot(fun(A,bool)),bot_bot(fun(product_prod(A,A),bool))) ).

tff(fact_40_well__order__on__empty,axiom,
    ! [A: $tType] : order_well_order_on(A,bot_bot(fun(A,bool)),bot_bot(fun(product_prod(A,A),bool))) ).

tff(fact_41_UNIV__not__empty,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) != bot_bot(fun(A,bool)) ) ).

tff(fact_42_Diff__empty,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( minus_minus(fun(A,bool),A1,bot_bot(fun(A,bool))) = A1 ) ).

tff(fact_43_wf__empty,axiom,
    ! [A: $tType] : wf(A,bot_bot(fun(product_prod(A,A),bool))) ).

tff(fact_44_linear__order__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_1409979114der_on(A,A1,R1)
    <=> ( order_915043626der_on(A,A1,R1)
        & total_on(A,A1,R1) ) ) ).

tff(fact_45_strict__linear__order__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,order_215145569der_on(A,A1),R1))
    <=> ( trans(A,R1)
        & irrefl(A,R1)
        & total_on(A,A1,R1) ) ) ).

tff(fact_46_equals0I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [Y: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y),A1))
     => ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_47_Range__Id,axiom,
    ! [A: $tType] : ( range(A,A,id(A)) = top_top(fun(A,bool)) ) ).

tff(fact_48_Domain__Id,axiom,
    ! [A: $tType] : ( domain(A,A,id(A)) = top_top(fun(A,bool)) ) ).

tff(fact_49_refl__Id,axiom,
    ! [A: $tType] : refl_on(A,top_top(fun(A,bool)),id(A)) ).

tff(fact_50_Domain__empty,axiom,
    ! [B: $tType,A: $tType] : ( domain(A,B,bot_bot(fun(product_prod(A,B),bool))) = bot_bot(fun(A,bool)) ) ).

tff(fact_51_Range__empty,axiom,
    ! [B: $tType,A: $tType] : ( range(B,A,bot_bot(fun(product_prod(B,A),bool))) = bot_bot(fun(A,bool)) ) ).

tff(fact_52_Domain__empty__iff,axiom,
    ! [B: $tType,A: $tType,R1: fun(product_prod(A,B),bool)] :
      ( ( domain(A,B,R1) = bot_bot(fun(A,bool)) )
    <=> ( R1 = bot_bot(fun(product_prod(A,B),bool)) ) ) ).

tff(fact_53_Range__empty__iff,axiom,
    ! [A: $tType,B: $tType,R1: fun(product_prod(B,A),bool)] :
      ( ( range(B,A,R1) = bot_bot(fun(A,bool)) )
    <=> ( R1 = bot_bot(fun(product_prod(B,A),bool)) ) ) ).

tff(fact_54_refl__on__empty,axiom,
    ! [A: $tType] : refl_on(A,bot_bot(fun(A,bool)),bot_bot(fun(product_prod(A,A),bool))) ).

tff(fact_55_trans__Id,axiom,
    ! [A: $tType] : trans(A,id(A)) ).

tff(fact_56_partial__order__on__empty,axiom,
    ! [A: $tType] : order_915043626der_on(A,bot_bot(fun(A,bool)),bot_bot(fun(product_prod(A,A),bool))) ).

tff(fact_57_trans__lex__prod,axiom,
    ! [A: $tType,B: $tType,R2: fun(product_prod(B,B),bool),R11: fun(product_prod(A,A),bool)] :
      ( trans(A,R11)
     => ( trans(B,R2)
       => trans(product_prod(A,B),lex_prod(A,B,R11,R2)) ) ) ).

tff(fact_58_wf__lex__prod,axiom,
    ! [A: $tType,B: $tType,Rb: fun(product_prod(B,B),bool),Ra: fun(product_prod(A,A),bool)] :
      ( wf(A,Ra)
     => ( wf(B,Rb)
       => wf(product_prod(A,B),lex_prod(A,B,Ra,Rb)) ) ) ).

tff(fact_59_wf__measure,axiom,
    ! [A: $tType,F: fun(A,nat)] : wf(A,measure(A,F)) ).

tff(fact_60_trans__diff__Id,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( trans(A,R1)
     => ( antisym(A,R1)
       => trans(A,minus_minus(fun(product_prod(A,A),bool),R1,id(A))) ) ) ).

tff(fact_61_antisym__empty,axiom,
    ! [A: $tType] : antisym(A,bot_bot(fun(product_prod(A,A),bool))) ).

tff(fact_62_antisym__Id,axiom,
    ! [A: $tType] : antisym(A,id(A)) ).

tff(fact_63_partial__order__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_915043626der_on(A,A1,R1)
    <=> ( order_preorder_on(A,A1,R1)
        & antisym(A,R1) ) ) ).

tff(fact_64_preorder__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_preorder_on(A,A1,R1)
    <=> ( refl_on(A,A1,R1)
        & trans(A,R1) ) ) ).

tff(fact_65_preorder__on__empty,axiom,
    ! [A: $tType] : order_preorder_on(A,bot_bot(fun(A,bool)),bot_bot(fun(product_prod(A,A),bool))) ).

tff(fact_66_Id__on__empty,axiom,
    ! [A: $tType] : ( id_on(A,bot_bot(fun(A,bool))) = bot_bot(fun(product_prod(A,A),bool)) ) ).

tff(fact_67_Range__Diff__subset,axiom,
    ! [A: $tType,B: $tType,B1: fun(product_prod(B,A),bool),A1: fun(product_prod(B,A),bool)] : ord_less_eq(fun(A,bool),minus_minus(fun(A,bool),range(B,A,A1),range(B,A,B1)),range(B,A,minus_minus(fun(product_prod(B,A),bool),A1,B1))) ).

tff(fact_68_Domain__Diff__subset,axiom,
    ! [B: $tType,A: $tType,B1: fun(product_prod(A,B),bool),A1: fun(product_prod(A,B),bool)] : ord_less_eq(fun(A,bool),minus_minus(fun(A,bool),domain(A,B,A1),domain(A,B,B1)),domain(A,B,minus_minus(fun(product_prod(A,B),bool),A1,B1))) ).

tff(fact_69_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ord_less_eq(A,X2,X2) ) ).

tff(fact_70_subsetD,axiom,
    ! [A: $tType,C2: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1)) ) ) ).

tff(fact_71_equalityI,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( ord_less_eq(fun(A,bool),B1,A1)
       => ( A1 = B1 ) ) ) ).

tff(fact_72_subset__empty,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,bot_bot(fun(A,bool)))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_73_empty__subsetI,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ord_less_eq(fun(A,bool),bot_bot(fun(A,bool)),A1) ).

tff(fact_74_Domain__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( domain(A,A,id_on(A,A1)) = A1 ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A1))
    <=> pp(aa(A,bool,A1,X)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_trans__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : trans(A,id_on(A,A1)) ).

tff(fact_79_Domain__mono,axiom,
    ! [B: $tType,A: $tType,S: fun(product_prod(A,B),bool),R1: fun(product_prod(A,B),bool)] :
      ( ord_less_eq(fun(product_prod(A,B),bool),R1,S)
     => ord_less_eq(fun(A,bool),domain(A,B,R1),domain(A,B,S)) ) ).

tff(fact_80_bot__least,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A2: A] : ord_less_eq(A,bot_bot(A),A2) ) ).

tff(fact_81_bot__unique,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A3: A] :
          ( ord_less_eq(A,A3,bot_bot(A))
        <=> ( A3 = bot_bot(A) ) ) ) ).

tff(fact_82_le__bot,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A2: A] :
          ( ord_less_eq(A,A2,bot_bot(A))
         => ( A2 = bot_bot(A) ) ) ) ).

tff(fact_83_diff__eq__diff__less__eq,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D1: A,C2: A,B2: A,A3: A] :
          ( ( minus_minus(A,A3,B2) = minus_minus(A,C2,D1) )
         => ( ord_less_eq(A,A3,B2)
          <=> ord_less_eq(A,C2,D1) ) ) ) ).

tff(fact_84_top__le,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A2: A] :
          ( ord_less_eq(A,top_top(A),A2)
         => ( A2 = top_top(A) ) ) ) ).

tff(fact_85_top__unique,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A3: A] :
          ( ord_less_eq(A,top_top(A),A3)
        <=> ( A3 = top_top(A) ) ) ) ).

tff(fact_86_top__greatest,axiom,
    ! [A: $tType] :
      ( top(A)
     => ! [A2: A] : ord_less_eq(A,A2,top_top(A)) ) ).

tff(fact_87_subset__UNIV,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ord_less_eq(fun(A,bool),A1,top_top(fun(A,bool))) ).

tff(fact_88_double__diff,axiom,
    ! [A: $tType,C1: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( ord_less_eq(fun(A,bool),B1,C1)
       => ( minus_minus(fun(A,bool),B1,minus_minus(fun(A,bool),C1,A1)) = A1 ) ) ) ).

tff(fact_89_Diff__mono,axiom,
    ! [A: $tType,B1: fun(A,bool),D: fun(A,bool),C1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,C1)
     => ( ord_less_eq(fun(A,bool),D,B1)
       => ord_less_eq(fun(A,bool),minus_minus(fun(A,bool),A1,B1),minus_minus(fun(A,bool),C1,D)) ) ) ).

tff(fact_90_Diff__subset,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ord_less_eq(fun(A,bool),minus_minus(fun(A,bool),A1,B1),A1) ).

tff(fact_91_subset__refl,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ord_less_eq(fun(A,bool),A1,A1) ).

tff(fact_92_set__eq__subset,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B1 )
    <=> ( ord_less_eq(fun(A,bool),A1,B1)
        & ord_less_eq(fun(A,bool),B1,A1) ) ) ).

tff(fact_93_rev__predicate1D,axiom,
    ! [A: $tType,Q1: fun(A,bool),X: A,P1: fun(A,bool)] :
      ( pp(aa(A,bool,P1,X))
     => ( ord_less_eq(fun(A,bool),P1,Q1)
       => pp(aa(A,bool,Q1,X)) ) ) ).

tff(fact_94_equalityD1,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B1 )
     => ord_less_eq(fun(A,bool),A1,B1) ) ).

tff(fact_95_equalityD2,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B1 )
     => ord_less_eq(fun(A,bool),B1,A1) ) ).

tff(fact_96_in__mono,axiom,
    ! [A: $tType,X: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),B1)) ) ) ).

tff(fact_97_predicate1D,axiom,
    ! [A: $tType,X: A,Q1: fun(A,bool),P1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),P1,Q1)
     => ( pp(aa(A,bool,P1,X))
       => pp(aa(A,bool,Q1,X)) ) ) ).

tff(fact_98_set__rev__mp,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A1))
     => ( ord_less_eq(fun(A,bool),A1,B1)
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),B1)) ) ) ).

tff(fact_99_set__mp,axiom,
    ! [A: $tType,X: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),B1)) ) ) ).

%----Arities (8)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

%----Helper facts (15)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    order_1409979114der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)),r) ).

tff(conj_1,hypothesis,
    wf(arrow_411405190le_alt,minus_minus(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),r,id(arrow_411405190le_alt))) ).

tff(conj_2,conjecture,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : pp(aa(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool,order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool))),L)) ).

%------------------------------------------------------------------------------
