%------------------------------------------------------------------------------
% File     : SCT178_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 55
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_55 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  141 (  39 unt;  35 typ;   0 def)
%            Number of atoms       :  215 (  59 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  141 (  32   ~;   2   |;   7   &)
%                                         (  26 <=>;  74  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   43 (  25   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-6 aty)
%            Number of functors    :   19 (  19 usr;   3 con; 0-6 aty)
%            Number of variables   :  531 ( 479   !;   7   ?; 531   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:08
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (31)
tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,B),bool) * A * B ) > $o ) ).

tff(sy_c_Order__Relation_Olinear__order__on,type,
    order_1409979114der_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Opartial__order__on,type,
    order_915043626der_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Opreorder__on,type,
    order_preorder_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(product_prod(A,A),bool),bool) ) ).

tff(sy_c_Order__Relation_Owell__order__on,type,
    order_well_order_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,product_prod(A,B))) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(product_prod(A,B),C) > fun(A,fun(B,C)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(product_prod(A,B),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A: $tType,B: $tType,T: $tType] : fun(fun(A,fun(B,T)),fun(product_prod(A,B),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A: $tType,B: $tType,C: $tType,D: $tType] : ( ( fun(A,product_prod(B,C)) * fun(B,fun(C,D)) ) > fun(A,D) ) ).

tff(sy_c_Relation_OId__on,type,
    id_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oantisym,type,
    antisym: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Oconverse,type,
    converse: 
      !>[A: $tType,B: $tType] : ( fun(product_prod(A,B),bool) > fun(product_prod(B,A),bool) ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B: $tType,A: $tType] : ( ( fun(product_prod(B,B),bool) * fun(A,B) ) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Orefl__on,type,
    refl_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Relation_Otrans,type,
    trans: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

%----Relevant facts (98)
tff(fact_0_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_1_converse__in__Lin,axiom,
    ! [L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),converse(arrow_411405190le_alt,arrow_411405190le_alt,L1),arrow_1985332922le_Lin)
    <=> member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin) ) ).

tff(fact_2_notin__Lin__iff,axiom,
    ! [Y: arrow_411405190le_alt,X1: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => ( ( X1 != Y )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y),L1)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),X1),L1) ) ) ) ).

tff(fact_3_Lin__irrefl,axiom,
    ! [B2: arrow_411405190le_alt,A2: arrow_411405190le_alt,L1: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L1,arrow_1985332922le_Lin)
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),A2),B2),L1)
       => ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),B2),A2),L1) ) ) ).

tff(fact_4__096EX_Ar_O_Awell__order__on_AUNIV_Ar_096,axiom,
    ? [X11: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : order_well_order_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)),X11) ).

tff(fact_5_converse__iff,axiom,
    ! [A: $tType,B: $tType,R1: fun(product_prod(B,A),bool),B2: B,A2: A] :
      ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2),converse(B,A,R1))
    <=> member(product_prod(B,A),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),B2),A2),R1) ) ).

tff(fact_6_top1I,axiom,
    ! [A: $tType,X1: A] : pp(aa(A,bool,top_top(fun(A,bool)),X1)) ).

tff(fact_7_UNIV__I,axiom,
    ! [A: $tType,X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_8_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_9_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P2: fun(product_prod(A,B),bool)] :
      ( ! [X12: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P2,X12))
    <=> ! [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,P2,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3))) ) ).

tff(fact_10_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A7: A,B2: B,A2: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A7),B6) )
    <=> ( ( A2 = A7 )
        & ( B2 = B6 ) ) ) ).

tff(fact_11_converseI,axiom,
    ! [B: $tType,A: $tType,R1: fun(product_prod(A,B),bool),B2: B,A2: A] :
      ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2),R1)
     => member(product_prod(B,A),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),B2),A2),converse(A,B,R1)) ) ).

tff(fact_12_converseD,axiom,
    ! [A: $tType,B: $tType,R1: fun(product_prod(B,A),bool),B2: B,A2: A] :
      ( member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2),converse(B,A,R1))
     => member(product_prod(B,A),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),B2),A2),R1) ) ).

tff(fact_13_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X1: B] : ( aa(B,A,top_top(fun(B,A)),X1) = top_top(A) ) ) ).

tff(fact_14_converseE,axiom,
    ! [A: $tType,B: $tType,R1: fun(product_prod(B,A),bool),Yx: product_prod(A,B)] :
      ( member(product_prod(A,B),Yx,converse(B,A,R1))
     => ~ ! [X2: B,Y1: A] :
            ( ( Yx = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Y1),X2) )
           => ~ member(product_prod(B,A),aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),X2),Y1),R1) ) ) ).

tff(fact_15_converse__converse,axiom,
    ! [B: $tType,A: $tType,R1: fun(product_prod(A,B),bool)] : ( converse(B,A,converse(A,B,R1)) = R1 ) ).

tff(fact_16_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A6: A,B4: B,A5: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B4) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B5) )
     => ~ ( ( A5 = A6 )
         => ( B4 != B5 ) ) ) ).

tff(fact_17_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_18_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P2: fun(product_prod(A,B),bool)] :
      ( ? [X12: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P2,X12))
    <=> ? [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,P2,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3))) ) ).

tff(fact_19_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A2: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B2)) = aa(C,A,aa(B,fun(C,A),F1,A2),B2) ) ).

tff(fact_20_UNIV__eq__I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X2: A] : member(A,X2,A1)
     => ( top_top(fun(A,bool)) = A1 ) ) ).

tff(fact_21_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X2: A] : member(A,X2,top_top(fun(A,bool))) ).

tff(fact_22_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y3: product_prod(A,B)] :
      ~ ! [A3: A,B1: B] : ( Y3 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B1) ) ).

tff(fact_23_PairE,axiom,
    ! [A: $tType,B: $tType,P3: product_prod(A,B)] :
      ~ ! [X2: A,Y1: B] : ( P3 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y1) ) ).

tff(fact_24_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y3: product_prod(A,product_prod(B,C))] :
      ~ ! [A3: A,B1: B,C2: C] : ( Y3 != aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A3),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B1),C2)) ) ).

tff(fact_25_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,C)),P2: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A3: A,B1: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P2,aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A3),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B1),C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P2,X1)) ) ).

tff(fact_26_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),P2: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A3: A,B1: B,C2: C,D1: D,E1: E,F3: F2] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P2,aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B1),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P2,X1)) ) ).

tff(fact_27_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y3: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A3: A,B1: B,C2: C,D1: D,E1: E,F3: F2] : ( Y3 != aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B1),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_28_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P2: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A3: A,B1: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P2,aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A3),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B1),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P2,X1)) ) ).

tff(fact_29_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y3: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A3: A,B1: B,C2: C,D1: D,E1: E] : ( Y3 != aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A3),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B1),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_30_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,D))),P2: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A3: A,B1: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P2,aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A3),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B1),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P2,X1)) ) ).

tff(fact_31_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y3: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A3: A,B1: B,C2: C,D1: D] : ( Y3 != aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A3),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B1),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1))) ) ).

tff(fact_32_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A2: B,C1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),produc1605651328_split(B,C,A),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B2)) = aa(C,A,aa(B,fun(C,A),C1,A2),B2) ) ).

tff(fact_33_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,B2: C,A2: B,F: fun(product_prod(B,C),A)] : ( aa(C,A,aa(B,fun(C,A),product_curry(B,C,A,F),A2),B2) = aa(product_prod(B,C),A,F,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B2)) ) ).

tff(fact_34_curryI,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2)))
     => pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B2)) ) ).

tff(fact_35_total__on__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( total_on(A,A1,converse(A,A,R1))
    <=> total_on(A,A1,R1) ) ).

tff(fact_36_converse__inv__image,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),R: fun(product_prod(B,B),bool)] : ( converse(A,A,inv_image(B,A,R,F)) = inv_image(B,A,converse(B,B,R),F) ) ).

tff(fact_37_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Y: B,X1: B,F: fun(B,A),R1: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R1,F,X1,Y)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R1,aa(B,A,F,X1)),aa(B,A,F,Y))) ) ).

tff(fact_38_irrefl__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( irrefl(A,R1)
    <=> ! [X3: A] : ~ member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X3),X3),R1) ) ).

tff(fact_39_in__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(A,B),R1: fun(product_prod(B,B),bool),Y: A,X1: A] :
      ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X1),Y),inv_image(B,A,R1,F))
    <=> member(product_prod(B,B),aa(B,product_prod(B,B),aa(B,fun(B,product_prod(B,B)),product_Pair(B,B),aa(A,B,F,X1)),aa(A,B,F,Y)),R1) ) ).

tff(fact_40_total__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( total_on(A,A1,R1)
    <=> ! [X3: A] :
          ( member(A,X3,A1)
         => ! [Xa: A] :
              ( member(A,Xa,A1)
             => ( ( X3 != Xa )
               => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X3),Xa),R1)
                  | member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Xa),X3),R1) ) ) ) ) ) ).

tff(fact_41_curryD,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B2))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2))) ) ).

tff(fact_42_curryE,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A2),B2))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2))) ) ).

tff(fact_43_strict__linear__order__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,order_215145569der_on(A,A1),R1))
    <=> ( trans(A,R1)
        & irrefl(A,R1)
        & total_on(A,A1,R1) ) ) ).

tff(fact_44_antisym__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( antisym(A,converse(A,A,R1))
    <=> antisym(A,R1) ) ).

tff(fact_45_well__order__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
    ? [X11: fun(product_prod(A,A),bool)] : order_well_order_on(A,A1,X11) ).

tff(fact_46_converse__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( converse(A,A,id_on(A,A1)) = id_on(A,A1) ) ).

tff(fact_47_internal__split__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] : ( produc1605651328_split(A,B,C) = product_prod_case(A,B,C) ) ).

tff(fact_48_prod__caseI,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F1: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F1,A2),B2))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F1),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2))) ) ).

tff(fact_49_splitI,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F,A2),B2))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2))) ) ).

tff(fact_50_mem__splitI,axiom,
    ! [A: $tType,B: $tType,C: $tType,B2: C,A2: B,C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,A2),B2))
     => member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B2))) ) ).

tff(fact_51_split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A2: B,F: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B2)) = aa(C,A,aa(B,fun(C,A),F,A2),B2) ) ).

tff(fact_52_trans__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( trans(A,converse(A,A,R1))
    <=> trans(A,R1) ) ).

tff(fact_53_splitD,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2)))
     => pp(aa(B,bool,aa(A,fun(B,bool),F,A2),B2)) ) ).

tff(fact_54_trans__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : trans(A,id_on(A,A1)) ).

tff(fact_55_antisym__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : antisym(A,id_on(A,A1)) ).

tff(fact_56_split__weak__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,C)),Q1: product_prod(A,B),P1: product_prod(A,B)] :
      ( ( P1 = Q1 )
     => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),P1) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),Q1) ) ) ).

tff(fact_57_splitD_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,C1: C,B2: B,A2: A,R: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),R),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2)),C1))
     => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),R,A2),B2),C1)) ) ).

tff(fact_58_prod_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A2: B,F1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A2),B2)) = aa(C,A,aa(B,fun(C,A),F1,A2),B2) ) ).

tff(fact_59_transD,axiom,
    ! [A: $tType,C1: A,B2: A,A2: A,R1: fun(product_prod(A,A),bool)] :
      ( trans(A,R1)
     => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A2),B2),R1)
       => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),B2),C1),R1)
         => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A2),C1),R1) ) ) ) ).

tff(fact_60_trans__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( trans(A,R1)
    <=> ! [X3: A,Y2: A,Z2: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X3),Y2),R1)
         => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y2),Z2),R1)
           => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X3),Z2),R1) ) ) ) ).

tff(fact_61_Id__on__eqI,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,A2: A] :
      ( ( A2 = B2 )
     => ( member(A,A2,A1)
       => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A2),B2),id_on(A,A1)) ) ) ).

tff(fact_62_Id__on__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),Y: A,X1: A] :
      ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X1),Y),id_on(A,A1))
    <=> ( ( X1 = Y )
        & member(A,X1,A1) ) ) ).

tff(fact_63_antisymD,axiom,
    ! [A: $tType,B2: A,A2: A,R1: fun(product_prod(A,A),bool)] :
      ( antisym(A,R1)
     => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A2),B2),R1)
       => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),B2),A2),R1)
         => ( A2 = B2 ) ) ) ) ).

tff(fact_64_antisym__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( antisym(A,R1)
    <=> ! [X3: A,Y2: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X3),Y2),R1)
         => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y2),X3),R1)
           => ( X3 = Y2 ) ) ) ) ).

tff(fact_65_curry__split,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(A,fun(B,C))] : ( product_curry(A,B,C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F)) = F ) ).

tff(fact_66_split__curry,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(product_prod(A,B),C)] : ( aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),product_curry(A,B,C,F)) = F ) ).

tff(fact_67_trans__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(B,A),R1: fun(product_prod(A,A),bool)] :
      ( trans(A,R1)
     => trans(B,inv_image(A,B,R1,F)) ) ).

tff(fact_68_Id__onE,axiom,
    ! [A: $tType,A1: fun(A,bool),C1: product_prod(A,A)] :
      ( member(product_prod(A,A),C1,id_on(A,A1))
     => ~ ! [X2: A] :
            ( member(A,X2,A1)
           => ( C1 != aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),X2) ) ) ) ).

tff(fact_69_mem__splitI2,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,fun(C,bool))),Z: C,P1: product_prod(A,B)] :
      ( ! [A3: A,B1: B] :
          ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B1) )
         => member(C,Z,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A3),B1)) )
     => member(C,Z,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P1)) ) ).

tff(fact_70_splitI2_H,axiom,
    ! [A: $tType,B: $tType,C: $tType,X1: C,C1: fun(A,fun(B,fun(C,bool))),P1: product_prod(A,B)] :
      ( ! [A3: A,B1: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B1) = P1 )
         => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A3),B1),X1)) )
     => pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P1),X1)) ) ).

tff(fact_71_mem__splitE,axiom,
    ! [B: $tType,A: $tType,C: $tType,P1: product_prod(B,C),C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),P1))
     => ~ ! [X2: B,Y1: C] :
            ( ( P1 = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X2),Y1) )
           => ~ member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,X2),Y1)) ) ) ).

tff(fact_72_splitE_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: C,P1: product_prod(A,B),C1: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P1),Z))
     => ~ ! [X2: A,Y1: B] :
            ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y1) )
           => ~ pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,X2),Y1),Z)) ) ) ).

tff(fact_73_splitE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B),C1: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P1))
     => ~ ! [X2: A,Y1: B] :
            ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y1) )
           => ~ pp(aa(B,bool,aa(A,fun(B,bool),C1,X2),Y1)) ) ) ).

tff(fact_74_splitI2,axiom,
    ! [B: $tType,A: $tType,C1: fun(A,fun(B,bool)),P1: product_prod(A,B)] :
      ( ! [A3: A,B1: B] :
          ( ( P1 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B1) )
         => pp(aa(B,bool,aa(A,fun(B,bool),C1,A3),B1)) )
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P1)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P2: fun(A,bool)] : ( collect(A,P2) = P2 ) ).

tff(fact_78_antisymI,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( ! [X2: A,Y1: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),Y1),R1)
         => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y1),X2),R1)
           => ( X2 = Y1 ) ) )
     => antisym(A,R1) ) ).

tff(fact_79_transI,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( ! [X2: A,Y1: A,Z1: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),Y1),R1)
         => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y1),Z1),R1)
           => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),Z1),R1) ) )
     => trans(A,R1) ) ).

tff(fact_80_splitE2,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: product_prod(B,C),P2: fun(B,fun(C,A)),Q2: fun(A,bool)] :
      ( pp(aa(A,bool,Q2,aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),P2),Z)))
     => ~ ! [X2: B,Y1: C] :
            ( ( Z = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X2),Y1) )
           => ~ pp(aa(A,bool,Q2,aa(C,A,aa(B,fun(C,A),P2,X2),Y1))) ) ) ).

tff(fact_81_linear__order__on__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_1409979114der_on(A,A1,converse(A,A,R1))
    <=> order_1409979114der_on(A,A1,R1) ) ).

tff(fact_82_partial__order__on__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_915043626der_on(A,A1,converse(A,A,R1))
    <=> order_915043626der_on(A,A1,R1) ) ).

tff(fact_83_linear__order__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_1409979114der_on(A,A1,R1)
    <=> ( order_915043626der_on(A,A1,R1)
        & total_on(A,A1,R1) ) ) ).

tff(fact_84_partial__order__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_915043626der_on(A,A1,R1)
    <=> ( order_preorder_on(A,A1,R1)
        & antisym(A,R1) ) ) ).

tff(fact_85_preorder__on__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_preorder_on(A,A1,converse(A,A,R1))
    <=> order_preorder_on(A,A1,R1) ) ).

tff(fact_86_split__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,P1: product_prod(A,B),G: fun(A,fun(B,C)),F: fun(A,fun(B,C)),Q1: product_prod(A,B)] :
      ( ! [X2: A,Y1: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y1) = Q1 )
         => ( aa(B,C,aa(A,fun(B,C),F,X2),Y1) = aa(B,C,aa(A,fun(B,C),G,X2),Y1) ) )
     => ( ( P1 = Q1 )
       => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F),P1) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),G),Q1) ) ) ) ).

tff(fact_87_preorder__on__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( order_preorder_on(A,A1,R1)
    <=> ( refl_on(A,A1,R1)
        & trans(A,R1) ) ) ).

tff(fact_88_refl__on__converse,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( refl_on(A,A1,converse(A,A,R1))
    <=> refl_on(A,A1,R1) ) ).

tff(fact_89_refl__onD2,axiom,
    ! [A: $tType,Y: A,X1: A,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( refl_on(A,A1,R1)
     => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X1),Y),R1)
       => member(A,Y,A1) ) ) ).

tff(fact_90_refl__onD1,axiom,
    ! [A: $tType,Y: A,X1: A,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( refl_on(A,A1,R1)
     => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X1),Y),R1)
       => member(A,X1,A1) ) ) ).

tff(fact_91_refl__onD,axiom,
    ! [A: $tType,A2: A,R1: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( refl_on(A,A1,R1)
     => ( member(A,A2,A1)
       => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A2),A2),R1) ) ) ).

tff(fact_92_refl__on__Id__on,axiom,
    ! [A: $tType,A1: fun(A,bool)] : refl_on(A,A1,id_on(A,A1)) ).

tff(fact_93_in__rel__def,axiom,
    ! [B: $tType,A: $tType,Y: B,X1: A,R: fun(product_prod(A,B),bool)] :
      ( in_rel(A,B,R,X1,Y)
    <=> member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Y),R) ) ).

tff(fact_94_scomp__apply,axiom,
    ! [A: $tType,C: $tType,D: $tType,B: $tType,X1: B,G: fun(C,fun(D,A)),F: fun(B,product_prod(C,D))] : ( aa(B,A,product_scomp(B,C,D,A,F,G),X1) = aa(product_prod(C,D),A,aa(fun(C,fun(D,A)),fun(product_prod(C,D),A),product_prod_case(C,D,A),G),aa(B,product_prod(C,D),F,X1)) ) ).

tff(fact_95_scomp__Pair,axiom,
    ! [C: $tType,B: $tType,A: $tType,X1: fun(A,product_prod(B,C))] : ( product_scomp(A,B,C,product_prod(B,C),X1,product_Pair(B,C)) = X1 ) ).

tff(fact_96_Pair__scomp,axiom,
    ! [A: $tType,B: $tType,C: $tType,F: fun(C,fun(A,B)),X1: C] : ( product_scomp(A,C,A,B,aa(C,fun(A,product_prod(C,A)),product_Pair(C,A),X1),F) = aa(C,fun(A,B),F,X1) ) ).

tff(fact_97_scomp__def,axiom,
    ! [B: $tType,C: $tType,D: $tType,A: $tType,G: fun(C,fun(D,B)),F: fun(A,product_prod(C,D)),X: A] : ( aa(A,B,product_scomp(A,C,D,B,F,G),X) = aa(product_prod(C,D),B,aa(fun(C,fun(D,B)),fun(product_prod(C,D),B),product_prod_case(C,D,B),G),aa(A,product_prod(C,D),F,X)) ) ).

%----Arities (2)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ? [L: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] : member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),L,arrow_1985332922le_Lin) ).

%------------------------------------------------------------------------------
