%------------------------------------------------------------------------------
% File     : SCT176_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 47
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_47 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  113 (  34 unt;  32 typ;   0 def)
%            Number of atoms       :  165 (  59 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  117 (  33   ~;   5   |;   8   &)
%                                         (  15 <=>;  56  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   37 (  21   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-6 aty)
%            Number of functors    :   21 (  21 usr;   4 con; 0-6 aty)
%            Number of variables   :  473 ( 422   !;   6   ?; 473   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:05
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (28)
tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,B),bool) * A * B ) > $o ) ).

tff(sy_c_Nitpick_Orefl_H,type,
    refl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(product_prod(A,A),bool),bool) ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,product_prod(A,B))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A: $tType,C: $tType,B: $tType] : ( ( fun(A,C) * product_prod(A,B) ) > product_prod(C,B) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * product_prod(A,B) ) > product_prod(A,C) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(product_prod(A,B),C) > fun(A,fun(B,C)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(product_prod(A,B),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A: $tType,B: $tType,T: $tType] : fun(fun(A,fun(B,T)),fun(product_prod(A,B),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A: $tType,B: $tType,C: $tType,D: $tType] : ( ( fun(A,product_prod(B,C)) * fun(B,fun(C,D)) ) > fun(A,D) ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B: $tType,A: $tType] : ( ( fun(product_prod(B,B),bool) * fun(A,B) ) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Relation_Otrans,type,
    trans: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,A),bool) * fun(product_prod(B,B),bool) ) > fun(product_prod(product_prod(A,B),product_prod(A,B)),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_L,type,
    l: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

%----Relevant facts (73)
tff(fact_0_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X1: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( ( X1 != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X1),Y1),La)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y1),X1),La) ) ) ) ).

tff(fact_1_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ! [A5: A,B4: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B4))) ) ).

tff(fact_2_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B3: B,A4: A,B2: B,A3: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3) )
    <=> ( ( A3 = A4 )
        & ( B2 = B3 ) ) ) ).

tff(fact_3_trans__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( trans(A,R)
    <=> ! [X: A,Y: A,Z2: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X),Y),R)
         => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y),Z2),R)
           => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X),Z2),R) ) ) ) ).

tff(fact_4_transD,axiom,
    ! [A: $tType,C1: A,B2: A,A3: A,R: fun(product_prod(A,A),bool)] :
      ( trans(A,R)
     => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A3),B2),R)
       => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),B2),C1),R)
         => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A3),C1),R) ) ) ) ).

tff(fact_5_transI,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( ! [X2: A,Y2: A,Z1: A] :
          ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),Y2),R)
         => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Y2),Z1),R)
           => member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X2),Z1),R) ) )
     => trans(A,R) ) ).

tff(fact_6_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B6: B,A7: A,B5: B,A6: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B5) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A7),B6) )
     => ~ ( ( A6 = A7 )
         => ( B5 != B6 ) ) ) ).

tff(fact_7_trans__lex__prod,axiom,
    ! [A: $tType,B: $tType,R2: fun(product_prod(B,B),bool),R11: fun(product_prod(A,A),bool)] :
      ( trans(A,R11)
     => ( trans(B,R2)
       => trans(product_prod(A,B),lex_prod(A,B,R11,R2)) ) ) ).

tff(fact_8_in__rel__def,axiom,
    ! [B: $tType,A: $tType,Y1: B,X1: A,R1: fun(product_prod(A,B),bool)] :
      ( in_rel(A,B,R1,X1,Y1)
    <=> member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Y1),R1) ) ).

tff(fact_9_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ? [A5: A,B4: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B4))) ) ).

tff(fact_10_Nitpick_Orefl_H__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( refl(A,R)
    <=> ! [X: A] : member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X),X),R) ) ).

tff(fact_11_in__lex__prod,axiom,
    ! [A: $tType,B: $tType,S: fun(product_prod(B,B),bool),R: fun(product_prod(A,A),bool),B3: B,A4: A,B2: B,A3: A] :
      ( member(product_prod(product_prod(A,B),product_prod(A,B)),aa(product_prod(A,B),product_prod(product_prod(A,B),product_prod(A,B)),aa(product_prod(A,B),fun(product_prod(A,B),product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3)),lex_prod(A,B,R,S))
    <=> ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A3),A4),R)
        | ( ( A3 = A4 )
          & member(product_prod(B,B),aa(B,product_prod(B,B),aa(B,fun(B,product_prod(B,B)),product_Pair(B,B),B2),B3),S) ) ) ) ).

tff(fact_12_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y3: product_prod(A,product_prod(B,C))] :
      ~ ! [A2: A,B1: B,C2: C] : ( Y3 != aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A2),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B1),C2)) ) ).

tff(fact_13_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,C)),P1: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A2: A,B1: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P1,aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A2),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B1),C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P1,X1)) ) ).

tff(fact_14_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y3: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A2: A,B1: B,C2: C,D1: D] : ( Y3 != aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A2),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B1),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1))) ) ).

tff(fact_15_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,D))),P1: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A2: A,B1: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A2),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B1),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,X1)) ) ).

tff(fact_16_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y3: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A2: A,B1: B,C2: C,D1: D,E1: E] : ( Y3 != aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A2),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B1),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_17_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A2: A,B1: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A2),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B1),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,X1)) ) ).

tff(fact_18_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y3: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A2: A,B1: B,C2: C,D1: D,E1: E,F3: F2] : ( Y3 != aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A2),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B1),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_19_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A2: A,B1: B,C2: C,D1: D,E1: E,F3: F2] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A2),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B1),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,X1)) ) ).

tff(fact_20_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A3: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A3),B2)) = aa(C,A,aa(B,fun(C,A),F1,A3),B2) ) ).

tff(fact_21_PairE,axiom,
    ! [A: $tType,B: $tType,P3: product_prod(A,B)] :
      ~ ! [X2: A,Y2: B] : ( P3 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y2) ) ).

tff(fact_22_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y3: product_prod(A,B)] :
      ~ ! [A2: A,B1: B] : ( Y3 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1) ) ).

tff(fact_23_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A3: B,C1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),produc1605651328_split(B,C,A),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A3),B2)) = aa(C,A,aa(B,fun(C,A),C1,A3),B2) ) ).

tff(fact_24_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,B2: C,A3: B,F: fun(product_prod(B,C),A)] : ( aa(C,A,aa(B,fun(C,A),product_curry(B,C,A,F),A3),B2) = aa(product_prod(B,C),A,F,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A3),B2)) ) ).

tff(fact_25_curryI,axiom,
    ! [A: $tType,B: $tType,B2: B,A3: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2)))
     => pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A3),B2)) ) ).

tff(fact_26_irrefl__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( irrefl(A,R)
    <=> ! [X: A] : ~ member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X),X),R) ) ).

tff(fact_27_in__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(A,B),R: fun(product_prod(B,B),bool),Y1: A,X1: A] :
      ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X1),Y1),inv_image(B,A,R,F))
    <=> member(product_prod(B,B),aa(B,product_prod(B,B),aa(B,fun(B,product_prod(B,B)),product_Pair(B,B),aa(A,B,F,X1)),aa(A,B,F,Y1)),R) ) ).

tff(fact_28_curryE,axiom,
    ! [A: $tType,B: $tType,B2: B,A3: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A3),B2))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2))) ) ).

tff(fact_29_curryD,axiom,
    ! [A: $tType,B: $tType,B2: B,A3: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A3),B2))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2))) ) ).

tff(fact_30_trans__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(B,A),R: fun(product_prod(A,A),bool)] :
      ( trans(A,R)
     => trans(B,inv_image(A,B,R,F)) ) ).

tff(fact_31_internal__split__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] : ( produc1605651328_split(A,B,C) = product_prod_case(A,B,C) ) ).

tff(fact_32_apsnd__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y1: C,X1: A,F: fun(C,B)] : ( product_apsnd(C,B,A,F,aa(C,product_prod(A,C),aa(A,fun(C,product_prod(A,C)),product_Pair(A,C),X1),Y1)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),aa(C,B,F,Y1)) ) ).

tff(fact_33_strict__linear__order__on__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,order_215145569der_on(A,A1),R))
    <=> ( trans(A,R)
        & irrefl(A,R)
        & total_on(A,A1,R) ) ) ).

tff(fact_34_apfst__conv,axiom,
    ! [C: $tType,A: $tType,B: $tType,Y1: B,X1: C,F: fun(C,A)] : ( product_apfst(C,A,B,F,aa(B,product_prod(C,B),aa(C,fun(B,product_prod(C,B)),product_Pair(C,B),X1),Y1)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C,A,F,X1)),Y1) ) ).

tff(fact_35_surj__pair,axiom,
    ! [A: $tType,B: $tType,P3: product_prod(A,B)] :
    ? [X2: A,Y2: B] : ( P3 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y2) ) ).

tff(fact_36_total__on__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A1: fun(A,bool)] :
      ( total_on(A,A1,R)
    <=> ! [X: A] :
          ( member(A,X,A1)
         => ! [Xa: A] :
              ( member(A,Xa,A1)
             => ( ( X != Xa )
               => ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X),Xa),R)
                  | member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),Xa),X),R) ) ) ) ) ) ).

tff(fact_37_splitI,axiom,
    ! [A: $tType,B: $tType,B2: B,A3: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F,A3),B2))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2))) ) ).

tff(fact_38_prod__caseI,axiom,
    ! [A: $tType,B: $tType,B2: B,A3: A,F1: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F1,A3),B2))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F1),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2))) ) ).

tff(fact_39_mem__splitI,axiom,
    ! [A: $tType,B: $tType,C: $tType,B2: C,A3: B,C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,A3),B2))
     => member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A3),B2))) ) ).

tff(fact_40_split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A3: B,F: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A3),B2)) = aa(C,A,aa(B,fun(C,A),F,A3),B2) ) ).

tff(fact_41_apsnd__apfst__commute,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,P2: product_prod(D,C),G: fun(D,A),F: fun(C,B)] : ( product_apsnd(C,B,A,F,product_apfst(D,A,C,G,P2)) = product_apfst(D,A,B,G,product_apsnd(C,B,D,F,P2)) ) ).

tff(fact_42_split__weak__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,C)),Q1: product_prod(A,B),P2: product_prod(A,B)] :
      ( ( P2 = Q1 )
     => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),P2) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),Q1) ) ) ).

tff(fact_43_splitD,axiom,
    ! [A: $tType,B: $tType,B2: B,A3: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2)))
     => pp(aa(B,bool,aa(A,fun(B,bool),F,A3),B2)) ) ).

tff(fact_44_splitD_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,C1: C,B2: B,A3: A,R1: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),R1),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A3),B2)),C1))
     => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),R1,A3),B2),C1)) ) ).

tff(fact_45_prod_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A3: B,F1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A3),B2)) = aa(C,A,aa(B,fun(C,A),F1,A3),B2) ) ).

tff(fact_46_curry__split,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(A,fun(B,C))] : ( product_curry(A,B,C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F)) = F ) ).

tff(fact_47_split__curry,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(product_prod(A,B),C)] : ( aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),product_curry(A,B,C,F)) = F ) ).

tff(fact_48_splitI2,axiom,
    ! [B: $tType,A: $tType,C1: fun(A,fun(B,bool)),P2: product_prod(A,B)] :
      ( ! [A2: A,B1: B] :
          ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1) )
         => pp(aa(B,bool,aa(A,fun(B,bool),C1,A2),B1)) )
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P2)) ) ).

tff(fact_49_splitE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B),C1: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P2))
     => ~ ! [X2: A,Y2: B] :
            ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y2) )
           => ~ pp(aa(B,bool,aa(A,fun(B,bool),C1,X2),Y2)) ) ) ).

tff(fact_50_mem__splitI2,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,fun(C,bool))),Z: C,P2: product_prod(A,B)] :
      ( ! [A2: A,B1: B] :
          ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1) )
         => member(C,Z,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A2),B1)) )
     => member(C,Z,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P2)) ) ).

tff(fact_51_splitI2_H,axiom,
    ! [A: $tType,B: $tType,C: $tType,X1: C,C1: fun(A,fun(B,fun(C,bool))),P2: product_prod(A,B)] :
      ( ! [A2: A,B1: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B1) = P2 )
         => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A2),B1),X1)) )
     => pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P2),X1)) ) ).

tff(fact_52_mem__splitE,axiom,
    ! [B: $tType,A: $tType,C: $tType,P2: product_prod(B,C),C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),P2))
     => ~ ! [X2: B,Y2: C] :
            ( ( P2 = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X2),Y2) )
           => ~ member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,X2),Y2)) ) ) ).

tff(fact_53_splitE_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: C,P2: product_prod(A,B),C1: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P2),Z))
     => ~ ! [X2: A,Y2: B] :
            ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y2) )
           => ~ pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,X2),Y2),Z)) ) ) ).

tff(fact_54_splitE2,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: product_prod(B,C),P1: fun(B,fun(C,A)),Q2: fun(A,bool)] :
      ( pp(aa(A,bool,Q2,aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),P1),Z)))
     => ~ ! [X2: B,Y2: C] :
            ( ( Z = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X2),Y2) )
           => ~ pp(aa(A,bool,Q2,aa(C,A,aa(B,fun(C,A),P1,X2),Y2))) ) ) ).

tff(fact_55_split__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,P2: product_prod(A,B),G: fun(A,fun(B,C)),F: fun(A,fun(B,C)),Q1: product_prod(A,B)] :
      ( ! [X2: A,Y2: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y2) = Q1 )
         => ( aa(B,C,aa(A,fun(B,C),F,X2),Y2) = aa(B,C,aa(A,fun(B,C),G,X2),Y2) ) )
     => ( ( P2 = Q1 )
       => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F),P2) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),G),Q1) ) ) ) ).

tff(fact_56_apfst__convE,axiom,
    ! [C: $tType,A: $tType,B: $tType,P2: product_prod(C,B),F: fun(C,A),Q1: product_prod(A,B)] :
      ( ( Q1 = product_apfst(C,A,B,F,P2) )
     => ~ ! [X2: C,Y2: B] :
            ( ( P2 = aa(B,product_prod(C,B),aa(C,fun(B,product_prod(C,B)),product_Pair(C,B),X2),Y2) )
           => ( Q1 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C,A,F,X2)),Y2) ) ) ) ).

tff(fact_57_scomp__apply,axiom,
    ! [A: $tType,C: $tType,D: $tType,B: $tType,X1: B,G: fun(C,fun(D,A)),F: fun(B,product_prod(C,D))] : ( aa(B,A,product_scomp(B,C,D,A,F,G),X1) = aa(product_prod(C,D),A,aa(fun(C,fun(D,A)),fun(product_prod(C,D),A),product_prod_case(C,D,A),G),aa(B,product_prod(C,D),F,X1)) ) ).

tff(fact_58_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_59_scomp__def,axiom,
    ! [B: $tType,C: $tType,D: $tType,A: $tType,G: fun(C,fun(D,B)),F: fun(A,product_prod(C,D)),X3: A] : ( aa(A,B,product_scomp(A,C,D,B,F,G),X3) = aa(product_prod(C,D),B,aa(fun(C,fun(D,B)),fun(product_prod(C,D),B),product_prod_case(C,D,B),G),aa(A,product_prod(C,D),F,X3)) ) ).

tff(fact_60_scomp__Pair,axiom,
    ! [C: $tType,B: $tType,A: $tType,X1: fun(A,product_prod(B,C))] : ( product_scomp(A,B,C,product_prod(B,C),X1,product_Pair(B,C)) = X1 ) ).

tff(fact_61_Pair__scomp,axiom,
    ! [A: $tType,B: $tType,C: $tType,F: fun(C,fun(A,B)),X1: C] : ( product_scomp(A,C,A,B,aa(C,fun(A,product_prod(C,A)),product_Pair(C,A),X1),F) = aa(C,fun(A,B),F,X1) ) ).

tff(fact_62_top1I,axiom,
    ! [A: $tType,X1: A] : pp(aa(A,bool,top_top(fun(A,bool)),X1)) ).

tff(fact_63_UNIV__I,axiom,
    ! [A: $tType,X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_64_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_65_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_66_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X1: B] : ( aa(B,A,top_top(fun(B,A)),X1) = top_top(A) ) ) ).

tff(fact_67_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X2: A] : member(A,X2,top_top(fun(A,bool))) ).

tff(fact_68_UNIV__eq__I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X2: A] : member(A,X2,A1)
     => ( top_top(fun(A,bool)) = A1 ) ) ).

tff(fact_69_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Y1: B,X1: B,F: fun(B,A),R: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R,F,X1,Y1)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R,aa(B,A,F,X1)),aa(B,A,F,Y1))) ) ).

tff(fact_70_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_71_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_72_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

%----Arities (2)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ( ( trans(arrow_411405190le_alt,l)
      & ! [X: arrow_411405190le_alt] : ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),X),l)
      & ! [X: arrow_411405190le_alt,Y: arrow_411405190le_alt] :
          ( ( X != Y )
         => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),X),l)
            | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y),l) ) ) )
  <=> ( trans(arrow_411405190le_alt,l)
      & ! [X: arrow_411405190le_alt] : ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),X),l)
      & ! [X: arrow_411405190le_alt,Y: arrow_411405190le_alt] :
          ( ( X != Y )
         => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y),l)
            | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),X),l) ) ) ) ) ).

%------------------------------------------------------------------------------
