%------------------------------------------------------------------------------
% File     : SCT175_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 46
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_46 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.0.0, 0.67 v8.2.0, 0.33 v7.4.0, 0.75 v7.1.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  142 (  30 unt;  35 typ;   0 def)
%            Number of atoms       :  247 (  41 equ)
%            Maximal formula atoms :    9 (   1 avg)
%            Number of connectives :  173 (  33   ~;   2   |;   7   &)
%                                         (  31 <=>; 100  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   45 (  27   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-6 aty)
%            Number of functors    :   19 (  19 usr;   4 con; 0-6 aty)
%            Number of variables   :  484 ( 442   !;   4   ?; 484   :)
%                                         (  38  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:03
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (31)
tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Order__Relation_Olinear__order__on,type,
    order_1409979114der_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Opartial__order__on,type,
    order_915043626der_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Opreorder__on,type,
    order_preorder_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(product_prod(A,A),bool),bool) ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C2: $tType] : ( ( fun(product_prod(A,B),C2) * A * B ) > C2 ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C2: $tType] : ( ( fun(A,fun(B,C2)) * product_prod(A,B) ) > C2 ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Relation_OId__on,type,
    id_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oantisym,type,
    antisym: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Oconverse,type,
    converse: 
      !>[A: $tType,B: $tType] : ( fun(product_prod(A,B),bool) > fun(product_prod(B,A),bool) ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B: $tType,A: $tType] : ( ( fun(product_prod(B,B),bool) * fun(A,B) ) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Orefl__on,type,
    refl_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Relation_Osym,type,
    sym: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(product_prod(A,A),bool) ) > $o ) ).

tff(sy_c_Relation_Otrans,type,
    trans: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Transitive__Closure_Oacyclic,type,
    transitive_acyclic: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Transitive__Closure_Otrancl,type,
    transitive_trancl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_L,type,
    l: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

%----Relevant facts (99)
tff(fact_0_converse__converse,axiom,
    ! [B: $tType,A: $tType,R: fun(product_prod(A,B),bool)] : ( converse(B,A,converse(A,B,R)) = R ) ).

tff(fact_1_notin__Lin__iff,axiom,
    ! [Y1: arrow_411405190le_alt,X: arrow_411405190le_alt,La: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool)] :
      ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),La,arrow_1985332922le_Lin)
     => ( ( X != Y1 )
       => ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,X,Y1),La)
        <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt,Y1,X),La) ) ) ) ).

tff(fact_2_linear__order__on__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( order_1409979114der_on(A,A2,converse(A,A,R))
    <=> order_1409979114der_on(A,A2,R) ) ).

tff(fact_3_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_4_preorder__on__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( order_preorder_on(A,A2,converse(A,A,R))
    <=> order_preorder_on(A,A2,R) ) ).

tff(fact_5_partial__order__on__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( order_915043626der_on(A,A2,converse(A,A,R))
    <=> order_915043626der_on(A,A2,R) ) ).

tff(fact_6_total__on__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( total_on(A,A2,converse(A,A,R))
    <=> total_on(A,A2,R) ) ).

tff(fact_7_converse__inv__image,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),R1: fun(product_prod(B,B),bool)] : ( converse(A,A,inv_image(B,A,R1,F)) = inv_image(B,A,converse(B,B,R1),F) ) ).

tff(fact_8_antisym__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( antisym(A,converse(A,A,R))
    <=> antisym(A,R) ) ).

tff(fact_9_acyclic__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( transitive_acyclic(A,converse(A,A,R))
    <=> transitive_acyclic(A,R) ) ).

tff(fact_10_converse__Id__on,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( converse(A,A,id_on(A,A2)) = id_on(A,A2) ) ).

tff(fact_11_sym__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( sym(A,converse(A,A,R))
    <=> sym(A,R) ) ).

tff(fact_12_converse__iff,axiom,
    ! [A: $tType,B: $tType,R: fun(product_prod(B,A),bool),B1: B,A1: A] :
      ( member(product_prod(A,B),product_Pair(A,B,A1,B1),converse(B,A,R))
    <=> member(product_prod(B,A),product_Pair(B,A,B1,A1),R) ) ).

tff(fact_13_in__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(A,B),R: fun(product_prod(B,B),bool),Y1: A,X: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X,Y1),inv_image(B,A,R,F))
    <=> member(product_prod(B,B),product_Pair(B,B,aa(A,B,F,X),aa(A,B,F,Y1)),R) ) ).

tff(fact_14_sym__Id__on,axiom,
    ! [A: $tType,A2: fun(A,bool)] : sym(A,id_on(A,A2)) ).

tff(fact_15_antisym__Id__on,axiom,
    ! [A: $tType,A2: fun(A,bool)] : antisym(A,id_on(A,A2)) ).

tff(fact_16_sym__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( sym(A,R)
    <=> ! [X2: A,Y2: A] :
          ( member(product_prod(A,A),product_Pair(A,A,X2,Y2),R)
         => member(product_prod(A,A),product_Pair(A,A,Y2,X2),R) ) ) ).

tff(fact_17_antisym__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( antisym(A,R)
    <=> ! [X2: A,Y2: A] :
          ( member(product_prod(A,A),product_Pair(A,A,X2,Y2),R)
         => ( member(product_prod(A,A),product_Pair(A,A,Y2,X2),R)
           => ( X2 = Y2 ) ) ) ) ).

tff(fact_18_total__on__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( total_on(A,A2,R)
    <=> ! [X2: A] :
          ( member(A,X2,A2)
         => ! [Xa: A] :
              ( member(A,Xa,A2)
             => ( ( X2 != Xa )
               => ( member(product_prod(A,A),product_Pair(A,A,X2,Xa),R)
                  | member(product_prod(A,A),product_Pair(A,A,Xa,X2),R) ) ) ) ) ) ).

tff(fact_19_Id__on__iff,axiom,
    ! [A: $tType,A2: fun(A,bool),Y1: A,X: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X,Y1),id_on(A,A2))
    <=> ( ( X = Y1 )
        & member(A,X,A2) ) ) ).

tff(fact_20_sym__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(B,A),R: fun(product_prod(A,A),bool)] :
      ( sym(A,R)
     => sym(B,inv_image(A,B,R,F)) ) ).

tff(fact_21_symD,axiom,
    ! [A: $tType,B1: A,A1: A,R: fun(product_prod(A,A),bool)] :
      ( sym(A,R)
     => ( member(product_prod(A,A),product_Pair(A,A,A1,B1),R)
       => member(product_prod(A,A),product_Pair(A,A,B1,A1),R) ) ) ).

tff(fact_22_antisymD,axiom,
    ! [A: $tType,B1: A,A1: A,R: fun(product_prod(A,A),bool)] :
      ( antisym(A,R)
     => ( member(product_prod(A,A),product_Pair(A,A,A1,B1),R)
       => ( member(product_prod(A,A),product_Pair(A,A,B1,A1),R)
         => ( A1 = B1 ) ) ) ) ).

tff(fact_23_Id__on__eqI,axiom,
    ! [A: $tType,A2: fun(A,bool),B1: A,A1: A] :
      ( ( A1 = B1 )
     => ( member(A,A1,A2)
       => member(product_prod(A,A),product_Pair(A,A,A1,B1),id_on(A,A2)) ) ) ).

tff(fact_24_partial__order__on__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( order_915043626der_on(A,A2,R)
    <=> ( order_preorder_on(A,A2,R)
        & antisym(A,R) ) ) ).

tff(fact_25_linear__order__on__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( order_1409979114der_on(A,A2,R)
    <=> ( order_915043626der_on(A,A2,R)
        & total_on(A,A2,R) ) ) ).

tff(fact_26_converseD,axiom,
    ! [A: $tType,B: $tType,R: fun(product_prod(B,A),bool),B1: B,A1: A] :
      ( member(product_prod(A,B),product_Pair(A,B,A1,B1),converse(B,A,R))
     => member(product_prod(B,A),product_Pair(B,A,B1,A1),R) ) ).

tff(fact_27_converseI,axiom,
    ! [B: $tType,A: $tType,R: fun(product_prod(A,B),bool),B1: B,A1: A] :
      ( member(product_prod(A,B),product_Pair(A,B,A1,B1),R)
     => member(product_prod(B,A),product_Pair(B,A,B1,A1),converse(A,B,R)) ) ).

tff(fact_28_sym__conv__converse__eq,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( sym(A,R)
    <=> ( converse(A,A,R) = R ) ) ).

tff(fact_29_Id__onE,axiom,
    ! [A: $tType,A2: fun(A,bool),C1: product_prod(A,A)] :
      ( member(product_prod(A,A),C1,id_on(A,A2))
     => ~ ! [X1: A] :
            ( member(A,X1,A2)
           => ( C1 != product_Pair(A,A,X1,X1) ) ) ) ).

tff(fact_30_converseE,axiom,
    ! [A: $tType,B: $tType,R: fun(product_prod(B,A),bool),Yx: product_prod(A,B)] :
      ( member(product_prod(A,B),Yx,converse(B,A,R))
     => ~ ! [X1: B,Y: A] :
            ( ( Yx = product_Pair(A,B,Y,X1) )
           => ~ member(product_prod(B,A),product_Pair(B,A,X1,Y),R) ) ) ).

tff(fact_31_antisymI,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( ! [X1: A,Y: A] :
          ( member(product_prod(A,A),product_Pair(A,A,X1,Y),R)
         => ( member(product_prod(A,A),product_Pair(A,A,Y,X1),R)
           => ( X1 = Y ) ) )
     => antisym(A,R) ) ).

tff(fact_32_symI,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( ! [A3: A,B2: A] :
          ( member(product_prod(A,A),product_Pair(A,A,A3,B2),R)
         => member(product_prod(A,A),product_Pair(A,A,B2,A3),R) )
     => sym(A,R) ) ).

tff(fact_33_top1I,axiom,
    ! [A: $tType,X: A] : pp(aa(A,bool,top_top(fun(A,bool)),X)) ).

tff(fact_34_UNIV__I,axiom,
    ! [A: $tType,X: A] : member(A,X,top_top(fun(A,bool))) ).

tff(fact_35_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X: A] : member(A,X,top_top(fun(A,bool))) ).

tff(fact_36_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ! [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,P1,product_Pair(A,B,A4,B3))) ) ).

tff(fact_37_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A7: A,B1: B,A1: A] :
      ( ( product_Pair(A,B,A1,B1) = product_Pair(A,B,A7,B6) )
    <=> ( ( A1 = A7 )
        & ( B1 = B6 ) ) ) ).

tff(fact_38_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A6: A,B4: B,A5: A] :
      ( ( product_Pair(A,B,A5,B4) = product_Pair(A,B,A6,B5) )
     => ~ ( ( A5 = A6 )
         => ( B4 != B5 ) ) ) ).

tff(fact_39_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_40_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ? [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,P1,product_Pair(A,B,A4,B3))) ) ).

tff(fact_41_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C2: $tType,B1: C2,A1: B,F11: fun(B,fun(C2,A))] : ( product_prod_rec(B,C2,A,F11,product_Pair(B,C2,A1,B1)) = aa(C2,A,aa(B,fun(C2,A),F11,A1),B1) ) ).

tff(fact_42_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X: B] : ( aa(B,A,top_top(fun(B,A)),X) = top_top(A) ) ) ).

tff(fact_43_UNIV__eq__I,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ! [X1: A] : member(A,X1,A2)
     => ( top_top(fun(A,bool)) = A2 ) ) ).

tff(fact_44_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X1: A] : member(A,X1,top_top(fun(A,bool))) ).

tff(fact_45_prod__induct6,axiom,
    ! [F1: $tType,E: $tType,D: $tType,C2: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C2,product_prod(D,product_prod(E,F1))))),P1: fun(product_prod(A,product_prod(B,product_prod(C2,product_prod(D,product_prod(E,F1))))),bool)] :
      ( ! [A3: A,B2: B,C: C2,D1: D,E1: E,F2: F1] : pp(aa(product_prod(A,product_prod(B,product_prod(C2,product_prod(D,product_prod(E,F1))))),bool,P1,product_Pair(A,product_prod(B,product_prod(C2,product_prod(D,product_prod(E,F1)))),A3,product_Pair(B,product_prod(C2,product_prod(D,product_prod(E,F1))),B2,product_Pair(C2,product_prod(D,product_prod(E,F1)),C,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C2,product_prod(D,product_prod(E,F1))))),bool,P1,X)) ) ).

tff(fact_46_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C2: $tType,D: $tType,E: $tType,F1: $tType,Y3: product_prod(A,product_prod(B,product_prod(C2,product_prod(D,product_prod(E,F1)))))] :
      ~ ! [A3: A,B2: B,C: C2,D1: D,E1: E,F2: F1] : ( Y3 != product_Pair(A,product_prod(B,product_prod(C2,product_prod(D,product_prod(E,F1)))),A3,product_Pair(B,product_prod(C2,product_prod(D,product_prod(E,F1))),B2,product_Pair(C2,product_prod(D,product_prod(E,F1)),C,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2))))) ) ).

tff(fact_47_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C2: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C2,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B,product_prod(C2,product_prod(D,E)))),bool)] :
      ( ! [A3: A,B2: B,C: C2,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C2,product_prod(D,E)))),bool,P1,product_Pair(A,product_prod(B,product_prod(C2,product_prod(D,E))),A3,product_Pair(B,product_prod(C2,product_prod(D,E)),B2,product_Pair(C2,product_prod(D,E),C,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C2,product_prod(D,E)))),bool,P1,X)) ) ).

tff(fact_48_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C2: $tType,D: $tType,E: $tType,Y3: product_prod(A,product_prod(B,product_prod(C2,product_prod(D,E))))] :
      ~ ! [A3: A,B2: B,C: C2,D1: D,E1: E] : ( Y3 != product_Pair(A,product_prod(B,product_prod(C2,product_prod(D,E))),A3,product_Pair(B,product_prod(C2,product_prod(D,E)),B2,product_Pair(C2,product_prod(D,E),C,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_49_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C2: $tType,D: $tType,Y3: product_prod(A,product_prod(B,product_prod(C2,D)))] :
      ~ ! [A3: A,B2: B,C: C2,D1: D] : ( Y3 != product_Pair(A,product_prod(B,product_prod(C2,D)),A3,product_Pair(B,product_prod(C2,D),B2,product_Pair(C2,D,C,D1))) ) ).

tff(fact_50_prod__induct4,axiom,
    ! [D: $tType,C2: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C2,D))),P1: fun(product_prod(A,product_prod(B,product_prod(C2,D))),bool)] :
      ( ! [A3: A,B2: B,C: C2,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C2,D))),bool,P1,product_Pair(A,product_prod(B,product_prod(C2,D)),A3,product_Pair(B,product_prod(C2,D),B2,product_Pair(C2,D,C,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C2,D))),bool,P1,X)) ) ).

tff(fact_51_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C2: $tType,Y3: product_prod(A,product_prod(B,C2))] :
      ~ ! [A3: A,B2: B,C: C2] : ( Y3 != product_Pair(A,product_prod(B,C2),A3,product_Pair(B,C2,B2,C)) ) ).

tff(fact_52_prod__induct3,axiom,
    ! [C2: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,C2)),P1: fun(product_prod(A,product_prod(B,C2)),bool)] :
      ( ! [A3: A,B2: B,C: C2] : pp(aa(product_prod(A,product_prod(B,C2)),bool,P1,product_Pair(A,product_prod(B,C2),A3,product_Pair(B,C2,B2,C))))
     => pp(aa(product_prod(A,product_prod(B,C2)),bool,P1,X)) ) ).

tff(fact_53_PairE,axiom,
    ! [A: $tType,B: $tType,P3: product_prod(A,B)] :
      ~ ! [X1: A,Y: B] : ( P3 != product_Pair(A,B,X1,Y) ) ).

tff(fact_54_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y3: product_prod(A,B)] :
      ~ ! [A3: A,B2: B] : ( Y3 != product_Pair(A,B,A3,B2) ) ).

tff(fact_55_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C2: $tType,B1: C2,A1: B,C1: fun(B,fun(C2,A))] : ( produc1605651328_split(B,C2,A,C1,product_Pair(B,C2,A1,B1)) = aa(C2,A,aa(B,fun(C2,A),C1,A1),B1) ) ).

tff(fact_56_curry__conv,axiom,
    ! [A: $tType,B: $tType,C2: $tType,B1: C2,A1: B,F: fun(product_prod(B,C2),A)] : ( product_curry(B,C2,A,F,A1,B1) = aa(product_prod(B,C2),A,F,product_Pair(B,C2,A1,B1)) ) ).

tff(fact_57_curryI,axiom,
    ! [A: $tType,B: $tType,B1: B,A1: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A1,B1)))
     => pp(product_curry(A,B,bool,F,A1,B1)) ) ).

tff(fact_58_curryE,axiom,
    ! [A: $tType,B: $tType,B1: B,A1: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,A1,B1))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A1,B1))) ) ).

tff(fact_59_curryD,axiom,
    ! [A: $tType,B: $tType,B1: B,A1: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,A1,B1))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A1,B1))) ) ).

tff(fact_60_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Y1: B,X: B,F: fun(B,A),R: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R,F,X,Y1)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R,aa(B,A,F,X)),aa(B,A,F,Y1))) ) ).

tff(fact_61_irrefl__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( irrefl(A,R)
    <=> ! [X2: A] : ~ member(product_prod(A,A),product_Pair(A,A,X2,X2),R) ) ).

tff(fact_62_strict__linear__order__on__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,order_215145569der_on(A,A2),R))
    <=> ( trans(A,R)
        & irrefl(A,R)
        & total_on(A,A2,R) ) ) ).

tff(fact_63_trans__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( trans(A,converse(A,A,R))
    <=> trans(A,R) ) ).

tff(fact_64_transD,axiom,
    ! [A: $tType,C1: A,B1: A,A1: A,R: fun(product_prod(A,A),bool)] :
      ( trans(A,R)
     => ( member(product_prod(A,A),product_Pair(A,A,A1,B1),R)
       => ( member(product_prod(A,A),product_Pair(A,A,B1,C1),R)
         => member(product_prod(A,A),product_Pair(A,A,A1,C1),R) ) ) ) ).

tff(fact_65_trans__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( trans(A,R)
    <=> ! [X2: A,Y2: A,Z2: A] :
          ( member(product_prod(A,A),product_Pair(A,A,X2,Y2),R)
         => ( member(product_prod(A,A),product_Pair(A,A,Y2,Z2),R)
           => member(product_prod(A,A),product_Pair(A,A,X2,Z2),R) ) ) ) ).

tff(fact_66_trans__Id__on,axiom,
    ! [A: $tType,A2: fun(A,bool)] : trans(A,id_on(A,A2)) ).

tff(fact_67_trans__inv__image,axiom,
    ! [A: $tType,B: $tType,F: fun(B,A),R: fun(product_prod(A,A),bool)] :
      ( trans(A,R)
     => trans(B,inv_image(A,B,R,F)) ) ).

tff(fact_68_transI,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( ! [X1: A,Y: A,Z: A] :
          ( member(product_prod(A,A),product_Pair(A,A,X1,Y),R)
         => ( member(product_prod(A,A),product_Pair(A,A,Y,Z),R)
           => member(product_prod(A,A),product_Pair(A,A,X1,Z),R) ) )
     => trans(A,R) ) ).

tff(fact_69_preorder__on__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( order_preorder_on(A,A2,R)
    <=> ( refl_on(A,A2,R)
        & trans(A,R) ) ) ).

tff(fact_70_acyclic__irrefl,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( transitive_acyclic(A,R)
    <=> irrefl(A,transitive_trancl(A,R)) ) ).

tff(fact_71_trancl_Or__into__trancl,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),B1: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B1),R)
     => member(product_prod(A,A),product_Pair(A,A,A1,B1),transitive_trancl(A,R)) ) ).

tff(fact_72_refl__on__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( refl_on(A,A2,converse(A,A,R))
    <=> refl_on(A,A2,R) ) ).

tff(fact_73_trancl__id,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( trans(A,R)
     => ( transitive_trancl(A,R) = R ) ) ).

tff(fact_74_trans__trancl,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] : trans(A,transitive_trancl(A,R)) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X: A] :
      ( member(A,X,A2)
    <=> pp(aa(A,bool,A2,X)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_refl__on__Id__on,axiom,
    ! [A: $tType,A2: fun(A,bool)] : refl_on(A,A2,id_on(A,A2)) ).

tff(fact_79_trancl__converse,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] : ( transitive_trancl(A,converse(A,A,R)) = converse(A,A,transitive_trancl(A,R)) ) ).

tff(fact_80_sym__trancl,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( sym(A,R)
     => sym(A,transitive_trancl(A,R)) ) ).

tff(fact_81_r__into__trancl_H,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),P2: product_prod(A,A)] :
      ( member(product_prod(A,A),P2,R)
     => member(product_prod(A,A),P2,transitive_trancl(A,R)) ) ).

tff(fact_82_refl__onD,axiom,
    ! [A: $tType,A1: A,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( refl_on(A,A2,R)
     => ( member(A,A1,A2)
       => member(product_prod(A,A),product_Pair(A,A,A1,A1),R) ) ) ).

tff(fact_83_refl__onD1,axiom,
    ! [A: $tType,Y1: A,X: A,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( refl_on(A,A2,R)
     => ( member(product_prod(A,A),product_Pair(A,A,X,Y1),R)
       => member(A,X,A2) ) ) ).

tff(fact_84_refl__onD2,axiom,
    ! [A: $tType,Y1: A,X: A,R: fun(product_prod(A,A),bool),A2: fun(A,bool)] :
      ( refl_on(A,A2,R)
     => ( member(product_prod(A,A),product_Pair(A,A,X,Y1),R)
       => member(A,Y1,A2) ) ) ).

tff(fact_85_trancl__trans,axiom,
    ! [A: $tType,C1: A,R: fun(product_prod(A,A),bool),B1: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B1),transitive_trancl(A,R))
     => ( member(product_prod(A,A),product_Pair(A,A,B1,C1),transitive_trancl(A,R))
       => member(product_prod(A,A),product_Pair(A,A,A1,C1),transitive_trancl(A,R)) ) ) ).

tff(fact_86_Transitive__Closure_Otrancl__into__trancl,axiom,
    ! [A: $tType,C1: A,R: fun(product_prod(A,A),bool),B1: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B1),transitive_trancl(A,R))
     => ( member(product_prod(A,A),product_Pair(A,A,B1,C1),R)
       => member(product_prod(A,A),product_Pair(A,A,A1,C1),transitive_trancl(A,R)) ) ) ).

tff(fact_87_trancl__into__trancl2,axiom,
    ! [A: $tType,C1: A,R: fun(product_prod(A,A),bool),B1: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B1),R)
     => ( member(product_prod(A,A),product_Pair(A,A,B1,C1),transitive_trancl(A,R))
       => member(product_prod(A,A),product_Pair(A,A,A1,C1),transitive_trancl(A,R)) ) ) ).

tff(fact_88_r__r__into__trancl,axiom,
    ! [A: $tType,C1: A,R1: fun(product_prod(A,A),bool),B1: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B1),R1)
     => ( member(product_prod(A,A),product_Pair(A,A,B1,C1),R1)
       => member(product_prod(A,A),product_Pair(A,A,A1,C1),transitive_trancl(A,R1)) ) ) ).

tff(fact_89_trancl__converseD,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Y1: A,X: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X,Y1),transitive_trancl(A,converse(A,A,R)))
     => member(product_prod(A,A),product_Pair(A,A,X,Y1),converse(A,A,transitive_trancl(A,R))) ) ).

tff(fact_90_trancl__converseI,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Y1: A,X: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X,Y1),converse(A,A,transitive_trancl(A,R)))
     => member(product_prod(A,A),product_Pair(A,A,X,Y1),transitive_trancl(A,converse(A,A,R))) ) ).

tff(fact_91_acyclic__def,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( transitive_acyclic(A,R)
    <=> ! [X2: A] : ~ member(product_prod(A,A),product_Pair(A,A,X2,X2),transitive_trancl(A,R)) ) ).

tff(fact_92_acyclicI,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] :
      ( ! [X1: A] : ~ member(product_prod(A,A),product_Pair(A,A,X1,X1),transitive_trancl(A,R))
     => transitive_acyclic(A,R) ) ).

tff(fact_93_tranclE,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),B1: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B1),transitive_trancl(A,R))
     => ( ~ member(product_prod(A,A),product_Pair(A,A,A1,B1),R)
       => ~ ! [C: A] :
              ( member(product_prod(A,A),product_Pair(A,A,A1,C),transitive_trancl(A,R))
             => ~ member(product_prod(A,A),product_Pair(A,A,C,B1),R) ) ) ) ).

tff(fact_94_converse__tranclE,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Z1: A,X: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X,Z1),transitive_trancl(A,R))
     => ( ~ member(product_prod(A,A),product_Pair(A,A,X,Z1),R)
       => ~ ! [Y: A] :
              ( member(product_prod(A,A),product_Pair(A,A,X,Y),R)
             => ~ member(product_prod(A,A),product_Pair(A,A,Y,Z1),transitive_trancl(A,R)) ) ) ) ).

tff(fact_95_irrefl__trancl__rD,axiom,
    ! [A: $tType,Y1: A,X: A,R: fun(product_prod(A,A),bool)] :
      ( ! [X1: A] : ~ member(product_prod(A,A),product_Pair(A,A,X1,X1),transitive_trancl(A,R))
     => ( member(product_prod(A,A),product_Pair(A,A,X,Y1),R)
       => ( X != Y1 ) ) ) ).

tff(fact_96_trancl__trans__induct,axiom,
    ! [A: $tType,P1: fun(A,fun(A,bool)),R: fun(product_prod(A,A),bool),Y1: A,X: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X,Y1),transitive_trancl(A,R))
     => ( ! [X1: A,Y: A] :
            ( member(product_prod(A,A),product_Pair(A,A,X1,Y),R)
           => pp(aa(A,bool,aa(A,fun(A,bool),P1,X1),Y)) )
       => ( ! [X1: A,Y: A,Z: A] :
              ( member(product_prod(A,A),product_Pair(A,A,X1,Y),transitive_trancl(A,R))
             => ( pp(aa(A,bool,aa(A,fun(A,bool),P1,X1),Y))
               => ( member(product_prod(A,A),product_Pair(A,A,Y,Z),transitive_trancl(A,R))
                 => ( pp(aa(A,bool,aa(A,fun(A,bool),P1,Y),Z))
                   => pp(aa(A,bool,aa(A,fun(A,bool),P1,X1),Z)) ) ) ) )
         => pp(aa(A,bool,aa(A,fun(A,bool),P1,X),Y1)) ) ) ) ).

tff(fact_97_converse__trancl__induct,axiom,
    ! [A: $tType,P1: fun(A,bool),R: fun(product_prod(A,A),bool),B1: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B1),transitive_trancl(A,R))
     => ( ! [Y: A] :
            ( member(product_prod(A,A),product_Pair(A,A,Y,B1),R)
           => pp(aa(A,bool,P1,Y)) )
       => ( ! [Y: A,Z: A] :
              ( member(product_prod(A,A),product_Pair(A,A,Y,Z),R)
             => ( member(product_prod(A,A),product_Pair(A,A,Z,B1),transitive_trancl(A,R))
               => ( pp(aa(A,bool,P1,Z))
                 => pp(aa(A,bool,P1,Y)) ) ) )
         => pp(aa(A,bool,P1,A1)) ) ) ) ).

tff(fact_98_trancl__induct,axiom,
    ! [A: $tType,P1: fun(A,bool),R: fun(product_prod(A,A),bool),B1: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B1),transitive_trancl(A,R))
     => ( ! [Y: A] :
            ( member(product_prod(A,A),product_Pair(A,A,A1,Y),R)
           => pp(aa(A,bool,P1,Y)) )
       => ( ! [Y: A,Z: A] :
              ( member(product_prod(A,A),product_Pair(A,A,A1,Y),transitive_trancl(A,R))
             => ( member(product_prod(A,A),product_Pair(A,A,Y,Z),R)
               => ( pp(aa(A,bool,P1,Y))
                 => pp(aa(A,bool,P1,Z)) ) ) )
         => pp(aa(A,bool,P1,B1)) ) ) ) ).

%----Arities (2)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ( member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),converse(arrow_411405190le_alt,arrow_411405190le_alt,l),arrow_1985332922le_Lin)
  <=> member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),l,arrow_1985332922le_Lin) ) ).

%------------------------------------------------------------------------------
