%------------------------------------------------------------------------------
% File     : SCT174_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 42
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_42 [Bla13]

% Status   : ContradictoryAxioms
% Rating   : 0.33 v9.1.0, 0.00 v8.1.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  114 (  33 unt;  31 typ;   0 def)
%            Number of atoms       :  176 (  59 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  125 (  32   ~;   3   |;   5   &)
%                                         (  15 <=>;  70  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   35 (  21   >;  14   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  10 usr;   1 prp; 0-5 aty)
%            Number of functors    :   19 (  19 usr;   5 con; 0-6 aty)
%            Number of variables   :  482 ( 435   !;   5   ?; 482   :)
%                                         (  42  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:01
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (27)
tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A1: $tType,B: $tType] : ( ( fun(product_prod(A1,B),bool) * A1 * B ) > $o ) ).

tff(sy_c_Nitpick_Orefl_H,type,
    refl: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > $o ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A1: $tType] : ( ( fun(A1,bool) * fun(product_prod(A1,A1),bool) ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A1: $tType,B: $tType] : fun(A1,fun(B,product_prod(A1,B))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A1: $tType,C1: $tType,B: $tType] : ( ( fun(A1,C1) * product_prod(A1,B) ) > product_prod(C1,B) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B: $tType,C1: $tType,A1: $tType] : ( ( fun(B,C1) * product_prod(A1,B) ) > product_prod(A1,C1) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A1: $tType,B: $tType,C1: $tType] : ( fun(product_prod(A1,B),C1) > fun(A1,fun(B,C1)) ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A1: $tType,B: $tType,C1: $tType] : fun(fun(A1,fun(B,C1)),fun(product_prod(A1,B),C1)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A1: $tType,B: $tType,T: $tType] : fun(fun(A1,fun(B,T)),fun(product_prod(A1,B),T)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A1: $tType,B: $tType,T: $tType] : ( ( fun(A1,fun(B,T)) * product_prod(A1,B) ) > T ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A1: $tType,B: $tType,C1: $tType,D: $tType] : ( ( fun(A1,product_prod(B,C1)) * fun(B,fun(C1,D)) ) > fun(A1,D) ) ).

tff(sy_c_Relation_OId__on,type,
    id_on: 
      !>[A1: $tType] : ( fun(A1,bool) > fun(product_prod(A1,A1),bool) ) ).

tff(sy_c_Relation_Oantisym,type,
    antisym: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > $o ) ).

tff(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B: $tType,A1: $tType] : ( ( fun(product_prod(B,B),bool) * fun(A1,B) ) > fun(product_prod(A1,A1),bool) ) ).

tff(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > $o ) ).

tff(sy_c_Relation_Osingle__valued,type,
    single_valued: 
      !>[A1: $tType,B: $tType] : ( fun(product_prod(A1,B),bool) > $o ) ).

tff(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A1: $tType] : ( ( fun(A1,bool) * fun(product_prod(A1,A1),bool) ) > $o ) ).

tff(sy_c_Relation_Otrans,type,
    trans: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > $o ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A1: $tType,B: $tType] : ( ( fun(product_prod(A1,A1),bool) * fun(product_prod(B,B),bool) ) > fun(product_prod(product_prod(A1,B),product_prod(A1,B)),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B: $tType] : ( ( fun(A1,B) * A1 ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_L,type,
    l: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_x,type,
    x: arrow_411405190le_alt ).

tff(sy_v_y,type,
    y: arrow_411405190le_alt ).

%----Relevant facts (74)
tff(fact_0_split__paired__All,axiom,
    ! [A1: $tType,B: $tType,P1: fun(product_prod(A1,B),bool)] :
      ( ! [X11: product_prod(A1,B)] : pp(aa(product_prod(A1,B),bool,P1,X11))
    <=> ! [A5: A1,B4: B] : pp(aa(product_prod(A1,B),bool,P1,aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A5),B4))) ) ).

tff(fact_1_Pair__eq,axiom,
    ! [A1: $tType,B: $tType,B3: B,A4: A1,B1: B,A2: A1] :
      ( ( aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1) = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A4),B3) )
    <=> ( ( A2 = A4 )
        & ( B1 = B3 ) ) ) ).

tff(fact_2_trans__def,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool)] :
      ( trans(A1,R)
    <=> ! [X2: A1,Y2: A1,Z2: A1] :
          ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X2),Y2),R)
         => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),Y2),Z2),R)
           => member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X2),Z2),R) ) ) ) ).

tff(fact_3_transD,axiom,
    ! [A1: $tType,C: A1,B1: A1,A2: A1,R: fun(product_prod(A1,A1),bool)] :
      ( trans(A1,R)
     => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),A2),B1),R)
       => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),B1),C),R)
         => member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),A2),C),R) ) ) ) ).

tff(fact_4_transI,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool)] :
      ( ! [X1: A1,Y1: A1,Z: A1] :
          ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X1),Y1),R)
         => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),Y1),Z),R)
           => member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X1),Z),R) ) )
     => trans(A1,R) ) ).

tff(fact_5_Pair__inject,axiom,
    ! [A1: $tType,B: $tType,B6: B,A7: A1,B5: B,A6: A1] :
      ( ( aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A6),B5) = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A7),B6) )
     => ~ ( ( A6 = A7 )
         => ( B5 != B6 ) ) ) ).

tff(fact_6_trans__lex__prod,axiom,
    ! [A1: $tType,B: $tType,R2: fun(product_prod(B,B),bool),R11: fun(product_prod(A1,A1),bool)] :
      ( trans(A1,R11)
     => ( trans(B,R2)
       => trans(product_prod(A1,B),lex_prod(A1,B,R11,R2)) ) ) ).

tff(fact_7_in__rel__def,axiom,
    ! [B: $tType,A1: $tType,Ya: B,Xa: A1,R1: fun(product_prod(A1,B),bool)] :
      ( in_rel(A1,B,R1,Xa,Ya)
    <=> member(product_prod(A1,B),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Xa),Ya),R1) ) ).

tff(fact_8_split__paired__Ex,axiom,
    ! [A1: $tType,B: $tType,P1: fun(product_prod(A1,B),bool)] :
      ( ? [X11: product_prod(A1,B)] : pp(aa(product_prod(A1,B),bool,P1,X11))
    <=> ? [A5: A1,B4: B] : pp(aa(product_prod(A1,B),bool,P1,aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A5),B4))) ) ).

tff(fact_9_Nitpick_Orefl_H__def,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool)] :
      ( refl(A1,R)
    <=> ! [X2: A1] : member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X2),X2),R) ) ).

tff(fact_10_in__lex__prod,axiom,
    ! [A1: $tType,B: $tType,S: fun(product_prod(B,B),bool),R: fun(product_prod(A1,A1),bool),B3: B,A4: A1,B1: B,A2: A1] :
      ( member(product_prod(product_prod(A1,B),product_prod(A1,B)),aa(product_prod(A1,B),product_prod(product_prod(A1,B),product_prod(A1,B)),aa(product_prod(A1,B),fun(product_prod(A1,B),product_prod(product_prod(A1,B),product_prod(A1,B))),product_Pair(product_prod(A1,B),product_prod(A1,B)),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1)),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A4),B3)),lex_prod(A1,B,R,S))
    <=> ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),A2),A4),R)
        | ( ( A2 = A4 )
          & member(product_prod(B,B),aa(B,product_prod(B,B),aa(B,fun(B,product_prod(B,B)),product_Pair(B,B),B1),B3),S) ) ) ) ).

tff(fact_11_prod_Orecs,axiom,
    ! [B: $tType,A1: $tType,C1: $tType,B1: C1,A2: B,F1: fun(B,fun(C1,A1))] : ( product_prod_rec(B,C1,A1,F1,aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1)) = aa(C1,A1,aa(B,fun(C1,A1),F1,A2),B1) ) ).

tff(fact_12_prod__cases3,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,Y3: product_prod(A1,product_prod(B,C1))] :
      ~ ! [A3: A1,B2: B,C2: C1] : ( Y3 != aa(product_prod(B,C1),product_prod(A1,product_prod(B,C1)),aa(A1,fun(product_prod(B,C1),product_prod(A1,product_prod(B,C1))),product_Pair(A1,product_prod(B,C1)),A3),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),B2),C2)) ) ).

tff(fact_13_prod__induct3,axiom,
    ! [C1: $tType,B: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B,C1)),P1: fun(product_prod(A1,product_prod(B,C1)),bool)] :
      ( ! [A3: A1,B2: B,C2: C1] : pp(aa(product_prod(A1,product_prod(B,C1)),bool,P1,aa(product_prod(B,C1),product_prod(A1,product_prod(B,C1)),aa(A1,fun(product_prod(B,C1),product_prod(A1,product_prod(B,C1))),product_Pair(A1,product_prod(B,C1)),A3),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),B2),C2))))
     => pp(aa(product_prod(A1,product_prod(B,C1)),bool,P1,Xa)) ) ).

tff(fact_14_prod__cases4,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,D: $tType,Y3: product_prod(A1,product_prod(B,product_prod(C1,D)))] :
      ~ ! [A3: A1,B2: B,C2: C1,D1: D] : ( Y3 != aa(product_prod(B,product_prod(C1,D)),product_prod(A1,product_prod(B,product_prod(C1,D))),aa(A1,fun(product_prod(B,product_prod(C1,D)),product_prod(A1,product_prod(B,product_prod(C1,D)))),product_Pair(A1,product_prod(B,product_prod(C1,D))),A3),aa(product_prod(C1,D),product_prod(B,product_prod(C1,D)),aa(B,fun(product_prod(C1,D),product_prod(B,product_prod(C1,D))),product_Pair(B,product_prod(C1,D)),B2),aa(D,product_prod(C1,D),aa(C1,fun(D,product_prod(C1,D)),product_Pair(C1,D),C2),D1))) ) ).

tff(fact_15_prod__induct4,axiom,
    ! [D: $tType,C1: $tType,B: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B,product_prod(C1,D))),P1: fun(product_prod(A1,product_prod(B,product_prod(C1,D))),bool)] :
      ( ! [A3: A1,B2: B,C2: C1,D1: D] : pp(aa(product_prod(A1,product_prod(B,product_prod(C1,D))),bool,P1,aa(product_prod(B,product_prod(C1,D)),product_prod(A1,product_prod(B,product_prod(C1,D))),aa(A1,fun(product_prod(B,product_prod(C1,D)),product_prod(A1,product_prod(B,product_prod(C1,D)))),product_Pair(A1,product_prod(B,product_prod(C1,D))),A3),aa(product_prod(C1,D),product_prod(B,product_prod(C1,D)),aa(B,fun(product_prod(C1,D),product_prod(B,product_prod(C1,D))),product_Pair(B,product_prod(C1,D)),B2),aa(D,product_prod(C1,D),aa(C1,fun(D,product_prod(C1,D)),product_Pair(C1,D),C2),D1)))))
     => pp(aa(product_prod(A1,product_prod(B,product_prod(C1,D))),bool,P1,Xa)) ) ).

tff(fact_16_prod__cases5,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,D: $tType,E: $tType,Y3: product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E))))] :
      ~ ! [A3: A1,B2: B,C2: C1,D1: D,E1: E] : ( Y3 != aa(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),aa(A1,fun(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E))))),product_Pair(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),A3),aa(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E))),aa(B,fun(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E)))),product_Pair(B,product_prod(C1,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C1,product_prod(D,E)),aa(C1,fun(product_prod(D,E),product_prod(C1,product_prod(D,E))),product_Pair(C1,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_17_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C1: $tType,B: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),P1: fun(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),bool)] :
      ( ! [A3: A1,B2: B,C2: C1,D1: D,E1: E] : pp(aa(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),bool,P1,aa(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),aa(A1,fun(product_prod(B,product_prod(C1,product_prod(D,E))),product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E))))),product_Pair(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),A3),aa(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E))),aa(B,fun(product_prod(C1,product_prod(D,E)),product_prod(B,product_prod(C1,product_prod(D,E)))),product_Pair(B,product_prod(C1,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C1,product_prod(D,E)),aa(C1,fun(product_prod(D,E),product_prod(C1,product_prod(D,E))),product_Pair(C1,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),bool,P1,Xa)) ) ).

tff(fact_18_prod__cases6,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,D: $tType,E: $tType,F2: $tType,Y3: product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A3: A1,B2: B,C2: C1,D1: D,E1: E,F3: F2] : ( Y3 != aa(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),aa(A1,fun(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))))),product_Pair(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2))),aa(C1,fun(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2)))),product_Pair(C1,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_19_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C1: $tType,B: $tType,A1: $tType,Xa: product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),P1: fun(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A3: A1,B2: B,C2: C1,D1: D,E1: E,F3: F2] : pp(aa(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool,P1,aa(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),aa(A1,fun(product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))))),product_Pair(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),A3),aa(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C1,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C1,product_prod(D,product_prod(E,F2)))),B2),aa(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2))),aa(C1,fun(product_prod(D,product_prod(E,F2)),product_prod(C1,product_prod(D,product_prod(E,F2)))),product_Pair(C1,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D1),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F2))))),bool,P1,Xa)) ) ).

tff(fact_20_prod_Oexhaust,axiom,
    ! [A1: $tType,B: $tType,Y3: product_prod(A1,B)] :
      ~ ! [A3: A1,B2: B] : ( Y3 != aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A3),B2) ) ).

tff(fact_21_PairE,axiom,
    ! [A1: $tType,B: $tType,P2: product_prod(A1,B)] :
      ~ ! [X1: A1,Y1: B] : ( P2 != aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y1) ) ).

tff(fact_22_internal__split__conv,axiom,
    ! [B: $tType,A1: $tType,C1: $tType,B1: C1,A2: B,C: fun(B,fun(C1,A1))] : ( aa(product_prod(B,C1),A1,aa(fun(B,fun(C1,A1)),fun(product_prod(B,C1),A1),produc1605651328_split(B,C1,A1),C),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1)) = aa(C1,A1,aa(B,fun(C1,A1),C,A2),B1) ) ).

tff(fact_23_curry__conv,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,B1: C1,A2: B,F: fun(product_prod(B,C1),A1)] : ( aa(C1,A1,aa(B,fun(C1,A1),product_curry(B,C1,A1,F),A2),B1) = aa(product_prod(B,C1),A1,F,aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1)) ) ).

tff(fact_24_curryI,axiom,
    ! [A1: $tType,B: $tType,B1: B,A2: A1,F: fun(product_prod(A1,B),bool)] :
      ( pp(aa(product_prod(A1,B),bool,F,aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1)))
     => pp(aa(B,bool,aa(A1,fun(B,bool),product_curry(A1,B,bool,F),A2),B1)) ) ).

tff(fact_25_irrefl__def,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool)] :
      ( irrefl(A1,R)
    <=> ! [X2: A1] : ~ member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X2),X2),R) ) ).

tff(fact_26_in__inv__image,axiom,
    ! [A1: $tType,B: $tType,F: fun(A1,B),R: fun(product_prod(B,B),bool),Ya: A1,Xa: A1] :
      ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),Xa),Ya),inv_image(B,A1,R,F))
    <=> member(product_prod(B,B),aa(B,product_prod(B,B),aa(B,fun(B,product_prod(B,B)),product_Pair(B,B),aa(A1,B,F,Xa)),aa(A1,B,F,Ya)),R) ) ).

tff(fact_27_trans__inv__image,axiom,
    ! [A1: $tType,B: $tType,F: fun(B,A1),R: fun(product_prod(A1,A1),bool)] :
      ( trans(A1,R)
     => trans(B,inv_image(A1,B,R,F)) ) ).

tff(fact_28_curryE,axiom,
    ! [A1: $tType,B: $tType,B1: B,A2: A1,F: fun(product_prod(A1,B),bool)] :
      ( pp(aa(B,bool,aa(A1,fun(B,bool),product_curry(A1,B,bool,F),A2),B1))
     => pp(aa(product_prod(A1,B),bool,F,aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1))) ) ).

tff(fact_29_curryD,axiom,
    ! [A1: $tType,B: $tType,B1: B,A2: A1,F: fun(product_prod(A1,B),bool)] :
      ( pp(aa(B,bool,aa(A1,fun(B,bool),product_curry(A1,B,bool,F),A2),B1))
     => pp(aa(product_prod(A1,B),bool,F,aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1))) ) ).

tff(fact_30_internal__split__def,axiom,
    ! [C1: $tType,B: $tType,A1: $tType] : ( produc1605651328_split(A1,B,C1) = product_prod_case(A1,B,C1) ) ).

tff(fact_31_apsnd__conv,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,Ya: C1,Xa: A1,F: fun(C1,B)] : ( product_apsnd(C1,B,A1,F,aa(C1,product_prod(A1,C1),aa(A1,fun(C1,product_prod(A1,C1)),product_Pair(A1,C1),Xa),Ya)) = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Xa),aa(C1,B,F,Ya)) ) ).

tff(fact_32_strict__linear__order__on__def,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),A: fun(A1,bool)] :
      ( order_215145569der_on(A1,A,R)
    <=> ( trans(A1,R)
        & irrefl(A1,R)
        & total_on(A1,A,R) ) ) ).

tff(fact_33_apfst__conv,axiom,
    ! [C1: $tType,A1: $tType,B: $tType,Ya: B,Xa: C1,F: fun(C1,A1)] : ( product_apfst(C1,A1,B,F,aa(B,product_prod(C1,B),aa(C1,fun(B,product_prod(C1,B)),product_Pair(C1,B),Xa),Ya)) = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),aa(C1,A1,F,Xa)),Ya) ) ).

tff(fact_34_surj__pair,axiom,
    ! [A1: $tType,B: $tType,P2: product_prod(A1,B)] :
    ? [X1: A1,Y1: B] : ( P2 = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y1) ) ).

tff(fact_35_total__on__def,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),A: fun(A1,bool)] :
      ( total_on(A1,A,R)
    <=> ! [X2: A1] :
          ( member(A1,X2,A)
         => ! [Xa1: A1] :
              ( member(A1,Xa1,A)
             => ( ( X2 != Xa1 )
               => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X2),Xa1),R)
                  | member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),Xa1),X2),R) ) ) ) ) ) ).

tff(fact_36_splitI,axiom,
    ! [A1: $tType,B: $tType,B1: B,A2: A1,F: fun(A1,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A1,fun(B,bool),F,A2),B1))
     => pp(aa(product_prod(A1,B),bool,aa(fun(A1,fun(B,bool)),fun(product_prod(A1,B),bool),product_prod_case(A1,B,bool),F),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1))) ) ).

tff(fact_37_prod__caseI,axiom,
    ! [A1: $tType,B: $tType,B1: B,A2: A1,F1: fun(A1,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A1,fun(B,bool),F1,A2),B1))
     => pp(aa(product_prod(A1,B),bool,aa(fun(A1,fun(B,bool)),fun(product_prod(A1,B),bool),product_prod_case(A1,B,bool),F1),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1))) ) ).

tff(fact_38_mem__splitI,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,B1: C1,A2: B,C: fun(B,fun(C1,fun(A1,bool))),Z1: A1] :
      ( member(A1,Z1,aa(C1,fun(A1,bool),aa(B,fun(C1,fun(A1,bool)),C,A2),B1))
     => member(A1,Z1,aa(product_prod(B,C1),fun(A1,bool),aa(fun(B,fun(C1,fun(A1,bool))),fun(product_prod(B,C1),fun(A1,bool)),product_prod_case(B,C1,fun(A1,bool)),C),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1))) ) ).

tff(fact_39_split__conv,axiom,
    ! [B: $tType,A1: $tType,C1: $tType,B1: C1,A2: B,F: fun(B,fun(C1,A1))] : ( aa(product_prod(B,C1),A1,aa(fun(B,fun(C1,A1)),fun(product_prod(B,C1),A1),product_prod_case(B,C1,A1),F),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1)) = aa(C1,A1,aa(B,fun(C1,A1),F,A2),B1) ) ).

tff(fact_40_apsnd__apfst__commute,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,D: $tType,P: product_prod(D,C1),G: fun(D,A1),F: fun(C1,B)] : ( product_apsnd(C1,B,A1,F,product_apfst(D,A1,C1,G,P)) = product_apfst(D,A1,B,G,product_apsnd(C1,B,D,F,P)) ) ).

tff(fact_41_split__weak__cong,axiom,
    ! [C1: $tType,B: $tType,A1: $tType,C: fun(A1,fun(B,C1)),Q: product_prod(A1,B),P: product_prod(A1,B)] :
      ( ( P = Q )
     => ( aa(product_prod(A1,B),C1,aa(fun(A1,fun(B,C1)),fun(product_prod(A1,B),C1),product_prod_case(A1,B,C1),C),P) = aa(product_prod(A1,B),C1,aa(fun(A1,fun(B,C1)),fun(product_prod(A1,B),C1),product_prod_case(A1,B,C1),C),Q) ) ) ).

tff(fact_42_splitD,axiom,
    ! [A1: $tType,B: $tType,B1: B,A2: A1,F: fun(A1,fun(B,bool))] :
      ( pp(aa(product_prod(A1,B),bool,aa(fun(A1,fun(B,bool)),fun(product_prod(A1,B),bool),product_prod_case(A1,B,bool),F),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1)))
     => pp(aa(B,bool,aa(A1,fun(B,bool),F,A2),B1)) ) ).

tff(fact_43_splitD_H,axiom,
    ! [B: $tType,A1: $tType,C1: $tType,C: C1,B1: B,A2: A1,R1: fun(A1,fun(B,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A1,B),fun(C1,bool),aa(fun(A1,fun(B,fun(C1,bool))),fun(product_prod(A1,B),fun(C1,bool)),product_prod_case(A1,B,fun(C1,bool)),R1),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A2),B1)),C))
     => pp(aa(C1,bool,aa(B,fun(C1,bool),aa(A1,fun(B,fun(C1,bool)),R1,A2),B1),C)) ) ).

tff(fact_44_prod_Osimps_I2_J,axiom,
    ! [B: $tType,A1: $tType,C1: $tType,B1: C1,A2: B,F1: fun(B,fun(C1,A1))] : ( aa(product_prod(B,C1),A1,aa(fun(B,fun(C1,A1)),fun(product_prod(B,C1),A1),product_prod_case(B,C1,A1),F1),aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),A2),B1)) = aa(C1,A1,aa(B,fun(C1,A1),F1,A2),B1) ) ).

tff(fact_45_curry__split,axiom,
    ! [C1: $tType,B: $tType,A1: $tType,F: fun(A1,fun(B,C1))] : ( product_curry(A1,B,C1,aa(fun(A1,fun(B,C1)),fun(product_prod(A1,B),C1),product_prod_case(A1,B,C1),F)) = F ) ).

tff(fact_46_split__curry,axiom,
    ! [C1: $tType,B: $tType,A1: $tType,F: fun(product_prod(A1,B),C1)] : ( aa(fun(A1,fun(B,C1)),fun(product_prod(A1,B),C1),product_prod_case(A1,B,C1),product_curry(A1,B,C1,F)) = F ) ).

tff(fact_47_splitI2,axiom,
    ! [B: $tType,A1: $tType,C: fun(A1,fun(B,bool)),P: product_prod(A1,B)] :
      ( ! [A3: A1,B2: B] :
          ( ( P = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A3),B2) )
         => pp(aa(B,bool,aa(A1,fun(B,bool),C,A3),B2)) )
     => pp(aa(product_prod(A1,B),bool,aa(fun(A1,fun(B,bool)),fun(product_prod(A1,B),bool),product_prod_case(A1,B,bool),C),P)) ) ).

tff(fact_48_splitE,axiom,
    ! [A1: $tType,B: $tType,P: product_prod(A1,B),C: fun(A1,fun(B,bool))] :
      ( pp(aa(product_prod(A1,B),bool,aa(fun(A1,fun(B,bool)),fun(product_prod(A1,B),bool),product_prod_case(A1,B,bool),C),P))
     => ~ ! [X1: A1,Y1: B] :
            ( ( P = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y1) )
           => ~ pp(aa(B,bool,aa(A1,fun(B,bool),C,X1),Y1)) ) ) ).

tff(fact_49_mem__splitI2,axiom,
    ! [C1: $tType,B: $tType,A1: $tType,C: fun(A1,fun(B,fun(C1,bool))),Z1: C1,P: product_prod(A1,B)] :
      ( ! [A3: A1,B2: B] :
          ( ( P = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A3),B2) )
         => member(C1,Z1,aa(B,fun(C1,bool),aa(A1,fun(B,fun(C1,bool)),C,A3),B2)) )
     => member(C1,Z1,aa(product_prod(A1,B),fun(C1,bool),aa(fun(A1,fun(B,fun(C1,bool))),fun(product_prod(A1,B),fun(C1,bool)),product_prod_case(A1,B,fun(C1,bool)),C),P)) ) ).

tff(fact_50_splitI2_H,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,Xa: C1,C: fun(A1,fun(B,fun(C1,bool))),P: product_prod(A1,B)] :
      ( ! [A3: A1,B2: B] :
          ( ( aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),A3),B2) = P )
         => pp(aa(C1,bool,aa(B,fun(C1,bool),aa(A1,fun(B,fun(C1,bool)),C,A3),B2),Xa)) )
     => pp(aa(C1,bool,aa(product_prod(A1,B),fun(C1,bool),aa(fun(A1,fun(B,fun(C1,bool))),fun(product_prod(A1,B),fun(C1,bool)),product_prod_case(A1,B,fun(C1,bool)),C),P),Xa)) ) ).

tff(fact_51_mem__splitE,axiom,
    ! [B: $tType,A1: $tType,C1: $tType,P: product_prod(B,C1),C: fun(B,fun(C1,fun(A1,bool))),Z1: A1] :
      ( member(A1,Z1,aa(product_prod(B,C1),fun(A1,bool),aa(fun(B,fun(C1,fun(A1,bool))),fun(product_prod(B,C1),fun(A1,bool)),product_prod_case(B,C1,fun(A1,bool)),C),P))
     => ~ ! [X1: B,Y1: C1] :
            ( ( P = aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),X1),Y1) )
           => ~ member(A1,Z1,aa(C1,fun(A1,bool),aa(B,fun(C1,fun(A1,bool)),C,X1),Y1)) ) ) ).

tff(fact_52_splitE_H,axiom,
    ! [B: $tType,A1: $tType,C1: $tType,Z1: C1,P: product_prod(A1,B),C: fun(A1,fun(B,fun(C1,bool)))] :
      ( pp(aa(C1,bool,aa(product_prod(A1,B),fun(C1,bool),aa(fun(A1,fun(B,fun(C1,bool))),fun(product_prod(A1,B),fun(C1,bool)),product_prod_case(A1,B,fun(C1,bool)),C),P),Z1))
     => ~ ! [X1: A1,Y1: B] :
            ( ( P = aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y1) )
           => ~ pp(aa(C1,bool,aa(B,fun(C1,bool),aa(A1,fun(B,fun(C1,bool)),C,X1),Y1),Z1)) ) ) ).

tff(fact_53_splitE2,axiom,
    ! [B: $tType,A1: $tType,C1: $tType,Z1: product_prod(B,C1),P1: fun(B,fun(C1,A1)),Q1: fun(A1,bool)] :
      ( pp(aa(A1,bool,Q1,aa(product_prod(B,C1),A1,aa(fun(B,fun(C1,A1)),fun(product_prod(B,C1),A1),product_prod_case(B,C1,A1),P1),Z1)))
     => ~ ! [X1: B,Y1: C1] :
            ( ( Z1 = aa(C1,product_prod(B,C1),aa(B,fun(C1,product_prod(B,C1)),product_Pair(B,C1),X1),Y1) )
           => ~ pp(aa(A1,bool,Q1,aa(C1,A1,aa(B,fun(C1,A1),P1,X1),Y1))) ) ) ).

tff(fact_54_split__cong,axiom,
    ! [C1: $tType,B: $tType,A1: $tType,P: product_prod(A1,B),G: fun(A1,fun(B,C1)),F: fun(A1,fun(B,C1)),Q: product_prod(A1,B)] :
      ( ! [X1: A1,Y1: B] :
          ( ( aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y1) = Q )
         => ( aa(B,C1,aa(A1,fun(B,C1),F,X1),Y1) = aa(B,C1,aa(A1,fun(B,C1),G,X1),Y1) ) )
     => ( ( P = Q )
       => ( aa(product_prod(A1,B),C1,aa(fun(A1,fun(B,C1)),fun(product_prod(A1,B),C1),product_prod_case(A1,B,C1),F),P) = aa(product_prod(A1,B),C1,aa(fun(A1,fun(B,C1)),fun(product_prod(A1,B),C1),product_prod_case(A1,B,C1),G),Q) ) ) ) ).

tff(fact_55_apfst__convE,axiom,
    ! [C1: $tType,A1: $tType,B: $tType,P: product_prod(C1,B),F: fun(C1,A1),Q: product_prod(A1,B)] :
      ( ( Q = product_apfst(C1,A1,B,F,P) )
     => ~ ! [X1: C1,Y1: B] :
            ( ( P = aa(B,product_prod(C1,B),aa(C1,fun(B,product_prod(C1,B)),product_Pair(C1,B),X1),Y1) )
           => ( Q != aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),aa(C1,A1,F,X1)),Y1) ) ) ) ).

tff(fact_56_scomp__apply,axiom,
    ! [A1: $tType,C1: $tType,D: $tType,B: $tType,Xa: B,G: fun(C1,fun(D,A1)),F: fun(B,product_prod(C1,D))] : ( aa(B,A1,product_scomp(B,C1,D,A1,F,G),Xa) = aa(product_prod(C1,D),A1,aa(fun(C1,fun(D,A1)),fun(product_prod(C1,D),A1),product_prod_case(C1,D,A1),G),aa(B,product_prod(C1,D),F,Xa)) ) ).

tff(fact_57_scomp__def,axiom,
    ! [B: $tType,C1: $tType,D: $tType,A1: $tType,G: fun(C1,fun(D,B)),F: fun(A1,product_prod(C1,D)),X: A1] : ( aa(A1,B,product_scomp(A1,C1,D,B,F,G),X) = aa(product_prod(C1,D),B,aa(fun(C1,fun(D,B)),fun(product_prod(C1,D),B),product_prod_case(C1,D,B),G),aa(A1,product_prod(C1,D),F,X)) ) ).

tff(fact_58_trans__Id__on,axiom,
    ! [A1: $tType,A: fun(A1,bool)] : trans(A1,id_on(A1,A)) ).

tff(fact_59_Id__on__eqI,axiom,
    ! [A1: $tType,A: fun(A1,bool),B1: A1,A2: A1] :
      ( ( A2 = B1 )
     => ( member(A1,A2,A)
       => member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),A2),B1),id_on(A1,A)) ) ) ).

tff(fact_60_Id__on__iff,axiom,
    ! [A1: $tType,A: fun(A1,bool),Ya: A1,Xa: A1] :
      ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),Xa),Ya),id_on(A1,A))
    <=> ( ( Xa = Ya )
        & member(A1,Xa,A) ) ) ).

tff(fact_61_scomp__Pair,axiom,
    ! [C1: $tType,B: $tType,A1: $tType,Xa: fun(A1,product_prod(B,C1))] : ( product_scomp(A1,B,C1,product_prod(B,C1),Xa,product_Pair(B,C1)) = Xa ) ).

tff(fact_62_Pair__scomp,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,F: fun(C1,fun(A1,B)),Xa: C1] : ( product_scomp(A1,C1,A1,B,aa(C1,fun(A1,product_prod(C1,A1)),product_Pair(C1,A1),Xa),F) = aa(C1,fun(A1,B),F,Xa) ) ).

tff(fact_63_Id__onE,axiom,
    ! [A1: $tType,A: fun(A1,bool),C: product_prod(A1,A1)] :
      ( member(product_prod(A1,A1),C,id_on(A1,A))
     => ~ ! [X1: A1] :
            ( member(A1,X1,A)
           => ( C != aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X1),X1) ) ) ) ).

tff(fact_64_single__valued__Id__on,axiom,
    ! [A1: $tType,A: fun(A1,bool)] : single_valued(A1,A1,id_on(A1,A)) ).

tff(fact_65_antisym__Id__on,axiom,
    ! [A1: $tType,A: fun(A1,bool)] : antisym(A1,id_on(A1,A)) ).

tff(fact_66_antisym__def,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool)] :
      ( antisym(A1,R)
    <=> ! [X2: A1,Y2: A1] :
          ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X2),Y2),R)
         => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),Y2),X2),R)
           => ( X2 = Y2 ) ) ) ) ).

tff(fact_67_antisymD,axiom,
    ! [A1: $tType,B1: A1,A2: A1,R: fun(product_prod(A1,A1),bool)] :
      ( antisym(A1,R)
     => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),A2),B1),R)
       => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),B1),A2),R)
         => ( A2 = B1 ) ) ) ) ).

tff(fact_68_single__valued__def,axiom,
    ! [A1: $tType,B: $tType,R: fun(product_prod(A1,B),bool)] :
      ( single_valued(A1,B,R)
    <=> ! [X2: A1,Y2: B] :
          ( member(product_prod(A1,B),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X2),Y2),R)
         => ! [Z2: B] :
              ( member(product_prod(A1,B),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X2),Z2),R)
             => ( Y2 = Z2 ) ) ) ) ).

tff(fact_69_single__valuedD,axiom,
    ! [A1: $tType,B: $tType,Z1: B,Ya: B,Xa: A1,R: fun(product_prod(A1,B),bool)] :
      ( single_valued(A1,B,R)
     => ( member(product_prod(A1,B),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Xa),Ya),R)
       => ( member(product_prod(A1,B),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),Xa),Z1),R)
         => ( Ya = Z1 ) ) ) ) ).

tff(fact_70_single__valuedI,axiom,
    ! [B: $tType,A1: $tType,R: fun(product_prod(A1,B),bool)] :
      ( ! [X1: A1,Y1: B] :
          ( member(product_prod(A1,B),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Y1),R)
         => ! [Z: B] :
              ( member(product_prod(A1,B),aa(B,product_prod(A1,B),aa(A1,fun(B,product_prod(A1,B)),product_Pair(A1,B),X1),Z),R)
             => ( Y1 = Z ) ) )
     => single_valued(A1,B,R) ) ).

tff(fact_71_antisymI,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool)] :
      ( ! [X1: A1,Y1: A1] :
          ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),X1),Y1),R)
         => ( member(product_prod(A1,A1),aa(A1,product_prod(A1,A1),aa(A1,fun(A1,product_prod(A1,A1)),product_Pair(A1,A1),Y1),X1),R)
           => ( X1 = Y1 ) ) )
     => antisym(A1,R) ) ).

tff(fact_72_ext,axiom,
    ! [B: $tType,A1: $tType,G: fun(A1,B),F: fun(A1,B)] :
      ( ! [X1: A1] : ( aa(A1,B,F,X1) = aa(A1,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_73_mem__def,axiom,
    ! [A1: $tType,A: fun(A1,bool),Xa: A1] :
      ( member(A1,Xa,A)
    <=> pp(aa(A1,bool,A,Xa)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (7)
tff(conj_0,hypothesis,
    x != y ).

tff(conj_1,hypothesis,
    trans(arrow_411405190le_alt,l) ).

tff(conj_2,hypothesis,
    ! [X: arrow_411405190le_alt] : ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),X),l) ).

tff(conj_3,hypothesis,
    ! [X: arrow_411405190le_alt,Y: arrow_411405190le_alt] :
      ( ( X != Y )
     => ( member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),X),Y),l)
        | member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),Y),X),l) ) ) ).

tff(conj_4,hypothesis,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),y),x),l) ).

tff(conj_5,hypothesis,
    member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),x),y),l) ).

tff(conj_6,conjecture,
    $false ).

%------------------------------------------------------------------------------
