%------------------------------------------------------------------------------
% File     : SCT173_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 41
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_41 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  136 (  53 unt;  33 typ;   0 def)
%            Number of atoms       :  171 (  95 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   97 (  29   ~;   2   |;   4   &)
%                                         (  12 <=>;  50  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   35 (  20   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-6 aty)
%            Number of functors    :   25 (  25 usr;   6 con; 0-6 aty)
%            Number of variables   :  602 ( 549   !;   6   ?; 602   :)
%                                         (  47  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:13:55
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (29)
tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_c_Arrow__Order__Mirabelle__qkbtqzkjxu_OLin,type,
    arrow_1985332922le_Lin: fun(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),bool) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_FunDef_Oin__rel,type,
    in_rel: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,B),bool) * A * B ) > $o ) ).

tff(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Nitpick_Orefl_H,type,
    refl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > $o ) ).

tff(sy_c_Order__Relation_Ostrict__linear__order__on,type,
    order_215145569der_on: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(product_prod(A,A),bool),bool) ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,product_prod(A,B))) ).

tff(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A: $tType,C: $tType,B: $tType] : ( ( fun(A,C) * product_prod(A,B) ) > product_prod(C,B) ) ).

tff(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * product_prod(A,B) ) > product_prod(A,C) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(product_prod(A,B),C) > fun(A,fun(B,C)) ) ).

tff(sy_c_Product__Type_Ofst,type,
    product_fst: 
      !>[A: $tType,B: $tType] : ( product_prod(A,B) > A ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(product_prod(A,B),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A: $tType,B: $tType,T2: $tType] : fun(fun(A,fun(B,T2)),fun(product_prod(A,B),T2)) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T2: $tType] : ( ( fun(A,fun(B,T2)) * product_prod(A,B) ) > T2 ) ).

tff(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A: $tType,B: $tType,C: $tType,D: $tType] : ( ( fun(A,product_prod(B,C)) * fun(B,fun(C,D)) ) > fun(A,D) ) ).

tff(sy_c_Product__Type_Osnd,type,
    product_snd: 
      !>[A: $tType,B: $tType] : ( product_prod(A,B) > B ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,A),bool) * fun(product_prod(B,B),bool) ) > fun(product_prod(product_prod(A,B),product_prod(A,B)),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_L,type,
    l: fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool) ).

tff(sy_v_x,type,
    x: arrow_411405190le_alt ).

tff(sy_v_y,type,
    y: arrow_411405190le_alt ).

%----Relevant facts (93)
tff(fact_0_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ! [A6: A,B5: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B5))) ) ).

tff(fact_1_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B4: B,A5: A,B1: B,A1: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B4) )
    <=> ( ( A1 = A5 )
        & ( B1 = B4 ) ) ) ).

tff(fact_2_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B6: B,A7: A,B2: B,A2: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A7),B6) )
     => ~ ( ( A2 = A7 )
         => ( B2 != B6 ) ) ) ).

tff(fact_3_in__rel__def,axiom,
    ! [B: $tType,A: $tType,Ya: B,Xa: A,R: fun(product_prod(A,B),bool)] :
      ( in_rel(A,B,R,Xa,Ya)
    <=> member(product_prod(A,B),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Xa),Ya),R) ) ).

tff(fact_4_Lin__def,axiom,
    arrow_1985332922le_Lin = collect(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),order_215145569der_on(arrow_411405190le_alt,top_top(fun(arrow_411405190le_alt,bool)))) ).

tff(fact_5_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ? [A6: A,B5: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B5))) ) ).

tff(fact_6_Nitpick_Orefl_H__def,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] :
      ( refl(A,R1)
    <=> ! [X4: A] : member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),X4),X4),R1) ) ).

tff(fact_7_in__lex__prod,axiom,
    ! [A: $tType,B: $tType,S: fun(product_prod(B,B),bool),R1: fun(product_prod(A,A),bool),B4: B,A5: A,B1: B,A1: A] :
      ( member(product_prod(product_prod(A,B),product_prod(A,B)),aa(product_prod(A,B),product_prod(product_prod(A,B),product_prod(A,B)),aa(product_prod(A,B),fun(product_prod(A,B),product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B4)),lex_prod(A,B,R1,S))
    <=> ( member(product_prod(A,A),aa(A,product_prod(A,A),aa(A,fun(A,product_prod(A,A)),product_Pair(A,A),A1),A5),R1)
        | ( ( A1 = A5 )
          & member(product_prod(B,B),aa(B,product_prod(B,B),aa(B,fun(B,product_prod(B,B)),product_Pair(B,B),B1),B4),S) ) ) ) ).

tff(fact_8_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,A1: B,F11: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F11,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A1),B1)) = aa(C,A,aa(B,fun(C,A),F11,A1),B1) ) ).

tff(fact_9_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool)] :
      ( ! [A4: A,B3: B,C2: C,D2: D,E1: E,F3: F2] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A4),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B3),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D2),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),bool,P1,Xa)) ) ).

tff(fact_10_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F2: $tType,Y1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))] :
      ~ ! [A4: A,B3: B,C2: C,D2: D,E1: E,F3: F2] : ( Y1 != aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),A4),aa(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F2))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F2))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F2)))),B3),aa(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2))),aa(C,fun(product_prod(D,product_prod(E,F2)),product_prod(C,product_prod(D,product_prod(E,F2)))),product_Pair(C,product_prod(D,product_prod(E,F2))),C2),aa(product_prod(E,F2),product_prod(D,product_prod(E,F2)),aa(D,fun(product_prod(E,F2),product_prod(D,product_prod(E,F2))),product_Pair(D,product_prod(E,F2)),D2),aa(F2,product_prod(E,F2),aa(E,fun(F2,product_prod(E,F2)),product_Pair(E,F2),E1),F3))))) ) ).

tff(fact_11_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A4: A,B3: B,C2: C,D2: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A4),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B3),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D2),E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,Xa)) ) ).

tff(fact_12_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A4: A,B3: B,C2: C,D2: D,E1: E] : ( Y1 != aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A4),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B3),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D2),E1)))) ) ).

tff(fact_13_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y1: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A4: A,B3: B,C2: C,D2: D] : ( Y1 != aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A4),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B3),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D2))) ) ).

tff(fact_14_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,D))),P1: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A4: A,B3: B,C2: C,D2: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A4),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B3),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D2)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,Xa)) ) ).

tff(fact_15_top1I,axiom,
    ! [A: $tType,Xa: A] : pp(aa(A,bool,top_top(fun(A,bool)),Xa)) ).

tff(fact_16_UNIV__I,axiom,
    ! [A: $tType,Xa: A] : member(A,Xa,top_top(fun(A,bool))) ).

tff(fact_17_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,Xa: A] : member(A,Xa,top_top(fun(A,bool))) ).

tff(fact_18_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y1: product_prod(A,product_prod(B,C))] :
      ~ ! [A4: A,B3: B,C2: C] : ( Y1 != aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A4),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B3),C2)) ) ).

tff(fact_19_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,C)),P1: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A4: A,B3: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P1,aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A4),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B3),C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P1,Xa)) ) ).

tff(fact_20_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [Xa: B] : ( aa(B,A,top_top(fun(B,A)),Xa) = top_top(A) ) ) ).

tff(fact_21_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_22_UNIV__eq__I,axiom,
    ! [A: $tType,A3: fun(A,bool)] :
      ( ! [X2: A] : member(A,X2,A3)
     => ( top_top(fun(A,bool)) = A3 ) ) ).

tff(fact_23_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X2: A] : member(A,X2,top_top(fun(A,bool))) ).

tff(fact_24_PairE,axiom,
    ! [A: $tType,B: $tType,P3: product_prod(A,B)] :
      ~ ! [X2: A,Y: B] : ( P3 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y) ) ).

tff(fact_25_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y1: product_prod(A,B)] :
      ~ ! [A4: A,B3: B] : ( Y1 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3) ) ).

tff(fact_26_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,A1: B,C1: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),produc1605651328_split(B,C,A),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A1),B1)) = aa(C,A,aa(B,fun(C,A),C1,A1),B1) ) ).

tff(fact_27_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,B1: C,A1: B,F: fun(product_prod(B,C),A)] : ( aa(C,A,aa(B,fun(C,A),product_curry(B,C,A,F),A1),B1) = aa(product_prod(B,C),A,F,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A1),B1)) ) ).

tff(fact_28_curryI,axiom,
    ! [A: $tType,B: $tType,B1: B,A1: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1)))
     => pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A1),B1)) ) ).

tff(fact_29_curryE,axiom,
    ! [A: $tType,B: $tType,B1: B,A1: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A1),B1))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1))) ) ).

tff(fact_30_curryD,axiom,
    ! [A: $tType,B: $tType,B1: B,A1: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_curry(A,B,bool,F),A1),B1))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1))) ) ).

tff(fact_31_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Ya: B,Xa: B,F: fun(B,A),R1: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R1,F,Xa,Ya)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R1,aa(B,A,F,Xa)),aa(B,A,F,Ya))) ) ).

tff(fact_32_internal__split__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] : ( produc1605651328_split(A,B,C) = product_prod_case(A,B,C) ) ).

tff(fact_33_apsnd__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ya: C,Xa: A,F: fun(C,B)] : ( product_apsnd(C,B,A,F,aa(C,product_prod(A,C),aa(A,fun(C,product_prod(A,C)),product_Pair(A,C),Xa),Ya)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Xa),aa(C,B,F,Ya)) ) ).

tff(fact_34_apfst__conv,axiom,
    ! [C: $tType,A: $tType,B: $tType,Ya: B,Xa: C,F: fun(C,A)] : ( product_apfst(C,A,B,F,aa(B,product_prod(C,B),aa(C,fun(B,product_prod(C,B)),product_Pair(C,B),Xa),Ya)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C,A,F,Xa)),Ya) ) ).

tff(fact_35_surj__pair,axiom,
    ! [A: $tType,B: $tType,P3: product_prod(A,B)] :
    ? [X2: A,Y: B] : ( P3 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y) ) ).

tff(fact_36_Pair__scomp,axiom,
    ! [A: $tType,B: $tType,C: $tType,F: fun(C,fun(A,B)),Xa: C] : ( product_scomp(A,C,A,B,aa(C,fun(A,product_prod(C,A)),product_Pair(C,A),Xa),F) = aa(C,fun(A,B),F,Xa) ) ).

tff(fact_37_splitI,axiom,
    ! [A: $tType,B: $tType,B1: B,A1: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F,A1),B1))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1))) ) ).

tff(fact_38_prod__caseI,axiom,
    ! [A: $tType,B: $tType,B1: B,A1: A,F11: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),F11,A1),B1))
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F11),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1))) ) ).

tff(fact_39_mem__splitI,axiom,
    ! [A: $tType,B: $tType,C: $tType,B1: C,A1: B,C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,A1),B1))
     => member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A1),B1))) ) ).

tff(fact_40_split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,A1: B,F: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A1),B1)) = aa(C,A,aa(B,fun(C,A),F,A1),B1) ) ).

tff(fact_41_scomp__apply,axiom,
    ! [A: $tType,C: $tType,D: $tType,B: $tType,Xa: B,G: fun(C,fun(D,A)),F: fun(B,product_prod(C,D))] : ( aa(B,A,product_scomp(B,C,D,A,F,G),Xa) = aa(product_prod(C,D),A,aa(fun(C,fun(D,A)),fun(product_prod(C,D),A),product_prod_case(C,D,A),G),aa(B,product_prod(C,D),F,Xa)) ) ).

tff(fact_42_scomp__def,axiom,
    ! [B: $tType,C: $tType,D: $tType,A: $tType,G: fun(C,fun(D,B)),F: fun(A,product_prod(C,D)),X: A] : ( aa(A,B,product_scomp(A,C,D,B,F,G),X) = aa(product_prod(C,D),B,aa(fun(C,fun(D,B)),fun(product_prod(C,D),B),product_prod_case(C,D,B),G),aa(A,product_prod(C,D),F,X)) ) ).

tff(fact_43_apsnd__apfst__commute,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,P2: product_prod(D,C),G: fun(D,A),F: fun(C,B)] : ( product_apsnd(C,B,A,F,product_apfst(D,A,C,G,P2)) = product_apfst(D,A,B,G,product_apsnd(C,B,D,F,P2)) ) ).

tff(fact_44_split__weak__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,C)),Q2: product_prod(A,B),P2: product_prod(A,B)] :
      ( ( P2 = Q2 )
     => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),P2) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),Q2) ) ) ).

tff(fact_45_splitD,axiom,
    ! [A: $tType,B: $tType,B1: B,A1: A,F: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),F),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1)))
     => pp(aa(B,bool,aa(A,fun(B,bool),F,A1),B1)) ) ).

tff(fact_46_splitD_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,C1: C,B1: B,A1: A,R: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),R),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1)),C1))
     => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),R,A1),B1),C1)) ) ).

tff(fact_47_prod_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,A1: B,F11: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F11),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),A1),B1)) = aa(C,A,aa(B,fun(C,A),F11,A1),B1) ) ).

tff(fact_48_scomp__Pair,axiom,
    ! [C: $tType,B: $tType,A: $tType,Xa: fun(A,product_prod(B,C))] : ( product_scomp(A,B,C,product_prod(B,C),Xa,product_Pair(B,C)) = Xa ) ).

tff(fact_49_curry__split,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(A,fun(B,C))] : ( product_curry(A,B,C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F)) = F ) ).

tff(fact_50_split__curry,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: fun(product_prod(A,B),C)] : ( aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),product_curry(A,B,C,F)) = F ) ).

tff(fact_51_splitE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B),C1: fun(A,fun(B,bool))] :
      ( pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P2))
     => ~ ! [X2: A,Y: B] :
            ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y) )
           => ~ pp(aa(B,bool,aa(A,fun(B,bool),C1,X2),Y)) ) ) ).

tff(fact_52_splitI2,axiom,
    ! [B: $tType,A: $tType,C1: fun(A,fun(B,bool)),P2: product_prod(A,B)] :
      ( ! [A4: A,B3: B] :
          ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3) )
         => pp(aa(B,bool,aa(A,fun(B,bool),C1,A4),B3)) )
     => pp(aa(product_prod(A,B),bool,aa(fun(A,fun(B,bool)),fun(product_prod(A,B),bool),product_prod_case(A,B,bool),C1),P2)) ) ).

tff(fact_53_mem__splitI2,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,fun(C,bool))),Z: C,P2: product_prod(A,B)] :
      ( ! [A4: A,B3: B] :
          ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3) )
         => member(C,Z,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A4),B3)) )
     => member(C,Z,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P2)) ) ).

tff(fact_54_splitI2_H,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xa: C,C1: fun(A,fun(B,fun(C,bool))),P2: product_prod(A,B)] :
      ( ! [A4: A,B3: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3) = P2 )
         => pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,A4),B3),Xa)) )
     => pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P2),Xa)) ) ).

tff(fact_55_mem__splitE,axiom,
    ! [B: $tType,A: $tType,C: $tType,P2: product_prod(B,C),C1: fun(B,fun(C,fun(A,bool))),Z: A] :
      ( member(A,Z,aa(product_prod(B,C),fun(A,bool),aa(fun(B,fun(C,fun(A,bool))),fun(product_prod(B,C),fun(A,bool)),product_prod_case(B,C,fun(A,bool)),C1),P2))
     => ~ ! [X2: B,Y: C] :
            ( ( P2 = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X2),Y) )
           => ~ member(A,Z,aa(C,fun(A,bool),aa(B,fun(C,fun(A,bool)),C1,X2),Y)) ) ) ).

tff(fact_56_splitE_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: C,P2: product_prod(A,B),C1: fun(A,fun(B,fun(C,bool)))] :
      ( pp(aa(C,bool,aa(product_prod(A,B),fun(C,bool),aa(fun(A,fun(B,fun(C,bool))),fun(product_prod(A,B),fun(C,bool)),product_prod_case(A,B,fun(C,bool)),C1),P2),Z))
     => ~ ! [X2: A,Y: B] :
            ( ( P2 = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y) )
           => ~ pp(aa(C,bool,aa(B,fun(C,bool),aa(A,fun(B,fun(C,bool)),C1,X2),Y),Z)) ) ) ).

tff(fact_57_splitE2,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: product_prod(B,C),P1: fun(B,fun(C,A)),Q1: fun(A,bool)] :
      ( pp(aa(A,bool,Q1,aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),P1),Z)))
     => ~ ! [X2: B,Y: C] :
            ( ( Z = aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),X2),Y) )
           => ~ pp(aa(A,bool,Q1,aa(C,A,aa(B,fun(C,A),P1,X2),Y))) ) ) ).

tff(fact_58_split__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,P2: product_prod(A,B),G: fun(A,fun(B,C)),F: fun(A,fun(B,C)),Q2: product_prod(A,B)] :
      ( ! [X2: A,Y: B] :
          ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Y) = Q2 )
         => ( aa(B,C,aa(A,fun(B,C),F,X2),Y) = aa(B,C,aa(A,fun(B,C),G,X2),Y) ) )
     => ( ( P2 = Q2 )
       => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),F),P2) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),G),Q2) ) ) ) ).

tff(fact_59_apfst__convE,axiom,
    ! [C: $tType,A: $tType,B: $tType,P2: product_prod(C,B),F: fun(C,A),Q2: product_prod(A,B)] :
      ( ( Q2 = product_apfst(C,A,B,F,P2) )
     => ~ ! [X2: C,Y: B] :
            ( ( P2 = aa(B,product_prod(C,B),aa(C,fun(B,product_prod(C,B)),product_Pair(C,B),X2),Y) )
           => ( Q2 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C,A,F,X2)),Y) ) ) ) ).

tff(fact_60_apfst__apsnd,axiom,
    ! [A: $tType,B: $tType,D: $tType,C: $tType,Xa: product_prod(C,D),G: fun(D,B),F: fun(C,A)] : ( product_apfst(C,A,B,F,product_apsnd(D,B,C,G,Xa)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(C,A,F,product_fst(C,D,Xa))),aa(D,B,G,product_snd(C,D,Xa))) ) ).

tff(fact_61_apsnd__apfst,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Xa: product_prod(D,C),G: fun(D,A),F: fun(C,B)] : ( product_apsnd(C,B,A,F,product_apfst(D,A,C,G,Xa)) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),aa(D,A,G,product_fst(D,C,Xa))),aa(C,B,F,product_snd(D,C,Xa))) ) ).

tff(fact_62_apfst__eq__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,G: fun(C,A),Xa: product_prod(C,B),F: fun(C,A)] :
      ( ( product_apfst(C,A,B,F,Xa) = product_apfst(C,A,B,G,Xa) )
    <=> ( aa(C,A,F,product_fst(C,B,Xa)) = aa(C,A,G,product_fst(C,B,Xa)) ) ) ).

tff(fact_63_fst__apfst,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xa: product_prod(C,B),F: fun(C,A)] : ( product_fst(A,B,product_apfst(C,A,B,F,Xa)) = aa(C,A,F,product_fst(C,B,Xa)) ) ).

tff(fact_64_fst__apsnd,axiom,
    ! [B: $tType,C: $tType,A: $tType,Xa: product_prod(A,C),F: fun(C,B)] : ( product_fst(A,B,product_apsnd(C,B,A,F,Xa)) = product_fst(A,C,Xa) ) ).

tff(fact_65_apsnd__eq__conv,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: fun(C,B),Xa: product_prod(A,C),F: fun(C,B)] :
      ( ( product_apsnd(C,B,A,F,Xa) = product_apsnd(C,B,A,G,Xa) )
    <=> ( aa(C,B,F,product_snd(A,C,Xa)) = aa(C,B,G,product_snd(A,C,Xa)) ) ) ).

tff(fact_66_snd__apsnd,axiom,
    ! [A: $tType,C: $tType,B: $tType,Xa: product_prod(B,C),F: fun(C,A)] : ( product_snd(B,A,product_apsnd(C,A,B,F,Xa)) = aa(C,A,F,product_snd(B,C,Xa)) ) ).

tff(fact_67_snd__apfst,axiom,
    ! [B: $tType,A: $tType,C: $tType,Xa: product_prod(C,A),F: fun(C,B)] : ( product_snd(B,A,product_apfst(C,B,A,F,Xa)) = product_snd(C,A,Xa) ) ).

tff(fact_68_prod__eqI,axiom,
    ! [B: $tType,A: $tType,Q3: product_prod(A,B),P3: product_prod(A,B)] :
      ( ( product_fst(A,B,P3) = product_fst(A,B,Q3) )
     => ( ( product_snd(A,B,P3) = product_snd(A,B,Q3) )
       => ( P3 = Q3 ) ) ) ).

tff(fact_69_pair__collapse,axiom,
    ! [B: $tType,A: $tType,P3: product_prod(A,B)] : ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),product_fst(A,B,P3)),product_snd(A,B,P3)) = P3 ) ).

tff(fact_70_prod__eq__iff,axiom,
    ! [B: $tType,A: $tType,T1: product_prod(A,B),S: product_prod(A,B)] :
      ( ( S = T1 )
    <=> ( ( product_fst(A,B,S) = product_fst(A,B,T1) )
        & ( product_snd(A,B,S) = product_snd(A,B,T1) ) ) ) ).

tff(fact_71_surjective__pairing,axiom,
    ! [B: $tType,A: $tType,T: product_prod(A,B)] : ( T = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),product_fst(A,B,T)),product_snd(A,B,T)) ) ).

tff(fact_72_snd__conv,axiom,
    ! [B: $tType,A: $tType,B2: A,A2: B] : ( product_snd(B,A,aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),A2),B2)) = B2 ) ).

tff(fact_73_snd__eqD,axiom,
    ! [B: $tType,A: $tType,A2: A,Y1: A,X3: B] :
      ( ( product_snd(B,A,aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),X3),Y1)) = A2 )
     => ( Y1 = A2 ) ) ).

tff(fact_74_fst__conv,axiom,
    ! [B: $tType,A: $tType,B2: B,A2: A] : ( product_fst(A,B,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2)) = A2 ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),Xa: A] :
      ( member(A,Xa,A3)
    <=> pp(aa(A,bool,A3,Xa)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_fst__eqD,axiom,
    ! [B: $tType,A: $tType,A2: A,Y1: B,X3: A] :
      ( ( product_fst(A,B,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X3),Y1)) = A2 )
     => ( X3 = A2 ) ) ).

tff(fact_79_prod__case__beta,axiom,
    ! [A: $tType,C: $tType,B: $tType,P2: product_prod(B,C),F: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F),P2) = aa(C,A,aa(B,fun(C,A),F,product_fst(B,C,P2)),product_snd(B,C,P2)) ) ).

tff(fact_80_exI__realizer,axiom,
    ! [B: $tType,A: $tType,Xa: B,Ya: A,P1: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),P1,Ya),Xa))
     => pp(aa(B,bool,aa(A,fun(B,bool),P1,product_snd(B,A,aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),Xa),Ya))),product_fst(B,A,aa(A,product_prod(B,A),aa(B,fun(A,product_prod(B,A)),product_Pair(B,A),Xa),Ya)))) ) ).

tff(fact_81_conjI__realizer,axiom,
    ! [A: $tType,B: $tType,Q2: B,Q1: fun(B,bool),P2: A,P1: fun(A,bool)] :
      ( pp(aa(A,bool,P1,P2))
     => ( pp(aa(B,bool,Q1,Q2))
       => ( pp(aa(A,bool,P1,product_fst(A,B,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),P2),Q2))))
          & pp(aa(B,bool,Q1,product_snd(A,B,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),P2),Q2)))) ) ) ) ).

tff(fact_82_exE__realizer_H,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(B,A),P1: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),P1,product_snd(B,A,P2)),product_fst(B,A,P2)))
     => ~ ! [X2: B,Y: A] : ~ pp(aa(B,bool,aa(A,fun(B,bool),P1,Y),X2)) ) ).

tff(fact_83_split__comp,axiom,
    ! [D: $tType,A: $tType,C: $tType,B: $tType,Xa: product_prod(B,C),G: fun(B,D),F: fun(D,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),comp(D,fun(C,A),B,F,G)),Xa) = aa(C,A,aa(D,fun(C,A),F,aa(B,D,G,product_fst(B,C,Xa))),product_snd(B,C,Xa)) ) ).

tff(fact_84_o__eq__dest__lhs,axiom,
    ! [C: $tType,B: $tType,A: $tType,V: A,C1: fun(A,B),B1: fun(A,C),A1: fun(C,B)] :
      ( ( comp(C,B,A,A1,B1) = C1 )
     => ( aa(C,B,A1,aa(A,C,B1,V)) = aa(A,B,C1,V) ) ) ).

tff(fact_85_comp__cong,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,E: $tType,X1: E,G1: fun(E,D),F1: fun(D,A),Xa: C,G: fun(C,B),F: fun(B,A)] :
      ( ( aa(B,A,F,aa(C,B,G,Xa)) = aa(D,A,F1,aa(E,D,G1,X1)) )
     => ( aa(C,A,comp(B,A,C,F,G),Xa) = aa(E,A,comp(D,A,E,F1,G1),X1) ) ) ).

tff(fact_86_apfst__compose,axiom,
    ! [C: $tType,A: $tType,B: $tType,D: $tType,Xa: product_prod(D,B),G: fun(D,C),F: fun(C,A)] : ( product_apfst(C,A,B,F,product_apfst(D,C,B,G,Xa)) = product_apfst(D,A,B,comp(C,A,D,F,G),Xa) ) ).

tff(fact_87_apsnd__compose,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,Xa: product_prod(A,D),G: fun(D,C),F: fun(C,B)] : ( product_apsnd(C,B,A,F,product_apsnd(D,C,A,G,Xa)) = product_apsnd(D,B,A,comp(C,B,D,F,G),Xa) ) ).

tff(fact_88_o__apply,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xa: C,G: fun(C,B),F: fun(B,A)] : ( aa(C,A,comp(B,A,C,F,G),Xa) = aa(B,A,F,aa(C,B,G,Xa)) ) ).

tff(fact_89_o__def,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: fun(A,C),F: fun(C,B),X: A] : ( aa(A,B,comp(C,B,A,F,G),X) = aa(C,B,F,aa(A,C,G,X)) ) ).

tff(fact_90_o__eq__elim,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,D1: fun(A,D),C1: fun(D,B),B1: fun(A,C),A1: fun(C,B)] :
      ( ( comp(C,B,A,A1,B1) = comp(D,B,A,C1,D1) )
     => ! [V1: A] : ( aa(C,B,A1,aa(A,C,B1,V1)) = aa(D,B,C1,aa(A,D,D1,V1)) ) ) ).

tff(fact_91_o__eq__dest,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,V: A,D1: fun(A,D),C1: fun(D,B),B1: fun(A,C),A1: fun(C,B)] :
      ( ( comp(C,B,A,A1,B1) = comp(D,B,A,C1,D1) )
     => ( aa(C,B,A1,aa(A,C,B1,V)) = aa(D,B,C1,aa(A,D,D1,V)) ) ) ).

tff(fact_92_o__assoc,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,H: fun(A,D),G: fun(D,C),F: fun(C,B)] : ( comp(C,B,A,F,comp(D,C,A,G,H)) = comp(D,B,A,comp(C,B,D,F,G),H) ) ).

%----Arities (2)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    member(fun(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),bool),l,arrow_1985332922le_Lin) ).

tff(conj_1,hypothesis,
    x != y ).

tff(conj_2,conjecture,
    ( ~ member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),x),y),l)
  <=> member(product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt),aa(arrow_411405190le_alt,fun(arrow_411405190le_alt,product_prod(arrow_411405190le_alt,arrow_411405190le_alt)),product_Pair(arrow_411405190le_alt,arrow_411405190le_alt),y),x),l) ) ).

%------------------------------------------------------------------------------
