%------------------------------------------------------------------------------
% File     : SCT172_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Social Choice Theory
% Problem  : Arrow's Impossibility Theorem line 32
% Version  : Especial.
% English  : Formalization of two proofs of Arrow's impossibility theorem. One
%            formalization is based on utility functions, the other one on
%            strict partial orders.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : arrow_32 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.5.0, 0.67 v7.4.0, 0.50 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  135 (  40 unt;  31 typ;   0 def)
%            Number of atoms       :  209 ( 157 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  141 (  36   ~;   3   |;  22   &)
%                                         (  32 <=>;  48  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   42 (  24   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-3 aty)
%            Number of functors    :   23 (  23 usr;   3 con; 0-5 aty)
%            Number of variables   :  362 ( 323   !;  10   ?; 362   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:13:53
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Arrow__Order__Mirabelle__qkbtqzkjxu_Oalt,type,
    arrow_411405190le_alt: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (27)
tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Obutlast,type,
    butlast: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_OdropWhile,type,
    dropWhile: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Ohd,type,
    hd: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olast,type,
    last: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_List_Olinorder__class_Oinsort__key,type,
    linorder_insort_key: 
      !>[B1: $tType,A: $tType] : ( ( fun(B1,A) * B1 * list(B1) ) > list(B1) ) ).

tff(sy_c_List_Olinorder__class_Osort__key,type,
    linorder_sort_key: 
      !>[B1: $tType,A: $tType] : ( ( fun(B1,A) * list(B1) ) > list(B1) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,list(B1)) * list(A) ) > list(B1) ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_OtakeWhile,type,
    takeWhile: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: arrow_411405190le_alt ).

%----Relevant facts (100)
tff(fact_0_alt3,axiom,
    ? [A1: arrow_411405190le_alt,B4: arrow_411405190le_alt,C: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A1,cons(arrow_411405190le_alt,B4,cons(arrow_411405190le_alt,C,nil(arrow_411405190le_alt))))) ).

tff(fact_1_third__alt,axiom,
    ! [B3: arrow_411405190le_alt,A4: arrow_411405190le_alt] :
      ( ( A4 != B3 )
     => ? [C: arrow_411405190le_alt] : distinct(arrow_411405190le_alt,cons(arrow_411405190le_alt,A4,cons(arrow_411405190le_alt,B3,cons(arrow_411405190le_alt,C,nil(arrow_411405190le_alt))))) ) ).

tff(fact_2_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : distinct(A,nil(A)) ).

tff(fact_3_distinct__singleton,axiom,
    ! [A: $tType,X: A] : distinct(A,cons(A,X,nil(A))) ).

tff(fact_4_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A3: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A3,List3) )
    <=> ( ( Aa = A3 )
        & ( List = List3 ) ) ) ).

tff(fact_5_distinct__length__2__or__more,axiom,
    ! [A: $tType,Xs1: list(A),B2: A,Aa: A] :
      ( distinct(A,cons(A,Aa,cons(A,B2,Xs1)))
    <=> ( ( Aa != B2 )
        & distinct(A,cons(A,Aa,Xs1))
        & distinct(A,cons(A,B2,Xs1)) ) ) ).

tff(fact_6_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A2: A] : ( nil(A) != cons(A,A2,List2) ) ).

tff(fact_7_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A2: A] : ( cons(A,A2,List2) != nil(A) ) ).

tff(fact_8_neq__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
    <=> ? [Y3: A,Ys4: list(A)] : ( Xs1 = cons(A,Y3,Ys4) ) ) ).

tff(fact_9_list_Oexhaust,axiom,
    ! [A: $tType,Y2: list(A)] :
      ( ( Y2 != nil(A) )
     => ~ ! [A1: A,List1: list(A)] : ( Y2 != cons(A,A1,List1) ) ) ).

tff(fact_10_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_11_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_12_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_13_distinct__insert,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( distinct(A,Xs)
     => distinct(A,insert(A,X,Xs)) ) ).

tff(fact_14_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_15_list_Osimps_I4_J,axiom,
    ! [B1: $tType,A: $tType,F2: fun(B1,fun(list(B1),A)),F1: A] : ( list_case(A,B1,F1,F2,nil(B1)) = F1 ) ).

tff(fact_16_list_Osimps_I5_J,axiom,
    ! [A: $tType,B1: $tType,List: list(B1),Aa: B1,F2: fun(B1,fun(list(B1),A)),F1: A] : ( list_case(A,B1,F1,F2,cons(B1,Aa,List)) = aa(list(B1),A,aa(B1,fun(list(B1),A),F2,Aa),List) ) ).

tff(fact_17_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex1(A,P,nil(A)) ).

tff(fact_18_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y2: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y2,Ys1)) = cons(A,X,cons(A,Y2,splice(A,Xs,Ys1))) ) ).

tff(fact_19_list__nonempty__induct,axiom,
    ! [A: $tType,P: fun(list(A),bool),Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ( ! [X2: A] : pp(aa(list(A),bool,P,cons(A,X2,nil(A))))
       => ( ! [X2: A,Xs2: list(A)] :
              ( ( Xs2 != nil(A) )
             => ( pp(aa(list(A),bool,P,Xs2))
               => pp(aa(list(A),bool,P,cons(A,X2,Xs2))) ) )
         => pp(aa(list(A),bool,P,Xs1)) ) ) ) ).

tff(fact_20_list_Orecs_I1_J,axiom,
    ! [B1: $tType,A: $tType,F2: fun(B1,fun(list(B1),fun(A,A))),F1: A] : ( list_rec(A,B1,F1,F2,nil(B1)) = F1 ) ).

tff(fact_21_list_Orecs_I2_J,axiom,
    ! [A: $tType,B1: $tType,List: list(B1),Aa: B1,F2: fun(B1,fun(list(B1),fun(A,A))),F1: A] : ( list_rec(A,B1,F1,F2,cons(B1,Aa,List)) = aa(A,A,aa(list(B1),fun(A,A),aa(B1,fun(list(B1),fun(A,A)),F2,Aa),List),list_rec(A,B1,F1,F2,List)) ) ).

tff(fact_22_last_Osimps,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( ( Xs = nil(A) )
       => ( last(A,cons(A,X,Xs)) = X ) )
      & ( ( Xs != nil(A) )
       => ( last(A,cons(A,X,Xs)) = last(A,Xs) ) ) ) ).

tff(fact_23_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_24_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_25_last__ConsR,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( last(A,cons(A,X,Xs)) = last(A,Xs) ) ) ).

tff(fact_26_last__ConsL,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( Xs = nil(A) )
     => ( last(A,cons(A,X,Xs)) = X ) ) ).

tff(fact_27_butlast_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( ( Xs = nil(A) )
       => ( butlast(A,cons(A,X,Xs)) = nil(A) ) )
      & ( ( Xs != nil(A) )
       => ( butlast(A,cons(A,X,Xs)) = cons(A,X,butlast(A,Xs)) ) ) ) ).

tff(fact_28_insort__key_Osimps_I1_J,axiom,
    ! [B1: $tType,A: $tType] :
      ( linorder(B1)
     => ! [X1: A,F: fun(A,B1)] : ( linorder_insort_key(A,B1,F,X1,nil(A)) = cons(A,X1,nil(A)) ) ) ).

tff(fact_29_null__rec_I2_J,axiom,
    ! [B1: $tType] : null(B1,nil(B1)) ).

tff(fact_30_List_Onull__def,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( null(A,Xs1)
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_31_eq__Nil__null,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 = nil(A) )
    <=> null(A,Xs1) ) ).

tff(fact_32_takeWhile_Osimps_I2_J,axiom,
    ! [A: $tType,Xs1: list(A),X1: A,P: fun(A,bool)] :
      ( ( pp(aa(A,bool,P,X1))
       => ( takeWhile(A,P,cons(A,X1,Xs1)) = cons(A,X1,takeWhile(A,P,Xs1)) ) )
      & ( ~ pp(aa(A,bool,P,X1))
       => ( takeWhile(A,P,cons(A,X1,Xs1)) = nil(A) ) ) ) ).

tff(fact_33_last__snoc,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( last(A,append(A,Xs,cons(A,X,nil(A)))) = X ) ).

tff(fact_34_append__assoc,axiom,
    ! [A: $tType,Zs1: list(A),Ys1: list(A),Xs: list(A)] : ( append(A,append(A,Xs,Ys1),Zs1) = append(A,Xs,append(A,Ys1,Zs1)) ) ).

tff(fact_35_same__append__eq,axiom,
    ! [A: $tType,Zs: list(A),Ys: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys) = append(A,Xs1,Zs) )
    <=> ( Ys = Zs ) ) ).

tff(fact_36_append__same__eq,axiom,
    ! [A: $tType,Zs: list(A),Xs1: list(A),Ys: list(A)] :
      ( ( append(A,Ys,Xs1) = append(A,Zs,Xs1) )
    <=> ( Ys = Zs ) ) ).

tff(fact_37_append__Cons,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A),X: A] : ( append(A,cons(A,X,Xs),Ys1) = cons(A,X,append(A,Xs,Ys1)) ) ).

tff(fact_38_append__self__conv2,axiom,
    ! [A: $tType,Ys: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys) = Ys )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_39_append__self__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys) = Xs1 )
    <=> ( Ys = nil(A) ) ) ).

tff(fact_40_append__is__Nil__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys) = nil(A) )
    <=> ( ( Xs1 = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_41_self__append__conv2,axiom,
    ! [A: $tType,Xs1: list(A),Ys: list(A)] :
      ( ( Ys = append(A,Xs1,Ys) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_42_self__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs1: list(A)] :
      ( ( Xs1 = append(A,Xs1,Ys) )
    <=> ( Ys = nil(A) ) ) ).

tff(fact_43_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs1: list(A)] :
      ( ( nil(A) = append(A,Xs1,Ys) )
    <=> ( ( Xs1 = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_44_takeWhile_Osimps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ( takeWhile(A,P,nil(A)) = nil(A) ) ).

tff(fact_45_butlast_Osimps_I1_J,axiom,
    ! [A: $tType] : ( butlast(A,nil(A)) = nil(A) ) ).

tff(fact_46_append1__eq__conv,axiom,
    ! [A: $tType,Y: A,Ys: list(A),X1: A,Xs1: list(A)] :
      ( ( append(A,Xs1,cons(A,X1,nil(A))) = append(A,Ys,cons(A,Y,nil(A))) )
    <=> ( ( Xs1 = Ys )
        & ( X1 = Y ) ) ) ).

tff(fact_47_append__eq__append__conv2,axiom,
    ! [A: $tType,Ts: list(A),Zs: list(A),Ys: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys) = append(A,Zs,Ts) )
    <=> ? [Us1: list(A)] :
          ( ( ( Xs1 = append(A,Zs,Us1) )
            & ( append(A,Us1,Ys) = Ts ) )
          | ( ( append(A,Xs1,Us1) = Zs )
            & ( Ys = append(A,Us1,Ts) ) ) ) ) ).

tff(fact_48_insort__key__left__comm,axiom,
    ! [A: $tType,B1: $tType] :
      ( linorder(A)
     => ! [Xs1: list(B1),Y: B1,X1: B1,F: fun(B1,A)] :
          ( ( aa(B1,A,F,X1) != aa(B1,A,F,Y) )
         => ( linorder_insort_key(B1,A,F,Y,linorder_insort_key(B1,A,F,X1,Xs1)) = linorder_insort_key(B1,A,F,X1,linorder_insort_key(B1,A,F,Y,Xs1)) ) ) ) ).

tff(fact_49_append__eq__appendI,axiom,
    ! [A: $tType,Us: list(A),Ys1: list(A),Zs1: list(A),Xs11: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Xs11) = Zs1 )
     => ( ( Ys1 = append(A,Xs11,Us) )
       => ( append(A,Xs,Ys1) = append(A,Zs1,Us) ) ) ) ).

tff(fact_50_takeWhile__tail,axiom,
    ! [A: $tType,L: list(A),Xs1: list(A),X1: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X1))
     => ( takeWhile(A,P,append(A,Xs1,cons(A,X1,L))) = takeWhile(A,P,Xs1) ) ) ).

tff(fact_51_butlast__append,axiom,
    ! [A: $tType,Xs: list(A),Ys1: list(A)] :
      ( ( ( Ys1 = nil(A) )
       => ( butlast(A,append(A,Xs,Ys1)) = butlast(A,Xs) ) )
      & ( ( Ys1 != nil(A) )
       => ( butlast(A,append(A,Xs,Ys1)) = append(A,Xs,butlast(A,Ys1)) ) ) ) ).

tff(fact_52_butlast__snoc,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( butlast(A,append(A,Xs,cons(A,X,nil(A)))) = Xs ) ).

tff(fact_53_Cons__eq__appendI,axiom,
    ! [A: $tType,Zs1: list(A),Xs: list(A),Ys1: list(A),Xs11: list(A),X: A] :
      ( ( cons(A,X,Xs11) = Ys1 )
     => ( ( Xs = append(A,Xs11,Zs1) )
       => ( cons(A,X,Xs) = append(A,Ys1,Zs1) ) ) ) ).

tff(fact_54_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A)] :
      ( ( Xs = Ys1 )
     => ( Xs = append(A,nil(A),Ys1) ) ) ).

tff(fact_55_append__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( append(A,Xs,nil(A)) = Xs ) ).

tff(fact_56_append__Nil,axiom,
    ! [A: $tType,Ys1: list(A)] : ( append(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_57_insort__not__Nil,axiom,
    ! [B1: $tType,A: $tType] :
      ( linorder(B1)
     => ! [Xs1: list(A),Aa: A,F: fun(A,B1)] : ( linorder_insort_key(A,B1,F,Aa,Xs1) != nil(A) ) ) ).

tff(fact_58_distinct__takeWhile,axiom,
    ! [A: $tType,P: fun(A,bool),Xs1: list(A)] :
      ( distinct(A,Xs1)
     => distinct(A,takeWhile(A,P,Xs1)) ) ).

tff(fact_59_append__butlast__last__id,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( append(A,butlast(A,Xs),cons(A,last(A,Xs),nil(A))) = Xs ) ) ).

tff(fact_60_snoc__eq__iff__butlast,axiom,
    ! [A: $tType,Ys: list(A),X1: A,Xs1: list(A)] :
      ( ( append(A,Xs1,cons(A,X1,nil(A))) = Ys )
    <=> ( ( Ys != nil(A) )
        & ( butlast(A,Ys) = Xs1 )
        & ( last(A,Ys) = X1 ) ) ) ).

tff(fact_61_Cons__eq__append__conv,axiom,
    ! [A: $tType,Zs: list(A),Ys: list(A),Xs1: list(A),X1: A] :
      ( ( cons(A,X1,Xs1) = append(A,Ys,Zs) )
    <=> ( ( ( Ys = nil(A) )
          & ( cons(A,X1,Xs1) = Zs ) )
        | ? [Ys3: list(A)] :
            ( ( cons(A,X1,Ys3) = Ys )
            & ( Xs1 = append(A,Ys3,Zs) ) ) ) ) ).

tff(fact_62_append__eq__Cons__conv,axiom,
    ! [A: $tType,Xs1: list(A),X1: A,Zs: list(A),Ys: list(A)] :
      ( ( append(A,Ys,Zs) = cons(A,X1,Xs1) )
    <=> ( ( ( Ys = nil(A) )
          & ( Zs = cons(A,X1,Xs1) ) )
        | ? [Ys3: list(A)] :
            ( ( Ys = cons(A,X1,Ys3) )
            & ( append(A,Ys3,Zs) = Xs1 ) ) ) ) ).

tff(fact_63_last__appendL,axiom,
    ! [A: $tType,Xs: list(A),Ys1: list(A)] :
      ( ( Ys1 = nil(A) )
     => ( last(A,append(A,Xs,Ys1)) = last(A,Xs) ) ) ).

tff(fact_64_last__appendR,axiom,
    ! [A: $tType,Xs: list(A),Ys1: list(A)] :
      ( ( Ys1 != nil(A) )
     => ( last(A,append(A,Xs,Ys1)) = last(A,Ys1) ) ) ).

tff(fact_65_last__append,axiom,
    ! [A: $tType,Xs: list(A),Ys1: list(A)] :
      ( ( ( Ys1 = nil(A) )
       => ( last(A,append(A,Xs,Ys1)) = last(A,Xs) ) )
      & ( ( Ys1 != nil(A) )
       => ( last(A,append(A,Xs,Ys1)) = last(A,Ys1) ) ) ) ).

tff(fact_66_distinct__butlast,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( distinct(A,Xs)
       => distinct(A,butlast(A,Xs)) ) ) ).

tff(fact_67_null__rec_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ~ null(A,cons(A,X,Xs)) ).

tff(fact_68_rev__cases,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ~ ! [Ys2: list(A),Y1: A] : ( Xs != append(A,Ys2,cons(A,Y1,nil(A))) ) ) ).

tff(fact_69_rev__induct,axiom,
    ! [A: $tType,Xs1: list(A),P: fun(list(A),bool)] :
      ( pp(aa(list(A),bool,P,nil(A)))
     => ( ! [X2: A,Xs2: list(A)] :
            ( pp(aa(list(A),bool,P,Xs2))
           => pp(aa(list(A),bool,P,append(A,Xs2,cons(A,X2,nil(A))))) )
       => pp(aa(list(A),bool,P,Xs1)) ) ) ).

tff(fact_70_equal__Nil__null,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( equal_equal(list(A),Xs1,nil(A))
    <=> null(A,Xs1) ) ).

tff(fact_71_rotate__simps,axiom,
    ! [A: $tType,B1: $tType,Xs: list(B1),X: B1] :
      ( ( rotate1(A,nil(A)) = nil(A) )
      & ( rotate1(B1,cons(B1,X,Xs)) = append(B1,Xs,cons(B1,X,nil(B1))) ) ) ).

tff(fact_72_maps__simps_I1_J,axiom,
    ! [A: $tType,B1: $tType,Xs1: list(B1),X1: B1,F: fun(B1,list(A))] : ( maps(B1,A,F,cons(B1,X1,Xs1)) = append(A,aa(B1,list(A),F,X1),maps(B1,A,F,Xs1)) ) ).

tff(fact_73_sort__key__simps_I2_J,axiom,
    ! [B1: $tType,A: $tType] :
      ( linorder(B1)
     => ! [Xs1: list(A),X1: A,F: fun(A,B1)] : ( linorder_sort_key(A,B1,F,cons(A,X1,Xs1)) = linorder_insort_key(A,B1,F,X1,linorder_sort_key(A,B1,F,Xs1)) ) ) ).

tff(fact_74_sort__key__simps_I1_J,axiom,
    ! [B1: $tType,A: $tType] :
      ( linorder(B1)
     => ! [F: fun(A,B1)] : ( linorder_sort_key(A,B1,F,nil(A)) = nil(A) ) ) ).

tff(fact_75_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( rotate1(A,Xs1) = nil(A) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_76_distinct__sort,axiom,
    ! [B1: $tType,A: $tType] :
      ( linorder(B1)
     => ! [Xs1: list(A),F: fun(A,B1)] :
          ( distinct(A,linorder_sort_key(A,B1,F,Xs1))
        <=> distinct(A,Xs1) ) ) ).

tff(fact_77_distinct1__rotate,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( distinct(A,rotate1(A,Xs1))
    <=> distinct(A,Xs1) ) ).

tff(fact_78_equal__list__def,axiom,
    ! [A: $tType,Y: list(A),X1: list(A)] :
      ( equal_equal(list(A),X1,Y)
    <=> ( X1 = Y ) ) ).

tff(fact_79_maps__simps_I2_J,axiom,
    ! [B1: $tType,A: $tType,F: fun(B1,list(A))] : ( maps(B1,A,F,nil(B1)) = nil(A) ) ).

tff(fact_80_dropWhile__eq__Cons__conv,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs1: list(A),P: fun(A,bool)] :
      ( ( dropWhile(A,P,Xs1) = cons(A,Y,Ys) )
    <=> ( ( Xs1 = append(A,takeWhile(A,P,Xs1),cons(A,Y,Ys)) )
        & ~ pp(aa(A,bool,P,Y)) ) ) ).

tff(fact_81_rev_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( rev(A,cons(A,X,Xs)) = append(A,rev(A,Xs),cons(A,X,nil(A))) ) ).

tff(fact_82_rev__is__rev__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs1: list(A)] :
      ( ( rev(A,Xs1) = rev(A,Ys) )
    <=> ( Xs1 = Ys ) ) ).

tff(fact_83_rev_Osimps_I1_J,axiom,
    ! [A: $tType] : ( rev(A,nil(A)) = nil(A) ) ).

tff(fact_84_Nil__is__rev__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( nil(A) = rev(A,Xs1) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_85_rev__is__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( rev(A,Xs1) = nil(A) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_86_rev__append,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A)] : ( rev(A,append(A,Xs,Ys1)) = append(A,rev(A,Ys1),rev(A,Xs)) ) ).

tff(fact_87_distinct__rev,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( distinct(A,rev(A,Xs1))
    <=> distinct(A,Xs1) ) ).

tff(fact_88_dropWhile_Osimps_I2_J,axiom,
    ! [A: $tType,Xs1: list(A),X1: A,P: fun(A,bool)] :
      ( ( pp(aa(A,bool,P,X1))
       => ( dropWhile(A,P,cons(A,X1,Xs1)) = dropWhile(A,P,Xs1) ) )
      & ( ~ pp(aa(A,bool,P,X1))
       => ( dropWhile(A,P,cons(A,X1,Xs1)) = cons(A,X1,Xs1) ) ) ) ).

tff(fact_89_dropWhile_Osimps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ( dropWhile(A,P,nil(A)) = nil(A) ) ).

tff(fact_90_singleton__rev__conv,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] :
      ( ( cons(A,X1,nil(A)) = rev(A,Xs1) )
    <=> ( Xs1 = cons(A,X1,nil(A)) ) ) ).

tff(fact_91_rev__singleton__conv,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] :
      ( ( rev(A,Xs1) = cons(A,X1,nil(A)) )
    <=> ( Xs1 = cons(A,X1,nil(A)) ) ) ).

tff(fact_92_rev__eq__Cons__iff,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs1: list(A)] :
      ( ( rev(A,Xs1) = cons(A,Y,Ys) )
    <=> ( Xs1 = append(A,rev(A,Ys),cons(A,Y,nil(A))) ) ) ).

tff(fact_93_distinct__dropWhile,axiom,
    ! [A: $tType,P: fun(A,bool),Xs1: list(A)] :
      ( distinct(A,Xs1)
     => distinct(A,dropWhile(A,P,Xs1)) ) ).

tff(fact_94_rev__rev__ident,axiom,
    ! [A: $tType,Xs: list(A)] : ( rev(A,rev(A,Xs)) = Xs ) ).

tff(fact_95_rev__swap,axiom,
    ! [A: $tType,Ys: list(A),Xs1: list(A)] :
      ( ( rev(A,Xs1) = Ys )
    <=> ( Xs1 = rev(A,Ys) ) ) ).

tff(fact_96_takeWhile__dropWhile__id,axiom,
    ! [A: $tType,Xs1: list(A),P: fun(A,bool)] : ( append(A,takeWhile(A,P,Xs1),dropWhile(A,P,Xs1)) = Xs1 ) ).

tff(fact_97_hd__rev,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( hd(A,rev(A,Xs)) = last(A,Xs) ) ) ).

tff(fact_98_last__rev,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( last(A,rev(A,Xs)) = hd(A,Xs) ) ) ).

tff(fact_99_hd_Osimps,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( hd(A,cons(A,X,Xs)) = X ) ).

%----Arities (1)
tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ? [B: arrow_411405190le_alt] : ( B != a ) ).

%------------------------------------------------------------------------------
