%------------------------------------------------------------------------------
% File     : RNG100+1 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Ring Theory
% Problem  : Chinese remainder theorem in a ring 06, 00 expansion
% Version  : Especial.
% English  :

% Refs     : [VLP07] Verchinine et al. (2007), System for Automated Deduction
%          : [Pas08] Paskevich (2008), Email to G. Sutcliffe
% Source   : [Pas08]
% Names    : chines_06.00 [Pas08]

% Status   : Theorem
% Rating   : 0.91 v9.0.0, 0.92 v7.5.0, 0.91 v7.4.0, 0.87 v7.3.0, 0.86 v7.1.0, 0.83 v7.0.0, 0.97 v6.4.0, 0.92 v6.2.0, 1.00 v4.0.0
% Syntax   : Number of formulae    :   39 (   5 unt;   9 def)
%            Number of atoms       :  152 (  31 equ)
%            Maximal formula atoms :    9 (   3 avg)
%            Number of connectives :  117 (   4   ~;   1   |;  53   &)
%                                         (  12 <=>;  47  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   6 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :   13 (  11 usr;   1 prp; 0-3 aty)
%            Number of functors    :   10 (  10 usr;   3 con; 0-2 aty)
%            Number of variables   :   83 (  76   !;   7   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Problem generated by the SAD system [VLP07]
%------------------------------------------------------------------------------
fof(mElmSort,axiom,
    ! [W0] :
      ( aElement0(W0)
     => $true ) ).

fof(mSortsC,axiom,
    aElement0(sz00) ).

fof(mSortsC_01,axiom,
    aElement0(sz10) ).

fof(mSortsU,axiom,
    ! [W0] :
      ( aElement0(W0)
     => aElement0(smndt0(W0)) ) ).

fof(mSortsB,axiom,
    ! [W0,W1] :
      ( ( aElement0(W0)
        & aElement0(W1) )
     => aElement0(sdtpldt0(W0,W1)) ) ).

fof(mSortsB_02,axiom,
    ! [W0,W1] :
      ( ( aElement0(W0)
        & aElement0(W1) )
     => aElement0(sdtasdt0(W0,W1)) ) ).

fof(mAddComm,axiom,
    ! [W0,W1] :
      ( ( aElement0(W0)
        & aElement0(W1) )
     => sdtpldt0(W0,W1) = sdtpldt0(W1,W0) ) ).

fof(mAddAsso,axiom,
    ! [W0,W1,W2] :
      ( ( aElement0(W0)
        & aElement0(W1)
        & aElement0(W2) )
     => sdtpldt0(sdtpldt0(W0,W1),W2) = sdtpldt0(W0,sdtpldt0(W1,W2)) ) ).

fof(mAddZero,axiom,
    ! [W0] :
      ( aElement0(W0)
     => ( sdtpldt0(W0,sz00) = W0
        & W0 = sdtpldt0(sz00,W0) ) ) ).

fof(mAddInvr,axiom,
    ! [W0] :
      ( aElement0(W0)
     => ( sdtpldt0(W0,smndt0(W0)) = sz00
        & sz00 = sdtpldt0(smndt0(W0),W0) ) ) ).

fof(mMulComm,axiom,
    ! [W0,W1] :
      ( ( aElement0(W0)
        & aElement0(W1) )
     => sdtasdt0(W0,W1) = sdtasdt0(W1,W0) ) ).

fof(mMulAsso,axiom,
    ! [W0,W1,W2] :
      ( ( aElement0(W0)
        & aElement0(W1)
        & aElement0(W2) )
     => sdtasdt0(sdtasdt0(W0,W1),W2) = sdtasdt0(W0,sdtasdt0(W1,W2)) ) ).

fof(mMulUnit,axiom,
    ! [W0] :
      ( aElement0(W0)
     => ( sdtasdt0(W0,sz10) = W0
        & W0 = sdtasdt0(sz10,W0) ) ) ).

fof(mAMDistr,axiom,
    ! [W0,W1,W2] :
      ( ( aElement0(W0)
        & aElement0(W1)
        & aElement0(W2) )
     => ( sdtasdt0(W0,sdtpldt0(W1,W2)) = sdtpldt0(sdtasdt0(W0,W1),sdtasdt0(W0,W2))
        & sdtasdt0(sdtpldt0(W1,W2),W0) = sdtpldt0(sdtasdt0(W1,W0),sdtasdt0(W2,W0)) ) ) ).

fof(mMulMnOne,axiom,
    ! [W0] :
      ( aElement0(W0)
     => ( sdtasdt0(smndt0(sz10),W0) = smndt0(W0)
        & smndt0(W0) = sdtasdt0(W0,smndt0(sz10)) ) ) ).

fof(mMulZero,axiom,
    ! [W0] :
      ( aElement0(W0)
     => ( sdtasdt0(W0,sz00) = sz00
        & sz00 = sdtasdt0(sz00,W0) ) ) ).

fof(mCancel,axiom,
    ! [W0,W1] :
      ( ( aElement0(W0)
        & aElement0(W1) )
     => ( sdtasdt0(W0,W1) = sz00
       => ( W0 = sz00
          | W1 = sz00 ) ) ) ).

fof(mUnNeZr,axiom,
    sz10 != sz00 ).

fof(mSetSort,axiom,
    ! [W0] :
      ( aSet0(W0)
     => $true ) ).

fof(mEOfElem,axiom,
    ! [W0] :
      ( aSet0(W0)
     => ! [W1] :
          ( aElementOf0(W1,W0)
         => aElement0(W1) ) ) ).

fof(mSetEq,axiom,
    ! [W0,W1] :
      ( ( aSet0(W0)
        & aSet0(W1) )
     => ( ( ! [W2] :
              ( aElementOf0(W2,W0)
             => aElementOf0(W2,W1) )
          & ! [W2] :
              ( aElementOf0(W2,W1)
             => aElementOf0(W2,W0) ) )
       => W0 = W1 ) ) ).

fof(mDefSSum,definition,
    ! [W0,W1] :
      ( ( aSet0(W0)
        & aSet0(W1) )
     => ! [W2] :
          ( W2 = sdtpldt1(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ? [W4,W5] :
                    ( aElementOf0(W4,W0)
                    & aElementOf0(W5,W1)
                    & sdtpldt0(W4,W5) = W3 ) ) ) ) ) ).

fof(mDefSInt,definition,
    ! [W0,W1] :
      ( ( aSet0(W0)
        & aSet0(W1) )
     => ! [W2] :
          ( W2 = sdtasasdt0(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ( aElementOf0(W3,W0)
                  & aElementOf0(W3,W1) ) ) ) ) ) ).

fof(mDefIdeal,definition,
    ! [W0] :
      ( aIdeal0(W0)
    <=> ( aSet0(W0)
        & ! [W1] :
            ( aElementOf0(W1,W0)
           => ( ! [W2] :
                  ( aElementOf0(W2,W0)
                 => aElementOf0(sdtpldt0(W1,W2),W0) )
              & ! [W2] :
                  ( aElement0(W2)
                 => aElementOf0(sdtasdt0(W2,W1),W0) ) ) ) ) ) ).

fof(mIdeSum,axiom,
    ! [W0,W1] :
      ( ( aIdeal0(W0)
        & aIdeal0(W1) )
     => aIdeal0(sdtpldt1(W0,W1)) ) ).

fof(mIdeInt,axiom,
    ! [W0,W1] :
      ( ( aIdeal0(W0)
        & aIdeal0(W1) )
     => aIdeal0(sdtasasdt0(W0,W1)) ) ).

fof(mDefMod,definition,
    ! [W0,W1,W2] :
      ( ( aElement0(W0)
        & aElement0(W1)
        & aIdeal0(W2) )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
      <=> aElementOf0(sdtpldt0(W0,smndt0(W1)),W2) ) ) ).

fof(mChineseRemainder,axiom,
    ! [W0,W1] :
      ( ( aIdeal0(W0)
        & aIdeal0(W1) )
     => ( ! [W2] :
            ( aElement0(W2)
           => aElementOf0(W2,sdtpldt1(W0,W1)) )
       => ! [W2,W3] :
            ( ( aElement0(W2)
              & aElement0(W3) )
           => ? [W4] :
                ( aElement0(W4)
                & sdteqdtlpzmzozddtrp0(W4,W2,W0)
                & sdteqdtlpzmzozddtrp0(W4,W3,W1) ) ) ) ) ).

fof(mNatSort,axiom,
    ! [W0] :
      ( aNaturalNumber0(W0)
     => $true ) ).

fof(mEucSort,axiom,
    ! [W0] :
      ( ( aElement0(W0)
        & W0 != sz00 )
     => aNaturalNumber0(sbrdtbr0(W0)) ) ).

fof(mNatLess,axiom,
    ! [W0,W1] :
      ( ( aNaturalNumber0(W0)
        & aNaturalNumber0(W1) )
     => ( iLess0(W0,W1)
       => $true ) ) ).

fof(mDivision,axiom,
    ! [W0,W1] :
      ( ( aElement0(W0)
        & aElement0(W1)
        & W1 != sz00 )
     => ? [W2,W3] :
          ( aElement0(W2)
          & aElement0(W3)
          & W0 = sdtpldt0(sdtasdt0(W2,W1),W3)
          & ( W3 != sz00
           => iLess0(sbrdtbr0(W3),sbrdtbr0(W1)) ) ) ) ).

fof(mDefDiv,definition,
    ! [W0,W1] :
      ( ( aElement0(W0)
        & aElement0(W1) )
     => ( doDivides0(W0,W1)
      <=> ? [W2] :
            ( aElement0(W2)
            & sdtasdt0(W0,W2) = W1 ) ) ) ).

fof(mDefDvs,definition,
    ! [W0] :
      ( aElement0(W0)
     => ! [W1] :
          ( aDivisorOf0(W1,W0)
        <=> ( aElement0(W1)
            & doDivides0(W1,W0) ) ) ) ).

fof(mDefGCD,definition,
    ! [W0,W1] :
      ( ( aElement0(W0)
        & aElement0(W1) )
     => ! [W2] :
          ( aGcdOfAnd0(W2,W0,W1)
        <=> ( aDivisorOf0(W2,W0)
            & aDivisorOf0(W2,W1)
            & ! [W3] :
                ( ( aDivisorOf0(W3,W0)
                  & aDivisorOf0(W3,W1) )
               => doDivides0(W3,W2) ) ) ) ) ).

fof(mDefRel,definition,
    ! [W0,W1] :
      ( ( aElement0(W0)
        & aElement0(W1) )
     => ( misRelativelyPrime0(W0,W1)
      <=> aGcdOfAnd0(sz10,W0,W1) ) ) ).

fof(mDefPrIdeal,definition,
    ! [W0] :
      ( aElement0(W0)
     => ! [W1] :
          ( W1 = slsdtgt0(W0)
        <=> ( aSet0(W1)
            & ! [W2] :
                ( aElementOf0(W2,W1)
              <=> ? [W3] :
                    ( aElement0(W3)
                    & sdtasdt0(W0,W3) = W2 ) ) ) ) ) ).

fof(m__1905,hypothesis,
    aElement0(xc) ).

fof(m__,conjecture,
    aIdeal0(slsdtgt0(xc)) ).

%------------------------------------------------------------------------------
