%--------------------------------------------------------------------------
% File     : RNG025-9 : TPTP v9.2.0. Released v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : Middle or Flexible Law
% Version  : [Ste87] (equality) axioms : Biased.
%            Theorem formulation : Linearized.
% English  :

% Refs     : [Ste87] Stevens (1987), Some Experiments in Nonassociative Rin
% Source   : [TPTP]
% Names    :

% Status   : Satisfiable
% Rating   : 0.00 v9.1.0, 0.43 v9.0.0, 0.22 v8.2.0, 0.00 v8.1.0, 0.25 v7.5.0, 0.00 v6.2.0, 0.17 v6.1.0, 0.40 v6.0.0, 0.20 v5.5.0, 0.40 v5.4.0, 0.50 v5.3.0, 0.67 v5.2.0, 0.33 v3.2.0, 0.67 v3.1.0, 0.33 v2.5.0, 0.67 v2.4.0, 0.67 v2.2.1, 0.75 v2.2.0, 0.67 v2.1.0, 1.00 v2.0.0
% Syntax   : Number of clauses     :   25 (  25 unt;   0 nHn;   1 RR)
%            Number of literals    :   25 (  25 equ;   1 neg)
%            Maximal clause size   :    1 (   1 avg)
%            Maximal term depth    :    4 (   2 avg)
%            Number of predicates  :    1 (   0 usr;   0 prp; 2-2 aty)
%            Number of functors    :    9 (   9 usr;   4 con; 0-3 aty)
%            Number of variables   :   54 (   2 sgn)
% SPC      : CNF_SAT_RFO_PEQ_UEQ

% Comments : Biased towards Otter.
%--------------------------------------------------------------------------
%----Don't Include nonassociative ring axioms.
%----The associator has to be replaced by its linearised form.
% include('axioms/RNG003-0.ax').
%--------------------------------------------------------------------------
%----The next 7 clause are extra lemmas which Stevens found useful
cnf(product_of_inverses,axiom,
    multiply(additive_inverse(X),additive_inverse(Y)) = multiply(X,Y) ).

cnf(inverse_product1,axiom,
    multiply(additive_inverse(X),Y) = additive_inverse(multiply(X,Y)) ).

cnf(inverse_product2,axiom,
    multiply(X,additive_inverse(Y)) = additive_inverse(multiply(X,Y)) ).

cnf(distributivity_of_difference1,axiom,
    multiply(X,add(Y,additive_inverse(Z))) = add(multiply(X,Y),additive_inverse(multiply(X,Z))) ).

cnf(distributivity_of_difference2,axiom,
    multiply(add(X,additive_inverse(Y)),Z) = add(multiply(X,Z),additive_inverse(multiply(Y,Z))) ).

cnf(distributivity_of_difference3,axiom,
    multiply(additive_inverse(X),add(Y,Z)) = add(additive_inverse(multiply(X,Y)),additive_inverse(multiply(X,Z))) ).

cnf(distributivity_of_difference4,axiom,
    multiply(add(X,Y),additive_inverse(Z)) = add(additive_inverse(multiply(X,Z)),additive_inverse(multiply(Y,Z))) ).

%----Commutativity for addition
cnf(commutativity_for_addition,axiom,
    add(X,Y) = add(Y,X) ).

%----Associativity for addition
cnf(associativity_for_addition,axiom,
    add(X,add(Y,Z)) = add(add(X,Y),Z) ).

%----There exists an additive identity element
cnf(left_additive_identity,axiom,
    add(additive_identity,X) = X ).

cnf(right_additive_identity,axiom,
    add(X,additive_identity) = X ).

%----Multiplicative zero
cnf(left_multiplicative_zero,axiom,
    multiply(additive_identity,X) = additive_identity ).

cnf(right_multiplicative_zero,axiom,
    multiply(X,additive_identity) = additive_identity ).

%----Existence of left additive additive_inverse
cnf(left_additive_inverse,axiom,
    add(additive_inverse(X),X) = additive_identity ).

cnf(right_additive_inverse,axiom,
    add(X,additive_inverse(X)) = additive_identity ).

%----Distributive property of product over sum
cnf(distribute1,axiom,
    multiply(X,add(Y,Z)) = add(multiply(X,Y),multiply(X,Z)) ).

cnf(distribute2,axiom,
    multiply(add(X,Y),Z) = add(multiply(X,Z),multiply(Y,Z)) ).

%----Inverse of additive_inverse of X is X
cnf(additive_inverse_additive_inverse,axiom,
    additive_inverse(additive_inverse(X)) = X ).

%----Right alternative law
cnf(right_alternative,axiom,
    multiply(multiply(X,Y),Y) = multiply(X,multiply(Y,Y)) ).

%----Left alternative law
cnf(left_alternative,axiom,
    multiply(multiply(X,X),Y) = multiply(X,multiply(X,Y)) ).

%----Associator
% input_clause(associator,axiom,
%     [++equal(associator(X,Y,Z),add(multiply(multiply(X,Y),Z),
% additive_inverse(multiply(X,multiply(Y,Z)))))]).

%----Linearised for of the associator
cnf(linearised_associator1,axiom,
    associator(X,Y,add(U,V)) = add(associator(X,Y,U),associator(X,Y,V)) ).

cnf(linearised_associator2,axiom,
    associator(X,add(U,V),Y) = add(associator(X,U,Y),associator(X,V,Y)) ).

cnf(linearised_associator3,axiom,
    associator(add(U,V),X,Y) = add(associator(U,X,Y),associator(V,X,Y)) ).

%----Commutator
cnf(commutator,axiom,
    commutator(X,Y) = add(multiply(Y,X),additive_inverse(multiply(X,Y))) ).

cnf(prove_flexible_law,negated_conjecture,
    add(associator(a,b,c),associator(a,c,b)) != additive_identity ).

%--------------------------------------------------------------------------
