%------------------------------------------------------------------------------
% File     : PUZ149_13 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Puzzles
% Problem  : The bungling chemist
% Version  : [QMLTP] axioms.
% English  : Assume that a chemical compound c is made by pouring the elements
%            a and b into the same beaker. The two elements a and b are not
%            acid. It is possible that after making the compound c it results
%            in an acid. Then it is possible that pouring element a results
%            not in an acid, and pouring a and b in the beaker results in an
%            acid.

% Refs     : [Bal98] Baldoni (1998), Normal Multimodal Logics: Automatic De
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : MML006+1 [QMLTP]

% Status   : Theorem
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :   15 (   0 unt;   8 typ;   0 def)
%            Number of atoms       :   29 (   0 equ)
%            Maximal formula atoms :    5 (   4 avg)
%            Number of connectives :   28 (   6   ~;   0   |;   5   &)
%                                         (   0 <=>;  17  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    7 (   6 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :    4 (   2   >;   2   *;   0   +;   0  <<)
%            Number of predicates  :    2 (   2 usr;   0 prp; 1-3 aty)
%            Number of functors    :    4 (   4 usr;   4 con; 0-0 aty)
%            Number of variables   :   17 (;  13   !;   4   ?;  17   :)
% SPC      : TF0_THM_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_K, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_index_type',type,
    '$ki_index': $tType ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_index' * '$ki_world' * '$ki_world' ) > $o ).

tff('#idx(make_c)_decl',type,
    '#idx(make_c)': '$ki_index' ).

tff('#idx(pour_b)_decl',type,
    '#idx(pour_b)': '$ki_index' ).

tff('#idx(pour_a)_decl',type,
    '#idx(pour_a)': '$ki_index' ).

tff(acid_decl,type,
    acid: '$ki_world' > $o ).

tff(pour_ab_make_axiom_1,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(pour_a)','$ki_local_world',W)
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'('#idx(pour_b)',W,W0)
           => acid(W0) ) )
   => ! [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(make_c)','$ki_local_world',W)
       => acid(W) ) ) ).

tff(pour_ab_make_axiom_2,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(pour_a)','$ki_local_world',W)
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'('#idx(pour_b)',W,W0)
           => ~ acid(W0) ) )
   => ! [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(make_c)','$ki_local_world',W)
       => ~ acid(W) ) ) ).

tff(pour_ba_make_axiom_1,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(pour_b)','$ki_local_world',W)
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'('#idx(pour_a)',W,W0)
           => acid(W0) ) )
   => ! [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(make_c)','$ki_local_world',W)
       => acid(W) ) ) ).

tff(pour_ba_make_axiom_2,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(pour_b)','$ki_local_world',W)
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'('#idx(pour_a)',W,W0)
           => ~ acid(W0) ) )
   => ! [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(make_c)','$ki_local_world',W)
       => ~ acid(W) ) ) ).

tff(pour_a_acid,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(pour_a)','$ki_local_world',W)
     => ~ acid(W) ) ).

tff(make_c_acid,axiom,
    ? [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(make_c)','$ki_local_world',W)
      & acid(W) ) ).

tff(verify,conjecture,
    ( ? [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(pour_a)','$ki_local_world',W)
        & ~ acid(W) )
    & ? [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(pour_a)','$ki_local_world',W)
        & ? [W0: '$ki_world'] :
            ( '$ki_accessible'('#idx(pour_b)',W,W0)
            & acid(W0) ) ) ) ).

%------------------------------------------------------------------------------
