%------------------------------------------------------------------------------
% File     : PUZ034-1.003 : TPTP v9.2.0. Released v1.0.0.
% Domain   : Puzzles
% Problem  : N queens problem
% Version  : [SETHEO] axioms : Biased.
% English  : The problem is to place 3 queens on an 3x3 chess board, so that no
%            queen can attack another.

% Refs     :
% Source   : [SETHEO]
% Names    : q1-2.lop (Size 8) [SETHEO]
%          : q1-9.lop (Size 9) [SETHEO]
%          : q1-10.lop (Size 10) [SETHEO]

% Status   : Satisfiable
% Rating   : 0.67 v9.1.0, 1.00 v5.4.0, 0.89 v5.3.0, 1.00 v3.3.0, 0.67 v3.2.0, 1.00 v3.1.0, 0.86 v2.7.0, 0.80 v2.6.0, 1.00 v2.5.0, 0.83 v2.4.0, 0.67 v2.2.1, 1.00 v2.1.0
% Syntax   : Number of clauses     :   18 (   9 unt;   2 nHn;  12 RR)
%            Number of literals    :   39 (   0 equ;  22 neg)
%            Maximal clause size   :    7 (   2 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of predicates  :    9 (   9 usr;   0 prp; 2-3 aty)
%            Number of functors    :    4 (   4 usr;   2 con; 0-2 aty)
%            Number of variables   :   45 (   6 sgn)
% SPC      : CNF_SAT_RFO_NEQ

% Comments : Biased towards SETHEO.
%          : tptp2X: -f tptp -s3 PUZ034-1.g
%------------------------------------------------------------------------------
cnf(make_list_of_numbers1,axiom,
    ( range(Low,High,cons(Low,RestOfNumbers))
    | ~ less(Low,High)
    | ~ sum(Low,s(n0),NewLow)
    | ~ range(NewLow,High,RestOfNumbers) ) ).

cnf(make_list_of_numbers2,axiom,
    range(Same,Same,cons(Same,empty_list)) ).

cnf(less1,axiom,
    less(n0,s(X)) ).

cnf(less2,axiom,
    ( less(s(X),s(Y))
    | ~ less(X,Y) ) ).

cnf(add_0,axiom,
    sum(X,n0,X) ).

cnf(add,axiom,
    ( ~ sum(X,Y,Z)
    | sum(X,s(Y),s(Z)) ) ).

cnf(select1,axiom,
    select(Head,cons(Head,Tail),Tail) ).

cnf(select2,axiom,
    ( select(Element,cons(Head,Tail),cons(Head,NewTail))
    | ~ select(Element,Tail,NewTail) ) ).

cnf(same_definition1,axiom,
    ~ same(s(X),n0) ).

cnf(same_definition2,axiom,
    ~ same(n0,s(X)) ).

cnf(same_definition3,axiom,
    ( ~ same(s(X),s(Y))
    | same(X,Y) ) ).

cnf(attack,axiom,
    ( diagonal_attack(Queen,s(n0),PlacedQueens)
    | ~ attack(Queen,PlacedQueens) ) ).

cnf(check_diagonals1,axiom,
    ( ~ diagonal_attack(Queen,QueenNumber,cons(PlacedQueen,OtherPlacedQueens))
    | ~ sum(Diagonal1,QueenNumber,PlacedQueen)
    | same(Diagonal1,Queen)
    | ~ sum(PlacedQueen,QueenNumber,Diagonal2)
    | same(Diagonal2,Queen)
    | ~ sum(QueenNumber,s(n0),NextQueenNumber)
    | diagonal_attack(Queen,NextQueenNumber,OtherPlacedQueens) ) ).

cnf(check_diagonals2,axiom,
    ~ diagonal_attack(Queen,LastQueen,empty_list) ).

cnf(place_a_queen1,axiom,
    ( do_queens(UnplacedQueens,SafeQueens,Placement)
    | ~ select(AQueen,UnplacedQueens,RestOfUnplacedQueens)
    | attack(AQueen,SafeQueens)
    | ~ do_queens(RestOfUnplacedQueens,cons(AQueen,SafeQueens),Placement) ) ).

cnf(place_a_queen2,axiom,
    do_queens(empty_list,Placement,Placement) ).

cnf(set_up_queens,axiom,
    ( queens(NumberOfQueens,Placement)
    | ~ sum(NumberOfQueens,s(n0),Low)
    | ~ sum(NumberOfQueens,NumberOfQueens,High)
    | ~ range(Low,High,Positions)
    | ~ do_queens(Positions,empty_list,Placement) ) ).

cnf(place_queens,negated_conjecture,
    ~ queens(s(s(s(n0))),Placement) ).

%------------------------------------------------------------------------------
