%------------------------------------------------------------------------------
% File     : PLA057_1.018 : TPTP v9.2.0. Released v9.0.0.
% Domain   : Planning
% Problem  : Path from the entry to the exit of a labyrinth 18
% Version  : Especial.
% English  :  The formula is the path from the entry to the exit of a
%            labyrinth. It makes no difference whether one starts at the
%            entry or at the exit.

% Refs     : [BHS00] Balsiger et al. (2000), A Benchmark Method for the Pro
%          : [NH+22] Nalon et al. (2022), Local Reductions for the Modal Cu
%          : [Nal22] Nalon (2022), Email to Geoff Sutcliffe
%          : [NH+23] Nalon et al. (2023), Buy One Get 14 Free: Evaluating L
% Source   : [Nal22]
% Names    : k45_path_p.0018 [Nal22]

% Status   : Theorem
% Rating   : 1.00 v9.0.0
% Syntax   : Number of formulae    :   19 (   0 unt;  18 typ;   0 def)
%            Number of atoms       : 2730 (   0 equ)
%            Maximal formula atoms : 2730 (2730 avg)
%            Number of connectives : 9591 (1366   ~;1361   |;1368   &)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%                                         (5496 {.};   0 {#})
%            Maximal formula depth :  303 ( 303 avg)
%            Maximal term depth    :    0 (   0 avg)
%            Number of types       :    1 (   0 usr)
%            Number of type conns  :    0 (   0   >;   0   *;   0   +;   0  <<)
%            Number of predicates  :   18 (  18 usr;  18 prp; 0-0 aty)
%            Number of functors    :    0 (   0 usr;   0 con; --- aty)
%            Number of variables   :    0 (;   0   !;   0   ?;   0   :)
% SPC      : NX0_THM_PRP_NEQ_NAR

% Comments :
%------------------------------------------------------------------------------
tff('k45_path_p.0018',logic,
    $modal == 
      [ $modalities == $modal_system_K45 ] ).

tff(p1_decl,type,
    p1: $o ).

tff(p2_decl,type,
    p2: $o ).

tff(p3_decl,type,
    p3: $o ).

tff(p4_decl,type,
    p4: $o ).

tff(p5_decl,type,
    p5: $o ).

tff(p6_decl,type,
    p6: $o ).

tff(y1_decl,type,
    y1: $o ).

tff(y2_decl,type,
    y2: $o ).

tff(y3_decl,type,
    y3: $o ).

tff(y4_decl,type,
    y4: $o ).

tff(y5_decl,type,
    y5: $o ).

tff(y6_decl,type,
    y6: $o ).

tff(z1_decl,type,
    z1: $o ).

tff(z2_decl,type,
    z2: $o ).

tff(z3_decl,type,
    z3: $o ).

tff(z4_decl,type,
    z4: $o ).

tff(z5_decl,type,
    z5: $o ).

tff(z6_decl,type,
    z6: $o ).

tff(prove,conjecture,
    ~ ( <.> ( ~ p1
            | ( [.] z1
              & <.> [.] y1
              & <.> <.> ( ~ z1
                        | ~ y1 ) ) )
      & <.> ( ~ p2
            | ( [.] z2
              & <.> [.] y2
              & <.> <.> ( ~ z2
                        | ~ y2 ) ) )
      & <.> ( ~ p3
            | ( [.] z3
              & <.> [.] y3
              & <.> <.> ( ~ z3
                        | ~ y3 ) ) )
      & <.> ( ~ p5
            | ( [.] z5
              & <.> [.] y5
              & <.> <.> ( ~ z5
                        | ~ y5 ) ) )
      & [.] ( p1
            | ( [.] z1
              & <.> [.] y1
              & <.> <.> ( ~ z1
                        | ~ y1 ) )
            | <.> ( ~ p3
                  | ( [.] z3
                    & <.> [.] y3
                    & <.> <.> ( ~ z3
                              | ~ y3 ) ) ) )
      & [.] ( p1
            | ( [.] z1
              & <.> [.] y1
              & <.> <.> ( ~ z1
                        | ~ y1 ) )
            | <.> ( ~ p5
                  | ( [.] z5
                    & <.> [.] y5
                    & <.> <.> ( ~ z5
                              | ~ y5 ) ) ) )
      & [.] ( p2
            | ( [.] z2
              & <.> [.] y2
              & <.> <.> ( ~ z2
                        | ~ y2 ) )
            | <.> ( ~ p1
                  | ( [.] z1
                    & <.> [.] y1
                    & <.> <.> ( ~ z1
                              | ~ y1 ) ) ) )
      & [.] ( p3
            | ( [.] z3
              & <.> [.] y3
              & <.> <.> ( ~ z3
                        | ~ y3 ) )
            | <.> ( ~ p3
                  | ( [.] z3
                    & <.> [.] y3
                    & <.> <.> ( ~ z3
                              | ~ y3 ) ) ) )
      & [.] ( p3
            | ( [.] z3
              & <.> [.] y3
              & <.> <.> ( ~ z3
                        | ~ y3 ) )
            | <.> ( ~ p5
                  | ( [.] z5
                    & <.> [.] y5
                    & <.> <.> ( ~ z5
                              | ~ y5 ) ) ) )
      & [.] ( p5
            | ( [.] z5
              & <.> [.] y5
              & <.> <.> ( ~ z5
                        | ~ y5 ) )
            | <.> ( ~ p3
                  | ( [.] z3
                    & <.> [.] y3
                    & <.> <.> ( ~ z3
                              | ~ y3 ) ) ) )
      & [.] ( p5
            | ( [.] z5
              & <.> [.] y5
              & <.> <.> ( ~ z5
                        | ~ y5 ) )
            | <.> ( ~ p5
                  | ( [.] z5
                    & <.> [.] y5
                    & <.> <.> ( ~ z5
                              | ~ y5 ) ) ) )
      & [.] [.] ( p1
                | ( [.] z1
                  & <.> [.] y1
                  & <.> <.> ( ~ z1
                            | ~ y1 ) )
                | <.> ( ~ p1
                      | ( [.] z1
                        & <.> [.] y1
                        & <.> <.> ( ~ z1
                                  | ~ y1 ) ) ) )
      & [.] [.] ( p1
                | ( [.] z1
                  & <.> [.] y1
                  & <.> <.> ( ~ z1
                            | ~ y1 ) )
                | <.> ( ~ p3
                      | ( [.] z3
                        & <.> [.] y3
                        & <.> <.> ( ~ z3
                                  | ~ y3 ) ) ) )
      & [.] [.] ( p1
                | ( [.] z1
                  & <.> [.] y1
                  & <.> <.> ( ~ z1
                            | ~ y1 ) )
                | <.> ( ~ p6
                      | ( [.] z6
                        & <.> [.] y6
                        & <.> <.> ( ~ z6
                                  | ~ y6 ) ) ) )
      & [.] [.] ( p1
                | ( [.] z1
                  & <.> [.] y1
                  & <.> <.> ( ~ z1
                            | ~ y1 ) )
                | <.> ( ~ p5
                      | ( [.] z5
                        & <.> [.] y5
                        & <.> <.> ( ~ z5
                                  | ~ y5 ) ) ) )
      & [.] ( p4
            | ( [.] z4
              & <.> [.] y4
              & <.> <.> ( ~ z4
                        | ~ y4 ) )
            | <.> ( ~ p2
                  | ( [.] z2
                    & <.> [.] y2
                    & <.> <.> ( ~ z2
                              | ~ y2 ) ) ) )
      & [.] ( p6
            | ( [.] z6
              & <.> [.] y6
              & <.> <.> ( ~ z6
                        | ~ y6 ) )
            | <.> ( ~ p2
                  | ( [.] z2
                    & <.> [.] y2
                    & <.> <.> ( ~ z2
                              | ~ y2 ) ) ) )
      & [.] [.] ( p3
                | ( [.] z3
                  & <.> [.] y3
                  & <.> <.> ( ~ z3
                            | ~ y3 ) )
                | <.> ( ~ p1
                      | ( [.] z1
                        & <.> [.] y1
                        & <.> <.> ( ~ z1
                                  | ~ y1 ) ) ) )
      & [.] [.] ( p3
                | ( [.] z3
                  & <.> [.] y3
                  & <.> <.> ( ~ z3
                            | ~ y3 ) )
                | <.> ( ~ p3
                      | ( [.] z3
                        & <.> [.] y3
                        & <.> <.> ( ~ z3
                                  | ~ y3 ) ) ) )
      & [.] [.] ( p3
                | ( [.] z3
                  & <.> [.] y3
                  & <.> <.> ( ~ z3
                            | ~ y3 ) )
                | <.> ( ~ p5
                      | ( [.] z5
                        & <.> [.] y5
                        & <.> <.> ( ~ z5
                                  | ~ y5 ) ) ) )
      & [.] ( p4
            | ( [.] z4
              & <.> [.] y4
              & <.> <.> ( ~ z4
                        | ~ y4 ) )
            | <.> ( ~ p4
                  | ( [.] z4
                    & <.> [.] y4
                    & <.> <.> ( ~ z4
                              | ~ y4 ) ) ) )
      & [.] ( p6
            | ( [.] z6
              & <.> [.] y6
              & <.> <.> ( ~ z6
                        | ~ y6 ) )
            | <.> ( ~ p4
                  | ( [.] z4
                    & <.> [.] y4
                    & <.> <.> ( ~ z4
                              | ~ y4 ) ) ) )
      & [.] [.] ( p5
                | ( [.] z5
                  & <.> [.] y5
                  & <.> <.> ( ~ z5
                            | ~ y5 ) )
                | <.> ( ~ p1
                      | ( [.] z1
                        & <.> [.] y1
                        & <.> <.> ( ~ z1
                                  | ~ y1 ) ) ) )
      & [.] [.] ( p5
                | ( [.] z5
                  & <.> [.] y5
                  & <.> <.> ( ~ z5
                            | ~ y5 ) )
                | <.> ( ~ p3
                      | ( [.] z3
                        & <.> [.] y3
                        & <.> <.> ( ~ z3
                                  | ~ y3 ) ) ) )
      & [.] [.] ( p5
                | ( [.] z5
                  & <.> [.] y5
                  & <.> <.> ( ~ z5
                            | ~ y5 ) )
                | <.> ( ~ p5
                      | ( [.] z5
                        & <.> [.] y5
                        & <.> <.> ( ~ z5
                                  | ~ y5 ) ) ) )
      & [.] ( p4
            | ( [.] z4
              & <.> [.] y4
              & <.> <.> ( ~ z4
                        | ~ y4 ) )
            | <.> ( ~ p6
                  | ( [.] z6
                    & <.> [.] y6
                    & <.> <.> ( ~ z6
                              | ~ y6 ) ) ) )
      & [.] ( p6
            | ( [.] z6
              & <.> [.] y6
              & <.> <.> ( ~ z6
                        | ~ y6 ) )
            | <.> ( ~ p6
                  | ( [.] z6
                    & <.> [.] y6
                    & <.> <.> ( ~ z6
                              | ~ y6 ) ) ) )
      & [.] [.] [.] ( p1
                    | ( [.] z1
                      & <.> [.] y1
                      & <.> <.> ( ~ z1
                                | ~ y1 ) )
                    | <.> ( ~ p1
                          | ( [.] z1
                            & <.> [.] y1
                            & <.> <.> ( ~ z1
                                      | ~ y1 ) ) ) )
      & [.] [.] [.] ( p1
                    | ( [.] z1
                      & <.> [.] y1
                      & <.> <.> ( ~ z1
                                | ~ y1 ) )
                    | <.> ( ~ p3
                          | ( [.] z3
                            & <.> [.] y3
                            & <.> <.> ( ~ z3
                                      | ~ y3 ) ) ) )
      & [.] [.] ( p2
                | ( [.] z2
                  & <.> [.] y2
                  & <.> <.> ( ~ z2
                            | ~ y2 ) )
                | <.> ( ~ p2
                      | ( [.] z2
                        & <.> [.] y2
                        & <.> <.> ( ~ z2
                                  | ~ y2 ) ) ) )
      & [.] [.] ( p4
                | ( [.] z4
                  & <.> [.] y4
                  & <.> <.> ( ~ z4
                            | ~ y4 ) )
                | <.> ( ~ p2
                      | ( [.] z2
                        & <.> [.] y2
                        & <.> <.> ( ~ z2
                                  | ~ y2 ) ) ) )
      & [.] [.] ( p6
                | ( [.] z6
                  & <.> [.] y6
                  & <.> <.> ( ~ z6
                            | ~ y6 ) )
                | <.> ( ~ p2
                      | ( [.] z2
                        & <.> [.] y2
                        & <.> <.> ( ~ z2
                                  | ~ y2 ) ) ) )
      & [.] [.] [.] ( p3
                    | ( [.] z3
                      & <.> [.] y3
                      & <.> <.> ( ~ z3
                                | ~ y3 ) )
                    | <.> ( ~ p1
                          | ( [.] z1
                            & <.> [.] y1
                            & <.> <.> ( ~ z1
                                      | ~ y1 ) ) ) )
      & [.] [.] [.] ( p3
                    | ( [.] z3
                      & <.> [.] y3
                      & <.> <.> ( ~ z3
                                | ~ y3 ) )
                    | <.> ( ~ p3
                          | ( [.] z3
                            & <.> [.] y3
                            & <.> <.> ( ~ z3
                                      | ~ y3 ) ) ) )
      & [.] [.] ( p2
                | ( [.] z2
                  & <.> [.] y2
                  & <.> <.> ( ~ z2
                            | ~ y2 ) )
                | <.> ( ~ p4
                      | ( [.] z4
                        & <.> [.] y4
                        & <.> <.> ( ~ z4
                                  | ~ y4 ) ) ) )
      & [.] [.] ( p4
                | ( [.] z4
                  & <.> [.] y4
                  & <.> <.> ( ~ z4
                            | ~ y4 ) )
                | <.> ( ~ p4
                      | ( [.] z4
                        & <.> [.] y4
                        & <.> <.> ( ~ z4
                                  | ~ y4 ) ) ) )
      & [.] [.] ( p6
                | ( [.] z6
                  & <.> [.] y6
                  & <.> <.> ( ~ z6
                            | ~ y6 ) )
                | <.> ( ~ p4
                      | ( [.] z4
                        & <.> [.] y4
                        & <.> <.> ( ~ z4
                                  | ~ y4 ) ) ) )
      & [.] [.] [.] ( p5
                    | ( [.] z5
                      & <.> [.] y5
                      & <.> <.> ( ~ z5
                                | ~ y5 ) )
                    | <.> ( ~ p1
                          | ( [.] z1
                            & <.> [.] y1
                            & <.> <.> ( ~ z1
                                      | ~ y1 ) ) ) )
      & [.] [.] [.] ( p5
                    | ( [.] z5
                      & <.> [.] y5
                      & <.> <.> ( ~ z5
                                | ~ y5 ) )
                    | <.> ( ~ p3
                          | ( [.] z3
                            & <.> [.] y3
                            & <.> <.> ( ~ z3
                                      | ~ y3 ) ) ) )
      & [.] [.] [.] ( p6
                    | ( [.] z6
                      & <.> [.] y6
                      & <.> <.> ( ~ z6
                                | ~ y6 ) )
                    | <.> ( ~ p5
                          | ( [.] z5
                            & <.> [.] y5
                            & <.> <.> ( ~ z5
                                      | ~ y5 ) ) ) )
      & [.] [.] ( p2
                | ( [.] z2
                  & <.> [.] y2
                  & <.> <.> ( ~ z2
                            | ~ y2 ) )
                | <.> ( ~ p6
                      | ( [.] z6
                        & <.> [.] y6
                        & <.> <.> ( ~ z6
                                  | ~ y6 ) ) ) )
      & [.] [.] ( p4
                | ( [.] z4
                  & <.> [.] y4
                  & <.> <.> ( ~ z4
                            | ~ y4 ) )
                | <.> ( ~ p6
                      | ( [.] z6
                        & <.> [.] y6
                        & <.> <.> ( ~ z6
                                  | ~ y6 ) ) ) )
      & [.] [.] ( p6
                | ( [.] z6
                  & <.> [.] y6
                  & <.> <.> ( ~ z6
                            | ~ y6 ) )
                | <.> ( ~ p6
                      | ( [.] z6
                        & <.> [.] y6
                        & <.> <.> ( ~ z6
                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] ( p1
                        | ( [.] z1
                          & <.> [.] y1
                          & <.> <.> ( ~ z1
                                    | ~ y1 ) )
                        | <.> ( ~ p1
                              | ( [.] z1
                                & <.> [.] y1
                                & <.> <.> ( ~ z1
                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] ( p1
                        | ( [.] z1
                          & <.> [.] y1
                          & <.> <.> ( ~ z1
                                    | ~ y1 ) )
                        | <.> ( ~ p3
                              | ( [.] z3
                                & <.> [.] y3
                                & <.> <.> ( ~ z3
                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] ( p1
                        | ( [.] z1
                          & <.> [.] y1
                          & <.> <.> ( ~ z1
                                    | ~ y1 ) )
                        | <.> ( ~ p5
                              | ( [.] z5
                                & <.> [.] y5
                                & <.> <.> ( ~ z5
                                          | ~ y5 ) ) ) )
      & [.] [.] [.] ( p2
                    | ( [.] z2
                      & <.> [.] y2
                      & <.> <.> ( ~ z2
                                | ~ y2 ) )
                    | <.> ( ~ p2
                          | ( [.] z2
                            & <.> [.] y2
                            & <.> <.> ( ~ z2
                                      | ~ y2 ) ) ) )
      & [.] [.] [.] ( p4
                    | ( [.] z4
                      & <.> [.] y4
                      & <.> <.> ( ~ z4
                                | ~ y4 ) )
                    | <.> ( ~ p2
                          | ( [.] z2
                            & <.> [.] y2
                            & <.> <.> ( ~ z2
                                      | ~ y2 ) ) ) )
      & [.] [.] [.] [.] ( p3
                        | ( [.] z3
                          & <.> [.] y3
                          & <.> <.> ( ~ z3
                                    | ~ y3 ) )
                        | <.> ( ~ p1
                              | ( [.] z1
                                & <.> [.] y1
                                & <.> <.> ( ~ z1
                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] ( p3
                        | ( [.] z3
                          & <.> [.] y3
                          & <.> <.> ( ~ z3
                                    | ~ y3 ) )
                        | <.> ( ~ p3
                              | ( [.] z3
                                & <.> [.] y3
                                & <.> <.> ( ~ z3
                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] ( p3
                        | ( [.] z3
                          & <.> [.] y3
                          & <.> <.> ( ~ z3
                                    | ~ y3 ) )
                        | <.> ( ~ p5
                              | ( [.] z5
                                & <.> [.] y5
                                & <.> <.> ( ~ z5
                                          | ~ y5 ) ) ) )
      & [.] [.] [.] ( p2
                    | ( [.] z2
                      & <.> [.] y2
                      & <.> <.> ( ~ z2
                                | ~ y2 ) )
                    | <.> ( ~ p4
                          | ( [.] z4
                            & <.> [.] y4
                            & <.> <.> ( ~ z4
                                      | ~ y4 ) ) ) )
      & [.] [.] [.] ( p4
                    | ( [.] z4
                      & <.> [.] y4
                      & <.> <.> ( ~ z4
                                | ~ y4 ) )
                    | <.> ( ~ p4
                          | ( [.] z4
                            & <.> [.] y4
                            & <.> <.> ( ~ z4
                                      | ~ y4 ) ) ) )
      & [.] [.] [.] [.] ( p5
                        | ( [.] z5
                          & <.> [.] y5
                          & <.> <.> ( ~ z5
                                    | ~ y5 ) )
                        | <.> ( ~ p1
                              | ( [.] z1
                                & <.> [.] y1
                                & <.> <.> ( ~ z1
                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] ( p5
                        | ( [.] z5
                          & <.> [.] y5
                          & <.> <.> ( ~ z5
                                    | ~ y5 ) )
                        | <.> ( ~ p3
                              | ( [.] z3
                                & <.> [.] y3
                                & <.> <.> ( ~ z3
                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] ( p5
                        | ( [.] z5
                          & <.> [.] y5
                          & <.> <.> ( ~ z5
                                    | ~ y5 ) )
                        | <.> ( ~ p4
                              | ( [.] z4
                                & <.> [.] y4
                                & <.> <.> ( ~ z4
                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] ( p5
                        | ( [.] z5
                          & <.> [.] y5
                          & <.> <.> ( ~ z5
                                    | ~ y5 ) )
                        | <.> ( ~ p5
                              | ( [.] z5
                                & <.> [.] y5
                                & <.> <.> ( ~ z5
                                          | ~ y5 ) ) ) )
      & [.] [.] [.] ( p2
                    | ( [.] z2
                      & <.> [.] y2
                      & <.> <.> ( ~ z2
                                | ~ y2 ) )
                    | <.> ( ~ p6
                          | ( [.] z6
                            & <.> [.] y6
                            & <.> <.> ( ~ z6
                                      | ~ y6 ) ) ) )
      & [.] [.] [.] ( p4
                    | ( [.] z4
                      & <.> [.] y4
                      & <.> <.> ( ~ z4
                                | ~ y4 ) )
                    | <.> ( ~ p6
                          | ( [.] z6
                            & <.> [.] y6
                            & <.> <.> ( ~ z6
                                      | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] ( p1
                            | ( [.] z1
                              & <.> [.] y1
                              & <.> <.> ( ~ z1
                                        | ~ y1 ) )
                            | <.> ( ~ p1
                                  | ( [.] z1
                                    & <.> [.] y1
                                    & <.> <.> ( ~ z1
                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] ( p1
                            | ( [.] z1
                              & <.> [.] y1
                              & <.> <.> ( ~ z1
                                        | ~ y1 ) )
                            | <.> ( ~ p5
                                  | ( [.] z5
                                    & <.> [.] y5
                                    & <.> <.> ( ~ z5
                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] ( p2
                        | ( [.] z2
                          & <.> [.] y2
                          & <.> <.> ( ~ z2
                                    | ~ y2 ) )
                        | <.> ( ~ p2
                              | ( [.] z2
                                & <.> [.] y2
                                & <.> <.> ( ~ z2
                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] ( p4
                        | ( [.] z4
                          & <.> [.] y4
                          & <.> <.> ( ~ z4
                                    | ~ y4 ) )
                        | <.> ( ~ p2
                              | ( [.] z2
                                & <.> [.] y2
                                & <.> <.> ( ~ z2
                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] ( p6
                        | ( [.] z6
                          & <.> [.] y6
                          & <.> <.> ( ~ z6
                                    | ~ y6 ) )
                        | <.> ( ~ p2
                              | ( [.] z2
                                & <.> [.] y2
                                & <.> <.> ( ~ z2
                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] ( p3
                            | ( [.] z3
                              & <.> [.] y3
                              & <.> <.> ( ~ z3
                                        | ~ y3 ) )
                            | <.> ( ~ p1
                                  | ( [.] z1
                                    & <.> [.] y1
                                    & <.> <.> ( ~ z1
                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] ( p3
                            | ( [.] z3
                              & <.> [.] y3
                              & <.> <.> ( ~ z3
                                        | ~ y3 ) )
                            | <.> ( ~ p5
                                  | ( [.] z5
                                    & <.> [.] y5
                                    & <.> <.> ( ~ z5
                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] ( p4
                            | ( [.] z4
                              & <.> [.] y4
                              & <.> <.> ( ~ z4
                                        | ~ y4 ) )
                            | <.> ( ~ p3
                                  | ( [.] z3
                                    & <.> [.] y3
                                    & <.> <.> ( ~ z3
                                              | ~ y3 ) ) ) )
      & [.] [.] [.] [.] ( p2
                        | ( [.] z2
                          & <.> [.] y2
                          & <.> <.> ( ~ z2
                                    | ~ y2 ) )
                        | <.> ( ~ p4
                              | ( [.] z4
                                & <.> [.] y4
                                & <.> <.> ( ~ z4
                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] ( p4
                        | ( [.] z4
                          & <.> [.] y4
                          & <.> <.> ( ~ z4
                                    | ~ y4 ) )
                        | <.> ( ~ p4
                              | ( [.] z4
                                & <.> [.] y4
                                & <.> <.> ( ~ z4
                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] ( p6
                        | ( [.] z6
                          & <.> [.] y6
                          & <.> <.> ( ~ z6
                                    | ~ y6 ) )
                        | <.> ( ~ p4
                              | ( [.] z4
                                & <.> [.] y4
                                & <.> <.> ( ~ z4
                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] ( p5
                            | ( [.] z5
                              & <.> [.] y5
                              & <.> <.> ( ~ z5
                                        | ~ y5 ) )
                            | <.> ( ~ p1
                                  | ( [.] z1
                                    & <.> [.] y1
                                    & <.> <.> ( ~ z1
                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] ( p5
                            | ( [.] z5
                              & <.> [.] y5
                              & <.> <.> ( ~ z5
                                        | ~ y5 ) )
                            | <.> ( ~ p5
                                  | ( [.] z5
                                    & <.> [.] y5
                                    & <.> <.> ( ~ z5
                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] ( p2
                        | ( [.] z2
                          & <.> [.] y2
                          & <.> <.> ( ~ z2
                                    | ~ y2 ) )
                        | <.> ( ~ p6
                              | ( [.] z6
                                & <.> [.] y6
                                & <.> <.> ( ~ z6
                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] ( p4
                        | ( [.] z4
                          & <.> [.] y4
                          & <.> <.> ( ~ z4
                                    | ~ y4 ) )
                        | <.> ( ~ p6
                              | ( [.] z6
                                & <.> [.] y6
                                & <.> <.> ( ~ z6
                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] ( p6
                        | ( [.] z6
                          & <.> [.] y6
                          & <.> <.> ( ~ z6
                                    | ~ y6 ) )
                        | <.> ( ~ p6
                              | ( [.] z6
                                & <.> [.] y6
                                & <.> <.> ( ~ z6
                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p1
                                | ( [.] z1
                                  & <.> [.] y1
                                  & <.> <.> ( ~ z1
                                            | ~ y1 ) )
                                | <.> ( ~ p1
                                      | ( [.] z1
                                        & <.> [.] y1
                                        & <.> <.> ( ~ z1
                                                  | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p1
                                | ( [.] z1
                                  & <.> [.] y1
                                  & <.> <.> ( ~ z1
                                            | ~ y1 ) )
                                | <.> ( ~ p3
                                      | ( [.] z3
                                        & <.> [.] y3
                                        & <.> <.> ( ~ z3
                                                  | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p1
                                | ( [.] z1
                                  & <.> [.] y1
                                  & <.> <.> ( ~ z1
                                            | ~ y1 ) )
                                | <.> ( ~ p5
                                      | ( [.] z5
                                        & <.> [.] y5
                                        & <.> <.> ( ~ z5
                                                  | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] ( p2
                            | ( [.] z2
                              & <.> [.] y2
                              & <.> <.> ( ~ z2
                                        | ~ y2 ) )
                            | <.> ( ~ p2
                                  | ( [.] z2
                                    & <.> [.] y2
                                    & <.> <.> ( ~ z2
                                              | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] ( p6
                            | ( [.] z6
                              & <.> [.] y6
                              & <.> <.> ( ~ z6
                                        | ~ y6 ) )
                            | <.> ( ~ p2
                                  | ( [.] z2
                                    & <.> [.] y2
                                    & <.> <.> ( ~ z2
                                              | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p3
                                | ( [.] z3
                                  & <.> [.] y3
                                  & <.> <.> ( ~ z3
                                            | ~ y3 ) )
                                | <.> ( ~ p1
                                      | ( [.] z1
                                        & <.> [.] y1
                                        & <.> <.> ( ~ z1
                                                  | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p3
                                | ( [.] z3
                                  & <.> [.] y3
                                  & <.> <.> ( ~ z3
                                            | ~ y3 ) )
                                | <.> ( ~ p3
                                      | ( [.] z3
                                        & <.> [.] y3
                                        & <.> <.> ( ~ z3
                                                  | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p3
                                | ( [.] z3
                                  & <.> [.] y3
                                  & <.> <.> ( ~ z3
                                            | ~ y3 ) )
                                | <.> ( ~ p2
                                      | ( [.] z2
                                        & <.> [.] y2
                                        & <.> <.> ( ~ z2
                                                  | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p3
                                | ( [.] z3
                                  & <.> [.] y3
                                  & <.> <.> ( ~ z3
                                            | ~ y3 ) )
                                | <.> ( ~ p5
                                      | ( [.] z5
                                        & <.> [.] y5
                                        & <.> <.> ( ~ z5
                                                  | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] ( p2
                            | ( [.] z2
                              & <.> [.] y2
                              & <.> <.> ( ~ z2
                                        | ~ y2 ) )
                            | <.> ( ~ p4
                                  | ( [.] z4
                                    & <.> [.] y4
                                    & <.> <.> ( ~ z4
                                              | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] ( p6
                            | ( [.] z6
                              & <.> [.] y6
                              & <.> <.> ( ~ z6
                                        | ~ y6 ) )
                            | <.> ( ~ p4
                                  | ( [.] z4
                                    & <.> [.] y4
                                    & <.> <.> ( ~ z4
                                              | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p5
                                | ( [.] z5
                                  & <.> [.] y5
                                  & <.> <.> ( ~ z5
                                            | ~ y5 ) )
                                | <.> ( ~ p1
                                      | ( [.] z1
                                        & <.> [.] y1
                                        & <.> <.> ( ~ z1
                                                  | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p5
                                | ( [.] z5
                                  & <.> [.] y5
                                  & <.> <.> ( ~ z5
                                            | ~ y5 ) )
                                | <.> ( ~ p3
                                      | ( [.] z3
                                        & <.> [.] y3
                                        & <.> <.> ( ~ z3
                                                  | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p5
                                | ( [.] z5
                                  & <.> [.] y5
                                  & <.> <.> ( ~ z5
                                            | ~ y5 ) )
                                | <.> ( ~ p5
                                      | ( [.] z5
                                        & <.> [.] y5
                                        & <.> <.> ( ~ z5
                                                  | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] ( p2
                            | ( [.] z2
                              & <.> [.] y2
                              & <.> <.> ( ~ z2
                                        | ~ y2 ) )
                            | <.> ( ~ p6
                                  | ( [.] z6
                                    & <.> [.] y6
                                    & <.> <.> ( ~ z6
                                              | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] ( p6
                            | ( [.] z6
                              & <.> [.] y6
                              & <.> <.> ( ~ z6
                                        | ~ y6 ) )
                            | <.> ( ~ p6
                                  | ( [.] z6
                                    & <.> [.] y6
                                    & <.> <.> ( ~ z6
                                              | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p1
                                    | ( [.] z1
                                      & <.> [.] y1
                                      & <.> <.> ( ~ z1
                                                | ~ y1 ) )
                                    | <.> ( ~ p3
                                          | ( [.] z3
                                            & <.> [.] y3
                                            & <.> <.> ( ~ z3
                                                      | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p1
                                    | ( [.] z1
                                      & <.> [.] y1
                                      & <.> <.> ( ~ z1
                                                | ~ y1 ) )
                                    | <.> ( ~ p5
                                          | ( [.] z5
                                            & <.> [.] y5
                                            & <.> <.> ( ~ z5
                                                      | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p2
                                    | ( [.] z2
                                      & <.> [.] y2
                                      & <.> <.> ( ~ z2
                                                | ~ y2 ) )
                                    | <.> ( ~ p1
                                          | ( [.] z1
                                            & <.> [.] y1
                                            & <.> <.> ( ~ z1
                                                      | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p2
                                | ( [.] z2
                                  & <.> [.] y2
                                  & <.> <.> ( ~ z2
                                            | ~ y2 ) )
                                | <.> ( ~ p2
                                      | ( [.] z2
                                        & <.> [.] y2
                                        & <.> <.> ( ~ z2
                                                  | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p4
                                | ( [.] z4
                                  & <.> [.] y4
                                  & <.> <.> ( ~ z4
                                            | ~ y4 ) )
                                | <.> ( ~ p2
                                      | ( [.] z2
                                        & <.> [.] y2
                                        & <.> <.> ( ~ z2
                                                  | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p6
                                | ( [.] z6
                                  & <.> [.] y6
                                  & <.> <.> ( ~ z6
                                            | ~ y6 ) )
                                | <.> ( ~ p2
                                      | ( [.] z2
                                        & <.> [.] y2
                                        & <.> <.> ( ~ z2
                                                  | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p3
                                    | ( [.] z3
                                      & <.> [.] y3
                                      & <.> <.> ( ~ z3
                                                | ~ y3 ) )
                                    | <.> ( ~ p3
                                          | ( [.] z3
                                            & <.> [.] y3
                                            & <.> <.> ( ~ z3
                                                      | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p3
                                    | ( [.] z3
                                      & <.> [.] y3
                                      & <.> <.> ( ~ z3
                                                | ~ y3 ) )
                                    | <.> ( ~ p5
                                          | ( [.] z5
                                            & <.> [.] y5
                                            & <.> <.> ( ~ z5
                                                      | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p2
                                | ( [.] z2
                                  & <.> [.] y2
                                  & <.> <.> ( ~ z2
                                            | ~ y2 ) )
                                | <.> ( ~ p4
                                      | ( [.] z4
                                        & <.> [.] y4
                                        & <.> <.> ( ~ z4
                                                  | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p4
                                | ( [.] z4
                                  & <.> [.] y4
                                  & <.> <.> ( ~ z4
                                            | ~ y4 ) )
                                | <.> ( ~ p4
                                      | ( [.] z4
                                        & <.> [.] y4
                                        & <.> <.> ( ~ z4
                                                  | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p6
                                | ( [.] z6
                                  & <.> [.] y6
                                  & <.> <.> ( ~ z6
                                            | ~ y6 ) )
                                | <.> ( ~ p4
                                      | ( [.] z4
                                        & <.> [.] y4
                                        & <.> <.> ( ~ z4
                                                  | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p5
                                    | ( [.] z5
                                      & <.> [.] y5
                                      & <.> <.> ( ~ z5
                                                | ~ y5 ) )
                                    | <.> ( ~ p3
                                          | ( [.] z3
                                            & <.> [.] y3
                                            & <.> <.> ( ~ z3
                                                      | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p5
                                    | ( [.] z5
                                      & <.> [.] y5
                                      & <.> <.> ( ~ z5
                                                | ~ y5 ) )
                                    | <.> ( ~ p5
                                          | ( [.] z5
                                            & <.> [.] y5
                                            & <.> <.> ( ~ z5
                                                      | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p2
                                | ( [.] z2
                                  & <.> [.] y2
                                  & <.> <.> ( ~ z2
                                            | ~ y2 ) )
                                | <.> ( ~ p6
                                      | ( [.] z6
                                        & <.> [.] y6
                                        & <.> <.> ( ~ z6
                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p4
                                | ( [.] z4
                                  & <.> [.] y4
                                  & <.> <.> ( ~ z4
                                            | ~ y4 ) )
                                | <.> ( ~ p6
                                      | ( [.] z6
                                        & <.> [.] y6
                                        & <.> <.> ( ~ z6
                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] ( p6
                                | ( [.] z6
                                  & <.> [.] y6
                                  & <.> <.> ( ~ z6
                                            | ~ y6 ) )
                                | <.> ( ~ p6
                                      | ( [.] z6
                                        & <.> [.] y6
                                        & <.> <.> ( ~ z6
                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                        | ( [.] z1
                                          & <.> [.] y1
                                          & <.> <.> ( ~ z1
                                                    | ~ y1 ) )
                                        | <.> ( ~ p1
                                              | ( [.] z1
                                                & <.> [.] y1
                                                & <.> <.> ( ~ z1
                                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                        | ( [.] z1
                                          & <.> [.] y1
                                          & <.> <.> ( ~ z1
                                                    | ~ y1 ) )
                                        | <.> ( ~ p3
                                              | ( [.] z3
                                                & <.> [.] y3
                                                & <.> <.> ( ~ z3
                                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                        | ( [.] z1
                                          & <.> [.] y1
                                          & <.> <.> ( ~ z1
                                                    | ~ y1 ) )
                                        | <.> ( ~ p6
                                              | ( [.] z6
                                                & <.> [.] y6
                                                & <.> <.> ( ~ z6
                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                        | ( [.] z1
                                          & <.> [.] y1
                                          & <.> <.> ( ~ z1
                                                    | ~ y1 ) )
                                        | <.> ( ~ p5
                                              | ( [.] z5
                                                & <.> [.] y5
                                                & <.> <.> ( ~ z5
                                                          | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p4
                                    | ( [.] z4
                                      & <.> [.] y4
                                      & <.> <.> ( ~ z4
                                                | ~ y4 ) )
                                    | <.> ( ~ p2
                                          | ( [.] z2
                                            & <.> [.] y2
                                            & <.> <.> ( ~ z2
                                                      | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p6
                                    | ( [.] z6
                                      & <.> [.] y6
                                      & <.> <.> ( ~ z6
                                                | ~ y6 ) )
                                    | <.> ( ~ p2
                                          | ( [.] z2
                                            & <.> [.] y2
                                            & <.> <.> ( ~ z2
                                                      | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                        | ( [.] z3
                                          & <.> [.] y3
                                          & <.> <.> ( ~ z3
                                                    | ~ y3 ) )
                                        | <.> ( ~ p1
                                              | ( [.] z1
                                                & <.> [.] y1
                                                & <.> <.> ( ~ z1
                                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                        | ( [.] z3
                                          & <.> [.] y3
                                          & <.> <.> ( ~ z3
                                                    | ~ y3 ) )
                                        | <.> ( ~ p3
                                              | ( [.] z3
                                                & <.> [.] y3
                                                & <.> <.> ( ~ z3
                                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                        | ( [.] z3
                                          & <.> [.] y3
                                          & <.> <.> ( ~ z3
                                                    | ~ y3 ) )
                                        | <.> ( ~ p5
                                              | ( [.] z5
                                                & <.> [.] y5
                                                & <.> <.> ( ~ z5
                                                          | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p4
                                    | ( [.] z4
                                      & <.> [.] y4
                                      & <.> <.> ( ~ z4
                                                | ~ y4 ) )
                                    | <.> ( ~ p4
                                          | ( [.] z4
                                            & <.> [.] y4
                                            & <.> <.> ( ~ z4
                                                      | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p6
                                    | ( [.] z6
                                      & <.> [.] y6
                                      & <.> <.> ( ~ z6
                                                | ~ y6 ) )
                                    | <.> ( ~ p4
                                          | ( [.] z4
                                            & <.> [.] y4
                                            & <.> <.> ( ~ z4
                                                      | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                        | ( [.] z5
                                          & <.> [.] y5
                                          & <.> <.> ( ~ z5
                                                    | ~ y5 ) )
                                        | <.> ( ~ p1
                                              | ( [.] z1
                                                & <.> [.] y1
                                                & <.> <.> ( ~ z1
                                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                        | ( [.] z5
                                          & <.> [.] y5
                                          & <.> <.> ( ~ z5
                                                    | ~ y5 ) )
                                        | <.> ( ~ p3
                                              | ( [.] z3
                                                & <.> [.] y3
                                                & <.> <.> ( ~ z3
                                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                        | ( [.] z5
                                          & <.> [.] y5
                                          & <.> <.> ( ~ z5
                                                    | ~ y5 ) )
                                        | <.> ( ~ p5
                                              | ( [.] z5
                                                & <.> [.] y5
                                                & <.> <.> ( ~ z5
                                                          | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p4
                                    | ( [.] z4
                                      & <.> [.] y4
                                      & <.> <.> ( ~ z4
                                                | ~ y4 ) )
                                    | <.> ( ~ p6
                                          | ( [.] z6
                                            & <.> [.] y6
                                            & <.> <.> ( ~ z6
                                                      | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p6
                                    | ( [.] z6
                                      & <.> [.] y6
                                      & <.> <.> ( ~ z6
                                                | ~ y6 ) )
                                    | <.> ( ~ p6
                                          | ( [.] z6
                                            & <.> [.] y6
                                            & <.> <.> ( ~ z6
                                                      | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                            | ( [.] z1
                                              & <.> [.] y1
                                              & <.> <.> ( ~ z1
                                                        | ~ y1 ) )
                                            | <.> ( ~ p1
                                                  | ( [.] z1
                                                    & <.> [.] y1
                                                    & <.> <.> ( ~ z1
                                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                            | ( [.] z1
                                              & <.> [.] y1
                                              & <.> <.> ( ~ z1
                                                        | ~ y1 ) )
                                            | <.> ( ~ p5
                                                  | ( [.] z5
                                                    & <.> [.] y5
                                                    & <.> <.> ( ~ z5
                                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                        | ( [.] z2
                                          & <.> [.] y2
                                          & <.> <.> ( ~ z2
                                                    | ~ y2 ) )
                                        | <.> ( ~ p2
                                              | ( [.] z2
                                                & <.> [.] y2
                                                & <.> <.> ( ~ z2
                                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                        | ( [.] z4
                                          & <.> [.] y4
                                          & <.> <.> ( ~ z4
                                                    | ~ y4 ) )
                                        | <.> ( ~ p2
                                              | ( [.] z2
                                                & <.> [.] y2
                                                & <.> <.> ( ~ z2
                                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                        | ( [.] z6
                                          & <.> [.] y6
                                          & <.> <.> ( ~ z6
                                                    | ~ y6 ) )
                                        | <.> ( ~ p2
                                              | ( [.] z2
                                                & <.> [.] y2
                                                & <.> <.> ( ~ z2
                                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                            | ( [.] z3
                                              & <.> [.] y3
                                              & <.> <.> ( ~ z3
                                                        | ~ y3 ) )
                                            | <.> ( ~ p1
                                                  | ( [.] z1
                                                    & <.> [.] y1
                                                    & <.> <.> ( ~ z1
                                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                            | ( [.] z3
                                              & <.> [.] y3
                                              & <.> <.> ( ~ z3
                                                        | ~ y3 ) )
                                            | <.> ( ~ p5
                                                  | ( [.] z5
                                                    & <.> [.] y5
                                                    & <.> <.> ( ~ z5
                                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                        | ( [.] z2
                                          & <.> [.] y2
                                          & <.> <.> ( ~ z2
                                                    | ~ y2 ) )
                                        | <.> ( ~ p4
                                              | ( [.] z4
                                                & <.> [.] y4
                                                & <.> <.> ( ~ z4
                                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                        | ( [.] z4
                                          & <.> [.] y4
                                          & <.> <.> ( ~ z4
                                                    | ~ y4 ) )
                                        | <.> ( ~ p4
                                              | ( [.] z4
                                                & <.> [.] y4
                                                & <.> <.> ( ~ z4
                                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                        | ( [.] z6
                                          & <.> [.] y6
                                          & <.> <.> ( ~ z6
                                                    | ~ y6 ) )
                                        | <.> ( ~ p4
                                              | ( [.] z4
                                                & <.> [.] y4
                                                & <.> <.> ( ~ z4
                                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                            | ( [.] z5
                                              & <.> [.] y5
                                              & <.> <.> ( ~ z5
                                                        | ~ y5 ) )
                                            | <.> ( ~ p1
                                                  | ( [.] z1
                                                    & <.> [.] y1
                                                    & <.> <.> ( ~ z1
                                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                            | ( [.] z5
                                              & <.> [.] y5
                                              & <.> <.> ( ~ z5
                                                        | ~ y5 ) )
                                            | <.> ( ~ p5
                                                  | ( [.] z5
                                                    & <.> [.] y5
                                                    & <.> <.> ( ~ z5
                                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                            | ( [.] z6
                                              & <.> [.] y6
                                              & <.> <.> ( ~ z6
                                                        | ~ y6 ) )
                                            | <.> ( ~ p3
                                                  | ( [.] z3
                                                    & <.> [.] y3
                                                    & <.> <.> ( ~ z3
                                                              | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                        | ( [.] z2
                                          & <.> [.] y2
                                          & <.> <.> ( ~ z2
                                                    | ~ y2 ) )
                                        | <.> ( ~ p6
                                              | ( [.] z6
                                                & <.> [.] y6
                                                & <.> <.> ( ~ z6
                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                        | ( [.] z4
                                          & <.> [.] y4
                                          & <.> <.> ( ~ z4
                                                    | ~ y4 ) )
                                        | <.> ( ~ p6
                                              | ( [.] z6
                                                & <.> [.] y6
                                                & <.> <.> ( ~ z6
                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                        | ( [.] z6
                                          & <.> [.] y6
                                          & <.> <.> ( ~ z6
                                                    | ~ y6 ) )
                                        | <.> ( ~ p6
                                              | ( [.] z6
                                                & <.> [.] y6
                                                & <.> <.> ( ~ z6
                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                | ( [.] z1
                                                  & <.> [.] y1
                                                  & <.> <.> ( ~ z1
                                                            | ~ y1 ) )
                                                | <.> ( ~ p1
                                                      | ( [.] z1
                                                        & <.> [.] y1
                                                        & <.> <.> ( ~ z1
                                                                  | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                | ( [.] z1
                                                  & <.> [.] y1
                                                  & <.> <.> ( ~ z1
                                                            | ~ y1 ) )
                                                | <.> ( ~ p3
                                                      | ( [.] z3
                                                        & <.> [.] y3
                                                        & <.> <.> ( ~ z3
                                                                  | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                | ( [.] z1
                                                  & <.> [.] y1
                                                  & <.> <.> ( ~ z1
                                                            | ~ y1 ) )
                                                | <.> ( ~ p5
                                                      | ( [.] z5
                                                        & <.> [.] y5
                                                        & <.> <.> ( ~ z5
                                                                  | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                            | ( [.] z2
                                              & <.> [.] y2
                                              & <.> <.> ( ~ z2
                                                        | ~ y2 ) )
                                            | <.> ( ~ p2
                                                  | ( [.] z2
                                                    & <.> [.] y2
                                                    & <.> <.> ( ~ z2
                                                              | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                            | ( [.] z4
                                              & <.> [.] y4
                                              & <.> <.> ( ~ z4
                                                        | ~ y4 ) )
                                            | <.> ( ~ p2
                                                  | ( [.] z2
                                                    & <.> [.] y2
                                                    & <.> <.> ( ~ z2
                                                              | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                | ( [.] z3
                                                  & <.> [.] y3
                                                  & <.> <.> ( ~ z3
                                                            | ~ y3 ) )
                                                | <.> ( ~ p1
                                                      | ( [.] z1
                                                        & <.> [.] y1
                                                        & <.> <.> ( ~ z1
                                                                  | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                | ( [.] z3
                                                  & <.> [.] y3
                                                  & <.> <.> ( ~ z3
                                                            | ~ y3 ) )
                                                | <.> ( ~ p3
                                                      | ( [.] z3
                                                        & <.> [.] y3
                                                        & <.> <.> ( ~ z3
                                                                  | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                | ( [.] z3
                                                  & <.> [.] y3
                                                  & <.> <.> ( ~ z3
                                                            | ~ y3 ) )
                                                | <.> ( ~ p6
                                                      | ( [.] z6
                                                        & <.> [.] y6
                                                        & <.> <.> ( ~ z6
                                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                | ( [.] z3
                                                  & <.> [.] y3
                                                  & <.> <.> ( ~ z3
                                                            | ~ y3 ) )
                                                | <.> ( ~ p5
                                                      | ( [.] z5
                                                        & <.> [.] y5
                                                        & <.> <.> ( ~ z5
                                                                  | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                            | ( [.] z2
                                              & <.> [.] y2
                                              & <.> <.> ( ~ z2
                                                        | ~ y2 ) )
                                            | <.> ( ~ p4
                                                  | ( [.] z4
                                                    & <.> [.] y4
                                                    & <.> <.> ( ~ z4
                                                              | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                            | ( [.] z4
                                              & <.> [.] y4
                                              & <.> <.> ( ~ z4
                                                        | ~ y4 ) )
                                            | <.> ( ~ p4
                                                  | ( [.] z4
                                                    & <.> [.] y4
                                                    & <.> <.> ( ~ z4
                                                              | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                | ( [.] z5
                                                  & <.> [.] y5
                                                  & <.> <.> ( ~ z5
                                                            | ~ y5 ) )
                                                | <.> ( ~ p1
                                                      | ( [.] z1
                                                        & <.> [.] y1
                                                        & <.> <.> ( ~ z1
                                                                  | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                | ( [.] z5
                                                  & <.> [.] y5
                                                  & <.> <.> ( ~ z5
                                                            | ~ y5 ) )
                                                | <.> ( ~ p3
                                                      | ( [.] z3
                                                        & <.> [.] y3
                                                        & <.> <.> ( ~ z3
                                                                  | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                | ( [.] z5
                                                  & <.> [.] y5
                                                  & <.> <.> ( ~ z5
                                                            | ~ y5 ) )
                                                | <.> ( ~ p5
                                                      | ( [.] z5
                                                        & <.> [.] y5
                                                        & <.> <.> ( ~ z5
                                                                  | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                            | ( [.] z2
                                              & <.> [.] y2
                                              & <.> <.> ( ~ z2
                                                        | ~ y2 ) )
                                            | <.> ( ~ p6
                                                  | ( [.] z6
                                                    & <.> [.] y6
                                                    & <.> <.> ( ~ z6
                                                              | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                            | ( [.] z4
                                              & <.> [.] y4
                                              & <.> <.> ( ~ z4
                                                        | ~ y4 ) )
                                            | <.> ( ~ p6
                                                  | ( [.] z6
                                                    & <.> [.] y6
                                                    & <.> <.> ( ~ z6
                                                              | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                    | ( [.] z1
                                                      & <.> [.] y1
                                                      & <.> <.> ( ~ z1
                                                                | ~ y1 ) )
                                                    | <.> ( ~ p1
                                                          | ( [.] z1
                                                            & <.> [.] y1
                                                            & <.> <.> ( ~ z1
                                                                      | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                    | ( [.] z1
                                                      & <.> [.] y1
                                                      & <.> <.> ( ~ z1
                                                                | ~ y1 ) )
                                                    | <.> ( ~ p5
                                                          | ( [.] z5
                                                            & <.> [.] y5
                                                            & <.> <.> ( ~ z5
                                                                      | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                | ( [.] z2
                                                  & <.> [.] y2
                                                  & <.> <.> ( ~ z2
                                                            | ~ y2 ) )
                                                | <.> ( ~ p2
                                                      | ( [.] z2
                                                        & <.> [.] y2
                                                        & <.> <.> ( ~ z2
                                                                  | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                | ( [.] z4
                                                  & <.> [.] y4
                                                  & <.> <.> ( ~ z4
                                                            | ~ y4 ) )
                                                | <.> ( ~ p2
                                                      | ( [.] z2
                                                        & <.> [.] y2
                                                        & <.> <.> ( ~ z2
                                                                  | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                | ( [.] z6
                                                  & <.> [.] y6
                                                  & <.> <.> ( ~ z6
                                                            | ~ y6 ) )
                                                | <.> ( ~ p2
                                                      | ( [.] z2
                                                        & <.> [.] y2
                                                        & <.> <.> ( ~ z2
                                                                  | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                    | ( [.] z3
                                                      & <.> [.] y3
                                                      & <.> <.> ( ~ z3
                                                                | ~ y3 ) )
                                                    | <.> ( ~ p1
                                                          | ( [.] z1
                                                            & <.> [.] y1
                                                            & <.> <.> ( ~ z1
                                                                      | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                    | ( [.] z3
                                                      & <.> [.] y3
                                                      & <.> <.> ( ~ z3
                                                                | ~ y3 ) )
                                                    | <.> ( ~ p5
                                                          | ( [.] z5
                                                            & <.> [.] y5
                                                            & <.> <.> ( ~ z5
                                                                      | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                | ( [.] z2
                                                  & <.> [.] y2
                                                  & <.> <.> ( ~ z2
                                                            | ~ y2 ) )
                                                | <.> ( ~ p4
                                                      | ( [.] z4
                                                        & <.> [.] y4
                                                        & <.> <.> ( ~ z4
                                                                  | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                | ( [.] z4
                                                  & <.> [.] y4
                                                  & <.> <.> ( ~ z4
                                                            | ~ y4 ) )
                                                | <.> ( ~ p4
                                                      | ( [.] z4
                                                        & <.> [.] y4
                                                        & <.> <.> ( ~ z4
                                                                  | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                | ( [.] z6
                                                  & <.> [.] y6
                                                  & <.> <.> ( ~ z6
                                                            | ~ y6 ) )
                                                | <.> ( ~ p4
                                                      | ( [.] z4
                                                        & <.> [.] y4
                                                        & <.> <.> ( ~ z4
                                                                  | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                    | ( [.] z5
                                                      & <.> [.] y5
                                                      & <.> <.> ( ~ z5
                                                                | ~ y5 ) )
                                                    | <.> ( ~ p1
                                                          | ( [.] z1
                                                            & <.> [.] y1
                                                            & <.> <.> ( ~ z1
                                                                      | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                    | ( [.] z5
                                                      & <.> [.] y5
                                                      & <.> <.> ( ~ z5
                                                                | ~ y5 ) )
                                                    | <.> ( ~ p5
                                                          | ( [.] z5
                                                            & <.> [.] y5
                                                            & <.> <.> ( ~ z5
                                                                      | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                    | ( [.] z6
                                                      & <.> [.] y6
                                                      & <.> <.> ( ~ z6
                                                                | ~ y6 ) )
                                                    | <.> ( ~ p3
                                                          | ( [.] z3
                                                            & <.> [.] y3
                                                            & <.> <.> ( ~ z3
                                                                      | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                | ( [.] z2
                                                  & <.> [.] y2
                                                  & <.> <.> ( ~ z2
                                                            | ~ y2 ) )
                                                | <.> ( ~ p6
                                                      | ( [.] z6
                                                        & <.> [.] y6
                                                        & <.> <.> ( ~ z6
                                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                | ( [.] z4
                                                  & <.> [.] y4
                                                  & <.> <.> ( ~ z4
                                                            | ~ y4 ) )
                                                | <.> ( ~ p6
                                                      | ( [.] z6
                                                        & <.> [.] y6
                                                        & <.> <.> ( ~ z6
                                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                | ( [.] z6
                                                  & <.> [.] y6
                                                  & <.> <.> ( ~ z6
                                                            | ~ y6 ) )
                                                | <.> ( ~ p6
                                                      | ( [.] z6
                                                        & <.> [.] y6
                                                        & <.> <.> ( ~ z6
                                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                        | ( [.] z1
                                                          & <.> [.] y1
                                                          & <.> <.> ( ~ z1
                                                                    | ~ y1 ) )
                                                        | <.> ( ~ p1
                                                              | ( [.] z1
                                                                & <.> [.] y1
                                                                & <.> <.> ( ~ z1
                                                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                        | ( [.] z1
                                                          & <.> [.] y1
                                                          & <.> <.> ( ~ z1
                                                                    | ~ y1 ) )
                                                        | <.> ( ~ p3
                                                              | ( [.] z3
                                                                & <.> [.] y3
                                                                & <.> <.> ( ~ z3
                                                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                        | ( [.] z1
                                                          & <.> [.] y1
                                                          & <.> <.> ( ~ z1
                                                                    | ~ y1 ) )
                                                        | <.> ( ~ p5
                                                              | ( [.] z5
                                                                & <.> [.] y5
                                                                & <.> <.> ( ~ z5
                                                                          | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                    | ( [.] z2
                                                      & <.> [.] y2
                                                      & <.> <.> ( ~ z2
                                                                | ~ y2 ) )
                                                    | <.> ( ~ p2
                                                          | ( [.] z2
                                                            & <.> [.] y2
                                                            & <.> <.> ( ~ z2
                                                                      | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                    | ( [.] z4
                                                      & <.> [.] y4
                                                      & <.> <.> ( ~ z4
                                                                | ~ y4 ) )
                                                    | <.> ( ~ p2
                                                          | ( [.] z2
                                                            & <.> [.] y2
                                                            & <.> <.> ( ~ z2
                                                                      | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                        | ( [.] z3
                                                          & <.> [.] y3
                                                          & <.> <.> ( ~ z3
                                                                    | ~ y3 ) )
                                                        | <.> ( ~ p1
                                                              | ( [.] z1
                                                                & <.> [.] y1
                                                                & <.> <.> ( ~ z1
                                                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                        | ( [.] z3
                                                          & <.> [.] y3
                                                          & <.> <.> ( ~ z3
                                                                    | ~ y3 ) )
                                                        | <.> ( ~ p3
                                                              | ( [.] z3
                                                                & <.> [.] y3
                                                                & <.> <.> ( ~ z3
                                                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                        | ( [.] z3
                                                          & <.> [.] y3
                                                          & <.> <.> ( ~ z3
                                                                    | ~ y3 ) )
                                                        | <.> ( ~ p6
                                                              | ( [.] z6
                                                                & <.> [.] y6
                                                                & <.> <.> ( ~ z6
                                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                        | ( [.] z3
                                                          & <.> [.] y3
                                                          & <.> <.> ( ~ z3
                                                                    | ~ y3 ) )
                                                        | <.> ( ~ p5
                                                              | ( [.] z5
                                                                & <.> [.] y5
                                                                & <.> <.> ( ~ z5
                                                                          | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                    | ( [.] z2
                                                      & <.> [.] y2
                                                      & <.> <.> ( ~ z2
                                                                | ~ y2 ) )
                                                    | <.> ( ~ p4
                                                          | ( [.] z4
                                                            & <.> [.] y4
                                                            & <.> <.> ( ~ z4
                                                                      | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                    | ( [.] z4
                                                      & <.> [.] y4
                                                      & <.> <.> ( ~ z4
                                                                | ~ y4 ) )
                                                    | <.> ( ~ p4
                                                          | ( [.] z4
                                                            & <.> [.] y4
                                                            & <.> <.> ( ~ z4
                                                                      | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                        | ( [.] z5
                                                          & <.> [.] y5
                                                          & <.> <.> ( ~ z5
                                                                    | ~ y5 ) )
                                                        | <.> ( ~ p1
                                                              | ( [.] z1
                                                                & <.> [.] y1
                                                                & <.> <.> ( ~ z1
                                                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                        | ( [.] z5
                                                          & <.> [.] y5
                                                          & <.> <.> ( ~ z5
                                                                    | ~ y5 ) )
                                                        | <.> ( ~ p3
                                                              | ( [.] z3
                                                                & <.> [.] y3
                                                                & <.> <.> ( ~ z3
                                                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                        | ( [.] z5
                                                          & <.> [.] y5
                                                          & <.> <.> ( ~ z5
                                                                    | ~ y5 ) )
                                                        | <.> ( ~ p5
                                                              | ( [.] z5
                                                                & <.> [.] y5
                                                                & <.> <.> ( ~ z5
                                                                          | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                    | ( [.] z2
                                                      & <.> [.] y2
                                                      & <.> <.> ( ~ z2
                                                                | ~ y2 ) )
                                                    | <.> ( ~ p6
                                                          | ( [.] z6
                                                            & <.> [.] y6
                                                            & <.> <.> ( ~ z6
                                                                      | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                    | ( [.] z4
                                                      & <.> [.] y4
                                                      & <.> <.> ( ~ z4
                                                                | ~ y4 ) )
                                                    | <.> ( ~ p6
                                                          | ( [.] z6
                                                            & <.> [.] y6
                                                            & <.> <.> ( ~ z6
                                                                      | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                            | ( [.] z1
                                                              & <.> [.] y1
                                                              & <.> <.> ( ~ z1
                                                                        | ~ y1 ) )
                                                            | <.> ( ~ p1
                                                                  | ( [.] z1
                                                                    & <.> [.] y1
                                                                    & <.> <.> ( ~ z1
                                                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                            | ( [.] z1
                                                              & <.> [.] y1
                                                              & <.> <.> ( ~ z1
                                                                        | ~ y1 ) )
                                                            | <.> ( ~ p5
                                                                  | ( [.] z5
                                                                    & <.> [.] y5
                                                                    & <.> <.> ( ~ z5
                                                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                        | ( [.] z2
                                                          & <.> [.] y2
                                                          & <.> <.> ( ~ z2
                                                                    | ~ y2 ) )
                                                        | <.> ( ~ p2
                                                              | ( [.] z2
                                                                & <.> [.] y2
                                                                & <.> <.> ( ~ z2
                                                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                        | ( [.] z4
                                                          & <.> [.] y4
                                                          & <.> <.> ( ~ z4
                                                                    | ~ y4 ) )
                                                        | <.> ( ~ p2
                                                              | ( [.] z2
                                                                & <.> [.] y2
                                                                & <.> <.> ( ~ z2
                                                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                        | ( [.] z6
                                                          & <.> [.] y6
                                                          & <.> <.> ( ~ z6
                                                                    | ~ y6 ) )
                                                        | <.> ( ~ p2
                                                              | ( [.] z2
                                                                & <.> [.] y2
                                                                & <.> <.> ( ~ z2
                                                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                            | ( [.] z3
                                                              & <.> [.] y3
                                                              & <.> <.> ( ~ z3
                                                                        | ~ y3 ) )
                                                            | <.> ( ~ p1
                                                                  | ( [.] z1
                                                                    & <.> [.] y1
                                                                    & <.> <.> ( ~ z1
                                                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                            | ( [.] z3
                                                              & <.> [.] y3
                                                              & <.> <.> ( ~ z3
                                                                        | ~ y3 ) )
                                                            | <.> ( ~ p5
                                                                  | ( [.] z5
                                                                    & <.> [.] y5
                                                                    & <.> <.> ( ~ z5
                                                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                        | ( [.] z2
                                                          & <.> [.] y2
                                                          & <.> <.> ( ~ z2
                                                                    | ~ y2 ) )
                                                        | <.> ( ~ p4
                                                              | ( [.] z4
                                                                & <.> [.] y4
                                                                & <.> <.> ( ~ z4
                                                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                        | ( [.] z4
                                                          & <.> [.] y4
                                                          & <.> <.> ( ~ z4
                                                                    | ~ y4 ) )
                                                        | <.> ( ~ p4
                                                              | ( [.] z4
                                                                & <.> [.] y4
                                                                & <.> <.> ( ~ z4
                                                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                        | ( [.] z6
                                                          & <.> [.] y6
                                                          & <.> <.> ( ~ z6
                                                                    | ~ y6 ) )
                                                        | <.> ( ~ p4
                                                              | ( [.] z4
                                                                & <.> [.] y4
                                                                & <.> <.> ( ~ z4
                                                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                            | ( [.] z5
                                                              & <.> [.] y5
                                                              & <.> <.> ( ~ z5
                                                                        | ~ y5 ) )
                                                            | <.> ( ~ p1
                                                                  | ( [.] z1
                                                                    & <.> [.] y1
                                                                    & <.> <.> ( ~ z1
                                                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                            | ( [.] z5
                                                              & <.> [.] y5
                                                              & <.> <.> ( ~ z5
                                                                        | ~ y5 ) )
                                                            | <.> ( ~ p5
                                                                  | ( [.] z5
                                                                    & <.> [.] y5
                                                                    & <.> <.> ( ~ z5
                                                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                            | ( [.] z6
                                                              & <.> [.] y6
                                                              & <.> <.> ( ~ z6
                                                                        | ~ y6 ) )
                                                            | <.> ( ~ p3
                                                                  | ( [.] z3
                                                                    & <.> [.] y3
                                                                    & <.> <.> ( ~ z3
                                                                              | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                        | ( [.] z2
                                                          & <.> [.] y2
                                                          & <.> <.> ( ~ z2
                                                                    | ~ y2 ) )
                                                        | <.> ( ~ p6
                                                              | ( [.] z6
                                                                & <.> [.] y6
                                                                & <.> <.> ( ~ z6
                                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                        | ( [.] z4
                                                          & <.> [.] y4
                                                          & <.> <.> ( ~ z4
                                                                    | ~ y4 ) )
                                                        | <.> ( ~ p6
                                                              | ( [.] z6
                                                                & <.> [.] y6
                                                                & <.> <.> ( ~ z6
                                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                        | ( [.] z6
                                                          & <.> [.] y6
                                                          & <.> <.> ( ~ z6
                                                                    | ~ y6 ) )
                                                        | <.> ( ~ p6
                                                              | ( [.] z6
                                                                & <.> [.] y6
                                                                & <.> <.> ( ~ z6
                                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                                | ( [.] z1
                                                                  & <.> [.] y1
                                                                  & <.> <.> ( ~ z1
                                                                            | ~ y1 ) )
                                                                | <.> ( ~ p1
                                                                      | ( [.] z1
                                                                        & <.> [.] y1
                                                                        & <.> <.> ( ~ z1
                                                                                  | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                                | ( [.] z1
                                                                  & <.> [.] y1
                                                                  & <.> <.> ( ~ z1
                                                                            | ~ y1 ) )
                                                                | <.> ( ~ p3
                                                                      | ( [.] z3
                                                                        & <.> [.] y3
                                                                        & <.> <.> ( ~ z3
                                                                                  | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                                | ( [.] z1
                                                                  & <.> [.] y1
                                                                  & <.> <.> ( ~ z1
                                                                            | ~ y1 ) )
                                                                | <.> ( ~ p5
                                                                      | ( [.] z5
                                                                        & <.> [.] y5
                                                                        & <.> <.> ( ~ z5
                                                                                  | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                            | ( [.] z2
                                                              & <.> [.] y2
                                                              & <.> <.> ( ~ z2
                                                                        | ~ y2 ) )
                                                            | <.> ( ~ p2
                                                                  | ( [.] z2
                                                                    & <.> [.] y2
                                                                    & <.> <.> ( ~ z2
                                                                              | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                            | ( [.] z4
                                                              & <.> [.] y4
                                                              & <.> <.> ( ~ z4
                                                                        | ~ y4 ) )
                                                            | <.> ( ~ p2
                                                                  | ( [.] z2
                                                                    & <.> [.] y2
                                                                    & <.> <.> ( ~ z2
                                                                              | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                | ( [.] z3
                                                                  & <.> [.] y3
                                                                  & <.> <.> ( ~ z3
                                                                            | ~ y3 ) )
                                                                | <.> ( ~ p1
                                                                      | ( [.] z1
                                                                        & <.> [.] y1
                                                                        & <.> <.> ( ~ z1
                                                                                  | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                | ( [.] z3
                                                                  & <.> [.] y3
                                                                  & <.> <.> ( ~ z3
                                                                            | ~ y3 ) )
                                                                | <.> ( ~ p3
                                                                      | ( [.] z3
                                                                        & <.> [.] y3
                                                                        & <.> <.> ( ~ z3
                                                                                  | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                | ( [.] z3
                                                                  & <.> [.] y3
                                                                  & <.> <.> ( ~ z3
                                                                            | ~ y3 ) )
                                                                | <.> ( ~ p6
                                                                      | ( [.] z6
                                                                        & <.> [.] y6
                                                                        & <.> <.> ( ~ z6
                                                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                | ( [.] z3
                                                                  & <.> [.] y3
                                                                  & <.> <.> ( ~ z3
                                                                            | ~ y3 ) )
                                                                | <.> ( ~ p5
                                                                      | ( [.] z5
                                                                        & <.> [.] y5
                                                                        & <.> <.> ( ~ z5
                                                                                  | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                            | ( [.] z2
                                                              & <.> [.] y2
                                                              & <.> <.> ( ~ z2
                                                                        | ~ y2 ) )
                                                            | <.> ( ~ p4
                                                                  | ( [.] z4
                                                                    & <.> [.] y4
                                                                    & <.> <.> ( ~ z4
                                                                              | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                            | ( [.] z4
                                                              & <.> [.] y4
                                                              & <.> <.> ( ~ z4
                                                                        | ~ y4 ) )
                                                            | <.> ( ~ p4
                                                                  | ( [.] z4
                                                                    & <.> [.] y4
                                                                    & <.> <.> ( ~ z4
                                                                              | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                                | ( [.] z5
                                                                  & <.> [.] y5
                                                                  & <.> <.> ( ~ z5
                                                                            | ~ y5 ) )
                                                                | <.> ( ~ p1
                                                                      | ( [.] z1
                                                                        & <.> [.] y1
                                                                        & <.> <.> ( ~ z1
                                                                                  | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                                | ( [.] z5
                                                                  & <.> [.] y5
                                                                  & <.> <.> ( ~ z5
                                                                            | ~ y5 ) )
                                                                | <.> ( ~ p3
                                                                      | ( [.] z3
                                                                        & <.> [.] y3
                                                                        & <.> <.> ( ~ z3
                                                                                  | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                                | ( [.] z5
                                                                  & <.> [.] y5
                                                                  & <.> <.> ( ~ z5
                                                                            | ~ y5 ) )
                                                                | <.> ( ~ p5
                                                                      | ( [.] z5
                                                                        & <.> [.] y5
                                                                        & <.> <.> ( ~ z5
                                                                                  | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                            | ( [.] z2
                                                              & <.> [.] y2
                                                              & <.> <.> ( ~ z2
                                                                        | ~ y2 ) )
                                                            | <.> ( ~ p6
                                                                  | ( [.] z6
                                                                    & <.> [.] y6
                                                                    & <.> <.> ( ~ z6
                                                                              | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                            | ( [.] z4
                                                              & <.> [.] y4
                                                              & <.> <.> ( ~ z4
                                                                        | ~ y4 ) )
                                                            | <.> ( ~ p6
                                                                  | ( [.] z6
                                                                    & <.> [.] y6
                                                                    & <.> <.> ( ~ z6
                                                                              | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                                    | ( [.] z1
                                                                      & <.> [.] y1
                                                                      & <.> <.> ( ~ z1
                                                                                | ~ y1 ) )
                                                                    | <.> ( ~ p1
                                                                          | ( [.] z1
                                                                            & <.> [.] y1
                                                                            & <.> <.> ( ~ z1
                                                                                      | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                                    | ( [.] z1
                                                                      & <.> [.] y1
                                                                      & <.> <.> ( ~ z1
                                                                                | ~ y1 ) )
                                                                    | <.> ( ~ p5
                                                                          | ( [.] z5
                                                                            & <.> [.] y5
                                                                            & <.> <.> ( ~ z5
                                                                                      | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                | ( [.] z2
                                                                  & <.> [.] y2
                                                                  & <.> <.> ( ~ z2
                                                                            | ~ y2 ) )
                                                                | <.> ( ~ p2
                                                                      | ( [.] z2
                                                                        & <.> [.] y2
                                                                        & <.> <.> ( ~ z2
                                                                                  | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                | ( [.] z4
                                                                  & <.> [.] y4
                                                                  & <.> <.> ( ~ z4
                                                                            | ~ y4 ) )
                                                                | <.> ( ~ p2
                                                                      | ( [.] z2
                                                                        & <.> [.] y2
                                                                        & <.> <.> ( ~ z2
                                                                                  | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                                | ( [.] z6
                                                                  & <.> [.] y6
                                                                  & <.> <.> ( ~ z6
                                                                            | ~ y6 ) )
                                                                | <.> ( ~ p2
                                                                      | ( [.] z2
                                                                        & <.> [.] y2
                                                                        & <.> <.> ( ~ z2
                                                                                  | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                    | ( [.] z3
                                                                      & <.> [.] y3
                                                                      & <.> <.> ( ~ z3
                                                                                | ~ y3 ) )
                                                                    | <.> ( ~ p1
                                                                          | ( [.] z1
                                                                            & <.> [.] y1
                                                                            & <.> <.> ( ~ z1
                                                                                      | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                    | ( [.] z3
                                                                      & <.> [.] y3
                                                                      & <.> <.> ( ~ z3
                                                                                | ~ y3 ) )
                                                                    | <.> ( ~ p5
                                                                          | ( [.] z5
                                                                            & <.> [.] y5
                                                                            & <.> <.> ( ~ z5
                                                                                      | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                | ( [.] z2
                                                                  & <.> [.] y2
                                                                  & <.> <.> ( ~ z2
                                                                            | ~ y2 ) )
                                                                | <.> ( ~ p4
                                                                      | ( [.] z4
                                                                        & <.> [.] y4
                                                                        & <.> <.> ( ~ z4
                                                                                  | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                | ( [.] z4
                                                                  & <.> [.] y4
                                                                  & <.> <.> ( ~ z4
                                                                            | ~ y4 ) )
                                                                | <.> ( ~ p4
                                                                      | ( [.] z4
                                                                        & <.> [.] y4
                                                                        & <.> <.> ( ~ z4
                                                                                  | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                                | ( [.] z6
                                                                  & <.> [.] y6
                                                                  & <.> <.> ( ~ z6
                                                                            | ~ y6 ) )
                                                                | <.> ( ~ p4
                                                                      | ( [.] z4
                                                                        & <.> [.] y4
                                                                        & <.> <.> ( ~ z4
                                                                                  | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                                    | ( [.] z5
                                                                      & <.> [.] y5
                                                                      & <.> <.> ( ~ z5
                                                                                | ~ y5 ) )
                                                                    | <.> ( ~ p1
                                                                          | ( [.] z1
                                                                            & <.> [.] y1
                                                                            & <.> <.> ( ~ z1
                                                                                      | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                                    | ( [.] z5
                                                                      & <.> [.] y5
                                                                      & <.> <.> ( ~ z5
                                                                                | ~ y5 ) )
                                                                    | <.> ( ~ p5
                                                                          | ( [.] z5
                                                                            & <.> [.] y5
                                                                            & <.> <.> ( ~ z5
                                                                                      | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                                    | ( [.] z6
                                                                      & <.> [.] y6
                                                                      & <.> <.> ( ~ z6
                                                                                | ~ y6 ) )
                                                                    | <.> ( ~ p3
                                                                          | ( [.] z3
                                                                            & <.> [.] y3
                                                                            & <.> <.> ( ~ z3
                                                                                      | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                | ( [.] z2
                                                                  & <.> [.] y2
                                                                  & <.> <.> ( ~ z2
                                                                            | ~ y2 ) )
                                                                | <.> ( ~ p6
                                                                      | ( [.] z6
                                                                        & <.> [.] y6
                                                                        & <.> <.> ( ~ z6
                                                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                | ( [.] z4
                                                                  & <.> [.] y4
                                                                  & <.> <.> ( ~ z4
                                                                            | ~ y4 ) )
                                                                | <.> ( ~ p6
                                                                      | ( [.] z6
                                                                        & <.> [.] y6
                                                                        & <.> <.> ( ~ z6
                                                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                                | ( [.] z6
                                                                  & <.> [.] y6
                                                                  & <.> <.> ( ~ z6
                                                                            | ~ y6 ) )
                                                                | <.> ( ~ p6
                                                                      | ( [.] z6
                                                                        & <.> [.] y6
                                                                        & <.> <.> ( ~ z6
                                                                                  | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                                        | ( [.] z1
                                                                          & <.> [.] y1
                                                                          & <.> <.> ( ~ z1
                                                                                    | ~ y1 ) )
                                                                        | <.> ( ~ p1
                                                                              | ( [.] z1
                                                                                & <.> [.] y1
                                                                                & <.> <.> ( ~ z1
                                                                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                                        | ( [.] z1
                                                                          & <.> [.] y1
                                                                          & <.> <.> ( ~ z1
                                                                                    | ~ y1 ) )
                                                                        | <.> ( ~ p3
                                                                              | ( [.] z3
                                                                                & <.> [.] y3
                                                                                & <.> <.> ( ~ z3
                                                                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                                        | ( [.] z1
                                                                          & <.> [.] y1
                                                                          & <.> <.> ( ~ z1
                                                                                    | ~ y1 ) )
                                                                        | <.> ( ~ p5
                                                                              | ( [.] z5
                                                                                & <.> [.] y5
                                                                                & <.> <.> ( ~ z5
                                                                                          | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                    | ( [.] z2
                                                                      & <.> [.] y2
                                                                      & <.> <.> ( ~ z2
                                                                                | ~ y2 ) )
                                                                    | <.> ( ~ p2
                                                                          | ( [.] z2
                                                                            & <.> [.] y2
                                                                            & <.> <.> ( ~ z2
                                                                                      | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                    | ( [.] z4
                                                                      & <.> [.] y4
                                                                      & <.> <.> ( ~ z4
                                                                                | ~ y4 ) )
                                                                    | <.> ( ~ p2
                                                                          | ( [.] z2
                                                                            & <.> [.] y2
                                                                            & <.> <.> ( ~ z2
                                                                                      | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                        | ( [.] z3
                                                                          & <.> [.] y3
                                                                          & <.> <.> ( ~ z3
                                                                                    | ~ y3 ) )
                                                                        | <.> ( ~ p1
                                                                              | ( [.] z1
                                                                                & <.> [.] y1
                                                                                & <.> <.> ( ~ z1
                                                                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                        | ( [.] z3
                                                                          & <.> [.] y3
                                                                          & <.> <.> ( ~ z3
                                                                                    | ~ y3 ) )
                                                                        | <.> ( ~ p3
                                                                              | ( [.] z3
                                                                                & <.> [.] y3
                                                                                & <.> <.> ( ~ z3
                                                                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                        | ( [.] z3
                                                                          & <.> [.] y3
                                                                          & <.> <.> ( ~ z3
                                                                                    | ~ y3 ) )
                                                                        | <.> ( ~ p6
                                                                              | ( [.] z6
                                                                                & <.> [.] y6
                                                                                & <.> <.> ( ~ z6
                                                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                        | ( [.] z3
                                                                          & <.> [.] y3
                                                                          & <.> <.> ( ~ z3
                                                                                    | ~ y3 ) )
                                                                        | <.> ( ~ p5
                                                                              | ( [.] z5
                                                                                & <.> [.] y5
                                                                                & <.> <.> ( ~ z5
                                                                                          | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                    | ( [.] z2
                                                                      & <.> [.] y2
                                                                      & <.> <.> ( ~ z2
                                                                                | ~ y2 ) )
                                                                    | <.> ( ~ p4
                                                                          | ( [.] z4
                                                                            & <.> [.] y4
                                                                            & <.> <.> ( ~ z4
                                                                                      | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                    | ( [.] z4
                                                                      & <.> [.] y4
                                                                      & <.> <.> ( ~ z4
                                                                                | ~ y4 ) )
                                                                    | <.> ( ~ p4
                                                                          | ( [.] z4
                                                                            & <.> [.] y4
                                                                            & <.> <.> ( ~ z4
                                                                                      | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                                        | ( [.] z5
                                                                          & <.> [.] y5
                                                                          & <.> <.> ( ~ z5
                                                                                    | ~ y5 ) )
                                                                        | <.> ( ~ p1
                                                                              | ( [.] z1
                                                                                & <.> [.] y1
                                                                                & <.> <.> ( ~ z1
                                                                                          | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                                        | ( [.] z5
                                                                          & <.> [.] y5
                                                                          & <.> <.> ( ~ z5
                                                                                    | ~ y5 ) )
                                                                        | <.> ( ~ p3
                                                                              | ( [.] z3
                                                                                & <.> [.] y3
                                                                                & <.> <.> ( ~ z3
                                                                                          | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                                        | ( [.] z5
                                                                          & <.> [.] y5
                                                                          & <.> <.> ( ~ z5
                                                                                    | ~ y5 ) )
                                                                        | <.> ( ~ p5
                                                                              | ( [.] z5
                                                                                & <.> [.] y5
                                                                                & <.> <.> ( ~ z5
                                                                                          | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                    | ( [.] z2
                                                                      & <.> [.] y2
                                                                      & <.> <.> ( ~ z2
                                                                                | ~ y2 ) )
                                                                    | <.> ( ~ p6
                                                                          | ( [.] z6
                                                                            & <.> [.] y6
                                                                            & <.> <.> ( ~ z6
                                                                                      | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                    | ( [.] z4
                                                                      & <.> [.] y4
                                                                      & <.> <.> ( ~ z4
                                                                                | ~ y4 ) )
                                                                    | <.> ( ~ p6
                                                                          | ( [.] z6
                                                                            & <.> [.] y6
                                                                            & <.> <.> ( ~ z6
                                                                                      | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                                            | ( [.] z1
                                                                              & <.> [.] y1
                                                                              & <.> <.> ( ~ z1
                                                                                        | ~ y1 ) )
                                                                            | <.> ( ~ p1
                                                                                  | ( [.] z1
                                                                                    & <.> [.] y1
                                                                                    & <.> <.> ( ~ z1
                                                                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                                            | ( [.] z1
                                                                              & <.> [.] y1
                                                                              & <.> <.> ( ~ z1
                                                                                        | ~ y1 ) )
                                                                            | <.> ( ~ p5
                                                                                  | ( [.] z5
                                                                                    & <.> [.] y5
                                                                                    & <.> <.> ( ~ z5
                                                                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                        | ( [.] z2
                                                                          & <.> [.] y2
                                                                          & <.> <.> ( ~ z2
                                                                                    | ~ y2 ) )
                                                                        | <.> ( ~ p2
                                                                              | ( [.] z2
                                                                                & <.> [.] y2
                                                                                & <.> <.> ( ~ z2
                                                                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                        | ( [.] z4
                                                                          & <.> [.] y4
                                                                          & <.> <.> ( ~ z4
                                                                                    | ~ y4 ) )
                                                                        | <.> ( ~ p2
                                                                              | ( [.] z2
                                                                                & <.> [.] y2
                                                                                & <.> <.> ( ~ z2
                                                                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                                        | ( [.] z6
                                                                          & <.> [.] y6
                                                                          & <.> <.> ( ~ z6
                                                                                    | ~ y6 ) )
                                                                        | <.> ( ~ p2
                                                                              | ( [.] z2
                                                                                & <.> [.] y2
                                                                                & <.> <.> ( ~ z2
                                                                                          | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                            | ( [.] z3
                                                                              & <.> [.] y3
                                                                              & <.> <.> ( ~ z3
                                                                                        | ~ y3 ) )
                                                                            | <.> ( ~ p1
                                                                                  | ( [.] z1
                                                                                    & <.> [.] y1
                                                                                    & <.> <.> ( ~ z1
                                                                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                            | ( [.] z3
                                                                              & <.> [.] y3
                                                                              & <.> <.> ( ~ z3
                                                                                        | ~ y3 ) )
                                                                            | <.> ( ~ p5
                                                                                  | ( [.] z5
                                                                                    & <.> [.] y5
                                                                                    & <.> <.> ( ~ z5
                                                                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                        | ( [.] z2
                                                                          & <.> [.] y2
                                                                          & <.> <.> ( ~ z2
                                                                                    | ~ y2 ) )
                                                                        | <.> ( ~ p4
                                                                              | ( [.] z4
                                                                                & <.> [.] y4
                                                                                & <.> <.> ( ~ z4
                                                                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                        | ( [.] z4
                                                                          & <.> [.] y4
                                                                          & <.> <.> ( ~ z4
                                                                                    | ~ y4 ) )
                                                                        | <.> ( ~ p4
                                                                              | ( [.] z4
                                                                                & <.> [.] y4
                                                                                & <.> <.> ( ~ z4
                                                                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                                        | ( [.] z6
                                                                          & <.> [.] y6
                                                                          & <.> <.> ( ~ z6
                                                                                    | ~ y6 ) )
                                                                        | <.> ( ~ p4
                                                                              | ( [.] z4
                                                                                & <.> [.] y4
                                                                                & <.> <.> ( ~ z4
                                                                                          | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                                            | ( [.] z5
                                                                              & <.> [.] y5
                                                                              & <.> <.> ( ~ z5
                                                                                        | ~ y5 ) )
                                                                            | <.> ( ~ p1
                                                                                  | ( [.] z1
                                                                                    & <.> [.] y1
                                                                                    & <.> <.> ( ~ z1
                                                                                              | ~ y1 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                                                            | ( [.] z5
                                                                              & <.> [.] y5
                                                                              & <.> <.> ( ~ z5
                                                                                        | ~ y5 ) )
                                                                            | <.> ( ~ p5
                                                                                  | ( [.] z5
                                                                                    & <.> [.] y5
                                                                                    & <.> <.> ( ~ z5
                                                                                              | ~ y5 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                                            | ( [.] z6
                                                                              & <.> [.] y6
                                                                              & <.> <.> ( ~ z6
                                                                                        | ~ y6 ) )
                                                                            | <.> ( ~ p3
                                                                                  | ( [.] z3
                                                                                    & <.> [.] y3
                                                                                    & <.> <.> ( ~ z3
                                                                                              | ~ y3 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                        | ( [.] z2
                                                                          & <.> [.] y2
                                                                          & <.> <.> ( ~ z2
                                                                                    | ~ y2 ) )
                                                                        | <.> ( ~ p6
                                                                              | ( [.] z6
                                                                                & <.> [.] y6
                                                                                & <.> <.> ( ~ z6
                                                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                        | ( [.] z4
                                                                          & <.> [.] y4
                                                                          & <.> <.> ( ~ z4
                                                                                    | ~ y4 ) )
                                                                        | <.> ( ~ p6
                                                                              | ( [.] z6
                                                                                & <.> [.] y6
                                                                                & <.> <.> ( ~ z6
                                                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                                        | ( [.] z6
                                                                          & <.> [.] y6
                                                                          & <.> <.> ( ~ z6
                                                                                    | ~ y6 ) )
                                                                        | <.> ( ~ p6
                                                                              | ( [.] z6
                                                                                & <.> [.] y6
                                                                                & <.> <.> ( ~ z6
                                                                                          | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                            | ( [.] z2
                                                                              & <.> [.] y2
                                                                              & <.> <.> ( ~ z2
                                                                                        | ~ y2 ) )
                                                                            | <.> ( ~ p2
                                                                                  | ( [.] z2
                                                                                    & <.> [.] y2
                                                                                    & <.> <.> ( ~ z2
                                                                                              | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                            | ( [.] z4
                                                                              & <.> [.] y4
                                                                              & <.> <.> ( ~ z4
                                                                                        | ~ y4 ) )
                                                                            | <.> ( ~ p2
                                                                                  | ( [.] z2
                                                                                    & <.> [.] y2
                                                                                    & <.> <.> ( ~ z2
                                                                                              | ~ y2 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                            | ( [.] z2
                                                                              & <.> [.] y2
                                                                              & <.> <.> ( ~ z2
                                                                                        | ~ y2 ) )
                                                                            | <.> ( ~ p4
                                                                                  | ( [.] z4
                                                                                    & <.> [.] y4
                                                                                    & <.> <.> ( ~ z4
                                                                                              | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                            | ( [.] z4
                                                                              & <.> [.] y4
                                                                              & <.> <.> ( ~ z4
                                                                                        | ~ y4 ) )
                                                                            | <.> ( ~ p4
                                                                                  | ( [.] z4
                                                                                    & <.> [.] y4
                                                                                    & <.> <.> ( ~ z4
                                                                                              | ~ y4 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                            | ( [.] z2
                                                                              & <.> [.] y2
                                                                              & <.> <.> ( ~ z2
                                                                                        | ~ y2 ) )
                                                                            | <.> ( ~ p6
                                                                                  | ( [.] z6
                                                                                    & <.> [.] y6
                                                                                    & <.> <.> ( ~ z6
                                                                                              | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                            | ( [.] z4
                                                                              & <.> [.] y4
                                                                              & <.> <.> ( ~ z4
                                                                                        | ~ y4 ) )
                                                                            | <.> ( ~ p6
                                                                                  | ( [.] z6
                                                                                    & <.> [.] y6
                                                                                    & <.> <.> ( ~ z6
                                                                                              | ~ y6 ) ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                                                | ( [.] z2
                                                                                  & <.> [.] y2
                                                                                  & <.> <.> ( ~ z2
                                                                                            | ~ y2 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                                                | ( [.] z4
                                                                                  & <.> [.] y4
                                                                                  & <.> <.> ( ~ z4
                                                                                            | ~ y4 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                                                                | ( [.] z3
                                                                                  & <.> [.] y3
                                                                                  & <.> <.> ( ~ z3
                                                                                            | ~ y3 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                                                | ( [.] z6
                                                                                  & <.> [.] y6
                                                                                  & <.> <.> ( ~ z6
                                                                                            | ~ y6 ) ) ) ) ).

%------------------------------------------------------------------------------
