%------------------------------------------------------------------------------
% File     : PLA056_1.010 : TPTP v9.2.0. Released v9.0.0.
% Domain   : Planning
% Problem  : Path from the entry to the exit of a labyrinth 10
% Version  : Especial.
% English  : The formula is the path from the entry to the exit of a
%            labyrinth. It makes no difference whether one starts at the
%            entry or at the exit.

% Refs     : [BHS00] Balsiger et al. (2000), A Benchmark Method for the Pro
%          : [NH+22] Nalon et al. (2022), Local Reductions for the Modal Cu
%          : [Nal22] Nalon (2022), Email to Geoff Sutcliffe
%          : [NH+23] Nalon et al. (2023), Buy One Get 14 Free: Evaluating L
% Source   : [Nal22]
% Names    : k4_path_p.0010 [Nal22]

% Status   : Theorem
% Rating   : 1.00 v9.1.0, 0.50 v9.0.0
% Syntax   : Number of formulae    :   13 (   0 unt;  12 typ;   0 def)
%            Number of atoms       :  870 (   0 equ)
%            Maximal formula atoms :  870 ( 870 avg)
%            Number of connectives : 3065 ( 436   ~; 431   |; 438   &)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%                                         (1760 {.};   0 {#})
%            Maximal formula depth :  165 ( 165 avg)
%            Maximal term depth    :    0 (   0 avg)
%            Number of types       :    1 (   0 usr)
%            Number of type conns  :    0 (   0   >;   0   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  12 usr;  12 prp; 0-0 aty)
%            Number of functors    :    0 (   0 usr;   0 con; --- aty)
%            Number of variables   :    0 (;   0   !;   0   ?;   0   :)
% SPC      : NX0_THM_PRP_NEQ_NAR

% Comments :
%------------------------------------------------------------------------------
tff('k4_path_p.0010',logic,
    $modal == 
      [ $modalities == $modal_system_K4 ] ).

tff(p1_decl,type,
    p1: $o ).

tff(p2_decl,type,
    p2: $o ).

tff(p3_decl,type,
    p3: $o ).

tff(p4_decl,type,
    p4: $o ).

tff(p5_decl,type,
    p5: $o ).

tff(p6_decl,type,
    p6: $o ).

tff(z1_decl,type,
    z1: $o ).

tff(z2_decl,type,
    z2: $o ).

tff(z3_decl,type,
    z3: $o ).

tff(z4_decl,type,
    z4: $o ).

tff(z5_decl,type,
    z5: $o ).

tff(z6_decl,type,
    z6: $o ).

tff(prove,conjecture,
    ~ ( <.> ( ~ p1
            | ( [.] z1
              & <.> <.> ~ z1 ) )
      & <.> ( ~ p2
            | ( [.] z2
              & <.> <.> ~ z2 ) )
      & <.> ( ~ p3
            | ( [.] z3
              & <.> <.> ~ z3 ) )
      & <.> ( ~ p5
            | ( [.] z5
              & <.> <.> ~ z5 ) )
      & [.] ( p1
            | ( [.] z1
              & <.> <.> ~ z1 )
            | <.> ( ~ p3
                  | ( [.] z3
                    & <.> <.> ~ z3 ) ) )
      & [.] ( p1
            | ( [.] z1
              & <.> <.> ~ z1 )
            | <.> ( ~ p5
                  | ( [.] z5
                    & <.> <.> ~ z5 ) ) )
      & [.] ( p2
            | ( [.] z2
              & <.> <.> ~ z2 )
            | <.> ( ~ p1
                  | ( [.] z1
                    & <.> <.> ~ z1 ) ) )
      & [.] ( p3
            | ( [.] z3
              & <.> <.> ~ z3 )
            | <.> ( ~ p3
                  | ( [.] z3
                    & <.> <.> ~ z3 ) ) )
      & [.] ( p3
            | ( [.] z3
              & <.> <.> ~ z3 )
            | <.> ( ~ p5
                  | ( [.] z5
                    & <.> <.> ~ z5 ) ) )
      & [.] ( p5
            | ( [.] z5
              & <.> <.> ~ z5 )
            | <.> ( ~ p3
                  | ( [.] z3
                    & <.> <.> ~ z3 ) ) )
      & [.] ( p5
            | ( [.] z5
              & <.> <.> ~ z5 )
            | <.> ( ~ p5
                  | ( [.] z5
                    & <.> <.> ~ z5 ) ) )
      & [.] [.] ( p1
                | ( [.] z1
                  & <.> <.> ~ z1 )
                | <.> ( ~ p1
                      | ( [.] z1
                        & <.> <.> ~ z1 ) ) )
      & [.] [.] ( p1
                | ( [.] z1
                  & <.> <.> ~ z1 )
                | <.> ( ~ p3
                      | ( [.] z3
                        & <.> <.> ~ z3 ) ) )
      & [.] [.] ( p1
                | ( [.] z1
                  & <.> <.> ~ z1 )
                | <.> ( ~ p6
                      | ( [.] z6
                        & <.> <.> ~ z6 ) ) )
      & [.] [.] ( p1
                | ( [.] z1
                  & <.> <.> ~ z1 )
                | <.> ( ~ p5
                      | ( [.] z5
                        & <.> <.> ~ z5 ) ) )
      & [.] ( p4
            | ( [.] z4
              & <.> <.> ~ z4 )
            | <.> ( ~ p2
                  | ( [.] z2
                    & <.> <.> ~ z2 ) ) )
      & [.] ( p6
            | ( [.] z6
              & <.> <.> ~ z6 )
            | <.> ( ~ p2
                  | ( [.] z2
                    & <.> <.> ~ z2 ) ) )
      & [.] [.] ( p3
                | ( [.] z3
                  & <.> <.> ~ z3 )
                | <.> ( ~ p1
                      | ( [.] z1
                        & <.> <.> ~ z1 ) ) )
      & [.] [.] ( p3
                | ( [.] z3
                  & <.> <.> ~ z3 )
                | <.> ( ~ p3
                      | ( [.] z3
                        & <.> <.> ~ z3 ) ) )
      & [.] [.] ( p3
                | ( [.] z3
                  & <.> <.> ~ z3 )
                | <.> ( ~ p5
                      | ( [.] z5
                        & <.> <.> ~ z5 ) ) )
      & [.] ( p4
            | ( [.] z4
              & <.> <.> ~ z4 )
            | <.> ( ~ p4
                  | ( [.] z4
                    & <.> <.> ~ z4 ) ) )
      & [.] ( p6
            | ( [.] z6
              & <.> <.> ~ z6 )
            | <.> ( ~ p4
                  | ( [.] z4
                    & <.> <.> ~ z4 ) ) )
      & [.] [.] ( p5
                | ( [.] z5
                  & <.> <.> ~ z5 )
                | <.> ( ~ p1
                      | ( [.] z1
                        & <.> <.> ~ z1 ) ) )
      & [.] [.] ( p5
                | ( [.] z5
                  & <.> <.> ~ z5 )
                | <.> ( ~ p3
                      | ( [.] z3
                        & <.> <.> ~ z3 ) ) )
      & [.] [.] ( p5
                | ( [.] z5
                  & <.> <.> ~ z5 )
                | <.> ( ~ p5
                      | ( [.] z5
                        & <.> <.> ~ z5 ) ) )
      & [.] ( p4
            | ( [.] z4
              & <.> <.> ~ z4 )
            | <.> ( ~ p6
                  | ( [.] z6
                    & <.> <.> ~ z6 ) ) )
      & [.] ( p6
            | ( [.] z6
              & <.> <.> ~ z6 )
            | <.> ( ~ p6
                  | ( [.] z6
                    & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] ( p1
                    | ( [.] z1
                      & <.> <.> ~ z1 )
                    | <.> ( ~ p1
                          | ( [.] z1
                            & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] ( p1
                    | ( [.] z1
                      & <.> <.> ~ z1 )
                    | <.> ( ~ p3
                          | ( [.] z3
                            & <.> <.> ~ z3 ) ) )
      & [.] [.] ( p2
                | ( [.] z2
                  & <.> <.> ~ z2 )
                | <.> ( ~ p2
                      | ( [.] z2
                        & <.> <.> ~ z2 ) ) )
      & [.] [.] ( p4
                | ( [.] z4
                  & <.> <.> ~ z4 )
                | <.> ( ~ p2
                      | ( [.] z2
                        & <.> <.> ~ z2 ) ) )
      & [.] [.] ( p6
                | ( [.] z6
                  & <.> <.> ~ z6 )
                | <.> ( ~ p2
                      | ( [.] z2
                        & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] ( p3
                    | ( [.] z3
                      & <.> <.> ~ z3 )
                    | <.> ( ~ p1
                          | ( [.] z1
                            & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] ( p3
                    | ( [.] z3
                      & <.> <.> ~ z3 )
                    | <.> ( ~ p3
                          | ( [.] z3
                            & <.> <.> ~ z3 ) ) )
      & [.] [.] ( p2
                | ( [.] z2
                  & <.> <.> ~ z2 )
                | <.> ( ~ p4
                      | ( [.] z4
                        & <.> <.> ~ z4 ) ) )
      & [.] [.] ( p4
                | ( [.] z4
                  & <.> <.> ~ z4 )
                | <.> ( ~ p4
                      | ( [.] z4
                        & <.> <.> ~ z4 ) ) )
      & [.] [.] ( p6
                | ( [.] z6
                  & <.> <.> ~ z6 )
                | <.> ( ~ p4
                      | ( [.] z4
                        & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] ( p5
                    | ( [.] z5
                      & <.> <.> ~ z5 )
                    | <.> ( ~ p1
                          | ( [.] z1
                            & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] ( p5
                    | ( [.] z5
                      & <.> <.> ~ z5 )
                    | <.> ( ~ p3
                          | ( [.] z3
                            & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] ( p6
                    | ( [.] z6
                      & <.> <.> ~ z6 )
                    | <.> ( ~ p5
                          | ( [.] z5
                            & <.> <.> ~ z5 ) ) )
      & [.] [.] ( p2
                | ( [.] z2
                  & <.> <.> ~ z2 )
                | <.> ( ~ p6
                      | ( [.] z6
                        & <.> <.> ~ z6 ) ) )
      & [.] [.] ( p4
                | ( [.] z4
                  & <.> <.> ~ z4 )
                | <.> ( ~ p6
                      | ( [.] z6
                        & <.> <.> ~ z6 ) ) )
      & [.] [.] ( p6
                | ( [.] z6
                  & <.> <.> ~ z6 )
                | <.> ( ~ p6
                      | ( [.] z6
                        & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] ( p1
                        | ( [.] z1
                          & <.> <.> ~ z1 )
                        | <.> ( ~ p1
                              | ( [.] z1
                                & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] ( p1
                        | ( [.] z1
                          & <.> <.> ~ z1 )
                        | <.> ( ~ p3
                              | ( [.] z3
                                & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] ( p1
                        | ( [.] z1
                          & <.> <.> ~ z1 )
                        | <.> ( ~ p5
                              | ( [.] z5
                                & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] ( p2
                    | ( [.] z2
                      & <.> <.> ~ z2 )
                    | <.> ( ~ p2
                          | ( [.] z2
                            & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] ( p4
                    | ( [.] z4
                      & <.> <.> ~ z4 )
                    | <.> ( ~ p2
                          | ( [.] z2
                            & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] ( p3
                        | ( [.] z3
                          & <.> <.> ~ z3 )
                        | <.> ( ~ p1
                              | ( [.] z1
                                & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] ( p3
                        | ( [.] z3
                          & <.> <.> ~ z3 )
                        | <.> ( ~ p3
                              | ( [.] z3
                                & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] ( p3
                        | ( [.] z3
                          & <.> <.> ~ z3 )
                        | <.> ( ~ p5
                              | ( [.] z5
                                & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] ( p2
                    | ( [.] z2
                      & <.> <.> ~ z2 )
                    | <.> ( ~ p4
                          | ( [.] z4
                            & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] ( p4
                    | ( [.] z4
                      & <.> <.> ~ z4 )
                    | <.> ( ~ p4
                          | ( [.] z4
                            & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] ( p5
                        | ( [.] z5
                          & <.> <.> ~ z5 )
                        | <.> ( ~ p1
                              | ( [.] z1
                                & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] ( p5
                        | ( [.] z5
                          & <.> <.> ~ z5 )
                        | <.> ( ~ p3
                              | ( [.] z3
                                & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] ( p5
                        | ( [.] z5
                          & <.> <.> ~ z5 )
                        | <.> ( ~ p4
                              | ( [.] z4
                                & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] ( p5
                        | ( [.] z5
                          & <.> <.> ~ z5 )
                        | <.> ( ~ p5
                              | ( [.] z5
                                & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] ( p2
                    | ( [.] z2
                      & <.> <.> ~ z2 )
                    | <.> ( ~ p6
                          | ( [.] z6
                            & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] ( p4
                    | ( [.] z4
                      & <.> <.> ~ z4 )
                    | <.> ( ~ p6
                          | ( [.] z6
                            & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] ( p1
                            | ( [.] z1
                              & <.> <.> ~ z1 )
                            | <.> ( ~ p3
                                  | ( [.] z3
                                    & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] ( p1
                            | ( [.] z1
                              & <.> <.> ~ z1 )
                            | <.> ( ~ p5
                                  | ( [.] z5
                                    & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] ( p2
                        | ( [.] z2
                          & <.> <.> ~ z2 )
                        | <.> ( ~ p2
                              | ( [.] z2
                                & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] ( p4
                        | ( [.] z4
                          & <.> <.> ~ z4 )
                        | <.> ( ~ p2
                              | ( [.] z2
                                & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] ( p6
                        | ( [.] z6
                          & <.> <.> ~ z6 )
                        | <.> ( ~ p2
                              | ( [.] z2
                                & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] ( p3
                            | ( [.] z3
                              & <.> <.> ~ z3 )
                            | <.> ( ~ p3
                                  | ( [.] z3
                                    & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] ( p3
                            | ( [.] z3
                              & <.> <.> ~ z3 )
                            | <.> ( ~ p5
                                  | ( [.] z5
                                    & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] ( p4
                            | ( [.] z4
                              & <.> <.> ~ z4 )
                            | <.> ( ~ p1
                                  | ( [.] z1
                                    & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] ( p2
                        | ( [.] z2
                          & <.> <.> ~ z2 )
                        | <.> ( ~ p4
                              | ( [.] z4
                                & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] ( p4
                        | ( [.] z4
                          & <.> <.> ~ z4 )
                        | <.> ( ~ p4
                              | ( [.] z4
                                & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] ( p6
                        | ( [.] z6
                          & <.> <.> ~ z6 )
                        | <.> ( ~ p4
                              | ( [.] z4
                                & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] ( p5
                            | ( [.] z5
                              & <.> <.> ~ z5 )
                            | <.> ( ~ p3
                                  | ( [.] z3
                                    & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] ( p5
                            | ( [.] z5
                              & <.> <.> ~ z5 )
                            | <.> ( ~ p5
                                  | ( [.] z5
                                    & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] ( p2
                        | ( [.] z2
                          & <.> <.> ~ z2 )
                        | <.> ( ~ p6
                              | ( [.] z6
                                & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] ( p4
                        | ( [.] z4
                          & <.> <.> ~ z4 )
                        | <.> ( ~ p6
                              | ( [.] z6
                                & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] ( p6
                        | ( [.] z6
                          & <.> <.> ~ z6 )
                        | <.> ( ~ p6
                              | ( [.] z6
                                & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p1
                                | ( [.] z1
                                  & <.> <.> ~ z1 )
                                | <.> ( ~ p1
                                      | ( [.] z1
                                        & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p1
                                | ( [.] z1
                                  & <.> <.> ~ z1 )
                                | <.> ( ~ p3
                                      | ( [.] z3
                                        & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p1
                                | ( [.] z1
                                  & <.> <.> ~ z1 )
                                | <.> ( ~ p4
                                      | ( [.] z4
                                        & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p1
                                | ( [.] z1
                                  & <.> <.> ~ z1 )
                                | <.> ( ~ p5
                                      | ( [.] z5
                                        & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] ( p2
                            | ( [.] z2
                              & <.> <.> ~ z2 )
                            | <.> ( ~ p2
                                  | ( [.] z2
                                    & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] ( p6
                            | ( [.] z6
                              & <.> <.> ~ z6 )
                            | <.> ( ~ p2
                                  | ( [.] z2
                                    & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p3
                                | ( [.] z3
                                  & <.> <.> ~ z3 )
                                | <.> ( ~ p1
                                      | ( [.] z1
                                        & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p3
                                | ( [.] z3
                                  & <.> <.> ~ z3 )
                                | <.> ( ~ p3
                                      | ( [.] z3
                                        & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p3
                                | ( [.] z3
                                  & <.> <.> ~ z3 )
                                | <.> ( ~ p5
                                      | ( [.] z5
                                        & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] ( p2
                            | ( [.] z2
                              & <.> <.> ~ z2 )
                            | <.> ( ~ p4
                                  | ( [.] z4
                                    & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] ( p6
                            | ( [.] z6
                              & <.> <.> ~ z6 )
                            | <.> ( ~ p4
                                  | ( [.] z4
                                    & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p5
                                | ( [.] z5
                                  & <.> <.> ~ z5 )
                                | <.> ( ~ p1
                                      | ( [.] z1
                                        & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p5
                                | ( [.] z5
                                  & <.> <.> ~ z5 )
                                | <.> ( ~ p3
                                      | ( [.] z3
                                        & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p5
                                | ( [.] z5
                                  & <.> <.> ~ z5 )
                                | <.> ( ~ p5
                                      | ( [.] z5
                                        & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] ( p2
                            | ( [.] z2
                              & <.> <.> ~ z2 )
                            | <.> ( ~ p6
                                  | ( [.] z6
                                    & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] ( p6
                            | ( [.] z6
                              & <.> <.> ~ z6 )
                            | <.> ( ~ p6
                                  | ( [.] z6
                                    & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p1
                                    | ( [.] z1
                                      & <.> <.> ~ z1 )
                                    | <.> ( ~ p3
                                          | ( [.] z3
                                            & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p1
                                    | ( [.] z1
                                      & <.> <.> ~ z1 )
                                    | <.> ( ~ p5
                                          | ( [.] z5
                                            & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p2
                                | ( [.] z2
                                  & <.> <.> ~ z2 )
                                | <.> ( ~ p2
                                      | ( [.] z2
                                        & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p4
                                | ( [.] z4
                                  & <.> <.> ~ z4 )
                                | <.> ( ~ p2
                                      | ( [.] z2
                                        & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p6
                                | ( [.] z6
                                  & <.> <.> ~ z6 )
                                | <.> ( ~ p2
                                      | ( [.] z2
                                        & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p3
                                    | ( [.] z3
                                      & <.> <.> ~ z3 )
                                    | <.> ( ~ p3
                                          | ( [.] z3
                                            & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p3
                                    | ( [.] z3
                                      & <.> <.> ~ z3 )
                                    | <.> ( ~ p5
                                          | ( [.] z5
                                            & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p4
                                    | ( [.] z4
                                      & <.> <.> ~ z4 )
                                    | <.> ( ~ p1
                                          | ( [.] z1
                                            & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p2
                                | ( [.] z2
                                  & <.> <.> ~ z2 )
                                | <.> ( ~ p4
                                      | ( [.] z4
                                        & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p4
                                | ( [.] z4
                                  & <.> <.> ~ z4 )
                                | <.> ( ~ p4
                                      | ( [.] z4
                                        & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p6
                                | ( [.] z6
                                  & <.> <.> ~ z6 )
                                | <.> ( ~ p4
                                      | ( [.] z4
                                        & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p5
                                    | ( [.] z5
                                      & <.> <.> ~ z5 )
                                    | <.> ( ~ p3
                                          | ( [.] z3
                                            & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p5
                                    | ( [.] z5
                                      & <.> <.> ~ z5 )
                                    | <.> ( ~ p5
                                          | ( [.] z5
                                            & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p2
                                | ( [.] z2
                                  & <.> <.> ~ z2 )
                                | <.> ( ~ p6
                                      | ( [.] z6
                                        & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p4
                                | ( [.] z4
                                  & <.> <.> ~ z4 )
                                | <.> ( ~ p6
                                      | ( [.] z6
                                        & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] ( p6
                                | ( [.] z6
                                  & <.> <.> ~ z6 )
                                | <.> ( ~ p6
                                      | ( [.] z6
                                        & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                        | ( [.] z1
                                          & <.> <.> ~ z1 )
                                        | <.> ( ~ p1
                                              | ( [.] z1
                                                & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                        | ( [.] z1
                                          & <.> <.> ~ z1 )
                                        | <.> ( ~ p3
                                              | ( [.] z3
                                                & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                        | ( [.] z1
                                          & <.> <.> ~ z1 )
                                        | <.> ( ~ p4
                                              | ( [.] z4
                                                & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                        | ( [.] z1
                                          & <.> <.> ~ z1 )
                                        | <.> ( ~ p5
                                              | ( [.] z5
                                                & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p2
                                    | ( [.] z2
                                      & <.> <.> ~ z2 )
                                    | <.> ( ~ p2
                                          | ( [.] z2
                                            & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p6
                                    | ( [.] z6
                                      & <.> <.> ~ z6 )
                                    | <.> ( ~ p2
                                          | ( [.] z2
                                            & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                        | ( [.] z3
                                          & <.> <.> ~ z3 )
                                        | <.> ( ~ p1
                                              | ( [.] z1
                                                & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                        | ( [.] z3
                                          & <.> <.> ~ z3 )
                                        | <.> ( ~ p3
                                              | ( [.] z3
                                                & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                        | ( [.] z3
                                          & <.> <.> ~ z3 )
                                        | <.> ( ~ p5
                                              | ( [.] z5
                                                & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p2
                                    | ( [.] z2
                                      & <.> <.> ~ z2 )
                                    | <.> ( ~ p4
                                          | ( [.] z4
                                            & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p6
                                    | ( [.] z6
                                      & <.> <.> ~ z6 )
                                    | <.> ( ~ p4
                                          | ( [.] z4
                                            & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                        | ( [.] z5
                                          & <.> <.> ~ z5 )
                                        | <.> ( ~ p1
                                              | ( [.] z1
                                                & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                        | ( [.] z5
                                          & <.> <.> ~ z5 )
                                        | <.> ( ~ p3
                                              | ( [.] z3
                                                & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                        | ( [.] z5
                                          & <.> <.> ~ z5 )
                                        | <.> ( ~ p5
                                              | ( [.] z5
                                                & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p2
                                    | ( [.] z2
                                      & <.> <.> ~ z2 )
                                    | <.> ( ~ p6
                                          | ( [.] z6
                                            & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] ( p6
                                    | ( [.] z6
                                      & <.> <.> ~ z6 )
                                    | <.> ( ~ p6
                                          | ( [.] z6
                                            & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                            | ( [.] z1
                                              & <.> <.> ~ z1 )
                                            | <.> ( ~ p3
                                                  | ( [.] z3
                                                    & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                            | ( [.] z1
                                              & <.> <.> ~ z1 )
                                            | <.> ( ~ p5
                                                  | ( [.] z5
                                                    & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                        | ( [.] z2
                                          & <.> <.> ~ z2 )
                                        | <.> ( ~ p2
                                              | ( [.] z2
                                                & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                        | ( [.] z4
                                          & <.> <.> ~ z4 )
                                        | <.> ( ~ p2
                                              | ( [.] z2
                                                & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                        | ( [.] z6
                                          & <.> <.> ~ z6 )
                                        | <.> ( ~ p2
                                              | ( [.] z2
                                                & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                            | ( [.] z3
                                              & <.> <.> ~ z3 )
                                            | <.> ( ~ p3
                                                  | ( [.] z3
                                                    & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p3
                                            | ( [.] z3
                                              & <.> <.> ~ z3 )
                                            | <.> ( ~ p5
                                                  | ( [.] z5
                                                    & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                            | ( [.] z4
                                              & <.> <.> ~ z4 )
                                            | <.> ( ~ p1
                                                  | ( [.] z1
                                                    & <.> <.> ~ z1 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                        | ( [.] z2
                                          & <.> <.> ~ z2 )
                                        | <.> ( ~ p4
                                              | ( [.] z4
                                                & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                        | ( [.] z4
                                          & <.> <.> ~ z4 )
                                        | <.> ( ~ p4
                                              | ( [.] z4
                                                & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                        | ( [.] z6
                                          & <.> <.> ~ z6 )
                                        | <.> ( ~ p4
                                              | ( [.] z4
                                                & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                            | ( [.] z5
                                              & <.> <.> ~ z5 )
                                            | <.> ( ~ p3
                                                  | ( [.] z3
                                                    & <.> <.> ~ z3 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p5
                                            | ( [.] z5
                                              & <.> <.> ~ z5 )
                                            | <.> ( ~ p5
                                                  | ( [.] z5
                                                    & <.> <.> ~ z5 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                        | ( [.] z2
                                          & <.> <.> ~ z2 )
                                        | <.> ( ~ p6
                                              | ( [.] z6
                                                & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                        | ( [.] z4
                                          & <.> <.> ~ z4 )
                                        | <.> ( ~ p6
                                              | ( [.] z6
                                                & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                        | ( [.] z6
                                          & <.> <.> ~ z6 )
                                        | <.> ( ~ p6
                                              | ( [.] z6
                                                & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                            | ( [.] z2
                                              & <.> <.> ~ z2 )
                                            | <.> ( ~ p2
                                                  | ( [.] z2
                                                    & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                            | ( [.] z6
                                              & <.> <.> ~ z6 )
                                            | <.> ( ~ p2
                                                  | ( [.] z2
                                                    & <.> <.> ~ z2 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                            | ( [.] z2
                                              & <.> <.> ~ z2 )
                                            | <.> ( ~ p4
                                                  | ( [.] z4
                                                    & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                            | ( [.] z6
                                              & <.> <.> ~ z6 )
                                            | <.> ( ~ p4
                                                  | ( [.] z4
                                                    & <.> <.> ~ z4 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                            | ( [.] z2
                                              & <.> <.> ~ z2 )
                                            | <.> ( ~ p6
                                                  | ( [.] z6
                                                    & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                            | ( [.] z6
                                              & <.> <.> ~ z6 )
                                            | <.> ( ~ p6
                                                  | ( [.] z6
                                                    & <.> <.> ~ z6 ) ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p2
                                                | ( [.] z2
                                                  & <.> <.> ~ z2 ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p4
                                                | ( [.] z4
                                                  & <.> <.> ~ z4 ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p1
                                                | ( [.] z1
                                                  & <.> <.> ~ z1 ) )
      & [.] [.] [.] [.] [.] [.] [.] [.] [.] [.] ( p6
                                                | ( [.] z6
                                                  & <.> <.> ~ z6 ) ) ) ).

%------------------------------------------------------------------------------
