%------------------------------------------------------------------------------
% File     : PLA055_1.010 : TPTP v9.2.0. Released v9.0.0.
% Domain   : Planning
% Problem  : Path from the entry to the exit of a labyrinth 10
% Version  : Especial.
% English  : The formula is the path from the entry to the exit of a 
%            labyrinth. It makes no difference whether one starts at the 
%            entry or at the exit.

% Refs     : [BHS00] Balsiger et al. (2000), A Benchmark Method for the Pro
%          : [NH+22] Nalon et al. (2022), Local Reductions for the Modal Cu
%          : [Nal22] Nalon (2022), Email to Geoff Sutcliffe
%          : [NH+23] Nalon et al. (2023), Buy One Get 14 Free: Evaluating L
% Source   : [Nal22]
% Names    : k_path_p.0010 [Nal22]

% Status   : Theorem
% Rating   : 0.50 v9.0.0
% Syntax   : Number of formulae    :    8 (   0 unt;   7 typ;   0 def)
%            Number of atoms       :  351 (   0 equ)
%            Maximal formula atoms :  351 ( 351 avg)
%            Number of connectives : 1387 ( 147   ~; 209   |; 141   &)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%                                         ( 890 {.};   0 {#})
%            Maximal formula depth :  223 ( 223 avg)
%            Maximal term depth    :    0 (   0 avg)
%            Number of types       :    1 (   0 usr)
%            Number of type conns  :    0 (   0   >;   0   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   7 usr;   7 prp; 0-0 aty)
%            Number of functors    :    0 (   0 usr;   0 con; --- aty)
%            Number of variables   :    0 (;   0   !;   0   ?;   0   :)
% SPC      : NX0_THM_PRP_NEQ_NAR

% Comments :
%------------------------------------------------------------------------------
tff('k_path_p.0010',logic,
    $modal == 
      [ $modalities == $modal_system_K ] ).

tff(false_decl,type,
    false: $o ).

tff(p1_decl,type,
    p1: $o ).

tff(p2_decl,type,
    p2: $o ).

tff(p3_decl,type,
    p3: $o ).

tff(p4_decl,type,
    p4: $o ).

tff(p5_decl,type,
    p5: $o ).

tff(p6_decl,type,
    p6: $o ).

tff(prove,conjecture,
    ~ ~ ( [.] p1
        | [.] p2
        | [.] p3
        | [.] p5
        | <.> ( ~ p1
              & [.] p3 )
        | <.> ( ~ p1
              & [.] p5 )
        | false
        | <.> ( ~ p2
              & [.] p1 )
        | false
        | <.> ( ~ p3
              & [.] p3 )
        | <.> ( ~ p3
              & [.] p5 )
        | false
        | false
        | false
        | <.> ( ~ p5
              & [.] p3 )
        | <.> ( ~ p5
              & [.] p5 )
        | false
        | false
        | false
        | <.> <.> ( ~ p1
                  & [.] p1 )
        | <.> <.> ( ~ p1
                  & [.] p3 )
        | <.> <.> ( ~ p1
                  & [.] p6 )
        | <.> <.> ( ~ p1
                  & [.] p5 )
        | false
        | false
        | <.> ( ~ p4
              & [.] p2 )
        | <.> ( ~ p6
              & [.] p2 )
        | <.> <.> ( ~ p3
                  & [.] p1 )
        | <.> <.> ( ~ p3
                  & [.] p3 )
        | <.> <.> ( ~ p3
                  & [.] p5 )
        | false
        | false
        | <.> ( ~ p4
              & [.] p4 )
        | <.> ( ~ p6
              & [.] p4 )
        | <.> <.> ( ~ p5
                  & [.] p1 )
        | <.> <.> ( ~ p5
                  & [.] p3 )
        | <.> <.> ( ~ p5
                  & [.] p5 )
        | false
        | false
        | <.> ( ~ p4
              & [.] p6 )
        | <.> ( ~ p6
              & [.] p6 )
        | <.> <.> <.> ( ~ p1
                      & [.] p1 )
        | <.> <.> <.> ( ~ p1
                      & [.] p3 )
        | false
        | false
        | <.> <.> ( ~ p2
                  & [.] p2 )
        | <.> <.> ( ~ p4
                  & [.] p2 )
        | <.> <.> ( ~ p6
                  & [.] p2 )
        | <.> <.> <.> ( ~ p3
                      & [.] p1 )
        | <.> <.> <.> ( ~ p3
                      & [.] p3 )
        | false
        | false
        | <.> <.> ( ~ p2
                  & [.] p4 )
        | <.> <.> ( ~ p4
                  & [.] p4 )
        | <.> <.> ( ~ p6
                  & [.] p4 )
        | <.> <.> <.> ( ~ p5
                      & [.] p1 )
        | <.> <.> <.> ( ~ p5
                      & [.] p3 )
        | false
        | <.> <.> <.> ( ~ p6
                      & [.] p5 )
        | <.> <.> ( ~ p2
                  & [.] p6 )
        | <.> <.> ( ~ p4
                  & [.] p6 )
        | <.> <.> ( ~ p6
                  & [.] p6 )
        | <.> <.> <.> <.> ( ~ p1
                          & [.] p1 )
        | <.> <.> <.> <.> ( ~ p1
                          & [.] p3 )
        | <.> <.> <.> <.> ( ~ p1
                          & [.] p5 )
        | false
        | false
        | <.> <.> <.> ( ~ p2
                      & [.] p2 )
        | <.> <.> <.> ( ~ p4
                      & [.] p2 )
        | <.> <.> <.> <.> ( ~ p3
                          & [.] p1 )
        | <.> <.> <.> <.> ( ~ p3
                          & [.] p3 )
        | <.> <.> <.> <.> ( ~ p3
                          & [.] p5 )
        | false
        | false
        | <.> <.> <.> ( ~ p2
                      & [.] p4 )
        | <.> <.> <.> ( ~ p4
                      & [.] p4 )
        | <.> <.> <.> <.> ( ~ p5
                          & [.] p1 )
        | <.> <.> <.> <.> ( ~ p5
                          & [.] p3 )
        | <.> <.> <.> <.> ( ~ p5
                          & [.] p4 )
        | <.> <.> <.> <.> ( ~ p5
                          & [.] p5 )
        | false
        | false
        | <.> <.> <.> ( ~ p2
                      & [.] p6 )
        | <.> <.> <.> ( ~ p4
                      & [.] p6 )
        | <.> <.> <.> <.> <.> ( ~ p1
                              & [.] p3 )
        | <.> <.> <.> <.> <.> ( ~ p1
                              & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> ( ~ p2
                          & [.] p2 )
        | <.> <.> <.> <.> ( ~ p4
                          & [.] p2 )
        | <.> <.> <.> <.> ( ~ p6
                          & [.] p2 )
        | <.> <.> <.> <.> <.> ( ~ p3
                              & [.] p3 )
        | <.> <.> <.> <.> <.> ( ~ p3
                              & [.] p5 )
        | false
        | <.> <.> <.> <.> <.> ( ~ p4
                              & [.] p1 )
        | <.> <.> <.> <.> ( ~ p2
                          & [.] p4 )
        | <.> <.> <.> <.> ( ~ p4
                          & [.] p4 )
        | <.> <.> <.> <.> ( ~ p6
                          & [.] p4 )
        | <.> <.> <.> <.> <.> ( ~ p5
                              & [.] p3 )
        | <.> <.> <.> <.> <.> ( ~ p5
                              & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> ( ~ p2
                          & [.] p6 )
        | <.> <.> <.> <.> ( ~ p4
                          & [.] p6 )
        | <.> <.> <.> <.> ( ~ p6
                          & [.] p6 )
        | <.> <.> <.> <.> <.> <.> ( ~ p1
                                  & [.] p1 )
        | <.> <.> <.> <.> <.> <.> ( ~ p1
                                  & [.] p3 )
        | <.> <.> <.> <.> <.> <.> ( ~ p1
                                  & [.] p4 )
        | <.> <.> <.> <.> <.> <.> ( ~ p1
                                  & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> <.> ( ~ p2
                              & [.] p2 )
        | <.> <.> <.> <.> <.> ( ~ p6
                              & [.] p2 )
        | <.> <.> <.> <.> <.> <.> ( ~ p3
                                  & [.] p1 )
        | <.> <.> <.> <.> <.> <.> ( ~ p3
                                  & [.] p3 )
        | <.> <.> <.> <.> <.> <.> ( ~ p3
                                  & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> <.> ( ~ p2
                              & [.] p4 )
        | <.> <.> <.> <.> <.> ( ~ p6
                              & [.] p4 )
        | <.> <.> <.> <.> <.> <.> ( ~ p5
                                  & [.] p1 )
        | <.> <.> <.> <.> <.> <.> ( ~ p5
                                  & [.] p3 )
        | <.> <.> <.> <.> <.> <.> ( ~ p5
                                  & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> <.> ( ~ p2
                              & [.] p6 )
        | <.> <.> <.> <.> <.> ( ~ p6
                              & [.] p6 )
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p1
                                      & [.] p3 )
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p1
                                      & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> <.> <.> ( ~ p2
                                  & [.] p2 )
        | <.> <.> <.> <.> <.> <.> ( ~ p4
                                  & [.] p2 )
        | <.> <.> <.> <.> <.> <.> ( ~ p6
                                  & [.] p2 )
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p3
                                      & [.] p3 )
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p3
                                      & [.] p5 )
        | false
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p4
                                      & [.] p1 )
        | <.> <.> <.> <.> <.> <.> ( ~ p2
                                  & [.] p4 )
        | <.> <.> <.> <.> <.> <.> ( ~ p4
                                  & [.] p4 )
        | <.> <.> <.> <.> <.> <.> ( ~ p6
                                  & [.] p4 )
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p5
                                      & [.] p3 )
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p5
                                      & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> <.> <.> ( ~ p2
                                  & [.] p6 )
        | <.> <.> <.> <.> <.> <.> ( ~ p4
                                  & [.] p6 )
        | <.> <.> <.> <.> <.> <.> ( ~ p6
                                  & [.] p6 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p1
                                          & [.] p1 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p1
                                          & [.] p3 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p1
                                          & [.] p4 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p1
                                          & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p2
                                      & [.] p2 )
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p6
                                      & [.] p2 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p3
                                          & [.] p1 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p3
                                          & [.] p3 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p3
                                          & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p2
                                      & [.] p4 )
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p6
                                      & [.] p4 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p5
                                          & [.] p1 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p5
                                          & [.] p3 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p5
                                          & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p2
                                      & [.] p6 )
        | <.> <.> <.> <.> <.> <.> <.> ( ~ p6
                                      & [.] p6 )
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p1
                                              & [.] p3 )
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p1
                                              & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p2
                                          & [.] p2 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p4
                                          & [.] p2 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p6
                                          & [.] p2 )
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p3
                                              & [.] p3 )
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p3
                                              & [.] p5 )
        | false
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p4
                                              & [.] p1 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p2
                                          & [.] p4 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p4
                                          & [.] p4 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p6
                                          & [.] p4 )
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p5
                                              & [.] p3 )
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p5
                                              & [.] p5 )
        | false
        | false
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p2
                                          & [.] p6 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p4
                                          & [.] p6 )
        | <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p6
                                          & [.] p6 )
        | false
        | false
        | false
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p2
                                              & [.] p2 )
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p6
                                              & [.] p2 )
        | false
        | false
        | false
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p2
                                              & [.] p4 )
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p6
                                              & [.] p4 )
        | false
        | false
        | false
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p2
                                              & [.] p6 )
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> ( ~ p6
                                              & [.] p6 )
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> <.> ~ p2
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> <.> ~ p4
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> <.> ~ p1
        | <.> <.> <.> <.> <.> <.> <.> <.> <.> <.> ~ p6 ) ).

%------------------------------------------------------------------------------
