%------------------------------------------------------------------------------
% File     : PLA031-1.018 : TPTP v9.2.0. Released v5.2.0.
% Domain   : Planning
% Problem  : Driver's log k=18
% Version  : Especial.
% English  : A planning domain that involves driving trucks around
%            delivering packages between locations. The complication is
%            that the trucks require drivers who must walk between trucks
%            in order to drive them. The paths for walking and the roads
%            for driving form different maps on the locations.
%            Instances were semi-automatically translated from the basic
%            Strips instances used in the 2002 Planning Competition.

% Refs     : [LF03] Long & Fox (2003), The 3rd International Planning Compe
%          : [NV07a] Navarro (2007), Email to Geoff Sutcliffe
%          : [NV07b] Navarro & Voronkov (2007), Encoding Problems and Reaso
% Source   : [NV07a]
% Names    : driverlog08 [NV07a]

% Status   : Unsatisfiable
% Rating   : 1.00 v5.2.0
% Syntax   : Number of clauses     : 4924 (4644 unt;   0 nHn;4924 RR)
%            Number of literals    : 5334 (   0 equ; 477 neg)
%            Maximal clause size   :    6 (   1 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :    4 (   4 usr;   0 prp; 2-30 aty)
%            Number of functors    :   66 (  66 usr;  66 con; 0-0 aty)
%            Number of variables   : 8160 (   5 sgn)
% SPC      : CNF_UNS_EPR_NEQ_HRN

% Comments : Only instances 1-4 are within reach of current provers. (2007)
%          : Translated from [LF03] using [NV07b]
%------------------------------------------------------------------------------
cnf(load1,axiom,
    ( ~ s(L,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(truck1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load2,axiom,
    ( s(L,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(truck1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load3,axiom,
    ( ~ s(L,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(truck2,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load4,axiom,
    ( s(L,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(truck2,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load5,axiom,
    ( ~ s(L,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(truck3,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load6,axiom,
    ( s(L,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(truck3,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load7,axiom,
    ( ~ s(L,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(truck4,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load8,axiom,
    ( s(L,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(truck4,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load9,axiom,
    ( ~ s(L,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(truck5,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load10,axiom,
    ( s(L,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(truck5,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load11,axiom,
    ( ~ s(O1,L,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,truck1,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load12,axiom,
    ( s(O1,L,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,truck1,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load13,axiom,
    ( ~ s(O1,L,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,truck2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load14,axiom,
    ( s(O1,L,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,truck2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load15,axiom,
    ( ~ s(O1,L,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,truck3,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load16,axiom,
    ( s(O1,L,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,truck3,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load17,axiom,
    ( ~ s(O1,L,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,truck4,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load18,axiom,
    ( s(O1,L,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,truck4,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load19,axiom,
    ( ~ s(O1,L,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,truck5,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load20,axiom,
    ( s(O1,L,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,truck5,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load21,axiom,
    ( ~ s(O1,O2,L,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,truck1,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load22,axiom,
    ( s(O1,O2,L,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,truck1,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load23,axiom,
    ( ~ s(O1,O2,L,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,truck2,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load24,axiom,
    ( s(O1,O2,L,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,truck2,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load25,axiom,
    ( ~ s(O1,O2,L,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,truck3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load26,axiom,
    ( s(O1,O2,L,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,truck3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load27,axiom,
    ( ~ s(O1,O2,L,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,truck4,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load28,axiom,
    ( s(O1,O2,L,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,truck4,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load29,axiom,
    ( ~ s(O1,O2,L,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,truck5,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load30,axiom,
    ( s(O1,O2,L,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,truck5,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load31,axiom,
    ( ~ s(O1,O2,O3,L,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,truck1,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load32,axiom,
    ( s(O1,O2,O3,L,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,truck1,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load33,axiom,
    ( ~ s(O1,O2,O3,L,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,truck2,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load34,axiom,
    ( s(O1,O2,O3,L,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,truck2,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load35,axiom,
    ( ~ s(O1,O2,O3,L,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,truck3,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load36,axiom,
    ( s(O1,O2,O3,L,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,truck3,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load37,axiom,
    ( ~ s(O1,O2,O3,L,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,truck4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load38,axiom,
    ( s(O1,O2,O3,L,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,truck4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load39,axiom,
    ( ~ s(O1,O2,O3,L,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,truck5,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load40,axiom,
    ( s(O1,O2,O3,L,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,truck5,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load41,axiom,
    ( ~ s(O1,O2,O3,O4,L,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,truck1,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load42,axiom,
    ( s(O1,O2,O3,O4,L,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,truck1,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load43,axiom,
    ( ~ s(O1,O2,O3,O4,L,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,truck2,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load44,axiom,
    ( s(O1,O2,O3,O4,L,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,truck2,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load45,axiom,
    ( ~ s(O1,O2,O3,O4,L,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,truck3,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load46,axiom,
    ( s(O1,O2,O3,O4,L,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,truck3,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load47,axiom,
    ( ~ s(O1,O2,O3,O4,L,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,truck4,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load48,axiom,
    ( s(O1,O2,O3,O4,L,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,truck4,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load49,axiom,
    ( ~ s(O1,O2,O3,O4,L,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,truck5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load50,axiom,
    ( s(O1,O2,O3,O4,L,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,truck5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load51,axiom,
    ( ~ s(O1,O2,O3,O4,O5,L,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,truck1,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load52,axiom,
    ( s(O1,O2,O3,O4,O5,L,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,truck1,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load53,axiom,
    ( ~ s(O1,O2,O3,O4,O5,L,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,truck2,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load54,axiom,
    ( s(O1,O2,O3,O4,O5,L,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,truck2,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load55,axiom,
    ( ~ s(O1,O2,O3,O4,O5,L,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,truck3,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load56,axiom,
    ( s(O1,O2,O3,O4,O5,L,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,truck3,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load57,axiom,
    ( ~ s(O1,O2,O3,O4,O5,L,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,truck4,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load58,axiom,
    ( s(O1,O2,O3,O4,O5,L,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,truck4,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load59,axiom,
    ( ~ s(O1,O2,O3,O4,O5,L,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,truck5,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load60,axiom,
    ( s(O1,O2,O3,O4,O5,L,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,truck5,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load61,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,L,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,truck1,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load62,axiom,
    ( s(O1,O2,O3,O4,O5,O6,L,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,truck1,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load63,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,L,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,truck2,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load64,axiom,
    ( s(O1,O2,O3,O4,O5,O6,L,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,truck2,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load65,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,L,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,truck3,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load66,axiom,
    ( s(O1,O2,O3,O4,O5,O6,L,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,truck3,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load67,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,L,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,truck4,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load68,axiom,
    ( s(O1,O2,O3,O4,O5,O6,L,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,truck4,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load69,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,L,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,truck5,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load70,axiom,
    ( s(O1,O2,O3,O4,O5,O6,L,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,truck5,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load71,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,L,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,truck1,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load72,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,L,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,truck1,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load73,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,L,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,truck2,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load74,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,L,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,truck2,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load75,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,L,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,truck3,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load76,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,L,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,truck3,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load77,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,L,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,truck4,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load78,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,L,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,truck4,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load79,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,L,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,truck5,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load80,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,L,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,truck5,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load81,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,L,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,truck1,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load82,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,L,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,truck1,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load83,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,L,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,truck2,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load84,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,L,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,truck2,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load85,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,L,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,truck3,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load86,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,L,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,truck3,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load87,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,L,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,truck4,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load88,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,L,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,truck4,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load89,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,L,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,truck5,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load90,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,L,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,truck5,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load91,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,L,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,truck1,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load92,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,L,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,truck1,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load93,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,L,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,truck2,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load94,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,L,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,truck2,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load95,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,L,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,truck3,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load96,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,L,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,truck3,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load97,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,L,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,truck4,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load98,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,L,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,truck4,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load99,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,L,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,truck5,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load100,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,L,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,truck5,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load101,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,L,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,truck1,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load102,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,L,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,truck1,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load103,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,L,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,truck2,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load104,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,L,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,truck2,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load105,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,L,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,truck3,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load106,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,L,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,truck3,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load107,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,L,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,truck4,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load108,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,L,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,truck4,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load109,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,L,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,truck5,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load110,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,L,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,truck5,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load111,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,L,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,truck1,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load112,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,L,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,truck1,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load113,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,L,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,truck2,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load114,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,L,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,truck2,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load115,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,L,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,truck3,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load116,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,L,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,truck3,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load117,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,L,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,truck4,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load118,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,L,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,truck4,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load119,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,L,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,truck5,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load120,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,L,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,truck5,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load121,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,L,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,truck1,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load122,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,L,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,truck1,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load123,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,L,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,truck2,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load124,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,L,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,truck2,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load125,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,L,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,truck3,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load126,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,L,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,truck3,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load127,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,L,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,truck4,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load128,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,L,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,truck4,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load129,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,L,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,truck5,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load130,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,L,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,truck5,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load131,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,L,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,truck1,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load132,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,L,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,truck1,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load133,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,L,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,truck2,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load134,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,L,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,truck2,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load135,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,L,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,truck3,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load136,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,L,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,truck3,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load137,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,L,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,truck4,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load138,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,L,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,truck4,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load139,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,L,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,truck5,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load140,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,L,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,truck5,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load141,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,L,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,truck1,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load142,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,L,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,truck1,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load143,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,L,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,truck2,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load144,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,L,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,truck2,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load145,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,L,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,truck3,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load146,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,L,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,truck3,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load147,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,L,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,truck4,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load148,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,L,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,truck4,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load149,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,L,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,truck5,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load150,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,L,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,truck5,O16,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load151,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,L,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,truck1,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load152,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,L,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,truck1,O17,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load153,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,L,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,truck2,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load154,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,L,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,truck2,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load155,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,L,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,truck3,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load156,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,L,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,truck3,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load157,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,L,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,truck4,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load158,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,L,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,truck4,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load159,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,L,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,truck5,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load160,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,L,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,truck5,O17,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load161,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,L,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,truck1,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load162,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,L,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,truck1,O18,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load163,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,L,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,truck2,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load164,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,L,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,truck2,O18,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load165,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,L,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,truck3,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load166,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,L,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,truck3,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load167,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,L,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,truck4,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load168,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,L,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,truck4,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load169,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,L,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,truck5,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load170,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,L,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,truck5,O18,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load171,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,L,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,truck1,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load172,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,L,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,truck1,O19,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load173,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,L,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,truck2,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load174,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,L,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,truck2,O19,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load175,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,L,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,truck3,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load176,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,L,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,truck3,O19,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load177,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,L,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,truck4,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load178,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,L,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,truck4,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load179,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,L,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,truck5,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load180,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,L,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,truck5,O19,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load181,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,L,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,truck1,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load182,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,L,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,truck1,O20,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load183,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,L,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,truck2,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load184,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,L,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,truck2,O20,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load185,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,L,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,truck3,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load186,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,L,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,truck3,O20,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load187,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,L,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,truck4,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load188,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,L,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,truck4,O20,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load189,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,L,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,truck5,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load190,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,L,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,truck5,O20,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load191,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,L,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,truck1,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load192,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,L,D1,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,truck1,D1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(load193,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,L,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,truck2,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load194,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,L,D1,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,truck2,D1,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(load195,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,L,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,truck3,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load196,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,L,D1,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,truck3,D1,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(load197,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,L,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,truck4,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load198,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,L,D1,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,truck4,D1,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(load199,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,L,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,truck5,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(load200,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,L,D1,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,truck5,D1,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(board1,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,L,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ neq(D2,truck1)
    | ~ neq(D3,truck1)
    | ~ neq(D4,truck1)
    | ~ neq(D5,truck1)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(board2,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,L,D2,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck1,D2,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(board3,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,L,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ neq(D2,truck2)
    | ~ neq(D3,truck2)
    | ~ neq(D4,truck2)
    | ~ neq(D5,truck2)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck2,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(board4,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,L,D2,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck2,D2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(board5,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,L,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ neq(D2,truck3)
    | ~ neq(D3,truck3)
    | ~ neq(D4,truck3)
    | ~ neq(D5,truck3)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck3,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(board6,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,L,D2,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck3,D2,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(board7,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,L,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ neq(D2,truck4)
    | ~ neq(D3,truck4)
    | ~ neq(D4,truck4)
    | ~ neq(D5,truck4)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck4,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(board8,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,L,D2,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck4,D2,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(board9,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,L,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ neq(D2,truck5)
    | ~ neq(D3,truck5)
    | ~ neq(D4,truck5)
    | ~ neq(D5,truck5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck5,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(board10,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,L,D2,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck5,D2,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(board11,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,L,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ neq(D1,truck1)
    | ~ neq(D3,truck1)
    | ~ neq(D4,truck1)
    | ~ neq(D5,truck1)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck1,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(board12,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,L,D3,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck1,D3,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(board13,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,L,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ neq(D1,truck2)
    | ~ neq(D3,truck2)
    | ~ neq(D4,truck2)
    | ~ neq(D5,truck2)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(board14,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,L,D3,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck2,D3,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(board15,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,L,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ neq(D1,truck3)
    | ~ neq(D3,truck3)
    | ~ neq(D4,truck3)
    | ~ neq(D5,truck3)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck3,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(board16,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,L,D3,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck3,D3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(board17,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,L,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ neq(D1,truck4)
    | ~ neq(D3,truck4)
    | ~ neq(D4,truck4)
    | ~ neq(D5,truck4)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck4,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(board18,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,L,D3,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck4,D3,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(board19,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,L,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ neq(D1,truck5)
    | ~ neq(D3,truck5)
    | ~ neq(D4,truck5)
    | ~ neq(D5,truck5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck5,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(board20,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,L,D3,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck5,D3,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(board21,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,L,D4,D5,L,T2,T3,T4,T5)
    | ~ neq(D1,truck1)
    | ~ neq(D2,truck1)
    | ~ neq(D4,truck1)
    | ~ neq(D5,truck1)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck1,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(board22,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,L,D4,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck1,D4,D5,L,T2,T3,T4,T5) ) ).

cnf(board23,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,L,D4,D5,T1,L,T3,T4,T5)
    | ~ neq(D1,truck2)
    | ~ neq(D2,truck2)
    | ~ neq(D4,truck2)
    | ~ neq(D5,truck2)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck2,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(board24,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,L,D4,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck2,D4,D5,T1,L,T3,T4,T5) ) ).

cnf(board25,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,L,D4,D5,T1,T2,L,T4,T5)
    | ~ neq(D1,truck3)
    | ~ neq(D2,truck3)
    | ~ neq(D4,truck3)
    | ~ neq(D5,truck3)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(board26,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,L,D4,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck3,D4,D5,T1,T2,L,T4,T5) ) ).

cnf(board27,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,L,D4,D5,T1,T2,T3,L,T5)
    | ~ neq(D1,truck4)
    | ~ neq(D2,truck4)
    | ~ neq(D4,truck4)
    | ~ neq(D5,truck4)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck4,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(board28,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,L,D4,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck4,D4,D5,T1,T2,T3,L,T5) ) ).

cnf(board29,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,L,D4,D5,T1,T2,T3,T4,L)
    | ~ neq(D1,truck5)
    | ~ neq(D2,truck5)
    | ~ neq(D4,truck5)
    | ~ neq(D5,truck5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck5,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(board30,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,L,D4,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck5,D4,D5,T1,T2,T3,T4,L) ) ).

cnf(board31,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,L,D5,L,T2,T3,T4,T5)
    | ~ neq(D1,truck1)
    | ~ neq(D2,truck1)
    | ~ neq(D3,truck1)
    | ~ neq(D5,truck1)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck1,D5,L,T2,T3,T4,T5) ) ).

cnf(board32,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,L,D5,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck1,D5,L,T2,T3,T4,T5) ) ).

cnf(board33,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,L,D5,T1,L,T3,T4,T5)
    | ~ neq(D1,truck2)
    | ~ neq(D2,truck2)
    | ~ neq(D3,truck2)
    | ~ neq(D5,truck2)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck2,D5,T1,L,T3,T4,T5) ) ).

cnf(board34,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,L,D5,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck2,D5,T1,L,T3,T4,T5) ) ).

cnf(board35,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,L,D5,T1,T2,L,T4,T5)
    | ~ neq(D1,truck3)
    | ~ neq(D2,truck3)
    | ~ neq(D3,truck3)
    | ~ neq(D5,truck3)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck3,D5,T1,T2,L,T4,T5) ) ).

cnf(board36,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,L,D5,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck3,D5,T1,T2,L,T4,T5) ) ).

cnf(board37,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,L,D5,T1,T2,T3,L,T5)
    | ~ neq(D1,truck4)
    | ~ neq(D2,truck4)
    | ~ neq(D3,truck4)
    | ~ neq(D5,truck4)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck4,D5,T1,T2,T3,L,T5) ) ).

cnf(board38,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,L,D5,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck4,D5,T1,T2,T3,L,T5) ) ).

cnf(board39,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,L,D5,T1,T2,T3,T4,L)
    | ~ neq(D1,truck5)
    | ~ neq(D2,truck5)
    | ~ neq(D3,truck5)
    | ~ neq(D5,truck5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck5,D5,T1,T2,T3,T4,L) ) ).

cnf(board40,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,L,D5,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck5,D5,T1,T2,T3,T4,L) ) ).

cnf(board41,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,L,L,T2,T3,T4,T5)
    | ~ neq(D1,truck1)
    | ~ neq(D2,truck1)
    | ~ neq(D3,truck1)
    | ~ neq(D4,truck1)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck1,L,T2,T3,T4,T5) ) ).

cnf(board42,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,L,L,T2,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck1,L,T2,T3,T4,T5) ) ).

cnf(board43,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,L,T1,L,T3,T4,T5)
    | ~ neq(D1,truck2)
    | ~ neq(D2,truck2)
    | ~ neq(D3,truck2)
    | ~ neq(D4,truck2)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck2,T1,L,T3,T4,T5) ) ).

cnf(board44,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,L,T1,L,T3,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck2,T1,L,T3,T4,T5) ) ).

cnf(board45,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,L,T1,T2,L,T4,T5)
    | ~ neq(D1,truck3)
    | ~ neq(D2,truck3)
    | ~ neq(D3,truck3)
    | ~ neq(D4,truck3)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck3,T1,T2,L,T4,T5) ) ).

cnf(board46,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,L,T1,T2,L,T4,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck3,T1,T2,L,T4,T5) ) ).

cnf(board47,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,L,T1,T2,T3,L,T5)
    | ~ neq(D1,truck4)
    | ~ neq(D2,truck4)
    | ~ neq(D3,truck4)
    | ~ neq(D4,truck4)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck4,T1,T2,T3,L,T5) ) ).

cnf(board48,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,L,T1,T2,T3,L,T5)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck4,T1,T2,T3,L,T5) ) ).

cnf(board49,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,L,T1,T2,T3,T4,L)
    | ~ neq(D1,truck5)
    | ~ neq(D2,truck5)
    | ~ neq(D3,truck5)
    | ~ neq(D4,truck5)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck5,T1,T2,T3,T4,L) ) ).

cnf(board50,axiom,
    ( s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,L,T1,T2,T3,T4,L)
    | ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck5,T1,T2,T3,T4,L) ) ).

cnf(drive1,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck1,D2,D3,D4,D5,S,T2,T3,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck1,D2,D3,D4,D5,D,T2,T3,T4,T5) ) ).

cnf(drive2,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck2,D2,D3,D4,D5,T1,S,T3,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck2,D2,D3,D4,D5,T1,D,T3,T4,T5) ) ).

cnf(drive3,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck3,D2,D3,D4,D5,T1,T2,S,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck3,D2,D3,D4,D5,T1,T2,D,T4,T5) ) ).

cnf(drive4,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck4,D2,D3,D4,D5,T1,T2,T3,S,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck4,D2,D3,D4,D5,T1,T2,T3,D,T5) ) ).

cnf(drive5,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck5,D2,D3,D4,D5,T1,T2,T3,T4,S)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,truck5,D2,D3,D4,D5,T1,T2,T3,T4,D) ) ).

cnf(drive6,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck1,D3,D4,D5,S,T2,T3,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck1,D3,D4,D5,D,T2,T3,T4,T5) ) ).

cnf(drive7,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck2,D3,D4,D5,T1,S,T3,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck2,D3,D4,D5,T1,D,T3,T4,T5) ) ).

cnf(drive8,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck3,D3,D4,D5,T1,T2,S,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck3,D3,D4,D5,T1,T2,D,T4,T5) ) ).

cnf(drive9,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck4,D3,D4,D5,T1,T2,T3,S,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck4,D3,D4,D5,T1,T2,T3,D,T5) ) ).

cnf(drive10,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck5,D3,D4,D5,T1,T2,T3,T4,S)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,truck5,D3,D4,D5,T1,T2,T3,T4,D) ) ).

cnf(drive11,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck1,D4,D5,S,T2,T3,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck1,D4,D5,D,T2,T3,T4,T5) ) ).

cnf(drive12,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck2,D4,D5,T1,S,T3,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck2,D4,D5,T1,D,T3,T4,T5) ) ).

cnf(drive13,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck3,D4,D5,T1,T2,S,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck3,D4,D5,T1,T2,D,T4,T5) ) ).

cnf(drive14,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck4,D4,D5,T1,T2,T3,S,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck4,D4,D5,T1,T2,T3,D,T5) ) ).

cnf(drive15,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck5,D4,D5,T1,T2,T3,T4,S)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,truck5,D4,D5,T1,T2,T3,T4,D) ) ).

cnf(drive16,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck1,D5,S,T2,T3,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck1,D5,D,T2,T3,T4,T5) ) ).

cnf(drive17,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck2,D5,T1,S,T3,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck2,D5,T1,D,T3,T4,T5) ) ).

cnf(drive18,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck3,D5,T1,T2,S,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck3,D5,T1,T2,D,T4,T5) ) ).

cnf(drive19,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck4,D5,T1,T2,T3,S,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck4,D5,T1,T2,T3,D,T5) ) ).

cnf(drive20,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck5,D5,T1,T2,T3,T4,S)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,truck5,D5,T1,T2,T3,T4,D) ) ).

cnf(drive21,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck1,S,T2,T3,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck1,D,T2,T3,T4,T5) ) ).

cnf(drive22,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck2,T1,S,T3,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck2,T1,D,T3,T4,T5) ) ).

cnf(drive23,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck3,T1,T2,S,T4,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck3,T1,T2,D,T4,T5) ) ).

cnf(drive24,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck4,T1,T2,T3,S,T5)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck4,T1,T2,T3,D,T5) ) ).

cnf(drive25,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck5,T1,T2,T3,T4,S)
    | ~ link(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,truck5,T1,T2,T3,T4,D) ) ).

cnf(walk1,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,S,D2,D3,D4,D5,T1,T2,T3,T4,T5)
    | ~ path(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D,D2,D3,D4,D5,T1,T2,T3,T4,T5) ) ).

cnf(walk2,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,S,D3,D4,D5,T1,T2,T3,T4,T5)
    | ~ path(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D,D3,D4,D5,T1,T2,T3,T4,T5) ) ).

cnf(walk3,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,S,D4,D5,T1,T2,T3,T4,T5)
    | ~ path(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D,D4,D5,T1,T2,T3,T4,T5) ) ).

cnf(walk4,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,S,D5,T1,T2,T3,T4,T5)
    | ~ path(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D,D5,T1,T2,T3,T4,T5) ) ).

cnf(walk5,axiom,
    ( ~ s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,S,T1,T2,T3,T4,T5)
    | ~ path(S,D)
    | s(O1,O2,O3,O4,O5,O6,O7,O8,O9,O10,O11,O12,O13,O14,O15,O16,O17,O18,O19,O20,D1,D2,D3,D4,D,T1,T2,T3,T4,T5) ) ).

cnf(neq1,axiom,
    ~ neq(truck1,truck1) ).

cnf(neq2,axiom,
    neq(truck1,truck2) ).

cnf(neq3,axiom,
    neq(truck1,truck3) ).

cnf(neq4,axiom,
    neq(truck1,truck4) ).

cnf(neq5,axiom,
    neq(truck1,truck5) ).

cnf(neq6,axiom,
    neq(truck1,s0) ).

cnf(neq7,axiom,
    neq(truck1,s1) ).

cnf(neq8,axiom,
    neq(truck1,s2) ).

cnf(neq9,axiom,
    neq(truck1,s3) ).

cnf(neq10,axiom,
    neq(truck1,s4) ).

cnf(neq11,axiom,
    neq(truck1,s5) ).

cnf(neq12,axiom,
    neq(truck1,s6) ).

cnf(neq13,axiom,
    neq(truck1,s7) ).

cnf(neq14,axiom,
    neq(truck1,s8) ).

cnf(neq15,axiom,
    neq(truck1,s9) ).

cnf(neq16,axiom,
    neq(truck1,s10) ).

cnf(neq17,axiom,
    neq(truck1,s11) ).

cnf(neq18,axiom,
    neq(truck1,s12) ).

cnf(neq19,axiom,
    neq(truck1,s13) ).

cnf(neq20,axiom,
    neq(truck1,s14) ).

cnf(neq21,axiom,
    neq(truck1,s15) ).

cnf(neq22,axiom,
    neq(truck1,s16) ).

cnf(neq23,axiom,
    neq(truck1,s17) ).

cnf(neq24,axiom,
    neq(truck1,s18) ).

cnf(neq25,axiom,
    neq(truck1,s19) ).

cnf(neq26,axiom,
    neq(truck1,p0_8) ).

cnf(neq27,axiom,
    neq(truck1,p1_3) ).

cnf(neq28,axiom,
    neq(truck1,p1_4) ).

cnf(neq29,axiom,
    neq(truck1,p1_9) ).

cnf(neq30,axiom,
    neq(truck1,p2_3) ).

cnf(neq31,axiom,
    neq(truck1,p3_10) ).

cnf(neq32,axiom,
    neq(truck1,p3_19) ).

cnf(neq33,axiom,
    neq(truck1,p4_3) ).

cnf(neq34,axiom,
    neq(truck1,p4_6) ).

cnf(neq35,axiom,
    neq(truck1,p5_0) ).

cnf(neq36,axiom,
    neq(truck1,p5_10) ).

cnf(neq37,axiom,
    neq(truck1,p6_7) ).

cnf(neq38,axiom,
    neq(truck1,p6_10) ).

cnf(neq39,axiom,
    neq(truck1,p7_11) ).

cnf(neq40,axiom,
    neq(truck1,p8_2) ).

cnf(neq41,axiom,
    neq(truck1,p8_3) ).

cnf(neq42,axiom,
    neq(truck1,p8_5) ).

cnf(neq43,axiom,
    neq(truck1,p8_10) ).

cnf(neq44,axiom,
    neq(truck1,p9_15) ).

cnf(neq45,axiom,
    neq(truck1,p10_0) ).

cnf(neq46,axiom,
    neq(truck1,p11_3) ).

cnf(neq47,axiom,
    neq(truck1,p11_5) ).

cnf(neq48,axiom,
    neq(truck1,p11_13) ).

cnf(neq49,axiom,
    neq(truck1,p13_10) ).

cnf(neq50,axiom,
    neq(truck1,p13_14) ).

cnf(neq51,axiom,
    neq(truck1,p14_2) ).

cnf(neq52,axiom,
    neq(truck1,p14_7) ).

cnf(neq53,axiom,
    neq(truck1,p14_16) ).

cnf(neq54,axiom,
    neq(truck1,p14_17) ).

cnf(neq55,axiom,
    neq(truck1,p15_0) ).

cnf(neq56,axiom,
    neq(truck1,p15_1) ).

cnf(neq57,axiom,
    neq(truck1,p16_11) ).

cnf(neq58,axiom,
    neq(truck1,p16_18) ).

cnf(neq59,axiom,
    neq(truck1,p16_19) ).

cnf(neq60,axiom,
    neq(truck1,p17_3) ).

cnf(neq61,axiom,
    neq(truck1,p17_5) ).

cnf(neq62,axiom,
    neq(truck1,p17_8) ).

cnf(neq63,axiom,
    neq(truck1,p17_14) ).

cnf(neq64,axiom,
    neq(truck1,p18_15) ).

cnf(neq65,axiom,
    neq(truck1,p19_8) ).

cnf(neq66,axiom,
    neq(truck1,p19_12) ).

cnf(neq67,axiom,
    neq(truck2,truck1) ).

cnf(neq68,axiom,
    ~ neq(truck2,truck2) ).

cnf(neq69,axiom,
    neq(truck2,truck3) ).

cnf(neq70,axiom,
    neq(truck2,truck4) ).

cnf(neq71,axiom,
    neq(truck2,truck5) ).

cnf(neq72,axiom,
    neq(truck2,s0) ).

cnf(neq73,axiom,
    neq(truck2,s1) ).

cnf(neq74,axiom,
    neq(truck2,s2) ).

cnf(neq75,axiom,
    neq(truck2,s3) ).

cnf(neq76,axiom,
    neq(truck2,s4) ).

cnf(neq77,axiom,
    neq(truck2,s5) ).

cnf(neq78,axiom,
    neq(truck2,s6) ).

cnf(neq79,axiom,
    neq(truck2,s7) ).

cnf(neq80,axiom,
    neq(truck2,s8) ).

cnf(neq81,axiom,
    neq(truck2,s9) ).

cnf(neq82,axiom,
    neq(truck2,s10) ).

cnf(neq83,axiom,
    neq(truck2,s11) ).

cnf(neq84,axiom,
    neq(truck2,s12) ).

cnf(neq85,axiom,
    neq(truck2,s13) ).

cnf(neq86,axiom,
    neq(truck2,s14) ).

cnf(neq87,axiom,
    neq(truck2,s15) ).

cnf(neq88,axiom,
    neq(truck2,s16) ).

cnf(neq89,axiom,
    neq(truck2,s17) ).

cnf(neq90,axiom,
    neq(truck2,s18) ).

cnf(neq91,axiom,
    neq(truck2,s19) ).

cnf(neq92,axiom,
    neq(truck2,p0_8) ).

cnf(neq93,axiom,
    neq(truck2,p1_3) ).

cnf(neq94,axiom,
    neq(truck2,p1_4) ).

cnf(neq95,axiom,
    neq(truck2,p1_9) ).

cnf(neq96,axiom,
    neq(truck2,p2_3) ).

cnf(neq97,axiom,
    neq(truck2,p3_10) ).

cnf(neq98,axiom,
    neq(truck2,p3_19) ).

cnf(neq99,axiom,
    neq(truck2,p4_3) ).

cnf(neq100,axiom,
    neq(truck2,p4_6) ).

cnf(neq101,axiom,
    neq(truck2,p5_0) ).

cnf(neq102,axiom,
    neq(truck2,p5_10) ).

cnf(neq103,axiom,
    neq(truck2,p6_7) ).

cnf(neq104,axiom,
    neq(truck2,p6_10) ).

cnf(neq105,axiom,
    neq(truck2,p7_11) ).

cnf(neq106,axiom,
    neq(truck2,p8_2) ).

cnf(neq107,axiom,
    neq(truck2,p8_3) ).

cnf(neq108,axiom,
    neq(truck2,p8_5) ).

cnf(neq109,axiom,
    neq(truck2,p8_10) ).

cnf(neq110,axiom,
    neq(truck2,p9_15) ).

cnf(neq111,axiom,
    neq(truck2,p10_0) ).

cnf(neq112,axiom,
    neq(truck2,p11_3) ).

cnf(neq113,axiom,
    neq(truck2,p11_5) ).

cnf(neq114,axiom,
    neq(truck2,p11_13) ).

cnf(neq115,axiom,
    neq(truck2,p13_10) ).

cnf(neq116,axiom,
    neq(truck2,p13_14) ).

cnf(neq117,axiom,
    neq(truck2,p14_2) ).

cnf(neq118,axiom,
    neq(truck2,p14_7) ).

cnf(neq119,axiom,
    neq(truck2,p14_16) ).

cnf(neq120,axiom,
    neq(truck2,p14_17) ).

cnf(neq121,axiom,
    neq(truck2,p15_0) ).

cnf(neq122,axiom,
    neq(truck2,p15_1) ).

cnf(neq123,axiom,
    neq(truck2,p16_11) ).

cnf(neq124,axiom,
    neq(truck2,p16_18) ).

cnf(neq125,axiom,
    neq(truck2,p16_19) ).

cnf(neq126,axiom,
    neq(truck2,p17_3) ).

cnf(neq127,axiom,
    neq(truck2,p17_5) ).

cnf(neq128,axiom,
    neq(truck2,p17_8) ).

cnf(neq129,axiom,
    neq(truck2,p17_14) ).

cnf(neq130,axiom,
    neq(truck2,p18_15) ).

cnf(neq131,axiom,
    neq(truck2,p19_8) ).

cnf(neq132,axiom,
    neq(truck2,p19_12) ).

cnf(neq133,axiom,
    neq(truck3,truck1) ).

cnf(neq134,axiom,
    neq(truck3,truck2) ).

cnf(neq135,axiom,
    ~ neq(truck3,truck3) ).

cnf(neq136,axiom,
    neq(truck3,truck4) ).

cnf(neq137,axiom,
    neq(truck3,truck5) ).

cnf(neq138,axiom,
    neq(truck3,s0) ).

cnf(neq139,axiom,
    neq(truck3,s1) ).

cnf(neq140,axiom,
    neq(truck3,s2) ).

cnf(neq141,axiom,
    neq(truck3,s3) ).

cnf(neq142,axiom,
    neq(truck3,s4) ).

cnf(neq143,axiom,
    neq(truck3,s5) ).

cnf(neq144,axiom,
    neq(truck3,s6) ).

cnf(neq145,axiom,
    neq(truck3,s7) ).

cnf(neq146,axiom,
    neq(truck3,s8) ).

cnf(neq147,axiom,
    neq(truck3,s9) ).

cnf(neq148,axiom,
    neq(truck3,s10) ).

cnf(neq149,axiom,
    neq(truck3,s11) ).

cnf(neq150,axiom,
    neq(truck3,s12) ).

cnf(neq151,axiom,
    neq(truck3,s13) ).

cnf(neq152,axiom,
    neq(truck3,s14) ).

cnf(neq153,axiom,
    neq(truck3,s15) ).

cnf(neq154,axiom,
    neq(truck3,s16) ).

cnf(neq155,axiom,
    neq(truck3,s17) ).

cnf(neq156,axiom,
    neq(truck3,s18) ).

cnf(neq157,axiom,
    neq(truck3,s19) ).

cnf(neq158,axiom,
    neq(truck3,p0_8) ).

cnf(neq159,axiom,
    neq(truck3,p1_3) ).

cnf(neq160,axiom,
    neq(truck3,p1_4) ).

cnf(neq161,axiom,
    neq(truck3,p1_9) ).

cnf(neq162,axiom,
    neq(truck3,p2_3) ).

cnf(neq163,axiom,
    neq(truck3,p3_10) ).

cnf(neq164,axiom,
    neq(truck3,p3_19) ).

cnf(neq165,axiom,
    neq(truck3,p4_3) ).

cnf(neq166,axiom,
    neq(truck3,p4_6) ).

cnf(neq167,axiom,
    neq(truck3,p5_0) ).

cnf(neq168,axiom,
    neq(truck3,p5_10) ).

cnf(neq169,axiom,
    neq(truck3,p6_7) ).

cnf(neq170,axiom,
    neq(truck3,p6_10) ).

cnf(neq171,axiom,
    neq(truck3,p7_11) ).

cnf(neq172,axiom,
    neq(truck3,p8_2) ).

cnf(neq173,axiom,
    neq(truck3,p8_3) ).

cnf(neq174,axiom,
    neq(truck3,p8_5) ).

cnf(neq175,axiom,
    neq(truck3,p8_10) ).

cnf(neq176,axiom,
    neq(truck3,p9_15) ).

cnf(neq177,axiom,
    neq(truck3,p10_0) ).

cnf(neq178,axiom,
    neq(truck3,p11_3) ).

cnf(neq179,axiom,
    neq(truck3,p11_5) ).

cnf(neq180,axiom,
    neq(truck3,p11_13) ).

cnf(neq181,axiom,
    neq(truck3,p13_10) ).

cnf(neq182,axiom,
    neq(truck3,p13_14) ).

cnf(neq183,axiom,
    neq(truck3,p14_2) ).

cnf(neq184,axiom,
    neq(truck3,p14_7) ).

cnf(neq185,axiom,
    neq(truck3,p14_16) ).

cnf(neq186,axiom,
    neq(truck3,p14_17) ).

cnf(neq187,axiom,
    neq(truck3,p15_0) ).

cnf(neq188,axiom,
    neq(truck3,p15_1) ).

cnf(neq189,axiom,
    neq(truck3,p16_11) ).

cnf(neq190,axiom,
    neq(truck3,p16_18) ).

cnf(neq191,axiom,
    neq(truck3,p16_19) ).

cnf(neq192,axiom,
    neq(truck3,p17_3) ).

cnf(neq193,axiom,
    neq(truck3,p17_5) ).

cnf(neq194,axiom,
    neq(truck3,p17_8) ).

cnf(neq195,axiom,
    neq(truck3,p17_14) ).

cnf(neq196,axiom,
    neq(truck3,p18_15) ).

cnf(neq197,axiom,
    neq(truck3,p19_8) ).

cnf(neq198,axiom,
    neq(truck3,p19_12) ).

cnf(neq199,axiom,
    neq(truck4,truck1) ).

cnf(neq200,axiom,
    neq(truck4,truck2) ).

cnf(neq201,axiom,
    neq(truck4,truck3) ).

cnf(neq202,axiom,
    ~ neq(truck4,truck4) ).

cnf(neq203,axiom,
    neq(truck4,truck5) ).

cnf(neq204,axiom,
    neq(truck4,s0) ).

cnf(neq205,axiom,
    neq(truck4,s1) ).

cnf(neq206,axiom,
    neq(truck4,s2) ).

cnf(neq207,axiom,
    neq(truck4,s3) ).

cnf(neq208,axiom,
    neq(truck4,s4) ).

cnf(neq209,axiom,
    neq(truck4,s5) ).

cnf(neq210,axiom,
    neq(truck4,s6) ).

cnf(neq211,axiom,
    neq(truck4,s7) ).

cnf(neq212,axiom,
    neq(truck4,s8) ).

cnf(neq213,axiom,
    neq(truck4,s9) ).

cnf(neq214,axiom,
    neq(truck4,s10) ).

cnf(neq215,axiom,
    neq(truck4,s11) ).

cnf(neq216,axiom,
    neq(truck4,s12) ).

cnf(neq217,axiom,
    neq(truck4,s13) ).

cnf(neq218,axiom,
    neq(truck4,s14) ).

cnf(neq219,axiom,
    neq(truck4,s15) ).

cnf(neq220,axiom,
    neq(truck4,s16) ).

cnf(neq221,axiom,
    neq(truck4,s17) ).

cnf(neq222,axiom,
    neq(truck4,s18) ).

cnf(neq223,axiom,
    neq(truck4,s19) ).

cnf(neq224,axiom,
    neq(truck4,p0_8) ).

cnf(neq225,axiom,
    neq(truck4,p1_3) ).

cnf(neq226,axiom,
    neq(truck4,p1_4) ).

cnf(neq227,axiom,
    neq(truck4,p1_9) ).

cnf(neq228,axiom,
    neq(truck4,p2_3) ).

cnf(neq229,axiom,
    neq(truck4,p3_10) ).

cnf(neq230,axiom,
    neq(truck4,p3_19) ).

cnf(neq231,axiom,
    neq(truck4,p4_3) ).

cnf(neq232,axiom,
    neq(truck4,p4_6) ).

cnf(neq233,axiom,
    neq(truck4,p5_0) ).

cnf(neq234,axiom,
    neq(truck4,p5_10) ).

cnf(neq235,axiom,
    neq(truck4,p6_7) ).

cnf(neq236,axiom,
    neq(truck4,p6_10) ).

cnf(neq237,axiom,
    neq(truck4,p7_11) ).

cnf(neq238,axiom,
    neq(truck4,p8_2) ).

cnf(neq239,axiom,
    neq(truck4,p8_3) ).

cnf(neq240,axiom,
    neq(truck4,p8_5) ).

cnf(neq241,axiom,
    neq(truck4,p8_10) ).

cnf(neq242,axiom,
    neq(truck4,p9_15) ).

cnf(neq243,axiom,
    neq(truck4,p10_0) ).

cnf(neq244,axiom,
    neq(truck4,p11_3) ).

cnf(neq245,axiom,
    neq(truck4,p11_5) ).

cnf(neq246,axiom,
    neq(truck4,p11_13) ).

cnf(neq247,axiom,
    neq(truck4,p13_10) ).

cnf(neq248,axiom,
    neq(truck4,p13_14) ).

cnf(neq249,axiom,
    neq(truck4,p14_2) ).

cnf(neq250,axiom,
    neq(truck4,p14_7) ).

cnf(neq251,axiom,
    neq(truck4,p14_16) ).

cnf(neq252,axiom,
    neq(truck4,p14_17) ).

cnf(neq253,axiom,
    neq(truck4,p15_0) ).

cnf(neq254,axiom,
    neq(truck4,p15_1) ).

cnf(neq255,axiom,
    neq(truck4,p16_11) ).

cnf(neq256,axiom,
    neq(truck4,p16_18) ).

cnf(neq257,axiom,
    neq(truck4,p16_19) ).

cnf(neq258,axiom,
    neq(truck4,p17_3) ).

cnf(neq259,axiom,
    neq(truck4,p17_5) ).

cnf(neq260,axiom,
    neq(truck4,p17_8) ).

cnf(neq261,axiom,
    neq(truck4,p17_14) ).

cnf(neq262,axiom,
    neq(truck4,p18_15) ).

cnf(neq263,axiom,
    neq(truck4,p19_8) ).

cnf(neq264,axiom,
    neq(truck4,p19_12) ).

cnf(neq265,axiom,
    neq(truck5,truck1) ).

cnf(neq266,axiom,
    neq(truck5,truck2) ).

cnf(neq267,axiom,
    neq(truck5,truck3) ).

cnf(neq268,axiom,
    neq(truck5,truck4) ).

cnf(neq269,axiom,
    ~ neq(truck5,truck5) ).

cnf(neq270,axiom,
    neq(truck5,s0) ).

cnf(neq271,axiom,
    neq(truck5,s1) ).

cnf(neq272,axiom,
    neq(truck5,s2) ).

cnf(neq273,axiom,
    neq(truck5,s3) ).

cnf(neq274,axiom,
    neq(truck5,s4) ).

cnf(neq275,axiom,
    neq(truck5,s5) ).

cnf(neq276,axiom,
    neq(truck5,s6) ).

cnf(neq277,axiom,
    neq(truck5,s7) ).

cnf(neq278,axiom,
    neq(truck5,s8) ).

cnf(neq279,axiom,
    neq(truck5,s9) ).

cnf(neq280,axiom,
    neq(truck5,s10) ).

cnf(neq281,axiom,
    neq(truck5,s11) ).

cnf(neq282,axiom,
    neq(truck5,s12) ).

cnf(neq283,axiom,
    neq(truck5,s13) ).

cnf(neq284,axiom,
    neq(truck5,s14) ).

cnf(neq285,axiom,
    neq(truck5,s15) ).

cnf(neq286,axiom,
    neq(truck5,s16) ).

cnf(neq287,axiom,
    neq(truck5,s17) ).

cnf(neq288,axiom,
    neq(truck5,s18) ).

cnf(neq289,axiom,
    neq(truck5,s19) ).

cnf(neq290,axiom,
    neq(truck5,p0_8) ).

cnf(neq291,axiom,
    neq(truck5,p1_3) ).

cnf(neq292,axiom,
    neq(truck5,p1_4) ).

cnf(neq293,axiom,
    neq(truck5,p1_9) ).

cnf(neq294,axiom,
    neq(truck5,p2_3) ).

cnf(neq295,axiom,
    neq(truck5,p3_10) ).

cnf(neq296,axiom,
    neq(truck5,p3_19) ).

cnf(neq297,axiom,
    neq(truck5,p4_3) ).

cnf(neq298,axiom,
    neq(truck5,p4_6) ).

cnf(neq299,axiom,
    neq(truck5,p5_0) ).

cnf(neq300,axiom,
    neq(truck5,p5_10) ).

cnf(neq301,axiom,
    neq(truck5,p6_7) ).

cnf(neq302,axiom,
    neq(truck5,p6_10) ).

cnf(neq303,axiom,
    neq(truck5,p7_11) ).

cnf(neq304,axiom,
    neq(truck5,p8_2) ).

cnf(neq305,axiom,
    neq(truck5,p8_3) ).

cnf(neq306,axiom,
    neq(truck5,p8_5) ).

cnf(neq307,axiom,
    neq(truck5,p8_10) ).

cnf(neq308,axiom,
    neq(truck5,p9_15) ).

cnf(neq309,axiom,
    neq(truck5,p10_0) ).

cnf(neq310,axiom,
    neq(truck5,p11_3) ).

cnf(neq311,axiom,
    neq(truck5,p11_5) ).

cnf(neq312,axiom,
    neq(truck5,p11_13) ).

cnf(neq313,axiom,
    neq(truck5,p13_10) ).

cnf(neq314,axiom,
    neq(truck5,p13_14) ).

cnf(neq315,axiom,
    neq(truck5,p14_2) ).

cnf(neq316,axiom,
    neq(truck5,p14_7) ).

cnf(neq317,axiom,
    neq(truck5,p14_16) ).

cnf(neq318,axiom,
    neq(truck5,p14_17) ).

cnf(neq319,axiom,
    neq(truck5,p15_0) ).

cnf(neq320,axiom,
    neq(truck5,p15_1) ).

cnf(neq321,axiom,
    neq(truck5,p16_11) ).

cnf(neq322,axiom,
    neq(truck5,p16_18) ).

cnf(neq323,axiom,
    neq(truck5,p16_19) ).

cnf(neq324,axiom,
    neq(truck5,p17_3) ).

cnf(neq325,axiom,
    neq(truck5,p17_5) ).

cnf(neq326,axiom,
    neq(truck5,p17_8) ).

cnf(neq327,axiom,
    neq(truck5,p17_14) ).

cnf(neq328,axiom,
    neq(truck5,p18_15) ).

cnf(neq329,axiom,
    neq(truck5,p19_8) ).

cnf(neq330,axiom,
    neq(truck5,p19_12) ).

cnf(neq331,axiom,
    neq(s0,truck1) ).

cnf(neq332,axiom,
    neq(s0,truck2) ).

cnf(neq333,axiom,
    neq(s0,truck3) ).

cnf(neq334,axiom,
    neq(s0,truck4) ).

cnf(neq335,axiom,
    neq(s0,truck5) ).

cnf(neq336,axiom,
    ~ neq(s0,s0) ).

cnf(neq337,axiom,
    neq(s0,s1) ).

cnf(neq338,axiom,
    neq(s0,s2) ).

cnf(neq339,axiom,
    neq(s0,s3) ).

cnf(neq340,axiom,
    neq(s0,s4) ).

cnf(neq341,axiom,
    neq(s0,s5) ).

cnf(neq342,axiom,
    neq(s0,s6) ).

cnf(neq343,axiom,
    neq(s0,s7) ).

cnf(neq344,axiom,
    neq(s0,s8) ).

cnf(neq345,axiom,
    neq(s0,s9) ).

cnf(neq346,axiom,
    neq(s0,s10) ).

cnf(neq347,axiom,
    neq(s0,s11) ).

cnf(neq348,axiom,
    neq(s0,s12) ).

cnf(neq349,axiom,
    neq(s0,s13) ).

cnf(neq350,axiom,
    neq(s0,s14) ).

cnf(neq351,axiom,
    neq(s0,s15) ).

cnf(neq352,axiom,
    neq(s0,s16) ).

cnf(neq353,axiom,
    neq(s0,s17) ).

cnf(neq354,axiom,
    neq(s0,s18) ).

cnf(neq355,axiom,
    neq(s0,s19) ).

cnf(neq356,axiom,
    neq(s0,p0_8) ).

cnf(neq357,axiom,
    neq(s0,p1_3) ).

cnf(neq358,axiom,
    neq(s0,p1_4) ).

cnf(neq359,axiom,
    neq(s0,p1_9) ).

cnf(neq360,axiom,
    neq(s0,p2_3) ).

cnf(neq361,axiom,
    neq(s0,p3_10) ).

cnf(neq362,axiom,
    neq(s0,p3_19) ).

cnf(neq363,axiom,
    neq(s0,p4_3) ).

cnf(neq364,axiom,
    neq(s0,p4_6) ).

cnf(neq365,axiom,
    neq(s0,p5_0) ).

cnf(neq366,axiom,
    neq(s0,p5_10) ).

cnf(neq367,axiom,
    neq(s0,p6_7) ).

cnf(neq368,axiom,
    neq(s0,p6_10) ).

cnf(neq369,axiom,
    neq(s0,p7_11) ).

cnf(neq370,axiom,
    neq(s0,p8_2) ).

cnf(neq371,axiom,
    neq(s0,p8_3) ).

cnf(neq372,axiom,
    neq(s0,p8_5) ).

cnf(neq373,axiom,
    neq(s0,p8_10) ).

cnf(neq374,axiom,
    neq(s0,p9_15) ).

cnf(neq375,axiom,
    neq(s0,p10_0) ).

cnf(neq376,axiom,
    neq(s0,p11_3) ).

cnf(neq377,axiom,
    neq(s0,p11_5) ).

cnf(neq378,axiom,
    neq(s0,p11_13) ).

cnf(neq379,axiom,
    neq(s0,p13_10) ).

cnf(neq380,axiom,
    neq(s0,p13_14) ).

cnf(neq381,axiom,
    neq(s0,p14_2) ).

cnf(neq382,axiom,
    neq(s0,p14_7) ).

cnf(neq383,axiom,
    neq(s0,p14_16) ).

cnf(neq384,axiom,
    neq(s0,p14_17) ).

cnf(neq385,axiom,
    neq(s0,p15_0) ).

cnf(neq386,axiom,
    neq(s0,p15_1) ).

cnf(neq387,axiom,
    neq(s0,p16_11) ).

cnf(neq388,axiom,
    neq(s0,p16_18) ).

cnf(neq389,axiom,
    neq(s0,p16_19) ).

cnf(neq390,axiom,
    neq(s0,p17_3) ).

cnf(neq391,axiom,
    neq(s0,p17_5) ).

cnf(neq392,axiom,
    neq(s0,p17_8) ).

cnf(neq393,axiom,
    neq(s0,p17_14) ).

cnf(neq394,axiom,
    neq(s0,p18_15) ).

cnf(neq395,axiom,
    neq(s0,p19_8) ).

cnf(neq396,axiom,
    neq(s0,p19_12) ).

cnf(neq397,axiom,
    neq(s1,truck1) ).

cnf(neq398,axiom,
    neq(s1,truck2) ).

cnf(neq399,axiom,
    neq(s1,truck3) ).

cnf(neq400,axiom,
    neq(s1,truck4) ).

cnf(neq401,axiom,
    neq(s1,truck5) ).

cnf(neq402,axiom,
    neq(s1,s0) ).

cnf(neq403,axiom,
    ~ neq(s1,s1) ).

cnf(neq404,axiom,
    neq(s1,s2) ).

cnf(neq405,axiom,
    neq(s1,s3) ).

cnf(neq406,axiom,
    neq(s1,s4) ).

cnf(neq407,axiom,
    neq(s1,s5) ).

cnf(neq408,axiom,
    neq(s1,s6) ).

cnf(neq409,axiom,
    neq(s1,s7) ).

cnf(neq410,axiom,
    neq(s1,s8) ).

cnf(neq411,axiom,
    neq(s1,s9) ).

cnf(neq412,axiom,
    neq(s1,s10) ).

cnf(neq413,axiom,
    neq(s1,s11) ).

cnf(neq414,axiom,
    neq(s1,s12) ).

cnf(neq415,axiom,
    neq(s1,s13) ).

cnf(neq416,axiom,
    neq(s1,s14) ).

cnf(neq417,axiom,
    neq(s1,s15) ).

cnf(neq418,axiom,
    neq(s1,s16) ).

cnf(neq419,axiom,
    neq(s1,s17) ).

cnf(neq420,axiom,
    neq(s1,s18) ).

cnf(neq421,axiom,
    neq(s1,s19) ).

cnf(neq422,axiom,
    neq(s1,p0_8) ).

cnf(neq423,axiom,
    neq(s1,p1_3) ).

cnf(neq424,axiom,
    neq(s1,p1_4) ).

cnf(neq425,axiom,
    neq(s1,p1_9) ).

cnf(neq426,axiom,
    neq(s1,p2_3) ).

cnf(neq427,axiom,
    neq(s1,p3_10) ).

cnf(neq428,axiom,
    neq(s1,p3_19) ).

cnf(neq429,axiom,
    neq(s1,p4_3) ).

cnf(neq430,axiom,
    neq(s1,p4_6) ).

cnf(neq431,axiom,
    neq(s1,p5_0) ).

cnf(neq432,axiom,
    neq(s1,p5_10) ).

cnf(neq433,axiom,
    neq(s1,p6_7) ).

cnf(neq434,axiom,
    neq(s1,p6_10) ).

cnf(neq435,axiom,
    neq(s1,p7_11) ).

cnf(neq436,axiom,
    neq(s1,p8_2) ).

cnf(neq437,axiom,
    neq(s1,p8_3) ).

cnf(neq438,axiom,
    neq(s1,p8_5) ).

cnf(neq439,axiom,
    neq(s1,p8_10) ).

cnf(neq440,axiom,
    neq(s1,p9_15) ).

cnf(neq441,axiom,
    neq(s1,p10_0) ).

cnf(neq442,axiom,
    neq(s1,p11_3) ).

cnf(neq443,axiom,
    neq(s1,p11_5) ).

cnf(neq444,axiom,
    neq(s1,p11_13) ).

cnf(neq445,axiom,
    neq(s1,p13_10) ).

cnf(neq446,axiom,
    neq(s1,p13_14) ).

cnf(neq447,axiom,
    neq(s1,p14_2) ).

cnf(neq448,axiom,
    neq(s1,p14_7) ).

cnf(neq449,axiom,
    neq(s1,p14_16) ).

cnf(neq450,axiom,
    neq(s1,p14_17) ).

cnf(neq451,axiom,
    neq(s1,p15_0) ).

cnf(neq452,axiom,
    neq(s1,p15_1) ).

cnf(neq453,axiom,
    neq(s1,p16_11) ).

cnf(neq454,axiom,
    neq(s1,p16_18) ).

cnf(neq455,axiom,
    neq(s1,p16_19) ).

cnf(neq456,axiom,
    neq(s1,p17_3) ).

cnf(neq457,axiom,
    neq(s1,p17_5) ).

cnf(neq458,axiom,
    neq(s1,p17_8) ).

cnf(neq459,axiom,
    neq(s1,p17_14) ).

cnf(neq460,axiom,
    neq(s1,p18_15) ).

cnf(neq461,axiom,
    neq(s1,p19_8) ).

cnf(neq462,axiom,
    neq(s1,p19_12) ).

cnf(neq463,axiom,
    neq(s2,truck1) ).

cnf(neq464,axiom,
    neq(s2,truck2) ).

cnf(neq465,axiom,
    neq(s2,truck3) ).

cnf(neq466,axiom,
    neq(s2,truck4) ).

cnf(neq467,axiom,
    neq(s2,truck5) ).

cnf(neq468,axiom,
    neq(s2,s0) ).

cnf(neq469,axiom,
    neq(s2,s1) ).

cnf(neq470,axiom,
    ~ neq(s2,s2) ).

cnf(neq471,axiom,
    neq(s2,s3) ).

cnf(neq472,axiom,
    neq(s2,s4) ).

cnf(neq473,axiom,
    neq(s2,s5) ).

cnf(neq474,axiom,
    neq(s2,s6) ).

cnf(neq475,axiom,
    neq(s2,s7) ).

cnf(neq476,axiom,
    neq(s2,s8) ).

cnf(neq477,axiom,
    neq(s2,s9) ).

cnf(neq478,axiom,
    neq(s2,s10) ).

cnf(neq479,axiom,
    neq(s2,s11) ).

cnf(neq480,axiom,
    neq(s2,s12) ).

cnf(neq481,axiom,
    neq(s2,s13) ).

cnf(neq482,axiom,
    neq(s2,s14) ).

cnf(neq483,axiom,
    neq(s2,s15) ).

cnf(neq484,axiom,
    neq(s2,s16) ).

cnf(neq485,axiom,
    neq(s2,s17) ).

cnf(neq486,axiom,
    neq(s2,s18) ).

cnf(neq487,axiom,
    neq(s2,s19) ).

cnf(neq488,axiom,
    neq(s2,p0_8) ).

cnf(neq489,axiom,
    neq(s2,p1_3) ).

cnf(neq490,axiom,
    neq(s2,p1_4) ).

cnf(neq491,axiom,
    neq(s2,p1_9) ).

cnf(neq492,axiom,
    neq(s2,p2_3) ).

cnf(neq493,axiom,
    neq(s2,p3_10) ).

cnf(neq494,axiom,
    neq(s2,p3_19) ).

cnf(neq495,axiom,
    neq(s2,p4_3) ).

cnf(neq496,axiom,
    neq(s2,p4_6) ).

cnf(neq497,axiom,
    neq(s2,p5_0) ).

cnf(neq498,axiom,
    neq(s2,p5_10) ).

cnf(neq499,axiom,
    neq(s2,p6_7) ).

cnf(neq500,axiom,
    neq(s2,p6_10) ).

cnf(neq501,axiom,
    neq(s2,p7_11) ).

cnf(neq502,axiom,
    neq(s2,p8_2) ).

cnf(neq503,axiom,
    neq(s2,p8_3) ).

cnf(neq504,axiom,
    neq(s2,p8_5) ).

cnf(neq505,axiom,
    neq(s2,p8_10) ).

cnf(neq506,axiom,
    neq(s2,p9_15) ).

cnf(neq507,axiom,
    neq(s2,p10_0) ).

cnf(neq508,axiom,
    neq(s2,p11_3) ).

cnf(neq509,axiom,
    neq(s2,p11_5) ).

cnf(neq510,axiom,
    neq(s2,p11_13) ).

cnf(neq511,axiom,
    neq(s2,p13_10) ).

cnf(neq512,axiom,
    neq(s2,p13_14) ).

cnf(neq513,axiom,
    neq(s2,p14_2) ).

cnf(neq514,axiom,
    neq(s2,p14_7) ).

cnf(neq515,axiom,
    neq(s2,p14_16) ).

cnf(neq516,axiom,
    neq(s2,p14_17) ).

cnf(neq517,axiom,
    neq(s2,p15_0) ).

cnf(neq518,axiom,
    neq(s2,p15_1) ).

cnf(neq519,axiom,
    neq(s2,p16_11) ).

cnf(neq520,axiom,
    neq(s2,p16_18) ).

cnf(neq521,axiom,
    neq(s2,p16_19) ).

cnf(neq522,axiom,
    neq(s2,p17_3) ).

cnf(neq523,axiom,
    neq(s2,p17_5) ).

cnf(neq524,axiom,
    neq(s2,p17_8) ).

cnf(neq525,axiom,
    neq(s2,p17_14) ).

cnf(neq526,axiom,
    neq(s2,p18_15) ).

cnf(neq527,axiom,
    neq(s2,p19_8) ).

cnf(neq528,axiom,
    neq(s2,p19_12) ).

cnf(neq529,axiom,
    neq(s3,truck1) ).

cnf(neq530,axiom,
    neq(s3,truck2) ).

cnf(neq531,axiom,
    neq(s3,truck3) ).

cnf(neq532,axiom,
    neq(s3,truck4) ).

cnf(neq533,axiom,
    neq(s3,truck5) ).

cnf(neq534,axiom,
    neq(s3,s0) ).

cnf(neq535,axiom,
    neq(s3,s1) ).

cnf(neq536,axiom,
    neq(s3,s2) ).

cnf(neq537,axiom,
    ~ neq(s3,s3) ).

cnf(neq538,axiom,
    neq(s3,s4) ).

cnf(neq539,axiom,
    neq(s3,s5) ).

cnf(neq540,axiom,
    neq(s3,s6) ).

cnf(neq541,axiom,
    neq(s3,s7) ).

cnf(neq542,axiom,
    neq(s3,s8) ).

cnf(neq543,axiom,
    neq(s3,s9) ).

cnf(neq544,axiom,
    neq(s3,s10) ).

cnf(neq545,axiom,
    neq(s3,s11) ).

cnf(neq546,axiom,
    neq(s3,s12) ).

cnf(neq547,axiom,
    neq(s3,s13) ).

cnf(neq548,axiom,
    neq(s3,s14) ).

cnf(neq549,axiom,
    neq(s3,s15) ).

cnf(neq550,axiom,
    neq(s3,s16) ).

cnf(neq551,axiom,
    neq(s3,s17) ).

cnf(neq552,axiom,
    neq(s3,s18) ).

cnf(neq553,axiom,
    neq(s3,s19) ).

cnf(neq554,axiom,
    neq(s3,p0_8) ).

cnf(neq555,axiom,
    neq(s3,p1_3) ).

cnf(neq556,axiom,
    neq(s3,p1_4) ).

cnf(neq557,axiom,
    neq(s3,p1_9) ).

cnf(neq558,axiom,
    neq(s3,p2_3) ).

cnf(neq559,axiom,
    neq(s3,p3_10) ).

cnf(neq560,axiom,
    neq(s3,p3_19) ).

cnf(neq561,axiom,
    neq(s3,p4_3) ).

cnf(neq562,axiom,
    neq(s3,p4_6) ).

cnf(neq563,axiom,
    neq(s3,p5_0) ).

cnf(neq564,axiom,
    neq(s3,p5_10) ).

cnf(neq565,axiom,
    neq(s3,p6_7) ).

cnf(neq566,axiom,
    neq(s3,p6_10) ).

cnf(neq567,axiom,
    neq(s3,p7_11) ).

cnf(neq568,axiom,
    neq(s3,p8_2) ).

cnf(neq569,axiom,
    neq(s3,p8_3) ).

cnf(neq570,axiom,
    neq(s3,p8_5) ).

cnf(neq571,axiom,
    neq(s3,p8_10) ).

cnf(neq572,axiom,
    neq(s3,p9_15) ).

cnf(neq573,axiom,
    neq(s3,p10_0) ).

cnf(neq574,axiom,
    neq(s3,p11_3) ).

cnf(neq575,axiom,
    neq(s3,p11_5) ).

cnf(neq576,axiom,
    neq(s3,p11_13) ).

cnf(neq577,axiom,
    neq(s3,p13_10) ).

cnf(neq578,axiom,
    neq(s3,p13_14) ).

cnf(neq579,axiom,
    neq(s3,p14_2) ).

cnf(neq580,axiom,
    neq(s3,p14_7) ).

cnf(neq581,axiom,
    neq(s3,p14_16) ).

cnf(neq582,axiom,
    neq(s3,p14_17) ).

cnf(neq583,axiom,
    neq(s3,p15_0) ).

cnf(neq584,axiom,
    neq(s3,p15_1) ).

cnf(neq585,axiom,
    neq(s3,p16_11) ).

cnf(neq586,axiom,
    neq(s3,p16_18) ).

cnf(neq587,axiom,
    neq(s3,p16_19) ).

cnf(neq588,axiom,
    neq(s3,p17_3) ).

cnf(neq589,axiom,
    neq(s3,p17_5) ).

cnf(neq590,axiom,
    neq(s3,p17_8) ).

cnf(neq591,axiom,
    neq(s3,p17_14) ).

cnf(neq592,axiom,
    neq(s3,p18_15) ).

cnf(neq593,axiom,
    neq(s3,p19_8) ).

cnf(neq594,axiom,
    neq(s3,p19_12) ).

cnf(neq595,axiom,
    neq(s4,truck1) ).

cnf(neq596,axiom,
    neq(s4,truck2) ).

cnf(neq597,axiom,
    neq(s4,truck3) ).

cnf(neq598,axiom,
    neq(s4,truck4) ).

cnf(neq599,axiom,
    neq(s4,truck5) ).

cnf(neq600,axiom,
    neq(s4,s0) ).

cnf(neq601,axiom,
    neq(s4,s1) ).

cnf(neq602,axiom,
    neq(s4,s2) ).

cnf(neq603,axiom,
    neq(s4,s3) ).

cnf(neq604,axiom,
    ~ neq(s4,s4) ).

cnf(neq605,axiom,
    neq(s4,s5) ).

cnf(neq606,axiom,
    neq(s4,s6) ).

cnf(neq607,axiom,
    neq(s4,s7) ).

cnf(neq608,axiom,
    neq(s4,s8) ).

cnf(neq609,axiom,
    neq(s4,s9) ).

cnf(neq610,axiom,
    neq(s4,s10) ).

cnf(neq611,axiom,
    neq(s4,s11) ).

cnf(neq612,axiom,
    neq(s4,s12) ).

cnf(neq613,axiom,
    neq(s4,s13) ).

cnf(neq614,axiom,
    neq(s4,s14) ).

cnf(neq615,axiom,
    neq(s4,s15) ).

cnf(neq616,axiom,
    neq(s4,s16) ).

cnf(neq617,axiom,
    neq(s4,s17) ).

cnf(neq618,axiom,
    neq(s4,s18) ).

cnf(neq619,axiom,
    neq(s4,s19) ).

cnf(neq620,axiom,
    neq(s4,p0_8) ).

cnf(neq621,axiom,
    neq(s4,p1_3) ).

cnf(neq622,axiom,
    neq(s4,p1_4) ).

cnf(neq623,axiom,
    neq(s4,p1_9) ).

cnf(neq624,axiom,
    neq(s4,p2_3) ).

cnf(neq625,axiom,
    neq(s4,p3_10) ).

cnf(neq626,axiom,
    neq(s4,p3_19) ).

cnf(neq627,axiom,
    neq(s4,p4_3) ).

cnf(neq628,axiom,
    neq(s4,p4_6) ).

cnf(neq629,axiom,
    neq(s4,p5_0) ).

cnf(neq630,axiom,
    neq(s4,p5_10) ).

cnf(neq631,axiom,
    neq(s4,p6_7) ).

cnf(neq632,axiom,
    neq(s4,p6_10) ).

cnf(neq633,axiom,
    neq(s4,p7_11) ).

cnf(neq634,axiom,
    neq(s4,p8_2) ).

cnf(neq635,axiom,
    neq(s4,p8_3) ).

cnf(neq636,axiom,
    neq(s4,p8_5) ).

cnf(neq637,axiom,
    neq(s4,p8_10) ).

cnf(neq638,axiom,
    neq(s4,p9_15) ).

cnf(neq639,axiom,
    neq(s4,p10_0) ).

cnf(neq640,axiom,
    neq(s4,p11_3) ).

cnf(neq641,axiom,
    neq(s4,p11_5) ).

cnf(neq642,axiom,
    neq(s4,p11_13) ).

cnf(neq643,axiom,
    neq(s4,p13_10) ).

cnf(neq644,axiom,
    neq(s4,p13_14) ).

cnf(neq645,axiom,
    neq(s4,p14_2) ).

cnf(neq646,axiom,
    neq(s4,p14_7) ).

cnf(neq647,axiom,
    neq(s4,p14_16) ).

cnf(neq648,axiom,
    neq(s4,p14_17) ).

cnf(neq649,axiom,
    neq(s4,p15_0) ).

cnf(neq650,axiom,
    neq(s4,p15_1) ).

cnf(neq651,axiom,
    neq(s4,p16_11) ).

cnf(neq652,axiom,
    neq(s4,p16_18) ).

cnf(neq653,axiom,
    neq(s4,p16_19) ).

cnf(neq654,axiom,
    neq(s4,p17_3) ).

cnf(neq655,axiom,
    neq(s4,p17_5) ).

cnf(neq656,axiom,
    neq(s4,p17_8) ).

cnf(neq657,axiom,
    neq(s4,p17_14) ).

cnf(neq658,axiom,
    neq(s4,p18_15) ).

cnf(neq659,axiom,
    neq(s4,p19_8) ).

cnf(neq660,axiom,
    neq(s4,p19_12) ).

cnf(neq661,axiom,
    neq(s5,truck1) ).

cnf(neq662,axiom,
    neq(s5,truck2) ).

cnf(neq663,axiom,
    neq(s5,truck3) ).

cnf(neq664,axiom,
    neq(s5,truck4) ).

cnf(neq665,axiom,
    neq(s5,truck5) ).

cnf(neq666,axiom,
    neq(s5,s0) ).

cnf(neq667,axiom,
    neq(s5,s1) ).

cnf(neq668,axiom,
    neq(s5,s2) ).

cnf(neq669,axiom,
    neq(s5,s3) ).

cnf(neq670,axiom,
    neq(s5,s4) ).

cnf(neq671,axiom,
    ~ neq(s5,s5) ).

cnf(neq672,axiom,
    neq(s5,s6) ).

cnf(neq673,axiom,
    neq(s5,s7) ).

cnf(neq674,axiom,
    neq(s5,s8) ).

cnf(neq675,axiom,
    neq(s5,s9) ).

cnf(neq676,axiom,
    neq(s5,s10) ).

cnf(neq677,axiom,
    neq(s5,s11) ).

cnf(neq678,axiom,
    neq(s5,s12) ).

cnf(neq679,axiom,
    neq(s5,s13) ).

cnf(neq680,axiom,
    neq(s5,s14) ).

cnf(neq681,axiom,
    neq(s5,s15) ).

cnf(neq682,axiom,
    neq(s5,s16) ).

cnf(neq683,axiom,
    neq(s5,s17) ).

cnf(neq684,axiom,
    neq(s5,s18) ).

cnf(neq685,axiom,
    neq(s5,s19) ).

cnf(neq686,axiom,
    neq(s5,p0_8) ).

cnf(neq687,axiom,
    neq(s5,p1_3) ).

cnf(neq688,axiom,
    neq(s5,p1_4) ).

cnf(neq689,axiom,
    neq(s5,p1_9) ).

cnf(neq690,axiom,
    neq(s5,p2_3) ).

cnf(neq691,axiom,
    neq(s5,p3_10) ).

cnf(neq692,axiom,
    neq(s5,p3_19) ).

cnf(neq693,axiom,
    neq(s5,p4_3) ).

cnf(neq694,axiom,
    neq(s5,p4_6) ).

cnf(neq695,axiom,
    neq(s5,p5_0) ).

cnf(neq696,axiom,
    neq(s5,p5_10) ).

cnf(neq697,axiom,
    neq(s5,p6_7) ).

cnf(neq698,axiom,
    neq(s5,p6_10) ).

cnf(neq699,axiom,
    neq(s5,p7_11) ).

cnf(neq700,axiom,
    neq(s5,p8_2) ).

cnf(neq701,axiom,
    neq(s5,p8_3) ).

cnf(neq702,axiom,
    neq(s5,p8_5) ).

cnf(neq703,axiom,
    neq(s5,p8_10) ).

cnf(neq704,axiom,
    neq(s5,p9_15) ).

cnf(neq705,axiom,
    neq(s5,p10_0) ).

cnf(neq706,axiom,
    neq(s5,p11_3) ).

cnf(neq707,axiom,
    neq(s5,p11_5) ).

cnf(neq708,axiom,
    neq(s5,p11_13) ).

cnf(neq709,axiom,
    neq(s5,p13_10) ).

cnf(neq710,axiom,
    neq(s5,p13_14) ).

cnf(neq711,axiom,
    neq(s5,p14_2) ).

cnf(neq712,axiom,
    neq(s5,p14_7) ).

cnf(neq713,axiom,
    neq(s5,p14_16) ).

cnf(neq714,axiom,
    neq(s5,p14_17) ).

cnf(neq715,axiom,
    neq(s5,p15_0) ).

cnf(neq716,axiom,
    neq(s5,p15_1) ).

cnf(neq717,axiom,
    neq(s5,p16_11) ).

cnf(neq718,axiom,
    neq(s5,p16_18) ).

cnf(neq719,axiom,
    neq(s5,p16_19) ).

cnf(neq720,axiom,
    neq(s5,p17_3) ).

cnf(neq721,axiom,
    neq(s5,p17_5) ).

cnf(neq722,axiom,
    neq(s5,p17_8) ).

cnf(neq723,axiom,
    neq(s5,p17_14) ).

cnf(neq724,axiom,
    neq(s5,p18_15) ).

cnf(neq725,axiom,
    neq(s5,p19_8) ).

cnf(neq726,axiom,
    neq(s5,p19_12) ).

cnf(neq727,axiom,
    neq(s6,truck1) ).

cnf(neq728,axiom,
    neq(s6,truck2) ).

cnf(neq729,axiom,
    neq(s6,truck3) ).

cnf(neq730,axiom,
    neq(s6,truck4) ).

cnf(neq731,axiom,
    neq(s6,truck5) ).

cnf(neq732,axiom,
    neq(s6,s0) ).

cnf(neq733,axiom,
    neq(s6,s1) ).

cnf(neq734,axiom,
    neq(s6,s2) ).

cnf(neq735,axiom,
    neq(s6,s3) ).

cnf(neq736,axiom,
    neq(s6,s4) ).

cnf(neq737,axiom,
    neq(s6,s5) ).

cnf(neq738,axiom,
    ~ neq(s6,s6) ).

cnf(neq739,axiom,
    neq(s6,s7) ).

cnf(neq740,axiom,
    neq(s6,s8) ).

cnf(neq741,axiom,
    neq(s6,s9) ).

cnf(neq742,axiom,
    neq(s6,s10) ).

cnf(neq743,axiom,
    neq(s6,s11) ).

cnf(neq744,axiom,
    neq(s6,s12) ).

cnf(neq745,axiom,
    neq(s6,s13) ).

cnf(neq746,axiom,
    neq(s6,s14) ).

cnf(neq747,axiom,
    neq(s6,s15) ).

cnf(neq748,axiom,
    neq(s6,s16) ).

cnf(neq749,axiom,
    neq(s6,s17) ).

cnf(neq750,axiom,
    neq(s6,s18) ).

cnf(neq751,axiom,
    neq(s6,s19) ).

cnf(neq752,axiom,
    neq(s6,p0_8) ).

cnf(neq753,axiom,
    neq(s6,p1_3) ).

cnf(neq754,axiom,
    neq(s6,p1_4) ).

cnf(neq755,axiom,
    neq(s6,p1_9) ).

cnf(neq756,axiom,
    neq(s6,p2_3) ).

cnf(neq757,axiom,
    neq(s6,p3_10) ).

cnf(neq758,axiom,
    neq(s6,p3_19) ).

cnf(neq759,axiom,
    neq(s6,p4_3) ).

cnf(neq760,axiom,
    neq(s6,p4_6) ).

cnf(neq761,axiom,
    neq(s6,p5_0) ).

cnf(neq762,axiom,
    neq(s6,p5_10) ).

cnf(neq763,axiom,
    neq(s6,p6_7) ).

cnf(neq764,axiom,
    neq(s6,p6_10) ).

cnf(neq765,axiom,
    neq(s6,p7_11) ).

cnf(neq766,axiom,
    neq(s6,p8_2) ).

cnf(neq767,axiom,
    neq(s6,p8_3) ).

cnf(neq768,axiom,
    neq(s6,p8_5) ).

cnf(neq769,axiom,
    neq(s6,p8_10) ).

cnf(neq770,axiom,
    neq(s6,p9_15) ).

cnf(neq771,axiom,
    neq(s6,p10_0) ).

cnf(neq772,axiom,
    neq(s6,p11_3) ).

cnf(neq773,axiom,
    neq(s6,p11_5) ).

cnf(neq774,axiom,
    neq(s6,p11_13) ).

cnf(neq775,axiom,
    neq(s6,p13_10) ).

cnf(neq776,axiom,
    neq(s6,p13_14) ).

cnf(neq777,axiom,
    neq(s6,p14_2) ).

cnf(neq778,axiom,
    neq(s6,p14_7) ).

cnf(neq779,axiom,
    neq(s6,p14_16) ).

cnf(neq780,axiom,
    neq(s6,p14_17) ).

cnf(neq781,axiom,
    neq(s6,p15_0) ).

cnf(neq782,axiom,
    neq(s6,p15_1) ).

cnf(neq783,axiom,
    neq(s6,p16_11) ).

cnf(neq784,axiom,
    neq(s6,p16_18) ).

cnf(neq785,axiom,
    neq(s6,p16_19) ).

cnf(neq786,axiom,
    neq(s6,p17_3) ).

cnf(neq787,axiom,
    neq(s6,p17_5) ).

cnf(neq788,axiom,
    neq(s6,p17_8) ).

cnf(neq789,axiom,
    neq(s6,p17_14) ).

cnf(neq790,axiom,
    neq(s6,p18_15) ).

cnf(neq791,axiom,
    neq(s6,p19_8) ).

cnf(neq792,axiom,
    neq(s6,p19_12) ).

cnf(neq793,axiom,
    neq(s7,truck1) ).

cnf(neq794,axiom,
    neq(s7,truck2) ).

cnf(neq795,axiom,
    neq(s7,truck3) ).

cnf(neq796,axiom,
    neq(s7,truck4) ).

cnf(neq797,axiom,
    neq(s7,truck5) ).

cnf(neq798,axiom,
    neq(s7,s0) ).

cnf(neq799,axiom,
    neq(s7,s1) ).

cnf(neq800,axiom,
    neq(s7,s2) ).

cnf(neq801,axiom,
    neq(s7,s3) ).

cnf(neq802,axiom,
    neq(s7,s4) ).

cnf(neq803,axiom,
    neq(s7,s5) ).

cnf(neq804,axiom,
    neq(s7,s6) ).

cnf(neq805,axiom,
    ~ neq(s7,s7) ).

cnf(neq806,axiom,
    neq(s7,s8) ).

cnf(neq807,axiom,
    neq(s7,s9) ).

cnf(neq808,axiom,
    neq(s7,s10) ).

cnf(neq809,axiom,
    neq(s7,s11) ).

cnf(neq810,axiom,
    neq(s7,s12) ).

cnf(neq811,axiom,
    neq(s7,s13) ).

cnf(neq812,axiom,
    neq(s7,s14) ).

cnf(neq813,axiom,
    neq(s7,s15) ).

cnf(neq814,axiom,
    neq(s7,s16) ).

cnf(neq815,axiom,
    neq(s7,s17) ).

cnf(neq816,axiom,
    neq(s7,s18) ).

cnf(neq817,axiom,
    neq(s7,s19) ).

cnf(neq818,axiom,
    neq(s7,p0_8) ).

cnf(neq819,axiom,
    neq(s7,p1_3) ).

cnf(neq820,axiom,
    neq(s7,p1_4) ).

cnf(neq821,axiom,
    neq(s7,p1_9) ).

cnf(neq822,axiom,
    neq(s7,p2_3) ).

cnf(neq823,axiom,
    neq(s7,p3_10) ).

cnf(neq824,axiom,
    neq(s7,p3_19) ).

cnf(neq825,axiom,
    neq(s7,p4_3) ).

cnf(neq826,axiom,
    neq(s7,p4_6) ).

cnf(neq827,axiom,
    neq(s7,p5_0) ).

cnf(neq828,axiom,
    neq(s7,p5_10) ).

cnf(neq829,axiom,
    neq(s7,p6_7) ).

cnf(neq830,axiom,
    neq(s7,p6_10) ).

cnf(neq831,axiom,
    neq(s7,p7_11) ).

cnf(neq832,axiom,
    neq(s7,p8_2) ).

cnf(neq833,axiom,
    neq(s7,p8_3) ).

cnf(neq834,axiom,
    neq(s7,p8_5) ).

cnf(neq835,axiom,
    neq(s7,p8_10) ).

cnf(neq836,axiom,
    neq(s7,p9_15) ).

cnf(neq837,axiom,
    neq(s7,p10_0) ).

cnf(neq838,axiom,
    neq(s7,p11_3) ).

cnf(neq839,axiom,
    neq(s7,p11_5) ).

cnf(neq840,axiom,
    neq(s7,p11_13) ).

cnf(neq841,axiom,
    neq(s7,p13_10) ).

cnf(neq842,axiom,
    neq(s7,p13_14) ).

cnf(neq843,axiom,
    neq(s7,p14_2) ).

cnf(neq844,axiom,
    neq(s7,p14_7) ).

cnf(neq845,axiom,
    neq(s7,p14_16) ).

cnf(neq846,axiom,
    neq(s7,p14_17) ).

cnf(neq847,axiom,
    neq(s7,p15_0) ).

cnf(neq848,axiom,
    neq(s7,p15_1) ).

cnf(neq849,axiom,
    neq(s7,p16_11) ).

cnf(neq850,axiom,
    neq(s7,p16_18) ).

cnf(neq851,axiom,
    neq(s7,p16_19) ).

cnf(neq852,axiom,
    neq(s7,p17_3) ).

cnf(neq853,axiom,
    neq(s7,p17_5) ).

cnf(neq854,axiom,
    neq(s7,p17_8) ).

cnf(neq855,axiom,
    neq(s7,p17_14) ).

cnf(neq856,axiom,
    neq(s7,p18_15) ).

cnf(neq857,axiom,
    neq(s7,p19_8) ).

cnf(neq858,axiom,
    neq(s7,p19_12) ).

cnf(neq859,axiom,
    neq(s8,truck1) ).

cnf(neq860,axiom,
    neq(s8,truck2) ).

cnf(neq861,axiom,
    neq(s8,truck3) ).

cnf(neq862,axiom,
    neq(s8,truck4) ).

cnf(neq863,axiom,
    neq(s8,truck5) ).

cnf(neq864,axiom,
    neq(s8,s0) ).

cnf(neq865,axiom,
    neq(s8,s1) ).

cnf(neq866,axiom,
    neq(s8,s2) ).

cnf(neq867,axiom,
    neq(s8,s3) ).

cnf(neq868,axiom,
    neq(s8,s4) ).

cnf(neq869,axiom,
    neq(s8,s5) ).

cnf(neq870,axiom,
    neq(s8,s6) ).

cnf(neq871,axiom,
    neq(s8,s7) ).

cnf(neq872,axiom,
    ~ neq(s8,s8) ).

cnf(neq873,axiom,
    neq(s8,s9) ).

cnf(neq874,axiom,
    neq(s8,s10) ).

cnf(neq875,axiom,
    neq(s8,s11) ).

cnf(neq876,axiom,
    neq(s8,s12) ).

cnf(neq877,axiom,
    neq(s8,s13) ).

cnf(neq878,axiom,
    neq(s8,s14) ).

cnf(neq879,axiom,
    neq(s8,s15) ).

cnf(neq880,axiom,
    neq(s8,s16) ).

cnf(neq881,axiom,
    neq(s8,s17) ).

cnf(neq882,axiom,
    neq(s8,s18) ).

cnf(neq883,axiom,
    neq(s8,s19) ).

cnf(neq884,axiom,
    neq(s8,p0_8) ).

cnf(neq885,axiom,
    neq(s8,p1_3) ).

cnf(neq886,axiom,
    neq(s8,p1_4) ).

cnf(neq887,axiom,
    neq(s8,p1_9) ).

cnf(neq888,axiom,
    neq(s8,p2_3) ).

cnf(neq889,axiom,
    neq(s8,p3_10) ).

cnf(neq890,axiom,
    neq(s8,p3_19) ).

cnf(neq891,axiom,
    neq(s8,p4_3) ).

cnf(neq892,axiom,
    neq(s8,p4_6) ).

cnf(neq893,axiom,
    neq(s8,p5_0) ).

cnf(neq894,axiom,
    neq(s8,p5_10) ).

cnf(neq895,axiom,
    neq(s8,p6_7) ).

cnf(neq896,axiom,
    neq(s8,p6_10) ).

cnf(neq897,axiom,
    neq(s8,p7_11) ).

cnf(neq898,axiom,
    neq(s8,p8_2) ).

cnf(neq899,axiom,
    neq(s8,p8_3) ).

cnf(neq900,axiom,
    neq(s8,p8_5) ).

cnf(neq901,axiom,
    neq(s8,p8_10) ).

cnf(neq902,axiom,
    neq(s8,p9_15) ).

cnf(neq903,axiom,
    neq(s8,p10_0) ).

cnf(neq904,axiom,
    neq(s8,p11_3) ).

cnf(neq905,axiom,
    neq(s8,p11_5) ).

cnf(neq906,axiom,
    neq(s8,p11_13) ).

cnf(neq907,axiom,
    neq(s8,p13_10) ).

cnf(neq908,axiom,
    neq(s8,p13_14) ).

cnf(neq909,axiom,
    neq(s8,p14_2) ).

cnf(neq910,axiom,
    neq(s8,p14_7) ).

cnf(neq911,axiom,
    neq(s8,p14_16) ).

cnf(neq912,axiom,
    neq(s8,p14_17) ).

cnf(neq913,axiom,
    neq(s8,p15_0) ).

cnf(neq914,axiom,
    neq(s8,p15_1) ).

cnf(neq915,axiom,
    neq(s8,p16_11) ).

cnf(neq916,axiom,
    neq(s8,p16_18) ).

cnf(neq917,axiom,
    neq(s8,p16_19) ).

cnf(neq918,axiom,
    neq(s8,p17_3) ).

cnf(neq919,axiom,
    neq(s8,p17_5) ).

cnf(neq920,axiom,
    neq(s8,p17_8) ).

cnf(neq921,axiom,
    neq(s8,p17_14) ).

cnf(neq922,axiom,
    neq(s8,p18_15) ).

cnf(neq923,axiom,
    neq(s8,p19_8) ).

cnf(neq924,axiom,
    neq(s8,p19_12) ).

cnf(neq925,axiom,
    neq(s9,truck1) ).

cnf(neq926,axiom,
    neq(s9,truck2) ).

cnf(neq927,axiom,
    neq(s9,truck3) ).

cnf(neq928,axiom,
    neq(s9,truck4) ).

cnf(neq929,axiom,
    neq(s9,truck5) ).

cnf(neq930,axiom,
    neq(s9,s0) ).

cnf(neq931,axiom,
    neq(s9,s1) ).

cnf(neq932,axiom,
    neq(s9,s2) ).

cnf(neq933,axiom,
    neq(s9,s3) ).

cnf(neq934,axiom,
    neq(s9,s4) ).

cnf(neq935,axiom,
    neq(s9,s5) ).

cnf(neq936,axiom,
    neq(s9,s6) ).

cnf(neq937,axiom,
    neq(s9,s7) ).

cnf(neq938,axiom,
    neq(s9,s8) ).

cnf(neq939,axiom,
    ~ neq(s9,s9) ).

cnf(neq940,axiom,
    neq(s9,s10) ).

cnf(neq941,axiom,
    neq(s9,s11) ).

cnf(neq942,axiom,
    neq(s9,s12) ).

cnf(neq943,axiom,
    neq(s9,s13) ).

cnf(neq944,axiom,
    neq(s9,s14) ).

cnf(neq945,axiom,
    neq(s9,s15) ).

cnf(neq946,axiom,
    neq(s9,s16) ).

cnf(neq947,axiom,
    neq(s9,s17) ).

cnf(neq948,axiom,
    neq(s9,s18) ).

cnf(neq949,axiom,
    neq(s9,s19) ).

cnf(neq950,axiom,
    neq(s9,p0_8) ).

cnf(neq951,axiom,
    neq(s9,p1_3) ).

cnf(neq952,axiom,
    neq(s9,p1_4) ).

cnf(neq953,axiom,
    neq(s9,p1_9) ).

cnf(neq954,axiom,
    neq(s9,p2_3) ).

cnf(neq955,axiom,
    neq(s9,p3_10) ).

cnf(neq956,axiom,
    neq(s9,p3_19) ).

cnf(neq957,axiom,
    neq(s9,p4_3) ).

cnf(neq958,axiom,
    neq(s9,p4_6) ).

cnf(neq959,axiom,
    neq(s9,p5_0) ).

cnf(neq960,axiom,
    neq(s9,p5_10) ).

cnf(neq961,axiom,
    neq(s9,p6_7) ).

cnf(neq962,axiom,
    neq(s9,p6_10) ).

cnf(neq963,axiom,
    neq(s9,p7_11) ).

cnf(neq964,axiom,
    neq(s9,p8_2) ).

cnf(neq965,axiom,
    neq(s9,p8_3) ).

cnf(neq966,axiom,
    neq(s9,p8_5) ).

cnf(neq967,axiom,
    neq(s9,p8_10) ).

cnf(neq968,axiom,
    neq(s9,p9_15) ).

cnf(neq969,axiom,
    neq(s9,p10_0) ).

cnf(neq970,axiom,
    neq(s9,p11_3) ).

cnf(neq971,axiom,
    neq(s9,p11_5) ).

cnf(neq972,axiom,
    neq(s9,p11_13) ).

cnf(neq973,axiom,
    neq(s9,p13_10) ).

cnf(neq974,axiom,
    neq(s9,p13_14) ).

cnf(neq975,axiom,
    neq(s9,p14_2) ).

cnf(neq976,axiom,
    neq(s9,p14_7) ).

cnf(neq977,axiom,
    neq(s9,p14_16) ).

cnf(neq978,axiom,
    neq(s9,p14_17) ).

cnf(neq979,axiom,
    neq(s9,p15_0) ).

cnf(neq980,axiom,
    neq(s9,p15_1) ).

cnf(neq981,axiom,
    neq(s9,p16_11) ).

cnf(neq982,axiom,
    neq(s9,p16_18) ).

cnf(neq983,axiom,
    neq(s9,p16_19) ).

cnf(neq984,axiom,
    neq(s9,p17_3) ).

cnf(neq985,axiom,
    neq(s9,p17_5) ).

cnf(neq986,axiom,
    neq(s9,p17_8) ).

cnf(neq987,axiom,
    neq(s9,p17_14) ).

cnf(neq988,axiom,
    neq(s9,p18_15) ).

cnf(neq989,axiom,
    neq(s9,p19_8) ).

cnf(neq990,axiom,
    neq(s9,p19_12) ).

cnf(neq991,axiom,
    neq(s10,truck1) ).

cnf(neq992,axiom,
    neq(s10,truck2) ).

cnf(neq993,axiom,
    neq(s10,truck3) ).

cnf(neq994,axiom,
    neq(s10,truck4) ).

cnf(neq995,axiom,
    neq(s10,truck5) ).

cnf(neq996,axiom,
    neq(s10,s0) ).

cnf(neq997,axiom,
    neq(s10,s1) ).

cnf(neq998,axiom,
    neq(s10,s2) ).

cnf(neq999,axiom,
    neq(s10,s3) ).

cnf(neq1000,axiom,
    neq(s10,s4) ).

cnf(neq1001,axiom,
    neq(s10,s5) ).

cnf(neq1002,axiom,
    neq(s10,s6) ).

cnf(neq1003,axiom,
    neq(s10,s7) ).

cnf(neq1004,axiom,
    neq(s10,s8) ).

cnf(neq1005,axiom,
    neq(s10,s9) ).

cnf(neq1006,axiom,
    ~ neq(s10,s10) ).

cnf(neq1007,axiom,
    neq(s10,s11) ).

cnf(neq1008,axiom,
    neq(s10,s12) ).

cnf(neq1009,axiom,
    neq(s10,s13) ).

cnf(neq1010,axiom,
    neq(s10,s14) ).

cnf(neq1011,axiom,
    neq(s10,s15) ).

cnf(neq1012,axiom,
    neq(s10,s16) ).

cnf(neq1013,axiom,
    neq(s10,s17) ).

cnf(neq1014,axiom,
    neq(s10,s18) ).

cnf(neq1015,axiom,
    neq(s10,s19) ).

cnf(neq1016,axiom,
    neq(s10,p0_8) ).

cnf(neq1017,axiom,
    neq(s10,p1_3) ).

cnf(neq1018,axiom,
    neq(s10,p1_4) ).

cnf(neq1019,axiom,
    neq(s10,p1_9) ).

cnf(neq1020,axiom,
    neq(s10,p2_3) ).

cnf(neq1021,axiom,
    neq(s10,p3_10) ).

cnf(neq1022,axiom,
    neq(s10,p3_19) ).

cnf(neq1023,axiom,
    neq(s10,p4_3) ).

cnf(neq1024,axiom,
    neq(s10,p4_6) ).

cnf(neq1025,axiom,
    neq(s10,p5_0) ).

cnf(neq1026,axiom,
    neq(s10,p5_10) ).

cnf(neq1027,axiom,
    neq(s10,p6_7) ).

cnf(neq1028,axiom,
    neq(s10,p6_10) ).

cnf(neq1029,axiom,
    neq(s10,p7_11) ).

cnf(neq1030,axiom,
    neq(s10,p8_2) ).

cnf(neq1031,axiom,
    neq(s10,p8_3) ).

cnf(neq1032,axiom,
    neq(s10,p8_5) ).

cnf(neq1033,axiom,
    neq(s10,p8_10) ).

cnf(neq1034,axiom,
    neq(s10,p9_15) ).

cnf(neq1035,axiom,
    neq(s10,p10_0) ).

cnf(neq1036,axiom,
    neq(s10,p11_3) ).

cnf(neq1037,axiom,
    neq(s10,p11_5) ).

cnf(neq1038,axiom,
    neq(s10,p11_13) ).

cnf(neq1039,axiom,
    neq(s10,p13_10) ).

cnf(neq1040,axiom,
    neq(s10,p13_14) ).

cnf(neq1041,axiom,
    neq(s10,p14_2) ).

cnf(neq1042,axiom,
    neq(s10,p14_7) ).

cnf(neq1043,axiom,
    neq(s10,p14_16) ).

cnf(neq1044,axiom,
    neq(s10,p14_17) ).

cnf(neq1045,axiom,
    neq(s10,p15_0) ).

cnf(neq1046,axiom,
    neq(s10,p15_1) ).

cnf(neq1047,axiom,
    neq(s10,p16_11) ).

cnf(neq1048,axiom,
    neq(s10,p16_18) ).

cnf(neq1049,axiom,
    neq(s10,p16_19) ).

cnf(neq1050,axiom,
    neq(s10,p17_3) ).

cnf(neq1051,axiom,
    neq(s10,p17_5) ).

cnf(neq1052,axiom,
    neq(s10,p17_8) ).

cnf(neq1053,axiom,
    neq(s10,p17_14) ).

cnf(neq1054,axiom,
    neq(s10,p18_15) ).

cnf(neq1055,axiom,
    neq(s10,p19_8) ).

cnf(neq1056,axiom,
    neq(s10,p19_12) ).

cnf(neq1057,axiom,
    neq(s11,truck1) ).

cnf(neq1058,axiom,
    neq(s11,truck2) ).

cnf(neq1059,axiom,
    neq(s11,truck3) ).

cnf(neq1060,axiom,
    neq(s11,truck4) ).

cnf(neq1061,axiom,
    neq(s11,truck5) ).

cnf(neq1062,axiom,
    neq(s11,s0) ).

cnf(neq1063,axiom,
    neq(s11,s1) ).

cnf(neq1064,axiom,
    neq(s11,s2) ).

cnf(neq1065,axiom,
    neq(s11,s3) ).

cnf(neq1066,axiom,
    neq(s11,s4) ).

cnf(neq1067,axiom,
    neq(s11,s5) ).

cnf(neq1068,axiom,
    neq(s11,s6) ).

cnf(neq1069,axiom,
    neq(s11,s7) ).

cnf(neq1070,axiom,
    neq(s11,s8) ).

cnf(neq1071,axiom,
    neq(s11,s9) ).

cnf(neq1072,axiom,
    neq(s11,s10) ).

cnf(neq1073,axiom,
    ~ neq(s11,s11) ).

cnf(neq1074,axiom,
    neq(s11,s12) ).

cnf(neq1075,axiom,
    neq(s11,s13) ).

cnf(neq1076,axiom,
    neq(s11,s14) ).

cnf(neq1077,axiom,
    neq(s11,s15) ).

cnf(neq1078,axiom,
    neq(s11,s16) ).

cnf(neq1079,axiom,
    neq(s11,s17) ).

cnf(neq1080,axiom,
    neq(s11,s18) ).

cnf(neq1081,axiom,
    neq(s11,s19) ).

cnf(neq1082,axiom,
    neq(s11,p0_8) ).

cnf(neq1083,axiom,
    neq(s11,p1_3) ).

cnf(neq1084,axiom,
    neq(s11,p1_4) ).

cnf(neq1085,axiom,
    neq(s11,p1_9) ).

cnf(neq1086,axiom,
    neq(s11,p2_3) ).

cnf(neq1087,axiom,
    neq(s11,p3_10) ).

cnf(neq1088,axiom,
    neq(s11,p3_19) ).

cnf(neq1089,axiom,
    neq(s11,p4_3) ).

cnf(neq1090,axiom,
    neq(s11,p4_6) ).

cnf(neq1091,axiom,
    neq(s11,p5_0) ).

cnf(neq1092,axiom,
    neq(s11,p5_10) ).

cnf(neq1093,axiom,
    neq(s11,p6_7) ).

cnf(neq1094,axiom,
    neq(s11,p6_10) ).

cnf(neq1095,axiom,
    neq(s11,p7_11) ).

cnf(neq1096,axiom,
    neq(s11,p8_2) ).

cnf(neq1097,axiom,
    neq(s11,p8_3) ).

cnf(neq1098,axiom,
    neq(s11,p8_5) ).

cnf(neq1099,axiom,
    neq(s11,p8_10) ).

cnf(neq1100,axiom,
    neq(s11,p9_15) ).

cnf(neq1101,axiom,
    neq(s11,p10_0) ).

cnf(neq1102,axiom,
    neq(s11,p11_3) ).

cnf(neq1103,axiom,
    neq(s11,p11_5) ).

cnf(neq1104,axiom,
    neq(s11,p11_13) ).

cnf(neq1105,axiom,
    neq(s11,p13_10) ).

cnf(neq1106,axiom,
    neq(s11,p13_14) ).

cnf(neq1107,axiom,
    neq(s11,p14_2) ).

cnf(neq1108,axiom,
    neq(s11,p14_7) ).

cnf(neq1109,axiom,
    neq(s11,p14_16) ).

cnf(neq1110,axiom,
    neq(s11,p14_17) ).

cnf(neq1111,axiom,
    neq(s11,p15_0) ).

cnf(neq1112,axiom,
    neq(s11,p15_1) ).

cnf(neq1113,axiom,
    neq(s11,p16_11) ).

cnf(neq1114,axiom,
    neq(s11,p16_18) ).

cnf(neq1115,axiom,
    neq(s11,p16_19) ).

cnf(neq1116,axiom,
    neq(s11,p17_3) ).

cnf(neq1117,axiom,
    neq(s11,p17_5) ).

cnf(neq1118,axiom,
    neq(s11,p17_8) ).

cnf(neq1119,axiom,
    neq(s11,p17_14) ).

cnf(neq1120,axiom,
    neq(s11,p18_15) ).

cnf(neq1121,axiom,
    neq(s11,p19_8) ).

cnf(neq1122,axiom,
    neq(s11,p19_12) ).

cnf(neq1123,axiom,
    neq(s12,truck1) ).

cnf(neq1124,axiom,
    neq(s12,truck2) ).

cnf(neq1125,axiom,
    neq(s12,truck3) ).

cnf(neq1126,axiom,
    neq(s12,truck4) ).

cnf(neq1127,axiom,
    neq(s12,truck5) ).

cnf(neq1128,axiom,
    neq(s12,s0) ).

cnf(neq1129,axiom,
    neq(s12,s1) ).

cnf(neq1130,axiom,
    neq(s12,s2) ).

cnf(neq1131,axiom,
    neq(s12,s3) ).

cnf(neq1132,axiom,
    neq(s12,s4) ).

cnf(neq1133,axiom,
    neq(s12,s5) ).

cnf(neq1134,axiom,
    neq(s12,s6) ).

cnf(neq1135,axiom,
    neq(s12,s7) ).

cnf(neq1136,axiom,
    neq(s12,s8) ).

cnf(neq1137,axiom,
    neq(s12,s9) ).

cnf(neq1138,axiom,
    neq(s12,s10) ).

cnf(neq1139,axiom,
    neq(s12,s11) ).

cnf(neq1140,axiom,
    ~ neq(s12,s12) ).

cnf(neq1141,axiom,
    neq(s12,s13) ).

cnf(neq1142,axiom,
    neq(s12,s14) ).

cnf(neq1143,axiom,
    neq(s12,s15) ).

cnf(neq1144,axiom,
    neq(s12,s16) ).

cnf(neq1145,axiom,
    neq(s12,s17) ).

cnf(neq1146,axiom,
    neq(s12,s18) ).

cnf(neq1147,axiom,
    neq(s12,s19) ).

cnf(neq1148,axiom,
    neq(s12,p0_8) ).

cnf(neq1149,axiom,
    neq(s12,p1_3) ).

cnf(neq1150,axiom,
    neq(s12,p1_4) ).

cnf(neq1151,axiom,
    neq(s12,p1_9) ).

cnf(neq1152,axiom,
    neq(s12,p2_3) ).

cnf(neq1153,axiom,
    neq(s12,p3_10) ).

cnf(neq1154,axiom,
    neq(s12,p3_19) ).

cnf(neq1155,axiom,
    neq(s12,p4_3) ).

cnf(neq1156,axiom,
    neq(s12,p4_6) ).

cnf(neq1157,axiom,
    neq(s12,p5_0) ).

cnf(neq1158,axiom,
    neq(s12,p5_10) ).

cnf(neq1159,axiom,
    neq(s12,p6_7) ).

cnf(neq1160,axiom,
    neq(s12,p6_10) ).

cnf(neq1161,axiom,
    neq(s12,p7_11) ).

cnf(neq1162,axiom,
    neq(s12,p8_2) ).

cnf(neq1163,axiom,
    neq(s12,p8_3) ).

cnf(neq1164,axiom,
    neq(s12,p8_5) ).

cnf(neq1165,axiom,
    neq(s12,p8_10) ).

cnf(neq1166,axiom,
    neq(s12,p9_15) ).

cnf(neq1167,axiom,
    neq(s12,p10_0) ).

cnf(neq1168,axiom,
    neq(s12,p11_3) ).

cnf(neq1169,axiom,
    neq(s12,p11_5) ).

cnf(neq1170,axiom,
    neq(s12,p11_13) ).

cnf(neq1171,axiom,
    neq(s12,p13_10) ).

cnf(neq1172,axiom,
    neq(s12,p13_14) ).

cnf(neq1173,axiom,
    neq(s12,p14_2) ).

cnf(neq1174,axiom,
    neq(s12,p14_7) ).

cnf(neq1175,axiom,
    neq(s12,p14_16) ).

cnf(neq1176,axiom,
    neq(s12,p14_17) ).

cnf(neq1177,axiom,
    neq(s12,p15_0) ).

cnf(neq1178,axiom,
    neq(s12,p15_1) ).

cnf(neq1179,axiom,
    neq(s12,p16_11) ).

cnf(neq1180,axiom,
    neq(s12,p16_18) ).

cnf(neq1181,axiom,
    neq(s12,p16_19) ).

cnf(neq1182,axiom,
    neq(s12,p17_3) ).

cnf(neq1183,axiom,
    neq(s12,p17_5) ).

cnf(neq1184,axiom,
    neq(s12,p17_8) ).

cnf(neq1185,axiom,
    neq(s12,p17_14) ).

cnf(neq1186,axiom,
    neq(s12,p18_15) ).

cnf(neq1187,axiom,
    neq(s12,p19_8) ).

cnf(neq1188,axiom,
    neq(s12,p19_12) ).

cnf(neq1189,axiom,
    neq(s13,truck1) ).

cnf(neq1190,axiom,
    neq(s13,truck2) ).

cnf(neq1191,axiom,
    neq(s13,truck3) ).

cnf(neq1192,axiom,
    neq(s13,truck4) ).

cnf(neq1193,axiom,
    neq(s13,truck5) ).

cnf(neq1194,axiom,
    neq(s13,s0) ).

cnf(neq1195,axiom,
    neq(s13,s1) ).

cnf(neq1196,axiom,
    neq(s13,s2) ).

cnf(neq1197,axiom,
    neq(s13,s3) ).

cnf(neq1198,axiom,
    neq(s13,s4) ).

cnf(neq1199,axiom,
    neq(s13,s5) ).

cnf(neq1200,axiom,
    neq(s13,s6) ).

cnf(neq1201,axiom,
    neq(s13,s7) ).

cnf(neq1202,axiom,
    neq(s13,s8) ).

cnf(neq1203,axiom,
    neq(s13,s9) ).

cnf(neq1204,axiom,
    neq(s13,s10) ).

cnf(neq1205,axiom,
    neq(s13,s11) ).

cnf(neq1206,axiom,
    neq(s13,s12) ).

cnf(neq1207,axiom,
    ~ neq(s13,s13) ).

cnf(neq1208,axiom,
    neq(s13,s14) ).

cnf(neq1209,axiom,
    neq(s13,s15) ).

cnf(neq1210,axiom,
    neq(s13,s16) ).

cnf(neq1211,axiom,
    neq(s13,s17) ).

cnf(neq1212,axiom,
    neq(s13,s18) ).

cnf(neq1213,axiom,
    neq(s13,s19) ).

cnf(neq1214,axiom,
    neq(s13,p0_8) ).

cnf(neq1215,axiom,
    neq(s13,p1_3) ).

cnf(neq1216,axiom,
    neq(s13,p1_4) ).

cnf(neq1217,axiom,
    neq(s13,p1_9) ).

cnf(neq1218,axiom,
    neq(s13,p2_3) ).

cnf(neq1219,axiom,
    neq(s13,p3_10) ).

cnf(neq1220,axiom,
    neq(s13,p3_19) ).

cnf(neq1221,axiom,
    neq(s13,p4_3) ).

cnf(neq1222,axiom,
    neq(s13,p4_6) ).

cnf(neq1223,axiom,
    neq(s13,p5_0) ).

cnf(neq1224,axiom,
    neq(s13,p5_10) ).

cnf(neq1225,axiom,
    neq(s13,p6_7) ).

cnf(neq1226,axiom,
    neq(s13,p6_10) ).

cnf(neq1227,axiom,
    neq(s13,p7_11) ).

cnf(neq1228,axiom,
    neq(s13,p8_2) ).

cnf(neq1229,axiom,
    neq(s13,p8_3) ).

cnf(neq1230,axiom,
    neq(s13,p8_5) ).

cnf(neq1231,axiom,
    neq(s13,p8_10) ).

cnf(neq1232,axiom,
    neq(s13,p9_15) ).

cnf(neq1233,axiom,
    neq(s13,p10_0) ).

cnf(neq1234,axiom,
    neq(s13,p11_3) ).

cnf(neq1235,axiom,
    neq(s13,p11_5) ).

cnf(neq1236,axiom,
    neq(s13,p11_13) ).

cnf(neq1237,axiom,
    neq(s13,p13_10) ).

cnf(neq1238,axiom,
    neq(s13,p13_14) ).

cnf(neq1239,axiom,
    neq(s13,p14_2) ).

cnf(neq1240,axiom,
    neq(s13,p14_7) ).

cnf(neq1241,axiom,
    neq(s13,p14_16) ).

cnf(neq1242,axiom,
    neq(s13,p14_17) ).

cnf(neq1243,axiom,
    neq(s13,p15_0) ).

cnf(neq1244,axiom,
    neq(s13,p15_1) ).

cnf(neq1245,axiom,
    neq(s13,p16_11) ).

cnf(neq1246,axiom,
    neq(s13,p16_18) ).

cnf(neq1247,axiom,
    neq(s13,p16_19) ).

cnf(neq1248,axiom,
    neq(s13,p17_3) ).

cnf(neq1249,axiom,
    neq(s13,p17_5) ).

cnf(neq1250,axiom,
    neq(s13,p17_8) ).

cnf(neq1251,axiom,
    neq(s13,p17_14) ).

cnf(neq1252,axiom,
    neq(s13,p18_15) ).

cnf(neq1253,axiom,
    neq(s13,p19_8) ).

cnf(neq1254,axiom,
    neq(s13,p19_12) ).

cnf(neq1255,axiom,
    neq(s14,truck1) ).

cnf(neq1256,axiom,
    neq(s14,truck2) ).

cnf(neq1257,axiom,
    neq(s14,truck3) ).

cnf(neq1258,axiom,
    neq(s14,truck4) ).

cnf(neq1259,axiom,
    neq(s14,truck5) ).

cnf(neq1260,axiom,
    neq(s14,s0) ).

cnf(neq1261,axiom,
    neq(s14,s1) ).

cnf(neq1262,axiom,
    neq(s14,s2) ).

cnf(neq1263,axiom,
    neq(s14,s3) ).

cnf(neq1264,axiom,
    neq(s14,s4) ).

cnf(neq1265,axiom,
    neq(s14,s5) ).

cnf(neq1266,axiom,
    neq(s14,s6) ).

cnf(neq1267,axiom,
    neq(s14,s7) ).

cnf(neq1268,axiom,
    neq(s14,s8) ).

cnf(neq1269,axiom,
    neq(s14,s9) ).

cnf(neq1270,axiom,
    neq(s14,s10) ).

cnf(neq1271,axiom,
    neq(s14,s11) ).

cnf(neq1272,axiom,
    neq(s14,s12) ).

cnf(neq1273,axiom,
    neq(s14,s13) ).

cnf(neq1274,axiom,
    ~ neq(s14,s14) ).

cnf(neq1275,axiom,
    neq(s14,s15) ).

cnf(neq1276,axiom,
    neq(s14,s16) ).

cnf(neq1277,axiom,
    neq(s14,s17) ).

cnf(neq1278,axiom,
    neq(s14,s18) ).

cnf(neq1279,axiom,
    neq(s14,s19) ).

cnf(neq1280,axiom,
    neq(s14,p0_8) ).

cnf(neq1281,axiom,
    neq(s14,p1_3) ).

cnf(neq1282,axiom,
    neq(s14,p1_4) ).

cnf(neq1283,axiom,
    neq(s14,p1_9) ).

cnf(neq1284,axiom,
    neq(s14,p2_3) ).

cnf(neq1285,axiom,
    neq(s14,p3_10) ).

cnf(neq1286,axiom,
    neq(s14,p3_19) ).

cnf(neq1287,axiom,
    neq(s14,p4_3) ).

cnf(neq1288,axiom,
    neq(s14,p4_6) ).

cnf(neq1289,axiom,
    neq(s14,p5_0) ).

cnf(neq1290,axiom,
    neq(s14,p5_10) ).

cnf(neq1291,axiom,
    neq(s14,p6_7) ).

cnf(neq1292,axiom,
    neq(s14,p6_10) ).

cnf(neq1293,axiom,
    neq(s14,p7_11) ).

cnf(neq1294,axiom,
    neq(s14,p8_2) ).

cnf(neq1295,axiom,
    neq(s14,p8_3) ).

cnf(neq1296,axiom,
    neq(s14,p8_5) ).

cnf(neq1297,axiom,
    neq(s14,p8_10) ).

cnf(neq1298,axiom,
    neq(s14,p9_15) ).

cnf(neq1299,axiom,
    neq(s14,p10_0) ).

cnf(neq1300,axiom,
    neq(s14,p11_3) ).

cnf(neq1301,axiom,
    neq(s14,p11_5) ).

cnf(neq1302,axiom,
    neq(s14,p11_13) ).

cnf(neq1303,axiom,
    neq(s14,p13_10) ).

cnf(neq1304,axiom,
    neq(s14,p13_14) ).

cnf(neq1305,axiom,
    neq(s14,p14_2) ).

cnf(neq1306,axiom,
    neq(s14,p14_7) ).

cnf(neq1307,axiom,
    neq(s14,p14_16) ).

cnf(neq1308,axiom,
    neq(s14,p14_17) ).

cnf(neq1309,axiom,
    neq(s14,p15_0) ).

cnf(neq1310,axiom,
    neq(s14,p15_1) ).

cnf(neq1311,axiom,
    neq(s14,p16_11) ).

cnf(neq1312,axiom,
    neq(s14,p16_18) ).

cnf(neq1313,axiom,
    neq(s14,p16_19) ).

cnf(neq1314,axiom,
    neq(s14,p17_3) ).

cnf(neq1315,axiom,
    neq(s14,p17_5) ).

cnf(neq1316,axiom,
    neq(s14,p17_8) ).

cnf(neq1317,axiom,
    neq(s14,p17_14) ).

cnf(neq1318,axiom,
    neq(s14,p18_15) ).

cnf(neq1319,axiom,
    neq(s14,p19_8) ).

cnf(neq1320,axiom,
    neq(s14,p19_12) ).

cnf(neq1321,axiom,
    neq(s15,truck1) ).

cnf(neq1322,axiom,
    neq(s15,truck2) ).

cnf(neq1323,axiom,
    neq(s15,truck3) ).

cnf(neq1324,axiom,
    neq(s15,truck4) ).

cnf(neq1325,axiom,
    neq(s15,truck5) ).

cnf(neq1326,axiom,
    neq(s15,s0) ).

cnf(neq1327,axiom,
    neq(s15,s1) ).

cnf(neq1328,axiom,
    neq(s15,s2) ).

cnf(neq1329,axiom,
    neq(s15,s3) ).

cnf(neq1330,axiom,
    neq(s15,s4) ).

cnf(neq1331,axiom,
    neq(s15,s5) ).

cnf(neq1332,axiom,
    neq(s15,s6) ).

cnf(neq1333,axiom,
    neq(s15,s7) ).

cnf(neq1334,axiom,
    neq(s15,s8) ).

cnf(neq1335,axiom,
    neq(s15,s9) ).

cnf(neq1336,axiom,
    neq(s15,s10) ).

cnf(neq1337,axiom,
    neq(s15,s11) ).

cnf(neq1338,axiom,
    neq(s15,s12) ).

cnf(neq1339,axiom,
    neq(s15,s13) ).

cnf(neq1340,axiom,
    neq(s15,s14) ).

cnf(neq1341,axiom,
    ~ neq(s15,s15) ).

cnf(neq1342,axiom,
    neq(s15,s16) ).

cnf(neq1343,axiom,
    neq(s15,s17) ).

cnf(neq1344,axiom,
    neq(s15,s18) ).

cnf(neq1345,axiom,
    neq(s15,s19) ).

cnf(neq1346,axiom,
    neq(s15,p0_8) ).

cnf(neq1347,axiom,
    neq(s15,p1_3) ).

cnf(neq1348,axiom,
    neq(s15,p1_4) ).

cnf(neq1349,axiom,
    neq(s15,p1_9) ).

cnf(neq1350,axiom,
    neq(s15,p2_3) ).

cnf(neq1351,axiom,
    neq(s15,p3_10) ).

cnf(neq1352,axiom,
    neq(s15,p3_19) ).

cnf(neq1353,axiom,
    neq(s15,p4_3) ).

cnf(neq1354,axiom,
    neq(s15,p4_6) ).

cnf(neq1355,axiom,
    neq(s15,p5_0) ).

cnf(neq1356,axiom,
    neq(s15,p5_10) ).

cnf(neq1357,axiom,
    neq(s15,p6_7) ).

cnf(neq1358,axiom,
    neq(s15,p6_10) ).

cnf(neq1359,axiom,
    neq(s15,p7_11) ).

cnf(neq1360,axiom,
    neq(s15,p8_2) ).

cnf(neq1361,axiom,
    neq(s15,p8_3) ).

cnf(neq1362,axiom,
    neq(s15,p8_5) ).

cnf(neq1363,axiom,
    neq(s15,p8_10) ).

cnf(neq1364,axiom,
    neq(s15,p9_15) ).

cnf(neq1365,axiom,
    neq(s15,p10_0) ).

cnf(neq1366,axiom,
    neq(s15,p11_3) ).

cnf(neq1367,axiom,
    neq(s15,p11_5) ).

cnf(neq1368,axiom,
    neq(s15,p11_13) ).

cnf(neq1369,axiom,
    neq(s15,p13_10) ).

cnf(neq1370,axiom,
    neq(s15,p13_14) ).

cnf(neq1371,axiom,
    neq(s15,p14_2) ).

cnf(neq1372,axiom,
    neq(s15,p14_7) ).

cnf(neq1373,axiom,
    neq(s15,p14_16) ).

cnf(neq1374,axiom,
    neq(s15,p14_17) ).

cnf(neq1375,axiom,
    neq(s15,p15_0) ).

cnf(neq1376,axiom,
    neq(s15,p15_1) ).

cnf(neq1377,axiom,
    neq(s15,p16_11) ).

cnf(neq1378,axiom,
    neq(s15,p16_18) ).

cnf(neq1379,axiom,
    neq(s15,p16_19) ).

cnf(neq1380,axiom,
    neq(s15,p17_3) ).

cnf(neq1381,axiom,
    neq(s15,p17_5) ).

cnf(neq1382,axiom,
    neq(s15,p17_8) ).

cnf(neq1383,axiom,
    neq(s15,p17_14) ).

cnf(neq1384,axiom,
    neq(s15,p18_15) ).

cnf(neq1385,axiom,
    neq(s15,p19_8) ).

cnf(neq1386,axiom,
    neq(s15,p19_12) ).

cnf(neq1387,axiom,
    neq(s16,truck1) ).

cnf(neq1388,axiom,
    neq(s16,truck2) ).

cnf(neq1389,axiom,
    neq(s16,truck3) ).

cnf(neq1390,axiom,
    neq(s16,truck4) ).

cnf(neq1391,axiom,
    neq(s16,truck5) ).

cnf(neq1392,axiom,
    neq(s16,s0) ).

cnf(neq1393,axiom,
    neq(s16,s1) ).

cnf(neq1394,axiom,
    neq(s16,s2) ).

cnf(neq1395,axiom,
    neq(s16,s3) ).

cnf(neq1396,axiom,
    neq(s16,s4) ).

cnf(neq1397,axiom,
    neq(s16,s5) ).

cnf(neq1398,axiom,
    neq(s16,s6) ).

cnf(neq1399,axiom,
    neq(s16,s7) ).

cnf(neq1400,axiom,
    neq(s16,s8) ).

cnf(neq1401,axiom,
    neq(s16,s9) ).

cnf(neq1402,axiom,
    neq(s16,s10) ).

cnf(neq1403,axiom,
    neq(s16,s11) ).

cnf(neq1404,axiom,
    neq(s16,s12) ).

cnf(neq1405,axiom,
    neq(s16,s13) ).

cnf(neq1406,axiom,
    neq(s16,s14) ).

cnf(neq1407,axiom,
    neq(s16,s15) ).

cnf(neq1408,axiom,
    ~ neq(s16,s16) ).

cnf(neq1409,axiom,
    neq(s16,s17) ).

cnf(neq1410,axiom,
    neq(s16,s18) ).

cnf(neq1411,axiom,
    neq(s16,s19) ).

cnf(neq1412,axiom,
    neq(s16,p0_8) ).

cnf(neq1413,axiom,
    neq(s16,p1_3) ).

cnf(neq1414,axiom,
    neq(s16,p1_4) ).

cnf(neq1415,axiom,
    neq(s16,p1_9) ).

cnf(neq1416,axiom,
    neq(s16,p2_3) ).

cnf(neq1417,axiom,
    neq(s16,p3_10) ).

cnf(neq1418,axiom,
    neq(s16,p3_19) ).

cnf(neq1419,axiom,
    neq(s16,p4_3) ).

cnf(neq1420,axiom,
    neq(s16,p4_6) ).

cnf(neq1421,axiom,
    neq(s16,p5_0) ).

cnf(neq1422,axiom,
    neq(s16,p5_10) ).

cnf(neq1423,axiom,
    neq(s16,p6_7) ).

cnf(neq1424,axiom,
    neq(s16,p6_10) ).

cnf(neq1425,axiom,
    neq(s16,p7_11) ).

cnf(neq1426,axiom,
    neq(s16,p8_2) ).

cnf(neq1427,axiom,
    neq(s16,p8_3) ).

cnf(neq1428,axiom,
    neq(s16,p8_5) ).

cnf(neq1429,axiom,
    neq(s16,p8_10) ).

cnf(neq1430,axiom,
    neq(s16,p9_15) ).

cnf(neq1431,axiom,
    neq(s16,p10_0) ).

cnf(neq1432,axiom,
    neq(s16,p11_3) ).

cnf(neq1433,axiom,
    neq(s16,p11_5) ).

cnf(neq1434,axiom,
    neq(s16,p11_13) ).

cnf(neq1435,axiom,
    neq(s16,p13_10) ).

cnf(neq1436,axiom,
    neq(s16,p13_14) ).

cnf(neq1437,axiom,
    neq(s16,p14_2) ).

cnf(neq1438,axiom,
    neq(s16,p14_7) ).

cnf(neq1439,axiom,
    neq(s16,p14_16) ).

cnf(neq1440,axiom,
    neq(s16,p14_17) ).

cnf(neq1441,axiom,
    neq(s16,p15_0) ).

cnf(neq1442,axiom,
    neq(s16,p15_1) ).

cnf(neq1443,axiom,
    neq(s16,p16_11) ).

cnf(neq1444,axiom,
    neq(s16,p16_18) ).

cnf(neq1445,axiom,
    neq(s16,p16_19) ).

cnf(neq1446,axiom,
    neq(s16,p17_3) ).

cnf(neq1447,axiom,
    neq(s16,p17_5) ).

cnf(neq1448,axiom,
    neq(s16,p17_8) ).

cnf(neq1449,axiom,
    neq(s16,p17_14) ).

cnf(neq1450,axiom,
    neq(s16,p18_15) ).

cnf(neq1451,axiom,
    neq(s16,p19_8) ).

cnf(neq1452,axiom,
    neq(s16,p19_12) ).

cnf(neq1453,axiom,
    neq(s17,truck1) ).

cnf(neq1454,axiom,
    neq(s17,truck2) ).

cnf(neq1455,axiom,
    neq(s17,truck3) ).

cnf(neq1456,axiom,
    neq(s17,truck4) ).

cnf(neq1457,axiom,
    neq(s17,truck5) ).

cnf(neq1458,axiom,
    neq(s17,s0) ).

cnf(neq1459,axiom,
    neq(s17,s1) ).

cnf(neq1460,axiom,
    neq(s17,s2) ).

cnf(neq1461,axiom,
    neq(s17,s3) ).

cnf(neq1462,axiom,
    neq(s17,s4) ).

cnf(neq1463,axiom,
    neq(s17,s5) ).

cnf(neq1464,axiom,
    neq(s17,s6) ).

cnf(neq1465,axiom,
    neq(s17,s7) ).

cnf(neq1466,axiom,
    neq(s17,s8) ).

cnf(neq1467,axiom,
    neq(s17,s9) ).

cnf(neq1468,axiom,
    neq(s17,s10) ).

cnf(neq1469,axiom,
    neq(s17,s11) ).

cnf(neq1470,axiom,
    neq(s17,s12) ).

cnf(neq1471,axiom,
    neq(s17,s13) ).

cnf(neq1472,axiom,
    neq(s17,s14) ).

cnf(neq1473,axiom,
    neq(s17,s15) ).

cnf(neq1474,axiom,
    neq(s17,s16) ).

cnf(neq1475,axiom,
    ~ neq(s17,s17) ).

cnf(neq1476,axiom,
    neq(s17,s18) ).

cnf(neq1477,axiom,
    neq(s17,s19) ).

cnf(neq1478,axiom,
    neq(s17,p0_8) ).

cnf(neq1479,axiom,
    neq(s17,p1_3) ).

cnf(neq1480,axiom,
    neq(s17,p1_4) ).

cnf(neq1481,axiom,
    neq(s17,p1_9) ).

cnf(neq1482,axiom,
    neq(s17,p2_3) ).

cnf(neq1483,axiom,
    neq(s17,p3_10) ).

cnf(neq1484,axiom,
    neq(s17,p3_19) ).

cnf(neq1485,axiom,
    neq(s17,p4_3) ).

cnf(neq1486,axiom,
    neq(s17,p4_6) ).

cnf(neq1487,axiom,
    neq(s17,p5_0) ).

cnf(neq1488,axiom,
    neq(s17,p5_10) ).

cnf(neq1489,axiom,
    neq(s17,p6_7) ).

cnf(neq1490,axiom,
    neq(s17,p6_10) ).

cnf(neq1491,axiom,
    neq(s17,p7_11) ).

cnf(neq1492,axiom,
    neq(s17,p8_2) ).

cnf(neq1493,axiom,
    neq(s17,p8_3) ).

cnf(neq1494,axiom,
    neq(s17,p8_5) ).

cnf(neq1495,axiom,
    neq(s17,p8_10) ).

cnf(neq1496,axiom,
    neq(s17,p9_15) ).

cnf(neq1497,axiom,
    neq(s17,p10_0) ).

cnf(neq1498,axiom,
    neq(s17,p11_3) ).

cnf(neq1499,axiom,
    neq(s17,p11_5) ).

cnf(neq1500,axiom,
    neq(s17,p11_13) ).

cnf(neq1501,axiom,
    neq(s17,p13_10) ).

cnf(neq1502,axiom,
    neq(s17,p13_14) ).

cnf(neq1503,axiom,
    neq(s17,p14_2) ).

cnf(neq1504,axiom,
    neq(s17,p14_7) ).

cnf(neq1505,axiom,
    neq(s17,p14_16) ).

cnf(neq1506,axiom,
    neq(s17,p14_17) ).

cnf(neq1507,axiom,
    neq(s17,p15_0) ).

cnf(neq1508,axiom,
    neq(s17,p15_1) ).

cnf(neq1509,axiom,
    neq(s17,p16_11) ).

cnf(neq1510,axiom,
    neq(s17,p16_18) ).

cnf(neq1511,axiom,
    neq(s17,p16_19) ).

cnf(neq1512,axiom,
    neq(s17,p17_3) ).

cnf(neq1513,axiom,
    neq(s17,p17_5) ).

cnf(neq1514,axiom,
    neq(s17,p17_8) ).

cnf(neq1515,axiom,
    neq(s17,p17_14) ).

cnf(neq1516,axiom,
    neq(s17,p18_15) ).

cnf(neq1517,axiom,
    neq(s17,p19_8) ).

cnf(neq1518,axiom,
    neq(s17,p19_12) ).

cnf(neq1519,axiom,
    neq(s18,truck1) ).

cnf(neq1520,axiom,
    neq(s18,truck2) ).

cnf(neq1521,axiom,
    neq(s18,truck3) ).

cnf(neq1522,axiom,
    neq(s18,truck4) ).

cnf(neq1523,axiom,
    neq(s18,truck5) ).

cnf(neq1524,axiom,
    neq(s18,s0) ).

cnf(neq1525,axiom,
    neq(s18,s1) ).

cnf(neq1526,axiom,
    neq(s18,s2) ).

cnf(neq1527,axiom,
    neq(s18,s3) ).

cnf(neq1528,axiom,
    neq(s18,s4) ).

cnf(neq1529,axiom,
    neq(s18,s5) ).

cnf(neq1530,axiom,
    neq(s18,s6) ).

cnf(neq1531,axiom,
    neq(s18,s7) ).

cnf(neq1532,axiom,
    neq(s18,s8) ).

cnf(neq1533,axiom,
    neq(s18,s9) ).

cnf(neq1534,axiom,
    neq(s18,s10) ).

cnf(neq1535,axiom,
    neq(s18,s11) ).

cnf(neq1536,axiom,
    neq(s18,s12) ).

cnf(neq1537,axiom,
    neq(s18,s13) ).

cnf(neq1538,axiom,
    neq(s18,s14) ).

cnf(neq1539,axiom,
    neq(s18,s15) ).

cnf(neq1540,axiom,
    neq(s18,s16) ).

cnf(neq1541,axiom,
    neq(s18,s17) ).

cnf(neq1542,axiom,
    ~ neq(s18,s18) ).

cnf(neq1543,axiom,
    neq(s18,s19) ).

cnf(neq1544,axiom,
    neq(s18,p0_8) ).

cnf(neq1545,axiom,
    neq(s18,p1_3) ).

cnf(neq1546,axiom,
    neq(s18,p1_4) ).

cnf(neq1547,axiom,
    neq(s18,p1_9) ).

cnf(neq1548,axiom,
    neq(s18,p2_3) ).

cnf(neq1549,axiom,
    neq(s18,p3_10) ).

cnf(neq1550,axiom,
    neq(s18,p3_19) ).

cnf(neq1551,axiom,
    neq(s18,p4_3) ).

cnf(neq1552,axiom,
    neq(s18,p4_6) ).

cnf(neq1553,axiom,
    neq(s18,p5_0) ).

cnf(neq1554,axiom,
    neq(s18,p5_10) ).

cnf(neq1555,axiom,
    neq(s18,p6_7) ).

cnf(neq1556,axiom,
    neq(s18,p6_10) ).

cnf(neq1557,axiom,
    neq(s18,p7_11) ).

cnf(neq1558,axiom,
    neq(s18,p8_2) ).

cnf(neq1559,axiom,
    neq(s18,p8_3) ).

cnf(neq1560,axiom,
    neq(s18,p8_5) ).

cnf(neq1561,axiom,
    neq(s18,p8_10) ).

cnf(neq1562,axiom,
    neq(s18,p9_15) ).

cnf(neq1563,axiom,
    neq(s18,p10_0) ).

cnf(neq1564,axiom,
    neq(s18,p11_3) ).

cnf(neq1565,axiom,
    neq(s18,p11_5) ).

cnf(neq1566,axiom,
    neq(s18,p11_13) ).

cnf(neq1567,axiom,
    neq(s18,p13_10) ).

cnf(neq1568,axiom,
    neq(s18,p13_14) ).

cnf(neq1569,axiom,
    neq(s18,p14_2) ).

cnf(neq1570,axiom,
    neq(s18,p14_7) ).

cnf(neq1571,axiom,
    neq(s18,p14_16) ).

cnf(neq1572,axiom,
    neq(s18,p14_17) ).

cnf(neq1573,axiom,
    neq(s18,p15_0) ).

cnf(neq1574,axiom,
    neq(s18,p15_1) ).

cnf(neq1575,axiom,
    neq(s18,p16_11) ).

cnf(neq1576,axiom,
    neq(s18,p16_18) ).

cnf(neq1577,axiom,
    neq(s18,p16_19) ).

cnf(neq1578,axiom,
    neq(s18,p17_3) ).

cnf(neq1579,axiom,
    neq(s18,p17_5) ).

cnf(neq1580,axiom,
    neq(s18,p17_8) ).

cnf(neq1581,axiom,
    neq(s18,p17_14) ).

cnf(neq1582,axiom,
    neq(s18,p18_15) ).

cnf(neq1583,axiom,
    neq(s18,p19_8) ).

cnf(neq1584,axiom,
    neq(s18,p19_12) ).

cnf(neq1585,axiom,
    neq(s19,truck1) ).

cnf(neq1586,axiom,
    neq(s19,truck2) ).

cnf(neq1587,axiom,
    neq(s19,truck3) ).

cnf(neq1588,axiom,
    neq(s19,truck4) ).

cnf(neq1589,axiom,
    neq(s19,truck5) ).

cnf(neq1590,axiom,
    neq(s19,s0) ).

cnf(neq1591,axiom,
    neq(s19,s1) ).

cnf(neq1592,axiom,
    neq(s19,s2) ).

cnf(neq1593,axiom,
    neq(s19,s3) ).

cnf(neq1594,axiom,
    neq(s19,s4) ).

cnf(neq1595,axiom,
    neq(s19,s5) ).

cnf(neq1596,axiom,
    neq(s19,s6) ).

cnf(neq1597,axiom,
    neq(s19,s7) ).

cnf(neq1598,axiom,
    neq(s19,s8) ).

cnf(neq1599,axiom,
    neq(s19,s9) ).

cnf(neq1600,axiom,
    neq(s19,s10) ).

cnf(neq1601,axiom,
    neq(s19,s11) ).

cnf(neq1602,axiom,
    neq(s19,s12) ).

cnf(neq1603,axiom,
    neq(s19,s13) ).

cnf(neq1604,axiom,
    neq(s19,s14) ).

cnf(neq1605,axiom,
    neq(s19,s15) ).

cnf(neq1606,axiom,
    neq(s19,s16) ).

cnf(neq1607,axiom,
    neq(s19,s17) ).

cnf(neq1608,axiom,
    neq(s19,s18) ).

cnf(neq1609,axiom,
    ~ neq(s19,s19) ).

cnf(neq1610,axiom,
    neq(s19,p0_8) ).

cnf(neq1611,axiom,
    neq(s19,p1_3) ).

cnf(neq1612,axiom,
    neq(s19,p1_4) ).

cnf(neq1613,axiom,
    neq(s19,p1_9) ).

cnf(neq1614,axiom,
    neq(s19,p2_3) ).

cnf(neq1615,axiom,
    neq(s19,p3_10) ).

cnf(neq1616,axiom,
    neq(s19,p3_19) ).

cnf(neq1617,axiom,
    neq(s19,p4_3) ).

cnf(neq1618,axiom,
    neq(s19,p4_6) ).

cnf(neq1619,axiom,
    neq(s19,p5_0) ).

cnf(neq1620,axiom,
    neq(s19,p5_10) ).

cnf(neq1621,axiom,
    neq(s19,p6_7) ).

cnf(neq1622,axiom,
    neq(s19,p6_10) ).

cnf(neq1623,axiom,
    neq(s19,p7_11) ).

cnf(neq1624,axiom,
    neq(s19,p8_2) ).

cnf(neq1625,axiom,
    neq(s19,p8_3) ).

cnf(neq1626,axiom,
    neq(s19,p8_5) ).

cnf(neq1627,axiom,
    neq(s19,p8_10) ).

cnf(neq1628,axiom,
    neq(s19,p9_15) ).

cnf(neq1629,axiom,
    neq(s19,p10_0) ).

cnf(neq1630,axiom,
    neq(s19,p11_3) ).

cnf(neq1631,axiom,
    neq(s19,p11_5) ).

cnf(neq1632,axiom,
    neq(s19,p11_13) ).

cnf(neq1633,axiom,
    neq(s19,p13_10) ).

cnf(neq1634,axiom,
    neq(s19,p13_14) ).

cnf(neq1635,axiom,
    neq(s19,p14_2) ).

cnf(neq1636,axiom,
    neq(s19,p14_7) ).

cnf(neq1637,axiom,
    neq(s19,p14_16) ).

cnf(neq1638,axiom,
    neq(s19,p14_17) ).

cnf(neq1639,axiom,
    neq(s19,p15_0) ).

cnf(neq1640,axiom,
    neq(s19,p15_1) ).

cnf(neq1641,axiom,
    neq(s19,p16_11) ).

cnf(neq1642,axiom,
    neq(s19,p16_18) ).

cnf(neq1643,axiom,
    neq(s19,p16_19) ).

cnf(neq1644,axiom,
    neq(s19,p17_3) ).

cnf(neq1645,axiom,
    neq(s19,p17_5) ).

cnf(neq1646,axiom,
    neq(s19,p17_8) ).

cnf(neq1647,axiom,
    neq(s19,p17_14) ).

cnf(neq1648,axiom,
    neq(s19,p18_15) ).

cnf(neq1649,axiom,
    neq(s19,p19_8) ).

cnf(neq1650,axiom,
    neq(s19,p19_12) ).

cnf(neq1651,axiom,
    neq(p0_8,truck1) ).

cnf(neq1652,axiom,
    neq(p0_8,truck2) ).

cnf(neq1653,axiom,
    neq(p0_8,truck3) ).

cnf(neq1654,axiom,
    neq(p0_8,truck4) ).

cnf(neq1655,axiom,
    neq(p0_8,truck5) ).

cnf(neq1656,axiom,
    neq(p0_8,s0) ).

cnf(neq1657,axiom,
    neq(p0_8,s1) ).

cnf(neq1658,axiom,
    neq(p0_8,s2) ).

cnf(neq1659,axiom,
    neq(p0_8,s3) ).

cnf(neq1660,axiom,
    neq(p0_8,s4) ).

cnf(neq1661,axiom,
    neq(p0_8,s5) ).

cnf(neq1662,axiom,
    neq(p0_8,s6) ).

cnf(neq1663,axiom,
    neq(p0_8,s7) ).

cnf(neq1664,axiom,
    neq(p0_8,s8) ).

cnf(neq1665,axiom,
    neq(p0_8,s9) ).

cnf(neq1666,axiom,
    neq(p0_8,s10) ).

cnf(neq1667,axiom,
    neq(p0_8,s11) ).

cnf(neq1668,axiom,
    neq(p0_8,s12) ).

cnf(neq1669,axiom,
    neq(p0_8,s13) ).

cnf(neq1670,axiom,
    neq(p0_8,s14) ).

cnf(neq1671,axiom,
    neq(p0_8,s15) ).

cnf(neq1672,axiom,
    neq(p0_8,s16) ).

cnf(neq1673,axiom,
    neq(p0_8,s17) ).

cnf(neq1674,axiom,
    neq(p0_8,s18) ).

cnf(neq1675,axiom,
    neq(p0_8,s19) ).

cnf(neq1676,axiom,
    ~ neq(p0_8,p0_8) ).

cnf(neq1677,axiom,
    neq(p0_8,p1_3) ).

cnf(neq1678,axiom,
    neq(p0_8,p1_4) ).

cnf(neq1679,axiom,
    neq(p0_8,p1_9) ).

cnf(neq1680,axiom,
    neq(p0_8,p2_3) ).

cnf(neq1681,axiom,
    neq(p0_8,p3_10) ).

cnf(neq1682,axiom,
    neq(p0_8,p3_19) ).

cnf(neq1683,axiom,
    neq(p0_8,p4_3) ).

cnf(neq1684,axiom,
    neq(p0_8,p4_6) ).

cnf(neq1685,axiom,
    neq(p0_8,p5_0) ).

cnf(neq1686,axiom,
    neq(p0_8,p5_10) ).

cnf(neq1687,axiom,
    neq(p0_8,p6_7) ).

cnf(neq1688,axiom,
    neq(p0_8,p6_10) ).

cnf(neq1689,axiom,
    neq(p0_8,p7_11) ).

cnf(neq1690,axiom,
    neq(p0_8,p8_2) ).

cnf(neq1691,axiom,
    neq(p0_8,p8_3) ).

cnf(neq1692,axiom,
    neq(p0_8,p8_5) ).

cnf(neq1693,axiom,
    neq(p0_8,p8_10) ).

cnf(neq1694,axiom,
    neq(p0_8,p9_15) ).

cnf(neq1695,axiom,
    neq(p0_8,p10_0) ).

cnf(neq1696,axiom,
    neq(p0_8,p11_3) ).

cnf(neq1697,axiom,
    neq(p0_8,p11_5) ).

cnf(neq1698,axiom,
    neq(p0_8,p11_13) ).

cnf(neq1699,axiom,
    neq(p0_8,p13_10) ).

cnf(neq1700,axiom,
    neq(p0_8,p13_14) ).

cnf(neq1701,axiom,
    neq(p0_8,p14_2) ).

cnf(neq1702,axiom,
    neq(p0_8,p14_7) ).

cnf(neq1703,axiom,
    neq(p0_8,p14_16) ).

cnf(neq1704,axiom,
    neq(p0_8,p14_17) ).

cnf(neq1705,axiom,
    neq(p0_8,p15_0) ).

cnf(neq1706,axiom,
    neq(p0_8,p15_1) ).

cnf(neq1707,axiom,
    neq(p0_8,p16_11) ).

cnf(neq1708,axiom,
    neq(p0_8,p16_18) ).

cnf(neq1709,axiom,
    neq(p0_8,p16_19) ).

cnf(neq1710,axiom,
    neq(p0_8,p17_3) ).

cnf(neq1711,axiom,
    neq(p0_8,p17_5) ).

cnf(neq1712,axiom,
    neq(p0_8,p17_8) ).

cnf(neq1713,axiom,
    neq(p0_8,p17_14) ).

cnf(neq1714,axiom,
    neq(p0_8,p18_15) ).

cnf(neq1715,axiom,
    neq(p0_8,p19_8) ).

cnf(neq1716,axiom,
    neq(p0_8,p19_12) ).

cnf(neq1717,axiom,
    neq(p1_3,truck1) ).

cnf(neq1718,axiom,
    neq(p1_3,truck2) ).

cnf(neq1719,axiom,
    neq(p1_3,truck3) ).

cnf(neq1720,axiom,
    neq(p1_3,truck4) ).

cnf(neq1721,axiom,
    neq(p1_3,truck5) ).

cnf(neq1722,axiom,
    neq(p1_3,s0) ).

cnf(neq1723,axiom,
    neq(p1_3,s1) ).

cnf(neq1724,axiom,
    neq(p1_3,s2) ).

cnf(neq1725,axiom,
    neq(p1_3,s3) ).

cnf(neq1726,axiom,
    neq(p1_3,s4) ).

cnf(neq1727,axiom,
    neq(p1_3,s5) ).

cnf(neq1728,axiom,
    neq(p1_3,s6) ).

cnf(neq1729,axiom,
    neq(p1_3,s7) ).

cnf(neq1730,axiom,
    neq(p1_3,s8) ).

cnf(neq1731,axiom,
    neq(p1_3,s9) ).

cnf(neq1732,axiom,
    neq(p1_3,s10) ).

cnf(neq1733,axiom,
    neq(p1_3,s11) ).

cnf(neq1734,axiom,
    neq(p1_3,s12) ).

cnf(neq1735,axiom,
    neq(p1_3,s13) ).

cnf(neq1736,axiom,
    neq(p1_3,s14) ).

cnf(neq1737,axiom,
    neq(p1_3,s15) ).

cnf(neq1738,axiom,
    neq(p1_3,s16) ).

cnf(neq1739,axiom,
    neq(p1_3,s17) ).

cnf(neq1740,axiom,
    neq(p1_3,s18) ).

cnf(neq1741,axiom,
    neq(p1_3,s19) ).

cnf(neq1742,axiom,
    neq(p1_3,p0_8) ).

cnf(neq1743,axiom,
    ~ neq(p1_3,p1_3) ).

cnf(neq1744,axiom,
    neq(p1_3,p1_4) ).

cnf(neq1745,axiom,
    neq(p1_3,p1_9) ).

cnf(neq1746,axiom,
    neq(p1_3,p2_3) ).

cnf(neq1747,axiom,
    neq(p1_3,p3_10) ).

cnf(neq1748,axiom,
    neq(p1_3,p3_19) ).

cnf(neq1749,axiom,
    neq(p1_3,p4_3) ).

cnf(neq1750,axiom,
    neq(p1_3,p4_6) ).

cnf(neq1751,axiom,
    neq(p1_3,p5_0) ).

cnf(neq1752,axiom,
    neq(p1_3,p5_10) ).

cnf(neq1753,axiom,
    neq(p1_3,p6_7) ).

cnf(neq1754,axiom,
    neq(p1_3,p6_10) ).

cnf(neq1755,axiom,
    neq(p1_3,p7_11) ).

cnf(neq1756,axiom,
    neq(p1_3,p8_2) ).

cnf(neq1757,axiom,
    neq(p1_3,p8_3) ).

cnf(neq1758,axiom,
    neq(p1_3,p8_5) ).

cnf(neq1759,axiom,
    neq(p1_3,p8_10) ).

cnf(neq1760,axiom,
    neq(p1_3,p9_15) ).

cnf(neq1761,axiom,
    neq(p1_3,p10_0) ).

cnf(neq1762,axiom,
    neq(p1_3,p11_3) ).

cnf(neq1763,axiom,
    neq(p1_3,p11_5) ).

cnf(neq1764,axiom,
    neq(p1_3,p11_13) ).

cnf(neq1765,axiom,
    neq(p1_3,p13_10) ).

cnf(neq1766,axiom,
    neq(p1_3,p13_14) ).

cnf(neq1767,axiom,
    neq(p1_3,p14_2) ).

cnf(neq1768,axiom,
    neq(p1_3,p14_7) ).

cnf(neq1769,axiom,
    neq(p1_3,p14_16) ).

cnf(neq1770,axiom,
    neq(p1_3,p14_17) ).

cnf(neq1771,axiom,
    neq(p1_3,p15_0) ).

cnf(neq1772,axiom,
    neq(p1_3,p15_1) ).

cnf(neq1773,axiom,
    neq(p1_3,p16_11) ).

cnf(neq1774,axiom,
    neq(p1_3,p16_18) ).

cnf(neq1775,axiom,
    neq(p1_3,p16_19) ).

cnf(neq1776,axiom,
    neq(p1_3,p17_3) ).

cnf(neq1777,axiom,
    neq(p1_3,p17_5) ).

cnf(neq1778,axiom,
    neq(p1_3,p17_8) ).

cnf(neq1779,axiom,
    neq(p1_3,p17_14) ).

cnf(neq1780,axiom,
    neq(p1_3,p18_15) ).

cnf(neq1781,axiom,
    neq(p1_3,p19_8) ).

cnf(neq1782,axiom,
    neq(p1_3,p19_12) ).

cnf(neq1783,axiom,
    neq(p1_4,truck1) ).

cnf(neq1784,axiom,
    neq(p1_4,truck2) ).

cnf(neq1785,axiom,
    neq(p1_4,truck3) ).

cnf(neq1786,axiom,
    neq(p1_4,truck4) ).

cnf(neq1787,axiom,
    neq(p1_4,truck5) ).

cnf(neq1788,axiom,
    neq(p1_4,s0) ).

cnf(neq1789,axiom,
    neq(p1_4,s1) ).

cnf(neq1790,axiom,
    neq(p1_4,s2) ).

cnf(neq1791,axiom,
    neq(p1_4,s3) ).

cnf(neq1792,axiom,
    neq(p1_4,s4) ).

cnf(neq1793,axiom,
    neq(p1_4,s5) ).

cnf(neq1794,axiom,
    neq(p1_4,s6) ).

cnf(neq1795,axiom,
    neq(p1_4,s7) ).

cnf(neq1796,axiom,
    neq(p1_4,s8) ).

cnf(neq1797,axiom,
    neq(p1_4,s9) ).

cnf(neq1798,axiom,
    neq(p1_4,s10) ).

cnf(neq1799,axiom,
    neq(p1_4,s11) ).

cnf(neq1800,axiom,
    neq(p1_4,s12) ).

cnf(neq1801,axiom,
    neq(p1_4,s13) ).

cnf(neq1802,axiom,
    neq(p1_4,s14) ).

cnf(neq1803,axiom,
    neq(p1_4,s15) ).

cnf(neq1804,axiom,
    neq(p1_4,s16) ).

cnf(neq1805,axiom,
    neq(p1_4,s17) ).

cnf(neq1806,axiom,
    neq(p1_4,s18) ).

cnf(neq1807,axiom,
    neq(p1_4,s19) ).

cnf(neq1808,axiom,
    neq(p1_4,p0_8) ).

cnf(neq1809,axiom,
    neq(p1_4,p1_3) ).

cnf(neq1810,axiom,
    ~ neq(p1_4,p1_4) ).

cnf(neq1811,axiom,
    neq(p1_4,p1_9) ).

cnf(neq1812,axiom,
    neq(p1_4,p2_3) ).

cnf(neq1813,axiom,
    neq(p1_4,p3_10) ).

cnf(neq1814,axiom,
    neq(p1_4,p3_19) ).

cnf(neq1815,axiom,
    neq(p1_4,p4_3) ).

cnf(neq1816,axiom,
    neq(p1_4,p4_6) ).

cnf(neq1817,axiom,
    neq(p1_4,p5_0) ).

cnf(neq1818,axiom,
    neq(p1_4,p5_10) ).

cnf(neq1819,axiom,
    neq(p1_4,p6_7) ).

cnf(neq1820,axiom,
    neq(p1_4,p6_10) ).

cnf(neq1821,axiom,
    neq(p1_4,p7_11) ).

cnf(neq1822,axiom,
    neq(p1_4,p8_2) ).

cnf(neq1823,axiom,
    neq(p1_4,p8_3) ).

cnf(neq1824,axiom,
    neq(p1_4,p8_5) ).

cnf(neq1825,axiom,
    neq(p1_4,p8_10) ).

cnf(neq1826,axiom,
    neq(p1_4,p9_15) ).

cnf(neq1827,axiom,
    neq(p1_4,p10_0) ).

cnf(neq1828,axiom,
    neq(p1_4,p11_3) ).

cnf(neq1829,axiom,
    neq(p1_4,p11_5) ).

cnf(neq1830,axiom,
    neq(p1_4,p11_13) ).

cnf(neq1831,axiom,
    neq(p1_4,p13_10) ).

cnf(neq1832,axiom,
    neq(p1_4,p13_14) ).

cnf(neq1833,axiom,
    neq(p1_4,p14_2) ).

cnf(neq1834,axiom,
    neq(p1_4,p14_7) ).

cnf(neq1835,axiom,
    neq(p1_4,p14_16) ).

cnf(neq1836,axiom,
    neq(p1_4,p14_17) ).

cnf(neq1837,axiom,
    neq(p1_4,p15_0) ).

cnf(neq1838,axiom,
    neq(p1_4,p15_1) ).

cnf(neq1839,axiom,
    neq(p1_4,p16_11) ).

cnf(neq1840,axiom,
    neq(p1_4,p16_18) ).

cnf(neq1841,axiom,
    neq(p1_4,p16_19) ).

cnf(neq1842,axiom,
    neq(p1_4,p17_3) ).

cnf(neq1843,axiom,
    neq(p1_4,p17_5) ).

cnf(neq1844,axiom,
    neq(p1_4,p17_8) ).

cnf(neq1845,axiom,
    neq(p1_4,p17_14) ).

cnf(neq1846,axiom,
    neq(p1_4,p18_15) ).

cnf(neq1847,axiom,
    neq(p1_4,p19_8) ).

cnf(neq1848,axiom,
    neq(p1_4,p19_12) ).

cnf(neq1849,axiom,
    neq(p1_9,truck1) ).

cnf(neq1850,axiom,
    neq(p1_9,truck2) ).

cnf(neq1851,axiom,
    neq(p1_9,truck3) ).

cnf(neq1852,axiom,
    neq(p1_9,truck4) ).

cnf(neq1853,axiom,
    neq(p1_9,truck5) ).

cnf(neq1854,axiom,
    neq(p1_9,s0) ).

cnf(neq1855,axiom,
    neq(p1_9,s1) ).

cnf(neq1856,axiom,
    neq(p1_9,s2) ).

cnf(neq1857,axiom,
    neq(p1_9,s3) ).

cnf(neq1858,axiom,
    neq(p1_9,s4) ).

cnf(neq1859,axiom,
    neq(p1_9,s5) ).

cnf(neq1860,axiom,
    neq(p1_9,s6) ).

cnf(neq1861,axiom,
    neq(p1_9,s7) ).

cnf(neq1862,axiom,
    neq(p1_9,s8) ).

cnf(neq1863,axiom,
    neq(p1_9,s9) ).

cnf(neq1864,axiom,
    neq(p1_9,s10) ).

cnf(neq1865,axiom,
    neq(p1_9,s11) ).

cnf(neq1866,axiom,
    neq(p1_9,s12) ).

cnf(neq1867,axiom,
    neq(p1_9,s13) ).

cnf(neq1868,axiom,
    neq(p1_9,s14) ).

cnf(neq1869,axiom,
    neq(p1_9,s15) ).

cnf(neq1870,axiom,
    neq(p1_9,s16) ).

cnf(neq1871,axiom,
    neq(p1_9,s17) ).

cnf(neq1872,axiom,
    neq(p1_9,s18) ).

cnf(neq1873,axiom,
    neq(p1_9,s19) ).

cnf(neq1874,axiom,
    neq(p1_9,p0_8) ).

cnf(neq1875,axiom,
    neq(p1_9,p1_3) ).

cnf(neq1876,axiom,
    neq(p1_9,p1_4) ).

cnf(neq1877,axiom,
    ~ neq(p1_9,p1_9) ).

cnf(neq1878,axiom,
    neq(p1_9,p2_3) ).

cnf(neq1879,axiom,
    neq(p1_9,p3_10) ).

cnf(neq1880,axiom,
    neq(p1_9,p3_19) ).

cnf(neq1881,axiom,
    neq(p1_9,p4_3) ).

cnf(neq1882,axiom,
    neq(p1_9,p4_6) ).

cnf(neq1883,axiom,
    neq(p1_9,p5_0) ).

cnf(neq1884,axiom,
    neq(p1_9,p5_10) ).

cnf(neq1885,axiom,
    neq(p1_9,p6_7) ).

cnf(neq1886,axiom,
    neq(p1_9,p6_10) ).

cnf(neq1887,axiom,
    neq(p1_9,p7_11) ).

cnf(neq1888,axiom,
    neq(p1_9,p8_2) ).

cnf(neq1889,axiom,
    neq(p1_9,p8_3) ).

cnf(neq1890,axiom,
    neq(p1_9,p8_5) ).

cnf(neq1891,axiom,
    neq(p1_9,p8_10) ).

cnf(neq1892,axiom,
    neq(p1_9,p9_15) ).

cnf(neq1893,axiom,
    neq(p1_9,p10_0) ).

cnf(neq1894,axiom,
    neq(p1_9,p11_3) ).

cnf(neq1895,axiom,
    neq(p1_9,p11_5) ).

cnf(neq1896,axiom,
    neq(p1_9,p11_13) ).

cnf(neq1897,axiom,
    neq(p1_9,p13_10) ).

cnf(neq1898,axiom,
    neq(p1_9,p13_14) ).

cnf(neq1899,axiom,
    neq(p1_9,p14_2) ).

cnf(neq1900,axiom,
    neq(p1_9,p14_7) ).

cnf(neq1901,axiom,
    neq(p1_9,p14_16) ).

cnf(neq1902,axiom,
    neq(p1_9,p14_17) ).

cnf(neq1903,axiom,
    neq(p1_9,p15_0) ).

cnf(neq1904,axiom,
    neq(p1_9,p15_1) ).

cnf(neq1905,axiom,
    neq(p1_9,p16_11) ).

cnf(neq1906,axiom,
    neq(p1_9,p16_18) ).

cnf(neq1907,axiom,
    neq(p1_9,p16_19) ).

cnf(neq1908,axiom,
    neq(p1_9,p17_3) ).

cnf(neq1909,axiom,
    neq(p1_9,p17_5) ).

cnf(neq1910,axiom,
    neq(p1_9,p17_8) ).

cnf(neq1911,axiom,
    neq(p1_9,p17_14) ).

cnf(neq1912,axiom,
    neq(p1_9,p18_15) ).

cnf(neq1913,axiom,
    neq(p1_9,p19_8) ).

cnf(neq1914,axiom,
    neq(p1_9,p19_12) ).

cnf(neq1915,axiom,
    neq(p2_3,truck1) ).

cnf(neq1916,axiom,
    neq(p2_3,truck2) ).

cnf(neq1917,axiom,
    neq(p2_3,truck3) ).

cnf(neq1918,axiom,
    neq(p2_3,truck4) ).

cnf(neq1919,axiom,
    neq(p2_3,truck5) ).

cnf(neq1920,axiom,
    neq(p2_3,s0) ).

cnf(neq1921,axiom,
    neq(p2_3,s1) ).

cnf(neq1922,axiom,
    neq(p2_3,s2) ).

cnf(neq1923,axiom,
    neq(p2_3,s3) ).

cnf(neq1924,axiom,
    neq(p2_3,s4) ).

cnf(neq1925,axiom,
    neq(p2_3,s5) ).

cnf(neq1926,axiom,
    neq(p2_3,s6) ).

cnf(neq1927,axiom,
    neq(p2_3,s7) ).

cnf(neq1928,axiom,
    neq(p2_3,s8) ).

cnf(neq1929,axiom,
    neq(p2_3,s9) ).

cnf(neq1930,axiom,
    neq(p2_3,s10) ).

cnf(neq1931,axiom,
    neq(p2_3,s11) ).

cnf(neq1932,axiom,
    neq(p2_3,s12) ).

cnf(neq1933,axiom,
    neq(p2_3,s13) ).

cnf(neq1934,axiom,
    neq(p2_3,s14) ).

cnf(neq1935,axiom,
    neq(p2_3,s15) ).

cnf(neq1936,axiom,
    neq(p2_3,s16) ).

cnf(neq1937,axiom,
    neq(p2_3,s17) ).

cnf(neq1938,axiom,
    neq(p2_3,s18) ).

cnf(neq1939,axiom,
    neq(p2_3,s19) ).

cnf(neq1940,axiom,
    neq(p2_3,p0_8) ).

cnf(neq1941,axiom,
    neq(p2_3,p1_3) ).

cnf(neq1942,axiom,
    neq(p2_3,p1_4) ).

cnf(neq1943,axiom,
    neq(p2_3,p1_9) ).

cnf(neq1944,axiom,
    ~ neq(p2_3,p2_3) ).

cnf(neq1945,axiom,
    neq(p2_3,p3_10) ).

cnf(neq1946,axiom,
    neq(p2_3,p3_19) ).

cnf(neq1947,axiom,
    neq(p2_3,p4_3) ).

cnf(neq1948,axiom,
    neq(p2_3,p4_6) ).

cnf(neq1949,axiom,
    neq(p2_3,p5_0) ).

cnf(neq1950,axiom,
    neq(p2_3,p5_10) ).

cnf(neq1951,axiom,
    neq(p2_3,p6_7) ).

cnf(neq1952,axiom,
    neq(p2_3,p6_10) ).

cnf(neq1953,axiom,
    neq(p2_3,p7_11) ).

cnf(neq1954,axiom,
    neq(p2_3,p8_2) ).

cnf(neq1955,axiom,
    neq(p2_3,p8_3) ).

cnf(neq1956,axiom,
    neq(p2_3,p8_5) ).

cnf(neq1957,axiom,
    neq(p2_3,p8_10) ).

cnf(neq1958,axiom,
    neq(p2_3,p9_15) ).

cnf(neq1959,axiom,
    neq(p2_3,p10_0) ).

cnf(neq1960,axiom,
    neq(p2_3,p11_3) ).

cnf(neq1961,axiom,
    neq(p2_3,p11_5) ).

cnf(neq1962,axiom,
    neq(p2_3,p11_13) ).

cnf(neq1963,axiom,
    neq(p2_3,p13_10) ).

cnf(neq1964,axiom,
    neq(p2_3,p13_14) ).

cnf(neq1965,axiom,
    neq(p2_3,p14_2) ).

cnf(neq1966,axiom,
    neq(p2_3,p14_7) ).

cnf(neq1967,axiom,
    neq(p2_3,p14_16) ).

cnf(neq1968,axiom,
    neq(p2_3,p14_17) ).

cnf(neq1969,axiom,
    neq(p2_3,p15_0) ).

cnf(neq1970,axiom,
    neq(p2_3,p15_1) ).

cnf(neq1971,axiom,
    neq(p2_3,p16_11) ).

cnf(neq1972,axiom,
    neq(p2_3,p16_18) ).

cnf(neq1973,axiom,
    neq(p2_3,p16_19) ).

cnf(neq1974,axiom,
    neq(p2_3,p17_3) ).

cnf(neq1975,axiom,
    neq(p2_3,p17_5) ).

cnf(neq1976,axiom,
    neq(p2_3,p17_8) ).

cnf(neq1977,axiom,
    neq(p2_3,p17_14) ).

cnf(neq1978,axiom,
    neq(p2_3,p18_15) ).

cnf(neq1979,axiom,
    neq(p2_3,p19_8) ).

cnf(neq1980,axiom,
    neq(p2_3,p19_12) ).

cnf(neq1981,axiom,
    neq(p3_10,truck1) ).

cnf(neq1982,axiom,
    neq(p3_10,truck2) ).

cnf(neq1983,axiom,
    neq(p3_10,truck3) ).

cnf(neq1984,axiom,
    neq(p3_10,truck4) ).

cnf(neq1985,axiom,
    neq(p3_10,truck5) ).

cnf(neq1986,axiom,
    neq(p3_10,s0) ).

cnf(neq1987,axiom,
    neq(p3_10,s1) ).

cnf(neq1988,axiom,
    neq(p3_10,s2) ).

cnf(neq1989,axiom,
    neq(p3_10,s3) ).

cnf(neq1990,axiom,
    neq(p3_10,s4) ).

cnf(neq1991,axiom,
    neq(p3_10,s5) ).

cnf(neq1992,axiom,
    neq(p3_10,s6) ).

cnf(neq1993,axiom,
    neq(p3_10,s7) ).

cnf(neq1994,axiom,
    neq(p3_10,s8) ).

cnf(neq1995,axiom,
    neq(p3_10,s9) ).

cnf(neq1996,axiom,
    neq(p3_10,s10) ).

cnf(neq1997,axiom,
    neq(p3_10,s11) ).

cnf(neq1998,axiom,
    neq(p3_10,s12) ).

cnf(neq1999,axiom,
    neq(p3_10,s13) ).

cnf(neq2000,axiom,
    neq(p3_10,s14) ).

cnf(neq2001,axiom,
    neq(p3_10,s15) ).

cnf(neq2002,axiom,
    neq(p3_10,s16) ).

cnf(neq2003,axiom,
    neq(p3_10,s17) ).

cnf(neq2004,axiom,
    neq(p3_10,s18) ).

cnf(neq2005,axiom,
    neq(p3_10,s19) ).

cnf(neq2006,axiom,
    neq(p3_10,p0_8) ).

cnf(neq2007,axiom,
    neq(p3_10,p1_3) ).

cnf(neq2008,axiom,
    neq(p3_10,p1_4) ).

cnf(neq2009,axiom,
    neq(p3_10,p1_9) ).

cnf(neq2010,axiom,
    neq(p3_10,p2_3) ).

cnf(neq2011,axiom,
    ~ neq(p3_10,p3_10) ).

cnf(neq2012,axiom,
    neq(p3_10,p3_19) ).

cnf(neq2013,axiom,
    neq(p3_10,p4_3) ).

cnf(neq2014,axiom,
    neq(p3_10,p4_6) ).

cnf(neq2015,axiom,
    neq(p3_10,p5_0) ).

cnf(neq2016,axiom,
    neq(p3_10,p5_10) ).

cnf(neq2017,axiom,
    neq(p3_10,p6_7) ).

cnf(neq2018,axiom,
    neq(p3_10,p6_10) ).

cnf(neq2019,axiom,
    neq(p3_10,p7_11) ).

cnf(neq2020,axiom,
    neq(p3_10,p8_2) ).

cnf(neq2021,axiom,
    neq(p3_10,p8_3) ).

cnf(neq2022,axiom,
    neq(p3_10,p8_5) ).

cnf(neq2023,axiom,
    neq(p3_10,p8_10) ).

cnf(neq2024,axiom,
    neq(p3_10,p9_15) ).

cnf(neq2025,axiom,
    neq(p3_10,p10_0) ).

cnf(neq2026,axiom,
    neq(p3_10,p11_3) ).

cnf(neq2027,axiom,
    neq(p3_10,p11_5) ).

cnf(neq2028,axiom,
    neq(p3_10,p11_13) ).

cnf(neq2029,axiom,
    neq(p3_10,p13_10) ).

cnf(neq2030,axiom,
    neq(p3_10,p13_14) ).

cnf(neq2031,axiom,
    neq(p3_10,p14_2) ).

cnf(neq2032,axiom,
    neq(p3_10,p14_7) ).

cnf(neq2033,axiom,
    neq(p3_10,p14_16) ).

cnf(neq2034,axiom,
    neq(p3_10,p14_17) ).

cnf(neq2035,axiom,
    neq(p3_10,p15_0) ).

cnf(neq2036,axiom,
    neq(p3_10,p15_1) ).

cnf(neq2037,axiom,
    neq(p3_10,p16_11) ).

cnf(neq2038,axiom,
    neq(p3_10,p16_18) ).

cnf(neq2039,axiom,
    neq(p3_10,p16_19) ).

cnf(neq2040,axiom,
    neq(p3_10,p17_3) ).

cnf(neq2041,axiom,
    neq(p3_10,p17_5) ).

cnf(neq2042,axiom,
    neq(p3_10,p17_8) ).

cnf(neq2043,axiom,
    neq(p3_10,p17_14) ).

cnf(neq2044,axiom,
    neq(p3_10,p18_15) ).

cnf(neq2045,axiom,
    neq(p3_10,p19_8) ).

cnf(neq2046,axiom,
    neq(p3_10,p19_12) ).

cnf(neq2047,axiom,
    neq(p3_19,truck1) ).

cnf(neq2048,axiom,
    neq(p3_19,truck2) ).

cnf(neq2049,axiom,
    neq(p3_19,truck3) ).

cnf(neq2050,axiom,
    neq(p3_19,truck4) ).

cnf(neq2051,axiom,
    neq(p3_19,truck5) ).

cnf(neq2052,axiom,
    neq(p3_19,s0) ).

cnf(neq2053,axiom,
    neq(p3_19,s1) ).

cnf(neq2054,axiom,
    neq(p3_19,s2) ).

cnf(neq2055,axiom,
    neq(p3_19,s3) ).

cnf(neq2056,axiom,
    neq(p3_19,s4) ).

cnf(neq2057,axiom,
    neq(p3_19,s5) ).

cnf(neq2058,axiom,
    neq(p3_19,s6) ).

cnf(neq2059,axiom,
    neq(p3_19,s7) ).

cnf(neq2060,axiom,
    neq(p3_19,s8) ).

cnf(neq2061,axiom,
    neq(p3_19,s9) ).

cnf(neq2062,axiom,
    neq(p3_19,s10) ).

cnf(neq2063,axiom,
    neq(p3_19,s11) ).

cnf(neq2064,axiom,
    neq(p3_19,s12) ).

cnf(neq2065,axiom,
    neq(p3_19,s13) ).

cnf(neq2066,axiom,
    neq(p3_19,s14) ).

cnf(neq2067,axiom,
    neq(p3_19,s15) ).

cnf(neq2068,axiom,
    neq(p3_19,s16) ).

cnf(neq2069,axiom,
    neq(p3_19,s17) ).

cnf(neq2070,axiom,
    neq(p3_19,s18) ).

cnf(neq2071,axiom,
    neq(p3_19,s19) ).

cnf(neq2072,axiom,
    neq(p3_19,p0_8) ).

cnf(neq2073,axiom,
    neq(p3_19,p1_3) ).

cnf(neq2074,axiom,
    neq(p3_19,p1_4) ).

cnf(neq2075,axiom,
    neq(p3_19,p1_9) ).

cnf(neq2076,axiom,
    neq(p3_19,p2_3) ).

cnf(neq2077,axiom,
    neq(p3_19,p3_10) ).

cnf(neq2078,axiom,
    ~ neq(p3_19,p3_19) ).

cnf(neq2079,axiom,
    neq(p3_19,p4_3) ).

cnf(neq2080,axiom,
    neq(p3_19,p4_6) ).

cnf(neq2081,axiom,
    neq(p3_19,p5_0) ).

cnf(neq2082,axiom,
    neq(p3_19,p5_10) ).

cnf(neq2083,axiom,
    neq(p3_19,p6_7) ).

cnf(neq2084,axiom,
    neq(p3_19,p6_10) ).

cnf(neq2085,axiom,
    neq(p3_19,p7_11) ).

cnf(neq2086,axiom,
    neq(p3_19,p8_2) ).

cnf(neq2087,axiom,
    neq(p3_19,p8_3) ).

cnf(neq2088,axiom,
    neq(p3_19,p8_5) ).

cnf(neq2089,axiom,
    neq(p3_19,p8_10) ).

cnf(neq2090,axiom,
    neq(p3_19,p9_15) ).

cnf(neq2091,axiom,
    neq(p3_19,p10_0) ).

cnf(neq2092,axiom,
    neq(p3_19,p11_3) ).

cnf(neq2093,axiom,
    neq(p3_19,p11_5) ).

cnf(neq2094,axiom,
    neq(p3_19,p11_13) ).

cnf(neq2095,axiom,
    neq(p3_19,p13_10) ).

cnf(neq2096,axiom,
    neq(p3_19,p13_14) ).

cnf(neq2097,axiom,
    neq(p3_19,p14_2) ).

cnf(neq2098,axiom,
    neq(p3_19,p14_7) ).

cnf(neq2099,axiom,
    neq(p3_19,p14_16) ).

cnf(neq2100,axiom,
    neq(p3_19,p14_17) ).

cnf(neq2101,axiom,
    neq(p3_19,p15_0) ).

cnf(neq2102,axiom,
    neq(p3_19,p15_1) ).

cnf(neq2103,axiom,
    neq(p3_19,p16_11) ).

cnf(neq2104,axiom,
    neq(p3_19,p16_18) ).

cnf(neq2105,axiom,
    neq(p3_19,p16_19) ).

cnf(neq2106,axiom,
    neq(p3_19,p17_3) ).

cnf(neq2107,axiom,
    neq(p3_19,p17_5) ).

cnf(neq2108,axiom,
    neq(p3_19,p17_8) ).

cnf(neq2109,axiom,
    neq(p3_19,p17_14) ).

cnf(neq2110,axiom,
    neq(p3_19,p18_15) ).

cnf(neq2111,axiom,
    neq(p3_19,p19_8) ).

cnf(neq2112,axiom,
    neq(p3_19,p19_12) ).

cnf(neq2113,axiom,
    neq(p4_3,truck1) ).

cnf(neq2114,axiom,
    neq(p4_3,truck2) ).

cnf(neq2115,axiom,
    neq(p4_3,truck3) ).

cnf(neq2116,axiom,
    neq(p4_3,truck4) ).

cnf(neq2117,axiom,
    neq(p4_3,truck5) ).

cnf(neq2118,axiom,
    neq(p4_3,s0) ).

cnf(neq2119,axiom,
    neq(p4_3,s1) ).

cnf(neq2120,axiom,
    neq(p4_3,s2) ).

cnf(neq2121,axiom,
    neq(p4_3,s3) ).

cnf(neq2122,axiom,
    neq(p4_3,s4) ).

cnf(neq2123,axiom,
    neq(p4_3,s5) ).

cnf(neq2124,axiom,
    neq(p4_3,s6) ).

cnf(neq2125,axiom,
    neq(p4_3,s7) ).

cnf(neq2126,axiom,
    neq(p4_3,s8) ).

cnf(neq2127,axiom,
    neq(p4_3,s9) ).

cnf(neq2128,axiom,
    neq(p4_3,s10) ).

cnf(neq2129,axiom,
    neq(p4_3,s11) ).

cnf(neq2130,axiom,
    neq(p4_3,s12) ).

cnf(neq2131,axiom,
    neq(p4_3,s13) ).

cnf(neq2132,axiom,
    neq(p4_3,s14) ).

cnf(neq2133,axiom,
    neq(p4_3,s15) ).

cnf(neq2134,axiom,
    neq(p4_3,s16) ).

cnf(neq2135,axiom,
    neq(p4_3,s17) ).

cnf(neq2136,axiom,
    neq(p4_3,s18) ).

cnf(neq2137,axiom,
    neq(p4_3,s19) ).

cnf(neq2138,axiom,
    neq(p4_3,p0_8) ).

cnf(neq2139,axiom,
    neq(p4_3,p1_3) ).

cnf(neq2140,axiom,
    neq(p4_3,p1_4) ).

cnf(neq2141,axiom,
    neq(p4_3,p1_9) ).

cnf(neq2142,axiom,
    neq(p4_3,p2_3) ).

cnf(neq2143,axiom,
    neq(p4_3,p3_10) ).

cnf(neq2144,axiom,
    neq(p4_3,p3_19) ).

cnf(neq2145,axiom,
    ~ neq(p4_3,p4_3) ).

cnf(neq2146,axiom,
    neq(p4_3,p4_6) ).

cnf(neq2147,axiom,
    neq(p4_3,p5_0) ).

cnf(neq2148,axiom,
    neq(p4_3,p5_10) ).

cnf(neq2149,axiom,
    neq(p4_3,p6_7) ).

cnf(neq2150,axiom,
    neq(p4_3,p6_10) ).

cnf(neq2151,axiom,
    neq(p4_3,p7_11) ).

cnf(neq2152,axiom,
    neq(p4_3,p8_2) ).

cnf(neq2153,axiom,
    neq(p4_3,p8_3) ).

cnf(neq2154,axiom,
    neq(p4_3,p8_5) ).

cnf(neq2155,axiom,
    neq(p4_3,p8_10) ).

cnf(neq2156,axiom,
    neq(p4_3,p9_15) ).

cnf(neq2157,axiom,
    neq(p4_3,p10_0) ).

cnf(neq2158,axiom,
    neq(p4_3,p11_3) ).

cnf(neq2159,axiom,
    neq(p4_3,p11_5) ).

cnf(neq2160,axiom,
    neq(p4_3,p11_13) ).

cnf(neq2161,axiom,
    neq(p4_3,p13_10) ).

cnf(neq2162,axiom,
    neq(p4_3,p13_14) ).

cnf(neq2163,axiom,
    neq(p4_3,p14_2) ).

cnf(neq2164,axiom,
    neq(p4_3,p14_7) ).

cnf(neq2165,axiom,
    neq(p4_3,p14_16) ).

cnf(neq2166,axiom,
    neq(p4_3,p14_17) ).

cnf(neq2167,axiom,
    neq(p4_3,p15_0) ).

cnf(neq2168,axiom,
    neq(p4_3,p15_1) ).

cnf(neq2169,axiom,
    neq(p4_3,p16_11) ).

cnf(neq2170,axiom,
    neq(p4_3,p16_18) ).

cnf(neq2171,axiom,
    neq(p4_3,p16_19) ).

cnf(neq2172,axiom,
    neq(p4_3,p17_3) ).

cnf(neq2173,axiom,
    neq(p4_3,p17_5) ).

cnf(neq2174,axiom,
    neq(p4_3,p17_8) ).

cnf(neq2175,axiom,
    neq(p4_3,p17_14) ).

cnf(neq2176,axiom,
    neq(p4_3,p18_15) ).

cnf(neq2177,axiom,
    neq(p4_3,p19_8) ).

cnf(neq2178,axiom,
    neq(p4_3,p19_12) ).

cnf(neq2179,axiom,
    neq(p4_6,truck1) ).

cnf(neq2180,axiom,
    neq(p4_6,truck2) ).

cnf(neq2181,axiom,
    neq(p4_6,truck3) ).

cnf(neq2182,axiom,
    neq(p4_6,truck4) ).

cnf(neq2183,axiom,
    neq(p4_6,truck5) ).

cnf(neq2184,axiom,
    neq(p4_6,s0) ).

cnf(neq2185,axiom,
    neq(p4_6,s1) ).

cnf(neq2186,axiom,
    neq(p4_6,s2) ).

cnf(neq2187,axiom,
    neq(p4_6,s3) ).

cnf(neq2188,axiom,
    neq(p4_6,s4) ).

cnf(neq2189,axiom,
    neq(p4_6,s5) ).

cnf(neq2190,axiom,
    neq(p4_6,s6) ).

cnf(neq2191,axiom,
    neq(p4_6,s7) ).

cnf(neq2192,axiom,
    neq(p4_6,s8) ).

cnf(neq2193,axiom,
    neq(p4_6,s9) ).

cnf(neq2194,axiom,
    neq(p4_6,s10) ).

cnf(neq2195,axiom,
    neq(p4_6,s11) ).

cnf(neq2196,axiom,
    neq(p4_6,s12) ).

cnf(neq2197,axiom,
    neq(p4_6,s13) ).

cnf(neq2198,axiom,
    neq(p4_6,s14) ).

cnf(neq2199,axiom,
    neq(p4_6,s15) ).

cnf(neq2200,axiom,
    neq(p4_6,s16) ).

cnf(neq2201,axiom,
    neq(p4_6,s17) ).

cnf(neq2202,axiom,
    neq(p4_6,s18) ).

cnf(neq2203,axiom,
    neq(p4_6,s19) ).

cnf(neq2204,axiom,
    neq(p4_6,p0_8) ).

cnf(neq2205,axiom,
    neq(p4_6,p1_3) ).

cnf(neq2206,axiom,
    neq(p4_6,p1_4) ).

cnf(neq2207,axiom,
    neq(p4_6,p1_9) ).

cnf(neq2208,axiom,
    neq(p4_6,p2_3) ).

cnf(neq2209,axiom,
    neq(p4_6,p3_10) ).

cnf(neq2210,axiom,
    neq(p4_6,p3_19) ).

cnf(neq2211,axiom,
    neq(p4_6,p4_3) ).

cnf(neq2212,axiom,
    ~ neq(p4_6,p4_6) ).

cnf(neq2213,axiom,
    neq(p4_6,p5_0) ).

cnf(neq2214,axiom,
    neq(p4_6,p5_10) ).

cnf(neq2215,axiom,
    neq(p4_6,p6_7) ).

cnf(neq2216,axiom,
    neq(p4_6,p6_10) ).

cnf(neq2217,axiom,
    neq(p4_6,p7_11) ).

cnf(neq2218,axiom,
    neq(p4_6,p8_2) ).

cnf(neq2219,axiom,
    neq(p4_6,p8_3) ).

cnf(neq2220,axiom,
    neq(p4_6,p8_5) ).

cnf(neq2221,axiom,
    neq(p4_6,p8_10) ).

cnf(neq2222,axiom,
    neq(p4_6,p9_15) ).

cnf(neq2223,axiom,
    neq(p4_6,p10_0) ).

cnf(neq2224,axiom,
    neq(p4_6,p11_3) ).

cnf(neq2225,axiom,
    neq(p4_6,p11_5) ).

cnf(neq2226,axiom,
    neq(p4_6,p11_13) ).

cnf(neq2227,axiom,
    neq(p4_6,p13_10) ).

cnf(neq2228,axiom,
    neq(p4_6,p13_14) ).

cnf(neq2229,axiom,
    neq(p4_6,p14_2) ).

cnf(neq2230,axiom,
    neq(p4_6,p14_7) ).

cnf(neq2231,axiom,
    neq(p4_6,p14_16) ).

cnf(neq2232,axiom,
    neq(p4_6,p14_17) ).

cnf(neq2233,axiom,
    neq(p4_6,p15_0) ).

cnf(neq2234,axiom,
    neq(p4_6,p15_1) ).

cnf(neq2235,axiom,
    neq(p4_6,p16_11) ).

cnf(neq2236,axiom,
    neq(p4_6,p16_18) ).

cnf(neq2237,axiom,
    neq(p4_6,p16_19) ).

cnf(neq2238,axiom,
    neq(p4_6,p17_3) ).

cnf(neq2239,axiom,
    neq(p4_6,p17_5) ).

cnf(neq2240,axiom,
    neq(p4_6,p17_8) ).

cnf(neq2241,axiom,
    neq(p4_6,p17_14) ).

cnf(neq2242,axiom,
    neq(p4_6,p18_15) ).

cnf(neq2243,axiom,
    neq(p4_6,p19_8) ).

cnf(neq2244,axiom,
    neq(p4_6,p19_12) ).

cnf(neq2245,axiom,
    neq(p5_0,truck1) ).

cnf(neq2246,axiom,
    neq(p5_0,truck2) ).

cnf(neq2247,axiom,
    neq(p5_0,truck3) ).

cnf(neq2248,axiom,
    neq(p5_0,truck4) ).

cnf(neq2249,axiom,
    neq(p5_0,truck5) ).

cnf(neq2250,axiom,
    neq(p5_0,s0) ).

cnf(neq2251,axiom,
    neq(p5_0,s1) ).

cnf(neq2252,axiom,
    neq(p5_0,s2) ).

cnf(neq2253,axiom,
    neq(p5_0,s3) ).

cnf(neq2254,axiom,
    neq(p5_0,s4) ).

cnf(neq2255,axiom,
    neq(p5_0,s5) ).

cnf(neq2256,axiom,
    neq(p5_0,s6) ).

cnf(neq2257,axiom,
    neq(p5_0,s7) ).

cnf(neq2258,axiom,
    neq(p5_0,s8) ).

cnf(neq2259,axiom,
    neq(p5_0,s9) ).

cnf(neq2260,axiom,
    neq(p5_0,s10) ).

cnf(neq2261,axiom,
    neq(p5_0,s11) ).

cnf(neq2262,axiom,
    neq(p5_0,s12) ).

cnf(neq2263,axiom,
    neq(p5_0,s13) ).

cnf(neq2264,axiom,
    neq(p5_0,s14) ).

cnf(neq2265,axiom,
    neq(p5_0,s15) ).

cnf(neq2266,axiom,
    neq(p5_0,s16) ).

cnf(neq2267,axiom,
    neq(p5_0,s17) ).

cnf(neq2268,axiom,
    neq(p5_0,s18) ).

cnf(neq2269,axiom,
    neq(p5_0,s19) ).

cnf(neq2270,axiom,
    neq(p5_0,p0_8) ).

cnf(neq2271,axiom,
    neq(p5_0,p1_3) ).

cnf(neq2272,axiom,
    neq(p5_0,p1_4) ).

cnf(neq2273,axiom,
    neq(p5_0,p1_9) ).

cnf(neq2274,axiom,
    neq(p5_0,p2_3) ).

cnf(neq2275,axiom,
    neq(p5_0,p3_10) ).

cnf(neq2276,axiom,
    neq(p5_0,p3_19) ).

cnf(neq2277,axiom,
    neq(p5_0,p4_3) ).

cnf(neq2278,axiom,
    neq(p5_0,p4_6) ).

cnf(neq2279,axiom,
    ~ neq(p5_0,p5_0) ).

cnf(neq2280,axiom,
    neq(p5_0,p5_10) ).

cnf(neq2281,axiom,
    neq(p5_0,p6_7) ).

cnf(neq2282,axiom,
    neq(p5_0,p6_10) ).

cnf(neq2283,axiom,
    neq(p5_0,p7_11) ).

cnf(neq2284,axiom,
    neq(p5_0,p8_2) ).

cnf(neq2285,axiom,
    neq(p5_0,p8_3) ).

cnf(neq2286,axiom,
    neq(p5_0,p8_5) ).

cnf(neq2287,axiom,
    neq(p5_0,p8_10) ).

cnf(neq2288,axiom,
    neq(p5_0,p9_15) ).

cnf(neq2289,axiom,
    neq(p5_0,p10_0) ).

cnf(neq2290,axiom,
    neq(p5_0,p11_3) ).

cnf(neq2291,axiom,
    neq(p5_0,p11_5) ).

cnf(neq2292,axiom,
    neq(p5_0,p11_13) ).

cnf(neq2293,axiom,
    neq(p5_0,p13_10) ).

cnf(neq2294,axiom,
    neq(p5_0,p13_14) ).

cnf(neq2295,axiom,
    neq(p5_0,p14_2) ).

cnf(neq2296,axiom,
    neq(p5_0,p14_7) ).

cnf(neq2297,axiom,
    neq(p5_0,p14_16) ).

cnf(neq2298,axiom,
    neq(p5_0,p14_17) ).

cnf(neq2299,axiom,
    neq(p5_0,p15_0) ).

cnf(neq2300,axiom,
    neq(p5_0,p15_1) ).

cnf(neq2301,axiom,
    neq(p5_0,p16_11) ).

cnf(neq2302,axiom,
    neq(p5_0,p16_18) ).

cnf(neq2303,axiom,
    neq(p5_0,p16_19) ).

cnf(neq2304,axiom,
    neq(p5_0,p17_3) ).

cnf(neq2305,axiom,
    neq(p5_0,p17_5) ).

cnf(neq2306,axiom,
    neq(p5_0,p17_8) ).

cnf(neq2307,axiom,
    neq(p5_0,p17_14) ).

cnf(neq2308,axiom,
    neq(p5_0,p18_15) ).

cnf(neq2309,axiom,
    neq(p5_0,p19_8) ).

cnf(neq2310,axiom,
    neq(p5_0,p19_12) ).

cnf(neq2311,axiom,
    neq(p5_10,truck1) ).

cnf(neq2312,axiom,
    neq(p5_10,truck2) ).

cnf(neq2313,axiom,
    neq(p5_10,truck3) ).

cnf(neq2314,axiom,
    neq(p5_10,truck4) ).

cnf(neq2315,axiom,
    neq(p5_10,truck5) ).

cnf(neq2316,axiom,
    neq(p5_10,s0) ).

cnf(neq2317,axiom,
    neq(p5_10,s1) ).

cnf(neq2318,axiom,
    neq(p5_10,s2) ).

cnf(neq2319,axiom,
    neq(p5_10,s3) ).

cnf(neq2320,axiom,
    neq(p5_10,s4) ).

cnf(neq2321,axiom,
    neq(p5_10,s5) ).

cnf(neq2322,axiom,
    neq(p5_10,s6) ).

cnf(neq2323,axiom,
    neq(p5_10,s7) ).

cnf(neq2324,axiom,
    neq(p5_10,s8) ).

cnf(neq2325,axiom,
    neq(p5_10,s9) ).

cnf(neq2326,axiom,
    neq(p5_10,s10) ).

cnf(neq2327,axiom,
    neq(p5_10,s11) ).

cnf(neq2328,axiom,
    neq(p5_10,s12) ).

cnf(neq2329,axiom,
    neq(p5_10,s13) ).

cnf(neq2330,axiom,
    neq(p5_10,s14) ).

cnf(neq2331,axiom,
    neq(p5_10,s15) ).

cnf(neq2332,axiom,
    neq(p5_10,s16) ).

cnf(neq2333,axiom,
    neq(p5_10,s17) ).

cnf(neq2334,axiom,
    neq(p5_10,s18) ).

cnf(neq2335,axiom,
    neq(p5_10,s19) ).

cnf(neq2336,axiom,
    neq(p5_10,p0_8) ).

cnf(neq2337,axiom,
    neq(p5_10,p1_3) ).

cnf(neq2338,axiom,
    neq(p5_10,p1_4) ).

cnf(neq2339,axiom,
    neq(p5_10,p1_9) ).

cnf(neq2340,axiom,
    neq(p5_10,p2_3) ).

cnf(neq2341,axiom,
    neq(p5_10,p3_10) ).

cnf(neq2342,axiom,
    neq(p5_10,p3_19) ).

cnf(neq2343,axiom,
    neq(p5_10,p4_3) ).

cnf(neq2344,axiom,
    neq(p5_10,p4_6) ).

cnf(neq2345,axiom,
    neq(p5_10,p5_0) ).

cnf(neq2346,axiom,
    ~ neq(p5_10,p5_10) ).

cnf(neq2347,axiom,
    neq(p5_10,p6_7) ).

cnf(neq2348,axiom,
    neq(p5_10,p6_10) ).

cnf(neq2349,axiom,
    neq(p5_10,p7_11) ).

cnf(neq2350,axiom,
    neq(p5_10,p8_2) ).

cnf(neq2351,axiom,
    neq(p5_10,p8_3) ).

cnf(neq2352,axiom,
    neq(p5_10,p8_5) ).

cnf(neq2353,axiom,
    neq(p5_10,p8_10) ).

cnf(neq2354,axiom,
    neq(p5_10,p9_15) ).

cnf(neq2355,axiom,
    neq(p5_10,p10_0) ).

cnf(neq2356,axiom,
    neq(p5_10,p11_3) ).

cnf(neq2357,axiom,
    neq(p5_10,p11_5) ).

cnf(neq2358,axiom,
    neq(p5_10,p11_13) ).

cnf(neq2359,axiom,
    neq(p5_10,p13_10) ).

cnf(neq2360,axiom,
    neq(p5_10,p13_14) ).

cnf(neq2361,axiom,
    neq(p5_10,p14_2) ).

cnf(neq2362,axiom,
    neq(p5_10,p14_7) ).

cnf(neq2363,axiom,
    neq(p5_10,p14_16) ).

cnf(neq2364,axiom,
    neq(p5_10,p14_17) ).

cnf(neq2365,axiom,
    neq(p5_10,p15_0) ).

cnf(neq2366,axiom,
    neq(p5_10,p15_1) ).

cnf(neq2367,axiom,
    neq(p5_10,p16_11) ).

cnf(neq2368,axiom,
    neq(p5_10,p16_18) ).

cnf(neq2369,axiom,
    neq(p5_10,p16_19) ).

cnf(neq2370,axiom,
    neq(p5_10,p17_3) ).

cnf(neq2371,axiom,
    neq(p5_10,p17_5) ).

cnf(neq2372,axiom,
    neq(p5_10,p17_8) ).

cnf(neq2373,axiom,
    neq(p5_10,p17_14) ).

cnf(neq2374,axiom,
    neq(p5_10,p18_15) ).

cnf(neq2375,axiom,
    neq(p5_10,p19_8) ).

cnf(neq2376,axiom,
    neq(p5_10,p19_12) ).

cnf(neq2377,axiom,
    neq(p6_7,truck1) ).

cnf(neq2378,axiom,
    neq(p6_7,truck2) ).

cnf(neq2379,axiom,
    neq(p6_7,truck3) ).

cnf(neq2380,axiom,
    neq(p6_7,truck4) ).

cnf(neq2381,axiom,
    neq(p6_7,truck5) ).

cnf(neq2382,axiom,
    neq(p6_7,s0) ).

cnf(neq2383,axiom,
    neq(p6_7,s1) ).

cnf(neq2384,axiom,
    neq(p6_7,s2) ).

cnf(neq2385,axiom,
    neq(p6_7,s3) ).

cnf(neq2386,axiom,
    neq(p6_7,s4) ).

cnf(neq2387,axiom,
    neq(p6_7,s5) ).

cnf(neq2388,axiom,
    neq(p6_7,s6) ).

cnf(neq2389,axiom,
    neq(p6_7,s7) ).

cnf(neq2390,axiom,
    neq(p6_7,s8) ).

cnf(neq2391,axiom,
    neq(p6_7,s9) ).

cnf(neq2392,axiom,
    neq(p6_7,s10) ).

cnf(neq2393,axiom,
    neq(p6_7,s11) ).

cnf(neq2394,axiom,
    neq(p6_7,s12) ).

cnf(neq2395,axiom,
    neq(p6_7,s13) ).

cnf(neq2396,axiom,
    neq(p6_7,s14) ).

cnf(neq2397,axiom,
    neq(p6_7,s15) ).

cnf(neq2398,axiom,
    neq(p6_7,s16) ).

cnf(neq2399,axiom,
    neq(p6_7,s17) ).

cnf(neq2400,axiom,
    neq(p6_7,s18) ).

cnf(neq2401,axiom,
    neq(p6_7,s19) ).

cnf(neq2402,axiom,
    neq(p6_7,p0_8) ).

cnf(neq2403,axiom,
    neq(p6_7,p1_3) ).

cnf(neq2404,axiom,
    neq(p6_7,p1_4) ).

cnf(neq2405,axiom,
    neq(p6_7,p1_9) ).

cnf(neq2406,axiom,
    neq(p6_7,p2_3) ).

cnf(neq2407,axiom,
    neq(p6_7,p3_10) ).

cnf(neq2408,axiom,
    neq(p6_7,p3_19) ).

cnf(neq2409,axiom,
    neq(p6_7,p4_3) ).

cnf(neq2410,axiom,
    neq(p6_7,p4_6) ).

cnf(neq2411,axiom,
    neq(p6_7,p5_0) ).

cnf(neq2412,axiom,
    neq(p6_7,p5_10) ).

cnf(neq2413,axiom,
    ~ neq(p6_7,p6_7) ).

cnf(neq2414,axiom,
    neq(p6_7,p6_10) ).

cnf(neq2415,axiom,
    neq(p6_7,p7_11) ).

cnf(neq2416,axiom,
    neq(p6_7,p8_2) ).

cnf(neq2417,axiom,
    neq(p6_7,p8_3) ).

cnf(neq2418,axiom,
    neq(p6_7,p8_5) ).

cnf(neq2419,axiom,
    neq(p6_7,p8_10) ).

cnf(neq2420,axiom,
    neq(p6_7,p9_15) ).

cnf(neq2421,axiom,
    neq(p6_7,p10_0) ).

cnf(neq2422,axiom,
    neq(p6_7,p11_3) ).

cnf(neq2423,axiom,
    neq(p6_7,p11_5) ).

cnf(neq2424,axiom,
    neq(p6_7,p11_13) ).

cnf(neq2425,axiom,
    neq(p6_7,p13_10) ).

cnf(neq2426,axiom,
    neq(p6_7,p13_14) ).

cnf(neq2427,axiom,
    neq(p6_7,p14_2) ).

cnf(neq2428,axiom,
    neq(p6_7,p14_7) ).

cnf(neq2429,axiom,
    neq(p6_7,p14_16) ).

cnf(neq2430,axiom,
    neq(p6_7,p14_17) ).

cnf(neq2431,axiom,
    neq(p6_7,p15_0) ).

cnf(neq2432,axiom,
    neq(p6_7,p15_1) ).

cnf(neq2433,axiom,
    neq(p6_7,p16_11) ).

cnf(neq2434,axiom,
    neq(p6_7,p16_18) ).

cnf(neq2435,axiom,
    neq(p6_7,p16_19) ).

cnf(neq2436,axiom,
    neq(p6_7,p17_3) ).

cnf(neq2437,axiom,
    neq(p6_7,p17_5) ).

cnf(neq2438,axiom,
    neq(p6_7,p17_8) ).

cnf(neq2439,axiom,
    neq(p6_7,p17_14) ).

cnf(neq2440,axiom,
    neq(p6_7,p18_15) ).

cnf(neq2441,axiom,
    neq(p6_7,p19_8) ).

cnf(neq2442,axiom,
    neq(p6_7,p19_12) ).

cnf(neq2443,axiom,
    neq(p6_10,truck1) ).

cnf(neq2444,axiom,
    neq(p6_10,truck2) ).

cnf(neq2445,axiom,
    neq(p6_10,truck3) ).

cnf(neq2446,axiom,
    neq(p6_10,truck4) ).

cnf(neq2447,axiom,
    neq(p6_10,truck5) ).

cnf(neq2448,axiom,
    neq(p6_10,s0) ).

cnf(neq2449,axiom,
    neq(p6_10,s1) ).

cnf(neq2450,axiom,
    neq(p6_10,s2) ).

cnf(neq2451,axiom,
    neq(p6_10,s3) ).

cnf(neq2452,axiom,
    neq(p6_10,s4) ).

cnf(neq2453,axiom,
    neq(p6_10,s5) ).

cnf(neq2454,axiom,
    neq(p6_10,s6) ).

cnf(neq2455,axiom,
    neq(p6_10,s7) ).

cnf(neq2456,axiom,
    neq(p6_10,s8) ).

cnf(neq2457,axiom,
    neq(p6_10,s9) ).

cnf(neq2458,axiom,
    neq(p6_10,s10) ).

cnf(neq2459,axiom,
    neq(p6_10,s11) ).

cnf(neq2460,axiom,
    neq(p6_10,s12) ).

cnf(neq2461,axiom,
    neq(p6_10,s13) ).

cnf(neq2462,axiom,
    neq(p6_10,s14) ).

cnf(neq2463,axiom,
    neq(p6_10,s15) ).

cnf(neq2464,axiom,
    neq(p6_10,s16) ).

cnf(neq2465,axiom,
    neq(p6_10,s17) ).

cnf(neq2466,axiom,
    neq(p6_10,s18) ).

cnf(neq2467,axiom,
    neq(p6_10,s19) ).

cnf(neq2468,axiom,
    neq(p6_10,p0_8) ).

cnf(neq2469,axiom,
    neq(p6_10,p1_3) ).

cnf(neq2470,axiom,
    neq(p6_10,p1_4) ).

cnf(neq2471,axiom,
    neq(p6_10,p1_9) ).

cnf(neq2472,axiom,
    neq(p6_10,p2_3) ).

cnf(neq2473,axiom,
    neq(p6_10,p3_10) ).

cnf(neq2474,axiom,
    neq(p6_10,p3_19) ).

cnf(neq2475,axiom,
    neq(p6_10,p4_3) ).

cnf(neq2476,axiom,
    neq(p6_10,p4_6) ).

cnf(neq2477,axiom,
    neq(p6_10,p5_0) ).

cnf(neq2478,axiom,
    neq(p6_10,p5_10) ).

cnf(neq2479,axiom,
    neq(p6_10,p6_7) ).

cnf(neq2480,axiom,
    ~ neq(p6_10,p6_10) ).

cnf(neq2481,axiom,
    neq(p6_10,p7_11) ).

cnf(neq2482,axiom,
    neq(p6_10,p8_2) ).

cnf(neq2483,axiom,
    neq(p6_10,p8_3) ).

cnf(neq2484,axiom,
    neq(p6_10,p8_5) ).

cnf(neq2485,axiom,
    neq(p6_10,p8_10) ).

cnf(neq2486,axiom,
    neq(p6_10,p9_15) ).

cnf(neq2487,axiom,
    neq(p6_10,p10_0) ).

cnf(neq2488,axiom,
    neq(p6_10,p11_3) ).

cnf(neq2489,axiom,
    neq(p6_10,p11_5) ).

cnf(neq2490,axiom,
    neq(p6_10,p11_13) ).

cnf(neq2491,axiom,
    neq(p6_10,p13_10) ).

cnf(neq2492,axiom,
    neq(p6_10,p13_14) ).

cnf(neq2493,axiom,
    neq(p6_10,p14_2) ).

cnf(neq2494,axiom,
    neq(p6_10,p14_7) ).

cnf(neq2495,axiom,
    neq(p6_10,p14_16) ).

cnf(neq2496,axiom,
    neq(p6_10,p14_17) ).

cnf(neq2497,axiom,
    neq(p6_10,p15_0) ).

cnf(neq2498,axiom,
    neq(p6_10,p15_1) ).

cnf(neq2499,axiom,
    neq(p6_10,p16_11) ).

cnf(neq2500,axiom,
    neq(p6_10,p16_18) ).

cnf(neq2501,axiom,
    neq(p6_10,p16_19) ).

cnf(neq2502,axiom,
    neq(p6_10,p17_3) ).

cnf(neq2503,axiom,
    neq(p6_10,p17_5) ).

cnf(neq2504,axiom,
    neq(p6_10,p17_8) ).

cnf(neq2505,axiom,
    neq(p6_10,p17_14) ).

cnf(neq2506,axiom,
    neq(p6_10,p18_15) ).

cnf(neq2507,axiom,
    neq(p6_10,p19_8) ).

cnf(neq2508,axiom,
    neq(p6_10,p19_12) ).

cnf(neq2509,axiom,
    neq(p7_11,truck1) ).

cnf(neq2510,axiom,
    neq(p7_11,truck2) ).

cnf(neq2511,axiom,
    neq(p7_11,truck3) ).

cnf(neq2512,axiom,
    neq(p7_11,truck4) ).

cnf(neq2513,axiom,
    neq(p7_11,truck5) ).

cnf(neq2514,axiom,
    neq(p7_11,s0) ).

cnf(neq2515,axiom,
    neq(p7_11,s1) ).

cnf(neq2516,axiom,
    neq(p7_11,s2) ).

cnf(neq2517,axiom,
    neq(p7_11,s3) ).

cnf(neq2518,axiom,
    neq(p7_11,s4) ).

cnf(neq2519,axiom,
    neq(p7_11,s5) ).

cnf(neq2520,axiom,
    neq(p7_11,s6) ).

cnf(neq2521,axiom,
    neq(p7_11,s7) ).

cnf(neq2522,axiom,
    neq(p7_11,s8) ).

cnf(neq2523,axiom,
    neq(p7_11,s9) ).

cnf(neq2524,axiom,
    neq(p7_11,s10) ).

cnf(neq2525,axiom,
    neq(p7_11,s11) ).

cnf(neq2526,axiom,
    neq(p7_11,s12) ).

cnf(neq2527,axiom,
    neq(p7_11,s13) ).

cnf(neq2528,axiom,
    neq(p7_11,s14) ).

cnf(neq2529,axiom,
    neq(p7_11,s15) ).

cnf(neq2530,axiom,
    neq(p7_11,s16) ).

cnf(neq2531,axiom,
    neq(p7_11,s17) ).

cnf(neq2532,axiom,
    neq(p7_11,s18) ).

cnf(neq2533,axiom,
    neq(p7_11,s19) ).

cnf(neq2534,axiom,
    neq(p7_11,p0_8) ).

cnf(neq2535,axiom,
    neq(p7_11,p1_3) ).

cnf(neq2536,axiom,
    neq(p7_11,p1_4) ).

cnf(neq2537,axiom,
    neq(p7_11,p1_9) ).

cnf(neq2538,axiom,
    neq(p7_11,p2_3) ).

cnf(neq2539,axiom,
    neq(p7_11,p3_10) ).

cnf(neq2540,axiom,
    neq(p7_11,p3_19) ).

cnf(neq2541,axiom,
    neq(p7_11,p4_3) ).

cnf(neq2542,axiom,
    neq(p7_11,p4_6) ).

cnf(neq2543,axiom,
    neq(p7_11,p5_0) ).

cnf(neq2544,axiom,
    neq(p7_11,p5_10) ).

cnf(neq2545,axiom,
    neq(p7_11,p6_7) ).

cnf(neq2546,axiom,
    neq(p7_11,p6_10) ).

cnf(neq2547,axiom,
    ~ neq(p7_11,p7_11) ).

cnf(neq2548,axiom,
    neq(p7_11,p8_2) ).

cnf(neq2549,axiom,
    neq(p7_11,p8_3) ).

cnf(neq2550,axiom,
    neq(p7_11,p8_5) ).

cnf(neq2551,axiom,
    neq(p7_11,p8_10) ).

cnf(neq2552,axiom,
    neq(p7_11,p9_15) ).

cnf(neq2553,axiom,
    neq(p7_11,p10_0) ).

cnf(neq2554,axiom,
    neq(p7_11,p11_3) ).

cnf(neq2555,axiom,
    neq(p7_11,p11_5) ).

cnf(neq2556,axiom,
    neq(p7_11,p11_13) ).

cnf(neq2557,axiom,
    neq(p7_11,p13_10) ).

cnf(neq2558,axiom,
    neq(p7_11,p13_14) ).

cnf(neq2559,axiom,
    neq(p7_11,p14_2) ).

cnf(neq2560,axiom,
    neq(p7_11,p14_7) ).

cnf(neq2561,axiom,
    neq(p7_11,p14_16) ).

cnf(neq2562,axiom,
    neq(p7_11,p14_17) ).

cnf(neq2563,axiom,
    neq(p7_11,p15_0) ).

cnf(neq2564,axiom,
    neq(p7_11,p15_1) ).

cnf(neq2565,axiom,
    neq(p7_11,p16_11) ).

cnf(neq2566,axiom,
    neq(p7_11,p16_18) ).

cnf(neq2567,axiom,
    neq(p7_11,p16_19) ).

cnf(neq2568,axiom,
    neq(p7_11,p17_3) ).

cnf(neq2569,axiom,
    neq(p7_11,p17_5) ).

cnf(neq2570,axiom,
    neq(p7_11,p17_8) ).

cnf(neq2571,axiom,
    neq(p7_11,p17_14) ).

cnf(neq2572,axiom,
    neq(p7_11,p18_15) ).

cnf(neq2573,axiom,
    neq(p7_11,p19_8) ).

cnf(neq2574,axiom,
    neq(p7_11,p19_12) ).

cnf(neq2575,axiom,
    neq(p8_2,truck1) ).

cnf(neq2576,axiom,
    neq(p8_2,truck2) ).

cnf(neq2577,axiom,
    neq(p8_2,truck3) ).

cnf(neq2578,axiom,
    neq(p8_2,truck4) ).

cnf(neq2579,axiom,
    neq(p8_2,truck5) ).

cnf(neq2580,axiom,
    neq(p8_2,s0) ).

cnf(neq2581,axiom,
    neq(p8_2,s1) ).

cnf(neq2582,axiom,
    neq(p8_2,s2) ).

cnf(neq2583,axiom,
    neq(p8_2,s3) ).

cnf(neq2584,axiom,
    neq(p8_2,s4) ).

cnf(neq2585,axiom,
    neq(p8_2,s5) ).

cnf(neq2586,axiom,
    neq(p8_2,s6) ).

cnf(neq2587,axiom,
    neq(p8_2,s7) ).

cnf(neq2588,axiom,
    neq(p8_2,s8) ).

cnf(neq2589,axiom,
    neq(p8_2,s9) ).

cnf(neq2590,axiom,
    neq(p8_2,s10) ).

cnf(neq2591,axiom,
    neq(p8_2,s11) ).

cnf(neq2592,axiom,
    neq(p8_2,s12) ).

cnf(neq2593,axiom,
    neq(p8_2,s13) ).

cnf(neq2594,axiom,
    neq(p8_2,s14) ).

cnf(neq2595,axiom,
    neq(p8_2,s15) ).

cnf(neq2596,axiom,
    neq(p8_2,s16) ).

cnf(neq2597,axiom,
    neq(p8_2,s17) ).

cnf(neq2598,axiom,
    neq(p8_2,s18) ).

cnf(neq2599,axiom,
    neq(p8_2,s19) ).

cnf(neq2600,axiom,
    neq(p8_2,p0_8) ).

cnf(neq2601,axiom,
    neq(p8_2,p1_3) ).

cnf(neq2602,axiom,
    neq(p8_2,p1_4) ).

cnf(neq2603,axiom,
    neq(p8_2,p1_9) ).

cnf(neq2604,axiom,
    neq(p8_2,p2_3) ).

cnf(neq2605,axiom,
    neq(p8_2,p3_10) ).

cnf(neq2606,axiom,
    neq(p8_2,p3_19) ).

cnf(neq2607,axiom,
    neq(p8_2,p4_3) ).

cnf(neq2608,axiom,
    neq(p8_2,p4_6) ).

cnf(neq2609,axiom,
    neq(p8_2,p5_0) ).

cnf(neq2610,axiom,
    neq(p8_2,p5_10) ).

cnf(neq2611,axiom,
    neq(p8_2,p6_7) ).

cnf(neq2612,axiom,
    neq(p8_2,p6_10) ).

cnf(neq2613,axiom,
    neq(p8_2,p7_11) ).

cnf(neq2614,axiom,
    ~ neq(p8_2,p8_2) ).

cnf(neq2615,axiom,
    neq(p8_2,p8_3) ).

cnf(neq2616,axiom,
    neq(p8_2,p8_5) ).

cnf(neq2617,axiom,
    neq(p8_2,p8_10) ).

cnf(neq2618,axiom,
    neq(p8_2,p9_15) ).

cnf(neq2619,axiom,
    neq(p8_2,p10_0) ).

cnf(neq2620,axiom,
    neq(p8_2,p11_3) ).

cnf(neq2621,axiom,
    neq(p8_2,p11_5) ).

cnf(neq2622,axiom,
    neq(p8_2,p11_13) ).

cnf(neq2623,axiom,
    neq(p8_2,p13_10) ).

cnf(neq2624,axiom,
    neq(p8_2,p13_14) ).

cnf(neq2625,axiom,
    neq(p8_2,p14_2) ).

cnf(neq2626,axiom,
    neq(p8_2,p14_7) ).

cnf(neq2627,axiom,
    neq(p8_2,p14_16) ).

cnf(neq2628,axiom,
    neq(p8_2,p14_17) ).

cnf(neq2629,axiom,
    neq(p8_2,p15_0) ).

cnf(neq2630,axiom,
    neq(p8_2,p15_1) ).

cnf(neq2631,axiom,
    neq(p8_2,p16_11) ).

cnf(neq2632,axiom,
    neq(p8_2,p16_18) ).

cnf(neq2633,axiom,
    neq(p8_2,p16_19) ).

cnf(neq2634,axiom,
    neq(p8_2,p17_3) ).

cnf(neq2635,axiom,
    neq(p8_2,p17_5) ).

cnf(neq2636,axiom,
    neq(p8_2,p17_8) ).

cnf(neq2637,axiom,
    neq(p8_2,p17_14) ).

cnf(neq2638,axiom,
    neq(p8_2,p18_15) ).

cnf(neq2639,axiom,
    neq(p8_2,p19_8) ).

cnf(neq2640,axiom,
    neq(p8_2,p19_12) ).

cnf(neq2641,axiom,
    neq(p8_3,truck1) ).

cnf(neq2642,axiom,
    neq(p8_3,truck2) ).

cnf(neq2643,axiom,
    neq(p8_3,truck3) ).

cnf(neq2644,axiom,
    neq(p8_3,truck4) ).

cnf(neq2645,axiom,
    neq(p8_3,truck5) ).

cnf(neq2646,axiom,
    neq(p8_3,s0) ).

cnf(neq2647,axiom,
    neq(p8_3,s1) ).

cnf(neq2648,axiom,
    neq(p8_3,s2) ).

cnf(neq2649,axiom,
    neq(p8_3,s3) ).

cnf(neq2650,axiom,
    neq(p8_3,s4) ).

cnf(neq2651,axiom,
    neq(p8_3,s5) ).

cnf(neq2652,axiom,
    neq(p8_3,s6) ).

cnf(neq2653,axiom,
    neq(p8_3,s7) ).

cnf(neq2654,axiom,
    neq(p8_3,s8) ).

cnf(neq2655,axiom,
    neq(p8_3,s9) ).

cnf(neq2656,axiom,
    neq(p8_3,s10) ).

cnf(neq2657,axiom,
    neq(p8_3,s11) ).

cnf(neq2658,axiom,
    neq(p8_3,s12) ).

cnf(neq2659,axiom,
    neq(p8_3,s13) ).

cnf(neq2660,axiom,
    neq(p8_3,s14) ).

cnf(neq2661,axiom,
    neq(p8_3,s15) ).

cnf(neq2662,axiom,
    neq(p8_3,s16) ).

cnf(neq2663,axiom,
    neq(p8_3,s17) ).

cnf(neq2664,axiom,
    neq(p8_3,s18) ).

cnf(neq2665,axiom,
    neq(p8_3,s19) ).

cnf(neq2666,axiom,
    neq(p8_3,p0_8) ).

cnf(neq2667,axiom,
    neq(p8_3,p1_3) ).

cnf(neq2668,axiom,
    neq(p8_3,p1_4) ).

cnf(neq2669,axiom,
    neq(p8_3,p1_9) ).

cnf(neq2670,axiom,
    neq(p8_3,p2_3) ).

cnf(neq2671,axiom,
    neq(p8_3,p3_10) ).

cnf(neq2672,axiom,
    neq(p8_3,p3_19) ).

cnf(neq2673,axiom,
    neq(p8_3,p4_3) ).

cnf(neq2674,axiom,
    neq(p8_3,p4_6) ).

cnf(neq2675,axiom,
    neq(p8_3,p5_0) ).

cnf(neq2676,axiom,
    neq(p8_3,p5_10) ).

cnf(neq2677,axiom,
    neq(p8_3,p6_7) ).

cnf(neq2678,axiom,
    neq(p8_3,p6_10) ).

cnf(neq2679,axiom,
    neq(p8_3,p7_11) ).

cnf(neq2680,axiom,
    neq(p8_3,p8_2) ).

cnf(neq2681,axiom,
    ~ neq(p8_3,p8_3) ).

cnf(neq2682,axiom,
    neq(p8_3,p8_5) ).

cnf(neq2683,axiom,
    neq(p8_3,p8_10) ).

cnf(neq2684,axiom,
    neq(p8_3,p9_15) ).

cnf(neq2685,axiom,
    neq(p8_3,p10_0) ).

cnf(neq2686,axiom,
    neq(p8_3,p11_3) ).

cnf(neq2687,axiom,
    neq(p8_3,p11_5) ).

cnf(neq2688,axiom,
    neq(p8_3,p11_13) ).

cnf(neq2689,axiom,
    neq(p8_3,p13_10) ).

cnf(neq2690,axiom,
    neq(p8_3,p13_14) ).

cnf(neq2691,axiom,
    neq(p8_3,p14_2) ).

cnf(neq2692,axiom,
    neq(p8_3,p14_7) ).

cnf(neq2693,axiom,
    neq(p8_3,p14_16) ).

cnf(neq2694,axiom,
    neq(p8_3,p14_17) ).

cnf(neq2695,axiom,
    neq(p8_3,p15_0) ).

cnf(neq2696,axiom,
    neq(p8_3,p15_1) ).

cnf(neq2697,axiom,
    neq(p8_3,p16_11) ).

cnf(neq2698,axiom,
    neq(p8_3,p16_18) ).

cnf(neq2699,axiom,
    neq(p8_3,p16_19) ).

cnf(neq2700,axiom,
    neq(p8_3,p17_3) ).

cnf(neq2701,axiom,
    neq(p8_3,p17_5) ).

cnf(neq2702,axiom,
    neq(p8_3,p17_8) ).

cnf(neq2703,axiom,
    neq(p8_3,p17_14) ).

cnf(neq2704,axiom,
    neq(p8_3,p18_15) ).

cnf(neq2705,axiom,
    neq(p8_3,p19_8) ).

cnf(neq2706,axiom,
    neq(p8_3,p19_12) ).

cnf(neq2707,axiom,
    neq(p8_5,truck1) ).

cnf(neq2708,axiom,
    neq(p8_5,truck2) ).

cnf(neq2709,axiom,
    neq(p8_5,truck3) ).

cnf(neq2710,axiom,
    neq(p8_5,truck4) ).

cnf(neq2711,axiom,
    neq(p8_5,truck5) ).

cnf(neq2712,axiom,
    neq(p8_5,s0) ).

cnf(neq2713,axiom,
    neq(p8_5,s1) ).

cnf(neq2714,axiom,
    neq(p8_5,s2) ).

cnf(neq2715,axiom,
    neq(p8_5,s3) ).

cnf(neq2716,axiom,
    neq(p8_5,s4) ).

cnf(neq2717,axiom,
    neq(p8_5,s5) ).

cnf(neq2718,axiom,
    neq(p8_5,s6) ).

cnf(neq2719,axiom,
    neq(p8_5,s7) ).

cnf(neq2720,axiom,
    neq(p8_5,s8) ).

cnf(neq2721,axiom,
    neq(p8_5,s9) ).

cnf(neq2722,axiom,
    neq(p8_5,s10) ).

cnf(neq2723,axiom,
    neq(p8_5,s11) ).

cnf(neq2724,axiom,
    neq(p8_5,s12) ).

cnf(neq2725,axiom,
    neq(p8_5,s13) ).

cnf(neq2726,axiom,
    neq(p8_5,s14) ).

cnf(neq2727,axiom,
    neq(p8_5,s15) ).

cnf(neq2728,axiom,
    neq(p8_5,s16) ).

cnf(neq2729,axiom,
    neq(p8_5,s17) ).

cnf(neq2730,axiom,
    neq(p8_5,s18) ).

cnf(neq2731,axiom,
    neq(p8_5,s19) ).

cnf(neq2732,axiom,
    neq(p8_5,p0_8) ).

cnf(neq2733,axiom,
    neq(p8_5,p1_3) ).

cnf(neq2734,axiom,
    neq(p8_5,p1_4) ).

cnf(neq2735,axiom,
    neq(p8_5,p1_9) ).

cnf(neq2736,axiom,
    neq(p8_5,p2_3) ).

cnf(neq2737,axiom,
    neq(p8_5,p3_10) ).

cnf(neq2738,axiom,
    neq(p8_5,p3_19) ).

cnf(neq2739,axiom,
    neq(p8_5,p4_3) ).

cnf(neq2740,axiom,
    neq(p8_5,p4_6) ).

cnf(neq2741,axiom,
    neq(p8_5,p5_0) ).

cnf(neq2742,axiom,
    neq(p8_5,p5_10) ).

cnf(neq2743,axiom,
    neq(p8_5,p6_7) ).

cnf(neq2744,axiom,
    neq(p8_5,p6_10) ).

cnf(neq2745,axiom,
    neq(p8_5,p7_11) ).

cnf(neq2746,axiom,
    neq(p8_5,p8_2) ).

cnf(neq2747,axiom,
    neq(p8_5,p8_3) ).

cnf(neq2748,axiom,
    ~ neq(p8_5,p8_5) ).

cnf(neq2749,axiom,
    neq(p8_5,p8_10) ).

cnf(neq2750,axiom,
    neq(p8_5,p9_15) ).

cnf(neq2751,axiom,
    neq(p8_5,p10_0) ).

cnf(neq2752,axiom,
    neq(p8_5,p11_3) ).

cnf(neq2753,axiom,
    neq(p8_5,p11_5) ).

cnf(neq2754,axiom,
    neq(p8_5,p11_13) ).

cnf(neq2755,axiom,
    neq(p8_5,p13_10) ).

cnf(neq2756,axiom,
    neq(p8_5,p13_14) ).

cnf(neq2757,axiom,
    neq(p8_5,p14_2) ).

cnf(neq2758,axiom,
    neq(p8_5,p14_7) ).

cnf(neq2759,axiom,
    neq(p8_5,p14_16) ).

cnf(neq2760,axiom,
    neq(p8_5,p14_17) ).

cnf(neq2761,axiom,
    neq(p8_5,p15_0) ).

cnf(neq2762,axiom,
    neq(p8_5,p15_1) ).

cnf(neq2763,axiom,
    neq(p8_5,p16_11) ).

cnf(neq2764,axiom,
    neq(p8_5,p16_18) ).

cnf(neq2765,axiom,
    neq(p8_5,p16_19) ).

cnf(neq2766,axiom,
    neq(p8_5,p17_3) ).

cnf(neq2767,axiom,
    neq(p8_5,p17_5) ).

cnf(neq2768,axiom,
    neq(p8_5,p17_8) ).

cnf(neq2769,axiom,
    neq(p8_5,p17_14) ).

cnf(neq2770,axiom,
    neq(p8_5,p18_15) ).

cnf(neq2771,axiom,
    neq(p8_5,p19_8) ).

cnf(neq2772,axiom,
    neq(p8_5,p19_12) ).

cnf(neq2773,axiom,
    neq(p8_10,truck1) ).

cnf(neq2774,axiom,
    neq(p8_10,truck2) ).

cnf(neq2775,axiom,
    neq(p8_10,truck3) ).

cnf(neq2776,axiom,
    neq(p8_10,truck4) ).

cnf(neq2777,axiom,
    neq(p8_10,truck5) ).

cnf(neq2778,axiom,
    neq(p8_10,s0) ).

cnf(neq2779,axiom,
    neq(p8_10,s1) ).

cnf(neq2780,axiom,
    neq(p8_10,s2) ).

cnf(neq2781,axiom,
    neq(p8_10,s3) ).

cnf(neq2782,axiom,
    neq(p8_10,s4) ).

cnf(neq2783,axiom,
    neq(p8_10,s5) ).

cnf(neq2784,axiom,
    neq(p8_10,s6) ).

cnf(neq2785,axiom,
    neq(p8_10,s7) ).

cnf(neq2786,axiom,
    neq(p8_10,s8) ).

cnf(neq2787,axiom,
    neq(p8_10,s9) ).

cnf(neq2788,axiom,
    neq(p8_10,s10) ).

cnf(neq2789,axiom,
    neq(p8_10,s11) ).

cnf(neq2790,axiom,
    neq(p8_10,s12) ).

cnf(neq2791,axiom,
    neq(p8_10,s13) ).

cnf(neq2792,axiom,
    neq(p8_10,s14) ).

cnf(neq2793,axiom,
    neq(p8_10,s15) ).

cnf(neq2794,axiom,
    neq(p8_10,s16) ).

cnf(neq2795,axiom,
    neq(p8_10,s17) ).

cnf(neq2796,axiom,
    neq(p8_10,s18) ).

cnf(neq2797,axiom,
    neq(p8_10,s19) ).

cnf(neq2798,axiom,
    neq(p8_10,p0_8) ).

cnf(neq2799,axiom,
    neq(p8_10,p1_3) ).

cnf(neq2800,axiom,
    neq(p8_10,p1_4) ).

cnf(neq2801,axiom,
    neq(p8_10,p1_9) ).

cnf(neq2802,axiom,
    neq(p8_10,p2_3) ).

cnf(neq2803,axiom,
    neq(p8_10,p3_10) ).

cnf(neq2804,axiom,
    neq(p8_10,p3_19) ).

cnf(neq2805,axiom,
    neq(p8_10,p4_3) ).

cnf(neq2806,axiom,
    neq(p8_10,p4_6) ).

cnf(neq2807,axiom,
    neq(p8_10,p5_0) ).

cnf(neq2808,axiom,
    neq(p8_10,p5_10) ).

cnf(neq2809,axiom,
    neq(p8_10,p6_7) ).

cnf(neq2810,axiom,
    neq(p8_10,p6_10) ).

cnf(neq2811,axiom,
    neq(p8_10,p7_11) ).

cnf(neq2812,axiom,
    neq(p8_10,p8_2) ).

cnf(neq2813,axiom,
    neq(p8_10,p8_3) ).

cnf(neq2814,axiom,
    neq(p8_10,p8_5) ).

cnf(neq2815,axiom,
    ~ neq(p8_10,p8_10) ).

cnf(neq2816,axiom,
    neq(p8_10,p9_15) ).

cnf(neq2817,axiom,
    neq(p8_10,p10_0) ).

cnf(neq2818,axiom,
    neq(p8_10,p11_3) ).

cnf(neq2819,axiom,
    neq(p8_10,p11_5) ).

cnf(neq2820,axiom,
    neq(p8_10,p11_13) ).

cnf(neq2821,axiom,
    neq(p8_10,p13_10) ).

cnf(neq2822,axiom,
    neq(p8_10,p13_14) ).

cnf(neq2823,axiom,
    neq(p8_10,p14_2) ).

cnf(neq2824,axiom,
    neq(p8_10,p14_7) ).

cnf(neq2825,axiom,
    neq(p8_10,p14_16) ).

cnf(neq2826,axiom,
    neq(p8_10,p14_17) ).

cnf(neq2827,axiom,
    neq(p8_10,p15_0) ).

cnf(neq2828,axiom,
    neq(p8_10,p15_1) ).

cnf(neq2829,axiom,
    neq(p8_10,p16_11) ).

cnf(neq2830,axiom,
    neq(p8_10,p16_18) ).

cnf(neq2831,axiom,
    neq(p8_10,p16_19) ).

cnf(neq2832,axiom,
    neq(p8_10,p17_3) ).

cnf(neq2833,axiom,
    neq(p8_10,p17_5) ).

cnf(neq2834,axiom,
    neq(p8_10,p17_8) ).

cnf(neq2835,axiom,
    neq(p8_10,p17_14) ).

cnf(neq2836,axiom,
    neq(p8_10,p18_15) ).

cnf(neq2837,axiom,
    neq(p8_10,p19_8) ).

cnf(neq2838,axiom,
    neq(p8_10,p19_12) ).

cnf(neq2839,axiom,
    neq(p9_15,truck1) ).

cnf(neq2840,axiom,
    neq(p9_15,truck2) ).

cnf(neq2841,axiom,
    neq(p9_15,truck3) ).

cnf(neq2842,axiom,
    neq(p9_15,truck4) ).

cnf(neq2843,axiom,
    neq(p9_15,truck5) ).

cnf(neq2844,axiom,
    neq(p9_15,s0) ).

cnf(neq2845,axiom,
    neq(p9_15,s1) ).

cnf(neq2846,axiom,
    neq(p9_15,s2) ).

cnf(neq2847,axiom,
    neq(p9_15,s3) ).

cnf(neq2848,axiom,
    neq(p9_15,s4) ).

cnf(neq2849,axiom,
    neq(p9_15,s5) ).

cnf(neq2850,axiom,
    neq(p9_15,s6) ).

cnf(neq2851,axiom,
    neq(p9_15,s7) ).

cnf(neq2852,axiom,
    neq(p9_15,s8) ).

cnf(neq2853,axiom,
    neq(p9_15,s9) ).

cnf(neq2854,axiom,
    neq(p9_15,s10) ).

cnf(neq2855,axiom,
    neq(p9_15,s11) ).

cnf(neq2856,axiom,
    neq(p9_15,s12) ).

cnf(neq2857,axiom,
    neq(p9_15,s13) ).

cnf(neq2858,axiom,
    neq(p9_15,s14) ).

cnf(neq2859,axiom,
    neq(p9_15,s15) ).

cnf(neq2860,axiom,
    neq(p9_15,s16) ).

cnf(neq2861,axiom,
    neq(p9_15,s17) ).

cnf(neq2862,axiom,
    neq(p9_15,s18) ).

cnf(neq2863,axiom,
    neq(p9_15,s19) ).

cnf(neq2864,axiom,
    neq(p9_15,p0_8) ).

cnf(neq2865,axiom,
    neq(p9_15,p1_3) ).

cnf(neq2866,axiom,
    neq(p9_15,p1_4) ).

cnf(neq2867,axiom,
    neq(p9_15,p1_9) ).

cnf(neq2868,axiom,
    neq(p9_15,p2_3) ).

cnf(neq2869,axiom,
    neq(p9_15,p3_10) ).

cnf(neq2870,axiom,
    neq(p9_15,p3_19) ).

cnf(neq2871,axiom,
    neq(p9_15,p4_3) ).

cnf(neq2872,axiom,
    neq(p9_15,p4_6) ).

cnf(neq2873,axiom,
    neq(p9_15,p5_0) ).

cnf(neq2874,axiom,
    neq(p9_15,p5_10) ).

cnf(neq2875,axiom,
    neq(p9_15,p6_7) ).

cnf(neq2876,axiom,
    neq(p9_15,p6_10) ).

cnf(neq2877,axiom,
    neq(p9_15,p7_11) ).

cnf(neq2878,axiom,
    neq(p9_15,p8_2) ).

cnf(neq2879,axiom,
    neq(p9_15,p8_3) ).

cnf(neq2880,axiom,
    neq(p9_15,p8_5) ).

cnf(neq2881,axiom,
    neq(p9_15,p8_10) ).

cnf(neq2882,axiom,
    ~ neq(p9_15,p9_15) ).

cnf(neq2883,axiom,
    neq(p9_15,p10_0) ).

cnf(neq2884,axiom,
    neq(p9_15,p11_3) ).

cnf(neq2885,axiom,
    neq(p9_15,p11_5) ).

cnf(neq2886,axiom,
    neq(p9_15,p11_13) ).

cnf(neq2887,axiom,
    neq(p9_15,p13_10) ).

cnf(neq2888,axiom,
    neq(p9_15,p13_14) ).

cnf(neq2889,axiom,
    neq(p9_15,p14_2) ).

cnf(neq2890,axiom,
    neq(p9_15,p14_7) ).

cnf(neq2891,axiom,
    neq(p9_15,p14_16) ).

cnf(neq2892,axiom,
    neq(p9_15,p14_17) ).

cnf(neq2893,axiom,
    neq(p9_15,p15_0) ).

cnf(neq2894,axiom,
    neq(p9_15,p15_1) ).

cnf(neq2895,axiom,
    neq(p9_15,p16_11) ).

cnf(neq2896,axiom,
    neq(p9_15,p16_18) ).

cnf(neq2897,axiom,
    neq(p9_15,p16_19) ).

cnf(neq2898,axiom,
    neq(p9_15,p17_3) ).

cnf(neq2899,axiom,
    neq(p9_15,p17_5) ).

cnf(neq2900,axiom,
    neq(p9_15,p17_8) ).

cnf(neq2901,axiom,
    neq(p9_15,p17_14) ).

cnf(neq2902,axiom,
    neq(p9_15,p18_15) ).

cnf(neq2903,axiom,
    neq(p9_15,p19_8) ).

cnf(neq2904,axiom,
    neq(p9_15,p19_12) ).

cnf(neq2905,axiom,
    neq(p10_0,truck1) ).

cnf(neq2906,axiom,
    neq(p10_0,truck2) ).

cnf(neq2907,axiom,
    neq(p10_0,truck3) ).

cnf(neq2908,axiom,
    neq(p10_0,truck4) ).

cnf(neq2909,axiom,
    neq(p10_0,truck5) ).

cnf(neq2910,axiom,
    neq(p10_0,s0) ).

cnf(neq2911,axiom,
    neq(p10_0,s1) ).

cnf(neq2912,axiom,
    neq(p10_0,s2) ).

cnf(neq2913,axiom,
    neq(p10_0,s3) ).

cnf(neq2914,axiom,
    neq(p10_0,s4) ).

cnf(neq2915,axiom,
    neq(p10_0,s5) ).

cnf(neq2916,axiom,
    neq(p10_0,s6) ).

cnf(neq2917,axiom,
    neq(p10_0,s7) ).

cnf(neq2918,axiom,
    neq(p10_0,s8) ).

cnf(neq2919,axiom,
    neq(p10_0,s9) ).

cnf(neq2920,axiom,
    neq(p10_0,s10) ).

cnf(neq2921,axiom,
    neq(p10_0,s11) ).

cnf(neq2922,axiom,
    neq(p10_0,s12) ).

cnf(neq2923,axiom,
    neq(p10_0,s13) ).

cnf(neq2924,axiom,
    neq(p10_0,s14) ).

cnf(neq2925,axiom,
    neq(p10_0,s15) ).

cnf(neq2926,axiom,
    neq(p10_0,s16) ).

cnf(neq2927,axiom,
    neq(p10_0,s17) ).

cnf(neq2928,axiom,
    neq(p10_0,s18) ).

cnf(neq2929,axiom,
    neq(p10_0,s19) ).

cnf(neq2930,axiom,
    neq(p10_0,p0_8) ).

cnf(neq2931,axiom,
    neq(p10_0,p1_3) ).

cnf(neq2932,axiom,
    neq(p10_0,p1_4) ).

cnf(neq2933,axiom,
    neq(p10_0,p1_9) ).

cnf(neq2934,axiom,
    neq(p10_0,p2_3) ).

cnf(neq2935,axiom,
    neq(p10_0,p3_10) ).

cnf(neq2936,axiom,
    neq(p10_0,p3_19) ).

cnf(neq2937,axiom,
    neq(p10_0,p4_3) ).

cnf(neq2938,axiom,
    neq(p10_0,p4_6) ).

cnf(neq2939,axiom,
    neq(p10_0,p5_0) ).

cnf(neq2940,axiom,
    neq(p10_0,p5_10) ).

cnf(neq2941,axiom,
    neq(p10_0,p6_7) ).

cnf(neq2942,axiom,
    neq(p10_0,p6_10) ).

cnf(neq2943,axiom,
    neq(p10_0,p7_11) ).

cnf(neq2944,axiom,
    neq(p10_0,p8_2) ).

cnf(neq2945,axiom,
    neq(p10_0,p8_3) ).

cnf(neq2946,axiom,
    neq(p10_0,p8_5) ).

cnf(neq2947,axiom,
    neq(p10_0,p8_10) ).

cnf(neq2948,axiom,
    neq(p10_0,p9_15) ).

cnf(neq2949,axiom,
    ~ neq(p10_0,p10_0) ).

cnf(neq2950,axiom,
    neq(p10_0,p11_3) ).

cnf(neq2951,axiom,
    neq(p10_0,p11_5) ).

cnf(neq2952,axiom,
    neq(p10_0,p11_13) ).

cnf(neq2953,axiom,
    neq(p10_0,p13_10) ).

cnf(neq2954,axiom,
    neq(p10_0,p13_14) ).

cnf(neq2955,axiom,
    neq(p10_0,p14_2) ).

cnf(neq2956,axiom,
    neq(p10_0,p14_7) ).

cnf(neq2957,axiom,
    neq(p10_0,p14_16) ).

cnf(neq2958,axiom,
    neq(p10_0,p14_17) ).

cnf(neq2959,axiom,
    neq(p10_0,p15_0) ).

cnf(neq2960,axiom,
    neq(p10_0,p15_1) ).

cnf(neq2961,axiom,
    neq(p10_0,p16_11) ).

cnf(neq2962,axiom,
    neq(p10_0,p16_18) ).

cnf(neq2963,axiom,
    neq(p10_0,p16_19) ).

cnf(neq2964,axiom,
    neq(p10_0,p17_3) ).

cnf(neq2965,axiom,
    neq(p10_0,p17_5) ).

cnf(neq2966,axiom,
    neq(p10_0,p17_8) ).

cnf(neq2967,axiom,
    neq(p10_0,p17_14) ).

cnf(neq2968,axiom,
    neq(p10_0,p18_15) ).

cnf(neq2969,axiom,
    neq(p10_0,p19_8) ).

cnf(neq2970,axiom,
    neq(p10_0,p19_12) ).

cnf(neq2971,axiom,
    neq(p11_3,truck1) ).

cnf(neq2972,axiom,
    neq(p11_3,truck2) ).

cnf(neq2973,axiom,
    neq(p11_3,truck3) ).

cnf(neq2974,axiom,
    neq(p11_3,truck4) ).

cnf(neq2975,axiom,
    neq(p11_3,truck5) ).

cnf(neq2976,axiom,
    neq(p11_3,s0) ).

cnf(neq2977,axiom,
    neq(p11_3,s1) ).

cnf(neq2978,axiom,
    neq(p11_3,s2) ).

cnf(neq2979,axiom,
    neq(p11_3,s3) ).

cnf(neq2980,axiom,
    neq(p11_3,s4) ).

cnf(neq2981,axiom,
    neq(p11_3,s5) ).

cnf(neq2982,axiom,
    neq(p11_3,s6) ).

cnf(neq2983,axiom,
    neq(p11_3,s7) ).

cnf(neq2984,axiom,
    neq(p11_3,s8) ).

cnf(neq2985,axiom,
    neq(p11_3,s9) ).

cnf(neq2986,axiom,
    neq(p11_3,s10) ).

cnf(neq2987,axiom,
    neq(p11_3,s11) ).

cnf(neq2988,axiom,
    neq(p11_3,s12) ).

cnf(neq2989,axiom,
    neq(p11_3,s13) ).

cnf(neq2990,axiom,
    neq(p11_3,s14) ).

cnf(neq2991,axiom,
    neq(p11_3,s15) ).

cnf(neq2992,axiom,
    neq(p11_3,s16) ).

cnf(neq2993,axiom,
    neq(p11_3,s17) ).

cnf(neq2994,axiom,
    neq(p11_3,s18) ).

cnf(neq2995,axiom,
    neq(p11_3,s19) ).

cnf(neq2996,axiom,
    neq(p11_3,p0_8) ).

cnf(neq2997,axiom,
    neq(p11_3,p1_3) ).

cnf(neq2998,axiom,
    neq(p11_3,p1_4) ).

cnf(neq2999,axiom,
    neq(p11_3,p1_9) ).

cnf(neq3000,axiom,
    neq(p11_3,p2_3) ).

cnf(neq3001,axiom,
    neq(p11_3,p3_10) ).

cnf(neq3002,axiom,
    neq(p11_3,p3_19) ).

cnf(neq3003,axiom,
    neq(p11_3,p4_3) ).

cnf(neq3004,axiom,
    neq(p11_3,p4_6) ).

cnf(neq3005,axiom,
    neq(p11_3,p5_0) ).

cnf(neq3006,axiom,
    neq(p11_3,p5_10) ).

cnf(neq3007,axiom,
    neq(p11_3,p6_7) ).

cnf(neq3008,axiom,
    neq(p11_3,p6_10) ).

cnf(neq3009,axiom,
    neq(p11_3,p7_11) ).

cnf(neq3010,axiom,
    neq(p11_3,p8_2) ).

cnf(neq3011,axiom,
    neq(p11_3,p8_3) ).

cnf(neq3012,axiom,
    neq(p11_3,p8_5) ).

cnf(neq3013,axiom,
    neq(p11_3,p8_10) ).

cnf(neq3014,axiom,
    neq(p11_3,p9_15) ).

cnf(neq3015,axiom,
    neq(p11_3,p10_0) ).

cnf(neq3016,axiom,
    ~ neq(p11_3,p11_3) ).

cnf(neq3017,axiom,
    neq(p11_3,p11_5) ).

cnf(neq3018,axiom,
    neq(p11_3,p11_13) ).

cnf(neq3019,axiom,
    neq(p11_3,p13_10) ).

cnf(neq3020,axiom,
    neq(p11_3,p13_14) ).

cnf(neq3021,axiom,
    neq(p11_3,p14_2) ).

cnf(neq3022,axiom,
    neq(p11_3,p14_7) ).

cnf(neq3023,axiom,
    neq(p11_3,p14_16) ).

cnf(neq3024,axiom,
    neq(p11_3,p14_17) ).

cnf(neq3025,axiom,
    neq(p11_3,p15_0) ).

cnf(neq3026,axiom,
    neq(p11_3,p15_1) ).

cnf(neq3027,axiom,
    neq(p11_3,p16_11) ).

cnf(neq3028,axiom,
    neq(p11_3,p16_18) ).

cnf(neq3029,axiom,
    neq(p11_3,p16_19) ).

cnf(neq3030,axiom,
    neq(p11_3,p17_3) ).

cnf(neq3031,axiom,
    neq(p11_3,p17_5) ).

cnf(neq3032,axiom,
    neq(p11_3,p17_8) ).

cnf(neq3033,axiom,
    neq(p11_3,p17_14) ).

cnf(neq3034,axiom,
    neq(p11_3,p18_15) ).

cnf(neq3035,axiom,
    neq(p11_3,p19_8) ).

cnf(neq3036,axiom,
    neq(p11_3,p19_12) ).

cnf(neq3037,axiom,
    neq(p11_5,truck1) ).

cnf(neq3038,axiom,
    neq(p11_5,truck2) ).

cnf(neq3039,axiom,
    neq(p11_5,truck3) ).

cnf(neq3040,axiom,
    neq(p11_5,truck4) ).

cnf(neq3041,axiom,
    neq(p11_5,truck5) ).

cnf(neq3042,axiom,
    neq(p11_5,s0) ).

cnf(neq3043,axiom,
    neq(p11_5,s1) ).

cnf(neq3044,axiom,
    neq(p11_5,s2) ).

cnf(neq3045,axiom,
    neq(p11_5,s3) ).

cnf(neq3046,axiom,
    neq(p11_5,s4) ).

cnf(neq3047,axiom,
    neq(p11_5,s5) ).

cnf(neq3048,axiom,
    neq(p11_5,s6) ).

cnf(neq3049,axiom,
    neq(p11_5,s7) ).

cnf(neq3050,axiom,
    neq(p11_5,s8) ).

cnf(neq3051,axiom,
    neq(p11_5,s9) ).

cnf(neq3052,axiom,
    neq(p11_5,s10) ).

cnf(neq3053,axiom,
    neq(p11_5,s11) ).

cnf(neq3054,axiom,
    neq(p11_5,s12) ).

cnf(neq3055,axiom,
    neq(p11_5,s13) ).

cnf(neq3056,axiom,
    neq(p11_5,s14) ).

cnf(neq3057,axiom,
    neq(p11_5,s15) ).

cnf(neq3058,axiom,
    neq(p11_5,s16) ).

cnf(neq3059,axiom,
    neq(p11_5,s17) ).

cnf(neq3060,axiom,
    neq(p11_5,s18) ).

cnf(neq3061,axiom,
    neq(p11_5,s19) ).

cnf(neq3062,axiom,
    neq(p11_5,p0_8) ).

cnf(neq3063,axiom,
    neq(p11_5,p1_3) ).

cnf(neq3064,axiom,
    neq(p11_5,p1_4) ).

cnf(neq3065,axiom,
    neq(p11_5,p1_9) ).

cnf(neq3066,axiom,
    neq(p11_5,p2_3) ).

cnf(neq3067,axiom,
    neq(p11_5,p3_10) ).

cnf(neq3068,axiom,
    neq(p11_5,p3_19) ).

cnf(neq3069,axiom,
    neq(p11_5,p4_3) ).

cnf(neq3070,axiom,
    neq(p11_5,p4_6) ).

cnf(neq3071,axiom,
    neq(p11_5,p5_0) ).

cnf(neq3072,axiom,
    neq(p11_5,p5_10) ).

cnf(neq3073,axiom,
    neq(p11_5,p6_7) ).

cnf(neq3074,axiom,
    neq(p11_5,p6_10) ).

cnf(neq3075,axiom,
    neq(p11_5,p7_11) ).

cnf(neq3076,axiom,
    neq(p11_5,p8_2) ).

cnf(neq3077,axiom,
    neq(p11_5,p8_3) ).

cnf(neq3078,axiom,
    neq(p11_5,p8_5) ).

cnf(neq3079,axiom,
    neq(p11_5,p8_10) ).

cnf(neq3080,axiom,
    neq(p11_5,p9_15) ).

cnf(neq3081,axiom,
    neq(p11_5,p10_0) ).

cnf(neq3082,axiom,
    neq(p11_5,p11_3) ).

cnf(neq3083,axiom,
    ~ neq(p11_5,p11_5) ).

cnf(neq3084,axiom,
    neq(p11_5,p11_13) ).

cnf(neq3085,axiom,
    neq(p11_5,p13_10) ).

cnf(neq3086,axiom,
    neq(p11_5,p13_14) ).

cnf(neq3087,axiom,
    neq(p11_5,p14_2) ).

cnf(neq3088,axiom,
    neq(p11_5,p14_7) ).

cnf(neq3089,axiom,
    neq(p11_5,p14_16) ).

cnf(neq3090,axiom,
    neq(p11_5,p14_17) ).

cnf(neq3091,axiom,
    neq(p11_5,p15_0) ).

cnf(neq3092,axiom,
    neq(p11_5,p15_1) ).

cnf(neq3093,axiom,
    neq(p11_5,p16_11) ).

cnf(neq3094,axiom,
    neq(p11_5,p16_18) ).

cnf(neq3095,axiom,
    neq(p11_5,p16_19) ).

cnf(neq3096,axiom,
    neq(p11_5,p17_3) ).

cnf(neq3097,axiom,
    neq(p11_5,p17_5) ).

cnf(neq3098,axiom,
    neq(p11_5,p17_8) ).

cnf(neq3099,axiom,
    neq(p11_5,p17_14) ).

cnf(neq3100,axiom,
    neq(p11_5,p18_15) ).

cnf(neq3101,axiom,
    neq(p11_5,p19_8) ).

cnf(neq3102,axiom,
    neq(p11_5,p19_12) ).

cnf(neq3103,axiom,
    neq(p11_13,truck1) ).

cnf(neq3104,axiom,
    neq(p11_13,truck2) ).

cnf(neq3105,axiom,
    neq(p11_13,truck3) ).

cnf(neq3106,axiom,
    neq(p11_13,truck4) ).

cnf(neq3107,axiom,
    neq(p11_13,truck5) ).

cnf(neq3108,axiom,
    neq(p11_13,s0) ).

cnf(neq3109,axiom,
    neq(p11_13,s1) ).

cnf(neq3110,axiom,
    neq(p11_13,s2) ).

cnf(neq3111,axiom,
    neq(p11_13,s3) ).

cnf(neq3112,axiom,
    neq(p11_13,s4) ).

cnf(neq3113,axiom,
    neq(p11_13,s5) ).

cnf(neq3114,axiom,
    neq(p11_13,s6) ).

cnf(neq3115,axiom,
    neq(p11_13,s7) ).

cnf(neq3116,axiom,
    neq(p11_13,s8) ).

cnf(neq3117,axiom,
    neq(p11_13,s9) ).

cnf(neq3118,axiom,
    neq(p11_13,s10) ).

cnf(neq3119,axiom,
    neq(p11_13,s11) ).

cnf(neq3120,axiom,
    neq(p11_13,s12) ).

cnf(neq3121,axiom,
    neq(p11_13,s13) ).

cnf(neq3122,axiom,
    neq(p11_13,s14) ).

cnf(neq3123,axiom,
    neq(p11_13,s15) ).

cnf(neq3124,axiom,
    neq(p11_13,s16) ).

cnf(neq3125,axiom,
    neq(p11_13,s17) ).

cnf(neq3126,axiom,
    neq(p11_13,s18) ).

cnf(neq3127,axiom,
    neq(p11_13,s19) ).

cnf(neq3128,axiom,
    neq(p11_13,p0_8) ).

cnf(neq3129,axiom,
    neq(p11_13,p1_3) ).

cnf(neq3130,axiom,
    neq(p11_13,p1_4) ).

cnf(neq3131,axiom,
    neq(p11_13,p1_9) ).

cnf(neq3132,axiom,
    neq(p11_13,p2_3) ).

cnf(neq3133,axiom,
    neq(p11_13,p3_10) ).

cnf(neq3134,axiom,
    neq(p11_13,p3_19) ).

cnf(neq3135,axiom,
    neq(p11_13,p4_3) ).

cnf(neq3136,axiom,
    neq(p11_13,p4_6) ).

cnf(neq3137,axiom,
    neq(p11_13,p5_0) ).

cnf(neq3138,axiom,
    neq(p11_13,p5_10) ).

cnf(neq3139,axiom,
    neq(p11_13,p6_7) ).

cnf(neq3140,axiom,
    neq(p11_13,p6_10) ).

cnf(neq3141,axiom,
    neq(p11_13,p7_11) ).

cnf(neq3142,axiom,
    neq(p11_13,p8_2) ).

cnf(neq3143,axiom,
    neq(p11_13,p8_3) ).

cnf(neq3144,axiom,
    neq(p11_13,p8_5) ).

cnf(neq3145,axiom,
    neq(p11_13,p8_10) ).

cnf(neq3146,axiom,
    neq(p11_13,p9_15) ).

cnf(neq3147,axiom,
    neq(p11_13,p10_0) ).

cnf(neq3148,axiom,
    neq(p11_13,p11_3) ).

cnf(neq3149,axiom,
    neq(p11_13,p11_5) ).

cnf(neq3150,axiom,
    ~ neq(p11_13,p11_13) ).

cnf(neq3151,axiom,
    neq(p11_13,p13_10) ).

cnf(neq3152,axiom,
    neq(p11_13,p13_14) ).

cnf(neq3153,axiom,
    neq(p11_13,p14_2) ).

cnf(neq3154,axiom,
    neq(p11_13,p14_7) ).

cnf(neq3155,axiom,
    neq(p11_13,p14_16) ).

cnf(neq3156,axiom,
    neq(p11_13,p14_17) ).

cnf(neq3157,axiom,
    neq(p11_13,p15_0) ).

cnf(neq3158,axiom,
    neq(p11_13,p15_1) ).

cnf(neq3159,axiom,
    neq(p11_13,p16_11) ).

cnf(neq3160,axiom,
    neq(p11_13,p16_18) ).

cnf(neq3161,axiom,
    neq(p11_13,p16_19) ).

cnf(neq3162,axiom,
    neq(p11_13,p17_3) ).

cnf(neq3163,axiom,
    neq(p11_13,p17_5) ).

cnf(neq3164,axiom,
    neq(p11_13,p17_8) ).

cnf(neq3165,axiom,
    neq(p11_13,p17_14) ).

cnf(neq3166,axiom,
    neq(p11_13,p18_15) ).

cnf(neq3167,axiom,
    neq(p11_13,p19_8) ).

cnf(neq3168,axiom,
    neq(p11_13,p19_12) ).

cnf(neq3169,axiom,
    neq(p13_10,truck1) ).

cnf(neq3170,axiom,
    neq(p13_10,truck2) ).

cnf(neq3171,axiom,
    neq(p13_10,truck3) ).

cnf(neq3172,axiom,
    neq(p13_10,truck4) ).

cnf(neq3173,axiom,
    neq(p13_10,truck5) ).

cnf(neq3174,axiom,
    neq(p13_10,s0) ).

cnf(neq3175,axiom,
    neq(p13_10,s1) ).

cnf(neq3176,axiom,
    neq(p13_10,s2) ).

cnf(neq3177,axiom,
    neq(p13_10,s3) ).

cnf(neq3178,axiom,
    neq(p13_10,s4) ).

cnf(neq3179,axiom,
    neq(p13_10,s5) ).

cnf(neq3180,axiom,
    neq(p13_10,s6) ).

cnf(neq3181,axiom,
    neq(p13_10,s7) ).

cnf(neq3182,axiom,
    neq(p13_10,s8) ).

cnf(neq3183,axiom,
    neq(p13_10,s9) ).

cnf(neq3184,axiom,
    neq(p13_10,s10) ).

cnf(neq3185,axiom,
    neq(p13_10,s11) ).

cnf(neq3186,axiom,
    neq(p13_10,s12) ).

cnf(neq3187,axiom,
    neq(p13_10,s13) ).

cnf(neq3188,axiom,
    neq(p13_10,s14) ).

cnf(neq3189,axiom,
    neq(p13_10,s15) ).

cnf(neq3190,axiom,
    neq(p13_10,s16) ).

cnf(neq3191,axiom,
    neq(p13_10,s17) ).

cnf(neq3192,axiom,
    neq(p13_10,s18) ).

cnf(neq3193,axiom,
    neq(p13_10,s19) ).

cnf(neq3194,axiom,
    neq(p13_10,p0_8) ).

cnf(neq3195,axiom,
    neq(p13_10,p1_3) ).

cnf(neq3196,axiom,
    neq(p13_10,p1_4) ).

cnf(neq3197,axiom,
    neq(p13_10,p1_9) ).

cnf(neq3198,axiom,
    neq(p13_10,p2_3) ).

cnf(neq3199,axiom,
    neq(p13_10,p3_10) ).

cnf(neq3200,axiom,
    neq(p13_10,p3_19) ).

cnf(neq3201,axiom,
    neq(p13_10,p4_3) ).

cnf(neq3202,axiom,
    neq(p13_10,p4_6) ).

cnf(neq3203,axiom,
    neq(p13_10,p5_0) ).

cnf(neq3204,axiom,
    neq(p13_10,p5_10) ).

cnf(neq3205,axiom,
    neq(p13_10,p6_7) ).

cnf(neq3206,axiom,
    neq(p13_10,p6_10) ).

cnf(neq3207,axiom,
    neq(p13_10,p7_11) ).

cnf(neq3208,axiom,
    neq(p13_10,p8_2) ).

cnf(neq3209,axiom,
    neq(p13_10,p8_3) ).

cnf(neq3210,axiom,
    neq(p13_10,p8_5) ).

cnf(neq3211,axiom,
    neq(p13_10,p8_10) ).

cnf(neq3212,axiom,
    neq(p13_10,p9_15) ).

cnf(neq3213,axiom,
    neq(p13_10,p10_0) ).

cnf(neq3214,axiom,
    neq(p13_10,p11_3) ).

cnf(neq3215,axiom,
    neq(p13_10,p11_5) ).

cnf(neq3216,axiom,
    neq(p13_10,p11_13) ).

cnf(neq3217,axiom,
    ~ neq(p13_10,p13_10) ).

cnf(neq3218,axiom,
    neq(p13_10,p13_14) ).

cnf(neq3219,axiom,
    neq(p13_10,p14_2) ).

cnf(neq3220,axiom,
    neq(p13_10,p14_7) ).

cnf(neq3221,axiom,
    neq(p13_10,p14_16) ).

cnf(neq3222,axiom,
    neq(p13_10,p14_17) ).

cnf(neq3223,axiom,
    neq(p13_10,p15_0) ).

cnf(neq3224,axiom,
    neq(p13_10,p15_1) ).

cnf(neq3225,axiom,
    neq(p13_10,p16_11) ).

cnf(neq3226,axiom,
    neq(p13_10,p16_18) ).

cnf(neq3227,axiom,
    neq(p13_10,p16_19) ).

cnf(neq3228,axiom,
    neq(p13_10,p17_3) ).

cnf(neq3229,axiom,
    neq(p13_10,p17_5) ).

cnf(neq3230,axiom,
    neq(p13_10,p17_8) ).

cnf(neq3231,axiom,
    neq(p13_10,p17_14) ).

cnf(neq3232,axiom,
    neq(p13_10,p18_15) ).

cnf(neq3233,axiom,
    neq(p13_10,p19_8) ).

cnf(neq3234,axiom,
    neq(p13_10,p19_12) ).

cnf(neq3235,axiom,
    neq(p13_14,truck1) ).

cnf(neq3236,axiom,
    neq(p13_14,truck2) ).

cnf(neq3237,axiom,
    neq(p13_14,truck3) ).

cnf(neq3238,axiom,
    neq(p13_14,truck4) ).

cnf(neq3239,axiom,
    neq(p13_14,truck5) ).

cnf(neq3240,axiom,
    neq(p13_14,s0) ).

cnf(neq3241,axiom,
    neq(p13_14,s1) ).

cnf(neq3242,axiom,
    neq(p13_14,s2) ).

cnf(neq3243,axiom,
    neq(p13_14,s3) ).

cnf(neq3244,axiom,
    neq(p13_14,s4) ).

cnf(neq3245,axiom,
    neq(p13_14,s5) ).

cnf(neq3246,axiom,
    neq(p13_14,s6) ).

cnf(neq3247,axiom,
    neq(p13_14,s7) ).

cnf(neq3248,axiom,
    neq(p13_14,s8) ).

cnf(neq3249,axiom,
    neq(p13_14,s9) ).

cnf(neq3250,axiom,
    neq(p13_14,s10) ).

cnf(neq3251,axiom,
    neq(p13_14,s11) ).

cnf(neq3252,axiom,
    neq(p13_14,s12) ).

cnf(neq3253,axiom,
    neq(p13_14,s13) ).

cnf(neq3254,axiom,
    neq(p13_14,s14) ).

cnf(neq3255,axiom,
    neq(p13_14,s15) ).

cnf(neq3256,axiom,
    neq(p13_14,s16) ).

cnf(neq3257,axiom,
    neq(p13_14,s17) ).

cnf(neq3258,axiom,
    neq(p13_14,s18) ).

cnf(neq3259,axiom,
    neq(p13_14,s19) ).

cnf(neq3260,axiom,
    neq(p13_14,p0_8) ).

cnf(neq3261,axiom,
    neq(p13_14,p1_3) ).

cnf(neq3262,axiom,
    neq(p13_14,p1_4) ).

cnf(neq3263,axiom,
    neq(p13_14,p1_9) ).

cnf(neq3264,axiom,
    neq(p13_14,p2_3) ).

cnf(neq3265,axiom,
    neq(p13_14,p3_10) ).

cnf(neq3266,axiom,
    neq(p13_14,p3_19) ).

cnf(neq3267,axiom,
    neq(p13_14,p4_3) ).

cnf(neq3268,axiom,
    neq(p13_14,p4_6) ).

cnf(neq3269,axiom,
    neq(p13_14,p5_0) ).

cnf(neq3270,axiom,
    neq(p13_14,p5_10) ).

cnf(neq3271,axiom,
    neq(p13_14,p6_7) ).

cnf(neq3272,axiom,
    neq(p13_14,p6_10) ).

cnf(neq3273,axiom,
    neq(p13_14,p7_11) ).

cnf(neq3274,axiom,
    neq(p13_14,p8_2) ).

cnf(neq3275,axiom,
    neq(p13_14,p8_3) ).

cnf(neq3276,axiom,
    neq(p13_14,p8_5) ).

cnf(neq3277,axiom,
    neq(p13_14,p8_10) ).

cnf(neq3278,axiom,
    neq(p13_14,p9_15) ).

cnf(neq3279,axiom,
    neq(p13_14,p10_0) ).

cnf(neq3280,axiom,
    neq(p13_14,p11_3) ).

cnf(neq3281,axiom,
    neq(p13_14,p11_5) ).

cnf(neq3282,axiom,
    neq(p13_14,p11_13) ).

cnf(neq3283,axiom,
    neq(p13_14,p13_10) ).

cnf(neq3284,axiom,
    ~ neq(p13_14,p13_14) ).

cnf(neq3285,axiom,
    neq(p13_14,p14_2) ).

cnf(neq3286,axiom,
    neq(p13_14,p14_7) ).

cnf(neq3287,axiom,
    neq(p13_14,p14_16) ).

cnf(neq3288,axiom,
    neq(p13_14,p14_17) ).

cnf(neq3289,axiom,
    neq(p13_14,p15_0) ).

cnf(neq3290,axiom,
    neq(p13_14,p15_1) ).

cnf(neq3291,axiom,
    neq(p13_14,p16_11) ).

cnf(neq3292,axiom,
    neq(p13_14,p16_18) ).

cnf(neq3293,axiom,
    neq(p13_14,p16_19) ).

cnf(neq3294,axiom,
    neq(p13_14,p17_3) ).

cnf(neq3295,axiom,
    neq(p13_14,p17_5) ).

cnf(neq3296,axiom,
    neq(p13_14,p17_8) ).

cnf(neq3297,axiom,
    neq(p13_14,p17_14) ).

cnf(neq3298,axiom,
    neq(p13_14,p18_15) ).

cnf(neq3299,axiom,
    neq(p13_14,p19_8) ).

cnf(neq3300,axiom,
    neq(p13_14,p19_12) ).

cnf(neq3301,axiom,
    neq(p14_2,truck1) ).

cnf(neq3302,axiom,
    neq(p14_2,truck2) ).

cnf(neq3303,axiom,
    neq(p14_2,truck3) ).

cnf(neq3304,axiom,
    neq(p14_2,truck4) ).

cnf(neq3305,axiom,
    neq(p14_2,truck5) ).

cnf(neq3306,axiom,
    neq(p14_2,s0) ).

cnf(neq3307,axiom,
    neq(p14_2,s1) ).

cnf(neq3308,axiom,
    neq(p14_2,s2) ).

cnf(neq3309,axiom,
    neq(p14_2,s3) ).

cnf(neq3310,axiom,
    neq(p14_2,s4) ).

cnf(neq3311,axiom,
    neq(p14_2,s5) ).

cnf(neq3312,axiom,
    neq(p14_2,s6) ).

cnf(neq3313,axiom,
    neq(p14_2,s7) ).

cnf(neq3314,axiom,
    neq(p14_2,s8) ).

cnf(neq3315,axiom,
    neq(p14_2,s9) ).

cnf(neq3316,axiom,
    neq(p14_2,s10) ).

cnf(neq3317,axiom,
    neq(p14_2,s11) ).

cnf(neq3318,axiom,
    neq(p14_2,s12) ).

cnf(neq3319,axiom,
    neq(p14_2,s13) ).

cnf(neq3320,axiom,
    neq(p14_2,s14) ).

cnf(neq3321,axiom,
    neq(p14_2,s15) ).

cnf(neq3322,axiom,
    neq(p14_2,s16) ).

cnf(neq3323,axiom,
    neq(p14_2,s17) ).

cnf(neq3324,axiom,
    neq(p14_2,s18) ).

cnf(neq3325,axiom,
    neq(p14_2,s19) ).

cnf(neq3326,axiom,
    neq(p14_2,p0_8) ).

cnf(neq3327,axiom,
    neq(p14_2,p1_3) ).

cnf(neq3328,axiom,
    neq(p14_2,p1_4) ).

cnf(neq3329,axiom,
    neq(p14_2,p1_9) ).

cnf(neq3330,axiom,
    neq(p14_2,p2_3) ).

cnf(neq3331,axiom,
    neq(p14_2,p3_10) ).

cnf(neq3332,axiom,
    neq(p14_2,p3_19) ).

cnf(neq3333,axiom,
    neq(p14_2,p4_3) ).

cnf(neq3334,axiom,
    neq(p14_2,p4_6) ).

cnf(neq3335,axiom,
    neq(p14_2,p5_0) ).

cnf(neq3336,axiom,
    neq(p14_2,p5_10) ).

cnf(neq3337,axiom,
    neq(p14_2,p6_7) ).

cnf(neq3338,axiom,
    neq(p14_2,p6_10) ).

cnf(neq3339,axiom,
    neq(p14_2,p7_11) ).

cnf(neq3340,axiom,
    neq(p14_2,p8_2) ).

cnf(neq3341,axiom,
    neq(p14_2,p8_3) ).

cnf(neq3342,axiom,
    neq(p14_2,p8_5) ).

cnf(neq3343,axiom,
    neq(p14_2,p8_10) ).

cnf(neq3344,axiom,
    neq(p14_2,p9_15) ).

cnf(neq3345,axiom,
    neq(p14_2,p10_0) ).

cnf(neq3346,axiom,
    neq(p14_2,p11_3) ).

cnf(neq3347,axiom,
    neq(p14_2,p11_5) ).

cnf(neq3348,axiom,
    neq(p14_2,p11_13) ).

cnf(neq3349,axiom,
    neq(p14_2,p13_10) ).

cnf(neq3350,axiom,
    neq(p14_2,p13_14) ).

cnf(neq3351,axiom,
    ~ neq(p14_2,p14_2) ).

cnf(neq3352,axiom,
    neq(p14_2,p14_7) ).

cnf(neq3353,axiom,
    neq(p14_2,p14_16) ).

cnf(neq3354,axiom,
    neq(p14_2,p14_17) ).

cnf(neq3355,axiom,
    neq(p14_2,p15_0) ).

cnf(neq3356,axiom,
    neq(p14_2,p15_1) ).

cnf(neq3357,axiom,
    neq(p14_2,p16_11) ).

cnf(neq3358,axiom,
    neq(p14_2,p16_18) ).

cnf(neq3359,axiom,
    neq(p14_2,p16_19) ).

cnf(neq3360,axiom,
    neq(p14_2,p17_3) ).

cnf(neq3361,axiom,
    neq(p14_2,p17_5) ).

cnf(neq3362,axiom,
    neq(p14_2,p17_8) ).

cnf(neq3363,axiom,
    neq(p14_2,p17_14) ).

cnf(neq3364,axiom,
    neq(p14_2,p18_15) ).

cnf(neq3365,axiom,
    neq(p14_2,p19_8) ).

cnf(neq3366,axiom,
    neq(p14_2,p19_12) ).

cnf(neq3367,axiom,
    neq(p14_7,truck1) ).

cnf(neq3368,axiom,
    neq(p14_7,truck2) ).

cnf(neq3369,axiom,
    neq(p14_7,truck3) ).

cnf(neq3370,axiom,
    neq(p14_7,truck4) ).

cnf(neq3371,axiom,
    neq(p14_7,truck5) ).

cnf(neq3372,axiom,
    neq(p14_7,s0) ).

cnf(neq3373,axiom,
    neq(p14_7,s1) ).

cnf(neq3374,axiom,
    neq(p14_7,s2) ).

cnf(neq3375,axiom,
    neq(p14_7,s3) ).

cnf(neq3376,axiom,
    neq(p14_7,s4) ).

cnf(neq3377,axiom,
    neq(p14_7,s5) ).

cnf(neq3378,axiom,
    neq(p14_7,s6) ).

cnf(neq3379,axiom,
    neq(p14_7,s7) ).

cnf(neq3380,axiom,
    neq(p14_7,s8) ).

cnf(neq3381,axiom,
    neq(p14_7,s9) ).

cnf(neq3382,axiom,
    neq(p14_7,s10) ).

cnf(neq3383,axiom,
    neq(p14_7,s11) ).

cnf(neq3384,axiom,
    neq(p14_7,s12) ).

cnf(neq3385,axiom,
    neq(p14_7,s13) ).

cnf(neq3386,axiom,
    neq(p14_7,s14) ).

cnf(neq3387,axiom,
    neq(p14_7,s15) ).

cnf(neq3388,axiom,
    neq(p14_7,s16) ).

cnf(neq3389,axiom,
    neq(p14_7,s17) ).

cnf(neq3390,axiom,
    neq(p14_7,s18) ).

cnf(neq3391,axiom,
    neq(p14_7,s19) ).

cnf(neq3392,axiom,
    neq(p14_7,p0_8) ).

cnf(neq3393,axiom,
    neq(p14_7,p1_3) ).

cnf(neq3394,axiom,
    neq(p14_7,p1_4) ).

cnf(neq3395,axiom,
    neq(p14_7,p1_9) ).

cnf(neq3396,axiom,
    neq(p14_7,p2_3) ).

cnf(neq3397,axiom,
    neq(p14_7,p3_10) ).

cnf(neq3398,axiom,
    neq(p14_7,p3_19) ).

cnf(neq3399,axiom,
    neq(p14_7,p4_3) ).

cnf(neq3400,axiom,
    neq(p14_7,p4_6) ).

cnf(neq3401,axiom,
    neq(p14_7,p5_0) ).

cnf(neq3402,axiom,
    neq(p14_7,p5_10) ).

cnf(neq3403,axiom,
    neq(p14_7,p6_7) ).

cnf(neq3404,axiom,
    neq(p14_7,p6_10) ).

cnf(neq3405,axiom,
    neq(p14_7,p7_11) ).

cnf(neq3406,axiom,
    neq(p14_7,p8_2) ).

cnf(neq3407,axiom,
    neq(p14_7,p8_3) ).

cnf(neq3408,axiom,
    neq(p14_7,p8_5) ).

cnf(neq3409,axiom,
    neq(p14_7,p8_10) ).

cnf(neq3410,axiom,
    neq(p14_7,p9_15) ).

cnf(neq3411,axiom,
    neq(p14_7,p10_0) ).

cnf(neq3412,axiom,
    neq(p14_7,p11_3) ).

cnf(neq3413,axiom,
    neq(p14_7,p11_5) ).

cnf(neq3414,axiom,
    neq(p14_7,p11_13) ).

cnf(neq3415,axiom,
    neq(p14_7,p13_10) ).

cnf(neq3416,axiom,
    neq(p14_7,p13_14) ).

cnf(neq3417,axiom,
    neq(p14_7,p14_2) ).

cnf(neq3418,axiom,
    ~ neq(p14_7,p14_7) ).

cnf(neq3419,axiom,
    neq(p14_7,p14_16) ).

cnf(neq3420,axiom,
    neq(p14_7,p14_17) ).

cnf(neq3421,axiom,
    neq(p14_7,p15_0) ).

cnf(neq3422,axiom,
    neq(p14_7,p15_1) ).

cnf(neq3423,axiom,
    neq(p14_7,p16_11) ).

cnf(neq3424,axiom,
    neq(p14_7,p16_18) ).

cnf(neq3425,axiom,
    neq(p14_7,p16_19) ).

cnf(neq3426,axiom,
    neq(p14_7,p17_3) ).

cnf(neq3427,axiom,
    neq(p14_7,p17_5) ).

cnf(neq3428,axiom,
    neq(p14_7,p17_8) ).

cnf(neq3429,axiom,
    neq(p14_7,p17_14) ).

cnf(neq3430,axiom,
    neq(p14_7,p18_15) ).

cnf(neq3431,axiom,
    neq(p14_7,p19_8) ).

cnf(neq3432,axiom,
    neq(p14_7,p19_12) ).

cnf(neq3433,axiom,
    neq(p14_16,truck1) ).

cnf(neq3434,axiom,
    neq(p14_16,truck2) ).

cnf(neq3435,axiom,
    neq(p14_16,truck3) ).

cnf(neq3436,axiom,
    neq(p14_16,truck4) ).

cnf(neq3437,axiom,
    neq(p14_16,truck5) ).

cnf(neq3438,axiom,
    neq(p14_16,s0) ).

cnf(neq3439,axiom,
    neq(p14_16,s1) ).

cnf(neq3440,axiom,
    neq(p14_16,s2) ).

cnf(neq3441,axiom,
    neq(p14_16,s3) ).

cnf(neq3442,axiom,
    neq(p14_16,s4) ).

cnf(neq3443,axiom,
    neq(p14_16,s5) ).

cnf(neq3444,axiom,
    neq(p14_16,s6) ).

cnf(neq3445,axiom,
    neq(p14_16,s7) ).

cnf(neq3446,axiom,
    neq(p14_16,s8) ).

cnf(neq3447,axiom,
    neq(p14_16,s9) ).

cnf(neq3448,axiom,
    neq(p14_16,s10) ).

cnf(neq3449,axiom,
    neq(p14_16,s11) ).

cnf(neq3450,axiom,
    neq(p14_16,s12) ).

cnf(neq3451,axiom,
    neq(p14_16,s13) ).

cnf(neq3452,axiom,
    neq(p14_16,s14) ).

cnf(neq3453,axiom,
    neq(p14_16,s15) ).

cnf(neq3454,axiom,
    neq(p14_16,s16) ).

cnf(neq3455,axiom,
    neq(p14_16,s17) ).

cnf(neq3456,axiom,
    neq(p14_16,s18) ).

cnf(neq3457,axiom,
    neq(p14_16,s19) ).

cnf(neq3458,axiom,
    neq(p14_16,p0_8) ).

cnf(neq3459,axiom,
    neq(p14_16,p1_3) ).

cnf(neq3460,axiom,
    neq(p14_16,p1_4) ).

cnf(neq3461,axiom,
    neq(p14_16,p1_9) ).

cnf(neq3462,axiom,
    neq(p14_16,p2_3) ).

cnf(neq3463,axiom,
    neq(p14_16,p3_10) ).

cnf(neq3464,axiom,
    neq(p14_16,p3_19) ).

cnf(neq3465,axiom,
    neq(p14_16,p4_3) ).

cnf(neq3466,axiom,
    neq(p14_16,p4_6) ).

cnf(neq3467,axiom,
    neq(p14_16,p5_0) ).

cnf(neq3468,axiom,
    neq(p14_16,p5_10) ).

cnf(neq3469,axiom,
    neq(p14_16,p6_7) ).

cnf(neq3470,axiom,
    neq(p14_16,p6_10) ).

cnf(neq3471,axiom,
    neq(p14_16,p7_11) ).

cnf(neq3472,axiom,
    neq(p14_16,p8_2) ).

cnf(neq3473,axiom,
    neq(p14_16,p8_3) ).

cnf(neq3474,axiom,
    neq(p14_16,p8_5) ).

cnf(neq3475,axiom,
    neq(p14_16,p8_10) ).

cnf(neq3476,axiom,
    neq(p14_16,p9_15) ).

cnf(neq3477,axiom,
    neq(p14_16,p10_0) ).

cnf(neq3478,axiom,
    neq(p14_16,p11_3) ).

cnf(neq3479,axiom,
    neq(p14_16,p11_5) ).

cnf(neq3480,axiom,
    neq(p14_16,p11_13) ).

cnf(neq3481,axiom,
    neq(p14_16,p13_10) ).

cnf(neq3482,axiom,
    neq(p14_16,p13_14) ).

cnf(neq3483,axiom,
    neq(p14_16,p14_2) ).

cnf(neq3484,axiom,
    neq(p14_16,p14_7) ).

cnf(neq3485,axiom,
    ~ neq(p14_16,p14_16) ).

cnf(neq3486,axiom,
    neq(p14_16,p14_17) ).

cnf(neq3487,axiom,
    neq(p14_16,p15_0) ).

cnf(neq3488,axiom,
    neq(p14_16,p15_1) ).

cnf(neq3489,axiom,
    neq(p14_16,p16_11) ).

cnf(neq3490,axiom,
    neq(p14_16,p16_18) ).

cnf(neq3491,axiom,
    neq(p14_16,p16_19) ).

cnf(neq3492,axiom,
    neq(p14_16,p17_3) ).

cnf(neq3493,axiom,
    neq(p14_16,p17_5) ).

cnf(neq3494,axiom,
    neq(p14_16,p17_8) ).

cnf(neq3495,axiom,
    neq(p14_16,p17_14) ).

cnf(neq3496,axiom,
    neq(p14_16,p18_15) ).

cnf(neq3497,axiom,
    neq(p14_16,p19_8) ).

cnf(neq3498,axiom,
    neq(p14_16,p19_12) ).

cnf(neq3499,axiom,
    neq(p14_17,truck1) ).

cnf(neq3500,axiom,
    neq(p14_17,truck2) ).

cnf(neq3501,axiom,
    neq(p14_17,truck3) ).

cnf(neq3502,axiom,
    neq(p14_17,truck4) ).

cnf(neq3503,axiom,
    neq(p14_17,truck5) ).

cnf(neq3504,axiom,
    neq(p14_17,s0) ).

cnf(neq3505,axiom,
    neq(p14_17,s1) ).

cnf(neq3506,axiom,
    neq(p14_17,s2) ).

cnf(neq3507,axiom,
    neq(p14_17,s3) ).

cnf(neq3508,axiom,
    neq(p14_17,s4) ).

cnf(neq3509,axiom,
    neq(p14_17,s5) ).

cnf(neq3510,axiom,
    neq(p14_17,s6) ).

cnf(neq3511,axiom,
    neq(p14_17,s7) ).

cnf(neq3512,axiom,
    neq(p14_17,s8) ).

cnf(neq3513,axiom,
    neq(p14_17,s9) ).

cnf(neq3514,axiom,
    neq(p14_17,s10) ).

cnf(neq3515,axiom,
    neq(p14_17,s11) ).

cnf(neq3516,axiom,
    neq(p14_17,s12) ).

cnf(neq3517,axiom,
    neq(p14_17,s13) ).

cnf(neq3518,axiom,
    neq(p14_17,s14) ).

cnf(neq3519,axiom,
    neq(p14_17,s15) ).

cnf(neq3520,axiom,
    neq(p14_17,s16) ).

cnf(neq3521,axiom,
    neq(p14_17,s17) ).

cnf(neq3522,axiom,
    neq(p14_17,s18) ).

cnf(neq3523,axiom,
    neq(p14_17,s19) ).

cnf(neq3524,axiom,
    neq(p14_17,p0_8) ).

cnf(neq3525,axiom,
    neq(p14_17,p1_3) ).

cnf(neq3526,axiom,
    neq(p14_17,p1_4) ).

cnf(neq3527,axiom,
    neq(p14_17,p1_9) ).

cnf(neq3528,axiom,
    neq(p14_17,p2_3) ).

cnf(neq3529,axiom,
    neq(p14_17,p3_10) ).

cnf(neq3530,axiom,
    neq(p14_17,p3_19) ).

cnf(neq3531,axiom,
    neq(p14_17,p4_3) ).

cnf(neq3532,axiom,
    neq(p14_17,p4_6) ).

cnf(neq3533,axiom,
    neq(p14_17,p5_0) ).

cnf(neq3534,axiom,
    neq(p14_17,p5_10) ).

cnf(neq3535,axiom,
    neq(p14_17,p6_7) ).

cnf(neq3536,axiom,
    neq(p14_17,p6_10) ).

cnf(neq3537,axiom,
    neq(p14_17,p7_11) ).

cnf(neq3538,axiom,
    neq(p14_17,p8_2) ).

cnf(neq3539,axiom,
    neq(p14_17,p8_3) ).

cnf(neq3540,axiom,
    neq(p14_17,p8_5) ).

cnf(neq3541,axiom,
    neq(p14_17,p8_10) ).

cnf(neq3542,axiom,
    neq(p14_17,p9_15) ).

cnf(neq3543,axiom,
    neq(p14_17,p10_0) ).

cnf(neq3544,axiom,
    neq(p14_17,p11_3) ).

cnf(neq3545,axiom,
    neq(p14_17,p11_5) ).

cnf(neq3546,axiom,
    neq(p14_17,p11_13) ).

cnf(neq3547,axiom,
    neq(p14_17,p13_10) ).

cnf(neq3548,axiom,
    neq(p14_17,p13_14) ).

cnf(neq3549,axiom,
    neq(p14_17,p14_2) ).

cnf(neq3550,axiom,
    neq(p14_17,p14_7) ).

cnf(neq3551,axiom,
    neq(p14_17,p14_16) ).

cnf(neq3552,axiom,
    ~ neq(p14_17,p14_17) ).

cnf(neq3553,axiom,
    neq(p14_17,p15_0) ).

cnf(neq3554,axiom,
    neq(p14_17,p15_1) ).

cnf(neq3555,axiom,
    neq(p14_17,p16_11) ).

cnf(neq3556,axiom,
    neq(p14_17,p16_18) ).

cnf(neq3557,axiom,
    neq(p14_17,p16_19) ).

cnf(neq3558,axiom,
    neq(p14_17,p17_3) ).

cnf(neq3559,axiom,
    neq(p14_17,p17_5) ).

cnf(neq3560,axiom,
    neq(p14_17,p17_8) ).

cnf(neq3561,axiom,
    neq(p14_17,p17_14) ).

cnf(neq3562,axiom,
    neq(p14_17,p18_15) ).

cnf(neq3563,axiom,
    neq(p14_17,p19_8) ).

cnf(neq3564,axiom,
    neq(p14_17,p19_12) ).

cnf(neq3565,axiom,
    neq(p15_0,truck1) ).

cnf(neq3566,axiom,
    neq(p15_0,truck2) ).

cnf(neq3567,axiom,
    neq(p15_0,truck3) ).

cnf(neq3568,axiom,
    neq(p15_0,truck4) ).

cnf(neq3569,axiom,
    neq(p15_0,truck5) ).

cnf(neq3570,axiom,
    neq(p15_0,s0) ).

cnf(neq3571,axiom,
    neq(p15_0,s1) ).

cnf(neq3572,axiom,
    neq(p15_0,s2) ).

cnf(neq3573,axiom,
    neq(p15_0,s3) ).

cnf(neq3574,axiom,
    neq(p15_0,s4) ).

cnf(neq3575,axiom,
    neq(p15_0,s5) ).

cnf(neq3576,axiom,
    neq(p15_0,s6) ).

cnf(neq3577,axiom,
    neq(p15_0,s7) ).

cnf(neq3578,axiom,
    neq(p15_0,s8) ).

cnf(neq3579,axiom,
    neq(p15_0,s9) ).

cnf(neq3580,axiom,
    neq(p15_0,s10) ).

cnf(neq3581,axiom,
    neq(p15_0,s11) ).

cnf(neq3582,axiom,
    neq(p15_0,s12) ).

cnf(neq3583,axiom,
    neq(p15_0,s13) ).

cnf(neq3584,axiom,
    neq(p15_0,s14) ).

cnf(neq3585,axiom,
    neq(p15_0,s15) ).

cnf(neq3586,axiom,
    neq(p15_0,s16) ).

cnf(neq3587,axiom,
    neq(p15_0,s17) ).

cnf(neq3588,axiom,
    neq(p15_0,s18) ).

cnf(neq3589,axiom,
    neq(p15_0,s19) ).

cnf(neq3590,axiom,
    neq(p15_0,p0_8) ).

cnf(neq3591,axiom,
    neq(p15_0,p1_3) ).

cnf(neq3592,axiom,
    neq(p15_0,p1_4) ).

cnf(neq3593,axiom,
    neq(p15_0,p1_9) ).

cnf(neq3594,axiom,
    neq(p15_0,p2_3) ).

cnf(neq3595,axiom,
    neq(p15_0,p3_10) ).

cnf(neq3596,axiom,
    neq(p15_0,p3_19) ).

cnf(neq3597,axiom,
    neq(p15_0,p4_3) ).

cnf(neq3598,axiom,
    neq(p15_0,p4_6) ).

cnf(neq3599,axiom,
    neq(p15_0,p5_0) ).

cnf(neq3600,axiom,
    neq(p15_0,p5_10) ).

cnf(neq3601,axiom,
    neq(p15_0,p6_7) ).

cnf(neq3602,axiom,
    neq(p15_0,p6_10) ).

cnf(neq3603,axiom,
    neq(p15_0,p7_11) ).

cnf(neq3604,axiom,
    neq(p15_0,p8_2) ).

cnf(neq3605,axiom,
    neq(p15_0,p8_3) ).

cnf(neq3606,axiom,
    neq(p15_0,p8_5) ).

cnf(neq3607,axiom,
    neq(p15_0,p8_10) ).

cnf(neq3608,axiom,
    neq(p15_0,p9_15) ).

cnf(neq3609,axiom,
    neq(p15_0,p10_0) ).

cnf(neq3610,axiom,
    neq(p15_0,p11_3) ).

cnf(neq3611,axiom,
    neq(p15_0,p11_5) ).

cnf(neq3612,axiom,
    neq(p15_0,p11_13) ).

cnf(neq3613,axiom,
    neq(p15_0,p13_10) ).

cnf(neq3614,axiom,
    neq(p15_0,p13_14) ).

cnf(neq3615,axiom,
    neq(p15_0,p14_2) ).

cnf(neq3616,axiom,
    neq(p15_0,p14_7) ).

cnf(neq3617,axiom,
    neq(p15_0,p14_16) ).

cnf(neq3618,axiom,
    neq(p15_0,p14_17) ).

cnf(neq3619,axiom,
    ~ neq(p15_0,p15_0) ).

cnf(neq3620,axiom,
    neq(p15_0,p15_1) ).

cnf(neq3621,axiom,
    neq(p15_0,p16_11) ).

cnf(neq3622,axiom,
    neq(p15_0,p16_18) ).

cnf(neq3623,axiom,
    neq(p15_0,p16_19) ).

cnf(neq3624,axiom,
    neq(p15_0,p17_3) ).

cnf(neq3625,axiom,
    neq(p15_0,p17_5) ).

cnf(neq3626,axiom,
    neq(p15_0,p17_8) ).

cnf(neq3627,axiom,
    neq(p15_0,p17_14) ).

cnf(neq3628,axiom,
    neq(p15_0,p18_15) ).

cnf(neq3629,axiom,
    neq(p15_0,p19_8) ).

cnf(neq3630,axiom,
    neq(p15_0,p19_12) ).

cnf(neq3631,axiom,
    neq(p15_1,truck1) ).

cnf(neq3632,axiom,
    neq(p15_1,truck2) ).

cnf(neq3633,axiom,
    neq(p15_1,truck3) ).

cnf(neq3634,axiom,
    neq(p15_1,truck4) ).

cnf(neq3635,axiom,
    neq(p15_1,truck5) ).

cnf(neq3636,axiom,
    neq(p15_1,s0) ).

cnf(neq3637,axiom,
    neq(p15_1,s1) ).

cnf(neq3638,axiom,
    neq(p15_1,s2) ).

cnf(neq3639,axiom,
    neq(p15_1,s3) ).

cnf(neq3640,axiom,
    neq(p15_1,s4) ).

cnf(neq3641,axiom,
    neq(p15_1,s5) ).

cnf(neq3642,axiom,
    neq(p15_1,s6) ).

cnf(neq3643,axiom,
    neq(p15_1,s7) ).

cnf(neq3644,axiom,
    neq(p15_1,s8) ).

cnf(neq3645,axiom,
    neq(p15_1,s9) ).

cnf(neq3646,axiom,
    neq(p15_1,s10) ).

cnf(neq3647,axiom,
    neq(p15_1,s11) ).

cnf(neq3648,axiom,
    neq(p15_1,s12) ).

cnf(neq3649,axiom,
    neq(p15_1,s13) ).

cnf(neq3650,axiom,
    neq(p15_1,s14) ).

cnf(neq3651,axiom,
    neq(p15_1,s15) ).

cnf(neq3652,axiom,
    neq(p15_1,s16) ).

cnf(neq3653,axiom,
    neq(p15_1,s17) ).

cnf(neq3654,axiom,
    neq(p15_1,s18) ).

cnf(neq3655,axiom,
    neq(p15_1,s19) ).

cnf(neq3656,axiom,
    neq(p15_1,p0_8) ).

cnf(neq3657,axiom,
    neq(p15_1,p1_3) ).

cnf(neq3658,axiom,
    neq(p15_1,p1_4) ).

cnf(neq3659,axiom,
    neq(p15_1,p1_9) ).

cnf(neq3660,axiom,
    neq(p15_1,p2_3) ).

cnf(neq3661,axiom,
    neq(p15_1,p3_10) ).

cnf(neq3662,axiom,
    neq(p15_1,p3_19) ).

cnf(neq3663,axiom,
    neq(p15_1,p4_3) ).

cnf(neq3664,axiom,
    neq(p15_1,p4_6) ).

cnf(neq3665,axiom,
    neq(p15_1,p5_0) ).

cnf(neq3666,axiom,
    neq(p15_1,p5_10) ).

cnf(neq3667,axiom,
    neq(p15_1,p6_7) ).

cnf(neq3668,axiom,
    neq(p15_1,p6_10) ).

cnf(neq3669,axiom,
    neq(p15_1,p7_11) ).

cnf(neq3670,axiom,
    neq(p15_1,p8_2) ).

cnf(neq3671,axiom,
    neq(p15_1,p8_3) ).

cnf(neq3672,axiom,
    neq(p15_1,p8_5) ).

cnf(neq3673,axiom,
    neq(p15_1,p8_10) ).

cnf(neq3674,axiom,
    neq(p15_1,p9_15) ).

cnf(neq3675,axiom,
    neq(p15_1,p10_0) ).

cnf(neq3676,axiom,
    neq(p15_1,p11_3) ).

cnf(neq3677,axiom,
    neq(p15_1,p11_5) ).

cnf(neq3678,axiom,
    neq(p15_1,p11_13) ).

cnf(neq3679,axiom,
    neq(p15_1,p13_10) ).

cnf(neq3680,axiom,
    neq(p15_1,p13_14) ).

cnf(neq3681,axiom,
    neq(p15_1,p14_2) ).

cnf(neq3682,axiom,
    neq(p15_1,p14_7) ).

cnf(neq3683,axiom,
    neq(p15_1,p14_16) ).

cnf(neq3684,axiom,
    neq(p15_1,p14_17) ).

cnf(neq3685,axiom,
    neq(p15_1,p15_0) ).

cnf(neq3686,axiom,
    ~ neq(p15_1,p15_1) ).

cnf(neq3687,axiom,
    neq(p15_1,p16_11) ).

cnf(neq3688,axiom,
    neq(p15_1,p16_18) ).

cnf(neq3689,axiom,
    neq(p15_1,p16_19) ).

cnf(neq3690,axiom,
    neq(p15_1,p17_3) ).

cnf(neq3691,axiom,
    neq(p15_1,p17_5) ).

cnf(neq3692,axiom,
    neq(p15_1,p17_8) ).

cnf(neq3693,axiom,
    neq(p15_1,p17_14) ).

cnf(neq3694,axiom,
    neq(p15_1,p18_15) ).

cnf(neq3695,axiom,
    neq(p15_1,p19_8) ).

cnf(neq3696,axiom,
    neq(p15_1,p19_12) ).

cnf(neq3697,axiom,
    neq(p16_11,truck1) ).

cnf(neq3698,axiom,
    neq(p16_11,truck2) ).

cnf(neq3699,axiom,
    neq(p16_11,truck3) ).

cnf(neq3700,axiom,
    neq(p16_11,truck4) ).

cnf(neq3701,axiom,
    neq(p16_11,truck5) ).

cnf(neq3702,axiom,
    neq(p16_11,s0) ).

cnf(neq3703,axiom,
    neq(p16_11,s1) ).

cnf(neq3704,axiom,
    neq(p16_11,s2) ).

cnf(neq3705,axiom,
    neq(p16_11,s3) ).

cnf(neq3706,axiom,
    neq(p16_11,s4) ).

cnf(neq3707,axiom,
    neq(p16_11,s5) ).

cnf(neq3708,axiom,
    neq(p16_11,s6) ).

cnf(neq3709,axiom,
    neq(p16_11,s7) ).

cnf(neq3710,axiom,
    neq(p16_11,s8) ).

cnf(neq3711,axiom,
    neq(p16_11,s9) ).

cnf(neq3712,axiom,
    neq(p16_11,s10) ).

cnf(neq3713,axiom,
    neq(p16_11,s11) ).

cnf(neq3714,axiom,
    neq(p16_11,s12) ).

cnf(neq3715,axiom,
    neq(p16_11,s13) ).

cnf(neq3716,axiom,
    neq(p16_11,s14) ).

cnf(neq3717,axiom,
    neq(p16_11,s15) ).

cnf(neq3718,axiom,
    neq(p16_11,s16) ).

cnf(neq3719,axiom,
    neq(p16_11,s17) ).

cnf(neq3720,axiom,
    neq(p16_11,s18) ).

cnf(neq3721,axiom,
    neq(p16_11,s19) ).

cnf(neq3722,axiom,
    neq(p16_11,p0_8) ).

cnf(neq3723,axiom,
    neq(p16_11,p1_3) ).

cnf(neq3724,axiom,
    neq(p16_11,p1_4) ).

cnf(neq3725,axiom,
    neq(p16_11,p1_9) ).

cnf(neq3726,axiom,
    neq(p16_11,p2_3) ).

cnf(neq3727,axiom,
    neq(p16_11,p3_10) ).

cnf(neq3728,axiom,
    neq(p16_11,p3_19) ).

cnf(neq3729,axiom,
    neq(p16_11,p4_3) ).

cnf(neq3730,axiom,
    neq(p16_11,p4_6) ).

cnf(neq3731,axiom,
    neq(p16_11,p5_0) ).

cnf(neq3732,axiom,
    neq(p16_11,p5_10) ).

cnf(neq3733,axiom,
    neq(p16_11,p6_7) ).

cnf(neq3734,axiom,
    neq(p16_11,p6_10) ).

cnf(neq3735,axiom,
    neq(p16_11,p7_11) ).

cnf(neq3736,axiom,
    neq(p16_11,p8_2) ).

cnf(neq3737,axiom,
    neq(p16_11,p8_3) ).

cnf(neq3738,axiom,
    neq(p16_11,p8_5) ).

cnf(neq3739,axiom,
    neq(p16_11,p8_10) ).

cnf(neq3740,axiom,
    neq(p16_11,p9_15) ).

cnf(neq3741,axiom,
    neq(p16_11,p10_0) ).

cnf(neq3742,axiom,
    neq(p16_11,p11_3) ).

cnf(neq3743,axiom,
    neq(p16_11,p11_5) ).

cnf(neq3744,axiom,
    neq(p16_11,p11_13) ).

cnf(neq3745,axiom,
    neq(p16_11,p13_10) ).

cnf(neq3746,axiom,
    neq(p16_11,p13_14) ).

cnf(neq3747,axiom,
    neq(p16_11,p14_2) ).

cnf(neq3748,axiom,
    neq(p16_11,p14_7) ).

cnf(neq3749,axiom,
    neq(p16_11,p14_16) ).

cnf(neq3750,axiom,
    neq(p16_11,p14_17) ).

cnf(neq3751,axiom,
    neq(p16_11,p15_0) ).

cnf(neq3752,axiom,
    neq(p16_11,p15_1) ).

cnf(neq3753,axiom,
    ~ neq(p16_11,p16_11) ).

cnf(neq3754,axiom,
    neq(p16_11,p16_18) ).

cnf(neq3755,axiom,
    neq(p16_11,p16_19) ).

cnf(neq3756,axiom,
    neq(p16_11,p17_3) ).

cnf(neq3757,axiom,
    neq(p16_11,p17_5) ).

cnf(neq3758,axiom,
    neq(p16_11,p17_8) ).

cnf(neq3759,axiom,
    neq(p16_11,p17_14) ).

cnf(neq3760,axiom,
    neq(p16_11,p18_15) ).

cnf(neq3761,axiom,
    neq(p16_11,p19_8) ).

cnf(neq3762,axiom,
    neq(p16_11,p19_12) ).

cnf(neq3763,axiom,
    neq(p16_18,truck1) ).

cnf(neq3764,axiom,
    neq(p16_18,truck2) ).

cnf(neq3765,axiom,
    neq(p16_18,truck3) ).

cnf(neq3766,axiom,
    neq(p16_18,truck4) ).

cnf(neq3767,axiom,
    neq(p16_18,truck5) ).

cnf(neq3768,axiom,
    neq(p16_18,s0) ).

cnf(neq3769,axiom,
    neq(p16_18,s1) ).

cnf(neq3770,axiom,
    neq(p16_18,s2) ).

cnf(neq3771,axiom,
    neq(p16_18,s3) ).

cnf(neq3772,axiom,
    neq(p16_18,s4) ).

cnf(neq3773,axiom,
    neq(p16_18,s5) ).

cnf(neq3774,axiom,
    neq(p16_18,s6) ).

cnf(neq3775,axiom,
    neq(p16_18,s7) ).

cnf(neq3776,axiom,
    neq(p16_18,s8) ).

cnf(neq3777,axiom,
    neq(p16_18,s9) ).

cnf(neq3778,axiom,
    neq(p16_18,s10) ).

cnf(neq3779,axiom,
    neq(p16_18,s11) ).

cnf(neq3780,axiom,
    neq(p16_18,s12) ).

cnf(neq3781,axiom,
    neq(p16_18,s13) ).

cnf(neq3782,axiom,
    neq(p16_18,s14) ).

cnf(neq3783,axiom,
    neq(p16_18,s15) ).

cnf(neq3784,axiom,
    neq(p16_18,s16) ).

cnf(neq3785,axiom,
    neq(p16_18,s17) ).

cnf(neq3786,axiom,
    neq(p16_18,s18) ).

cnf(neq3787,axiom,
    neq(p16_18,s19) ).

cnf(neq3788,axiom,
    neq(p16_18,p0_8) ).

cnf(neq3789,axiom,
    neq(p16_18,p1_3) ).

cnf(neq3790,axiom,
    neq(p16_18,p1_4) ).

cnf(neq3791,axiom,
    neq(p16_18,p1_9) ).

cnf(neq3792,axiom,
    neq(p16_18,p2_3) ).

cnf(neq3793,axiom,
    neq(p16_18,p3_10) ).

cnf(neq3794,axiom,
    neq(p16_18,p3_19) ).

cnf(neq3795,axiom,
    neq(p16_18,p4_3) ).

cnf(neq3796,axiom,
    neq(p16_18,p4_6) ).

cnf(neq3797,axiom,
    neq(p16_18,p5_0) ).

cnf(neq3798,axiom,
    neq(p16_18,p5_10) ).

cnf(neq3799,axiom,
    neq(p16_18,p6_7) ).

cnf(neq3800,axiom,
    neq(p16_18,p6_10) ).

cnf(neq3801,axiom,
    neq(p16_18,p7_11) ).

cnf(neq3802,axiom,
    neq(p16_18,p8_2) ).

cnf(neq3803,axiom,
    neq(p16_18,p8_3) ).

cnf(neq3804,axiom,
    neq(p16_18,p8_5) ).

cnf(neq3805,axiom,
    neq(p16_18,p8_10) ).

cnf(neq3806,axiom,
    neq(p16_18,p9_15) ).

cnf(neq3807,axiom,
    neq(p16_18,p10_0) ).

cnf(neq3808,axiom,
    neq(p16_18,p11_3) ).

cnf(neq3809,axiom,
    neq(p16_18,p11_5) ).

cnf(neq3810,axiom,
    neq(p16_18,p11_13) ).

cnf(neq3811,axiom,
    neq(p16_18,p13_10) ).

cnf(neq3812,axiom,
    neq(p16_18,p13_14) ).

cnf(neq3813,axiom,
    neq(p16_18,p14_2) ).

cnf(neq3814,axiom,
    neq(p16_18,p14_7) ).

cnf(neq3815,axiom,
    neq(p16_18,p14_16) ).

cnf(neq3816,axiom,
    neq(p16_18,p14_17) ).

cnf(neq3817,axiom,
    neq(p16_18,p15_0) ).

cnf(neq3818,axiom,
    neq(p16_18,p15_1) ).

cnf(neq3819,axiom,
    neq(p16_18,p16_11) ).

cnf(neq3820,axiom,
    ~ neq(p16_18,p16_18) ).

cnf(neq3821,axiom,
    neq(p16_18,p16_19) ).

cnf(neq3822,axiom,
    neq(p16_18,p17_3) ).

cnf(neq3823,axiom,
    neq(p16_18,p17_5) ).

cnf(neq3824,axiom,
    neq(p16_18,p17_8) ).

cnf(neq3825,axiom,
    neq(p16_18,p17_14) ).

cnf(neq3826,axiom,
    neq(p16_18,p18_15) ).

cnf(neq3827,axiom,
    neq(p16_18,p19_8) ).

cnf(neq3828,axiom,
    neq(p16_18,p19_12) ).

cnf(neq3829,axiom,
    neq(p16_19,truck1) ).

cnf(neq3830,axiom,
    neq(p16_19,truck2) ).

cnf(neq3831,axiom,
    neq(p16_19,truck3) ).

cnf(neq3832,axiom,
    neq(p16_19,truck4) ).

cnf(neq3833,axiom,
    neq(p16_19,truck5) ).

cnf(neq3834,axiom,
    neq(p16_19,s0) ).

cnf(neq3835,axiom,
    neq(p16_19,s1) ).

cnf(neq3836,axiom,
    neq(p16_19,s2) ).

cnf(neq3837,axiom,
    neq(p16_19,s3) ).

cnf(neq3838,axiom,
    neq(p16_19,s4) ).

cnf(neq3839,axiom,
    neq(p16_19,s5) ).

cnf(neq3840,axiom,
    neq(p16_19,s6) ).

cnf(neq3841,axiom,
    neq(p16_19,s7) ).

cnf(neq3842,axiom,
    neq(p16_19,s8) ).

cnf(neq3843,axiom,
    neq(p16_19,s9) ).

cnf(neq3844,axiom,
    neq(p16_19,s10) ).

cnf(neq3845,axiom,
    neq(p16_19,s11) ).

cnf(neq3846,axiom,
    neq(p16_19,s12) ).

cnf(neq3847,axiom,
    neq(p16_19,s13) ).

cnf(neq3848,axiom,
    neq(p16_19,s14) ).

cnf(neq3849,axiom,
    neq(p16_19,s15) ).

cnf(neq3850,axiom,
    neq(p16_19,s16) ).

cnf(neq3851,axiom,
    neq(p16_19,s17) ).

cnf(neq3852,axiom,
    neq(p16_19,s18) ).

cnf(neq3853,axiom,
    neq(p16_19,s19) ).

cnf(neq3854,axiom,
    neq(p16_19,p0_8) ).

cnf(neq3855,axiom,
    neq(p16_19,p1_3) ).

cnf(neq3856,axiom,
    neq(p16_19,p1_4) ).

cnf(neq3857,axiom,
    neq(p16_19,p1_9) ).

cnf(neq3858,axiom,
    neq(p16_19,p2_3) ).

cnf(neq3859,axiom,
    neq(p16_19,p3_10) ).

cnf(neq3860,axiom,
    neq(p16_19,p3_19) ).

cnf(neq3861,axiom,
    neq(p16_19,p4_3) ).

cnf(neq3862,axiom,
    neq(p16_19,p4_6) ).

cnf(neq3863,axiom,
    neq(p16_19,p5_0) ).

cnf(neq3864,axiom,
    neq(p16_19,p5_10) ).

cnf(neq3865,axiom,
    neq(p16_19,p6_7) ).

cnf(neq3866,axiom,
    neq(p16_19,p6_10) ).

cnf(neq3867,axiom,
    neq(p16_19,p7_11) ).

cnf(neq3868,axiom,
    neq(p16_19,p8_2) ).

cnf(neq3869,axiom,
    neq(p16_19,p8_3) ).

cnf(neq3870,axiom,
    neq(p16_19,p8_5) ).

cnf(neq3871,axiom,
    neq(p16_19,p8_10) ).

cnf(neq3872,axiom,
    neq(p16_19,p9_15) ).

cnf(neq3873,axiom,
    neq(p16_19,p10_0) ).

cnf(neq3874,axiom,
    neq(p16_19,p11_3) ).

cnf(neq3875,axiom,
    neq(p16_19,p11_5) ).

cnf(neq3876,axiom,
    neq(p16_19,p11_13) ).

cnf(neq3877,axiom,
    neq(p16_19,p13_10) ).

cnf(neq3878,axiom,
    neq(p16_19,p13_14) ).

cnf(neq3879,axiom,
    neq(p16_19,p14_2) ).

cnf(neq3880,axiom,
    neq(p16_19,p14_7) ).

cnf(neq3881,axiom,
    neq(p16_19,p14_16) ).

cnf(neq3882,axiom,
    neq(p16_19,p14_17) ).

cnf(neq3883,axiom,
    neq(p16_19,p15_0) ).

cnf(neq3884,axiom,
    neq(p16_19,p15_1) ).

cnf(neq3885,axiom,
    neq(p16_19,p16_11) ).

cnf(neq3886,axiom,
    neq(p16_19,p16_18) ).

cnf(neq3887,axiom,
    ~ neq(p16_19,p16_19) ).

cnf(neq3888,axiom,
    neq(p16_19,p17_3) ).

cnf(neq3889,axiom,
    neq(p16_19,p17_5) ).

cnf(neq3890,axiom,
    neq(p16_19,p17_8) ).

cnf(neq3891,axiom,
    neq(p16_19,p17_14) ).

cnf(neq3892,axiom,
    neq(p16_19,p18_15) ).

cnf(neq3893,axiom,
    neq(p16_19,p19_8) ).

cnf(neq3894,axiom,
    neq(p16_19,p19_12) ).

cnf(neq3895,axiom,
    neq(p17_3,truck1) ).

cnf(neq3896,axiom,
    neq(p17_3,truck2) ).

cnf(neq3897,axiom,
    neq(p17_3,truck3) ).

cnf(neq3898,axiom,
    neq(p17_3,truck4) ).

cnf(neq3899,axiom,
    neq(p17_3,truck5) ).

cnf(neq3900,axiom,
    neq(p17_3,s0) ).

cnf(neq3901,axiom,
    neq(p17_3,s1) ).

cnf(neq3902,axiom,
    neq(p17_3,s2) ).

cnf(neq3903,axiom,
    neq(p17_3,s3) ).

cnf(neq3904,axiom,
    neq(p17_3,s4) ).

cnf(neq3905,axiom,
    neq(p17_3,s5) ).

cnf(neq3906,axiom,
    neq(p17_3,s6) ).

cnf(neq3907,axiom,
    neq(p17_3,s7) ).

cnf(neq3908,axiom,
    neq(p17_3,s8) ).

cnf(neq3909,axiom,
    neq(p17_3,s9) ).

cnf(neq3910,axiom,
    neq(p17_3,s10) ).

cnf(neq3911,axiom,
    neq(p17_3,s11) ).

cnf(neq3912,axiom,
    neq(p17_3,s12) ).

cnf(neq3913,axiom,
    neq(p17_3,s13) ).

cnf(neq3914,axiom,
    neq(p17_3,s14) ).

cnf(neq3915,axiom,
    neq(p17_3,s15) ).

cnf(neq3916,axiom,
    neq(p17_3,s16) ).

cnf(neq3917,axiom,
    neq(p17_3,s17) ).

cnf(neq3918,axiom,
    neq(p17_3,s18) ).

cnf(neq3919,axiom,
    neq(p17_3,s19) ).

cnf(neq3920,axiom,
    neq(p17_3,p0_8) ).

cnf(neq3921,axiom,
    neq(p17_3,p1_3) ).

cnf(neq3922,axiom,
    neq(p17_3,p1_4) ).

cnf(neq3923,axiom,
    neq(p17_3,p1_9) ).

cnf(neq3924,axiom,
    neq(p17_3,p2_3) ).

cnf(neq3925,axiom,
    neq(p17_3,p3_10) ).

cnf(neq3926,axiom,
    neq(p17_3,p3_19) ).

cnf(neq3927,axiom,
    neq(p17_3,p4_3) ).

cnf(neq3928,axiom,
    neq(p17_3,p4_6) ).

cnf(neq3929,axiom,
    neq(p17_3,p5_0) ).

cnf(neq3930,axiom,
    neq(p17_3,p5_10) ).

cnf(neq3931,axiom,
    neq(p17_3,p6_7) ).

cnf(neq3932,axiom,
    neq(p17_3,p6_10) ).

cnf(neq3933,axiom,
    neq(p17_3,p7_11) ).

cnf(neq3934,axiom,
    neq(p17_3,p8_2) ).

cnf(neq3935,axiom,
    neq(p17_3,p8_3) ).

cnf(neq3936,axiom,
    neq(p17_3,p8_5) ).

cnf(neq3937,axiom,
    neq(p17_3,p8_10) ).

cnf(neq3938,axiom,
    neq(p17_3,p9_15) ).

cnf(neq3939,axiom,
    neq(p17_3,p10_0) ).

cnf(neq3940,axiom,
    neq(p17_3,p11_3) ).

cnf(neq3941,axiom,
    neq(p17_3,p11_5) ).

cnf(neq3942,axiom,
    neq(p17_3,p11_13) ).

cnf(neq3943,axiom,
    neq(p17_3,p13_10) ).

cnf(neq3944,axiom,
    neq(p17_3,p13_14) ).

cnf(neq3945,axiom,
    neq(p17_3,p14_2) ).

cnf(neq3946,axiom,
    neq(p17_3,p14_7) ).

cnf(neq3947,axiom,
    neq(p17_3,p14_16) ).

cnf(neq3948,axiom,
    neq(p17_3,p14_17) ).

cnf(neq3949,axiom,
    neq(p17_3,p15_0) ).

cnf(neq3950,axiom,
    neq(p17_3,p15_1) ).

cnf(neq3951,axiom,
    neq(p17_3,p16_11) ).

cnf(neq3952,axiom,
    neq(p17_3,p16_18) ).

cnf(neq3953,axiom,
    neq(p17_3,p16_19) ).

cnf(neq3954,axiom,
    ~ neq(p17_3,p17_3) ).

cnf(neq3955,axiom,
    neq(p17_3,p17_5) ).

cnf(neq3956,axiom,
    neq(p17_3,p17_8) ).

cnf(neq3957,axiom,
    neq(p17_3,p17_14) ).

cnf(neq3958,axiom,
    neq(p17_3,p18_15) ).

cnf(neq3959,axiom,
    neq(p17_3,p19_8) ).

cnf(neq3960,axiom,
    neq(p17_3,p19_12) ).

cnf(neq3961,axiom,
    neq(p17_5,truck1) ).

cnf(neq3962,axiom,
    neq(p17_5,truck2) ).

cnf(neq3963,axiom,
    neq(p17_5,truck3) ).

cnf(neq3964,axiom,
    neq(p17_5,truck4) ).

cnf(neq3965,axiom,
    neq(p17_5,truck5) ).

cnf(neq3966,axiom,
    neq(p17_5,s0) ).

cnf(neq3967,axiom,
    neq(p17_5,s1) ).

cnf(neq3968,axiom,
    neq(p17_5,s2) ).

cnf(neq3969,axiom,
    neq(p17_5,s3) ).

cnf(neq3970,axiom,
    neq(p17_5,s4) ).

cnf(neq3971,axiom,
    neq(p17_5,s5) ).

cnf(neq3972,axiom,
    neq(p17_5,s6) ).

cnf(neq3973,axiom,
    neq(p17_5,s7) ).

cnf(neq3974,axiom,
    neq(p17_5,s8) ).

cnf(neq3975,axiom,
    neq(p17_5,s9) ).

cnf(neq3976,axiom,
    neq(p17_5,s10) ).

cnf(neq3977,axiom,
    neq(p17_5,s11) ).

cnf(neq3978,axiom,
    neq(p17_5,s12) ).

cnf(neq3979,axiom,
    neq(p17_5,s13) ).

cnf(neq3980,axiom,
    neq(p17_5,s14) ).

cnf(neq3981,axiom,
    neq(p17_5,s15) ).

cnf(neq3982,axiom,
    neq(p17_5,s16) ).

cnf(neq3983,axiom,
    neq(p17_5,s17) ).

cnf(neq3984,axiom,
    neq(p17_5,s18) ).

cnf(neq3985,axiom,
    neq(p17_5,s19) ).

cnf(neq3986,axiom,
    neq(p17_5,p0_8) ).

cnf(neq3987,axiom,
    neq(p17_5,p1_3) ).

cnf(neq3988,axiom,
    neq(p17_5,p1_4) ).

cnf(neq3989,axiom,
    neq(p17_5,p1_9) ).

cnf(neq3990,axiom,
    neq(p17_5,p2_3) ).

cnf(neq3991,axiom,
    neq(p17_5,p3_10) ).

cnf(neq3992,axiom,
    neq(p17_5,p3_19) ).

cnf(neq3993,axiom,
    neq(p17_5,p4_3) ).

cnf(neq3994,axiom,
    neq(p17_5,p4_6) ).

cnf(neq3995,axiom,
    neq(p17_5,p5_0) ).

cnf(neq3996,axiom,
    neq(p17_5,p5_10) ).

cnf(neq3997,axiom,
    neq(p17_5,p6_7) ).

cnf(neq3998,axiom,
    neq(p17_5,p6_10) ).

cnf(neq3999,axiom,
    neq(p17_5,p7_11) ).

cnf(neq4000,axiom,
    neq(p17_5,p8_2) ).

cnf(neq4001,axiom,
    neq(p17_5,p8_3) ).

cnf(neq4002,axiom,
    neq(p17_5,p8_5) ).

cnf(neq4003,axiom,
    neq(p17_5,p8_10) ).

cnf(neq4004,axiom,
    neq(p17_5,p9_15) ).

cnf(neq4005,axiom,
    neq(p17_5,p10_0) ).

cnf(neq4006,axiom,
    neq(p17_5,p11_3) ).

cnf(neq4007,axiom,
    neq(p17_5,p11_5) ).

cnf(neq4008,axiom,
    neq(p17_5,p11_13) ).

cnf(neq4009,axiom,
    neq(p17_5,p13_10) ).

cnf(neq4010,axiom,
    neq(p17_5,p13_14) ).

cnf(neq4011,axiom,
    neq(p17_5,p14_2) ).

cnf(neq4012,axiom,
    neq(p17_5,p14_7) ).

cnf(neq4013,axiom,
    neq(p17_5,p14_16) ).

cnf(neq4014,axiom,
    neq(p17_5,p14_17) ).

cnf(neq4015,axiom,
    neq(p17_5,p15_0) ).

cnf(neq4016,axiom,
    neq(p17_5,p15_1) ).

cnf(neq4017,axiom,
    neq(p17_5,p16_11) ).

cnf(neq4018,axiom,
    neq(p17_5,p16_18) ).

cnf(neq4019,axiom,
    neq(p17_5,p16_19) ).

cnf(neq4020,axiom,
    neq(p17_5,p17_3) ).

cnf(neq4021,axiom,
    ~ neq(p17_5,p17_5) ).

cnf(neq4022,axiom,
    neq(p17_5,p17_8) ).

cnf(neq4023,axiom,
    neq(p17_5,p17_14) ).

cnf(neq4024,axiom,
    neq(p17_5,p18_15) ).

cnf(neq4025,axiom,
    neq(p17_5,p19_8) ).

cnf(neq4026,axiom,
    neq(p17_5,p19_12) ).

cnf(neq4027,axiom,
    neq(p17_8,truck1) ).

cnf(neq4028,axiom,
    neq(p17_8,truck2) ).

cnf(neq4029,axiom,
    neq(p17_8,truck3) ).

cnf(neq4030,axiom,
    neq(p17_8,truck4) ).

cnf(neq4031,axiom,
    neq(p17_8,truck5) ).

cnf(neq4032,axiom,
    neq(p17_8,s0) ).

cnf(neq4033,axiom,
    neq(p17_8,s1) ).

cnf(neq4034,axiom,
    neq(p17_8,s2) ).

cnf(neq4035,axiom,
    neq(p17_8,s3) ).

cnf(neq4036,axiom,
    neq(p17_8,s4) ).

cnf(neq4037,axiom,
    neq(p17_8,s5) ).

cnf(neq4038,axiom,
    neq(p17_8,s6) ).

cnf(neq4039,axiom,
    neq(p17_8,s7) ).

cnf(neq4040,axiom,
    neq(p17_8,s8) ).

cnf(neq4041,axiom,
    neq(p17_8,s9) ).

cnf(neq4042,axiom,
    neq(p17_8,s10) ).

cnf(neq4043,axiom,
    neq(p17_8,s11) ).

cnf(neq4044,axiom,
    neq(p17_8,s12) ).

cnf(neq4045,axiom,
    neq(p17_8,s13) ).

cnf(neq4046,axiom,
    neq(p17_8,s14) ).

cnf(neq4047,axiom,
    neq(p17_8,s15) ).

cnf(neq4048,axiom,
    neq(p17_8,s16) ).

cnf(neq4049,axiom,
    neq(p17_8,s17) ).

cnf(neq4050,axiom,
    neq(p17_8,s18) ).

cnf(neq4051,axiom,
    neq(p17_8,s19) ).

cnf(neq4052,axiom,
    neq(p17_8,p0_8) ).

cnf(neq4053,axiom,
    neq(p17_8,p1_3) ).

cnf(neq4054,axiom,
    neq(p17_8,p1_4) ).

cnf(neq4055,axiom,
    neq(p17_8,p1_9) ).

cnf(neq4056,axiom,
    neq(p17_8,p2_3) ).

cnf(neq4057,axiom,
    neq(p17_8,p3_10) ).

cnf(neq4058,axiom,
    neq(p17_8,p3_19) ).

cnf(neq4059,axiom,
    neq(p17_8,p4_3) ).

cnf(neq4060,axiom,
    neq(p17_8,p4_6) ).

cnf(neq4061,axiom,
    neq(p17_8,p5_0) ).

cnf(neq4062,axiom,
    neq(p17_8,p5_10) ).

cnf(neq4063,axiom,
    neq(p17_8,p6_7) ).

cnf(neq4064,axiom,
    neq(p17_8,p6_10) ).

cnf(neq4065,axiom,
    neq(p17_8,p7_11) ).

cnf(neq4066,axiom,
    neq(p17_8,p8_2) ).

cnf(neq4067,axiom,
    neq(p17_8,p8_3) ).

cnf(neq4068,axiom,
    neq(p17_8,p8_5) ).

cnf(neq4069,axiom,
    neq(p17_8,p8_10) ).

cnf(neq4070,axiom,
    neq(p17_8,p9_15) ).

cnf(neq4071,axiom,
    neq(p17_8,p10_0) ).

cnf(neq4072,axiom,
    neq(p17_8,p11_3) ).

cnf(neq4073,axiom,
    neq(p17_8,p11_5) ).

cnf(neq4074,axiom,
    neq(p17_8,p11_13) ).

cnf(neq4075,axiom,
    neq(p17_8,p13_10) ).

cnf(neq4076,axiom,
    neq(p17_8,p13_14) ).

cnf(neq4077,axiom,
    neq(p17_8,p14_2) ).

cnf(neq4078,axiom,
    neq(p17_8,p14_7) ).

cnf(neq4079,axiom,
    neq(p17_8,p14_16) ).

cnf(neq4080,axiom,
    neq(p17_8,p14_17) ).

cnf(neq4081,axiom,
    neq(p17_8,p15_0) ).

cnf(neq4082,axiom,
    neq(p17_8,p15_1) ).

cnf(neq4083,axiom,
    neq(p17_8,p16_11) ).

cnf(neq4084,axiom,
    neq(p17_8,p16_18) ).

cnf(neq4085,axiom,
    neq(p17_8,p16_19) ).

cnf(neq4086,axiom,
    neq(p17_8,p17_3) ).

cnf(neq4087,axiom,
    neq(p17_8,p17_5) ).

cnf(neq4088,axiom,
    ~ neq(p17_8,p17_8) ).

cnf(neq4089,axiom,
    neq(p17_8,p17_14) ).

cnf(neq4090,axiom,
    neq(p17_8,p18_15) ).

cnf(neq4091,axiom,
    neq(p17_8,p19_8) ).

cnf(neq4092,axiom,
    neq(p17_8,p19_12) ).

cnf(neq4093,axiom,
    neq(p17_14,truck1) ).

cnf(neq4094,axiom,
    neq(p17_14,truck2) ).

cnf(neq4095,axiom,
    neq(p17_14,truck3) ).

cnf(neq4096,axiom,
    neq(p17_14,truck4) ).

cnf(neq4097,axiom,
    neq(p17_14,truck5) ).

cnf(neq4098,axiom,
    neq(p17_14,s0) ).

cnf(neq4099,axiom,
    neq(p17_14,s1) ).

cnf(neq4100,axiom,
    neq(p17_14,s2) ).

cnf(neq4101,axiom,
    neq(p17_14,s3) ).

cnf(neq4102,axiom,
    neq(p17_14,s4) ).

cnf(neq4103,axiom,
    neq(p17_14,s5) ).

cnf(neq4104,axiom,
    neq(p17_14,s6) ).

cnf(neq4105,axiom,
    neq(p17_14,s7) ).

cnf(neq4106,axiom,
    neq(p17_14,s8) ).

cnf(neq4107,axiom,
    neq(p17_14,s9) ).

cnf(neq4108,axiom,
    neq(p17_14,s10) ).

cnf(neq4109,axiom,
    neq(p17_14,s11) ).

cnf(neq4110,axiom,
    neq(p17_14,s12) ).

cnf(neq4111,axiom,
    neq(p17_14,s13) ).

cnf(neq4112,axiom,
    neq(p17_14,s14) ).

cnf(neq4113,axiom,
    neq(p17_14,s15) ).

cnf(neq4114,axiom,
    neq(p17_14,s16) ).

cnf(neq4115,axiom,
    neq(p17_14,s17) ).

cnf(neq4116,axiom,
    neq(p17_14,s18) ).

cnf(neq4117,axiom,
    neq(p17_14,s19) ).

cnf(neq4118,axiom,
    neq(p17_14,p0_8) ).

cnf(neq4119,axiom,
    neq(p17_14,p1_3) ).

cnf(neq4120,axiom,
    neq(p17_14,p1_4) ).

cnf(neq4121,axiom,
    neq(p17_14,p1_9) ).

cnf(neq4122,axiom,
    neq(p17_14,p2_3) ).

cnf(neq4123,axiom,
    neq(p17_14,p3_10) ).

cnf(neq4124,axiom,
    neq(p17_14,p3_19) ).

cnf(neq4125,axiom,
    neq(p17_14,p4_3) ).

cnf(neq4126,axiom,
    neq(p17_14,p4_6) ).

cnf(neq4127,axiom,
    neq(p17_14,p5_0) ).

cnf(neq4128,axiom,
    neq(p17_14,p5_10) ).

cnf(neq4129,axiom,
    neq(p17_14,p6_7) ).

cnf(neq4130,axiom,
    neq(p17_14,p6_10) ).

cnf(neq4131,axiom,
    neq(p17_14,p7_11) ).

cnf(neq4132,axiom,
    neq(p17_14,p8_2) ).

cnf(neq4133,axiom,
    neq(p17_14,p8_3) ).

cnf(neq4134,axiom,
    neq(p17_14,p8_5) ).

cnf(neq4135,axiom,
    neq(p17_14,p8_10) ).

cnf(neq4136,axiom,
    neq(p17_14,p9_15) ).

cnf(neq4137,axiom,
    neq(p17_14,p10_0) ).

cnf(neq4138,axiom,
    neq(p17_14,p11_3) ).

cnf(neq4139,axiom,
    neq(p17_14,p11_5) ).

cnf(neq4140,axiom,
    neq(p17_14,p11_13) ).

cnf(neq4141,axiom,
    neq(p17_14,p13_10) ).

cnf(neq4142,axiom,
    neq(p17_14,p13_14) ).

cnf(neq4143,axiom,
    neq(p17_14,p14_2) ).

cnf(neq4144,axiom,
    neq(p17_14,p14_7) ).

cnf(neq4145,axiom,
    neq(p17_14,p14_16) ).

cnf(neq4146,axiom,
    neq(p17_14,p14_17) ).

cnf(neq4147,axiom,
    neq(p17_14,p15_0) ).

cnf(neq4148,axiom,
    neq(p17_14,p15_1) ).

cnf(neq4149,axiom,
    neq(p17_14,p16_11) ).

cnf(neq4150,axiom,
    neq(p17_14,p16_18) ).

cnf(neq4151,axiom,
    neq(p17_14,p16_19) ).

cnf(neq4152,axiom,
    neq(p17_14,p17_3) ).

cnf(neq4153,axiom,
    neq(p17_14,p17_5) ).

cnf(neq4154,axiom,
    neq(p17_14,p17_8) ).

cnf(neq4155,axiom,
    ~ neq(p17_14,p17_14) ).

cnf(neq4156,axiom,
    neq(p17_14,p18_15) ).

cnf(neq4157,axiom,
    neq(p17_14,p19_8) ).

cnf(neq4158,axiom,
    neq(p17_14,p19_12) ).

cnf(neq4159,axiom,
    neq(p18_15,truck1) ).

cnf(neq4160,axiom,
    neq(p18_15,truck2) ).

cnf(neq4161,axiom,
    neq(p18_15,truck3) ).

cnf(neq4162,axiom,
    neq(p18_15,truck4) ).

cnf(neq4163,axiom,
    neq(p18_15,truck5) ).

cnf(neq4164,axiom,
    neq(p18_15,s0) ).

cnf(neq4165,axiom,
    neq(p18_15,s1) ).

cnf(neq4166,axiom,
    neq(p18_15,s2) ).

cnf(neq4167,axiom,
    neq(p18_15,s3) ).

cnf(neq4168,axiom,
    neq(p18_15,s4) ).

cnf(neq4169,axiom,
    neq(p18_15,s5) ).

cnf(neq4170,axiom,
    neq(p18_15,s6) ).

cnf(neq4171,axiom,
    neq(p18_15,s7) ).

cnf(neq4172,axiom,
    neq(p18_15,s8) ).

cnf(neq4173,axiom,
    neq(p18_15,s9) ).

cnf(neq4174,axiom,
    neq(p18_15,s10) ).

cnf(neq4175,axiom,
    neq(p18_15,s11) ).

cnf(neq4176,axiom,
    neq(p18_15,s12) ).

cnf(neq4177,axiom,
    neq(p18_15,s13) ).

cnf(neq4178,axiom,
    neq(p18_15,s14) ).

cnf(neq4179,axiom,
    neq(p18_15,s15) ).

cnf(neq4180,axiom,
    neq(p18_15,s16) ).

cnf(neq4181,axiom,
    neq(p18_15,s17) ).

cnf(neq4182,axiom,
    neq(p18_15,s18) ).

cnf(neq4183,axiom,
    neq(p18_15,s19) ).

cnf(neq4184,axiom,
    neq(p18_15,p0_8) ).

cnf(neq4185,axiom,
    neq(p18_15,p1_3) ).

cnf(neq4186,axiom,
    neq(p18_15,p1_4) ).

cnf(neq4187,axiom,
    neq(p18_15,p1_9) ).

cnf(neq4188,axiom,
    neq(p18_15,p2_3) ).

cnf(neq4189,axiom,
    neq(p18_15,p3_10) ).

cnf(neq4190,axiom,
    neq(p18_15,p3_19) ).

cnf(neq4191,axiom,
    neq(p18_15,p4_3) ).

cnf(neq4192,axiom,
    neq(p18_15,p4_6) ).

cnf(neq4193,axiom,
    neq(p18_15,p5_0) ).

cnf(neq4194,axiom,
    neq(p18_15,p5_10) ).

cnf(neq4195,axiom,
    neq(p18_15,p6_7) ).

cnf(neq4196,axiom,
    neq(p18_15,p6_10) ).

cnf(neq4197,axiom,
    neq(p18_15,p7_11) ).

cnf(neq4198,axiom,
    neq(p18_15,p8_2) ).

cnf(neq4199,axiom,
    neq(p18_15,p8_3) ).

cnf(neq4200,axiom,
    neq(p18_15,p8_5) ).

cnf(neq4201,axiom,
    neq(p18_15,p8_10) ).

cnf(neq4202,axiom,
    neq(p18_15,p9_15) ).

cnf(neq4203,axiom,
    neq(p18_15,p10_0) ).

cnf(neq4204,axiom,
    neq(p18_15,p11_3) ).

cnf(neq4205,axiom,
    neq(p18_15,p11_5) ).

cnf(neq4206,axiom,
    neq(p18_15,p11_13) ).

cnf(neq4207,axiom,
    neq(p18_15,p13_10) ).

cnf(neq4208,axiom,
    neq(p18_15,p13_14) ).

cnf(neq4209,axiom,
    neq(p18_15,p14_2) ).

cnf(neq4210,axiom,
    neq(p18_15,p14_7) ).

cnf(neq4211,axiom,
    neq(p18_15,p14_16) ).

cnf(neq4212,axiom,
    neq(p18_15,p14_17) ).

cnf(neq4213,axiom,
    neq(p18_15,p15_0) ).

cnf(neq4214,axiom,
    neq(p18_15,p15_1) ).

cnf(neq4215,axiom,
    neq(p18_15,p16_11) ).

cnf(neq4216,axiom,
    neq(p18_15,p16_18) ).

cnf(neq4217,axiom,
    neq(p18_15,p16_19) ).

cnf(neq4218,axiom,
    neq(p18_15,p17_3) ).

cnf(neq4219,axiom,
    neq(p18_15,p17_5) ).

cnf(neq4220,axiom,
    neq(p18_15,p17_8) ).

cnf(neq4221,axiom,
    neq(p18_15,p17_14) ).

cnf(neq4222,axiom,
    ~ neq(p18_15,p18_15) ).

cnf(neq4223,axiom,
    neq(p18_15,p19_8) ).

cnf(neq4224,axiom,
    neq(p18_15,p19_12) ).

cnf(neq4225,axiom,
    neq(p19_8,truck1) ).

cnf(neq4226,axiom,
    neq(p19_8,truck2) ).

cnf(neq4227,axiom,
    neq(p19_8,truck3) ).

cnf(neq4228,axiom,
    neq(p19_8,truck4) ).

cnf(neq4229,axiom,
    neq(p19_8,truck5) ).

cnf(neq4230,axiom,
    neq(p19_8,s0) ).

cnf(neq4231,axiom,
    neq(p19_8,s1) ).

cnf(neq4232,axiom,
    neq(p19_8,s2) ).

cnf(neq4233,axiom,
    neq(p19_8,s3) ).

cnf(neq4234,axiom,
    neq(p19_8,s4) ).

cnf(neq4235,axiom,
    neq(p19_8,s5) ).

cnf(neq4236,axiom,
    neq(p19_8,s6) ).

cnf(neq4237,axiom,
    neq(p19_8,s7) ).

cnf(neq4238,axiom,
    neq(p19_8,s8) ).

cnf(neq4239,axiom,
    neq(p19_8,s9) ).

cnf(neq4240,axiom,
    neq(p19_8,s10) ).

cnf(neq4241,axiom,
    neq(p19_8,s11) ).

cnf(neq4242,axiom,
    neq(p19_8,s12) ).

cnf(neq4243,axiom,
    neq(p19_8,s13) ).

cnf(neq4244,axiom,
    neq(p19_8,s14) ).

cnf(neq4245,axiom,
    neq(p19_8,s15) ).

cnf(neq4246,axiom,
    neq(p19_8,s16) ).

cnf(neq4247,axiom,
    neq(p19_8,s17) ).

cnf(neq4248,axiom,
    neq(p19_8,s18) ).

cnf(neq4249,axiom,
    neq(p19_8,s19) ).

cnf(neq4250,axiom,
    neq(p19_8,p0_8) ).

cnf(neq4251,axiom,
    neq(p19_8,p1_3) ).

cnf(neq4252,axiom,
    neq(p19_8,p1_4) ).

cnf(neq4253,axiom,
    neq(p19_8,p1_9) ).

cnf(neq4254,axiom,
    neq(p19_8,p2_3) ).

cnf(neq4255,axiom,
    neq(p19_8,p3_10) ).

cnf(neq4256,axiom,
    neq(p19_8,p3_19) ).

cnf(neq4257,axiom,
    neq(p19_8,p4_3) ).

cnf(neq4258,axiom,
    neq(p19_8,p4_6) ).

cnf(neq4259,axiom,
    neq(p19_8,p5_0) ).

cnf(neq4260,axiom,
    neq(p19_8,p5_10) ).

cnf(neq4261,axiom,
    neq(p19_8,p6_7) ).

cnf(neq4262,axiom,
    neq(p19_8,p6_10) ).

cnf(neq4263,axiom,
    neq(p19_8,p7_11) ).

cnf(neq4264,axiom,
    neq(p19_8,p8_2) ).

cnf(neq4265,axiom,
    neq(p19_8,p8_3) ).

cnf(neq4266,axiom,
    neq(p19_8,p8_5) ).

cnf(neq4267,axiom,
    neq(p19_8,p8_10) ).

cnf(neq4268,axiom,
    neq(p19_8,p9_15) ).

cnf(neq4269,axiom,
    neq(p19_8,p10_0) ).

cnf(neq4270,axiom,
    neq(p19_8,p11_3) ).

cnf(neq4271,axiom,
    neq(p19_8,p11_5) ).

cnf(neq4272,axiom,
    neq(p19_8,p11_13) ).

cnf(neq4273,axiom,
    neq(p19_8,p13_10) ).

cnf(neq4274,axiom,
    neq(p19_8,p13_14) ).

cnf(neq4275,axiom,
    neq(p19_8,p14_2) ).

cnf(neq4276,axiom,
    neq(p19_8,p14_7) ).

cnf(neq4277,axiom,
    neq(p19_8,p14_16) ).

cnf(neq4278,axiom,
    neq(p19_8,p14_17) ).

cnf(neq4279,axiom,
    neq(p19_8,p15_0) ).

cnf(neq4280,axiom,
    neq(p19_8,p15_1) ).

cnf(neq4281,axiom,
    neq(p19_8,p16_11) ).

cnf(neq4282,axiom,
    neq(p19_8,p16_18) ).

cnf(neq4283,axiom,
    neq(p19_8,p16_19) ).

cnf(neq4284,axiom,
    neq(p19_8,p17_3) ).

cnf(neq4285,axiom,
    neq(p19_8,p17_5) ).

cnf(neq4286,axiom,
    neq(p19_8,p17_8) ).

cnf(neq4287,axiom,
    neq(p19_8,p17_14) ).

cnf(neq4288,axiom,
    neq(p19_8,p18_15) ).

cnf(neq4289,axiom,
    ~ neq(p19_8,p19_8) ).

cnf(neq4290,axiom,
    neq(p19_8,p19_12) ).

cnf(neq4291,axiom,
    neq(p19_12,truck1) ).

cnf(neq4292,axiom,
    neq(p19_12,truck2) ).

cnf(neq4293,axiom,
    neq(p19_12,truck3) ).

cnf(neq4294,axiom,
    neq(p19_12,truck4) ).

cnf(neq4295,axiom,
    neq(p19_12,truck5) ).

cnf(neq4296,axiom,
    neq(p19_12,s0) ).

cnf(neq4297,axiom,
    neq(p19_12,s1) ).

cnf(neq4298,axiom,
    neq(p19_12,s2) ).

cnf(neq4299,axiom,
    neq(p19_12,s3) ).

cnf(neq4300,axiom,
    neq(p19_12,s4) ).

cnf(neq4301,axiom,
    neq(p19_12,s5) ).

cnf(neq4302,axiom,
    neq(p19_12,s6) ).

cnf(neq4303,axiom,
    neq(p19_12,s7) ).

cnf(neq4304,axiom,
    neq(p19_12,s8) ).

cnf(neq4305,axiom,
    neq(p19_12,s9) ).

cnf(neq4306,axiom,
    neq(p19_12,s10) ).

cnf(neq4307,axiom,
    neq(p19_12,s11) ).

cnf(neq4308,axiom,
    neq(p19_12,s12) ).

cnf(neq4309,axiom,
    neq(p19_12,s13) ).

cnf(neq4310,axiom,
    neq(p19_12,s14) ).

cnf(neq4311,axiom,
    neq(p19_12,s15) ).

cnf(neq4312,axiom,
    neq(p19_12,s16) ).

cnf(neq4313,axiom,
    neq(p19_12,s17) ).

cnf(neq4314,axiom,
    neq(p19_12,s18) ).

cnf(neq4315,axiom,
    neq(p19_12,s19) ).

cnf(neq4316,axiom,
    neq(p19_12,p0_8) ).

cnf(neq4317,axiom,
    neq(p19_12,p1_3) ).

cnf(neq4318,axiom,
    neq(p19_12,p1_4) ).

cnf(neq4319,axiom,
    neq(p19_12,p1_9) ).

cnf(neq4320,axiom,
    neq(p19_12,p2_3) ).

cnf(neq4321,axiom,
    neq(p19_12,p3_10) ).

cnf(neq4322,axiom,
    neq(p19_12,p3_19) ).

cnf(neq4323,axiom,
    neq(p19_12,p4_3) ).

cnf(neq4324,axiom,
    neq(p19_12,p4_6) ).

cnf(neq4325,axiom,
    neq(p19_12,p5_0) ).

cnf(neq4326,axiom,
    neq(p19_12,p5_10) ).

cnf(neq4327,axiom,
    neq(p19_12,p6_7) ).

cnf(neq4328,axiom,
    neq(p19_12,p6_10) ).

cnf(neq4329,axiom,
    neq(p19_12,p7_11) ).

cnf(neq4330,axiom,
    neq(p19_12,p8_2) ).

cnf(neq4331,axiom,
    neq(p19_12,p8_3) ).

cnf(neq4332,axiom,
    neq(p19_12,p8_5) ).

cnf(neq4333,axiom,
    neq(p19_12,p8_10) ).

cnf(neq4334,axiom,
    neq(p19_12,p9_15) ).

cnf(neq4335,axiom,
    neq(p19_12,p10_0) ).

cnf(neq4336,axiom,
    neq(p19_12,p11_3) ).

cnf(neq4337,axiom,
    neq(p19_12,p11_5) ).

cnf(neq4338,axiom,
    neq(p19_12,p11_13) ).

cnf(neq4339,axiom,
    neq(p19_12,p13_10) ).

cnf(neq4340,axiom,
    neq(p19_12,p13_14) ).

cnf(neq4341,axiom,
    neq(p19_12,p14_2) ).

cnf(neq4342,axiom,
    neq(p19_12,p14_7) ).

cnf(neq4343,axiom,
    neq(p19_12,p14_16) ).

cnf(neq4344,axiom,
    neq(p19_12,p14_17) ).

cnf(neq4345,axiom,
    neq(p19_12,p15_0) ).

cnf(neq4346,axiom,
    neq(p19_12,p15_1) ).

cnf(neq4347,axiom,
    neq(p19_12,p16_11) ).

cnf(neq4348,axiom,
    neq(p19_12,p16_18) ).

cnf(neq4349,axiom,
    neq(p19_12,p16_19) ).

cnf(neq4350,axiom,
    neq(p19_12,p17_3) ).

cnf(neq4351,axiom,
    neq(p19_12,p17_5) ).

cnf(neq4352,axiom,
    neq(p19_12,p17_8) ).

cnf(neq4353,axiom,
    neq(p19_12,p17_14) ).

cnf(neq4354,axiom,
    neq(p19_12,p18_15) ).

cnf(neq4355,axiom,
    neq(p19_12,p19_8) ).

cnf(neq4356,axiom,
    ~ neq(p19_12,p19_12) ).

cnf(map1,axiom,
    path(s0,p0_8) ).

cnf(map2,axiom,
    path(p0_8,s0) ).

cnf(map3,axiom,
    path(s8,p0_8) ).

cnf(map4,axiom,
    path(p0_8,s8) ).

cnf(map5,axiom,
    path(s1,p1_3) ).

cnf(map6,axiom,
    path(p1_3,s1) ).

cnf(map7,axiom,
    path(s3,p1_3) ).

cnf(map8,axiom,
    path(p1_3,s3) ).

cnf(map9,axiom,
    path(s1,p1_4) ).

cnf(map10,axiom,
    path(p1_4,s1) ).

cnf(map11,axiom,
    path(s4,p1_4) ).

cnf(map12,axiom,
    path(p1_4,s4) ).

cnf(map13,axiom,
    path(s1,p1_9) ).

cnf(map14,axiom,
    path(p1_9,s1) ).

cnf(map15,axiom,
    path(s9,p1_9) ).

cnf(map16,axiom,
    path(p1_9,s9) ).

cnf(map17,axiom,
    path(s2,p2_3) ).

cnf(map18,axiom,
    path(p2_3,s2) ).

cnf(map19,axiom,
    path(s3,p2_3) ).

cnf(map20,axiom,
    path(p2_3,s3) ).

cnf(map21,axiom,
    path(s3,p3_10) ).

cnf(map22,axiom,
    path(p3_10,s3) ).

cnf(map23,axiom,
    path(s10,p3_10) ).

cnf(map24,axiom,
    path(p3_10,s10) ).

cnf(map25,axiom,
    path(s3,p3_19) ).

cnf(map26,axiom,
    path(p3_19,s3) ).

cnf(map27,axiom,
    path(s19,p3_19) ).

cnf(map28,axiom,
    path(p3_19,s19) ).

cnf(map29,axiom,
    path(s4,p4_3) ).

cnf(map30,axiom,
    path(p4_3,s4) ).

cnf(map31,axiom,
    path(s3,p4_3) ).

cnf(map32,axiom,
    path(p4_3,s3) ).

cnf(map33,axiom,
    path(s4,p4_6) ).

cnf(map34,axiom,
    path(p4_6,s4) ).

cnf(map35,axiom,
    path(s6,p4_6) ).

cnf(map36,axiom,
    path(p4_6,s6) ).

cnf(map37,axiom,
    path(s5,p5_0) ).

cnf(map38,axiom,
    path(p5_0,s5) ).

cnf(map39,axiom,
    path(s0,p5_0) ).

cnf(map40,axiom,
    path(p5_0,s0) ).

cnf(map41,axiom,
    path(s5,p5_10) ).

cnf(map42,axiom,
    path(p5_10,s5) ).

cnf(map43,axiom,
    path(s10,p5_10) ).

cnf(map44,axiom,
    path(p5_10,s10) ).

cnf(map45,axiom,
    path(s6,p6_7) ).

cnf(map46,axiom,
    path(p6_7,s6) ).

cnf(map47,axiom,
    path(s7,p6_7) ).

cnf(map48,axiom,
    path(p6_7,s7) ).

cnf(map49,axiom,
    path(s6,p6_10) ).

cnf(map50,axiom,
    path(p6_10,s6) ).

cnf(map51,axiom,
    path(s10,p6_10) ).

cnf(map52,axiom,
    path(p6_10,s10) ).

cnf(map53,axiom,
    path(s7,p7_11) ).

cnf(map54,axiom,
    path(p7_11,s7) ).

cnf(map55,axiom,
    path(s11,p7_11) ).

cnf(map56,axiom,
    path(p7_11,s11) ).

cnf(map57,axiom,
    path(s8,p8_2) ).

cnf(map58,axiom,
    path(p8_2,s8) ).

cnf(map59,axiom,
    path(s2,p8_2) ).

cnf(map60,axiom,
    path(p8_2,s2) ).

cnf(map61,axiom,
    path(s8,p8_3) ).

cnf(map62,axiom,
    path(p8_3,s8) ).

cnf(map63,axiom,
    path(s3,p8_3) ).

cnf(map64,axiom,
    path(p8_3,s3) ).

cnf(map65,axiom,
    path(s8,p8_5) ).

cnf(map66,axiom,
    path(p8_5,s8) ).

cnf(map67,axiom,
    path(s5,p8_5) ).

cnf(map68,axiom,
    path(p8_5,s5) ).

cnf(map69,axiom,
    path(s8,p8_10) ).

cnf(map70,axiom,
    path(p8_10,s8) ).

cnf(map71,axiom,
    path(s10,p8_10) ).

cnf(map72,axiom,
    path(p8_10,s10) ).

cnf(map73,axiom,
    path(s9,p9_15) ).

cnf(map74,axiom,
    path(p9_15,s9) ).

cnf(map75,axiom,
    path(s15,p9_15) ).

cnf(map76,axiom,
    path(p9_15,s15) ).

cnf(map77,axiom,
    path(s10,p10_0) ).

cnf(map78,axiom,
    path(p10_0,s10) ).

cnf(map79,axiom,
    path(s0,p10_0) ).

cnf(map80,axiom,
    path(p10_0,s0) ).

cnf(map81,axiom,
    path(s11,p11_3) ).

cnf(map82,axiom,
    path(p11_3,s11) ).

cnf(map83,axiom,
    path(s3,p11_3) ).

cnf(map84,axiom,
    path(p11_3,s3) ).

cnf(map85,axiom,
    path(s11,p11_5) ).

cnf(map86,axiom,
    path(p11_5,s11) ).

cnf(map87,axiom,
    path(s5,p11_5) ).

cnf(map88,axiom,
    path(p11_5,s5) ).

cnf(map89,axiom,
    path(s11,p11_13) ).

cnf(map90,axiom,
    path(p11_13,s11) ).

cnf(map91,axiom,
    path(s13,p11_13) ).

cnf(map92,axiom,
    path(p11_13,s13) ).

cnf(map93,axiom,
    path(s13,p13_10) ).

cnf(map94,axiom,
    path(p13_10,s13) ).

cnf(map95,axiom,
    path(s10,p13_10) ).

cnf(map96,axiom,
    path(p13_10,s10) ).

cnf(map97,axiom,
    path(s13,p13_14) ).

cnf(map98,axiom,
    path(p13_14,s13) ).

cnf(map99,axiom,
    path(s14,p13_14) ).

cnf(map100,axiom,
    path(p13_14,s14) ).

cnf(map101,axiom,
    path(s14,p14_2) ).

cnf(map102,axiom,
    path(p14_2,s14) ).

cnf(map103,axiom,
    path(s2,p14_2) ).

cnf(map104,axiom,
    path(p14_2,s2) ).

cnf(map105,axiom,
    path(s14,p14_7) ).

cnf(map106,axiom,
    path(p14_7,s14) ).

cnf(map107,axiom,
    path(s7,p14_7) ).

cnf(map108,axiom,
    path(p14_7,s7) ).

cnf(map109,axiom,
    path(s14,p14_16) ).

cnf(map110,axiom,
    path(p14_16,s14) ).

cnf(map111,axiom,
    path(s16,p14_16) ).

cnf(map112,axiom,
    path(p14_16,s16) ).

cnf(map113,axiom,
    path(s14,p14_17) ).

cnf(map114,axiom,
    path(p14_17,s14) ).

cnf(map115,axiom,
    path(s17,p14_17) ).

cnf(map116,axiom,
    path(p14_17,s17) ).

cnf(map117,axiom,
    path(s15,p15_0) ).

cnf(map118,axiom,
    path(p15_0,s15) ).

cnf(map119,axiom,
    path(s0,p15_0) ).

cnf(map120,axiom,
    path(p15_0,s0) ).

cnf(map121,axiom,
    path(s15,p15_1) ).

cnf(map122,axiom,
    path(p15_1,s15) ).

cnf(map123,axiom,
    path(s1,p15_1) ).

cnf(map124,axiom,
    path(p15_1,s1) ).

cnf(map125,axiom,
    path(s16,p16_11) ).

cnf(map126,axiom,
    path(p16_11,s16) ).

cnf(map127,axiom,
    path(s11,p16_11) ).

cnf(map128,axiom,
    path(p16_11,s11) ).

cnf(map129,axiom,
    path(s16,p16_18) ).

cnf(map130,axiom,
    path(p16_18,s16) ).

cnf(map131,axiom,
    path(s18,p16_18) ).

cnf(map132,axiom,
    path(p16_18,s18) ).

cnf(map133,axiom,
    path(s16,p16_19) ).

cnf(map134,axiom,
    path(p16_19,s16) ).

cnf(map135,axiom,
    path(s19,p16_19) ).

cnf(map136,axiom,
    path(p16_19,s19) ).

cnf(map137,axiom,
    path(s17,p17_3) ).

cnf(map138,axiom,
    path(p17_3,s17) ).

cnf(map139,axiom,
    path(s3,p17_3) ).

cnf(map140,axiom,
    path(p17_3,s3) ).

cnf(map141,axiom,
    path(s17,p17_5) ).

cnf(map142,axiom,
    path(p17_5,s17) ).

cnf(map143,axiom,
    path(s5,p17_5) ).

cnf(map144,axiom,
    path(p17_5,s5) ).

cnf(map145,axiom,
    path(s17,p17_8) ).

cnf(map146,axiom,
    path(p17_8,s17) ).

cnf(map147,axiom,
    path(s8,p17_8) ).

cnf(map148,axiom,
    path(p17_8,s8) ).

cnf(map149,axiom,
    path(s18,p18_15) ).

cnf(map150,axiom,
    path(p18_15,s18) ).

cnf(map151,axiom,
    path(s15,p18_15) ).

cnf(map152,axiom,
    path(p18_15,s15) ).

cnf(map153,axiom,
    path(s19,p19_8) ).

cnf(map154,axiom,
    path(p19_8,s19) ).

cnf(map155,axiom,
    path(s8,p19_8) ).

cnf(map156,axiom,
    path(p19_8,s8) ).

cnf(map157,axiom,
    path(s19,p19_12) ).

cnf(map158,axiom,
    path(p19_12,s19) ).

cnf(map159,axiom,
    path(s12,p19_12) ).

cnf(map160,axiom,
    path(p19_12,s12) ).

cnf(map161,axiom,
    link(s0,s2) ).

cnf(map162,axiom,
    link(s2,s0) ).

cnf(map163,axiom,
    link(s0,s4) ).

cnf(map164,axiom,
    link(s4,s0) ).

cnf(map165,axiom,
    link(s0,s6) ).

cnf(map166,axiom,
    link(s6,s0) ).

cnf(map167,axiom,
    link(s1,s2) ).

cnf(map168,axiom,
    link(s2,s1) ).

cnf(map169,axiom,
    link(s1,s12) ).

cnf(map170,axiom,
    link(s12,s1) ).

cnf(map171,axiom,
    link(s1,s16) ).

cnf(map172,axiom,
    link(s16,s1) ).

cnf(map173,axiom,
    link(s2,s8) ).

cnf(map174,axiom,
    link(s8,s2) ).

cnf(map175,axiom,
    link(s2,s9) ).

cnf(map176,axiom,
    link(s9,s2) ).

cnf(map177,axiom,
    link(s2,s12) ).

cnf(map178,axiom,
    link(s12,s2) ).

cnf(map179,axiom,
    link(s2,s15) ).

cnf(map180,axiom,
    link(s15,s2) ).

cnf(map181,axiom,
    link(s3,s10) ).

cnf(map182,axiom,
    link(s10,s3) ).

cnf(map183,axiom,
    link(s3,s18) ).

cnf(map184,axiom,
    link(s18,s3) ).

cnf(map185,axiom,
    link(s4,s9) ).

cnf(map186,axiom,
    link(s9,s4) ).

cnf(map187,axiom,
    link(s4,s11) ).

cnf(map188,axiom,
    link(s11,s4) ).

cnf(map189,axiom,
    link(s5,s4) ).

cnf(map190,axiom,
    link(s4,s5) ).

cnf(map191,axiom,
    link(s5,s10) ).

cnf(map192,axiom,
    link(s10,s5) ).

cnf(map193,axiom,
    link(s5,s12) ).

cnf(map194,axiom,
    link(s12,s5) ).

cnf(map195,axiom,
    link(s5,s17) ).

cnf(map196,axiom,
    link(s17,s5) ).

cnf(map197,axiom,
    link(s6,s7) ).

cnf(map198,axiom,
    link(s7,s6) ).

cnf(map199,axiom,
    link(s7,s0) ).

cnf(map200,axiom,
    link(s0,s7) ).

cnf(map201,axiom,
    link(s7,s1) ).

cnf(map202,axiom,
    link(s1,s7) ).

cnf(map203,axiom,
    link(s7,s11) ).

cnf(map204,axiom,
    link(s11,s7) ).

cnf(map205,axiom,
    link(s7,s14) ).

cnf(map206,axiom,
    link(s14,s7) ).

cnf(map207,axiom,
    link(s8,s1) ).

cnf(map208,axiom,
    link(s1,s8) ).

cnf(map209,axiom,
    link(s8,s3) ).

cnf(map210,axiom,
    link(s3,s8) ).

cnf(map211,axiom,
    link(s8,s6) ).

cnf(map212,axiom,
    link(s6,s8) ).

cnf(map213,axiom,
    link(s8,s10) ).

cnf(map214,axiom,
    link(s10,s8) ).

cnf(map215,axiom,
    link(s8,s12) ).

cnf(map216,axiom,
    link(s12,s8) ).

cnf(map217,axiom,
    link(s9,s1) ).

cnf(map218,axiom,
    link(s1,s9) ).

cnf(map219,axiom,
    link(s9,s10) ).

cnf(map220,axiom,
    link(s10,s9) ).

cnf(map221,axiom,
    link(s9,s14) ).

cnf(map222,axiom,
    link(s14,s9) ).

cnf(map223,axiom,
    link(s9,s18) ).

cnf(map224,axiom,
    link(s18,s9) ).

cnf(map225,axiom,
    link(s10,s13) ).

cnf(map226,axiom,
    link(s13,s10) ).

cnf(map227,axiom,
    link(s10,s19) ).

cnf(map228,axiom,
    link(s19,s10) ).

cnf(map229,axiom,
    link(s11,s9) ).

cnf(map230,axiom,
    link(s9,s11) ).

cnf(map231,axiom,
    link(s11,s13) ).

cnf(map232,axiom,
    link(s13,s11) ).

cnf(map233,axiom,
    link(s11,s14) ).

cnf(map234,axiom,
    link(s14,s11) ).

cnf(map235,axiom,
    link(s11,s16) ).

cnf(map236,axiom,
    link(s16,s11) ).

cnf(map237,axiom,
    link(s12,s15) ).

cnf(map238,axiom,
    link(s15,s12) ).

cnf(map239,axiom,
    link(s13,s16) ).

cnf(map240,axiom,
    link(s16,s13) ).

cnf(map241,axiom,
    link(s13,s18) ).

cnf(map242,axiom,
    link(s18,s13) ).

cnf(map243,axiom,
    link(s14,s10) ).

cnf(map244,axiom,
    link(s10,s14) ).

cnf(map245,axiom,
    link(s14,s12) ).

cnf(map246,axiom,
    link(s12,s14) ).

cnf(map247,axiom,
    link(s14,s13) ).

cnf(map248,axiom,
    link(s13,s14) ).

cnf(map249,axiom,
    link(s14,s18) ).

cnf(map250,axiom,
    link(s18,s14) ).

cnf(map251,axiom,
    link(s15,s7) ).

cnf(map252,axiom,
    link(s7,s15) ).

cnf(map253,axiom,
    link(s15,s8) ).

cnf(map254,axiom,
    link(s8,s15) ).

cnf(map255,axiom,
    link(s15,s11) ).

cnf(map256,axiom,
    link(s11,s15) ).

cnf(map257,axiom,
    link(s16,s0) ).

cnf(map258,axiom,
    link(s0,s16) ).

cnf(map259,axiom,
    link(s16,s5) ).

cnf(map260,axiom,
    link(s5,s16) ).

cnf(map261,axiom,
    link(s16,s15) ).

cnf(map262,axiom,
    link(s15,s16) ).

cnf(map263,axiom,
    link(s17,s2) ).

cnf(map264,axiom,
    link(s2,s17) ).

cnf(map265,axiom,
    link(s17,s8) ).

cnf(map266,axiom,
    link(s8,s17) ).

cnf(map267,axiom,
    link(s17,s9) ).

cnf(map268,axiom,
    link(s9,s17) ).

cnf(map269,axiom,
    link(s17,s18) ).

cnf(map270,axiom,
    link(s18,s17) ).

cnf(map271,axiom,
    link(s18,s1) ).

cnf(map272,axiom,
    link(s1,s18) ).

cnf(map273,axiom,
    link(s18,s4) ).

cnf(map274,axiom,
    link(s4,s18) ).

cnf(map275,axiom,
    link(s18,s6) ).

cnf(map276,axiom,
    link(s6,s18) ).

cnf(map277,axiom,
    link(s18,s12) ).

cnf(map278,axiom,
    link(s12,s18) ).

cnf(map279,axiom,
    link(s18,s15) ).

cnf(map280,axiom,
    link(s15,s18) ).

cnf(map281,axiom,
    link(s19,s12) ).

cnf(map282,axiom,
    link(s12,s19) ).

cnf(map283,axiom,
    link(s19,s13) ).

cnf(map284,axiom,
    link(s13,s19) ).

cnf(map285,axiom,
    link(s19,s14) ).

cnf(map286,axiom,
    link(s14,s19) ).

cnf(init,axiom,
    s(s2,s18,s1,s12,s2,s4,s4,s4,s10,s18,s1,s7,s6,s16,s9,s18,s17,s13,s15,s13,s3,s14,s2,s16,s14,s13,s7,s6,s10,s6) ).

cnf(goal,negated_conjecture,
    ~ s(s16,s10,s12,s8,s3,s17,s4,s11,s1,s7,s9,s8,s9,s2,s4,s9,s13,s18,s9,s7,s2,X22,s11,s2,X25,s9,X27,X28,s15,X30) ).

%------------------------------------------------------------------------------
