%------------------------------------------------------------------------------
% File     : NUN015_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 201
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : s2s_201 [Bla13]

% Status   : ContradictoryAxioms
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  163 (  60 unt;  36 typ;   0 def)
%            Number of atoms       :  245 (  80 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  148 (  30   ~;   6   |;  15   &)
%                                         (  46 <=>;  51  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   3 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   14 (   9   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :   19 (  18 usr;   0 prp; 1-3 aty)
%            Number of functors    :   15 (  15 usr;   7 con; 0-4 aty)
%            Number of variables   :  192 ( 169   !;   0   ?; 192   :)
%                                         (  23  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_CAX_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:26:34
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (32)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_tn____,type,
    tn: nat ).

tff(sy_v_v____,type,
    v: int ).

tff(sy_v_w____,type,
    w: int ).

%----Relevant facts (97)
tff(fact_0__096v_A_126_061_A0_096,axiom,
    v != zero_zero(int) ).

tff(fact_1_zero__less__power2,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,zero_zero(A),power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))))
        <=> ( A1 != zero_zero(A) ) ) ) ).

tff(fact_2_zero__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( power_power(A,zero_zero(A),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) ) ) ).

tff(fact_3_zero__eq__power2,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [A1: A] :
          ( ( power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_4_less__special_I1_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Ya: int] :
          ( ord_less(A,zero_zero(A),number_number_of(A,Ya))
        <=> ord_less(int,pls,Ya) ) ) ).

tff(fact_5_less__special_I3_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Xa: int] :
          ( ord_less(A,number_number_of(A,Xa),zero_zero(A))
        <=> ord_less(int,Xa,pls) ) ) ).

tff(fact_6_rel__simps_I4_J,axiom,
    ! [K: int] :
      ( ord_less(int,pls,bit0(K))
    <=> ord_less(int,pls,K) ) ).

tff(fact_7_rel__simps_I10_J,axiom,
    ! [K: int] :
      ( ord_less(int,bit0(K),pls)
    <=> ord_less(int,K,pls) ) ).

tff(fact_8_rel__simps_I16_J,axiom,
    ! [L1: int,K: int] :
      ( ord_less(int,bit1(K),bit0(L1))
    <=> ord_less(int,K,L1) ) ).

tff(fact_9_rel__simps_I12_J,axiom,
    ! [K: int] :
      ( ord_less(int,bit1(K),pls)
    <=> ord_less(int,K,pls) ) ).

tff(fact_10_power__eq__0__iff__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [Wa: int,A1: A] :
          ( ( power_power(A,A1,number_number_of(nat,Wa)) = zero_zero(A) )
        <=> ( ( A1 = zero_zero(A) )
            & ( number_number_of(nat,Wa) != zero_zero(nat) ) ) ) ) ).

tff(fact_11_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Ya: int,Xa: int] :
          ( ord_less(A,number_number_of(A,Xa),number_number_of(A,Ya))
        <=> ord_less(int,Xa,Ya) ) ) ).

tff(fact_12_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_13_tn0,axiom,
    ord_less(nat,zero_zero(nat),tn) ).

tff(fact_14_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Ya: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Ya) )
        <=> ( Xa = Ya ) ) ) ).

tff(fact_15_rel__simps_I51_J,axiom,
    ! [L1: int,K: int] :
      ( ( bit1(K) = bit1(L1) )
    <=> ( K = L1 ) ) ).

tff(fact_16_rel__simps_I48_J,axiom,
    ! [L1: int,K: int] :
      ( ( bit0(K) = bit0(L1) )
    <=> ( K = L1 ) ) ).

tff(fact_17_n0,axiom,
    ord_less(nat,zero_zero(nat),n) ).

tff(fact_18_rel__simps_I46_J,axiom,
    ! [K1: int] : ( bit1(K1) != pls ) ).

tff(fact_19_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_20_rel__simps_I50_J,axiom,
    ! [L: int,K1: int] : ( bit1(K1) != bit0(L) ) ).

tff(fact_21_rel__simps_I49_J,axiom,
    ! [L: int,K1: int] : ( bit0(K1) != bit1(L) ) ).

tff(fact_22_rel__simps_I44_J,axiom,
    ! [K: int] :
      ( ( bit0(K) = pls )
    <=> ( K = pls ) ) ).

tff(fact_23_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_24_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_25_rel__simps_I17_J,axiom,
    ! [L1: int,K: int] :
      ( ord_less(int,bit1(K),bit1(L1))
    <=> ord_less(int,K,L1) ) ).

tff(fact_26_zero__less__power__nat__eq__number__of,axiom,
    ! [Wa: int,Xa: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,Xa,number_number_of(nat,Wa)))
    <=> ( ( number_number_of(nat,Wa) = zero_zero(nat) )
        | ord_less(nat,zero_zero(nat),Xa) ) ) ).

tff(fact_27_rel__simps_I2_J,axiom,
    ~ ord_less(int,pls,pls) ).

tff(fact_28_rel__simps_I14_J,axiom,
    ! [L1: int,K: int] :
      ( ord_less(int,bit0(K),bit0(L1))
    <=> ord_less(int,K,L1) ) ).

tff(fact_29_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_30_less__nat__number__of,axiom,
    ! [V1: int,Va: int] :
      ( ord_less(nat,number_number_of(nat,Va),number_number_of(nat,V1))
    <=> ( ( ord_less(int,Va,V1)
         => ord_less(int,pls,V1) )
        & ord_less(int,Va,V1) ) ) ).

tff(fact_31_less__0__number__of,axiom,
    ! [Va: int] :
      ( ord_less(nat,zero_zero(nat),number_number_of(nat,Va))
    <=> ord_less(int,pls,Va) ) ).

tff(fact_32_zero__less__power__nat__eq,axiom,
    ! [Na: nat,Xa: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,Xa,Na))
    <=> ( ( Na = zero_zero(nat) )
        | ord_less(nat,zero_zero(nat),Xa) ) ) ).

tff(fact_33_less__number__of__int__code,axiom,
    ! [L1: int,K: int] :
      ( ord_less(int,number_number_of(int,K),number_number_of(int,L1))
    <=> ord_less(int,K,L1) ) ).

tff(fact_34_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_35_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_36_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [Xa: A,Wa: int] :
          ( ( number_number_of(A,Wa) = Xa )
        <=> ( Xa = number_number_of(A,Wa) ) ) ) ).

tff(fact_37_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_38_less__int__code_I16_J,axiom,
    ! [K2: int,K11: int] :
      ( ord_less(int,bit1(K11),bit1(K2))
    <=> ord_less(int,K11,K2) ) ).

tff(fact_39_less__int__code_I13_J,axiom,
    ! [K2: int,K11: int] :
      ( ord_less(int,bit0(K11),bit0(K2))
    <=> ord_less(int,K11,K2) ) ).

tff(fact_40_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_41_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_42_less__int__code_I15_J,axiom,
    ! [K2: int,K11: int] :
      ( ord_less(int,bit1(K11),bit0(K2))
    <=> ord_less(int,K11,K2) ) ).

tff(fact_43_bin__less__0__simps_I4_J,axiom,
    ! [Wa: int] :
      ( ord_less(int,bit1(Wa),zero_zero(int))
    <=> ord_less(int,Wa,zero_zero(int)) ) ).

tff(fact_44_bin__less__0__simps_I1_J,axiom,
    ~ ord_less(int,pls,zero_zero(int)) ).

tff(fact_45_bin__less__0__simps_I3_J,axiom,
    ! [Wa: int] :
      ( ord_less(int,bit0(Wa),zero_zero(int))
    <=> ord_less(int,Wa,zero_zero(int)) ) ).

tff(fact_46_power2__less__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] : ~ ord_less(A,power_power(A,A2,number_number_of(nat,bit0(bit1(pls)))),zero_zero(A)) ) ).

tff(fact_47_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [Na: nat,A1: A] :
          ( ( power_power(A,A1,Na) = zero_zero(A) )
        <=> ( ( A1 = zero_zero(A) )
            & ( Na != zero_zero(nat) ) ) ) ) ).

tff(fact_48_quartic__square__square,axiom,
    ! [X: int] : ( power_power(int,power_power(int,X,number_number_of(nat,bit0(bit1(pls)))),number_number_of(nat,bit0(bit1(pls)))) = power_power(int,X,number_number_of(nat,bit0(bit0(bit1(pls))))) ) ).

tff(fact_49_pos2,axiom,
    ord_less(nat,zero_zero(nat),number_number_of(nat,bit0(bit1(pls)))) ).

tff(fact_50_calculation,axiom,
    plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls))))) = zero_zero(int) ).

tff(fact_51_zero__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ord_less(A,zero_zero(A),power_power(A,A2,N)) ) ) ).

tff(fact_52_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_53_nat__zero__less__power__iff,axiom,
    ! [Na: nat,Xa: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,Xa,Na))
    <=> ( ord_less(nat,zero_zero(nat),Xa)
        | ( Na = zero_zero(nat) ) ) ) ).

tff(fact_54_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_55_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_56_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( plus_plus(A,A1,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_57_add__Bit0__Bit0,axiom,
    ! [L: int,K1: int] : ( plus_plus(int,bit0(K1),bit0(L)) = bit0(plus_plus(int,K1,L)) ) ).

tff(fact_58_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( plus_plus(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,plus_plus(int,V,W)) ) ) ).

tff(fact_59_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( plus_plus(A,number_number_of(A,V),plus_plus(A,number_number_of(A,W),Z)) = plus_plus(A,number_number_of(A,plus_plus(int,V,W)),Z) ) ) ).

tff(fact_60_add__Bit0__Bit1,axiom,
    ! [L: int,K1: int] : ( plus_plus(int,bit0(K1),bit1(L)) = bit1(plus_plus(int,K1,L)) ) ).

tff(fact_61_add__Bit1__Bit0,axiom,
    ! [L: int,K1: int] : ( plus_plus(int,bit1(K1),bit0(L)) = bit1(plus_plus(int,K1,L)) ) ).

tff(fact_62_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_63_number__of__is__id,axiom,
    ! [K1: int] : ( number_number_of(int,K1) = K1 ) ).

tff(fact_64_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,plus_plus(int,V,W)) = plus_plus(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_65_nat__neq__iff,axiom,
    ! [Na: nat,Ma: nat] :
      ( ( Ma != Na )
    <=> ( ord_less(nat,Ma,Na)
        | ord_less(nat,Na,Ma) ) ) ).

tff(fact_66_plus__numeral__code_I9_J,axiom,
    ! [W: int,V: int] : ( plus_plus(int,number_number_of(int,V),number_number_of(int,W)) = number_number_of(int,plus_plus(int,V,W)) ) ).

tff(fact_67_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_68_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_69_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_70_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_71_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),Na: nat,Ma: nat] :
      ( ( ord_less(nat,Ma,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),Ma)) )
     => ( ( ( Ma = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),Ma)) )
       => ( ( ord_less(nat,Na,Ma)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),Ma)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),Ma)) ) ) ) ).

tff(fact_72_add__Pls,axiom,
    ! [K1: int] : ( plus_plus(int,pls,K1) = K1 ) ).

tff(fact_73_add__Pls__right,axiom,
    ! [K1: int] : ( plus_plus(int,K1,pls) = K1 ) ).

tff(fact_74_Bit0__def,axiom,
    ! [K1: int] : ( bit0(K1) = plus_plus(int,K1,K1) ) ).

tff(fact_75_even__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,plus_plus(A,A1,A1),zero_zero(A))
        <=> ord_less(A,A1,zero_zero(A)) ) ) ).

tff(fact_76_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( plus_plus(A,A2,number_number_of(A,pls)) = A2 ) ) ).

tff(fact_77_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( plus_plus(A,number_number_of(A,pls),A2) = A2 ) ) ).

tff(fact_78_number__of__Bit0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( number_number_of(A,bit0(W)) = plus_plus(A,plus_plus(A,zero_zero(A),number_number_of(A,W)),number_number_of(A,W)) ) ) ).

tff(fact_79_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_80_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_81_nat__power__less__imp__less,axiom,
    ! [N: nat,M: nat,I: nat] :
      ( ord_less(nat,zero_zero(nat),I)
     => ( ord_less(nat,power_power(nat,I,M),power_power(nat,I,N))
       => ord_less(nat,M,N) ) ) ).

tff(fact_82_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_83_sum__power2__eq__zero__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Ya: A,Xa: A] :
          ( ( plus_plus(A,power_power(A,Xa,number_number_of(nat,bit0(bit1(pls)))),power_power(A,Ya,number_number_of(nat,bit0(bit1(pls))))) = zero_zero(A) )
        <=> ( ( Xa = zero_zero(A) )
            & ( Ya = zero_zero(A) ) ) ) ) ).

tff(fact_84_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N: nat,A2: A] :
          ( ( A2 != zero_zero(A) )
         => ( power_power(A,A2,N) != zero_zero(A) ) ) ) ).

tff(fact_85_not__sum__power2__lt__zero,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] : ~ ord_less(A,plus_plus(A,power_power(A,X,number_number_of(nat,bit0(bit1(pls)))),power_power(A,Y,number_number_of(nat,bit0(bit1(pls))))),zero_zero(A)) ) ).

tff(fact_86_sum__power2__gt__zero__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Ya: A,Xa: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,power_power(A,Xa,number_number_of(nat,bit0(bit1(pls)))),power_power(A,Ya,number_number_of(nat,bit0(bit1(pls))))))
        <=> ( ( Xa != zero_zero(A) )
            | ( Ya != zero_zero(A) ) ) ) ) ).

tff(fact_87_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,A1,A1))
        <=> ord_less(A,zero_zero(A),A1) ) ) ).

tff(fact_88_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ord_less(A,plus_plus(A,A1,A1),zero_zero(A))
        <=> ord_less(A,A1,zero_zero(A)) ) ) ).

tff(fact_89_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C))
        <=> ord_less(A,A1,B) ) ) ).

tff(fact_90_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
        <=> ( B = C ) ) ) ).

tff(fact_91_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C,A1) )
        <=> ( B = C ) ) ) ).

tff(fact_92_add__is__0,axiom,
    ! [Na: nat,Ma: nat] :
      ( ( plus_plus(nat,Ma,Na) = zero_zero(nat) )
    <=> ( ( Ma = zero_zero(nat) )
        & ( Na = zero_zero(nat) ) ) ) ).

tff(fact_93_nat__add__left__cancel__less,axiom,
    ! [Na: nat,Ma: nat,K: nat] :
      ( ord_less(nat,plus_plus(nat,K,Ma),plus_plus(nat,K,Na))
    <=> ord_less(nat,Ma,Na) ) ).

tff(fact_94_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( zero_zero(A) = plus_plus(A,A1,A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_95_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B))
        <=> ord_less(A,A1,B) ) ) ).

tff(fact_96_add__gr__0,axiom,
    ! [Na: nat,Ma: nat] :
      ( ord_less(nat,zero_zero(nat),plus_plus(nat,Ma,Na))
    <=> ( ord_less(nat,zero_zero(nat),Ma)
        | ord_less(nat,zero_zero(nat),Na) ) ) ).

%----Arities (27)
tff(arity_Int_Oint___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ord_less(int,zero_zero(int),power_power(int,v,number_number_of(nat,bit0(bit1(pls))))) ).

%------------------------------------------------------------------------------
