%------------------------------------------------------------------------------
% File     : NUN009_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 186
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : s2s_186 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  162 (  68 unt;  43 typ;   0 def)
%            Number of atoms       :  205 (  88 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  107 (  21   ~;   2   |;  17   &)
%                                         (  27 <=>;  40  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   3 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   17 (  12   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :   18 (  17 usr;   0 prp; 1-3 aty)
%            Number of functors    :   23 (  23 usr;  13 con; 0-3 aty)
%            Number of variables   :  177 ( 155   !;   0   ?; 177   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:26:18
%------------------------------------------------------------------------------
%----Should-be-implicit typings (3)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

%----Explicit typings (40)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring,type,
    linordered_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_IntPrimes_Ozprime,type,
    zprime: int > $o ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_TwoSquares__Mirabelle__poiayhyqls_Ois__sum2sq,type,
    twoSqu1567020053sum2sq: int > $o ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_m,type,
    m: int ).

tff(sy_v_m1____,type,
    m1: int ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_r____,type,
    r: int ).

tff(sy_v_sa____,type,
    sa: int ).

tff(sy_v_t____,type,
    t: int ).

tff(sy_v_v____,type,
    v: int ).

tff(sy_v_w____,type,
    w: int ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_y____,type,
    y: int ).

%----Relevant facts (98)
tff(fact_0_m1,axiom,
    plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls))))) = times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),m1) ).

tff(fact_1__096_I4_A_K_Am_A_L_A1_J_A_K_A_I1_A_L_Aint_An_J_A_K_A_Iv_A_094_A2_A_L_Aw_A_094_A2_J_A_061_I_I1_A_L_Aint_An_J_A_K_A_Ir_A_K_Av_J_A_L_A_I1_A_L_Aint_An_J_A_K_A_Is_A_K_Aw_J_A_L_A_I1_A_L_Aint_An_J_A_K_Am1_J_A_094_A2_A_L_I_I1_A_L_Aint_An_J_A_K_A_Ir_A_K_Aw_J_A_N_A_I1_A_L_Aint_An_J_A_K_A_Is_A_K_Av_J_J_A_094_A2_096,axiom,
    times_times(int,times_times(int,plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls)))))) = plus_plus(int,power_power(int,plus_plus(int,plus_plus(int,times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,r,v)),times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,sa,w))),times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),m1)),number_number_of(nat,bit0(bit1(pls)))),power_power(int,minus_minus(int,times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,r,w)),times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,sa,v))),number_number_of(nat,bit0(bit1(pls))))) ).

tff(fact_2__096_I_Ir_A_K_A_I1_A_L_Aint_An_J_A_L_Av_J_A_K_Av_A_L_A_Is_A_K_A_I1_A_L_Aint_An_J_A_L_Aw_J_A_K_Aw_J_A_094_A2_A_L_I_Ir_A_K_A_I1_A_L_Aint_An_J_A_L_Av_J_A_K_Aw_A_N_A_Is_A_K_A_I1_A_L_Aint_An_J_A_L_Aw_J_A_K_Av_J_A_094_A2_A_061_I_I1_A_L_Aint_An_J_A_K_A_Ir_A_K_Av_J_A_L_A_I1_A_L_Aint_An_J_A_K_A_Is_A_K_Aw_J_A_L_A_Iv_A_094_A2_A_L_Aw_A_094_A2_J_J_A_094_A2_A_L_I_I1_A_L_Aint_An_J_A_K_A_Ir_A_K_Aw_J_A_N_A_I1_A_L_Aint_An_J_A_K_A_Is_A_K_Av_J_J_A_094_A2_096,axiom,
    plus_plus(int,power_power(int,plus_plus(int,times_times(int,plus_plus(int,times_times(int,r,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),v),v),times_times(int,plus_plus(int,times_times(int,sa,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),w),w)),number_number_of(nat,bit0(bit1(pls)))),power_power(int,minus_minus(int,times_times(int,plus_plus(int,times_times(int,r,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),v),w),times_times(int,plus_plus(int,times_times(int,sa,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),w),v)),number_number_of(nat,bit0(bit1(pls))))) = plus_plus(int,power_power(int,plus_plus(int,plus_plus(int,times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,r,v)),times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,sa,w))),plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls)))))),number_number_of(nat,bit0(bit1(pls)))),power_power(int,minus_minus(int,times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,r,w)),times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,sa,v))),number_number_of(nat,bit0(bit1(pls))))) ).

tff(fact_3__096_I_I1_A_L_Aint_An_J_A_K_A_Ir_A_K_Av_J_A_L_A_I1_A_L_Aint_An_J_A_K_A_Is_A_K_Aw_J_A_L_A_Iv_A_094_A2_A_L_Aw_A_094_A2_J_J_A_094_A2_A_L_I_I1_A_L_Aint_An_J_A_K_A_Ir_A_K_Aw_J_A_N_A_I1_A_L_Aint_An_J_A_K_A_Is_A_K_Av_J_J_A_094_A2_A_061_I_I1_A_L_Aint_An_J_A_K_A_Ir_A_K_Av_J_A_L_A_I1_A_L_Aint_An_J_A_K_A_Is_A_K_Aw_J_A_L_A_I1_A_L_Aint_An_J_A_K_Am1_J_A_094_A2_A_L_I_I1_A_L_Aint_An_J_A_K_A_Ir_A_K_Aw_J_A_N_A_I1_A_L_Aint_An_J_A_K_A_Is_A_K_Av_J_J_A_094_A2_096,axiom,
    plus_plus(int,power_power(int,plus_plus(int,plus_plus(int,times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,r,v)),times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,sa,w))),plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls)))))),number_number_of(nat,bit0(bit1(pls)))),power_power(int,minus_minus(int,times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,r,w)),times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,sa,v))),number_number_of(nat,bit0(bit1(pls))))) = plus_plus(int,power_power(int,plus_plus(int,plus_plus(int,times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,r,v)),times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,sa,w))),times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),m1)),number_number_of(nat,bit0(bit1(pls)))),power_power(int,minus_minus(int,times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,r,w)),times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),times_times(int,sa,v))),number_number_of(nat,bit0(bit1(pls))))) ).

tff(fact_4__096_B_Bthesis_O_A_I_B_Bx_Ay_O_Ax_A_094_A2_A_L_Ay_A_094_A2_A_061_A_I4_A_K_Am_A_L_A1_J_A_K_A_I1_A_L_Aint_An_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X1: int,Y1: int] : ( plus_plus(int,power_power(int,X1,number_number_of(nat,bit0(bit1(pls)))),power_power(int,Y1,number_number_of(nat,bit0(bit1(pls))))) != times_times(int,plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),plus_plus(int,one_one(int),semiring_1_of_nat(int,n))) ) ).

tff(fact_5__096_B_Bthesis_O_A_I_B_Bm1_O_Av_A_094_A2_A_L_Aw_A_094_A2_A_061_A_I1_A_L_Aint_An_J_A_K_Am1_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [M1: int] : ( plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls))))) != times_times(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),M1) ) ).

tff(fact_6_p,axiom,
    zprime(plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int))) ).

tff(fact_7_power2__eq__square__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W: int] : ( power_power(B,number_number_of(B,W),number_number_of(nat,bit0(bit1(pls)))) = times_times(B,number_number_of(B,W),number_number_of(B,W)) ) ) ).

tff(fact_8_one__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( power_power(A,one_one(A),number_number_of(nat,bit0(bit1(pls)))) = one_one(A) ) ) ).

tff(fact_9_add__special_I2_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( plus_plus(A,one_one(A),number_number_of(A,W)) = number_number_of(A,plus_plus(int,bit1(pls),W)) ) ) ).

tff(fact_10_add__special_I3_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( plus_plus(A,number_number_of(A,V),one_one(A)) = number_number_of(A,plus_plus(int,V,bit1(pls))) ) ) ).

tff(fact_11_one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( plus_plus(A,one_one(A),one_one(A)) = number_number_of(A,bit0(bit1(pls))) ) ) ).

tff(fact_12_nQ1,axiom,
    ~ twoSqu1567020053sum2sq(times_times(int,plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),plus_plus(int,one_one(int),semiring_1_of_nat(int,zero_zero(nat))))) ).

tff(fact_13_smaller_I2_J,axiom,
    ~ ( ord_less(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)))
     => ~ twoSqu1567020053sum2sq(times_times(int,plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),plus_plus(int,one_one(int),semiring_1_of_nat(int,n)))) ) ).

tff(fact_14_mult__Bit1,axiom,
    ! [L1: int,K: int] : ( times_times(int,bit1(K),L1) = plus_plus(int,bit0(times_times(int,K,L1)),L1) ) ).

tff(fact_15_numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_16_xy,axiom,
    plus_plus(int,power_power(int,x,number_number_of(nat,bit0(bit1(pls)))),power_power(int,y,number_number_of(nat,bit0(bit1(pls))))) = times_times(int,plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),plus_plus(int,one_one(int),semiring_1_of_nat(int,n))) ).

tff(fact_17_zdiff__power2,axiom,
    ! [B1: int,A2: int] : ( power_power(int,minus_minus(int,A2,B1),number_number_of(nat,bit0(bit1(pls)))) = plus_plus(int,minus_minus(int,power_power(int,A2,number_number_of(nat,bit0(bit1(pls)))),times_times(int,times_times(int,number_number_of(int,bit0(bit1(pls))),A2),B1)),power_power(int,B1,number_number_of(nat,bit0(bit1(pls))))) ) ).

tff(fact_18_zdiff__power3,axiom,
    ! [B1: int,A2: int] : ( power_power(int,minus_minus(int,A2,B1),number_number_of(nat,bit1(bit1(pls)))) = minus_minus(int,plus_plus(int,minus_minus(int,power_power(int,A2,number_number_of(nat,bit1(bit1(pls)))),times_times(int,times_times(int,number_number_of(int,bit1(bit1(pls))),power_power(int,A2,number_number_of(nat,bit0(bit1(pls))))),B1)),times_times(int,times_times(int,number_number_of(int,bit1(bit1(pls))),A2),power_power(int,B1,number_number_of(nat,bit0(bit1(pls)))))),power_power(int,B1,number_number_of(nat,bit1(bit1(pls))))) ) ).

tff(fact_19_t1,axiom,
    ord_less(int,one_one(int),t) ).

tff(fact_20_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Ya: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Ya) )
        <=> ( Xa = Ya ) ) ) ).

tff(fact_21_rel__simps_I51_J,axiom,
    ! [L: int,K3: int] :
      ( ( bit1(K3) = bit1(L) )
    <=> ( K3 = L ) ) ).

tff(fact_22_rel__simps_I48_J,axiom,
    ! [L: int,K3: int] :
      ( ( bit0(K3) = bit0(L) )
    <=> ( K3 = L ) ) ).

tff(fact_23_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( plus_plus(A,A1,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_24_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_25_rel__simps_I39_J,axiom,
    ! [L1: int] : ( pls != bit1(L1) ) ).

tff(fact_26_rel__simps_I50_J,axiom,
    ! [L1: int,K: int] : ( bit1(K) != bit0(L1) ) ).

tff(fact_27_rel__simps_I49_J,axiom,
    ! [L1: int,K: int] : ( bit0(K) != bit1(L1) ) ).

tff(fact_28_rel__simps_I44_J,axiom,
    ! [K3: int] :
      ( ( bit0(K3) = pls )
    <=> ( K3 = pls ) ) ).

tff(fact_29_rel__simps_I38_J,axiom,
    ! [L: int] :
      ( ( pls = bit0(L) )
    <=> ( pls = L ) ) ).

tff(fact_30_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_31_rel__simps_I17_J,axiom,
    ! [L: int,K3: int] :
      ( ord_less(int,bit1(K3),bit1(L))
    <=> ord_less(int,K3,L) ) ).

tff(fact_32_rel__simps_I2_J,axiom,
    ~ ord_less(int,pls,pls) ).

tff(fact_33_rel__simps_I14_J,axiom,
    ! [L: int,K3: int] :
      ( ord_less(int,bit0(K3),bit0(L))
    <=> ord_less(int,K3,L) ) ).

tff(fact_34_mult__Pls,axiom,
    ! [W: int] : ( times_times(int,pls,W) = pls ) ).

tff(fact_35_mult__Bit0,axiom,
    ! [L1: int,K: int] : ( times_times(int,bit0(K),L1) = bit0(times_times(int,K,L1)) ) ).

tff(fact_36_add__Bit0__Bit0,axiom,
    ! [L1: int,K: int] : ( plus_plus(int,bit0(K),bit0(L1)) = bit0(plus_plus(int,K,L1)) ) ).

tff(fact_37_mn,axiom,
    ord_less(int,m1,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))) ).

tff(fact_38_diff__bin__simps_I7_J,axiom,
    ! [L1: int,K: int] : ( minus_minus(int,bit0(K),bit0(L1)) = bit0(minus_minus(int,K,L1)) ) ).

tff(fact_39_n0,axiom,
    ord_less(nat,zero_zero(nat),n) ).

tff(fact_40_left__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & semiring(B) )
     => ! [V: int,B1: B,A2: B] : ( times_times(B,plus_plus(B,A2,B1),number_number_of(B,V)) = plus_plus(B,times_times(B,A2,number_number_of(B,V)),times_times(B,B1,number_number_of(B,V))) ) ) ).

tff(fact_41_right__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & semiring(B) )
     => ! [C: B,B1: B,V: int] : ( times_times(B,number_number_of(B,V),plus_plus(B,B1,C)) = plus_plus(B,times_times(B,number_number_of(B,V),B1),times_times(B,number_number_of(B,V),C)) ) ) ).

tff(fact_42_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_43_left__diff__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & ring(B) )
     => ! [V: int,B1: B,A2: B] : ( times_times(B,minus_minus(B,A2,B1),number_number_of(B,V)) = minus_minus(B,times_times(B,A2,number_number_of(B,V)),times_times(B,B1,number_number_of(B,V))) ) ) ).

tff(fact_44_right__diff__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & ring(B) )
     => ! [C: B,B1: B,V: int] : ( times_times(B,number_number_of(B,V),minus_minus(B,B1,C)) = minus_minus(B,times_times(B,number_number_of(B,V),B1),times_times(B,number_number_of(B,V),C)) ) ) ).

tff(fact_45_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Ya: int,Xa: int] :
          ( ord_less(A,number_number_of(A,Xa),number_number_of(A,Ya))
        <=> ord_less(int,Xa,Ya) ) ) ).

tff(fact_46_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W),Z)) = times_times(A,number_number_of(A,times_times(int,V,W)),Z) ) ) ).

tff(fact_47_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,times_times(int,V,W)) ) ) ).

tff(fact_48_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( plus_plus(A,number_number_of(A,V),plus_plus(A,number_number_of(A,W),Z)) = plus_plus(A,number_number_of(A,plus_plus(int,V,W)),Z) ) ) ).

tff(fact_49_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( plus_plus(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,plus_plus(int,V,W)) ) ) ).

tff(fact_50_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_51_rel__simps_I12_J,axiom,
    ! [K3: int] :
      ( ord_less(int,bit1(K3),pls)
    <=> ord_less(int,K3,pls) ) ).

tff(fact_52_rel__simps_I16_J,axiom,
    ! [L: int,K3: int] :
      ( ord_less(int,bit1(K3),bit0(L))
    <=> ord_less(int,K3,L) ) ).

tff(fact_53_rel__simps_I10_J,axiom,
    ! [K3: int] :
      ( ord_less(int,bit0(K3),pls)
    <=> ord_less(int,K3,pls) ) ).

tff(fact_54_rel__simps_I4_J,axiom,
    ! [K3: int] :
      ( ord_less(int,pls,bit0(K3))
    <=> ord_less(int,pls,K3) ) ).

tff(fact_55_nat__numeral__1__eq__1,axiom,
    number_number_of(nat,bit1(pls)) = one_one(nat) ).

tff(fact_56_add__Bit1__Bit0,axiom,
    ! [L1: int,K: int] : ( plus_plus(int,bit1(K),bit0(L1)) = bit1(plus_plus(int,K,L1)) ) ).

tff(fact_57_add__Bit0__Bit1,axiom,
    ! [L1: int,K: int] : ( plus_plus(int,bit0(K),bit1(L1)) = bit1(plus_plus(int,K,L1)) ) ).

tff(fact_58_diff__bin__simps_I10_J,axiom,
    ! [L1: int,K: int] : ( minus_minus(int,bit1(K),bit1(L1)) = bit0(minus_minus(int,K,L1)) ) ).

tff(fact_59_diff__bin__simps_I9_J,axiom,
    ! [L1: int,K: int] : ( minus_minus(int,bit1(K),bit0(L1)) = bit1(minus_minus(int,K,L1)) ) ).

tff(fact_60_diff__bin__simps_I3_J,axiom,
    ! [L1: int] : ( minus_minus(int,pls,bit0(L1)) = bit0(minus_minus(int,pls,L1)) ) ).

tff(fact_61_IH,axiom,
    ( ord_less(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)))
    & twoSqu1567020053sum2sq(times_times(int,plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),plus_plus(int,one_one(int),semiring_1_of_nat(int,n)))) ) ).

tff(fact_62_nat__1__add__1,axiom,
    plus_plus(nat,one_one(nat),one_one(nat)) = number_number_of(nat,bit0(bit1(pls))) ).

tff(fact_63_add__nat__number__of,axiom,
    ! [V1: int,V: int] :
      ( ( ord_less(int,V,pls)
       => ( plus_plus(nat,number_number_of(nat,V),number_number_of(nat,V1)) = number_number_of(nat,V1) ) )
      & ( ~ ord_less(int,V,pls)
       => ( ( ord_less(int,V1,pls)
           => ( plus_plus(nat,number_number_of(nat,V),number_number_of(nat,V1)) = number_number_of(nat,V) ) )
          & ( ~ ord_less(int,V1,pls)
           => ( plus_plus(nat,number_number_of(nat,V),number_number_of(nat,V1)) = number_number_of(nat,plus_plus(int,V,V1)) ) ) ) ) ) ).

tff(fact_64__096_Ix_A_094_A2_A_L_Ay_A_094_A2_J_A_K_A_Iv_A_094_A2_A_L_Aw_A_094_A2_J_A_061_Ix_A_K_Av_A_L_Ay_A_K_Aw_J_A_094_A2_A_L_A_Ix_A_K_Aw_A_N_Ay_A_K_Av_J_A_094_A2_096,axiom,
    times_times(int,plus_plus(int,power_power(int,x,number_number_of(nat,bit0(bit1(pls)))),power_power(int,y,number_number_of(nat,bit0(bit1(pls))))),plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls)))))) = plus_plus(int,power_power(int,plus_plus(int,times_times(int,x,v),times_times(int,y,w)),number_number_of(nat,bit0(bit1(pls)))),power_power(int,minus_minus(int,times_times(int,x,w),times_times(int,y,v)),number_number_of(nat,bit0(bit1(pls))))) ).

tff(fact_65_less__special_I3_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Xa: int] :
          ( ord_less(A,number_number_of(A,Xa),zero_zero(A))
        <=> ord_less(int,Xa,pls) ) ) ).

tff(fact_66_less__special_I1_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Ya: int] :
          ( ord_less(A,zero_zero(A),number_number_of(A,Ya))
        <=> ord_less(int,pls,Ya) ) ) ).

tff(fact_67_mult__nat__number__of,axiom,
    ! [V1: int,V: int] :
      ( ( ord_less(int,V,pls)
       => ( times_times(nat,number_number_of(nat,V),number_number_of(nat,V1)) = zero_zero(nat) ) )
      & ( ~ ord_less(int,V,pls)
       => ( times_times(nat,number_number_of(nat,V),number_number_of(nat,V1)) = number_number_of(nat,times_times(int,V,V1)) ) ) ) ).

tff(fact_68__096_I4_A_K_Am_A_L_A1_J_A_K_A_I1_A_L_Aint_An_J_A_K_A_Iv_A_094_A2_A_L_Aw_A_094_A2_J_A_061_Ix_A_094_A2_A_L_Ay_A_094_A2_J_A_K_A_Iv_A_094_A2_A_L_Aw_A_094_A2_J_096,axiom,
    times_times(int,times_times(int,plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls)))))) = times_times(int,plus_plus(int,power_power(int,x,number_number_of(nat,bit0(bit1(pls)))),power_power(int,y,number_number_of(nat,bit0(bit1(pls))))),plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls)))))) ).

tff(fact_69_less__special_I4_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Xa: int] :
          ( ord_less(A,number_number_of(A,Xa),one_one(A))
        <=> ord_less(int,Xa,bit1(pls)) ) ) ).

tff(fact_70_less__special_I2_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Ya: int] :
          ( ord_less(A,one_one(A),number_number_of(A,Ya))
        <=> ord_less(int,bit1(pls),Ya) ) ) ).

tff(fact_71_zero__eq__power2,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [A1: A] :
          ( ( power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_72_zero__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( power_power(A,zero_zero(A),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) ) ) ).

tff(fact_73__096_Ix_A_K_Av_A_L_Ay_A_K_Aw_J_A_094_A2_A_L_A_Ix_A_K_Aw_A_N_Ay_A_K_Av_J_A_094_A2_A_061_I_Ir_A_K_A_I1_A_L_Aint_An_J_A_L_Av_J_A_K_Av_A_L_A_Is_A_K_A_I1_A_L_Aint_An_J_A_L_Aw_J_A_K_Aw_J_A_094_A2_A_L_I_Ir_A_K_A_I1_A_L_Aint_An_J_A_L_Av_J_A_K_Aw_A_N_A_Is_A_K_A_I1_A_L_Aint_An_J_A_L_Aw_J_A_K_Av_J_A_094_A2_096,axiom,
    plus_plus(int,power_power(int,plus_plus(int,times_times(int,x,v),times_times(int,y,w)),number_number_of(nat,bit0(bit1(pls)))),power_power(int,minus_minus(int,times_times(int,x,w),times_times(int,y,v)),number_number_of(nat,bit0(bit1(pls))))) = plus_plus(int,power_power(int,plus_plus(int,times_times(int,plus_plus(int,times_times(int,r,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),v),v),times_times(int,plus_plus(int,times_times(int,sa,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),w),w)),number_number_of(nat,bit0(bit1(pls)))),power_power(int,minus_minus(int,times_times(int,plus_plus(int,times_times(int,r,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),v),w),times_times(int,plus_plus(int,times_times(int,sa,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),w),v)),number_number_of(nat,bit0(bit1(pls))))) ).

tff(fact_74_zero__less__power2,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,zero_zero(A),power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))))
        <=> ( A1 != zero_zero(A) ) ) ) ).

tff(fact_75_even__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,plus_plus(A,A1,A1),zero_zero(A))
        <=> ord_less(A,A1,zero_zero(A)) ) ) ).

tff(fact_76_less__int__code_I16_J,axiom,
    ! [K2: int,K1: int] :
      ( ord_less(int,bit1(K1),bit1(K2))
    <=> ord_less(int,K1,K2) ) ).

tff(fact_77_less__int__code_I13_J,axiom,
    ! [K2: int,K1: int] :
      ( ord_less(int,bit0(K1),bit0(K2))
    <=> ord_less(int,K1,K2) ) ).

tff(fact_78_less__number__of__int__code,axiom,
    ! [L: int,K3: int] :
      ( ord_less(int,number_number_of(int,K3),number_number_of(int,L))
    <=> ord_less(int,K3,L) ) ).

tff(fact_79_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X: int] : ( power_power(int,power_power(int,X,Y),Z) = power_power(int,X,times_times(nat,Y,Z)) ) ).

tff(fact_80_sum__squares__gt__zero__iff,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [Ya: A,Xa: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,times_times(A,Xa,Xa),times_times(A,Ya,Ya)))
        <=> ( ( Xa != zero_zero(A) )
            | ( Ya != zero_zero(A) ) ) ) ) ).

tff(fact_81_not__sum__squares__lt__zero,axiom,
    ! [A: $tType] :
      ( linordered_ring(A)
     => ! [Y: A,X: A] : ~ ord_less(A,plus_plus(A,times_times(A,X,X),times_times(A,Y,Y)),zero_zero(A)) ) ).

tff(fact_82_nat__number__of__mult__left,axiom,
    ! [K: nat,V1: int,V: int] :
      ( ( ord_less(int,V,pls)
       => ( times_times(nat,number_number_of(nat,V),times_times(nat,number_number_of(nat,V1),K)) = zero_zero(nat) ) )
      & ( ~ ord_less(int,V,pls)
       => ( times_times(nat,number_number_of(nat,V),times_times(nat,number_number_of(nat,V1),K)) = times_times(nat,number_number_of(nat,times_times(int,V,V1)),K) ) ) ) ).

tff(fact_83_less__int__code_I15_J,axiom,
    ! [K2: int,K1: int] :
      ( ord_less(int,bit1(K1),bit0(K2))
    <=> ord_less(int,K1,K2) ) ).

tff(fact_84_sum__squares__eq__zero__iff,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [Ya: A,Xa: A] :
          ( ( plus_plus(A,times_times(A,Xa,Xa),times_times(A,Ya,Ya)) = zero_zero(A) )
        <=> ( ( Xa = zero_zero(A) )
            & ( Ya = zero_zero(A) ) ) ) ) ).

tff(fact_85_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_86_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_87_zless__add1__eq,axiom,
    ! [Z1: int,Wa: int] :
      ( ord_less(int,Wa,plus_plus(int,Z1,one_one(int)))
    <=> ( ord_less(int,Wa,Z1)
        | ( Wa = Z1 ) ) ) ).

tff(fact_88_zpower__int,axiom,
    ! [N: nat,M: nat] : ( power_power(int,semiring_1_of_nat(int,M),N) = semiring_1_of_nat(int,power_power(nat,M,N)) ) ).

tff(fact_89_int__power,axiom,
    ! [N: nat,M: nat] : ( semiring_1_of_nat(int,power_power(nat,M,N)) = power_power(int,semiring_1_of_nat(int,M),N) ) ).

tff(fact_90_zadd__int__left,axiom,
    ! [Z: int,N: nat,M: nat] : ( plus_plus(int,semiring_1_of_nat(int,M),plus_plus(int,semiring_1_of_nat(int,N),Z)) = plus_plus(int,semiring_1_of_nat(int,plus_plus(nat,M,N)),Z) ) ).

tff(fact_91_zadd__int,axiom,
    ! [N: nat,M: nat] : ( plus_plus(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,N)) = semiring_1_of_nat(int,plus_plus(nat,M,N)) ) ).

tff(fact_92_zmult__int,axiom,
    ! [N: nat,M: nat] : ( times_times(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,N)) = semiring_1_of_nat(int,times_times(nat,M,N)) ) ).

tff(fact_93_int__mult,axiom,
    ! [N: nat,M: nat] : ( semiring_1_of_nat(int,times_times(nat,M,N)) = times_times(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,N)) ) ).

tff(fact_94_int__1,axiom,
    semiring_1_of_nat(int,one_one(nat)) = one_one(int) ).

tff(fact_95_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_96_nat__mult__2,axiom,
    ! [Z: nat] : ( times_times(nat,number_number_of(nat,bit0(bit1(pls))),Z) = plus_plus(nat,Z,Z) ) ).

tff(fact_97_nat__mult__2__right,axiom,
    ! [Z: nat] : ( times_times(nat,Z,number_number_of(nat,bit0(bit1(pls)))) = plus_plus(nat,Z,Z) ) ).

%----Arities (18)
tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring__strict,axiom,
    linord581940658strict(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring,axiom,
    linordered_ring(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    times_times(int,times_times(int,plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),plus_plus(int,one_one(int),semiring_1_of_nat(int,n))),plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls)))))) = plus_plus(int,times_times(int,power_power(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),number_number_of(nat,bit0(bit1(pls)))),power_power(int,plus_plus(int,plus_plus(int,times_times(int,r,v),times_times(int,sa,w)),m1),number_number_of(nat,bit0(bit1(pls))))),times_times(int,power_power(int,plus_plus(int,one_one(int),semiring_1_of_nat(int,n)),number_number_of(nat,bit0(bit1(pls)))),power_power(int,minus_minus(int,times_times(int,r,w),times_times(int,sa,v)),number_number_of(nat,bit0(bit1(pls)))))) ).

%------------------------------------------------------------------------------
