%------------------------------------------------------------------------------
% File     : NUN005_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 174
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : s2s_174 [Bla13]

% Status   : Theorem
% Rating   : 1.00 v9.1.0, 0.67 v7.4.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  160 (  71 unt;  30 typ;   0 def)
%            Number of atoms       :  201 ( 109 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   79 (   8   ~;   0   |;   7   &)
%                                         (   9 <=>;  55  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   4 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   12 (   8   >;   4   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-2 aty)
%            Number of functors    :   14 (  14 usr;   7 con; 0-3 aty)
%            Number of variables   :  287 ( 271   !;   0   ?; 287   :)
%                                         (  16  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:26:06
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

%----Explicit typings (26)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__ring,type,
    comm_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_v____,type,
    v: int ).

tff(sy_v_w____,type,
    w: int ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_y____,type,
    y: int ).

%----Relevant facts (98)
tff(fact_0_power2__eq__square__number__of,axiom,
    ! [B2: $tType] :
      ( ( monoid_mult(B2)
        & number(B2) )
     => ! [W: int] : ( power_power(B2,number_number_of(B2,W),number_number_of(nat,bit0(bit1(pls)))) = times_times(B2,number_number_of(B2,W),number_number_of(B2,W)) ) ) ).

tff(fact_1_mult__Bit1,axiom,
    ! [L: int,K: int] : ( times_times(int,bit1(K),L) = plus_plus(int,bit0(times_times(int,K,L)),L) ) ).

tff(fact_2_power2__diff,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Y: A,X: A] : ( power_power(A,minus_minus(A,X,Y),number_number_of(nat,bit0(bit1(pls)))) = minus_minus(A,plus_plus(A,power_power(A,X,number_number_of(nat,bit0(bit1(pls)))),power_power(A,Y,number_number_of(nat,bit0(bit1(pls))))),times_times(A,times_times(A,number_number_of(A,bit0(bit1(pls))),X),Y)) ) ) ).

tff(fact_3_zspecial__product,axiom,
    ! [B: int,A1: int] : ( times_times(int,plus_plus(int,A1,B),minus_minus(int,A1,B)) = minus_minus(int,power_power(int,A1,number_number_of(nat,bit0(bit1(pls)))),power_power(int,B,number_number_of(nat,bit0(bit1(pls))))) ) ).

tff(fact_4_power2__sum,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Y: A,X: A] : ( power_power(A,plus_plus(A,X,Y),number_number_of(nat,bit0(bit1(pls)))) = plus_plus(A,plus_plus(A,power_power(A,X,number_number_of(nat,bit0(bit1(pls)))),power_power(A,Y,number_number_of(nat,bit0(bit1(pls))))),times_times(A,times_times(A,number_number_of(A,bit0(bit1(pls))),X),Y)) ) ) ).

tff(fact_5_diff__bin__simps_I3_J,axiom,
    ! [L: int] : ( minus_minus(int,pls,bit0(L)) = bit0(minus_minus(int,pls,L)) ) ).

tff(fact_6_diff__bin__simps_I9_J,axiom,
    ! [L: int,K: int] : ( minus_minus(int,bit1(K),bit0(L)) = bit1(minus_minus(int,K,L)) ) ).

tff(fact_7_diff__bin__simps_I10_J,axiom,
    ! [L: int,K: int] : ( minus_minus(int,bit1(K),bit1(L)) = bit0(minus_minus(int,K,L)) ) ).

tff(fact_8_add__Bit0__Bit1,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit0(K),bit1(L)) = bit1(plus_plus(int,K,L)) ) ).

tff(fact_9_add__Bit1__Bit0,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit1(K),bit0(L)) = bit1(plus_plus(int,K,L)) ) ).

tff(fact_10_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( plus_plus(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,plus_plus(int,V,W)) ) ) ).

tff(fact_11_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( plus_plus(A,number_number_of(A,V),plus_plus(A,number_number_of(A,W),Z)) = plus_plus(A,number_number_of(A,plus_plus(int,V,W)),Z) ) ) ).

tff(fact_12_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Ya: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Ya) )
        <=> ( Xa = Ya ) ) ) ).

tff(fact_13_rel__simps_I51_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit1(K1) = bit1(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_14_rel__simps_I48_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit0(K1) = bit0(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_15_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_16_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_17_rel__simps_I50_J,axiom,
    ! [L: int,K: int] : ( bit1(K) != bit0(L) ) ).

tff(fact_18_rel__simps_I49_J,axiom,
    ! [L: int,K: int] : ( bit0(K) != bit1(L) ) ).

tff(fact_19_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_20_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_21_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_22_mult__Pls,axiom,
    ! [W: int] : ( times_times(int,pls,W) = pls ) ).

tff(fact_23_mult__Bit0,axiom,
    ! [L: int,K: int] : ( times_times(int,bit0(K),L) = bit0(times_times(int,K,L)) ) ).

tff(fact_24_add__Bit0__Bit0,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit0(K),bit0(L)) = bit0(plus_plus(int,K,L)) ) ).

tff(fact_25_diff__bin__simps_I7_J,axiom,
    ! [L: int,K: int] : ( minus_minus(int,bit0(K),bit0(L)) = bit0(minus_minus(int,K,L)) ) ).

tff(fact_26_left__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & semiring(B2) )
     => ! [V: int,B: B2,A1: B2] : ( times_times(B2,plus_plus(B2,A1,B),number_number_of(B2,V)) = plus_plus(B2,times_times(B2,A1,number_number_of(B2,V)),times_times(B2,B,number_number_of(B2,V))) ) ) ).

tff(fact_27_right__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & semiring(B2) )
     => ! [C: B2,B: B2,V: int] : ( times_times(B2,number_number_of(B2,V),plus_plus(B2,B,C)) = plus_plus(B2,times_times(B2,number_number_of(B2,V),B),times_times(B2,number_number_of(B2,V),C)) ) ) ).

tff(fact_28_left__diff__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & ring(B2) )
     => ! [V: int,B: B2,A1: B2] : ( times_times(B2,minus_minus(B2,A1,B),number_number_of(B2,V)) = minus_minus(B2,times_times(B2,A1,number_number_of(B2,V)),times_times(B2,B,number_number_of(B2,V))) ) ) ).

tff(fact_29_right__diff__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & ring(B2) )
     => ! [C: B2,B: B2,V: int] : ( times_times(B2,number_number_of(B2,V),minus_minus(B2,B,C)) = minus_minus(B2,times_times(B2,number_number_of(B2,V),B),times_times(B2,number_number_of(B2,V),C)) ) ) ).

tff(fact_30_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W),Z)) = times_times(A,number_number_of(A,times_times(int,V,W)),Z) ) ) ).

tff(fact_31_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,times_times(int,V,W)) ) ) ).

tff(fact_32_times__numeral__code_I5_J,axiom,
    ! [W: int,V: int] : ( times_times(int,number_number_of(int,V),number_number_of(int,W)) = number_number_of(int,times_times(int,V,W)) ) ).

tff(fact_33_plus__numeral__code_I9_J,axiom,
    ! [W: int,V: int] : ( plus_plus(int,number_number_of(int,V),number_number_of(int,W)) = number_number_of(int,plus_plus(int,V,W)) ) ).

tff(fact_34_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X: int] : ( power_power(int,power_power(int,X,Y),Z) = power_power(int,X,times_times(nat,Y,Z)) ) ).

tff(fact_35_nat__mult__2,axiom,
    ! [Z: nat] : ( times_times(nat,number_number_of(nat,bit0(bit1(pls))),Z) = plus_plus(nat,Z,Z) ) ).

tff(fact_36_nat__mult__2__right,axiom,
    ! [Z: nat] : ( times_times(nat,Z,number_number_of(nat,bit0(bit1(pls)))) = plus_plus(nat,Z,Z) ) ).

tff(fact_37_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [Xa: A,Wa: int] :
          ( ( number_number_of(A,Wa) = Xa )
        <=> ( Xa = number_number_of(A,Wa) ) ) ) ).

tff(fact_38_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = power_power(A,power_power(A,A1,N),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_39_zadd__power3,axiom,
    ! [B: int,A1: int] : ( power_power(int,plus_plus(int,A1,B),number_number_of(nat,bit1(bit1(pls)))) = plus_plus(int,plus_plus(int,plus_plus(int,power_power(int,A1,number_number_of(nat,bit1(bit1(pls)))),times_times(int,times_times(int,number_number_of(int,bit1(bit1(pls))),power_power(int,A1,number_number_of(nat,bit0(bit1(pls))))),B)),times_times(int,times_times(int,number_number_of(int,bit1(bit1(pls))),A1),power_power(int,B,number_number_of(nat,bit0(bit1(pls)))))),power_power(int,B,number_number_of(nat,bit1(bit1(pls))))) ) ).

tff(fact_40_zadd__power2,axiom,
    ! [B: int,A1: int] : ( power_power(int,plus_plus(int,A1,B),number_number_of(nat,bit0(bit1(pls)))) = plus_plus(int,plus_plus(int,power_power(int,A1,number_number_of(nat,bit0(bit1(pls)))),times_times(int,times_times(int,number_number_of(int,bit0(bit1(pls))),A1),B)),power_power(int,B,number_number_of(nat,bit0(bit1(pls))))) ) ).

tff(fact_41_zdiff__power3,axiom,
    ! [B: int,A1: int] : ( power_power(int,minus_minus(int,A1,B),number_number_of(nat,bit1(bit1(pls)))) = minus_minus(int,plus_plus(int,minus_minus(int,power_power(int,A1,number_number_of(nat,bit1(bit1(pls)))),times_times(int,times_times(int,number_number_of(int,bit1(bit1(pls))),power_power(int,A1,number_number_of(nat,bit0(bit1(pls))))),B)),times_times(int,times_times(int,number_number_of(int,bit1(bit1(pls))),A1),power_power(int,B,number_number_of(nat,bit0(bit1(pls)))))),power_power(int,B,number_number_of(nat,bit1(bit1(pls))))) ) ).

tff(fact_42_zdiff__power2,axiom,
    ! [B: int,A1: int] : ( power_power(int,minus_minus(int,A1,B),number_number_of(nat,bit0(bit1(pls)))) = plus_plus(int,minus_minus(int,power_power(int,A1,number_number_of(nat,bit0(bit1(pls)))),times_times(int,times_times(int,number_number_of(int,bit0(bit1(pls))),A1),B)),power_power(int,B,number_number_of(nat,bit0(bit1(pls))))) ) ).

tff(fact_43_add__Pls__right,axiom,
    ! [K: int] : ( plus_plus(int,K,pls) = K ) ).

tff(fact_44_add__Pls,axiom,
    ! [K: int] : ( plus_plus(int,pls,K) = K ) ).

tff(fact_45_Bit0__def,axiom,
    ! [K: int] : ( bit0(K) = plus_plus(int,K,K) ) ).

tff(fact_46_diff__bin__simps_I1_J,axiom,
    ! [K: int] : ( minus_minus(int,K,pls) = K ) ).

tff(fact_47_int__distrib_I1_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( times_times(int,plus_plus(int,Z1,Z2),W) = plus_plus(int,times_times(int,Z1,W),times_times(int,Z2,W)) ) ).

tff(fact_48_int__distrib_I2_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( times_times(int,W,plus_plus(int,Z1,Z2)) = plus_plus(int,times_times(int,W,Z1),times_times(int,W,Z2)) ) ).

tff(fact_49_int__distrib_I3_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( times_times(int,minus_minus(int,Z1,Z2),W) = minus_minus(int,times_times(int,Z1,W),times_times(int,Z2,W)) ) ).

tff(fact_50_int__distrib_I4_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( times_times(int,W,minus_minus(int,Z1,Z2)) = minus_minus(int,times_times(int,W,Z1),times_times(int,W,Z2)) ) ).

tff(fact_51_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( plus_plus(A,number_number_of(A,pls),A1) = A1 ) ) ).

tff(fact_52_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( plus_plus(A,A1,number_number_of(A,pls)) = A1 ) ) ).

tff(fact_53_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,times_times(int,V,W)) = times_times(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_54_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,plus_plus(int,V,W)) = plus_plus(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_55_number__of__diff,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,minus_minus(int,V,W)) = minus_minus(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_56_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,number_number_of(A,bit1(pls)),A1) = A1 ) ) ).

tff(fact_57_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_58_add__number__of__diff1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [C: A,W: int,V: int] : ( plus_plus(A,number_number_of(A,V),minus_minus(A,number_number_of(A,W),C)) = minus_minus(A,number_number_of(A,plus_plus(int,V,W)),C) ) ) ).

tff(fact_59_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit1(bit1(pls)))) = times_times(A,times_times(A,A1,A1),A1) ) ) ).

tff(fact_60_quartic__square__square,axiom,
    ! [X: int] : ( power_power(int,power_power(int,X,number_number_of(nat,bit0(bit1(pls)))),number_number_of(nat,bit0(bit1(pls)))) = power_power(int,X,number_number_of(nat,bit0(bit0(bit1(pls))))) ) ).

tff(fact_61_semiring__mult__2,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z: A] : ( times_times(A,number_number_of(A,bit0(bit1(pls))),Z) = plus_plus(A,Z,Z) ) ) ).

tff(fact_62_mult__2,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( times_times(A,number_number_of(A,bit0(bit1(pls))),Z) = plus_plus(A,Z,Z) ) ) ).

tff(fact_63_semiring__mult__2__right,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z: A] : ( times_times(A,Z,number_number_of(A,bit0(bit1(pls)))) = plus_plus(A,Z,Z) ) ) ).

tff(fact_64_mult__2__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( times_times(A,Z,number_number_of(A,bit0(bit1(pls)))) = plus_plus(A,Z,Z) ) ) ).

tff(fact_65_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) = times_times(A,A1,A1) ) ) ).

tff(fact_66_cube__square,axiom,
    ! [A1: int] : ( times_times(int,A1,power_power(int,A1,number_number_of(nat,bit0(bit1(pls))))) = power_power(int,A1,number_number_of(nat,bit1(bit1(pls)))) ) ).

tff(fact_67_comm__semiring__1__class_Onormalizing__semiring__rules_I36_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X: A] : ( power_power(A,X,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = times_times(A,power_power(A,X,N),power_power(A,X,N)) ) ) ).

tff(fact_68_comm__semiring__1__class_Onormalizing__semiring__rules_I29_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( times_times(A,X,X) = power_power(A,X,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_69_diff__square,axiom,
    ! [Y: nat,X: nat] : ( minus_minus(nat,power_power(nat,X,number_number_of(nat,bit0(bit1(pls)))),power_power(nat,Y,number_number_of(nat,bit0(bit1(pls))))) = times_times(nat,plus_plus(nat,X,Y),minus_minus(nat,X,Y)) ) ).

tff(fact_70_four__x__squared,axiom,
    ! [X: real] : ( times_times(real,number_number_of(real,bit0(bit0(bit1(pls)))),power_power(real,X,number_number_of(nat,bit0(bit1(pls))))) = power_power(real,times_times(real,number_number_of(real,bit0(bit1(pls))),X),number_number_of(nat,bit0(bit1(pls)))) ) ).

tff(fact_71_xzgcda__linear__aux1,axiom,
    ! [N: int,D1: int,C: int,M: int,B: int,R: int,A1: int] : ( plus_plus(int,times_times(int,minus_minus(int,A1,times_times(int,R,B)),M),times_times(int,minus_minus(int,C,times_times(int,R,D1)),N)) = minus_minus(int,plus_plus(int,times_times(int,A1,M),times_times(int,C,N)),times_times(int,R,plus_plus(int,times_times(int,B,M),times_times(int,D1,N)))) ) ).

tff(fact_72_eq__add__iff1,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [D: A,B1: A,C1: A,E1: A,A2: A] :
          ( ( plus_plus(A,times_times(A,A2,E1),C1) = plus_plus(A,times_times(A,B1,E1),D) )
        <=> ( plus_plus(A,times_times(A,minus_minus(A,A2,B1),E1),C1) = D ) ) ) ).

tff(fact_73_eq__add__iff2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [D: A,B1: A,C1: A,E1: A,A2: A] :
          ( ( plus_plus(A,times_times(A,A2,E1),C1) = plus_plus(A,times_times(A,B1,E1),D) )
        <=> ( C1 = plus_plus(A,times_times(A,minus_minus(A,B1,A2),E1),D) ) ) ) ).

tff(fact_74_mult__diff__mult,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [B: A,A1: A,Y: A,X: A] : ( minus_minus(A,times_times(A,X,Y),times_times(A,A1,B)) = plus_plus(A,times_times(A,X,minus_minus(A,Y,B)),times_times(A,minus_minus(A,X,A1),B)) ) ) ).

tff(fact_75_square__diff__square__factored,axiom,
    ! [A: $tType] :
      ( comm_ring(A)
     => ! [Y: A,X: A] : ( minus_minus(A,times_times(A,X,X),times_times(A,Y,Y)) = times_times(A,plus_plus(A,X,Y),minus_minus(A,X,Y)) ) ) ).

tff(fact_76_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_77_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,B) = times_times(A,B,A1) ) ) ).

tff(fact_78_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,Lx,Ry)) ) ) ).

tff(fact_79_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),Ry) ) ) ).

tff(fact_80_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,Lx,times_times(A,Ly,Rx)) ) ) ).

tff(fact_81_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,times_times(A,Lx,Rx),Ly) ) ) ).

tff(fact_82_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Lx,times_times(A,Ly,times_times(A,Rx,Ry))) ) ) ).

tff(fact_83_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,times_times(A,Lx,Ly),Ry)) ) ) ).

tff(fact_84_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),times_times(A,Ly,Ry)) ) ) ).

tff(fact_85_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,A1: A] : ( plus_plus(A,A1,C) = plus_plus(A,C,A1) ) ) ).

tff(fact_86_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D1)) = plus_plus(A,C,plus_plus(A,A1,D1)) ) ) ).

tff(fact_87_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D1)) = plus_plus(A,plus_plus(A,A1,C),D1) ) ) ).

tff(fact_88_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_89_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,plus_plus(A,A1,C),B) ) ) ).

tff(fact_90_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),plus_plus(A,C,D1)) = plus_plus(A,plus_plus(A,A1,C),plus_plus(A,B,D1)) ) ) ).

tff(fact_91_comm__semiring__1__class_Onormalizing__semiring__rules_I31_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,P: nat,X: A] : ( power_power(A,power_power(A,X,P),Q) = power_power(A,X,times_times(nat,P,Q)) ) ) ).

tff(fact_92_comm__semiring__1__class_Onormalizing__semiring__rules_I34_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Z: A,Y: A,X: A] : ( times_times(A,X,plus_plus(A,Y,Z)) = plus_plus(A,times_times(A,X,Y),times_times(A,X,Z)) ) ) ).

tff(fact_93_crossproduct__noteq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [D: A,C1: A,B1: A,A2: A] :
          ( ( ( A2 != B1 )
            & ( C1 != D ) )
        <=> ( plus_plus(A,times_times(A,A2,C1),times_times(A,B1,D)) != plus_plus(A,times_times(A,A2,D),times_times(A,B1,C1)) ) ) ) ).

tff(fact_94_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( comm_semiring(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,plus_plus(A,A1,B),C) = plus_plus(A,times_times(A,A1,C),times_times(A,B,C)) ) ) ).

tff(fact_95_comm__semiring__1__class_Onormalizing__semiring__rules_I8_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,plus_plus(A,A1,B),C) = plus_plus(A,times_times(A,A1,C),times_times(A,B,C)) ) ) ).

tff(fact_96_comm__semiring__1__class_Onormalizing__semiring__rules_I1_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,M: A,A1: A] : ( plus_plus(A,times_times(A,A1,M),times_times(A,B,M)) = times_times(A,plus_plus(A,A1,B),M) ) ) ).

tff(fact_97_combine__common__factor,axiom,
    ! [A: $tType] :
      ( semiring(A)
     => ! [C: A,B: A,E: A,A1: A] : ( plus_plus(A,times_times(A,A1,E),plus_plus(A,times_times(A,B,E),C)) = plus_plus(A,times_times(A,plus_plus(A,A1,B),E),C) ) ) ).

%----Arities (29)
tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring,axiom,
    comm_semiring(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Ocomm__ring,axiom,
    comm_ring(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring,axiom,
    comm_semiring(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_RealDef_Oreal___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring,axiom,
    comm_semiring(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__semiring,axiom,
    number_semiring(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__mult,axiom,
    monoid_mult(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__ring,axiom,
    comm_ring(real) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring,axiom,
    semiring(real) ).

tff(arity_RealDef_Oreal___Rings_Oring,axiom,
    ring(real) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    times_times(int,plus_plus(int,power_power(int,x,number_number_of(nat,bit0(bit1(pls)))),power_power(int,y,number_number_of(nat,bit0(bit1(pls))))),plus_plus(int,power_power(int,v,number_number_of(nat,bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls)))))) = plus_plus(int,power_power(int,plus_plus(int,times_times(int,x,v),times_times(int,y,w)),number_number_of(nat,bit0(bit1(pls)))),power_power(int,minus_minus(int,times_times(int,x,w),times_times(int,y,v)),number_number_of(nat,bit0(bit1(pls))))) ).

%------------------------------------------------------------------------------
