%------------------------------------------------------------------------------
% File     : NUM996_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 158
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : s2s_158 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  175 (  73 unt;  33 typ;   0 def)
%            Number of atoms       :  226 ( 115 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   92 (   8   ~;   1   |;   5   &)
%                                         (  11 <=>;  67  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   3 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   11 (   8   >;   3   *;   0   +;   0  <<)
%            Number of predicates  :   18 (  17 usr;   0 prp; 1-2 aty)
%            Number of functors    :   12 (  12 usr;   5 con; 0-3 aty)
%            Number of variables   :  288 ( 267   !;   0   ?; 288   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:41
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

%----Explicit typings (29)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add__abs,type,
    ordere142940540dd_abs: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oab__semigroup__idem__mult,type,
    ab_sem1668676832m_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oabs__class_Oabs,type,
    abs_abs: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_v____,type,
    v: int ).

tff(sy_v_w____,type,
    w: int ).

%----Relevant facts (98)
tff(fact_0_power2__eq__square__number__of,axiom,
    ! [B2: $tType] :
      ( ( monoid_mult(B2)
        & number(B2) )
     => ! [W: int] : ( power_power(B2,number_number_of(B2,W),number_number_of(nat,bit0(bit1(pls)))) = times_times(B2,number_number_of(B2,W),number_number_of(B2,W)) ) ) ).

tff(fact_1_abs__power2,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ( abs_abs(A,power_power(A,A1,number_number_of(nat,bit0(bit1(pls))))) = power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_2_power2__abs,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ( power_power(A,abs_abs(A,A1),number_number_of(nat,bit0(bit1(pls)))) = power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_3_mult__Bit1,axiom,
    ! [L: int,K: int] : ( times_times(int,bit1(K),L) = plus_plus(int,bit0(times_times(int,K,L)),L) ) ).

tff(fact_4_zadd__power2,axiom,
    ! [B: int,A1: int] : ( power_power(int,plus_plus(int,A1,B),number_number_of(nat,bit0(bit1(pls)))) = plus_plus(int,plus_plus(int,power_power(int,A1,number_number_of(nat,bit0(bit1(pls)))),times_times(int,times_times(int,number_number_of(int,bit0(bit1(pls))),A1),B)),power_power(int,B,number_number_of(nat,bit0(bit1(pls))))) ) ).

tff(fact_5_zadd__power3,axiom,
    ! [B: int,A1: int] : ( power_power(int,plus_plus(int,A1,B),number_number_of(nat,bit1(bit1(pls)))) = plus_plus(int,plus_plus(int,plus_plus(int,power_power(int,A1,number_number_of(nat,bit1(bit1(pls)))),times_times(int,times_times(int,number_number_of(int,bit1(bit1(pls))),power_power(int,A1,number_number_of(nat,bit0(bit1(pls))))),B)),times_times(int,times_times(int,number_number_of(int,bit1(bit1(pls))),A1),power_power(int,B,number_number_of(nat,bit0(bit1(pls)))))),power_power(int,B,number_number_of(nat,bit1(bit1(pls))))) ) ).

tff(fact_6_power2__sum,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Y: A,X: A] : ( power_power(A,plus_plus(A,X,Y),number_number_of(nat,bit0(bit1(pls)))) = plus_plus(A,plus_plus(A,power_power(A,X,number_number_of(nat,bit0(bit1(pls)))),power_power(A,Y,number_number_of(nat,bit0(bit1(pls))))),times_times(A,times_times(A,number_number_of(A,bit0(bit1(pls))),X),Y)) ) ) ).

tff(fact_7_add__Bit0__Bit1,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit0(K),bit1(L)) = bit1(plus_plus(int,K,L)) ) ).

tff(fact_8_add__Bit1__Bit0,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit1(K),bit0(L)) = bit1(plus_plus(int,K,L)) ) ).

tff(fact_9_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( plus_plus(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,plus_plus(int,V,W)) ) ) ).

tff(fact_10_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z1: A,W: int,V: int] : ( plus_plus(A,number_number_of(A,V),plus_plus(A,number_number_of(A,W),Z1)) = plus_plus(A,number_number_of(A,plus_plus(int,V,W)),Z1) ) ) ).

tff(fact_11_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,times_times(int,V,W)) ) ) ).

tff(fact_12_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Ya: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Ya) )
        <=> ( Xa = Ya ) ) ) ).

tff(fact_13_rel__simps_I51_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit1(K1) = bit1(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_14_rel__simps_I48_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit0(K1) = bit0(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_15_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_16_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_17_rel__simps_I50_J,axiom,
    ! [L: int,K: int] : ( bit1(K) != bit0(L) ) ).

tff(fact_18_rel__simps_I49_J,axiom,
    ! [L: int,K: int] : ( bit0(K) != bit1(L) ) ).

tff(fact_19_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_20_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_21_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_22_mult__Pls,axiom,
    ! [W: int] : ( times_times(int,pls,W) = pls ) ).

tff(fact_23_mult__Bit0,axiom,
    ! [L: int,K: int] : ( times_times(int,bit0(K),L) = bit0(times_times(int,K,L)) ) ).

tff(fact_24_add__Bit0__Bit0,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit0(K),bit0(L)) = bit0(plus_plus(int,K,L)) ) ).

tff(fact_25_left__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & semiring(B2) )
     => ! [V: int,B: B2,A1: B2] : ( times_times(B2,plus_plus(B2,A1,B),number_number_of(B2,V)) = plus_plus(B2,times_times(B2,A1,number_number_of(B2,V)),times_times(B2,B,number_number_of(B2,V))) ) ) ).

tff(fact_26_right__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & semiring(B2) )
     => ! [C: B2,B: B2,V: int] : ( times_times(B2,number_number_of(B2,V),plus_plus(B2,B,C)) = plus_plus(B2,times_times(B2,number_number_of(B2,V),B),times_times(B2,number_number_of(B2,V),C)) ) ) ).

tff(fact_27_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z1: A,W: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W),Z1)) = times_times(A,number_number_of(A,times_times(int,V,W)),Z1) ) ) ).

tff(fact_28_zpower__zpower,axiom,
    ! [Z1: nat,Y: nat,X: int] : ( power_power(int,power_power(int,X,Y),Z1) = power_power(int,X,times_times(nat,Y,Z1)) ) ).

tff(fact_29_nat__mult__2,axiom,
    ! [Z1: nat] : ( times_times(nat,number_number_of(nat,bit0(bit1(pls))),Z1) = plus_plus(nat,Z1,Z1) ) ).

tff(fact_30_nat__mult__2__right,axiom,
    ! [Z1: nat] : ( times_times(nat,Z1,number_number_of(nat,bit0(bit1(pls)))) = plus_plus(nat,Z1,Z1) ) ).

tff(fact_31_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [Xa: A,Wa: int] :
          ( ( number_number_of(A,Wa) = Xa )
        <=> ( Xa = number_number_of(A,Wa) ) ) ) ).

tff(fact_32_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_33_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = power_power(A,power_power(A,A1,N),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_34_add__Pls__right,axiom,
    ! [K: int] : ( plus_plus(int,K,pls) = K ) ).

tff(fact_35_add__Pls,axiom,
    ! [K: int] : ( plus_plus(int,pls,K) = K ) ).

tff(fact_36_Bit0__def,axiom,
    ! [K: int] : ( bit0(K) = plus_plus(int,K,K) ) ).

tff(fact_37_times__numeral__code_I5_J,axiom,
    ! [W: int,V: int] : ( times_times(int,number_number_of(int,V),number_number_of(int,W)) = number_number_of(int,times_times(int,V,W)) ) ).

tff(fact_38_int__distrib_I1_J,axiom,
    ! [W: int,Z2: int,Z11: int] : ( times_times(int,plus_plus(int,Z11,Z2),W) = plus_plus(int,times_times(int,Z11,W),times_times(int,Z2,W)) ) ).

tff(fact_39_int__distrib_I2_J,axiom,
    ! [Z2: int,Z11: int,W: int] : ( times_times(int,W,plus_plus(int,Z11,Z2)) = plus_plus(int,times_times(int,W,Z11),times_times(int,W,Z2)) ) ).

tff(fact_40_plus__numeral__code_I9_J,axiom,
    ! [W: int,V: int] : ( plus_plus(int,number_number_of(int,V),number_number_of(int,W)) = number_number_of(int,plus_plus(int,V,W)) ) ).

tff(fact_41_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( plus_plus(A,number_number_of(A,pls),A1) = A1 ) ) ).

tff(fact_42_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( plus_plus(A,A1,number_number_of(A,pls)) = A1 ) ) ).

tff(fact_43_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,times_times(int,V,W)) = times_times(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_44_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,plus_plus(int,V,W)) = plus_plus(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_45_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,number_number_of(A,bit1(pls)),A1) = A1 ) ) ).

tff(fact_46_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_47_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit1(bit1(pls)))) = times_times(A,times_times(A,A1,A1),A1) ) ) ).

tff(fact_48_quartic__square__square,axiom,
    ! [X: int] : ( power_power(int,power_power(int,X,number_number_of(nat,bit0(bit1(pls)))),number_number_of(nat,bit0(bit1(pls)))) = power_power(int,X,number_number_of(nat,bit0(bit0(bit1(pls))))) ) ).

tff(fact_49_abs__power3__distrib,axiom,
    ! [X: int] : ( abs_abs(int,power_power(int,X,number_number_of(nat,bit1(bit1(pls))))) = power_power(int,abs_abs(int,X),number_number_of(nat,bit1(bit1(pls)))) ) ).

tff(fact_50_semiring__mult__2,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z1: A] : ( times_times(A,number_number_of(A,bit0(bit1(pls))),Z1) = plus_plus(A,Z1,Z1) ) ) ).

tff(fact_51_mult__2,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z1: A] : ( times_times(A,number_number_of(A,bit0(bit1(pls))),Z1) = plus_plus(A,Z1,Z1) ) ) ).

tff(fact_52_semiring__mult__2__right,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z1: A] : ( times_times(A,Z1,number_number_of(A,bit0(bit1(pls)))) = plus_plus(A,Z1,Z1) ) ) ).

tff(fact_53_mult__2__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z1: A] : ( times_times(A,Z1,number_number_of(A,bit0(bit1(pls)))) = plus_plus(A,Z1,Z1) ) ) ).

tff(fact_54_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) = times_times(A,A1,A1) ) ) ).

tff(fact_55_cube__square,axiom,
    ! [A1: int] : ( times_times(int,A1,power_power(int,A1,number_number_of(nat,bit0(bit1(pls))))) = power_power(int,A1,number_number_of(nat,bit1(bit1(pls)))) ) ).

tff(fact_56_power2__eq__iff__abs__eq,axiom,
    ! [B1: int,A2: int] :
      ( ( power_power(int,A2,number_number_of(nat,bit0(bit1(pls)))) = power_power(int,B1,number_number_of(nat,bit0(bit1(pls)))) )
    <=> ( abs_abs(int,A2) = abs_abs(int,B1) ) ) ).

tff(fact_57_abs__power2__distrib,axiom,
    ! [A1: int] : ( abs_abs(int,power_power(int,A1,number_number_of(nat,bit0(bit1(pls))))) = power_power(int,abs_abs(int,A1),number_number_of(nat,bit0(bit1(pls)))) ) ).

tff(fact_58_comm__semiring__1__class_Onormalizing__semiring__rules_I36_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X: A] : ( power_power(A,X,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = times_times(A,power_power(A,X,N),power_power(A,X,N)) ) ) ).

tff(fact_59_comm__semiring__1__class_Onormalizing__semiring__rules_I29_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( times_times(A,X,X) = power_power(A,X,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_60_abs__add__abs,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [B: A,A1: A] : ( abs_abs(A,plus_plus(A,abs_abs(A,A1),abs_abs(A,B))) = plus_plus(A,abs_abs(A,A1),abs_abs(A,B)) ) ) ).

tff(fact_61_abs__mult__self,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ( times_times(A,abs_abs(A,A1),abs_abs(A,A1)) = times_times(A,A1,A1) ) ) ).

tff(fact_62_four__x__squared,axiom,
    ! [X: real] : ( times_times(real,number_number_of(real,bit0(bit0(bit1(pls)))),power_power(real,X,number_number_of(nat,bit0(bit1(pls))))) = power_power(real,times_times(real,number_number_of(real,bit0(bit1(pls))),X),number_number_of(nat,bit0(bit1(pls)))) ) ).

tff(fact_63_abs__idempotent,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A1: A] : ( abs_abs(A,abs_abs(A,A1)) = abs_abs(A,A1) ) ) ).

tff(fact_64_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B1: A] :
          ( ( plus_plus(A,B1,A2) = plus_plus(A,C1,A2) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_65_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( plus_plus(A,A2,B1) = plus_plus(A,A2,C1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_66_mult__left__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,times_times(A,A1,B)) = times_times(A,A1,B) ) ) ).

tff(fact_67_times_Oidem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [A1: A] : ( times_times(A,A1,A1) = A1 ) ) ).

tff(fact_68_mult__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [X: A] : ( times_times(A,X,X) = X ) ) ).

tff(fact_69_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,B) = times_times(A,B,A1) ) ) ).

tff(fact_70_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,Lx,Ry)) ) ) ).

tff(fact_71_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),Ry) ) ) ).

tff(fact_72_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,times_times(A,A1,B),C) = times_times(A,A1,times_times(A,B,C)) ) ) ).

tff(fact_73_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,Lx,times_times(A,Ly,Rx)) ) ) ).

tff(fact_74_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,times_times(A,Lx,Rx),Ly) ) ) ).

tff(fact_75_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Lx,times_times(A,Ly,times_times(A,Rx,Ry))) ) ) ).

tff(fact_76_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,times_times(A,Lx,Ly),Ry)) ) ) ).

tff(fact_77_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),times_times(A,Ly,Ry)) ) ) ).

tff(fact_78_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,A1: A] : ( plus_plus(A,A1,C) = plus_plus(A,C,A1) ) ) ).

tff(fact_79_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D1)) = plus_plus(A,C,plus_plus(A,A1,D1)) ) ) ).

tff(fact_80_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D1)) = plus_plus(A,plus_plus(A,A1,C),D1) ) ) ).

tff(fact_81_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_82_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_83_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,plus_plus(A,A1,C),B) ) ) ).

tff(fact_84_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),plus_plus(A,C,D1)) = plus_plus(A,plus_plus(A,A1,C),plus_plus(A,B,D1)) ) ) ).

tff(fact_85_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_86_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_87_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C,A1) )
         => ( B = C ) ) ) ).

tff(fact_88_comm__semiring__1__class_Onormalizing__semiring__rules_I31_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,P: nat,X: A] : ( power_power(A,power_power(A,X,P),Q) = power_power(A,X,times_times(nat,P,Q)) ) ) ).

tff(fact_89_comm__semiring__1__class_Onormalizing__semiring__rules_I34_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Z1: A,Y: A,X: A] : ( times_times(A,X,plus_plus(A,Y,Z1)) = plus_plus(A,times_times(A,X,Y),times_times(A,X,Z1)) ) ) ).

tff(fact_90_crossproduct__noteq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [D: A,C1: A,B1: A,A2: A] :
          ( ( ( A2 != B1 )
            & ( C1 != D ) )
        <=> ( plus_plus(A,times_times(A,A2,C1),times_times(A,B1,D)) != plus_plus(A,times_times(A,A2,D),times_times(A,B1,C1)) ) ) ) ).

tff(fact_91_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( comm_semiring(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,plus_plus(A,A1,B),C) = plus_plus(A,times_times(A,A1,C),times_times(A,B,C)) ) ) ).

tff(fact_92_comm__semiring__1__class_Onormalizing__semiring__rules_I8_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,plus_plus(A,A1,B),C) = plus_plus(A,times_times(A,A1,C),times_times(A,B,C)) ) ) ).

tff(fact_93_comm__semiring__1__class_Onormalizing__semiring__rules_I1_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,M: A,A1: A] : ( plus_plus(A,times_times(A,A1,M),times_times(A,B,M)) = times_times(A,plus_plus(A,A1,B),M) ) ) ).

tff(fact_94_combine__common__factor,axiom,
    ! [A: $tType] :
      ( semiring(A)
     => ! [C: A,B: A,E: A,A1: A] : ( plus_plus(A,times_times(A,A1,E),plus_plus(A,times_times(A,B,E),C)) = plus_plus(A,times_times(A,plus_plus(A,A1,B),E),C) ) ) ).

tff(fact_95_crossproduct__eq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [Z: A,Xa: A,Ya: A,Wa: A] :
          ( ( plus_plus(A,times_times(A,Wa,Ya),times_times(A,Xa,Z)) = plus_plus(A,times_times(A,Wa,Z),times_times(A,Xa,Ya)) )
        <=> ( ( Wa = Xa )
            | ( Ya = Z ) ) ) ) ).

tff(fact_96_comm__semiring__1__class_Onormalizing__semiring__rules_I30_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,Y: A,X: A] : ( power_power(A,times_times(A,X,Y),Q) = times_times(A,power_power(A,X,Q),power_power(A,Y,Q)) ) ) ).

tff(fact_97_comm__semiring__1__class_Onormalizing__semiring__rules_I26_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,P: nat,X: A] : ( times_times(A,power_power(A,X,P),power_power(A,X,Q)) = power_power(A,X,plus_plus(nat,P,Q)) ) ) ).

%----Arities (41)
tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Oordered__ab__group__add__abs,axiom,
    ordere142940540dd_abs(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring,axiom,
    comm_semiring(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring,axiom,
    comm_semiring(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_RealDef_Oreal___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(real) ).

tff(arity_RealDef_Oreal___Groups_Oordered__ab__group__add__abs,axiom,
    ordere142940540dd_abs(real) ).

tff(arity_RealDef_Oreal___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(real) ).

tff(arity_RealDef_Oreal___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(real) ).

tff(arity_RealDef_Oreal___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(real) ).

tff(arity_RealDef_Oreal___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring,axiom,
    comm_semiring(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__semiring,axiom,
    number_semiring(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__mult,axiom,
    monoid_mult(real) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring,axiom,
    semiring(real) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),power_power(int,v,number_number_of(nat,bit0(bit1(pls))))),times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),power_power(int,w,number_number_of(nat,bit0(bit1(pls)))))) = plus_plus(int,power_power(int,times_times(int,number_number_of(int,bit0(bit1(pls))),abs_abs(int,v)),number_number_of(nat,bit0(bit1(pls)))),power_power(int,times_times(int,number_number_of(int,bit0(bit1(pls))),abs_abs(int,w)),number_number_of(nat,bit0(bit1(pls))))) ).

%------------------------------------------------------------------------------
