%------------------------------------------------------------------------------
% File     : NUM991_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 152
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : s2s_152 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  168 (  61 unt;  34 typ;   0 def)
%            Number of atoms       :  260 (  77 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  151 (  25   ~;   4   |;   4   &)
%                                         (  29 <=>;  89  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   4 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   13 (   7   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   19 (  18 usr;   0 prp; 1-3 aty)
%            Number of functors    :   13 (  13 usr;   6 con; 0-4 aty)
%            Number of variables   :  246 ( 220   !;   2   ?; 246   :)
%                                         (  24  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:29
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (30)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_m1____,type,
    m1: int ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_t____,type,
    t: int ).

tff(sy_v_tn____,type,
    tn: nat ).

%----Relevant facts (98)
tff(fact_0_n1pos,axiom,
    ord_less(int,zero_zero(int),plus_plus(int,one_one(int),semiring_1_of_nat(int,n))) ).

tff(fact_1_t1,axiom,
    ord_less(int,one_one(int),t) ).

tff(fact_2__096_126_Am1_A_060_A1_A_L_Aint_An_096,axiom,
    ~ ord_less(int,m1,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))) ).

tff(fact_3_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,Na))
        <=> ord_less(nat,zero_zero(nat),Na) ) ) ).

tff(fact_4_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,A2,A2))
        <=> ord_less(A,zero_zero(A),A2) ) ) ).

tff(fact_5_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,plus_plus(A,A2,A2),zero_zero(A))
        <=> ord_less(A,A2,zero_zero(A)) ) ) ).

tff(fact_6_of__nat__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,one_one(nat)) = one_one(A) ) ) ).

tff(fact_7_of__nat__add,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [N1: nat,M: nat] : ( semiring_1_of_nat(A,plus_plus(nat,M,N1)) = plus_plus(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N1)) ) ) ).

tff(fact_8_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,Ma: nat] :
          ( ord_less(A,semiring_1_of_nat(A,Ma),semiring_1_of_nat(A,Na))
        <=> ord_less(nat,Ma,Na) ) ) ).

tff(fact_9_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_10_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,C1: A,A2: A] :
          ( ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B1,C1))
        <=> ord_less(A,A2,B1) ) ) ).

tff(fact_11_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,A2: A,C1: A] :
          ( ord_less(A,plus_plus(A,C1,A2),plus_plus(A,C1,B1))
        <=> ord_less(A,A2,B1) ) ) ).

tff(fact_12_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( zero_zero(A) = plus_plus(A,A2,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_13_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( plus_plus(A,A2,A2) = zero_zero(A) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_14_odd__less__0__iff,axiom,
    ! [Z: int] :
      ( ord_less(int,plus_plus(int,plus_plus(int,one_one(int),Z),Z),zero_zero(int))
    <=> ord_less(int,Z,zero_zero(int)) ) ).

tff(fact_15_tn0,axiom,
    ord_less(nat,zero_zero(nat),tn) ).

tff(fact_16_n0,axiom,
    ord_less(nat,zero_zero(nat),n) ).

tff(fact_17_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B1: A] :
          ( ( plus_plus(A,B1,A2) = plus_plus(A,C1,A2) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_18_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( plus_plus(A,A2,B1) = plus_plus(A,A2,C1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_19_nat__add__left__cancel,axiom,
    ! [Na: nat,Ma: nat,K1: nat] :
      ( ( plus_plus(nat,K1,Ma) = plus_plus(nat,K1,Na) )
    <=> ( Ma = Na ) ) ).

tff(fact_20_nat__add__right__cancel,axiom,
    ! [Na: nat,K1: nat,Ma: nat] :
      ( ( plus_plus(nat,Ma,K1) = plus_plus(nat,Na,K1) )
    <=> ( Ma = Na ) ) ).

tff(fact_21_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [Na: nat,Ma: nat] :
          ( ( semiring_1_of_nat(A,Ma) = semiring_1_of_nat(A,Na) )
        <=> ( Ma = Na ) ) ) ).

tff(fact_22_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_23_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_24_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_25_add__is__0,axiom,
    ! [Na: nat,Ma: nat] :
      ( ( plus_plus(nat,Ma,Na) = zero_zero(nat) )
    <=> ( ( Ma = zero_zero(nat) )
        & ( Na = zero_zero(nat) ) ) ) ).

tff(fact_26_nat__add__left__cancel__less,axiom,
    ! [Na: nat,Ma: nat,K1: nat] :
      ( ord_less(nat,plus_plus(nat,K1,Ma),plus_plus(nat,K1,Na))
    <=> ord_less(nat,Ma,Na) ) ).

tff(fact_27_add__gr__0,axiom,
    ! [Na: nat,Ma: nat] :
      ( ord_less(nat,zero_zero(nat),plus_plus(nat,Ma,Na))
    <=> ( ord_less(nat,zero_zero(nat),Ma)
        | ord_less(nat,zero_zero(nat),Na) ) ) ).

tff(fact_28_not__less0,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_29_less__not__refl,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_30_not__add__less1,axiom,
    ! [J: nat,I: nat] : ~ ord_less(nat,plus_plus(nat,I,J),I) ).

tff(fact_31_not__add__less2,axiom,
    ! [I: nat,J: nat] : ~ ord_less(nat,plus_plus(nat,J,I),I) ).

tff(fact_32_nat__neq__iff,axiom,
    ! [Na: nat,Ma: nat] :
      ( ( Ma != Na )
    <=> ( ord_less(nat,Ma,Na)
        | ord_less(nat,Na,Ma) ) ) ).

tff(fact_33_plus__nat_Oadd__0,axiom,
    ! [N1: nat] : ( plus_plus(nat,zero_zero(nat),N1) = N1 ) ).

tff(fact_34_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( plus_plus(nat,M,zero_zero(nat)) = M ) ).

tff(fact_35_nat__add__commute,axiom,
    ! [N1: nat,M: nat] : ( plus_plus(nat,M,N1) = plus_plus(nat,N1,M) ) ).

tff(fact_36_nat__add__left__commute,axiom,
    ! [Z1: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z1)) = plus_plus(nat,Y,plus_plus(nat,X,Z1)) ) ).

tff(fact_37_nat__add__assoc,axiom,
    ! [K2: nat,N1: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N1),K2) = plus_plus(nat,M,plus_plus(nat,N1,K2)) ) ).

tff(fact_38_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_39_less__irrefl__nat,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_40_gr__implies__not0,axiom,
    ! [N1: nat,M: nat] :
      ( ord_less(nat,M,N1)
     => ( N1 != zero_zero(nat) ) ) ).

tff(fact_41_less__not__refl2,axiom,
    ! [M: nat,N1: nat] :
      ( ord_less(nat,N1,M)
     => ( M != N1 ) ) ).

tff(fact_42_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_43_trans__less__add1,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,J,M)) ) ).

tff(fact_44_trans__less__add2,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,M,J)) ) ).

tff(fact_45_add__less__mono1,axiom,
    ! [K2: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,plus_plus(nat,I,K2),plus_plus(nat,J,K2)) ) ).

tff(fact_46_add__less__mono,axiom,
    ! [L: nat,K2: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ( ord_less(nat,K2,L)
       => ord_less(nat,plus_plus(nat,I,K2),plus_plus(nat,J,L)) ) ) ).

tff(fact_47_less__add__eq__less,axiom,
    ! [N1: nat,M: nat,L: nat,K2: nat] :
      ( ord_less(nat,K2,L)
     => ( ( plus_plus(nat,M,L) = plus_plus(nat,K2,N1) )
       => ord_less(nat,M,N1) ) ) ).

tff(fact_48_add__eq__self__zero,axiom,
    ! [N1: nat,M: nat] :
      ( ( plus_plus(nat,M,N1) = M )
     => ( N1 = zero_zero(nat) ) ) ).

tff(fact_49_add__lessD1,axiom,
    ! [K2: nat,J: nat,I: nat] :
      ( ord_less(nat,plus_plus(nat,I,J),K2)
     => ord_less(nat,I,K2) ) ).

tff(fact_50_gr0I,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_51_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,Ma: nat] :
      ( ( ord_less(nat,Ma,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),Ma)) )
     => ( ( ( Ma = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),Ma)) )
       => ( ( ord_less(nat,Na,Ma)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),Ma)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),Ma)) ) ) ) ).

tff(fact_52_zero__less__int__conv,axiom,
    ! [Na: nat] :
      ( ord_less(int,zero_zero(int),semiring_1_of_nat(int,Na))
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_53_zadd__int__left,axiom,
    ! [Z1: int,N1: nat,M: nat] : ( plus_plus(int,semiring_1_of_nat(int,M),plus_plus(int,semiring_1_of_nat(int,N1),Z1)) = plus_plus(int,semiring_1_of_nat(int,plus_plus(nat,M,N1)),Z1) ) ).

tff(fact_54_zadd__int,axiom,
    ! [N1: nat,M: nat] : ( plus_plus(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,N1)) = semiring_1_of_nat(int,plus_plus(nat,M,N1)) ) ).

tff(fact_55_zless__int,axiom,
    ! [Na: nat,Ma: nat] :
      ( ord_less(int,semiring_1_of_nat(int,Ma),semiring_1_of_nat(int,Na))
    <=> ord_less(nat,Ma,Na) ) ).

tff(fact_56_int__1,axiom,
    semiring_1_of_nat(int,one_one(nat)) = one_one(int) ).

tff(fact_57_int__eq__0__conv,axiom,
    ! [Na: nat] :
      ( ( semiring_1_of_nat(int,Na) = zero_zero(int) )
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_58_int__0,axiom,
    semiring_1_of_nat(int,zero_zero(nat)) = zero_zero(int) ).

tff(fact_59_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_60_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C,A1) )
         => ( B = C ) ) ) ).

tff(fact_61_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_62_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_63_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_64_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [Xa: A] :
          ( ( one_one(A) = Xa )
        <=> ( Xa = one_one(A) ) ) ) ).

tff(fact_65_int__int__eq,axiom,
    ! [Na: nat,Ma: nat] :
      ( ( semiring_1_of_nat(int,Ma) = semiring_1_of_nat(int,Na) )
    <=> ( Ma = Na ) ) ).

tff(fact_66_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_67_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_68_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_69_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_70_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B))
         => ord_less(A,A1,B) ) ) ).

tff(fact_71_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C))
         => ord_less(A,A1,B) ) ) ).

tff(fact_72_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,C,D)
           => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,D)) ) ) ) ).

tff(fact_73_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B)) ) ) ).

tff(fact_74_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C)) ) ) ).

tff(fact_75_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N1))
         => ord_less(nat,M,N1) ) ) ).

tff(fact_76_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M: nat] :
          ( ord_less(nat,M,N1)
         => ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N1)) ) ) ).

tff(fact_77_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,zero_zero(A))
         => ( ord_less(A,B,zero_zero(A))
           => ord_less(A,plus_plus(A,A1,B),zero_zero(A)) ) ) ) ).

tff(fact_78_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,zero_zero(A),B)
           => ord_less(A,zero_zero(A),plus_plus(A,A1,B)) ) ) ) ).

tff(fact_79_even__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( ord_less(A,plus_plus(A,A2,A2),zero_zero(A))
        <=> ord_less(A,A2,zero_zero(A)) ) ) ).

tff(fact_80_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ~ ord_less(A,semiring_1_of_nat(A,M),zero_zero(A)) ) ).

tff(fact_81_odd__nonzero,axiom,
    ! [Z1: int] : ( plus_plus(int,plus_plus(int,one_one(int),Z1),Z1) != zero_zero(int) ) ).

tff(fact_82_zless__add1__eq,axiom,
    ! [Z: int,Wa: int] :
      ( ord_less(int,Wa,plus_plus(int,Z,one_one(int)))
    <=> ( ord_less(int,Wa,Z)
        | ( Wa = Z ) ) ) ).

tff(fact_83_int__less__0__conv,axiom,
    ! [K2: nat] : ~ ord_less(int,semiring_1_of_nat(int,K2),zero_zero(int)) ).

tff(fact_84_zero__less__imp__eq__int,axiom,
    ! [K2: int] :
      ( ord_less(int,zero_zero(int),K2)
     => ? [N: nat] :
          ( ord_less(nat,zero_zero(nat),N)
          & ( K2 = semiring_1_of_nat(int,N) ) ) ) ).

tff(fact_85_zero__less__two,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),plus_plus(A,one_one(A),one_one(A))) ) ).

tff(fact_86_int__gr__induct,axiom,
    ! [P1: fun(int,bool),I1: int,K1: int] :
      ( ord_less(int,K1,I1)
     => ( pp(aa(int,bool,P1,plus_plus(int,K1,one_one(int))))
       => ( ! [I2: int] :
              ( ord_less(int,K1,I2)
             => ( pp(aa(int,bool,P1,I2))
               => pp(aa(int,bool,P1,plus_plus(int,I2,one_one(int)))) ) )
         => pp(aa(int,bool,P1,I1)) ) ) ) ).

tff(fact_87_less__imp__add__positive,axiom,
    ! [J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ? [K: nat] :
          ( ord_less(nat,zero_zero(nat),K)
          & ( plus_plus(nat,I,K) = J ) ) ) ).

tff(fact_88_transfer__int__nat__numerals_I2_J,axiom,
    one_one(int) = semiring_1_of_nat(int,one_one(nat)) ).

tff(fact_89_Nat__Transfer_Otransfer__int__nat__functions_I1_J,axiom,
    ! [Y: nat,X: nat] : ( plus_plus(int,semiring_1_of_nat(int,X),semiring_1_of_nat(int,Y)) = semiring_1_of_nat(int,plus_plus(nat,X,Y)) ) ).

tff(fact_90_Nat__Transfer_Otransfer__int__nat__relations_I2_J,axiom,
    ! [Ya: nat,Xa: nat] :
      ( ord_less(int,semiring_1_of_nat(int,Xa),semiring_1_of_nat(int,Ya))
    <=> ord_less(nat,Xa,Ya) ) ).

tff(fact_91_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = semiring_1_of_nat(int,zero_zero(nat)) ).

tff(fact_92_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_93_Nat__Transfer_Otransfer__int__nat__relations_I1_J,axiom,
    ! [Ya: nat,Xa: nat] :
      ( ( semiring_1_of_nat(int,Xa) = semiring_1_of_nat(int,Ya) )
    <=> ( Xa = Ya ) ) ).

tff(fact_94_int__if__cong,axiom,
    ! [Ya: nat,Xa: nat,P1: bool] :
      ( ( pp(P1)
       => ( semiring_1_of_nat(int,Xa) = semiring_1_of_nat(int,if(nat,P1,Xa,Ya)) ) )
      & ( ~ pp(P1)
       => ( semiring_1_of_nat(int,Ya) = semiring_1_of_nat(int,if(nat,P1,Xa,Ya)) ) ) ) ).

tff(fact_95_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_96_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_97_pos__add__strict,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,B,C)
           => ord_less(A,B,plus_plus(A,A1,C)) ) ) ) ).

%----Arities (30)
tff(arity_Int_Oint___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(int) ).

tff(arity_Int_Oint___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(int) ).

tff(arity_Int_Oint___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (5)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ord_less(int,zero_zero(int),plus_plus(int,one_one(int),semiring_1_of_nat(int,n))) ).

%------------------------------------------------------------------------------
