%------------------------------------------------------------------------------
% File     : NUM987_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 148
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : s2s_148 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  168 (  57 unt;  35 typ;   0 def)
%            Number of atoms       :  264 (  60 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  152 (  21   ~;   3   |;   1   &)
%                                         (  34 <=>;  93  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   4 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   12 (   7   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :   21 (  20 usr;   0 prp; 1-3 aty)
%            Number of functors    :   12 (  12 usr;   6 con; 0-4 aty)
%            Number of variables   :  251 ( 226   !;   0   ?; 251   :)
%                                         (  25  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:20
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (31)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_m1____,type,
    m1: int ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_t____,type,
    t: int ).

tff(sy_v_tn____,type,
    tn: nat ).

%----Relevant facts (98)
tff(fact_0_t1,axiom,
    ord_less(int,one_one(int),t) ).

tff(fact_1_n1pos,axiom,
    ord_less(int,zero_zero(int),plus_plus(int,one_one(int),semiring_1_of_nat(int,n))) ).

tff(fact_2_of__nat__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,one_one(nat)) = one_one(A) ) ) ).

tff(fact_3_of__nat__add,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [N: nat,M: nat] : ( semiring_1_of_nat(A,plus_plus(nat,M,N)) = plus_plus(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N)) ) ) ).

tff(fact_4_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,Ma: nat] :
          ( ord_less(A,semiring_1_of_nat(A,Ma),semiring_1_of_nat(A,Na))
        <=> ord_less(nat,Ma,Na) ) ) ).

tff(fact_5_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C))
        <=> ord_less(A,A1,B) ) ) ).

tff(fact_6_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B))
        <=> ord_less(A,A1,B) ) ) ).

tff(fact_7_zless__add1__eq,axiom,
    ! [Z: int,Wa: int] :
      ( ord_less(int,Wa,plus_plus(int,Z,one_one(int)))
    <=> ( ord_less(int,Wa,Z)
        | ( Wa = Z ) ) ) ).

tff(fact_8_less__add__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A2: A] : ord_less(A,A2,plus_plus(A,A2,one_one(A))) ) ).

tff(fact_9_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [Na: nat,Ma: nat] :
          ( ( semiring_1_of_nat(A,Ma) = semiring_1_of_nat(A,Na) )
        <=> ( Ma = Na ) ) ) ).

tff(fact_10_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
        <=> ( B = C ) ) ) ).

tff(fact_11_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C,A1) )
        <=> ( B = C ) ) ) ).

tff(fact_12_nat__add__left__cancel,axiom,
    ! [Na: nat,Ma: nat,K: nat] :
      ( ( plus_plus(nat,K,Ma) = plus_plus(nat,K,Na) )
    <=> ( Ma = Na ) ) ).

tff(fact_13_nat__add__right__cancel,axiom,
    ! [Na: nat,K: nat,Ma: nat] :
      ( ( plus_plus(nat,Ma,K) = plus_plus(nat,Na,K) )
    <=> ( Ma = Na ) ) ).

tff(fact_14_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( plus_plus(A,A1,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_15_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( zero_zero(A) = plus_plus(A,A1,A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_16_n0,axiom,
    ord_less(nat,zero_zero(nat),n) ).

tff(fact_17_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_18_nat__add__left__cancel__less,axiom,
    ! [Na: nat,Ma: nat,K: nat] :
      ( ord_less(nat,plus_plus(nat,K,Ma),plus_plus(nat,K,Na))
    <=> ord_less(nat,Ma,Na) ) ).

tff(fact_19_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ord_less(A,plus_plus(A,A1,A1),zero_zero(A))
        <=> ord_less(A,A1,zero_zero(A)) ) ) ).

tff(fact_20_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,A1,A1))
        <=> ord_less(A,zero_zero(A),A1) ) ) ).

tff(fact_21_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,Na))
        <=> ord_less(nat,zero_zero(nat),Na) ) ) ).

tff(fact_22_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_23_not__add__less1,axiom,
    ! [J: nat,I2: nat] : ~ ord_less(nat,plus_plus(nat,I2,J),I2) ).

tff(fact_24_not__add__less2,axiom,
    ! [I2: nat,J: nat] : ~ ord_less(nat,plus_plus(nat,J,I2),I2) ).

tff(fact_25_nat__neq__iff,axiom,
    ! [Na: nat,Ma: nat] :
      ( ( Ma != Na )
    <=> ( ord_less(nat,Ma,Na)
        | ord_less(nat,Na,Ma) ) ) ).

tff(fact_26_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_27_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,N) = plus_plus(nat,N,M) ) ).

tff(fact_28_nat__add__left__commute,axiom,
    ! [Z1: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z1)) = plus_plus(nat,Y,plus_plus(nat,X,Z1)) ) ).

tff(fact_29_nat__add__assoc,axiom,
    ! [K1: nat,N: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N),K1) = plus_plus(nat,M,plus_plus(nat,N,K1)) ) ).

tff(fact_30_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_31_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_32_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_33_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_34_trans__less__add1,axiom,
    ! [M: nat,J: nat,I2: nat] :
      ( ord_less(nat,I2,J)
     => ord_less(nat,I2,plus_plus(nat,J,M)) ) ).

tff(fact_35_trans__less__add2,axiom,
    ! [M: nat,J: nat,I2: nat] :
      ( ord_less(nat,I2,J)
     => ord_less(nat,I2,plus_plus(nat,M,J)) ) ).

tff(fact_36_add__less__mono1,axiom,
    ! [K1: nat,J: nat,I2: nat] :
      ( ord_less(nat,I2,J)
     => ord_less(nat,plus_plus(nat,I2,K1),plus_plus(nat,J,K1)) ) ).

tff(fact_37_add__less__mono,axiom,
    ! [L: nat,K1: nat,J: nat,I2: nat] :
      ( ord_less(nat,I2,J)
     => ( ord_less(nat,K1,L)
       => ord_less(nat,plus_plus(nat,I2,K1),plus_plus(nat,J,L)) ) ) ).

tff(fact_38_less__add__eq__less,axiom,
    ! [N: nat,M: nat,L: nat,K1: nat] :
      ( ord_less(nat,K1,L)
     => ( ( plus_plus(nat,M,L) = plus_plus(nat,K1,N) )
       => ord_less(nat,M,N) ) ) ).

tff(fact_39_add__lessD1,axiom,
    ! [K1: nat,J: nat,I2: nat] :
      ( ord_less(nat,plus_plus(nat,I2,J),K1)
     => ord_less(nat,I2,K1) ) ).

tff(fact_40_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),Na: nat,Ma: nat] :
      ( ( ord_less(nat,Ma,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),Ma)) )
     => ( ( ( Ma = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),Ma)) )
       => ( ( ord_less(nat,Na,Ma)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),Ma)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),Ma)) ) ) ) ).

tff(fact_41_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_42_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_43_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,zero_zero(A),A2) = A2 ) ) ).

tff(fact_44_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,zero_zero(A),A2) = A2 ) ) ).

tff(fact_45_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_46_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_47_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,A2,zero_zero(A))
         => ( ord_less(A,B1,zero_zero(A))
           => ord_less(A,plus_plus(A,A2,B1),zero_zero(A)) ) ) ) ).

tff(fact_48_pos__add__strict,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ( ord_less(A,B1,C1)
           => ord_less(A,B1,plus_plus(A,A2,C1)) ) ) ) ).

tff(fact_49_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ( ord_less(A,zero_zero(A),B1)
           => ord_less(A,zero_zero(A),plus_plus(A,A2,B1)) ) ) ) ).

tff(fact_50_even__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,plus_plus(A,A1,A1),zero_zero(A))
        <=> ord_less(A,A1,zero_zero(A)) ) ) ).

tff(fact_51_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_52_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_53_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ~ ord_less(A,semiring_1_of_nat(A,M),zero_zero(A)) ) ).

tff(fact_54_zadd__int__left,axiom,
    ! [Z1: int,N: nat,M: nat] : ( plus_plus(int,semiring_1_of_nat(int,M),plus_plus(int,semiring_1_of_nat(int,N),Z1)) = plus_plus(int,semiring_1_of_nat(int,plus_plus(nat,M,N)),Z1) ) ).

tff(fact_55_zadd__int,axiom,
    ! [N: nat,M: nat] : ( plus_plus(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,N)) = semiring_1_of_nat(int,plus_plus(nat,M,N)) ) ).

tff(fact_56_zless__int,axiom,
    ! [Na: nat,Ma: nat] :
      ( ord_less(int,semiring_1_of_nat(int,Ma),semiring_1_of_nat(int,Na))
    <=> ord_less(nat,Ma,Na) ) ).

tff(fact_57_int__1,axiom,
    semiring_1_of_nat(int,one_one(nat)) = one_one(int) ).

tff(fact_58_odd__nonzero,axiom,
    ! [Z1: int] : ( plus_plus(int,plus_plus(int,one_one(int),Z1),Z1) != zero_zero(int) ) ).

tff(fact_59_int__less__0__conv,axiom,
    ! [K1: nat] : ~ ord_less(int,semiring_1_of_nat(int,K1),zero_zero(int)) ).

tff(fact_60_zero__less__two,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),plus_plus(A,one_one(A),one_one(A))) ) ).

tff(fact_61_odd__less__0__iff,axiom,
    ! [Z: int] :
      ( ord_less(int,plus_plus(int,plus_plus(int,one_one(int),Z),Z),zero_zero(int))
    <=> ord_less(int,Z,zero_zero(int)) ) ).

tff(fact_62_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_63_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B1: A] :
          ( ( plus_plus(A,B1,A2) = plus_plus(A,C1,A2) )
         => ( B1 = C1 ) ) ) ).

tff(fact_64_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( plus_plus(A,A2,B1) = plus_plus(A,A2,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_65_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( plus_plus(A,A2,B1) = plus_plus(A,A2,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_66_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B1: A,A2: A] : ( plus_plus(A,plus_plus(A,A2,B1),C1) = plus_plus(A,A2,plus_plus(A,B1,C1)) ) ) ).

tff(fact_67_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [Xa: A] :
          ( ( one_one(A) = Xa )
        <=> ( Xa = one_one(A) ) ) ) ).

tff(fact_68_int__int__eq,axiom,
    ! [Na: nat,Ma: nat] :
      ( ( semiring_1_of_nat(int,Ma) = semiring_1_of_nat(int,Na) )
    <=> ( Ma = Na ) ) ).

tff(fact_69_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,A2: A,C1: A] :
          ( ord_less(A,plus_plus(A,C1,A2),plus_plus(A,C1,B1))
         => ord_less(A,A2,B1) ) ) ).

tff(fact_70_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,C1: A,A2: A] :
          ( ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B1,C1))
         => ord_less(A,A2,B1) ) ) ).

tff(fact_71_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D: A,C1: A,B1: A,A2: A] :
          ( ord_less(A,A2,B1)
         => ( ord_less(A,C1,D)
           => ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B1,D)) ) ) ) ).

tff(fact_72_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ord_less(A,A2,B1)
         => ord_less(A,plus_plus(A,C1,A2),plus_plus(A,C1,B1)) ) ) ).

tff(fact_73_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ord_less(A,A2,B1)
         => ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B1,C1)) ) ) ).

tff(fact_74_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N))
         => ord_less(nat,M,N) ) ) ).

tff(fact_75_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat] :
          ( ord_less(nat,M,N)
         => ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N)) ) ) ).

tff(fact_76_int__gr__induct,axiom,
    ! [P: fun(int,bool),I: int,K: int] :
      ( ord_less(int,K,I)
     => ( pp(aa(int,bool,P,plus_plus(int,K,one_one(int))))
       => ( ! [I1: int] :
              ( ord_less(int,K,I1)
             => ( pp(aa(int,bool,P,I1))
               => pp(aa(int,bool,P,plus_plus(int,I1,one_one(int)))) ) )
         => pp(aa(int,bool,P,I)) ) ) ) ).

tff(fact_77_transfer__int__nat__numerals_I2_J,axiom,
    one_one(int) = semiring_1_of_nat(int,one_one(nat)) ).

tff(fact_78_Nat__Transfer_Otransfer__int__nat__functions_I1_J,axiom,
    ! [Y: nat,X: nat] : ( plus_plus(int,semiring_1_of_nat(int,X),semiring_1_of_nat(int,Y)) = semiring_1_of_nat(int,plus_plus(nat,X,Y)) ) ).

tff(fact_79_Nat__Transfer_Otransfer__int__nat__relations_I2_J,axiom,
    ! [Ya: nat,Xa: nat] :
      ( ord_less(int,semiring_1_of_nat(int,Xa),semiring_1_of_nat(int,Ya))
    <=> ord_less(nat,Xa,Ya) ) ).

tff(fact_80_tn0,axiom,
    ord_less(nat,zero_zero(nat),tn) ).

tff(fact_81_tpos,axiom,
    ord_less_eq(int,one_one(int),t) ).

tff(fact_82_termination__basic__simps_I1_J,axiom,
    ! [Z1: nat,Y: nat,X: nat] :
      ( ord_less(nat,X,Y)
     => ord_less(nat,X,plus_plus(nat,Y,Z1)) ) ).

tff(fact_83_termination__basic__simps_I2_J,axiom,
    ! [Y: nat,Z1: nat,X: nat] :
      ( ord_less(nat,X,Z1)
     => ord_less(nat,X,plus_plus(nat,Y,Z1)) ) ).

tff(fact_84_add__0__iff,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [A1: A,B: A] :
          ( ( B = plus_plus(A,B,A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_85_add__le__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C: A,A1: A] :
          ( ord_less_eq(A,plus_plus(A,A1,C),plus_plus(A,B,C))
        <=> ord_less_eq(A,A1,B) ) ) ).

tff(fact_86_add__le__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C: A] :
          ( ord_less_eq(A,plus_plus(A,C,A1),plus_plus(A,C,B))
        <=> ord_less_eq(A,A1,B) ) ) ).

tff(fact_87_of__nat__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,Ma: nat] :
          ( ord_less_eq(A,semiring_1_of_nat(A,Ma),semiring_1_of_nat(A,Na))
        <=> ord_less_eq(nat,Ma,Na) ) ) ).

tff(fact_88_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_89_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_90_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_91_add__is__0,axiom,
    ! [Na: nat,Ma: nat] :
      ( ( plus_plus(nat,Ma,Na) = zero_zero(nat) )
    <=> ( ( Ma = zero_zero(nat) )
        & ( Na = zero_zero(nat) ) ) ) ).

tff(fact_92_double__add__le__zero__iff__single__add__le__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ord_less_eq(A,plus_plus(A,A1,A1),zero_zero(A))
        <=> ord_less_eq(A,A1,zero_zero(A)) ) ) ).

tff(fact_93_zero__le__double__add__iff__zero__le__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ord_less_eq(A,zero_zero(A),plus_plus(A,A1,A1))
        <=> ord_less_eq(A,zero_zero(A),A1) ) ) ).

tff(fact_94_add__gr__0,axiom,
    ! [Na: nat,Ma: nat] :
      ( ord_less(nat,zero_zero(nat),plus_plus(nat,Ma,Na))
    <=> ( ord_less(nat,zero_zero(nat),Ma)
        | ord_less(nat,zero_zero(nat),Na) ) ) ).

tff(fact_95_zle__add1__eq__le,axiom,
    ! [Z: int,Wa: int] :
      ( ord_less(int,Wa,plus_plus(int,Z,one_one(int)))
    <=> ord_less_eq(int,Wa,Z) ) ).

tff(fact_96_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ord_less_eq(int,zero_zero(int),zero_zero(int)) ).

tff(fact_97_int__le__0__conv,axiom,
    ! [Na: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,Na),zero_zero(int))
    <=> ( Na = zero_zero(nat) ) ) ).

%----Arities (32)
tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(int) ).

tff(arity_Int_Oint___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(int) ).

tff(arity_Int_Oint___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ord_less(int,m1,plus_plus(int,one_one(int),semiring_1_of_nat(int,n))) ).

%------------------------------------------------------------------------------
