%------------------------------------------------------------------------------
% File     : NUM974_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 112
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : s2s_112 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  143 (  42 unt;  26 typ;   0 def)
%            Number of atoms       :  255 (  70 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  165 (  27   ~;   2   |;   9   &)
%                                         (  42 <=>;  85  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   4 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   13 (   8   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   1 prp; 0-3 aty)
%            Number of functors    :   10 (  10 usr;   3 con; 0-4 aty)
%            Number of variables   :  190 ( 169   !;   4   ?; 190   :)
%                                         (  17  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:38
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (22)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_Onat,type,
    nat1: int > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_t____,type,
    t: int ).

tff(sy_v_thesis____,type,
    thesis: $o ).

%----Relevant facts (98)
tff(fact_0_t1,axiom,
    ord_less(int,one_one(int),t) ).

tff(fact_1_zero__less__diff,axiom,
    ! [Ma: nat,N1: nat] :
      ( ord_less(nat,zero_zero(nat),minus_minus(nat,N1,Ma))
    <=> ord_less(nat,Ma,N1) ) ).

tff(fact_2_diff__0__eq__0,axiom,
    ! [N2: nat] : ( minus_minus(nat,zero_zero(nat),N2) = zero_zero(nat) ) ).

tff(fact_3_diff__self__eq__0,axiom,
    ! [M: nat] : ( minus_minus(nat,M,M) = zero_zero(nat) ) ).

tff(fact_4_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_5_less__nat__zero__code,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_6_less__zeroE,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_7_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( minus_minus(A,A2,A2) = zero_zero(A) ) ) ).

tff(fact_8_diff__less,axiom,
    ! [M: nat,N2: nat] :
      ( ord_less(nat,zero_zero(nat),N2)
     => ( ord_less(nat,zero_zero(nat),M)
       => ord_less(nat,minus_minus(nat,M,N2),M) ) ) ).

tff(fact_9_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,B)
        <=> ord_less(A,minus_minus(A,A1,B),zero_zero(A)) ) ) ).

tff(fact_10_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_11_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_12_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_13_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 != Y1 )
         => ( ~ ord_less(A,X2,Y1)
           => ord_less(A,Y1,X2) ) ) ) ).

tff(fact_14_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X: A] :
          ( ( one_one(A) = X )
        <=> ( X = one_one(A) ) ) ) ).

tff(fact_15_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( ( minus_minus(A,A1,B) = minus_minus(A,C,D) )
         => ( ( A1 = B )
          <=> ( C = D ) ) ) ) ).

tff(fact_16_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),N1: nat,Ma: nat] :
      ( ( ord_less(nat,Ma,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),Ma)) )
     => ( ( ( Ma = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),Ma)) )
       => ( ( ord_less(nat,N1,Ma)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),Ma)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),Ma)) ) ) ) ).

tff(fact_17_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_18_less__not__refl2,axiom,
    ! [M: nat,N2: nat] :
      ( ord_less(nat,N2,M)
     => ( M != N2 ) ) ).

tff(fact_19_less__irrefl__nat,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,N2) ).

tff(fact_20_linorder__neqE__nat,axiom,
    ! [Y1: nat,X2: nat] :
      ( ( X2 != Y1 )
     => ( ~ ord_less(nat,X2,Y1)
       => ord_less(nat,Y1,X2) ) ) ).

tff(fact_21_nat__neq__iff,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( Ma != N1 )
    <=> ( ord_less(nat,Ma,N1)
        | ord_less(nat,N1,Ma) ) ) ).

tff(fact_22_less__not__refl,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,N2) ).

tff(fact_23_diff__commute,axiom,
    ! [K: nat,J: nat,I1: nat] : ( minus_minus(nat,minus_minus(nat,I1,J),K) = minus_minus(nat,minus_minus(nat,I1,K),J) ) ).

tff(fact_24_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_25_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_26_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B: A,A1: A] :
          ( ( minus_minus(A,A1,B) = zero_zero(A) )
        <=> ( A1 = B ) ) ) ).

tff(fact_27_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B: A,A1: A] :
          ( ( A1 = B )
        <=> ( minus_minus(A,A1,B) = zero_zero(A) ) ) ) ).

tff(fact_28_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( minus_minus(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_29_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( ( minus_minus(A,A1,B) = minus_minus(A,C,D) )
         => ( ord_less(A,A1,B)
          <=> ord_less(A,C,D) ) ) ) ).

tff(fact_30_gr0I,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N2) ) ).

tff(fact_31_gr__implies__not0,axiom,
    ! [N2: nat,M: nat] :
      ( ord_less(nat,M,N2)
     => ( N2 != zero_zero(nat) ) ) ).

tff(fact_32_not__less0,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_33_diffs0__imp__equal,axiom,
    ! [N2: nat,M: nat] :
      ( ( minus_minus(nat,M,N2) = zero_zero(nat) )
     => ( ( minus_minus(nat,N2,M) = zero_zero(nat) )
       => ( M = N2 ) ) ) ).

tff(fact_34_minus__nat_Odiff__0,axiom,
    ! [M: nat] : ( minus_minus(nat,M,zero_zero(nat)) = M ) ).

tff(fact_35_diff__less__mono2,axiom,
    ! [L: nat,N2: nat,M: nat] :
      ( ord_less(nat,M,N2)
     => ( ord_less(nat,M,L)
       => ord_less(nat,minus_minus(nat,L,N2),minus_minus(nat,L,M)) ) ) ).

tff(fact_36_less__imp__diff__less,axiom,
    ! [N2: nat,K: nat,J: nat] :
      ( ord_less(nat,J,K)
     => ord_less(nat,minus_minus(nat,J,N2),K) ) ).

tff(fact_37_zero__less__nat__eq,axiom,
    ! [Z: int] :
      ( ord_less(nat,zero_zero(nat),nat1(Z))
    <=> ord_less(int,zero_zero(int),Z) ) ).

tff(fact_38_zless__nat__conj,axiom,
    ! [Z: int,W: int] :
      ( ord_less(nat,nat1(W),nat1(Z))
    <=> ( ord_less(int,zero_zero(int),Z)
        & ord_less(int,W,Z) ) ) ).

tff(fact_39_nat__0,axiom,
    nat1(zero_zero(int)) = zero_zero(nat) ).

tff(fact_40_transfer__nat__int__numerals_I2_J,axiom,
    one_one(nat) = nat1(one_one(int)) ).

tff(fact_41_nat__mono__iff,axiom,
    ! [W: int,Z: int] :
      ( ord_less(int,zero_zero(int),Z)
     => ( ord_less(nat,nat1(W),nat1(Z))
      <=> ord_less(int,W,Z) ) ) ).

tff(fact_42_tpos,axiom,
    ord_less_eq(int,one_one(int),t) ).

tff(fact_43_transfer__nat__int__numerals_I1_J,axiom,
    zero_zero(nat) = nat1(zero_zero(int)) ).

tff(fact_44_Euler_Oaux1,axiom,
    ! [A2: int,X2: int] :
      ( ord_less(int,zero_zero(int),X2)
     => ( ord_less(int,X2,A2)
       => ( ( X2 != minus_minus(int,A2,one_one(int)) )
         => ord_less(int,X2,minus_minus(int,A2,one_one(int))) ) ) ) ).

tff(fact_45_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,N1))
        <=> ord_less(nat,zero_zero(nat),N1) ) ) ).

tff(fact_46_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [N1: nat,Ma: nat] :
          ( ( semiring_1_of_nat(A,Ma) = semiring_1_of_nat(A,N1) )
        <=> ( Ma = N1 ) ) ) ).

tff(fact_47_of__nat__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,Ma: nat] :
          ( ord_less_eq(A,semiring_1_of_nat(A,Ma),semiring_1_of_nat(A,N1))
        <=> ord_less_eq(nat,Ma,N1) ) ) ).

tff(fact_48_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_49_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,Ma: nat] :
          ( ord_less(A,semiring_1_of_nat(A,Ma),semiring_1_of_nat(A,N1))
        <=> ord_less(nat,Ma,N1) ) ) ).

tff(fact_50_of__nat__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,one_one(nat)) = one_one(A) ) ) ).

tff(fact_51_int__nat__eq,axiom,
    ! [Z2: int] :
      ( ( ord_less_eq(int,zero_zero(int),Z2)
       => ( semiring_1_of_nat(int,nat1(Z2)) = Z2 ) )
      & ( ~ ord_less_eq(int,zero_zero(int),Z2)
       => ( semiring_1_of_nat(int,nat1(Z2)) = zero_zero(int) ) ) ) ).

tff(fact_52_nat__0__iff,axiom,
    ! [I: int] :
      ( ( nat1(I) = zero_zero(nat) )
    <=> ord_less_eq(int,I,zero_zero(int)) ) ).

tff(fact_53_zle__diff1__eq,axiom,
    ! [Z: int,W: int] :
      ( ord_less_eq(int,W,minus_minus(int,Z,one_one(int)))
    <=> ord_less(int,W,Z) ) ).

tff(fact_54_int__less__0__conv,axiom,
    ! [K: nat] : ~ ord_less(int,semiring_1_of_nat(int,K),zero_zero(int)) ).

tff(fact_55_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ord_less_eq(int,zero_zero(int),zero_zero(int)) ).

tff(fact_56_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = semiring_1_of_nat(int,zero_zero(nat)) ).

tff(fact_57_zero__le__imp__of__nat,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,M)) ) ).

tff(fact_58_of__nat__0__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N2: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,N2)) ) ).

tff(fact_59_zero__zle__int,axiom,
    ! [N2: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,N2)) ).

tff(fact_60_Nat__Transfer_Otransfer__nat__int__function__closures_I9_J,axiom,
    ! [Z2: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,Z2)) ).

tff(fact_61_int__0,axiom,
    semiring_1_of_nat(int,zero_zero(nat)) = zero_zero(int) ).

tff(fact_62_transfer__int__nat__quantifiers_I2_J,axiom,
    ! [P: fun(int,bool)] :
      ( ? [X1: int] :
          ( ord_less_eq(int,zero_zero(int),X1)
          & pp(aa(int,bool,P,X1)) )
    <=> ? [X1: nat] : pp(aa(int,bool,P,semiring_1_of_nat(int,X1))) ) ).

tff(fact_63_transfer__int__nat__quantifiers_I1_J,axiom,
    ! [P: fun(int,bool)] :
      ( ! [X1: int] :
          ( ord_less_eq(int,zero_zero(int),X1)
         => pp(aa(int,bool,P,X1)) )
    <=> ! [X1: nat] : pp(aa(int,bool,P,semiring_1_of_nat(int,X1))) ) ).

tff(fact_64_int__eq__0__conv,axiom,
    ! [N1: nat] :
      ( ( semiring_1_of_nat(int,N1) = zero_zero(int) )
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_65_int__le__0__conv,axiom,
    ! [N1: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,N1),zero_zero(int))
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_66_int__eq__iff,axiom,
    ! [Z: int,Ma: nat] :
      ( ( semiring_1_of_nat(int,Ma) = Z )
    <=> ( ( Ma = nat1(Z) )
        & ord_less_eq(int,zero_zero(int),Z) ) ) ).

tff(fact_67_nat__0__le,axiom,
    ! [Z2: int] :
      ( ord_less_eq(int,zero_zero(int),Z2)
     => ( semiring_1_of_nat(int,nat1(Z2)) = Z2 ) ) ).

tff(fact_68_nat__int,axiom,
    ! [N2: nat] : ( nat1(semiring_1_of_nat(int,N2)) = N2 ) ).

tff(fact_69_Euler_Oaux2,axiom,
    ! [B1: int,C1: int,A2: int] :
      ( ord_less(int,A2,C1)
     => ( ord_less(int,B1,C1)
       => ( ord_less_eq(int,A2,B1)
          | ord_less_eq(int,B1,A2) ) ) ) ).

tff(fact_70_less__int__def,axiom,
    ! [W: int,Z: int] :
      ( ord_less(int,Z,W)
    <=> ( ord_less_eq(int,Z,W)
        & ( Z != W ) ) ) ).

tff(fact_71_Nat__Transfer_Otransfer__nat__int__function__closures_I6_J,axiom,
    ord_less_eq(int,zero_zero(int),one_one(int)) ).

tff(fact_72_eq__nat__nat__iff,axiom,
    ! [Z3: int,Z: int] :
      ( ord_less_eq(int,zero_zero(int),Z)
     => ( ord_less_eq(int,zero_zero(int),Z3)
       => ( ( nat1(Z) = nat1(Z3) )
        <=> ( Z = Z3 ) ) ) ) ).

tff(fact_73_transfer__nat__int__relations_I1_J,axiom,
    ! [Y: int,X: int] :
      ( ord_less_eq(int,zero_zero(int),X)
     => ( ord_less_eq(int,zero_zero(int),Y)
       => ( ( nat1(X) = nat1(Y) )
        <=> ( X = Y ) ) ) ) ).

tff(fact_74_all__nat,axiom,
    ! [P: fun(nat,bool)] :
      ( ! [X11: nat] : pp(aa(nat,bool,P,X11))
    <=> ! [X1: int] :
          ( ord_less_eq(int,zero_zero(int),X1)
         => pp(aa(nat,bool,P,nat1(X1))) ) ) ).

tff(fact_75_ex__nat,axiom,
    ! [P: fun(nat,bool)] :
      ( ? [X11: nat] : pp(aa(nat,bool,P,X11))
    <=> ? [X1: int] :
          ( ord_less_eq(int,zero_zero(int),X1)
          & pp(aa(nat,bool,P,nat1(X1))) ) ) ).

tff(fact_76_nat__eq__iff2,axiom,
    ! [W: int,Ma: nat] :
      ( ( Ma = nat1(W) )
    <=> ( ( ord_less_eq(int,zero_zero(int),W)
         => ( W = semiring_1_of_nat(int,Ma) ) )
        & ( ~ ord_less_eq(int,zero_zero(int),W)
         => ( Ma = zero_zero(nat) ) ) ) ) ).

tff(fact_77_nat__eq__iff,axiom,
    ! [Ma: nat,W: int] :
      ( ( nat1(W) = Ma )
    <=> ( ( ord_less_eq(int,zero_zero(int),W)
         => ( W = semiring_1_of_nat(int,Ma) ) )
        & ( ~ ord_less_eq(int,zero_zero(int),W)
         => ( Ma = zero_zero(nat) ) ) ) ) ).

tff(fact_78_nat__less__iff,axiom,
    ! [Ma: nat,W: int] :
      ( ord_less_eq(int,zero_zero(int),W)
     => ( ord_less(nat,nat1(W),Ma)
      <=> ord_less(int,W,semiring_1_of_nat(int,Ma)) ) ) ).

tff(fact_79_diff__eq__diff__less__eq,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( ( minus_minus(A,A1,B) = minus_minus(A,C,D) )
         => ( ord_less_eq(A,A1,B)
          <=> ord_less_eq(A,C,D) ) ) ) ).

tff(fact_80_zless__int,axiom,
    ! [N1: nat,Ma: nat] :
      ( ord_less(int,semiring_1_of_nat(int,Ma),semiring_1_of_nat(int,N1))
    <=> ord_less(nat,Ma,N1) ) ).

tff(fact_81_Nat__Transfer_Otransfer__int__nat__relations_I2_J,axiom,
    ! [Y: nat,X: nat] :
      ( ord_less(int,semiring_1_of_nat(int,X),semiring_1_of_nat(int,Y))
    <=> ord_less(nat,X,Y) ) ).

tff(fact_82_transfer__int__nat__numerals_I2_J,axiom,
    one_one(int) = semiring_1_of_nat(int,one_one(nat)) ).

tff(fact_83_int__1,axiom,
    semiring_1_of_nat(int,one_one(nat)) = one_one(int) ).

tff(fact_84_int__one__le__iff__zero__less,axiom,
    ! [Z: int] :
      ( ord_less_eq(int,one_one(int),Z)
    <=> ord_less(int,zero_zero(int),Z) ) ).

tff(fact_85_nat__le__0,axiom,
    ! [Z2: int] :
      ( ord_less_eq(int,Z2,zero_zero(int))
     => ( nat1(Z2) = zero_zero(nat) ) ) ).

tff(fact_86_nat__diff__distrib,axiom,
    ! [Z2: int,Z1: int] :
      ( ord_less_eq(int,zero_zero(int),Z1)
     => ( ord_less_eq(int,Z1,Z2)
       => ( nat1(minus_minus(int,Z2,Z1)) = minus_minus(nat,nat1(Z2),nat1(Z1)) ) ) ) ).

tff(fact_87_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ~ ord_less(A,semiring_1_of_nat(A,M),zero_zero(A)) ) ).

tff(fact_88_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N2: nat,M: nat] :
          ( ord_less(nat,M,N2)
         => ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N2)) ) ) ).

tff(fact_89_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N2: nat,M: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N2))
         => ord_less(nat,M,N2) ) ) ).

tff(fact_90_zero__less__int__conv,axiom,
    ! [N1: nat] :
      ( ord_less(int,zero_zero(int),semiring_1_of_nat(int,N1))
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_91_split__nat,axiom,
    ! [I: int,P: fun(nat,bool)] :
      ( pp(aa(nat,bool,P,nat1(I)))
    <=> ( ! [N: nat] :
            ( ( I = semiring_1_of_nat(int,N) )
           => pp(aa(nat,bool,P,N)) )
        & ( ord_less(int,I,zero_zero(int))
         => pp(aa(nat,bool,P,zero_zero(nat))) ) ) ) ).

tff(fact_92_not__one__le__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less_eq(A,one_one(A),zero_zero(A)) ) ).

tff(fact_93_zero__le__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less_eq(A,zero_zero(A),one_one(A)) ) ).

tff(fact_94_zless__nat__eq__int__zless,axiom,
    ! [Z: int,Ma: nat] :
      ( ord_less(nat,Ma,nat1(Z))
    <=> ord_less(int,semiring_1_of_nat(int,Ma),Z) ) ).

tff(fact_95_le__iff__diff__le__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B: A,A1: A] :
          ( ord_less_eq(A,A1,B)
        <=> ord_less_eq(A,minus_minus(A,A1,B),zero_zero(A)) ) ) ).

tff(fact_96_nat__less__eq__zless,axiom,
    ! [Z: int,W: int] :
      ( ord_less_eq(int,zero_zero(int),W)
     => ( ord_less(nat,nat1(W),nat1(Z))
      <=> ord_less(int,W,Z) ) ) ).

tff(fact_97_transfer__nat__int__relations_I2_J,axiom,
    ! [Y: int,X: int] :
      ( ord_less_eq(int,zero_zero(int),X)
     => ( ord_less_eq(int,zero_zero(int),Y)
       => ( ord_less(nat,nat1(X),nat1(Y))
        <=> ord_less(int,X,Y) ) ) ) ).

%----Arities (15)
tff(arity_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [Tn: nat] :
      ( ( Tn = minus_minus(nat,nat1(t),one_one(nat)) )
     => ( ord_less(nat,zero_zero(nat),Tn)
       => thesis ) ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
