%------------------------------------------------------------------------------
% File     : NUM970_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 103
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : s2s_103 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  175 (  66 unt;  36 typ;   0 def)
%            Number of atoms       :  284 (  67 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  161 (  16   ~;   6   |;  21   &)
%                                         (  45 <=>;  73  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   3 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   16 (  10   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   22 (  21 usr;   0 prp; 1-3 aty)
%            Number of functors    :   12 (  12 usr;   4 con; 0-4 aty)
%            Number of variables   :  217 ( 191   !;   0   ?; 217   :)
%                                         (  26  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:24
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (32)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_s____,type,
    s: int ).

%----Relevant facts (97)
tff(fact_0_zero__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( power_power(A,zero_zero(A),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) ) ) ).

tff(fact_1_zero__eq__power2,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [A1: A] :
          ( ( power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_2_le__special_I1_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y: int] :
          ( ord_less_eq(A,zero_zero(A),number_number_of(A,Y))
        <=> ord_less_eq(int,pls,Y) ) ) ).

tff(fact_3_le__special_I3_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [X: int] :
          ( ord_less_eq(A,number_number_of(A,X),zero_zero(A))
        <=> ord_less_eq(int,X,pls) ) ) ).

tff(fact_4_rel__simps_I21_J,axiom,
    ! [K1: int] :
      ( ord_less_eq(int,pls,bit0(K1))
    <=> ord_less_eq(int,pls,K1) ) ).

tff(fact_5_rel__simps_I27_J,axiom,
    ! [K1: int] :
      ( ord_less_eq(int,bit0(K1),pls)
    <=> ord_less_eq(int,K1,pls) ) ).

tff(fact_6_rel__simps_I32_J,axiom,
    ! [L1: int,K1: int] :
      ( ord_less_eq(int,bit0(K1),bit1(L1))
    <=> ord_less_eq(int,K1,L1) ) ).

tff(fact_7_rel__simps_I22_J,axiom,
    ! [K1: int] :
      ( ord_less_eq(int,pls,bit1(K1))
    <=> ord_less_eq(int,pls,K1) ) ).

tff(fact_8_power__eq__0__iff__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [W1: int,A1: A] :
          ( ( power_power(A,A1,number_number_of(nat,W1)) = zero_zero(A) )
        <=> ( ( A1 = zero_zero(A) )
            & ( number_number_of(nat,W1) != zero_zero(nat) ) ) ) ) ).

tff(fact_9_le__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y: int,X: int] :
          ( ord_less_eq(A,number_number_of(A,X),number_number_of(A,Y))
        <=> ord_less_eq(int,X,Y) ) ) ).

tff(fact_10_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_11_zero__le__power2,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] : ord_less_eq(A,zero_zero(A),power_power(A,A2,number_number_of(nat,bit0(bit1(pls))))) ) ).

tff(fact_12_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y: int,X: int] :
          ( ( number_number_of(A,X) = number_number_of(A,Y) )
        <=> ( X = Y ) ) ) ).

tff(fact_13_rel__simps_I51_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit1(K1) = bit1(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_14_rel__simps_I48_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit0(K1) = bit0(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_15_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_16_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_17_rel__simps_I50_J,axiom,
    ! [L: int,K: int] : ( bit1(K) != bit0(L) ) ).

tff(fact_18_rel__simps_I49_J,axiom,
    ! [L: int,K: int] : ( bit0(K) != bit1(L) ) ).

tff(fact_19_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_20_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_21_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_22_rel__simps_I34_J,axiom,
    ! [L1: int,K1: int] :
      ( ord_less_eq(int,bit1(K1),bit1(L1))
    <=> ord_less_eq(int,K1,L1) ) ).

tff(fact_23_rel__simps_I19_J,axiom,
    ord_less_eq(int,pls,pls) ).

tff(fact_24_rel__simps_I31_J,axiom,
    ! [L1: int,K1: int] :
      ( ord_less_eq(int,bit0(K1),bit0(L1))
    <=> ord_less_eq(int,K1,L1) ) ).

tff(fact_25_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_26_le__nat__number__of,axiom,
    ! [V1: int,V: int] :
      ( ord_less_eq(nat,number_number_of(nat,V),number_number_of(nat,V1))
    <=> ( ~ ord_less_eq(int,V,V1)
       => ord_less_eq(int,V,pls) ) ) ).

tff(fact_27_eq__number__of__0,axiom,
    ! [V: int] :
      ( ( number_number_of(nat,V) = zero_zero(nat) )
    <=> ord_less_eq(int,V,pls) ) ).

tff(fact_28_eq__0__number__of,axiom,
    ! [V: int] :
      ( ( zero_zero(nat) = number_number_of(nat,V) )
    <=> ord_less_eq(int,V,pls) ) ).

tff(fact_29_less__eq__number__of__int__code,axiom,
    ! [L1: int,K1: int] :
      ( ord_less_eq(int,number_number_of(int,K1),number_number_of(int,L1))
    <=> ord_less_eq(int,K1,L1) ) ).

tff(fact_30_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_31_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_32_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X: A,W1: int] :
          ( ( number_number_of(A,W1) = X )
        <=> ( X = number_number_of(A,W1) ) ) ) ).

tff(fact_33_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_34_less__eq__int__code_I16_J,axiom,
    ! [K2: int,K11: int] :
      ( ord_less_eq(int,bit1(K11),bit1(K2))
    <=> ord_less_eq(int,K11,K2) ) ).

tff(fact_35_less__eq__int__code_I13_J,axiom,
    ! [K2: int,K11: int] :
      ( ord_less_eq(int,bit0(K11),bit0(K2))
    <=> ord_less_eq(int,K11,K2) ) ).

tff(fact_36_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_37_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_38_less__eq__int__code_I14_J,axiom,
    ! [K2: int,K11: int] :
      ( ord_less_eq(int,bit0(K11),bit1(K2))
    <=> ord_less_eq(int,K11,K2) ) ).

tff(fact_39_power2__eq__imp__eq,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y1: A,X2: A] :
          ( ( power_power(A,X2,number_number_of(nat,bit0(bit1(pls)))) = power_power(A,Y1,number_number_of(nat,bit0(bit1(pls)))) )
         => ( ord_less_eq(A,zero_zero(A),X2)
           => ( ord_less_eq(A,zero_zero(A),Y1)
             => ( X2 = Y1 ) ) ) ) ) ).

tff(fact_40_power2__le__imp__le,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,power_power(A,X2,number_number_of(nat,bit0(bit1(pls)))),power_power(A,Y1,number_number_of(nat,bit0(bit1(pls)))))
         => ( ord_less_eq(A,zero_zero(A),Y1)
           => ord_less_eq(A,X2,Y1) ) ) ) ).

tff(fact_41_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [N: nat,A1: A] :
          ( ( power_power(A,A1,N) = zero_zero(A) )
        <=> ( ( A1 = zero_zero(A) )
            & ( N != zero_zero(nat) ) ) ) ) ).

tff(fact_42_power2__ge__self,axiom,
    ! [X2: int] : ord_less_eq(int,X2,power_power(int,X2,number_number_of(nat,bit0(bit1(pls))))) ).

tff(fact_43_quartic__square__square,axiom,
    ! [X2: int] : ( power_power(int,power_power(int,X2,number_number_of(nat,bit0(bit1(pls)))),number_number_of(nat,bit0(bit1(pls)))) = power_power(int,X2,number_number_of(nat,bit0(bit0(bit1(pls))))) ) ).

tff(fact_44_Nat__Transfer_Otransfer__nat__int__function__closures_I7_J,axiom,
    ord_less_eq(int,zero_zero(int),number_number_of(int,bit0(bit1(pls)))) ).

tff(fact_45_number__of1,axiom,
    ! [N1: int] :
      ( ord_less_eq(int,zero_zero(int),number_number_of(int,N1))
     => ( ord_less_eq(int,zero_zero(int),number_number_of(int,bit0(N1)))
        & ord_less_eq(int,zero_zero(int),number_number_of(int,bit1(N1))) ) ) ).

tff(fact_46_Nat__Transfer_Otransfer__nat__int__function__closures_I8_J,axiom,
    ord_less_eq(int,zero_zero(int),number_number_of(int,bit1(bit1(pls)))) ).

tff(fact_47_Nat__Transfer_Otransfer__nat__int__function__closures_I4_J,axiom,
    ! [N1: nat,X2: int] :
      ( ord_less_eq(int,zero_zero(int),X2)
     => ord_less_eq(int,zero_zero(int),power_power(int,X2,N1)) ) ).

tff(fact_48_number__of2,axiom,
    ord_less_eq(int,zero_zero(int),number_number_of(int,pls)) ).

tff(fact_49_power__mono,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,B1: A,A2: A] :
          ( ord_less_eq(A,A2,B1)
         => ( ord_less_eq(A,zero_zero(A),A2)
           => ord_less_eq(A,power_power(A,A2,N1),power_power(A,B1,N1)) ) ) ) ).

tff(fact_50_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_51_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N1: nat,A2: A] :
          ( ( A2 != zero_zero(A) )
         => ( power_power(A,A2,N1) != zero_zero(A) ) ) ) ).

tff(fact_52_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ord_less_eq(int,zero_zero(int),zero_zero(int)) ).

tff(fact_53_conj__le__cong,axiom,
    ! [P1: bool,P: bool,X: int] :
      ( ( ord_less_eq(int,zero_zero(int),X)
       => ( pp(P)
        <=> pp(P1) ) )
     => ( ( ord_less_eq(int,zero_zero(int),X)
          & pp(P) )
      <=> ( ord_less_eq(int,zero_zero(int),X)
          & pp(P1) ) ) ) ).

tff(fact_54_imp__le__cong,axiom,
    ! [P1: bool,P: bool,X: int] :
      ( ( ord_less_eq(int,zero_zero(int),X)
       => ( pp(P)
        <=> pp(P1) ) )
     => ( ( ord_less_eq(int,zero_zero(int),X)
         => pp(P) )
      <=> ( ord_less_eq(int,zero_zero(int),X)
         => pp(P1) ) ) ) ).

tff(fact_55_zero__le__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,A2: A] :
          ( ord_less_eq(A,zero_zero(A),A2)
         => ord_less_eq(A,zero_zero(A),power_power(A,A2,N1)) ) ) ).

tff(fact_56_le__0__eq,axiom,
    ! [N: nat] :
      ( ord_less_eq(nat,N,zero_zero(nat))
    <=> ( N = zero_zero(nat) ) ) ).

tff(fact_57_less__eq__nat_Osimps_I1_J,axiom,
    ! [N1: nat] : ord_less_eq(nat,zero_zero(nat),N1) ).

tff(fact_58_le0,axiom,
    ! [N1: nat] : ord_less_eq(nat,zero_zero(nat),N1) ).

tff(fact_59_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ord_less_eq(A,X2,X2) ) ).

tff(fact_60_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ~ ord_less_eq(A,X2,Y1)
         => ord_less_eq(A,Y1,X2) ) ) ).

tff(fact_61_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X),aa(A,B,G,X)) ) ) ).

tff(fact_62_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ord_less_eq(A,Y1,Z)
           => ord_less_eq(A,X2,Z) ) ) ) ).

tff(fact_63_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ord_less_eq(A,Y1,X2)
           => ( X2 = Y1 ) ) ) ) ).

tff(fact_64_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A2: A] :
          ( ord_less_eq(A,A2,B1)
         => ( ( B1 = C )
           => ord_less_eq(A,A2,C) ) ) ) ).

tff(fact_65_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A2: A] :
          ( ( A2 = B1 )
         => ( ord_less_eq(A,B1,C)
           => ord_less_eq(A,A2,C) ) ) ) ).

tff(fact_66_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X: A,Y: A] :
          ( ord_less_eq(A,Y,X)
         => ( ord_less_eq(A,X,Y)
          <=> ( X = Y ) ) ) ) ).

tff(fact_67_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X),aa(A,B,G,X)) ) ) ).

tff(fact_68_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 = Y1 )
         => ord_less_eq(A,X2,Y1) ) ) ).

tff(fact_69_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
        <=> ( ord_less_eq(A,X,Y)
            & ord_less_eq(A,Y,X) ) ) ) ).

tff(fact_70_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
          | ord_less_eq(A,Y1,X2) ) ) ).

tff(fact_71_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X1: A] : ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

tff(fact_72_le__antisym,axiom,
    ! [N1: nat,M: nat] :
      ( ord_less_eq(nat,M,N1)
     => ( ord_less_eq(nat,N1,M)
       => ( M = N1 ) ) ) ).

tff(fact_73_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

tff(fact_74_eq__imp__le,axiom,
    ! [N1: nat,M: nat] :
      ( ( M = N1 )
     => ord_less_eq(nat,M,N1) ) ).

tff(fact_75_nat__le__linear,axiom,
    ! [N1: nat,M: nat] :
      ( ord_less_eq(nat,M,N1)
      | ord_less_eq(nat,N1,M) ) ).

tff(fact_76_le__refl,axiom,
    ! [N1: nat] : ord_less_eq(nat,N1,N1) ).

tff(fact_77_power2__eq__square__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W: int] : ( power_power(B,number_number_of(B,W),number_number_of(nat,bit0(bit1(pls)))) = times_times(B,number_number_of(B,W),number_number_of(B,W)) ) ) ).

tff(fact_78_zero__less__power2,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,zero_zero(A),power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))))
        <=> ( A1 != zero_zero(A) ) ) ) ).

tff(fact_79_mult__cancel2,axiom,
    ! [N: nat,K1: nat,Ma: nat] :
      ( ( times_times(nat,Ma,K1) = times_times(nat,N,K1) )
    <=> ( ( Ma = N )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_80_mult__cancel1,axiom,
    ! [N: nat,Ma: nat,K1: nat] :
      ( ( times_times(nat,K1,Ma) = times_times(nat,K1,N) )
    <=> ( ( Ma = N )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_81_mult__is__0,axiom,
    ! [N: nat,Ma: nat] :
      ( ( times_times(nat,Ma,N) = zero_zero(nat) )
    <=> ( ( Ma = zero_zero(nat) )
        | ( N = zero_zero(nat) ) ) ) ).

tff(fact_82_mult__0__right,axiom,
    ! [M: nat] : ( times_times(nat,M,zero_zero(nat)) = zero_zero(nat) ) ).

tff(fact_83_mult__0,axiom,
    ! [N1: nat] : ( times_times(nat,zero_zero(nat),N1) = zero_zero(nat) ) ).

tff(fact_84_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_85_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_86_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_87_mult__less__cancel2,axiom,
    ! [N: nat,K1: nat,Ma: nat] :
      ( ord_less(nat,times_times(nat,Ma,K1),times_times(nat,N,K1))
    <=> ( ord_less(nat,zero_zero(nat),K1)
        & ord_less(nat,Ma,N) ) ) ).

tff(fact_88_mult__less__cancel1,axiom,
    ! [N: nat,Ma: nat,K1: nat] :
      ( ord_less(nat,times_times(nat,K1,Ma),times_times(nat,K1,N))
    <=> ( ord_less(nat,zero_zero(nat),K1)
        & ord_less(nat,Ma,N) ) ) ).

tff(fact_89_nat__0__less__mult__iff,axiom,
    ! [N: nat,Ma: nat] :
      ( ord_less(nat,zero_zero(nat),times_times(nat,Ma,N))
    <=> ( ord_less(nat,zero_zero(nat),Ma)
        & ord_less(nat,zero_zero(nat),N) ) ) ).

tff(fact_90_nat__zero__less__power__iff,axiom,
    ! [N: nat,X: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,X,N))
    <=> ( ord_less(nat,zero_zero(nat),X)
        | ( N = zero_zero(nat) ) ) ) ).

tff(fact_91_rel__simps_I17_J,axiom,
    ! [L1: int,K1: int] :
      ( ord_less(int,bit1(K1),bit1(L1))
    <=> ord_less(int,K1,L1) ) ).

tff(fact_92_rel__simps_I2_J,axiom,
    ~ ord_less(int,pls,pls) ).

tff(fact_93_mult__Pls,axiom,
    ! [W: int] : ( times_times(int,pls,W) = pls ) ).

tff(fact_94_rel__simps_I14_J,axiom,
    ! [L1: int,K1: int] :
      ( ord_less(int,bit0(K1),bit0(L1))
    <=> ord_less(int,K1,L1) ) ).

tff(fact_95_mult__Bit0,axiom,
    ! [L: int,K: int] : ( times_times(int,bit0(K),L) = bit0(times_times(int,K,L)) ) ).

tff(fact_96_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y: int,X: int] :
          ( ord_less(A,number_number_of(A,X),number_number_of(A,Y))
        <=> ord_less(int,X,Y) ) ) ).

%----Arities (39)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ord_less_eq(int,zero_zero(int),power_power(int,s,number_number_of(nat,bit0(bit1(pls))))) ).

%------------------------------------------------------------------------------
