%------------------------------------------------------------------------------
% File     : NUM952_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 74
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : s2s_74 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  143 (  67 unt;  30 typ;   0 def)
%            Number of atoms       :  178 ( 101 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :   79 (  14   ~;   2   |;   8   &)
%                                         (  11 <=>;  44  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   3 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   19 (  12   >;   7   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-3 aty)
%            Number of functors    :   15 (  15 usr;   6 con; 0-3 aty)
%            Number of variables   :  190 ( 175   !;   0   ?; 190   :)
%                                         (  15  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:23:40
%------------------------------------------------------------------------------
%----Should-be-implicit typings (3)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

%----Explicit typings (27)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_IntPrimes_Ozprime,type,
    zprime: int > $o ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OMin,type,
    min: int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_Residues_OLegendre,type,
    legendre: ( int * int ) > int ).

tff(sy_c_Residues_OQuadRes,type,
    quadRes: ( int * int ) > $o ).

tff(sy_c_Rings_Odvd__class_Odvd,type,
    dvd_dvd: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_m,type,
    m: int ).

tff(sy_v_s____,type,
    s: int ).

%----Relevant facts (97)
tff(fact_0__096s_A_094_A2_A_N_A_N1_A_061_As_A_094_A2_A_L_A1_096,axiom,
    minus_minus(int,power_power(int,s,number_number_of(nat,bit0(bit1(pls)))),number_number_of(int,min)) = plus_plus(int,power_power(int,s,number_number_of(nat,bit0(bit1(pls)))),one_one(int)) ).

tff(fact_1__0964_A_K_Am_A_L_A1_Advd_As_A_094_A2_A_N_A_N1_096,axiom,
    dvd_dvd(int,plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),minus_minus(int,power_power(int,s,number_number_of(nat,bit0(bit1(pls)))),number_number_of(int,min))) ).

tff(fact_2_p,axiom,
    zprime(plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int))) ).

tff(fact_3__096Legendre_A_N1_A_I4_A_K_Am_A_L_A1_J_A_061_A1_096,axiom,
    legendre(number_number_of(int,min),plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int))) = one_one(int) ).

tff(fact_4_power2__eq__square__number__of,axiom,
    ! [B1: $tType] :
      ( ( monoid_mult(B1)
        & number(B1) )
     => ! [W: int] : ( power_power(B1,number_number_of(B1,W),number_number_of(nat,bit0(bit1(pls)))) = times_times(B1,number_number_of(B1,W),number_number_of(B1,W)) ) ) ).

tff(fact_5_one__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( power_power(A,one_one(A),number_number_of(nat,bit0(bit1(pls)))) = one_one(A) ) ) ).

tff(fact_6_add__special_I2_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( plus_plus(A,one_one(A),number_number_of(A,W)) = number_number_of(A,plus_plus(int,bit1(pls),W)) ) ) ).

tff(fact_7_add__special_I3_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( plus_plus(A,number_number_of(A,V),one_one(A)) = number_number_of(A,plus_plus(int,V,bit1(pls))) ) ) ).

tff(fact_8_one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( plus_plus(A,one_one(A),one_one(A)) = number_number_of(A,bit0(bit1(pls))) ) ) ).

tff(fact_9_mult__Bit1,axiom,
    ! [L: int,K1: int] : ( times_times(int,bit1(K1),L) = plus_plus(int,bit0(times_times(int,K1,L)),L) ) ).

tff(fact_10_numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_11__096QuadRes_A_I4_A_K_Am_A_L_A1_J_A_N1_096,axiom,
    quadRes(plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),number_number_of(int,min)) ).

tff(fact_12_zadd__power2,axiom,
    ! [B: int,A1: int] : ( power_power(int,plus_plus(int,A1,B),number_number_of(nat,bit0(bit1(pls)))) = plus_plus(int,plus_plus(int,power_power(int,A1,number_number_of(nat,bit0(bit1(pls)))),times_times(int,times_times(int,number_number_of(int,bit0(bit1(pls))),A1),B)),power_power(int,B,number_number_of(nat,bit0(bit1(pls))))) ) ).

tff(fact_13_zadd__power3,axiom,
    ! [B: int,A1: int] : ( power_power(int,plus_plus(int,A1,B),number_number_of(nat,bit1(bit1(pls)))) = plus_plus(int,plus_plus(int,plus_plus(int,power_power(int,A1,number_number_of(nat,bit1(bit1(pls)))),times_times(int,times_times(int,number_number_of(int,bit1(bit1(pls))),power_power(int,A1,number_number_of(nat,bit0(bit1(pls))))),B)),times_times(int,times_times(int,number_number_of(int,bit1(bit1(pls))),A1),power_power(int,B,number_number_of(nat,bit0(bit1(pls)))))),power_power(int,B,number_number_of(nat,bit1(bit1(pls))))) ) ).

tff(fact_14_power2__sum,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Y: A,X1: A] : ( power_power(A,plus_plus(A,X1,Y),number_number_of(nat,bit0(bit1(pls)))) = plus_plus(A,plus_plus(A,power_power(A,X1,number_number_of(nat,bit0(bit1(pls)))),power_power(A,Y,number_number_of(nat,bit0(bit1(pls))))),times_times(A,times_times(A,number_number_of(A,bit0(bit1(pls))),X1),Y)) ) ) ).

tff(fact_15_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X: int] :
          ( ( number_number_of(A,X) = number_number_of(A,Y1) )
        <=> ( X = Y1 ) ) ) ).

tff(fact_16_rel__simps_I51_J,axiom,
    ! [L1: int,K: int] :
      ( ( bit1(K) = bit1(L1) )
    <=> ( K = L1 ) ) ).

tff(fact_17_rel__simps_I48_J,axiom,
    ! [L1: int,K: int] :
      ( ( bit0(K) = bit0(L1) )
    <=> ( K = L1 ) ) ).

tff(fact_18_rel__simps_I46_J,axiom,
    ! [K1: int] : ( bit1(K1) != pls ) ).

tff(fact_19_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_20_rel__simps_I50_J,axiom,
    ! [L: int,K1: int] : ( bit1(K1) != bit0(L) ) ).

tff(fact_21_rel__simps_I49_J,axiom,
    ! [L: int,K1: int] : ( bit0(K1) != bit1(L) ) ).

tff(fact_22_rel__simps_I44_J,axiom,
    ! [K: int] :
      ( ( bit0(K) = pls )
    <=> ( K = pls ) ) ).

tff(fact_23_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_24_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_25_mult__Pls,axiom,
    ! [W: int] : ( times_times(int,pls,W) = pls ) ).

tff(fact_26_mult__Bit0,axiom,
    ! [L: int,K1: int] : ( times_times(int,bit0(K1),L) = bit0(times_times(int,K1,L)) ) ).

tff(fact_27_add__Bit0__Bit0,axiom,
    ! [L: int,K1: int] : ( plus_plus(int,bit0(K1),bit0(L)) = bit0(plus_plus(int,K1,L)) ) ).

tff(fact_28_diff__bin__simps_I7_J,axiom,
    ! [L: int,K1: int] : ( minus_minus(int,bit0(K1),bit0(L)) = bit0(minus_minus(int,K1,L)) ) ).

tff(fact_29_rel__simps_I47_J,axiom,
    ! [K: int] :
      ( ( bit1(K) = min )
    <=> ( K = min ) ) ).

tff(fact_30_rel__simps_I43_J,axiom,
    ! [L1: int] :
      ( ( min = bit1(L1) )
    <=> ( min = L1 ) ) ).

tff(fact_31_Bit1__Min,axiom,
    bit1(min) = min ).

tff(fact_32_rel__simps_I37_J,axiom,
    pls != min ).

tff(fact_33_rel__simps_I40_J,axiom,
    min != pls ).

tff(fact_34_rel__simps_I45_J,axiom,
    ! [K1: int] : ( bit0(K1) != min ) ).

tff(fact_35_rel__simps_I42_J,axiom,
    ! [L: int] : ( min != bit0(L) ) ).

tff(fact_36_left__distrib__number__of,axiom,
    ! [B1: $tType] :
      ( ( number(B1)
        & semiring(B1) )
     => ! [V: int,B: B1,A1: B1] : ( times_times(B1,plus_plus(B1,A1,B),number_number_of(B1,V)) = plus_plus(B1,times_times(B1,A1,number_number_of(B1,V)),times_times(B1,B,number_number_of(B1,V))) ) ) ).

tff(fact_37_right__distrib__number__of,axiom,
    ! [B1: $tType] :
      ( ( number(B1)
        & semiring(B1) )
     => ! [C1: B1,B: B1,V: int] : ( times_times(B1,number_number_of(B1,V),plus_plus(B1,B,C1)) = plus_plus(B1,times_times(B1,number_number_of(B1,V),B),times_times(B1,number_number_of(B1,V),C1)) ) ) ).

tff(fact_38_left__diff__distrib__number__of,axiom,
    ! [B1: $tType] :
      ( ( number(B1)
        & ring(B1) )
     => ! [V: int,B: B1,A1: B1] : ( times_times(B1,minus_minus(B1,A1,B),number_number_of(B1,V)) = minus_minus(B1,times_times(B1,A1,number_number_of(B1,V)),times_times(B1,B,number_number_of(B1,V))) ) ) ).

tff(fact_39_right__diff__distrib__number__of,axiom,
    ! [B1: $tType] :
      ( ( number(B1)
        & ring(B1) )
     => ! [C1: B1,B: B1,V: int] : ( times_times(B1,number_number_of(B1,V),minus_minus(B1,B,C1)) = minus_minus(B1,times_times(B1,number_number_of(B1,V),B),times_times(B1,number_number_of(B1,V),C1)) ) ) ).

tff(fact_40_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W),Z)) = times_times(A,number_number_of(A,times_times(int,V,W)),Z) ) ) ).

tff(fact_41_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,times_times(int,V,W)) ) ) ).

tff(fact_42_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( plus_plus(A,number_number_of(A,V),plus_plus(A,number_number_of(A,W),Z)) = plus_plus(A,number_number_of(A,plus_plus(int,V,W)),Z) ) ) ).

tff(fact_43_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( plus_plus(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,plus_plus(int,V,W)) ) ) ).

tff(fact_44_nat__numeral__1__eq__1,axiom,
    number_number_of(nat,bit1(pls)) = one_one(nat) ).

tff(fact_45_add__Bit1__Bit0,axiom,
    ! [L: int,K1: int] : ( plus_plus(int,bit1(K1),bit0(L)) = bit1(plus_plus(int,K1,L)) ) ).

tff(fact_46_add__Bit0__Bit1,axiom,
    ! [L: int,K1: int] : ( plus_plus(int,bit0(K1),bit1(L)) = bit1(plus_plus(int,K1,L)) ) ).

tff(fact_47_diff__bin__simps_I10_J,axiom,
    ! [L: int,K1: int] : ( minus_minus(int,bit1(K1),bit1(L)) = bit0(minus_minus(int,K1,L)) ) ).

tff(fact_48_diff__bin__simps_I9_J,axiom,
    ! [L: int,K1: int] : ( minus_minus(int,bit1(K1),bit0(L)) = bit1(minus_minus(int,K1,L)) ) ).

tff(fact_49_diff__bin__simps_I3_J,axiom,
    ! [L: int] : ( minus_minus(int,pls,bit0(L)) = bit0(minus_minus(int,pls,L)) ) ).

tff(fact_50__096_126_AQuadRes_A_I4_A_K_Am_A_L_A1_J_A_N1_A_061_061_062_ALegendre_A_N1_A_I4_A_K_Am_A_L_A1_J_A_126_061_A1_096,axiom,
    ( ~ quadRes(plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),number_number_of(int,min))
   => ( legendre(number_number_of(int,min),plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int))) != one_one(int) ) ) ).

tff(fact_51_nat__1__add__1,axiom,
    plus_plus(nat,one_one(nat),one_one(nat)) = number_number_of(nat,bit0(bit1(pls))) ).

tff(fact_52_diff__bin__simps_I4_J,axiom,
    ! [L: int] : ( minus_minus(int,pls,bit1(L)) = bit1(minus_minus(int,min,L)) ) ).

tff(fact_53_diff__bin__simps_I6_J,axiom,
    ! [L: int] : ( minus_minus(int,min,bit1(L)) = bit0(minus_minus(int,min,L)) ) ).

tff(fact_54_diff__bin__simps_I5_J,axiom,
    ! [L: int] : ( minus_minus(int,min,bit0(L)) = bit1(minus_minus(int,min,L)) ) ).

tff(fact_55_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X1: int] : ( power_power(int,power_power(int,X1,Y),Z) = power_power(int,X1,times_times(nat,Y,Z)) ) ).

tff(fact_56_number__of__diff,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,minus_minus(int,V,W)) = minus_minus(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_57_zprime__zdvd__power,axiom,
    ! [N1: nat,A1: int,P: int] :
      ( zprime(P)
     => ( dvd_dvd(int,P,power_power(int,A1,N1))
       => dvd_dvd(int,P,A1) ) ) ).

tff(fact_58_nat__mult__2,axiom,
    ! [Z: nat] : ( times_times(nat,number_number_of(nat,bit0(bit1(pls))),Z) = plus_plus(nat,Z,Z) ) ).

tff(fact_59_nat__mult__2__right,axiom,
    ! [Z: nat] : ( times_times(nat,Z,number_number_of(nat,bit0(bit1(pls)))) = plus_plus(nat,Z,Z) ) ).

tff(fact_60_diff__bin__simps_I1_J,axiom,
    ! [K1: int] : ( minus_minus(int,K1,pls) = K1 ) ).

tff(fact_61_int__distrib_I3_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( times_times(int,minus_minus(int,Z1,Z2),W) = minus_minus(int,times_times(int,Z1,W),times_times(int,Z2,W)) ) ).

tff(fact_62_int__distrib_I4_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( times_times(int,W,minus_minus(int,Z1,Z2)) = minus_minus(int,times_times(int,W,Z1),times_times(int,W,Z2)) ) ).

tff(fact_63_zdvd__zdiffD,axiom,
    ! [N1: int,M: int,K1: int] :
      ( dvd_dvd(int,K1,minus_minus(int,M,N1))
     => ( dvd_dvd(int,K1,N1)
       => dvd_dvd(int,K1,M) ) ) ).

tff(fact_64_Numeral1__eq1__nat,axiom,
    one_one(nat) = number_number_of(nat,bit1(pls)) ).

tff(fact_65_zprime__power__zdvd__cancel__right,axiom,
    ! [A1: int,N1: nat,B: int,P: int] :
      ( zprime(P)
     => ( ~ dvd_dvd(int,P,B)
       => ( dvd_dvd(int,power_power(int,P,N1),times_times(int,A1,B))
         => dvd_dvd(int,power_power(int,P,N1),A1) ) ) ) ).

tff(fact_66_zprime__power__zdvd__cancel__left,axiom,
    ! [B: int,N1: nat,A1: int,P: int] :
      ( zprime(P)
     => ( ~ dvd_dvd(int,P,A1)
       => ( dvd_dvd(int,power_power(int,P,N1),times_times(int,A1,B))
         => dvd_dvd(int,power_power(int,P,N1),B) ) ) ) ).

tff(fact_67_zprime__2,axiom,
    zprime(number_number_of(int,bit0(bit1(pls)))) ).

tff(fact_68_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X: A,W1: int] :
          ( ( number_number_of(A,W1) = X )
        <=> ( X = number_number_of(A,W1) ) ) ) ).

tff(fact_69_number__of__is__id,axiom,
    ! [K1: int] : ( number_number_of(int,K1) = K1 ) ).

tff(fact_70_eq__number__of__Pls__Min,axiom,
    number_number_of(int,pls) != number_number_of(int,min) ).

tff(fact_71_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N1: nat,A1: A] : ( power_power(A,A1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N1)) = power_power(A,power_power(A,A1,N1),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_72_Legendre__1mod4,axiom,
    ! [M: int] :
      ( zprime(plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),M),one_one(int)))
     => ( legendre(number_number_of(int,min),plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),M),one_one(int))) = one_one(int) ) ) ).

tff(fact_73_power__m1__even,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [N1: nat] : ( power_power(A,number_number_of(A,min),times_times(nat,number_number_of(nat,bit0(bit1(pls))),N1)) = one_one(A) ) ) ).

tff(fact_74_add__number__of__diff1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [C1: A,W: int,V: int] : ( plus_plus(A,number_number_of(A,V),minus_minus(A,number_number_of(A,W),C1)) = minus_minus(A,number_number_of(A,plus_plus(int,V,W)),C1) ) ) ).

tff(fact_75_pos__zmult__eq__1__iff__lemma,axiom,
    ! [N1: int,M: int] :
      ( ( times_times(int,M,N1) = one_one(int) )
     => ( ( M = one_one(int) )
        | ( M = number_number_of(int,min) ) ) ) ).

tff(fact_76_zmult__eq__1__iff,axiom,
    ! [N: int,Ma: int] :
      ( ( times_times(int,Ma,N) = one_one(int) )
    <=> ( ( ( Ma = one_one(int) )
          & ( N = one_one(int) ) )
        | ( ( Ma = number_number_of(int,min) )
          & ( N = number_number_of(int,min) ) ) ) ) ).

tff(fact_77_add__Pls__right,axiom,
    ! [K1: int] : ( plus_plus(int,K1,pls) = K1 ) ).

tff(fact_78_add__Pls,axiom,
    ! [K1: int] : ( plus_plus(int,pls,K1) = K1 ) ).

tff(fact_79_Bit0__def,axiom,
    ! [K1: int] : ( bit0(K1) = plus_plus(int,K1,K1) ) ).

tff(fact_80_times__numeral__code_I5_J,axiom,
    ! [W: int,V: int] : ( times_times(int,number_number_of(int,V),number_number_of(int,W)) = number_number_of(int,times_times(int,V,W)) ) ).

tff(fact_81_int__distrib_I1_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( times_times(int,plus_plus(int,Z1,Z2),W) = plus_plus(int,times_times(int,Z1,W),times_times(int,Z2,W)) ) ).

tff(fact_82_int__distrib_I2_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( times_times(int,W,plus_plus(int,Z1,Z2)) = plus_plus(int,times_times(int,W,Z1),times_times(int,W,Z2)) ) ).

tff(fact_83_plus__numeral__code_I9_J,axiom,
    ! [W: int,V: int] : ( plus_plus(int,number_number_of(int,V),number_number_of(int,W)) = number_number_of(int,plus_plus(int,V,W)) ) ).

tff(fact_84_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( plus_plus(A,number_number_of(A,pls),A1) = A1 ) ) ).

tff(fact_85_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( plus_plus(A,A1,number_number_of(A,pls)) = A1 ) ) ).

tff(fact_86_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,times_times(int,V,W)) = times_times(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_87_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,plus_plus(int,V,W)) = plus_plus(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_88_Bit1__def,axiom,
    ! [K1: int] : ( bit1(K1) = plus_plus(int,plus_plus(int,one_one(int),K1),K1) ) ).

tff(fact_89_zdvd__period,axiom,
    ! [C: int,T: int,X: int,D: int,A2: int] :
      ( dvd_dvd(int,A2,D)
     => ( dvd_dvd(int,A2,plus_plus(int,X,T))
      <=> dvd_dvd(int,A2,plus_plus(int,plus_plus(int,X,times_times(int,C,D)),T)) ) ) ).

tff(fact_90_zdvd__reduce,axiom,
    ! [Ma: int,N: int,K: int] :
      ( dvd_dvd(int,K,plus_plus(int,N,times_times(int,K,Ma)))
    <=> dvd_dvd(int,K,N) ) ).

tff(fact_91_zspecial__product,axiom,
    ! [B: int,A1: int] : ( times_times(int,plus_plus(int,A1,B),minus_minus(int,A1,B)) = minus_minus(int,power_power(int,A1,number_number_of(nat,bit0(bit1(pls)))),power_power(int,B,number_number_of(nat,bit0(bit1(pls))))) ) ).

tff(fact_92_number__of__Bit1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( number_number_of(A,bit1(W)) = plus_plus(A,plus_plus(A,one_one(A),number_number_of(A,W)),number_number_of(A,W)) ) ) ).

tff(fact_93_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,number_number_of(A,bit1(pls)),A1) = A1 ) ) ).

tff(fact_94_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_95_semiring__numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_96_semiring__norm_I110_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( one_one(A) = number_number_of(A,bit1(pls)) ) ) ).

%----Arities (13)
tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    dvd_dvd(int,plus_plus(int,times_times(int,number_number_of(int,bit0(bit0(bit1(pls)))),m),one_one(int)),plus_plus(int,power_power(int,s,number_number_of(nat,bit0(bit1(pls)))),one_one(int))) ).

%------------------------------------------------------------------------------
