%------------------------------------------------------------------------------
% File     : NUM931_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Sum of two squares line 35
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : s2s_35 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  143 (  19 unt;  26 typ;   0 def)
%            Number of atoms       :  358 (  37 equ)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives :  281 (  40   ~;   8   |;  13   &)
%                                         (  34 <=>; 186  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   13 (   8   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-3 aty)
%            Number of functors    :   10 (  10 usr;   3 con; 0-4 aty)
%            Number of variables   :  323 ( 300   !;   4   ?; 323   :)
%                                         (  19  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:46
%------------------------------------------------------------------------------
%----Should-be-implicit typings (3)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (23)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Archimedean__Field_Ofloor__ceiling,type,
    archim1727834104eiling: 
      !>[A: $tType] : $o ).

tff(sy_c_Archimedean__Field_Oceiling,type,
    archimedean_ceiling: 
      !>[A: $tType] : ( A > int ) ).

tff(sy_c_Archimedean__Field_Ofloor__ceiling__class_Ofloor,type,
    archim2085082626_floor: 
      !>[A: $tType] : ( A > int ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Nat__Transfer_Otsub,type,
    nat_tsub: ( int * int ) > int ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_m,type,
    m: int ).

%----Relevant facts (98)
tff(fact_0__096_126_A1_A_060_061_Am_096,axiom,
    ~ ord_less_eq(int,one_one(int),m) ).

tff(fact_1_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ord_less_eq(A,X2,X2) ) ).

tff(fact_2_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ord_less_eq(int,zero_zero(int),zero_zero(int)) ).

tff(fact_3_conj__le__cong,axiom,
    ! [P1: bool,P: bool,X3: int] :
      ( ( ord_less_eq(int,zero_zero(int),X3)
       => ( pp(P)
        <=> pp(P1) ) )
     => ( ( ord_less_eq(int,zero_zero(int),X3)
          & pp(P) )
      <=> ( ord_less_eq(int,zero_zero(int),X3)
          & pp(P1) ) ) ) ).

tff(fact_4_imp__le__cong,axiom,
    ! [P1: bool,P: bool,X3: int] :
      ( ( ord_less_eq(int,zero_zero(int),X3)
       => ( pp(P)
        <=> pp(P1) ) )
     => ( ( ord_less_eq(int,zero_zero(int),X3)
         => pp(P) )
      <=> ( ord_less_eq(int,zero_zero(int),X3)
         => pp(P1) ) ) ) ).

tff(fact_5_Nat__Transfer_Otransfer__nat__int__function__closures_I6_J,axiom,
    ord_less_eq(int,zero_zero(int),one_one(int)) ).

tff(fact_6_zero__le__floor,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less_eq(int,zero_zero(int),archim2085082626_floor(A,X3))
        <=> ord_less_eq(A,zero_zero(A),X3) ) ) ).

tff(fact_7_ceiling__le__zero,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less_eq(int,archimedean_ceiling(A,X3),zero_zero(int))
        <=> ord_less_eq(A,X3,zero_zero(A)) ) ) ).

tff(fact_8_not__one__le__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less_eq(A,one_one(A),zero_zero(A)) ) ).

tff(fact_9_zero__le__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less_eq(A,zero_zero(A),one_one(A)) ) ).

tff(fact_10_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X4: A] : ord_less_eq(B,aa(A,B,F,X4),aa(A,B,G,X4)) ) ) ).

tff(fact_11_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
          | ord_less_eq(A,Y1,X2) ) ) ).

tff(fact_12_floor__zero,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ( archim2085082626_floor(A,zero_zero(A)) = zero_zero(int) ) ) ).

tff(fact_13_ceiling__zero,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ( archimedean_ceiling(A,zero_zero(A)) = zero_zero(int) ) ) ).

tff(fact_14_floor__one,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ( archim2085082626_floor(A,one_one(A)) = one_one(int) ) ) ).

tff(fact_15_ceiling__one,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ( archimedean_ceiling(A,one_one(A)) = one_one(int) ) ) ).

tff(fact_16_one__le__floor,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less_eq(int,one_one(int),archim2085082626_floor(A,X3))
        <=> ord_less_eq(A,one_one(A),X3) ) ) ).

tff(fact_17_ceiling__le__one,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less_eq(int,archimedean_ceiling(A,X3),one_one(int))
        <=> ord_less_eq(A,X3,one_one(A)) ) ) ).

tff(fact_18_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X3: A] :
          ( ( one_one(A) = X3 )
        <=> ( X3 = one_one(A) ) ) ) ).

tff(fact_19_ceiling__mono,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X2: A,Y1: A] :
          ( ord_less_eq(A,Y1,X2)
         => ord_less_eq(int,archimedean_ceiling(A,Y1),archimedean_ceiling(A,X2)) ) ) ).

tff(fact_20_floor__mono,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ord_less_eq(int,archim2085082626_floor(A,X2),archim2085082626_floor(A,Y1)) ) ) ).

tff(fact_21_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_22_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_23_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X3: A] :
          ( ( zero_zero(A) = X3 )
        <=> ( X3 = zero_zero(A) ) ) ) ).

tff(fact_24_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ~ ord_less_eq(A,X2,Y1)
         => ord_less_eq(A,Y1,X2) ) ) ).

tff(fact_25_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X3: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X3),aa(A,B,G,X3)) ) ) ).

tff(fact_26_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ord_less_eq(A,Y1,Z)
           => ord_less_eq(A,X2,Z) ) ) ) ).

tff(fact_27_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ord_less_eq(A,Y1,X2)
           => ( X2 = Y1 ) ) ) ) ).

tff(fact_28_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ord_less_eq(A,A2,B2)
         => ( ( B2 = C1 )
           => ord_less_eq(A,A2,C1) ) ) ) ).

tff(fact_29_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less_eq(A,B2,C1)
           => ord_less_eq(A,A2,C1) ) ) ) ).

tff(fact_30_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X3: A,Y2: A] :
          ( ord_less_eq(A,Y2,X3)
         => ( ord_less_eq(A,X3,Y2)
          <=> ( X3 = Y2 ) ) ) ) ).

tff(fact_31_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X3: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X3),aa(A,B,G,X3)) ) ) ).

tff(fact_32_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 = Y1 )
         => ord_less_eq(A,X2,Y1) ) ) ).

tff(fact_33_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X3: A] :
          ( ( X3 = Y2 )
        <=> ( ord_less_eq(A,X3,Y2)
            & ord_less_eq(A,Y2,X3) ) ) ) ).

tff(fact_34_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ! [X: A] : ord_less_eq(B,aa(A,B,F,X),aa(A,B,G,X))
         => ord_less_eq(fun(A,B),F,G) ) ) ).

tff(fact_35_ceiling__less__one,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less(int,archimedean_ceiling(A,X3),one_one(int))
        <=> ord_less_eq(A,X3,zero_zero(A)) ) ) ).

tff(fact_36_zero__less__floor,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less(int,zero_zero(int),archim2085082626_floor(A,X3))
        <=> ord_less_eq(A,one_one(A),X3) ) ) ).

tff(fact_37_one__le__ceiling,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less_eq(int,one_one(int),archimedean_ceiling(A,X3))
        <=> ord_less(A,zero_zero(A),X3) ) ) ).

tff(fact_38_floor__le__zero,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less_eq(int,archim2085082626_floor(A,X3),zero_zero(int))
        <=> ord_less(A,X3,one_one(A)) ) ) ).

tff(fact_39_Nat__Transfer_Otransfer__nat__int__function__closures_I3_J,axiom,
    ! [Y1: int,X2: int] :
      ( ord_less_eq(int,zero_zero(int),X2)
     => ( ord_less_eq(int,zero_zero(int),Y1)
       => ord_less_eq(int,zero_zero(int),nat_tsub(X2,Y1)) ) ) ).

tff(fact_40_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),A1: A] :
          ( ord_less_eq(A,A1,aa(B,A,F,B1))
         => ( ord_less_eq(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less_eq(B,X,Y)
                 => ord_less_eq(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less_eq(A,A1,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_41_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C: B,B1: B,F: fun(B,A),A1: A] :
          ( ( A1 = aa(B,A,F,B1) )
         => ( ord_less_eq(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less_eq(B,X,Y)
                 => ord_less_eq(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less_eq(A,A1,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_42_order__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,F: fun(A,B),B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ord_less_eq(B,aa(A,B,F,B1),C)
           => ( ! [X: A,Y: A] :
                  ( ord_less_eq(A,X,Y)
                 => ord_less_eq(B,aa(A,B,F,X),aa(A,B,F,Y)) )
             => ord_less_eq(B,aa(A,B,F,A1),C) ) ) ) ) ).

tff(fact_43_floor__less__zero,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less(int,archim2085082626_floor(A,X3),zero_zero(int))
        <=> ord_less(A,X3,zero_zero(A)) ) ) ).

tff(fact_44_zero__less__ceiling,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less(int,zero_zero(int),archimedean_ceiling(A,X3))
        <=> ord_less(A,zero_zero(A),X3) ) ) ).

tff(fact_45_floor__less__one,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less(int,archim2085082626_floor(A,X3),one_one(int))
        <=> ord_less(A,X3,one_one(A)) ) ) ).

tff(fact_46_one__less__ceiling,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [X3: A] :
          ( ord_less(int,one_one(int),archimedean_ceiling(A,X3))
        <=> ord_less(A,one_one(A),X3) ) ) ).

tff(fact_47_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ~ ord_less(A,X2,X2) ) ).

tff(fact_48_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ( X3 != Y2 )
        <=> ( ord_less(A,X3,Y2)
            | ord_less(A,Y2,X3) ) ) ) ).

tff(fact_49_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ~ ord_less(A,X3,Y2)
        <=> ( ord_less(A,Y2,X3)
            | ( X3 = Y2 ) ) ) ) ).

tff(fact_50_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
          | ( X2 = Y1 )
          | ord_less(A,Y1,X2) ) ) ).

tff(fact_51_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X3: A,Y2: A] :
          ( ~ ord_less(A,Y2,X3)
         => ( ~ ord_less(A,X3,Y2)
          <=> ( X3 = Y2 ) ) ) ) ).

tff(fact_52_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 != Y1 )
         => ( ~ ord_less(A,X2,Y1)
           => ord_less(A,Y1,X2) ) ) ) ).

tff(fact_53_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 != Y1 )
         => ( ~ ord_less(A,X2,Y1)
           => ord_less(A,Y1,X2) ) ) ) ).

tff(fact_54_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( X2 != Y1 ) ) ) ).

tff(fact_55_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ~ ord_less(A,Y1,X2) ) ) ).

tff(fact_56_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ~ ord_less(A,Y1,X2) ) ) ).

tff(fact_57_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( X2 != Y1 ) ) ) ).

tff(fact_58_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( Y1 != X2 ) ) ) ).

tff(fact_59_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P: bool,Y2: A,X3: A] :
          ( ord_less(A,X3,Y2)
         => ( ord_less(A,Y2,X3)
           => pp(P) ) ) ) ).

tff(fact_60_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ~ ord_less(A,B2,A2) ) ) ).

tff(fact_61_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less(A,B2,C1)
           => ord_less(A,A2,C1) ) ) ) ).

tff(fact_62_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ( ( B2 = C1 )
           => ord_less(A,A2,C1) ) ) ) ).

tff(fact_63_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( ord_less(A,Y1,Z)
           => ord_less(A,X2,Z) ) ) ) ).

tff(fact_64_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ~ ord_less(A,Y1,X2) ) ) ).

tff(fact_65_ceiling__less__cancel,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(int,archimedean_ceiling(A,X2),archimedean_ceiling(A,Y1))
         => ord_less(A,X2,Y1) ) ) ).

tff(fact_66_floor__less__cancel,axiom,
    ! [A: $tType] :
      ( archim1727834104eiling(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(int,archim2085082626_floor(A,X2),archim2085082626_floor(A,Y1))
         => ord_less(A,X2,Y1) ) ) ).

tff(fact_67_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ~ ord_less(A,X2,Y1)
         => ( ( X2 != Y1 )
           => ord_less(A,Y1,X2) ) ) ) ).

tff(fact_68_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less(fun(A,B),F,G)
        <=> ( ord_less_eq(fun(A,B),F,G)
            & ~ ord_less_eq(fun(A,B),G,F) ) ) ) ).

tff(fact_69_linorder__not__less,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ~ ord_less(A,X3,Y2)
        <=> ord_less_eq(A,Y2,X3) ) ) ).

tff(fact_70_linorder__not__le,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ~ ord_less_eq(A,X3,Y2)
        <=> ord_less(A,Y2,X3) ) ) ).

tff(fact_71_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
          | ord_less(A,Y1,X2) ) ) ).

tff(fact_72_order__less__le,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X3: A] :
          ( ord_less(A,X3,Y2)
        <=> ( ord_less_eq(A,X3,Y2)
            & ( X3 != Y2 ) ) ) ) ).

tff(fact_73_less__le__not__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X3: A] :
          ( ord_less(A,X3,Y2)
        <=> ( ord_less_eq(A,X3,Y2)
            & ~ ord_less_eq(A,Y2,X3) ) ) ) ).

tff(fact_74_order__le__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X3: A] :
          ( ord_less_eq(A,X3,Y2)
        <=> ( ord_less(A,X3,Y2)
            | ( X3 = Y2 ) ) ) ) ).

tff(fact_75_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ~ ord_less(A,X2,Y1)
         => ord_less_eq(A,Y1,X2) ) ) ).

tff(fact_76_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X2: A,Y1: A] :
          ( ~ ord_less_eq(A,Y1,X2)
         => ord_less(A,X2,Y1) ) ) ).

tff(fact_77_linorder__antisym__conv1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ~ ord_less(A,X3,Y2)
         => ( ord_less_eq(A,X3,Y2)
          <=> ( X3 = Y2 ) ) ) ) ).

tff(fact_78_order__neq__le__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ( A2 != B2 )
         => ( ord_less_eq(A,A2,B2)
           => ord_less(A,A2,B2) ) ) ) ).

tff(fact_79_leD,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X2: A,Y1: A] :
          ( ord_less_eq(A,Y1,X2)
         => ~ ord_less(A,X2,Y1) ) ) ).

tff(fact_80_order__less__imp__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ord_less_eq(A,X2,Y1) ) ) ).

tff(fact_81_linorder__antisym__conv2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ord_less_eq(A,X3,Y2)
         => ( ~ ord_less(A,X3,Y2)
          <=> ( X3 = Y2 ) ) ) ) ).

tff(fact_82_order__le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ord_less(A,X2,Y1)
            | ( X2 = Y1 ) ) ) ) ).

tff(fact_83_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ord_less_eq(A,A2,B2)
         => ( ( A2 != B2 )
           => ord_less(A,A2,B2) ) ) ) ).

tff(fact_84_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( ord_less_eq(A,Y1,Z)
           => ord_less(A,X2,Z) ) ) ) ).

tff(fact_85_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ord_less(A,Y1,Z)
           => ord_less(A,X2,Z) ) ) ) ).

tff(fact_86_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_87_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_88_int__one__le__iff__zero__less,axiom,
    ! [Z2: int] :
      ( ord_less_eq(int,one_one(int),Z2)
    <=> ord_less(int,zero_zero(int),Z2) ) ).

tff(fact_89_minf_I8_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z1: A] :
        ! [X1: A] :
          ( ord_less(A,X1,Z1)
         => ~ ord_less_eq(A,T,X1) ) ) ).

tff(fact_90_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z1: A] :
        ! [X1: A] :
          ( ord_less(A,Z1,X1)
         => ord_less_eq(A,T,X1) ) ) ).

tff(fact_91_minf_I6_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z1: A] :
        ! [X1: A] :
          ( ord_less(A,X1,Z1)
         => ord_less_eq(A,X1,T) ) ) ).

tff(fact_92_less__int__def,axiom,
    ! [W: int,Z2: int] :
      ( ord_less(int,Z2,W)
    <=> ( ord_less_eq(int,Z2,W)
        & ( Z2 != W ) ) ) ).

tff(fact_93_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),A1: A] :
          ( ord_less_eq(A,A1,aa(B,A,F,B1))
         => ( ord_less(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less(B,X,Y)
                 => ord_less(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less(A,A1,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_94_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),A1: A] :
          ( ord_less(A,A1,aa(B,A,F,B1))
         => ( ord_less_eq(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less_eq(B,X,Y)
                 => ord_less_eq(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less(A,A1,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_95_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z1: A] :
        ! [X1: A] :
          ( ord_less(A,Z1,X1)
         => ~ ord_less_eq(A,X1,T) ) ) ).

tff(fact_96_dense__le,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Z: A,Y1: A] :
          ( ! [X: A] :
              ( ord_less(A,X,Y1)
             => ord_less_eq(A,X,Z) )
         => ord_less_eq(A,Y1,Z) ) ) ).

tff(fact_97_order__le__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,F: fun(A,B),B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ord_less(B,aa(A,B,F,B1),C)
           => ( ! [X: A,Y: A] :
                  ( ord_less_eq(A,X,Y)
                 => ord_less_eq(B,aa(A,B,F,X),aa(A,B,F,Y)) )
             => ord_less(B,aa(A,B,F,A1),C) ) ) ) ) ).

%----Arities (16)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ord_less_eq(int,m,zero_zero(int)) ).

%------------------------------------------------------------------------------
