%------------------------------------------------------------------------------
% File     : NUM456+6 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Number Theory
% Problem  : Fuerstenberg's infinitude of primes 11_05, 05 expansion
% Version  : Especial.
% English  :

% Refs     : [VLP07] Verchinine et al. (2007), System for Automated Deduction
%          : [Pas08] Paskevich (2008), Email to G. Sutcliffe
% Source   : [Pas08]
% Names    : fuerst_11_05.05 [Pas08]

% Status   : ContradictoryAxioms
% Rating   : 0.24 v9.1.0, 0.21 v9.0.0, 0.25 v8.2.0, 0.19 v8.1.0, 0.14 v7.5.0, 0.16 v7.4.0, 0.29 v7.3.0, 0.00 v7.0.0, 0.17 v6.4.0, 0.19 v6.3.0, 0.12 v6.2.0, 0.16 v6.1.0, 0.23 v6.0.0, 0.13 v5.5.0, 0.33 v5.4.0, 0.36 v5.3.0, 0.44 v5.2.0, 0.30 v5.1.0, 0.38 v5.0.0, 0.46 v4.1.0, 0.57 v4.0.1, 0.78 v4.0.0
% Syntax   : Number of formulae    :   48 (   4 unt;  10 def)
%            Number of atoms       :  330 (  62 equ)
%            Maximal formula atoms :   56 (   6 avg)
%            Number of connectives :  306 (  24   ~;  15   |; 173   &)
%                                         (  25 <=>;  69  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   24 (   7 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :   13 (  10 usr;   2 prp; 0-3 aty)
%            Number of functors    :   16 (  16 usr;   8 con; 0-2 aty)
%            Number of variables   :  129 ( 105   !;  24   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : Problem generated by the SAD system [VLP07]
%------------------------------------------------------------------------------
fof(mIntegers,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => $true ) ).

fof(mIntZero,axiom,
    aInteger0(sz00) ).

fof(mIntOne,axiom,
    aInteger0(sz10) ).

fof(mIntNeg,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => aInteger0(smndt0(W0)) ) ).

fof(mIntPlus,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => aInteger0(sdtpldt0(W0,W1)) ) ).

fof(mIntMult,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => aInteger0(sdtasdt0(W0,W1)) ) ).

fof(mAddAsso,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => sdtpldt0(W0,sdtpldt0(W1,W2)) = sdtpldt0(sdtpldt0(W0,W1),W2) ) ).

fof(mAddComm,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => sdtpldt0(W0,W1) = sdtpldt0(W1,W0) ) ).

fof(mAddZero,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtpldt0(W0,sz00) = W0
        & W0 = sdtpldt0(sz00,W0) ) ) ).

fof(mAddNeg,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtpldt0(W0,smndt0(W0)) = sz00
        & sz00 = sdtpldt0(smndt0(W0),W0) ) ) ).

fof(mMulAsso,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => sdtasdt0(W0,sdtasdt0(W1,W2)) = sdtasdt0(sdtasdt0(W0,W1),W2) ) ).

fof(mMulComm,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => sdtasdt0(W0,W1) = sdtasdt0(W1,W0) ) ).

fof(mMulOne,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(W0,sz10) = W0
        & W0 = sdtasdt0(sz10,W0) ) ) ).

fof(mDistrib,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => ( sdtasdt0(W0,sdtpldt0(W1,W2)) = sdtpldt0(sdtasdt0(W0,W1),sdtasdt0(W0,W2))
        & sdtasdt0(sdtpldt0(W0,W1),W2) = sdtpldt0(sdtasdt0(W0,W2),sdtasdt0(W1,W2)) ) ) ).

fof(mMulZero,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(W0,sz00) = sz00
        & sz00 = sdtasdt0(sz00,W0) ) ) ).

fof(mMulMinOne,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(smndt0(sz10),W0) = smndt0(W0)
        & smndt0(W0) = sdtasdt0(W0,smndt0(sz10)) ) ) ).

fof(mZeroDiv,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => ( sdtasdt0(W0,W1) = sz00
       => ( W0 = sz00
          | W1 = sz00 ) ) ) ).

fof(mDivisor,definition,
    ! [W0] :
      ( aInteger0(W0)
     => ! [W1] :
          ( aDivisorOf0(W1,W0)
        <=> ( aInteger0(W1)
            & W1 != sz00
            & ? [W2] :
                ( aInteger0(W2)
                & sdtasdt0(W1,W2) = W0 ) ) ) ) ).

fof(mEquMod,definition,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
      <=> aDivisorOf0(W2,sdtpldt0(W0,smndt0(W1))) ) ) ).

fof(mEquModRef,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & W1 != sz00 )
     => sdteqdtlpzmzozddtrp0(W0,W0,W1) ) ).

fof(mEquModSym,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
       => sdteqdtlpzmzozddtrp0(W1,W0,W2) ) ) ).

fof(mEquModTrn,axiom,
    ! [W0,W1,W2,W3] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00
        & aInteger0(W3) )
     => ( ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
          & sdteqdtlpzmzozddtrp0(W1,W3,W2) )
       => sdteqdtlpzmzozddtrp0(W0,W3,W2) ) ) ).

fof(mEquModMul,axiom,
    ! [W0,W1,W2,W3] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00
        & aInteger0(W3)
        & W3 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,sdtasdt0(W2,W3))
       => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
          & sdteqdtlpzmzozddtrp0(W0,W1,W3) ) ) ) ).

fof(mPrime,axiom,
    ! [W0] :
      ( ( aInteger0(W0)
        & W0 != sz00 )
     => ( isPrime0(W0)
       => $true ) ) ).

fof(mPrimeDivisor,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( ? [W1] :
            ( aDivisorOf0(W1,W0)
            & isPrime0(W1) )
      <=> ( W0 != sz10
          & W0 != smndt0(sz10) ) ) ) ).

fof(mSets,axiom,
    ! [W0] :
      ( aSet0(W0)
     => $true ) ).

fof(mElements,axiom,
    ! [W0] :
      ( aSet0(W0)
     => ! [W1] :
          ( aElementOf0(W1,W0)
         => $true ) ) ).

fof(mSubset,definition,
    ! [W0] :
      ( aSet0(W0)
     => ! [W1] :
          ( aSubsetOf0(W1,W0)
        <=> ( aSet0(W1)
            & ! [W2] :
                ( aElementOf0(W2,W1)
               => aElementOf0(W2,W0) ) ) ) ) ).

fof(mFinSet,axiom,
    ! [W0] :
      ( aSet0(W0)
     => ( isFinite0(W0)
       => $true ) ) ).

fof(mUnion,definition,
    ! [W0,W1] :
      ( ( aSubsetOf0(W0,cS1395)
        & aSubsetOf0(W1,cS1395) )
     => ! [W2] :
          ( W2 = sdtbsmnsldt0(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ( aInteger0(W3)
                  & ( aElementOf0(W3,W0)
                    | aElementOf0(W3,W1) ) ) ) ) ) ) ).

fof(mIntersection,definition,
    ! [W0,W1] :
      ( ( aSubsetOf0(W0,cS1395)
        & aSubsetOf0(W1,cS1395) )
     => ! [W2] :
          ( W2 = sdtslmnbsdt0(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ( aInteger0(W3)
                  & aElementOf0(W3,W0)
                  & aElementOf0(W3,W1) ) ) ) ) ) ).

fof(mUnionSet,definition,
    ! [W0] :
      ( ( aSet0(W0)
        & ! [W1] :
            ( aElementOf0(W1,W0)
           => aSubsetOf0(W1,cS1395) ) )
     => ! [W1] :
          ( W1 = sbsmnsldt0(W0)
        <=> ( aSet0(W1)
            & ! [W2] :
                ( aElementOf0(W2,W1)
              <=> ( aInteger0(W2)
                  & ? [W3] :
                      ( aElementOf0(W3,W0)
                      & aElementOf0(W2,W3) ) ) ) ) ) ) ).

fof(mComplement,definition,
    ! [W0] :
      ( aSubsetOf0(W0,cS1395)
     => ! [W1] :
          ( W1 = stldt0(W0)
        <=> ( aSet0(W1)
            & ! [W2] :
                ( aElementOf0(W2,W1)
              <=> ( aInteger0(W2)
                  & ~ aElementOf0(W2,W0) ) ) ) ) ) ).

fof(mArSeq,definition,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & W1 != sz00 )
     => ! [W2] :
          ( W2 = szAzrzSzezqlpdtcmdtrp0(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ( aInteger0(W3)
                  & sdteqdtlpzmzozddtrp0(W3,W0,W1) ) ) ) ) ) ).

fof(mOpen,definition,
    ! [W0] :
      ( aSubsetOf0(W0,cS1395)
     => ( isOpen0(W0)
      <=> ! [W1] :
            ( aElementOf0(W1,W0)
           => ? [W2] :
                ( aInteger0(W2)
                & W2 != sz00
                & aSubsetOf0(szAzrzSzezqlpdtcmdtrp0(W1,W2),W0) ) ) ) ) ).

fof(mClosed,definition,
    ! [W0] :
      ( aSubsetOf0(W0,cS1395)
     => ( isClosed0(W0)
      <=> isOpen0(stldt0(W0)) ) ) ).

fof(mUnionOpen,axiom,
    ! [W0] :
      ( ( aSet0(W0)
        & ! [W1] :
            ( aElementOf0(W1,W0)
           => ( aSubsetOf0(W1,cS1395)
              & isOpen0(W1) ) ) )
     => isOpen0(sbsmnsldt0(W0)) ) ).

fof(mInterOpen,axiom,
    ! [W0,W1] :
      ( ( aSubsetOf0(W0,cS1395)
        & aSubsetOf0(W1,cS1395)
        & isOpen0(W0)
        & isOpen0(W1) )
     => isOpen0(sdtslmnbsdt0(W0,W1)) ) ).

fof(mUnionClosed,axiom,
    ! [W0,W1] :
      ( ( aSubsetOf0(W0,cS1395)
        & aSubsetOf0(W1,cS1395)
        & isClosed0(W0)
        & isClosed0(W1) )
     => isClosed0(sdtbsmnsldt0(W0,W1)) ) ).

fof(mUnionSClosed,axiom,
    ! [W0] :
      ( ( aSet0(W0)
        & isFinite0(W0)
        & ! [W1] :
            ( aElementOf0(W1,W0)
           => ( aSubsetOf0(W1,cS1395)
              & isClosed0(W1) ) ) )
     => isClosed0(sbsmnsldt0(W0)) ) ).

fof(mArSeqClosed,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & W1 != sz00 )
     => ( aSubsetOf0(szAzrzSzezqlpdtcmdtrp0(W0,W1),cS1395)
        & isClosed0(szAzrzSzezqlpdtcmdtrp0(W0,W1)) ) ) ).

fof(m__2046,hypothesis,
    ( aSet0(xS)
    & ! [W0] :
        ( ( aElementOf0(W0,xS)
         => ? [W1] :
              ( aInteger0(W1)
              & W1 != sz00
              & isPrime0(W1)
              & aSet0(szAzrzSzezqlpdtcmdtrp0(sz00,W1))
              & ! [W2] :
                  ( ( aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(sz00,W1))
                   => ( aInteger0(W2)
                      & ? [W3] :
                          ( aInteger0(W3)
                          & sdtasdt0(W1,W3) = sdtpldt0(W2,smndt0(sz00)) )
                      & aDivisorOf0(W1,sdtpldt0(W2,smndt0(sz00)))
                      & sdteqdtlpzmzozddtrp0(W2,sz00,W1) ) )
                  & ( ( aInteger0(W2)
                      & ( ? [W3] :
                            ( aInteger0(W3)
                            & sdtasdt0(W1,W3) = sdtpldt0(W2,smndt0(sz00)) )
                        | aDivisorOf0(W1,sdtpldt0(W2,smndt0(sz00)))
                        | sdteqdtlpzmzozddtrp0(W2,sz00,W1) ) )
                   => aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(sz00,W1)) ) )
              & szAzrzSzezqlpdtcmdtrp0(sz00,W1) = W0 ) )
        & ( ? [W1] :
              ( aInteger0(W1)
              & W1 != sz00
              & isPrime0(W1)
              & ( ( aSet0(szAzrzSzezqlpdtcmdtrp0(sz00,W1))
                  & ! [W2] :
                      ( ( aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(sz00,W1))
                       => ( aInteger0(W2)
                          & ? [W3] :
                              ( aInteger0(W3)
                              & sdtasdt0(W1,W3) = sdtpldt0(W2,smndt0(sz00)) )
                          & aDivisorOf0(W1,sdtpldt0(W2,smndt0(sz00)))
                          & sdteqdtlpzmzozddtrp0(W2,sz00,W1) ) )
                      & ( ( aInteger0(W2)
                          & ( ? [W3] :
                                ( aInteger0(W3)
                                & sdtasdt0(W1,W3) = sdtpldt0(W2,smndt0(sz00)) )
                            | aDivisorOf0(W1,sdtpldt0(W2,smndt0(sz00)))
                            | sdteqdtlpzmzozddtrp0(W2,sz00,W1) ) )
                       => aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(sz00,W1)) ) ) )
               => szAzrzSzezqlpdtcmdtrp0(sz00,W1) = W0 ) )
         => aElementOf0(W0,xS) ) )
    & xS = cS2043 ) ).

fof(m__2079,hypothesis,
    ( aSet0(sbsmnsldt0(xS))
    & ! [W0] :
        ( aElementOf0(W0,sbsmnsldt0(xS))
      <=> ( aInteger0(W0)
          & ? [W1] :
              ( aElementOf0(W1,xS)
              & aElementOf0(W0,W1) ) ) )
    & aSet0(stldt0(sbsmnsldt0(xS)))
    & ! [W0] :
        ( aElementOf0(W0,stldt0(sbsmnsldt0(xS)))
      <=> ( aInteger0(W0)
          & ~ aElementOf0(W0,sbsmnsldt0(xS)) ) )
    & ! [W0] :
        ( aElementOf0(W0,stldt0(sbsmnsldt0(xS)))
      <=> ( W0 = sz10
          | W0 = smndt0(sz10) ) )
    & stldt0(sbsmnsldt0(xS)) = cS2076 ) ).

fof(m__2117,hypothesis,
    isFinite0(xS) ).

fof(m__2144,hypothesis,
    ( aSet0(sbsmnsldt0(xS))
    & ! [W0] :
        ( aElementOf0(W0,sbsmnsldt0(xS))
      <=> ( aInteger0(W0)
          & ? [W1] :
              ( aElementOf0(W1,xS)
              & aElementOf0(W0,W1) ) ) )
    & ! [W0] :
        ( aElementOf0(W0,stldt0(sbsmnsldt0(xS)))
      <=> ( aInteger0(W0)
          & ~ aElementOf0(W0,sbsmnsldt0(xS)) ) )
    & ! [W0] :
        ( aElementOf0(W0,stldt0(sbsmnsldt0(xS)))
       => ? [W1] :
            ( aInteger0(W1)
            & W1 != sz00
            & aSet0(szAzrzSzezqlpdtcmdtrp0(W0,W1))
            & ! [W2] :
                ( ( aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(W0,W1))
                 => ( aInteger0(W2)
                    & ? [W3] :
                        ( aInteger0(W3)
                        & sdtasdt0(W1,W3) = sdtpldt0(W2,smndt0(W0)) )
                    & aDivisorOf0(W1,sdtpldt0(W2,smndt0(W0)))
                    & sdteqdtlpzmzozddtrp0(W2,W0,W1) ) )
                & ( ( aInteger0(W2)
                    & ( ? [W3] :
                          ( aInteger0(W3)
                          & sdtasdt0(W1,W3) = sdtpldt0(W2,smndt0(W0)) )
                      | aDivisorOf0(W1,sdtpldt0(W2,smndt0(W0)))
                      | sdteqdtlpzmzozddtrp0(W2,W0,W1) ) )
                 => aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(W0,W1)) ) )
            & ! [W2] :
                ( aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(W0,W1))
               => aElementOf0(W2,stldt0(sbsmnsldt0(xS))) )
            & aSubsetOf0(szAzrzSzezqlpdtcmdtrp0(W0,W1),stldt0(sbsmnsldt0(xS))) ) )
    & isOpen0(stldt0(sbsmnsldt0(xS)))
    & isClosed0(sbsmnsldt0(xS))
    & aSet0(sbsmnsldt0(xS))
    & ! [W0] :
        ( aElementOf0(W0,sbsmnsldt0(xS))
      <=> ( aInteger0(W0)
          & ? [W1] :
              ( aElementOf0(W1,xS)
              & aElementOf0(W0,W1) ) ) )
    & ! [W0] :
        ( aElementOf0(W0,stldt0(sbsmnsldt0(xS)))
      <=> ( aInteger0(W0)
          & ~ aElementOf0(W0,sbsmnsldt0(xS)) ) )
    & ! [W0] :
        ( aElementOf0(W0,stldt0(sbsmnsldt0(xS)))
       => ? [W1] :
            ( aInteger0(W1)
            & W1 != sz00
            & aSet0(szAzrzSzezqlpdtcmdtrp0(W0,W1))
            & ! [W2] :
                ( ( aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(W0,W1))
                 => ( aInteger0(W2)
                    & ? [W3] :
                        ( aInteger0(W3)
                        & sdtasdt0(W1,W3) = sdtpldt0(W2,smndt0(W0)) )
                    & aDivisorOf0(W1,sdtpldt0(W2,smndt0(W0)))
                    & sdteqdtlpzmzozddtrp0(W2,W0,W1) ) )
                & ( ( aInteger0(W2)
                    & ( ? [W3] :
                          ( aInteger0(W3)
                          & sdtasdt0(W1,W3) = sdtpldt0(W2,smndt0(W0)) )
                      | aDivisorOf0(W1,sdtpldt0(W2,smndt0(W0)))
                      | sdteqdtlpzmzozddtrp0(W2,W0,W1) ) )
                 => aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(W0,W1)) ) )
            & ! [W2] :
                ( aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(W0,W1))
               => aElementOf0(W2,stldt0(sbsmnsldt0(xS))) )
            & aSubsetOf0(szAzrzSzezqlpdtcmdtrp0(W0,W1),stldt0(sbsmnsldt0(xS))) ) ) ) ).

fof(m__2171,hypothesis,
    ( aInteger0(xp)
    & xp != sz00
    & aSet0(szAzrzSzezqlpdtcmdtrp0(sz10,xp))
    & ! [W0] :
        ( ( aElementOf0(W0,szAzrzSzezqlpdtcmdtrp0(sz10,xp))
         => ( aInteger0(W0)
            & ? [W1] :
                ( aInteger0(W1)
                & sdtasdt0(xp,W1) = sdtpldt0(W0,smndt0(sz10)) )
            & aDivisorOf0(xp,sdtpldt0(W0,smndt0(sz10)))
            & sdteqdtlpzmzozddtrp0(W0,sz10,xp) ) )
        & ( ( aInteger0(W0)
            & ( ? [W1] :
                  ( aInteger0(W1)
                  & sdtasdt0(xp,W1) = sdtpldt0(W0,smndt0(sz10)) )
              | aDivisorOf0(xp,sdtpldt0(W0,smndt0(sz10)))
              | sdteqdtlpzmzozddtrp0(W0,sz10,xp) ) )
         => aElementOf0(W0,szAzrzSzezqlpdtcmdtrp0(sz10,xp)) ) )
    & aSet0(sbsmnsldt0(xS))
    & ! [W0] :
        ( aElementOf0(W0,sbsmnsldt0(xS))
      <=> ( aInteger0(W0)
          & ? [W1] :
              ( aElementOf0(W1,xS)
              & aElementOf0(W0,W1) ) ) )
    & ! [W0] :
        ( aElementOf0(W0,stldt0(sbsmnsldt0(xS)))
      <=> ( aInteger0(W0)
          & ~ aElementOf0(W0,sbsmnsldt0(xS)) ) )
    & ! [W0] :
        ( aElementOf0(W0,szAzrzSzezqlpdtcmdtrp0(sz10,xp))
       => aElementOf0(W0,stldt0(sbsmnsldt0(xS))) )
    & aSubsetOf0(szAzrzSzezqlpdtcmdtrp0(sz10,xp),stldt0(sbsmnsldt0(xS))) ) ).

fof(m__2203,hypothesis,
    ? [W0] :
      ( aInteger0(W0)
      & ? [W1] :
          ( aInteger0(W1)
          & sdtasdt0(xp,W1) = sdtpldt0(W0,smndt0(sz10)) )
      & aDivisorOf0(xp,sdtpldt0(W0,smndt0(sz10)))
      & sdteqdtlpzmzozddtrp0(W0,sz10,xp)
      & aElementOf0(W0,szAzrzSzezqlpdtcmdtrp0(sz10,xp))
      & ~ ( W0 = sz10
          | W0 = smndt0(sz10)
          | aElementOf0(W0,cS2200) ) ) ).

fof(m__,conjecture,
    $false ).

%------------------------------------------------------------------------------
