%------------------------------------------------------------------------------
% File     : NUM443+4 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Number Theory
% Problem  : Fuerstenberg's infinitude of primes 10_01, 03 expansion
% Version  : Especial.
% English  :

% Refs     : [VLP07] Verchinine et al. (2007), System for Automated Deduction
%          : [Pas08] Paskevich (2008), Email to G. Sutcliffe
% Source   : [Pas08]
% Names    : fuerst_10_01.03 [Pas08]

% Status   : Theorem
% Rating   : 0.27 v9.1.0, 0.21 v9.0.0, 0.19 v8.1.0, 0.11 v7.5.0, 0.09 v7.4.0, 0.13 v7.3.0, 0.14 v7.2.0, 0.10 v7.1.0, 0.09 v7.0.0, 0.07 v6.4.0, 0.15 v6.3.0, 0.08 v6.1.0, 0.20 v6.0.0, 0.26 v5.4.0, 0.32 v5.3.0, 0.37 v5.2.0, 0.20 v5.1.0, 0.33 v5.0.0, 0.42 v4.1.0, 0.52 v4.0.1, 0.83 v4.0.0
% Syntax   : Number of formulae    :   43 (   2 unt;  10 def)
%            Number of atoms       :  220 (  43 equ)
%            Maximal formula atoms :   34 (   5 avg)
%            Number of connectives :  193 (  16   ~;   7   |;  98   &)
%                                         (  16 <=>;  56  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   6 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :   12 (  10 usr;   1 prp; 0-3 aty)
%            Number of functors    :   15 (  15 usr;   7 con; 0-2 aty)
%            Number of variables   :   94 (  85   !;   9   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Problem generated by the SAD system [VLP07]
%------------------------------------------------------------------------------
fof(mIntegers,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => $true ) ).

fof(mIntZero,axiom,
    aInteger0(sz00) ).

fof(mIntOne,axiom,
    aInteger0(sz10) ).

fof(mIntNeg,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => aInteger0(smndt0(W0)) ) ).

fof(mIntPlus,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => aInteger0(sdtpldt0(W0,W1)) ) ).

fof(mIntMult,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => aInteger0(sdtasdt0(W0,W1)) ) ).

fof(mAddAsso,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => sdtpldt0(W0,sdtpldt0(W1,W2)) = sdtpldt0(sdtpldt0(W0,W1),W2) ) ).

fof(mAddComm,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => sdtpldt0(W0,W1) = sdtpldt0(W1,W0) ) ).

fof(mAddZero,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtpldt0(W0,sz00) = W0
        & W0 = sdtpldt0(sz00,W0) ) ) ).

fof(mAddNeg,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtpldt0(W0,smndt0(W0)) = sz00
        & sz00 = sdtpldt0(smndt0(W0),W0) ) ) ).

fof(mMulAsso,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => sdtasdt0(W0,sdtasdt0(W1,W2)) = sdtasdt0(sdtasdt0(W0,W1),W2) ) ).

fof(mMulComm,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => sdtasdt0(W0,W1) = sdtasdt0(W1,W0) ) ).

fof(mMulOne,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(W0,sz10) = W0
        & W0 = sdtasdt0(sz10,W0) ) ) ).

fof(mDistrib,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => ( sdtasdt0(W0,sdtpldt0(W1,W2)) = sdtpldt0(sdtasdt0(W0,W1),sdtasdt0(W0,W2))
        & sdtasdt0(sdtpldt0(W0,W1),W2) = sdtpldt0(sdtasdt0(W0,W2),sdtasdt0(W1,W2)) ) ) ).

fof(mMulZero,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(W0,sz00) = sz00
        & sz00 = sdtasdt0(sz00,W0) ) ) ).

fof(mMulMinOne,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(smndt0(sz10),W0) = smndt0(W0)
        & smndt0(W0) = sdtasdt0(W0,smndt0(sz10)) ) ) ).

fof(mZeroDiv,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => ( sdtasdt0(W0,W1) = sz00
       => ( W0 = sz00
          | W1 = sz00 ) ) ) ).

fof(mDivisor,definition,
    ! [W0] :
      ( aInteger0(W0)
     => ! [W1] :
          ( aDivisorOf0(W1,W0)
        <=> ( aInteger0(W1)
            & W1 != sz00
            & ? [W2] :
                ( aInteger0(W2)
                & sdtasdt0(W1,W2) = W0 ) ) ) ) ).

fof(mEquMod,definition,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
      <=> aDivisorOf0(W2,sdtpldt0(W0,smndt0(W1))) ) ) ).

fof(mEquModRef,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & W1 != sz00 )
     => sdteqdtlpzmzozddtrp0(W0,W0,W1) ) ).

fof(mEquModSym,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
       => sdteqdtlpzmzozddtrp0(W1,W0,W2) ) ) ).

fof(mEquModTrn,axiom,
    ! [W0,W1,W2,W3] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00
        & aInteger0(W3) )
     => ( ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
          & sdteqdtlpzmzozddtrp0(W1,W3,W2) )
       => sdteqdtlpzmzozddtrp0(W0,W3,W2) ) ) ).

fof(mEquModMul,axiom,
    ! [W0,W1,W2,W3] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00
        & aInteger0(W3)
        & W3 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,sdtasdt0(W2,W3))
       => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
          & sdteqdtlpzmzozddtrp0(W0,W1,W3) ) ) ) ).

fof(mPrime,axiom,
    ! [W0] :
      ( ( aInteger0(W0)
        & W0 != sz00 )
     => ( isPrime0(W0)
       => $true ) ) ).

fof(mPrimeDivisor,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( ? [W1] :
            ( aDivisorOf0(W1,W0)
            & isPrime0(W1) )
      <=> ( W0 != sz10
          & W0 != smndt0(sz10) ) ) ) ).

fof(mSets,axiom,
    ! [W0] :
      ( aSet0(W0)
     => $true ) ).

fof(mElements,axiom,
    ! [W0] :
      ( aSet0(W0)
     => ! [W1] :
          ( aElementOf0(W1,W0)
         => $true ) ) ).

fof(mSubset,definition,
    ! [W0] :
      ( aSet0(W0)
     => ! [W1] :
          ( aSubsetOf0(W1,W0)
        <=> ( aSet0(W1)
            & ! [W2] :
                ( aElementOf0(W2,W1)
               => aElementOf0(W2,W0) ) ) ) ) ).

fof(mFinSet,axiom,
    ! [W0] :
      ( aSet0(W0)
     => ( isFinite0(W0)
       => $true ) ) ).

fof(mUnion,definition,
    ! [W0,W1] :
      ( ( aSubsetOf0(W0,cS1395)
        & aSubsetOf0(W1,cS1395) )
     => ! [W2] :
          ( W2 = sdtbsmnsldt0(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ( aInteger0(W3)
                  & ( aElementOf0(W3,W0)
                    | aElementOf0(W3,W1) ) ) ) ) ) ) ).

fof(mIntersection,definition,
    ! [W0,W1] :
      ( ( aSubsetOf0(W0,cS1395)
        & aSubsetOf0(W1,cS1395) )
     => ! [W2] :
          ( W2 = sdtslmnbsdt0(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ( aInteger0(W3)
                  & aElementOf0(W3,W0)
                  & aElementOf0(W3,W1) ) ) ) ) ) ).

fof(mUnionSet,definition,
    ! [W0] :
      ( ( aSet0(W0)
        & ! [W1] :
            ( aElementOf0(W1,W0)
           => aSubsetOf0(W1,cS1395) ) )
     => ! [W1] :
          ( W1 = sbsmnsldt0(W0)
        <=> ( aSet0(W1)
            & ! [W2] :
                ( aElementOf0(W2,W1)
              <=> ( aInteger0(W2)
                  & ? [W3] :
                      ( aElementOf0(W3,W0)
                      & aElementOf0(W2,W3) ) ) ) ) ) ) ).

fof(mComplement,definition,
    ! [W0] :
      ( aSubsetOf0(W0,cS1395)
     => ! [W1] :
          ( W1 = stldt0(W0)
        <=> ( aSet0(W1)
            & ! [W2] :
                ( aElementOf0(W2,W1)
              <=> ( aInteger0(W2)
                  & ~ aElementOf0(W2,W0) ) ) ) ) ) ).

fof(mArSeq,definition,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & W1 != sz00 )
     => ! [W2] :
          ( W2 = szAzrzSzezqlpdtcmdtrp0(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ( aInteger0(W3)
                  & sdteqdtlpzmzozddtrp0(W3,W0,W1) ) ) ) ) ) ).

fof(mOpen,definition,
    ! [W0] :
      ( aSubsetOf0(W0,cS1395)
     => ( isOpen0(W0)
      <=> ! [W1] :
            ( aElementOf0(W1,W0)
           => ? [W2] :
                ( aInteger0(W2)
                & W2 != sz00
                & aSubsetOf0(szAzrzSzezqlpdtcmdtrp0(W1,W2),W0) ) ) ) ) ).

fof(mClosed,definition,
    ! [W0] :
      ( aSubsetOf0(W0,cS1395)
     => ( isClosed0(W0)
      <=> isOpen0(stldt0(W0)) ) ) ).

fof(mUnionOpen,axiom,
    ! [W0] :
      ( ( aSet0(W0)
        & ! [W1] :
            ( aElementOf0(W1,W0)
           => ( aSubsetOf0(W1,cS1395)
              & isOpen0(W1) ) ) )
     => isOpen0(sbsmnsldt0(W0)) ) ).

fof(mInterOpen,axiom,
    ! [W0,W1] :
      ( ( aSubsetOf0(W0,cS1395)
        & aSubsetOf0(W1,cS1395)
        & isOpen0(W0)
        & isOpen0(W1) )
     => isOpen0(sdtslmnbsdt0(W0,W1)) ) ).

fof(mUnionClosed,axiom,
    ! [W0,W1] :
      ( ( aSubsetOf0(W0,cS1395)
        & aSubsetOf0(W1,cS1395)
        & isClosed0(W0)
        & isClosed0(W1) )
     => isClosed0(sdtbsmnsldt0(W0,W1)) ) ).

fof(mUnionSClosed,axiom,
    ! [W0] :
      ( ( aSet0(W0)
        & isFinite0(W0)
        & ! [W1] :
            ( aElementOf0(W1,W0)
           => ( aSubsetOf0(W1,cS1395)
              & isClosed0(W1) ) ) )
     => isClosed0(sbsmnsldt0(W0)) ) ).

fof(m__1962,hypothesis,
    ( aInteger0(xa)
    & aInteger0(xq)
    & xq != sz00 ) ).

fof(m__2010,hypothesis,
    ( aInteger0(xb)
    & aInteger0(xc) ) ).

fof(m__,conjecture,
    ( ( aSet0(szAzrzSzezqlpdtcmdtrp0(xa,xq))
      & ! [W0] :
          ( ( aElementOf0(W0,szAzrzSzezqlpdtcmdtrp0(xa,xq))
           => ( aInteger0(W0)
              & ? [W1] :
                  ( aInteger0(W1)
                  & sdtasdt0(xq,W1) = sdtpldt0(W0,smndt0(xa)) )
              & aDivisorOf0(xq,sdtpldt0(W0,smndt0(xa)))
              & sdteqdtlpzmzozddtrp0(W0,xa,xq) ) )
          & ( ( aInteger0(W0)
              & ( ? [W1] :
                    ( aInteger0(W1)
                    & sdtasdt0(xq,W1) = sdtpldt0(W0,smndt0(xa)) )
                | aDivisorOf0(xq,sdtpldt0(W0,smndt0(xa)))
                | sdteqdtlpzmzozddtrp0(W0,xa,xq) ) )
           => aElementOf0(W0,szAzrzSzezqlpdtcmdtrp0(xa,xq)) ) )
      & ~ aElementOf0(xb,szAzrzSzezqlpdtcmdtrp0(xa,xq))
      & aElementOf0(xb,stldt0(szAzrzSzezqlpdtcmdtrp0(xa,xq)))
      & ? [W0] :
          ( aInteger0(W0)
          & sdtasdt0(xq,W0) = sdtpldt0(xc,smndt0(xb)) )
      & aDivisorOf0(xq,sdtpldt0(xc,smndt0(xb)))
      & sdteqdtlpzmzozddtrp0(xc,xb,xq) )
   => ( ( aSet0(szAzrzSzezqlpdtcmdtrp0(xa,xq))
        & ! [W0] :
            ( ( aElementOf0(W0,szAzrzSzezqlpdtcmdtrp0(xa,xq))
             => ( aInteger0(W0)
                & ? [W1] :
                    ( aInteger0(W1)
                    & sdtasdt0(xq,W1) = sdtpldt0(W0,smndt0(xa)) )
                & aDivisorOf0(xq,sdtpldt0(W0,smndt0(xa)))
                & sdteqdtlpzmzozddtrp0(W0,xa,xq) ) )
            & ( ( aInteger0(W0)
                & ( ? [W1] :
                      ( aInteger0(W1)
                      & sdtasdt0(xq,W1) = sdtpldt0(W0,smndt0(xa)) )
                  | aDivisorOf0(xq,sdtpldt0(W0,smndt0(xa)))
                  | sdteqdtlpzmzozddtrp0(W0,xa,xq) ) )
             => aElementOf0(W0,szAzrzSzezqlpdtcmdtrp0(xa,xq)) ) ) )
     => ( ~ aElementOf0(xc,szAzrzSzezqlpdtcmdtrp0(xa,xq))
        | aElementOf0(xc,stldt0(szAzrzSzezqlpdtcmdtrp0(xa,xq))) ) ) ) ).

%------------------------------------------------------------------------------
