%------------------------------------------------------------------------------
% File     : NUM437+5 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Number Theory
% Problem  : Fuerstenberg's infinitude of primes 07, 04 expansion
% Version  : Especial.
% English  :

% Refs     : [VLP07] Verchinine et al. (2007), System for Automated Deduction
%          : [Pas08] Paskevich (2008), Email to G. Sutcliffe
% Source   : [Pas08]
% Names    : fuerst_07.04 [Pas08]

% Status   : Theorem
% Rating   : 0.45 v9.0.0, 0.47 v8.1.0, 0.42 v7.5.0, 0.50 v7.4.0, 0.40 v7.3.0, 0.41 v7.2.0, 0.38 v7.1.0, 0.39 v7.0.0, 0.57 v6.4.0, 0.54 v6.2.0, 0.64 v6.1.0, 0.73 v6.0.0, 0.61 v5.5.0, 0.74 v5.4.0, 0.75 v5.3.0, 0.78 v5.2.0, 0.65 v5.1.0, 0.76 v5.0.0, 0.88 v4.1.0, 0.91 v4.0.0
% Syntax   : Number of formulae    :   38 (   2 unt;  10 def)
%            Number of atoms       :  214 (  43 equ)
%            Maximal formula atoms :   29 (   5 avg)
%            Number of connectives :  191 (  15   ~;   8   |;  94   &)
%                                         (  18 <=>;  56  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   24 (   7 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :   12 (  10 usr;   1 prp; 0-3 aty)
%            Number of functors    :   12 (  12 usr;   4 con; 0-2 aty)
%            Number of variables   :   96 (  85   !;  11   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Problem generated by the SAD system [VLP07]
%------------------------------------------------------------------------------
fof(mIntegers,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => $true ) ).

fof(mIntZero,axiom,
    aInteger0(sz00) ).

fof(mIntOne,axiom,
    aInteger0(sz10) ).

fof(mIntNeg,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => aInteger0(smndt0(W0)) ) ).

fof(mIntPlus,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => aInteger0(sdtpldt0(W0,W1)) ) ).

fof(mIntMult,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => aInteger0(sdtasdt0(W0,W1)) ) ).

fof(mAddAsso,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => sdtpldt0(W0,sdtpldt0(W1,W2)) = sdtpldt0(sdtpldt0(W0,W1),W2) ) ).

fof(mAddComm,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => sdtpldt0(W0,W1) = sdtpldt0(W1,W0) ) ).

fof(mAddZero,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtpldt0(W0,sz00) = W0
        & W0 = sdtpldt0(sz00,W0) ) ) ).

fof(mAddNeg,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtpldt0(W0,smndt0(W0)) = sz00
        & sz00 = sdtpldt0(smndt0(W0),W0) ) ) ).

fof(mMulAsso,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => sdtasdt0(W0,sdtasdt0(W1,W2)) = sdtasdt0(sdtasdt0(W0,W1),W2) ) ).

fof(mMulComm,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => sdtasdt0(W0,W1) = sdtasdt0(W1,W0) ) ).

fof(mMulOne,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(W0,sz10) = W0
        & W0 = sdtasdt0(sz10,W0) ) ) ).

fof(mDistrib,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => ( sdtasdt0(W0,sdtpldt0(W1,W2)) = sdtpldt0(sdtasdt0(W0,W1),sdtasdt0(W0,W2))
        & sdtasdt0(sdtpldt0(W0,W1),W2) = sdtpldt0(sdtasdt0(W0,W2),sdtasdt0(W1,W2)) ) ) ).

fof(mMulZero,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(W0,sz00) = sz00
        & sz00 = sdtasdt0(sz00,W0) ) ) ).

fof(mMulMinOne,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(smndt0(sz10),W0) = smndt0(W0)
        & smndt0(W0) = sdtasdt0(W0,smndt0(sz10)) ) ) ).

fof(mZeroDiv,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => ( sdtasdt0(W0,W1) = sz00
       => ( W0 = sz00
          | W1 = sz00 ) ) ) ).

fof(mDivisor,definition,
    ! [W0] :
      ( aInteger0(W0)
     => ! [W1] :
          ( aDivisorOf0(W1,W0)
        <=> ( aInteger0(W1)
            & W1 != sz00
            & ? [W2] :
                ( aInteger0(W2)
                & sdtasdt0(W1,W2) = W0 ) ) ) ) ).

fof(mEquMod,definition,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
      <=> aDivisorOf0(W2,sdtpldt0(W0,smndt0(W1))) ) ) ).

fof(mEquModRef,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & W1 != sz00 )
     => sdteqdtlpzmzozddtrp0(W0,W0,W1) ) ).

fof(mEquModSym,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
       => sdteqdtlpzmzozddtrp0(W1,W0,W2) ) ) ).

fof(mEquModTrn,axiom,
    ! [W0,W1,W2,W3] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00
        & aInteger0(W3) )
     => ( ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
          & sdteqdtlpzmzozddtrp0(W1,W3,W2) )
       => sdteqdtlpzmzozddtrp0(W0,W3,W2) ) ) ).

fof(mEquModMul,axiom,
    ! [W0,W1,W2,W3] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00
        & aInteger0(W3)
        & W3 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,sdtasdt0(W2,W3))
       => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
          & sdteqdtlpzmzozddtrp0(W0,W1,W3) ) ) ) ).

fof(mPrime,axiom,
    ! [W0] :
      ( ( aInteger0(W0)
        & W0 != sz00 )
     => ( isPrime0(W0)
       => $true ) ) ).

fof(mPrimeDivisor,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( ? [W1] :
            ( aDivisorOf0(W1,W0)
            & isPrime0(W1) )
      <=> ( W0 != sz10
          & W0 != smndt0(sz10) ) ) ) ).

fof(mSets,axiom,
    ! [W0] :
      ( aSet0(W0)
     => $true ) ).

fof(mElements,axiom,
    ! [W0] :
      ( aSet0(W0)
     => ! [W1] :
          ( aElementOf0(W1,W0)
         => $true ) ) ).

fof(mSubset,definition,
    ! [W0] :
      ( aSet0(W0)
     => ! [W1] :
          ( aSubsetOf0(W1,W0)
        <=> ( aSet0(W1)
            & ! [W2] :
                ( aElementOf0(W2,W1)
               => aElementOf0(W2,W0) ) ) ) ) ).

fof(mFinSet,axiom,
    ! [W0] :
      ( aSet0(W0)
     => ( isFinite0(W0)
       => $true ) ) ).

fof(mUnion,definition,
    ! [W0,W1] :
      ( ( aSubsetOf0(W0,cS1395)
        & aSubsetOf0(W1,cS1395) )
     => ! [W2] :
          ( W2 = sdtbsmnsldt0(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ( aInteger0(W3)
                  & ( aElementOf0(W3,W0)
                    | aElementOf0(W3,W1) ) ) ) ) ) ) ).

fof(mIntersection,definition,
    ! [W0,W1] :
      ( ( aSubsetOf0(W0,cS1395)
        & aSubsetOf0(W1,cS1395) )
     => ! [W2] :
          ( W2 = sdtslmnbsdt0(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ( aInteger0(W3)
                  & aElementOf0(W3,W0)
                  & aElementOf0(W3,W1) ) ) ) ) ) ).

fof(mUnionSet,definition,
    ! [W0] :
      ( ( aSet0(W0)
        & ! [W1] :
            ( aElementOf0(W1,W0)
           => aSubsetOf0(W1,cS1395) ) )
     => ! [W1] :
          ( W1 = sbsmnsldt0(W0)
        <=> ( aSet0(W1)
            & ! [W2] :
                ( aElementOf0(W2,W1)
              <=> ( aInteger0(W2)
                  & ? [W3] :
                      ( aElementOf0(W3,W0)
                      & aElementOf0(W2,W3) ) ) ) ) ) ) ).

fof(mComplement,definition,
    ! [W0] :
      ( aSubsetOf0(W0,cS1395)
     => ! [W1] :
          ( W1 = stldt0(W0)
        <=> ( aSet0(W1)
            & ! [W2] :
                ( aElementOf0(W2,W1)
              <=> ( aInteger0(W2)
                  & ~ aElementOf0(W2,W0) ) ) ) ) ) ).

fof(mArSeq,definition,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & W1 != sz00 )
     => ! [W2] :
          ( W2 = szAzrzSzezqlpdtcmdtrp0(W0,W1)
        <=> ( aSet0(W2)
            & ! [W3] :
                ( aElementOf0(W3,W2)
              <=> ( aInteger0(W3)
                  & sdteqdtlpzmzozddtrp0(W3,W0,W1) ) ) ) ) ) ).

fof(mOpen,definition,
    ! [W0] :
      ( aSubsetOf0(W0,cS1395)
     => ( isOpen0(W0)
      <=> ! [W1] :
            ( aElementOf0(W1,W0)
           => ? [W2] :
                ( aInteger0(W2)
                & W2 != sz00
                & aSubsetOf0(szAzrzSzezqlpdtcmdtrp0(W1,W2),W0) ) ) ) ) ).

fof(mClosed,definition,
    ! [W0] :
      ( aSubsetOf0(W0,cS1395)
     => ( isClosed0(W0)
      <=> isOpen0(stldt0(W0)) ) ) ).

fof(m__1750,hypothesis,
    ( aSet0(xS)
    & ! [W0] :
        ( aElementOf0(W0,xS)
       => ( aSet0(cS1395)
          & ! [W1] :
              ( aElementOf0(W1,cS1395)
            <=> aInteger0(W1) )
          & aSet0(W0)
          & ! [W1] :
              ( aElementOf0(W1,W0)
             => aElementOf0(W1,cS1395) )
          & aSubsetOf0(W0,cS1395)
          & ! [W1] :
              ( aElementOf0(W1,W0)
             => ? [W2] :
                  ( aInteger0(W2)
                  & W2 != sz00
                  & aSet0(szAzrzSzezqlpdtcmdtrp0(W1,W2))
                  & ! [W3] :
                      ( ( aElementOf0(W3,szAzrzSzezqlpdtcmdtrp0(W1,W2))
                       => ( aInteger0(W3)
                          & ? [W4] :
                              ( aInteger0(W4)
                              & sdtasdt0(W2,W4) = sdtpldt0(W3,smndt0(W1)) )
                          & aDivisorOf0(W2,sdtpldt0(W3,smndt0(W1)))
                          & sdteqdtlpzmzozddtrp0(W3,W1,W2) ) )
                      & ( ( aInteger0(W3)
                          & ( ? [W4] :
                                ( aInteger0(W4)
                                & sdtasdt0(W2,W4) = sdtpldt0(W3,smndt0(W1)) )
                            | aDivisorOf0(W2,sdtpldt0(W3,smndt0(W1)))
                            | sdteqdtlpzmzozddtrp0(W3,W1,W2) ) )
                       => aElementOf0(W3,szAzrzSzezqlpdtcmdtrp0(W1,W2)) ) )
                  & ! [W3] :
                      ( aElementOf0(W3,szAzrzSzezqlpdtcmdtrp0(W1,W2))
                     => aElementOf0(W3,W0) )
                  & aSubsetOf0(szAzrzSzezqlpdtcmdtrp0(W1,W2),W0) ) )
          & isOpen0(W0) ) ) ) ).

fof(m__,conjecture,
    ( ( aSet0(sbsmnsldt0(xS))
      & ! [W0] :
          ( aElementOf0(W0,sbsmnsldt0(xS))
        <=> ( aInteger0(W0)
            & ? [W1] :
                ( aElementOf0(W1,xS)
                & aElementOf0(W0,W1) ) ) ) )
   => ( ! [W0] :
          ( aElementOf0(W0,sbsmnsldt0(xS))
         => ? [W1] :
              ( aInteger0(W1)
              & W1 != sz00
              & ( ( aSet0(szAzrzSzezqlpdtcmdtrp0(W0,W1))
                  & ! [W2] :
                      ( ( aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(W0,W1))
                       => ( aInteger0(W2)
                          & ? [W3] :
                              ( aInteger0(W3)
                              & sdtasdt0(W1,W3) = sdtpldt0(W2,smndt0(W0)) )
                          & aDivisorOf0(W1,sdtpldt0(W2,smndt0(W0)))
                          & sdteqdtlpzmzozddtrp0(W2,W0,W1) ) )
                      & ( ( aInteger0(W2)
                          & ( ? [W3] :
                                ( aInteger0(W3)
                                & sdtasdt0(W1,W3) = sdtpldt0(W2,smndt0(W0)) )
                            | aDivisorOf0(W1,sdtpldt0(W2,smndt0(W0)))
                            | sdteqdtlpzmzozddtrp0(W2,W0,W1) ) )
                       => aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(W0,W1)) ) ) )
               => ( ! [W2] :
                      ( aElementOf0(W2,szAzrzSzezqlpdtcmdtrp0(W0,W1))
                     => aElementOf0(W2,sbsmnsldt0(xS)) )
                  | aSubsetOf0(szAzrzSzezqlpdtcmdtrp0(W0,W1),sbsmnsldt0(xS)) ) ) ) )
      | isOpen0(sbsmnsldt0(xS)) ) ) ).

%------------------------------------------------------------------------------
