%------------------------------------------------------------------------------
% File     : NUM435+1 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Number Theory
% Problem  : Fuerstenberg's infinitude of primes 06_02, 00 expansion
% Version  : Especial.
% English  :

% Refs     : [VLP07] Verchinine et al. (2007), System for Automated Deduction
%          : [Pas08] Paskevich (2008), Email to G. Sutcliffe
% Source   : [Pas08]
% Names    : fuerst_06_02.00 [Pas08]

% Status   : Theorem
% Rating   : 0.27 v9.1.0, 0.30 v9.0.0, 0.31 v8.1.0, 0.36 v7.5.0, 0.38 v7.4.0, 0.20 v7.3.0, 0.24 v7.2.0, 0.28 v7.1.0, 0.35 v7.0.0, 0.33 v6.4.0, 0.35 v6.3.0, 0.29 v6.2.0, 0.36 v6.1.0, 0.43 v6.0.0, 0.39 v5.5.0, 0.44 v5.4.0, 0.50 v5.3.0, 0.56 v5.2.0, 0.50 v5.1.0, 0.57 v5.0.0, 0.62 v4.1.0, 0.65 v4.0.1, 0.83 v4.0.0
% Syntax   : Number of formulae    :   26 (   4 unt;   2 def)
%            Number of atoms       :   91 (  29 equ)
%            Maximal formula atoms :    8 (   3 avg)
%            Number of connectives :   72 (   7   ~;   1   |;  39   &)
%                                         (   2 <=>;  23  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    5 (   3 usr;   1 prp; 0-3 aty)
%            Number of functors    :   10 (  10 usr;   7 con; 0-2 aty)
%            Number of variables   :   41 (  40   !;   1   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Problem generated by the SAD system [VLP07]
%------------------------------------------------------------------------------
fof(mIntegers,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => $true ) ).

fof(mIntZero,axiom,
    aInteger0(sz00) ).

fof(mIntOne,axiom,
    aInteger0(sz10) ).

fof(mIntNeg,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => aInteger0(smndt0(W0)) ) ).

fof(mIntPlus,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => aInteger0(sdtpldt0(W0,W1)) ) ).

fof(mIntMult,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => aInteger0(sdtasdt0(W0,W1)) ) ).

fof(mAddAsso,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => sdtpldt0(W0,sdtpldt0(W1,W2)) = sdtpldt0(sdtpldt0(W0,W1),W2) ) ).

fof(mAddComm,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => sdtpldt0(W0,W1) = sdtpldt0(W1,W0) ) ).

fof(mAddZero,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtpldt0(W0,sz00) = W0
        & W0 = sdtpldt0(sz00,W0) ) ) ).

fof(mAddNeg,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtpldt0(W0,smndt0(W0)) = sz00
        & sz00 = sdtpldt0(smndt0(W0),W0) ) ) ).

fof(mMulAsso,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => sdtasdt0(W0,sdtasdt0(W1,W2)) = sdtasdt0(sdtasdt0(W0,W1),W2) ) ).

fof(mMulComm,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => sdtasdt0(W0,W1) = sdtasdt0(W1,W0) ) ).

fof(mMulOne,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(W0,sz10) = W0
        & W0 = sdtasdt0(sz10,W0) ) ) ).

fof(mDistrib,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2) )
     => ( sdtasdt0(W0,sdtpldt0(W1,W2)) = sdtpldt0(sdtasdt0(W0,W1),sdtasdt0(W0,W2))
        & sdtasdt0(sdtpldt0(W0,W1),W2) = sdtpldt0(sdtasdt0(W0,W2),sdtasdt0(W1,W2)) ) ) ).

fof(mMulZero,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(W0,sz00) = sz00
        & sz00 = sdtasdt0(sz00,W0) ) ) ).

fof(mMulMinOne,axiom,
    ! [W0] :
      ( aInteger0(W0)
     => ( sdtasdt0(smndt0(sz10),W0) = smndt0(W0)
        & smndt0(W0) = sdtasdt0(W0,smndt0(sz10)) ) ) ).

fof(mZeroDiv,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1) )
     => ( sdtasdt0(W0,W1) = sz00
       => ( W0 = sz00
          | W1 = sz00 ) ) ) ).

fof(mDivisor,definition,
    ! [W0] :
      ( aInteger0(W0)
     => ! [W1] :
          ( aDivisorOf0(W1,W0)
        <=> ( aInteger0(W1)
            & W1 != sz00
            & ? [W2] :
                ( aInteger0(W2)
                & sdtasdt0(W1,W2) = W0 ) ) ) ) ).

fof(mEquMod,definition,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
      <=> aDivisorOf0(W2,sdtpldt0(W0,smndt0(W1))) ) ) ).

fof(mEquModRef,axiom,
    ! [W0,W1] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & W1 != sz00 )
     => sdteqdtlpzmzozddtrp0(W0,W0,W1) ) ).

fof(mEquModSym,axiom,
    ! [W0,W1,W2] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00 )
     => ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
       => sdteqdtlpzmzozddtrp0(W1,W0,W2) ) ) ).

fof(mEquModTrn,axiom,
    ! [W0,W1,W2,W3] :
      ( ( aInteger0(W0)
        & aInteger0(W1)
        & aInteger0(W2)
        & W2 != sz00
        & aInteger0(W3) )
     => ( ( sdteqdtlpzmzozddtrp0(W0,W1,W2)
          & sdteqdtlpzmzozddtrp0(W1,W3,W2) )
       => sdteqdtlpzmzozddtrp0(W0,W3,W2) ) ) ).

fof(m__979,hypothesis,
    ( aInteger0(xa)
    & aInteger0(xb)
    & aInteger0(xp)
    & xp != sz00
    & aInteger0(xq)
    & xq != sz00 ) ).

fof(m__1003,hypothesis,
    sdteqdtlpzmzozddtrp0(xa,xb,sdtasdt0(xp,xq)) ).

fof(m__1032,hypothesis,
    ( aInteger0(xm)
    & sdtasdt0(sdtasdt0(xp,xq),xm) = sdtpldt0(xa,smndt0(xb)) ) ).

fof(m__,conjecture,
    sdtpldt0(xa,smndt0(xb)) = sdtasdt0(xq,sdtasdt0(xp,xm)) ).

%------------------------------------------------------------------------------
