%--------------------------------------------------------------------------
% File     : NUM019-1 : TPTP v9.2.0. Bugfixed v4.0.0.
% Domain   : Number Theory
% Problem  : Symmetry of equality can be derived
% Version  : [LS74] axioms : Incomplete.
% English  :

% Refs     : [LS74]  Lawrence & Starkey (1974), Experimental Tests of Resol
%          : [WM76]  Wilson & Minker (1976), Resolution, Refinements, and S
% Source   : [SPRFN]
% Names    : ls41 [LS74]
%          : Problem 41 [LS74]
%          : ls41 [WM76]

% Status   : Unsatisfiable
% Rating   : 0.00 v7.2.0, 0.25 v6.2.0, 0.17 v6.1.0, 0.07 v6.0.0, 0.11 v5.5.0, 0.06 v5.4.0, 0.11 v5.3.0, 0.15 v5.1.0, 0.19 v5.0.0, 0.07 v4.1.0, 0.13 v4.0.1, 0.14 v4.0.0
% Syntax   : Number of clauses     :   11 (   8 unt;   0 nHn;   6 RR)
%            Number of literals    :   15 (   0 equ;   6 neg)
%            Maximal clause size   :    3 (   1 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    1 (   1 usr;   0 prp; 2-2 aty)
%            Number of functors    :    6 (   6 usr;   3 con; 0-2 aty)
%            Number of variables   :   15 (   2 sgn)
% SPC      : CNF_UNS_RFO_NEQ_HRN

% Comments :
% Bugfixes : v4.0.0 - Bugfix in NUM001-0.ax
%--------------------------------------------------------------------------
%----Include recursive function + and * axioms
include('Axioms/NUM001-0.ax').
%--------------------------------------------------------------------------
cnf(reflexivity,hypothesis,
    equalish(X,X) ).

cnf(transitivity,hypothesis,
    ( ~ equalish(X,Y)
    | ~ equalish(X,Z)
    | equalish(Y,Z) ) ).

cnf(zero_is_the_first_number,hypothesis,
    ~ equalish(successor(A),n0) ).

cnf(a_equals_aa,hypothesis,
    equalish(a,aa) ).

cnf(prove_b_equals_a,negated_conjecture,
    ~ equalish(aa,a) ).

%--------------------------------------------------------------------------
