%--------------------------------------------------------------------------
% File     : NUM017-1 : TPTP v9.2.0. Released v1.0.0.
% Domain   : Number Theory
% Problem  : Square root of this prime is irrational
% Version  : [Rob63] axioms : Incomplete.
% English  : If a is prime, and a is not b^2/c^2, then the square root
%            of a is irrational.

% Refs     : [Rob63] Robinson (1963), Theorem Proving on the Computer
%          : [Wos65] Wos (1965), Unpublished Note
%          : [LS74]  Lawrence & Starkey (1974), Experimental Tests of Resol
%          : [WM76]  Wilson & Minker (1976), Resolution, Refinements, and S
% Source   : [SPRFN]
% Names    : - [Rob63]
%          : Problem 26 [LS74]
%          : wos26 [WM76]

% Status   : Unsatisfiable
% Rating   : 0.59 v9.1.0, 0.40 v9.0.0, 0.18 v8.2.0, 0.14 v8.1.0, 0.25 v7.4.0, 0.33 v7.3.0, 0.25 v7.2.0, 0.50 v6.1.0, 0.57 v6.0.0, 0.33 v5.5.0, 0.69 v5.4.0, 0.72 v5.3.0, 0.80 v5.2.0, 0.54 v5.1.0, 0.56 v5.0.0, 0.53 v4.1.0, 0.47 v4.0.1, 0.43 v3.7.0, 0.29 v3.4.0, 0.20 v3.3.0, 0.33 v3.1.0, 0.17 v2.7.0, 0.25 v2.6.0, 0.29 v2.4.0, 0.43 v2.3.0, 0.43 v2.2.1, 0.89 v2.1.0, 0.86 v2.0.0
% Syntax   : Number of clauses     :   24 (   6 unt;   0 nHn;  22 RR)
%            Number of literals    :   58 (   0 equ;  36 neg)
%            Maximal clause size   :    4 (   2 avg)
%            Maximal term depth    :    2 (   1 avg)
%            Number of predicates  :    4 (   4 usr;   0 prp; 1-3 aty)
%            Number of functors    :    7 (   7 usr;   5 con; 0-2 aty)
%            Number of variables   :   63 (   1 sgn)
% SPC      : CNF_UNS_RFO_NEQ_HRN

% Comments :
%--------------------------------------------------------------------------
cnf(reflexivity,axiom,
    equalish(X,X) ).

cnf(symmetry,axiom,
    ( ~ equalish(X,Y)
    | equalish(Y,X) ) ).

cnf(transitivity,axiom,
    ( ~ equalish(X,Y)
    | ~ equalish(Y,Z)
    | equalish(X,Z) ) ).

cnf(product_substitution1,axiom,
    ( ~ equalish(D,B)
    | ~ product(C,A,D)
    | product(C,A,B) ) ).

cnf(product_substitution2,axiom,
    ( ~ equalish(D,B)
    | ~ product(C,D,A)
    | product(C,B,A) ) ).

cnf(product_substitution3,axiom,
    ( ~ equalish(C,B)
    | ~ product(C,D,A)
    | product(B,D,A) ) ).

cnf(divides_substitution1,axiom,
    ( ~ equalish(B,A)
    | ~ divides(C,B)
    | divides(C,A) ) ).

cnf(divides_substitution2,axiom,
    ( ~ equalish(A,B)
    | ~ divides(A,C)
    | divides(B,C) ) ).

cnf(prime_substitution,axiom,
    ( ~ equalish(A,B)
    | ~ prime(A)
    | prime(B) ) ).

cnf(closure_of_product,axiom,
    product(A,B,multiply(A,B)) ).

cnf(product_associativity1,axiom,
    ( ~ product(A,B,C)
    | ~ product(D,E,B)
    | ~ product(A,D,F)
    | product(F,E,C) ) ).

cnf(product_associativity2,axiom,
    ( ~ product(A,B,C)
    | ~ product(D,B,E)
    | ~ product(F,D,A)
    | product(F,E,C) ) ).

cnf(product_commutativity,axiom,
    ( ~ product(A,B,C)
    | product(B,A,C) ) ).

cnf(product_left_cancellation,axiom,
    ( ~ product(A,B,C)
    | ~ product(A,D,C)
    | equalish(B,D) ) ).

cnf(transitivity_of_divides,axiom,
    ( ~ divides(A,B)
    | ~ divides(C,A)
    | divides(C,B) ) ).

cnf(well_defined_product,axiom,
    ( ~ product(A,B,C)
    | ~ product(A,B,D)
    | equalish(D,C) ) ).

cnf(divides_implies_product,axiom,
    ( ~ divides(A,B)
    | product(A,second_divided_by_1st(A,B),B) ) ).

cnf(product_divisible_by_operand,axiom,
    ( ~ product(A,B,C)
    | divides(A,C) ) ).

cnf(primes_lemma1,axiom,
    ( ~ divides(A,B)
    | ~ product(C,C,B)
    | ~ prime(A)
    | divides(A,C) ) ).

cnf(a_is_prime,hypothesis,
    prime(a) ).

cnf(b_squared,hypothesis,
    product(b,b,d) ).

cnf(c_squared,hypothesis,
    product(c,c,e) ).

cnf(a_times_c_squared_is_not_b_squared,hypothesis,
    ~ product(a,e,d) ).

cnf(prove_there_is_no_common_divisor,negated_conjecture,
    ( ~ divides(A,c)
    | ~ divides(A,b) ) ).

%--------------------------------------------------------------------------
