%------------------------------------------------------------------------------
% File     : NLP267_17 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Natural Language Processing
% Problem  : Ticket example
% Version  : [QMLTP] axioms.
% English  :

% Refs     : [FH+98] Farinas del Cerro et al. (1998), Belief Reconstruction
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : MML016+1 [QMLTP]

% Status   : Theorem
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :   24 (   2 unt;  14 typ;   0 def)
%            Number of atoms       :   27 (   0 equ)
%            Maximal formula atoms :    4 (   2 avg)
%            Number of connectives :   21 (   4   ~;   0   |;   7   &)
%                                         (   0 <=>;  10  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    5 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of types       :    4 (   2 usr)
%            Number of type conns  :    9 (   4   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   4 usr;   0 prp; 2-3 aty)
%            Number of functors    :    8 (   8 usr;   8 con; 0-0 aty)
%            Number of variables   :   12 (;  12   !;   0   ?;  12   :)
% SPC      : TF0_THM_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_S5, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_index_type',type,
    '$ki_index': $tType ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_index' * '$ki_world' * '$ki_world' ) > $o ).

tff('#idx(b_s)_decl',type,
    '#idx(b_s)': '$ki_index' ).

tff('#idx(b_u)_decl',type,
    '#idx(b_u)': '$ki_index' ).

tff('mrel_universal_#idx(b_s)',axiom,
    ! [W: '$ki_world',V: '$ki_world'] : '$ki_accessible'('#idx(b_s)',W,V) ).

tff('mrel_universal_#idx(b_u)',axiom,
    ! [W: '$ki_world',V: '$ki_world'] : '$ki_accessible'('#idx(b_u)',W,V) ).

tff(seventy_decl,type,
    seventy: $i ).

tff(ninetyfive_decl,type,
    ninetyfive: $i ).

tff(second_decl,type,
    second: $i ).

tff(paris_decl,type,
    paris: $i ).

tff(first_decl,type,
    first: $i ).

tff(price_decl,type,
    price: ( '$ki_world' * $i ) > $o ).

tff(dest_decl,type,
    dest: ( '$ki_world' * $i ) > $o ).

tff(class_decl,type,
    class: ( '$ki_world' * $i ) > $o ).

tff(axiom_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_s)','$ki_local_world',W)
     => ( ( dest(W,paris)
          & class(W,first) )
       => price(W,ninetyfive) ) ) ).

tff(axiom_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_s)','$ki_local_world',W)
     => ( ( dest(W,paris)
          & class(W,second) )
       => price(W,seventy) ) ) ).

tff(axiom_3_s,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_s)','$ki_local_world',W)
     => ~ ( class(W,first)
          & class(W,second) ) ) ).

tff(axiom_3_u,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_u)','$ki_local_world',W)
     => ~ ( class(W,first)
          & class(W,second) ) ) ).

tff(axiom_4_s,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_s)','$ki_local_world',W)
     => ~ ( price(W,seventy)
          & price(W,ninetyfive) ) ) ).

tff(axiom_4_u,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_u)','$ki_local_world',W)
     => ~ ( price(W,seventy)
          & price(W,ninetyfive) ) ) ).

tff(axiom_5,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_s)','$ki_local_world',W)
     => ( dest(W,paris)
        & class(W,second) ) ) ).

tff(verify,conjecture,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_s)','$ki_local_world',W)
     => price(W,seventy) ) ).

%------------------------------------------------------------------------------
