%------------------------------------------------------------------------------
% File     : NLP267_1 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Natural Language Processing
% Problem  : Ticket example
% Version  : [QMLTP] axioms.
% English  :

% Refs     : [FH+98] Farinas del Cerro et al. (1998), Belief Reconstruction
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : APM001+1 [QMLTP]

% Status   : Theorem
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :   18 (   0 unt;  11 typ;   0 def)
%            Number of atoms       :   20 (   0 equ)
%            Maximal formula atoms :    4 (   2 avg)
%            Number of connectives :   15 (   2   ~;   0   |;   4   &)
%                                         (   0 <=>;   9  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    5 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :    8 (   4   >;   4   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   4 usr;   0 prp; 2-2 aty)
%            Number of functors    :    6 (   6 usr;   6 con; 0-0 aty)
%            Number of variables   :    7 (;   7   !;   0   ?;   7   :)
% SPC      : TF0_THM_NEQ_NAR

% Comments :  Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_K, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_world' * '$ki_world' ) > $o ).

tff(seventy_decl,type,
    seventy: $i ).

tff(ninetyfive_decl,type,
    ninetyfive: $i ).

tff(second_decl,type,
    second: $i ).

tff(paris_decl,type,
    paris: $i ).

tff(first_decl,type,
    first: $i ).

tff(price_decl,type,
    price: ( '$ki_world' * $i ) > $o ).

tff(dest_decl,type,
    dest: ( '$ki_world' * $i ) > $o ).

tff(class_decl,type,
    class: ( '$ki_world' * $i ) > $o ).

tff(law1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ( ( dest(W,paris)
          & class(W,first) )
       => price(W,ninetyfive) ) ) ).

tff(law2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ( ( dest(W,paris)
          & class(W,second) )
       => price(W,seventy) ) ) ).

tff(law3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ~ ( class(W,first)
          & class(W,second) ) ) ).

tff(law4,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ~ ( price(W,ninetyfive)
          & price(W,seventy) ) ) ).

tff(belief1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => dest(W,paris) ) ).

tff(belief2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => class(W,second) ) ).

tff(verify,conjecture,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => price(W,seventy) ) ).

%------------------------------------------------------------------------------
