%------------------------------------------------------------------------------
% File     : NLP265_17 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Natural Language Processing
% Problem  : Schema instantiation example
% Version  : [QMLTP] axioms.
% English  : Alice intends Bob to believe that portland is a big city.

% Refs     : [BS96]  Bretier & Sadek (1996), Rational Agent as the Kernel o
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : MML014+1 [QMLTP]

% Status   : ContradictoryAxioms
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :   19 (   4 unt;  10 typ;   0 def)
%            Number of atoms       :   28 (   0 equ)
%            Maximal formula atoms :    8 (   3 avg)
%            Number of connectives :   22 (   3   ~;   0   |;   2   &)
%                                         (   0 <=>;  17  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of types       :    4 (   2 usr)
%            Number of type conns  :    5 (   2   >;   3   *;   0   +;   0  <<)
%            Number of predicates  :    2 (   2 usr;   0 prp; 2-3 aty)
%            Number of functors    :    6 (   6 usr;   6 con; 0-0 aty)
%            Number of variables   :   23 (;  23   !;   0   ?;  23   :)
% SPC      : TF0_THM_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_S5, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_index_type',type,
    '$ki_index': $tType ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_index' * '$ki_world' * '$ki_world' ) > $o ).

tff('#idx(b_alice)_decl',type,
    '#idx(b_alice)': '$ki_index' ).

tff('#idx(b_bob)_decl',type,
    '#idx(b_bob)': '$ki_index' ).

tff('#idx(i_bob)_decl',type,
    '#idx(i_bob)': '$ki_index' ).

tff('#idx(i_alice)_decl',type,
    '#idx(i_alice)': '$ki_index' ).

tff('mrel_universal_#idx(b_alice)',axiom,
    ! [W: '$ki_world',V: '$ki_world'] : '$ki_accessible'('#idx(b_alice)',W,V) ).

tff('mrel_universal_#idx(b_bob)',axiom,
    ! [W: '$ki_world',V: '$ki_world'] : '$ki_accessible'('#idx(b_bob)',W,V) ).

tff('mrel_universal_#idx(i_bob)',axiom,
    ! [W: '$ki_world',V: '$ki_world'] : '$ki_accessible'('#idx(i_bob)',W,V) ).

tff('mrel_universal_#idx(i_alice)',axiom,
    ! [W: '$ki_world',V: '$ki_world'] : '$ki_accessible'('#idx(i_alice)',W,V) ).

tff(portland_decl,type,
    portland: $i ).

tff(bigcity_decl,type,
    bigcity: ( '$ki_world' * $i ) > $o ).

tff(axiom_1_alice,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_alice)','$ki_local_world',W)
     => ( ( bigcity(W,portland)
          & ! [W0: '$ki_world'] :
              ( '$ki_accessible'('#idx(b_alice)',W,W0)
             => ! [W1: '$ki_world'] :
                  ( '$ki_accessible'('#idx(b_bob)',W0,W1)
                 => ~ bigcity(W1,portland) ) ) )
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'('#idx(i_alice)',W,W0)
           => ! [W1: '$ki_world'] :
                ( '$ki_accessible'('#idx(b_bob)',W0,W1)
               => bigcity(W1,portland) ) ) ) ) ).

tff(axiom_1_bob,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_bob)','$ki_local_world',W)
     => ( ( bigcity(W,portland)
          & ! [W0: '$ki_world'] :
              ( '$ki_accessible'('#idx(b_bob)',W,W0)
             => ! [W1: '$ki_world'] :
                  ( '$ki_accessible'('#idx(b_alice)',W0,W1)
                 => ~ bigcity(W1,portland) ) ) )
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'('#idx(i_bob)',W,W0)
           => ! [W1: '$ki_world'] :
                ( '$ki_accessible'('#idx(b_alice)',W0,W1)
               => bigcity(W1,portland) ) ) ) ) ).

tff(axiom_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_alice)','$ki_local_world',W)
     => bigcity(W,portland) ) ).

tff(axiom_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(b_alice)','$ki_local_world',W)
     => ! [W0: '$ki_world'] :
          ( '$ki_accessible'('#idx(b_bob)',W,W0)
         => ~ bigcity(W0,portland) ) ) ).

tff(verify,conjecture,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(i_alice)','$ki_local_world',W)
     => ! [W0: '$ki_world'] :
          ( '$ki_accessible'('#idx(b_bob)',W,W0)
         => bigcity(W0,portland) ) ) ).

%------------------------------------------------------------------------------
