%--------------------------------------------------------------------------
% File     : MGT062-1 : TPTP v9.2.0. Released v2.4.0.
% Domain   : Management (Organisation Theory)
% Problem  : Condictions for decreasing hazard of mortality
% Version  : [Han98] axioms.
% English  : If environmental drift destroys alignment exactly when advantage
%            can be gained from occupancy of a robust position, then the
%            hazard of mortality for an unendowed organization with a robust
%            position decreases with age.

% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%          : [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%          : [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [TPTP]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.18 v9.1.0, 0.10 v9.0.0, 0.20 v8.2.0, 0.14 v8.1.0, 0.05 v7.5.0, 0.11 v7.4.0, 0.18 v7.3.0, 0.08 v7.1.0, 0.00 v7.0.0, 0.07 v6.4.0, 0.00 v6.1.0, 0.14 v6.0.0, 0.10 v5.5.0, 0.30 v5.4.0, 0.35 v5.3.0, 0.33 v5.2.0, 0.25 v5.1.0, 0.35 v5.0.0, 0.21 v4.1.0, 0.23 v4.0.1, 0.18 v4.0.0, 0.09 v3.7.0, 0.00 v3.3.0, 0.14 v3.2.0, 0.31 v3.1.0, 0.18 v2.7.0, 0.17 v2.6.0, 0.00 v2.5.0, 0.44 v2.4.0
% Syntax   : Number of clauses     :   44 (  10 unt;  16 nHn;  36 RR)
%            Number of literals    :  117 (  16 equ;  55 neg)
%            Maximal clause size   :    5 (   2 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :   12 (  11 usr;   0 prp; 1-3 aty)
%            Number of functors    :   15 (  15 usr;  12 con; 0-2 aty)
%            Number of variables   :   72 (   5 sgn)
% SPC      : CNF_UNS_RFO_SEQ_NHN

% Comments : See MGT042+1.p for the mnemonic names.
%          : Created with tptp2X -f tptp -t clausify:otter MGT062+1.p
%--------------------------------------------------------------------------
include('Axioms/MGT001-0.ax').
%--------------------------------------------------------------------------
cnf(assumption_1_39,axiom,
    ( ~ organization(A)
    | has_endowment(A)
    | ~ has_immunity(A,B) ) ).

cnf(definition_2_40,axiom,
    ( ~ dissimilar(A,B,C)
    | organization(A) ) ).

cnf(definition_2_41,axiom,
    ( ~ dissimilar(A,B,C)
    | is_aligned(A,B)
    | is_aligned(A,C) ) ).

cnf(definition_2_42,axiom,
    ( ~ dissimilar(A,B,C)
    | ~ is_aligned(A,B)
    | ~ is_aligned(A,C) ) ).

cnf(definition_2_43,axiom,
    ( ~ organization(A)
    | ~ is_aligned(A,B)
    | is_aligned(A,B)
    | dissimilar(A,B,C) ) ).

cnf(definition_2_44,axiom,
    ( ~ organization(A)
    | ~ is_aligned(A,B)
    | is_aligned(A,C)
    | dissimilar(A,B,C) ) ).

cnf(definition_2_45,axiom,
    ( ~ organization(A)
    | ~ is_aligned(A,B)
    | is_aligned(A,C)
    | dissimilar(A,C,B) ) ).

cnf(definition_2_46,axiom,
    ( ~ organization(A)
    | ~ is_aligned(A,B)
    | is_aligned(A,B)
    | dissimilar(A,C,B) ) ).

cnf(assumption_13_47,axiom,
    ( ~ organization(A)
    | age(A,B) != zero
    | is_aligned(A,B) ) ).

cnf(assumption_15_48,axiom,
    ( ~ organization(A)
    | age(A,B) != zero
    | ~ greater(age(A,C),sigma)
    | dissimilar(A,B,C) ) ).

cnf(assumption_15_49,axiom,
    ( ~ organization(A)
    | age(A,B) != zero
    | ~ dissimilar(A,B,C)
    | greater(age(A,C),sigma) ) ).

cnf(definition_4_50,axiom,
    ( ~ robust_position(A)
    | ~ smaller_or_equal(age(A,B),tau)
    | ~ positional_advantage(A,B) ) ).

cnf(definition_4_51,axiom,
    ( ~ robust_position(A)
    | ~ greater(age(A,B),tau)
    | positional_advantage(A,B) ) ).

cnf(definition_4_52,axiom,
    ( smaller_or_equal(age(A,sk1(A)),tau)
    | greater(age(A,sk1(A)),tau)
    | robust_position(A) ) ).

cnf(definition_4_53,axiom,
    ( smaller_or_equal(age(A,sk1(A)),tau)
    | ~ positional_advantage(A,sk1(A))
    | robust_position(A) ) ).

cnf(definition_4_54,axiom,
    ( positional_advantage(A,sk1(A))
    | greater(age(A,sk1(A)),tau)
    | robust_position(A) ) ).

cnf(definition_4_55,axiom,
    ( positional_advantage(A,sk1(A))
    | ~ positional_advantage(A,sk1(A))
    | robust_position(A) ) ).

cnf(assumption_17_56,axiom,
    ( ~ organization(A)
    | ~ has_immunity(A,B)
    | hazard_of_mortality(A,B) = very_low ) ).

cnf(assumption_17_57,axiom,
    ( ~ organization(A)
    | has_immunity(A,B)
    | ~ is_aligned(A,B)
    | ~ positional_advantage(A,B)
    | hazard_of_mortality(A,B) = low ) ).

cnf(assumption_17_58,axiom,
    ( ~ organization(A)
    | has_immunity(A,B)
    | is_aligned(A,B)
    | ~ positional_advantage(A,B)
    | hazard_of_mortality(A,B) = mod1 ) ).

cnf(assumption_17_59,axiom,
    ( ~ organization(A)
    | has_immunity(A,B)
    | ~ is_aligned(A,B)
    | positional_advantage(A,B)
    | hazard_of_mortality(A,B) = mod2 ) ).

cnf(assumption_17_60,axiom,
    ( ~ organization(A)
    | has_immunity(A,B)
    | is_aligned(A,B)
    | positional_advantage(A,B)
    | hazard_of_mortality(A,B) = high ) ).

cnf(assumption_19_61,axiom,
    greater(mod2,mod1) ).

cnf(theorem_8_62,negated_conjecture,
    organization(sk2) ).

cnf(theorem_8_63,negated_conjecture,
    robust_position(sk2) ).

cnf(theorem_8_64,negated_conjecture,
    ~ has_endowment(sk2) ).

cnf(theorem_8_65,negated_conjecture,
    age(sk2,sk3) = zero ).

cnf(theorem_8_66,negated_conjecture,
    greater(sigma,zero) ).

cnf(theorem_8_67,negated_conjecture,
    greater(tau,zero) ).

cnf(theorem_8_68,negated_conjecture,
    sigma = tau ).

cnf(theorem_8_69,negated_conjecture,
    smaller_or_equal(age(sk2,sk4),sigma) ).

cnf(theorem_8_70,negated_conjecture,
    greater(age(sk2,sk5),sigma) ).

cnf(theorem_8_71,negated_conjecture,
    ( ~ smaller(hazard_of_mortality(sk2,sk5),hazard_of_mortality(sk2,sk4))
    | hazard_of_mortality(sk2,sk4) != hazard_of_mortality(sk2,sk3) ) ).

%--------------------------------------------------------------------------
