%------------------------------------------------------------------------------
% File     : LCL963_3 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Logic Calculi
% Problem  : Goedel translation of LCL451+1
% Version  : [QMLTP] axioms.
% English  : 

% Refs     : [Goe69] Goedel (1969), An Interpretation of the Intuitionistic
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : GLC451+1 [QMLTP]

% Status   : CounterSatisfiable
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :  112 (   3 unt;  43 typ;   0 def)
%            Number of atoms       :  722 (   0 equ)
%            Maximal formula atoms :   28 (  10 avg)
%            Number of connectives :  653 (   0   ~;   0   |;  30   &)
%                                         (   0 <=>; 623  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   19 (  11 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   50 (  41   >;   9   *;   0   +;   0  <<)
%            Number of predicates  :   36 (  36 usr;   0 prp; 1-3 aty)
%            Number of functors    :    6 (   6 usr;   1 con; 0-2 aty)
%            Number of variables   :  556 (; 554   !;   2   ?; 556   :)
% SPC      : TF0_CSA_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_D, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_world' * '$ki_world' ) > $o ).

tff(mrel_serial,axiom,
    ! [W: '$ki_world'] :
    ? [V: '$ki_world'] : '$ki_accessible'(W,V) ).

tff(r2_decl,type,
    r2: '$ki_world' > $o ).

tff(r3_decl,type,
    r3: '$ki_world' > $o ).

tff(r4_decl,type,
    r4: '$ki_world' > $o ).

tff(r5_decl,type,
    r5: '$ki_world' > $o ).

tff(equivalence_1_decl,type,
    equivalence_1: '$ki_world' > $o ).

tff(equivalence_2_decl,type,
    equivalence_2: '$ki_world' > $o ).

tff(cn2_decl,type,
    cn2: '$ki_world' > $o ).

tff(cn1_decl,type,
    cn1: '$ki_world' > $o ).

tff(cn3_decl,type,
    cn3: '$ki_world' > $o ).

tff(kn2_decl,type,
    kn2: '$ki_world' > $o ).

tff(kn1_decl,type,
    kn1: '$ki_world' > $o ).

tff(kn3_decl,type,
    kn3: '$ki_world' > $o ).

tff(equivalence_3_decl,type,
    equivalence_3: '$ki_world' > $o ).

tff(op_implies_or_decl,type,
    op_implies_or: '$ki_world' > $o ).

tff(op_and_decl,type,
    op_and: '$ki_world' > $o ).

tff(and_2_decl,type,
    and_2: '$ki_world' > $o ).

tff(and_3_decl,type,
    and_3: '$ki_world' > $o ).

tff(and_1_decl,type,
    and_1: '$ki_world' > $o ).

tff(implies_2_decl,type,
    implies_2: '$ki_world' > $o ).

tff(implies_3_decl,type,
    implies_3: '$ki_world' > $o ).

tff(op_implies_and_decl,type,
    op_implies_and: '$ki_world' > $o ).

tff(implies_1_decl,type,
    implies_1: '$ki_world' > $o ).

tff(substitution_of_equivalents_decl,type,
    substitution_of_equivalents: '$ki_world' > $o ).

tff(op_or_decl,type,
    op_or: '$ki_world' > $o ).

tff(modus_tollens_decl,type,
    modus_tollens: '$ki_world' > $o ).

tff(or_1_decl,type,
    or_1: '$ki_world' > $o ).

tff(or_2_decl,type,
    or_2: '$ki_world' > $o ).

tff(or_3_decl,type,
    or_3: '$ki_world' > $o ).

tff(op_equiv_decl,type,
    op_equiv: '$ki_world' > $o ).

tff(modus_ponens_decl,type,
    modus_ponens: '$ki_world' > $o ).

tff(op_implies_decl,type,
    op_implies: '$ki_world' > $o ).

tff(r1_decl,type,
    r1: '$ki_world' > $o ).

tff(qmltpeq_decl,type,
    qmltpeq: ( '$ki_world' * $i * $i ) > $o ).

tff(is_a_theorem_decl,type,
    is_a_theorem: ( '$ki_world' * $i ) > $o ).

tff(equiv_decl,type,
    equiv: ( $i * $i ) > $i ).

tff(not_decl,type,
    not: $i > $i ).

tff(or_decl,type,
    or: ( $i * $i ) > $i ).

tff(and_decl,type,
    and: ( $i * $i ) > $i ).

tff(implies_decl,type,
    implies: ( $i * $i ) > $i ).

tff('$ki_exists_in_world_$i_decl',type,
    '$ki_exists_in_world_$i': ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_const',axiom,
    ! [W: '$ki_world',X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff('$ki_exists_in_world_$i_nonempty',axiom,
    ! [W: '$ki_world'] :
    ? [X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff(reflexivity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => qmltpeq(W0,X,X) ) ) ) ).

tff(symmetry,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,X,Y) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,Y,X) ) ) ) ) ) ) ) ).

tff(transitivity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Z: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Z)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,X,Y) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,Y,Z) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,X,Z) ) ) ) ) ) ) ) ) ) ).

tff(and_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,and(A,C),and(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(and_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,and(C,A),and(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(equiv_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,equiv(A,C),equiv(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(equiv_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,equiv(C,A),equiv(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(implies_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,implies(A,C),implies(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(implies_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,implies(C,A),implies(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(not_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,not(A),not(B)) ) ) ) ) ) ) ) ).

tff(or_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,or(A,C),or(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(or_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,or(C,A),or(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(is_a_theorem_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,A,B) )
                          & ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,A) ) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => is_a_theorem(W2,B) ) ) ) ) ) ) ) ).

tff(modus_ponens_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => modus_ponens(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,X) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(X,Y)) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => is_a_theorem(W3,Y) ) ) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,X) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(X,Y)) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => is_a_theorem(W3,Y) ) ) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => modus_ponens(W0) ) ) ) ) ).

tff(substitution_of_equivalents_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => substitution_of_equivalents(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => is_a_theorem(W3,equiv(X,Y)) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,X,Y) ) ) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => is_a_theorem(W3,equiv(X,Y)) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,X,Y) ) ) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => substitution_of_equivalents(W0) ) ) ) ) ).

tff(modus_tollens_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => modus_tollens(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(implies(not(Y),not(X)),implies(X,Y))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(implies(not(Y),not(X)),implies(X,Y))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => modus_tollens(W0) ) ) ) ) ).

tff(implies_1_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => implies_1(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(X,implies(Y,X))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(X,implies(Y,X))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => implies_1(W0) ) ) ) ) ).

tff(implies_2_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => implies_2(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(implies(X,implies(X,Y)),implies(X,Y))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(implies(X,implies(X,Y)),implies(X,Y))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => implies_2(W0) ) ) ) ) ).

tff(implies_3_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => implies_3(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [Z: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,Z)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(implies(X,Y),implies(implies(Y,Z),implies(X,Z)))) ) ) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [Z: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,Z)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(implies(X,Y),implies(implies(Y,Z),implies(X,Z)))) ) ) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => implies_3(W0) ) ) ) ) ).

tff(and_1_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => and_1(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(and(X,Y),X)) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(and(X,Y),X)) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => and_1(W0) ) ) ) ) ).

tff(and_2_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => and_2(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(and(X,Y),Y)) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(and(X,Y),Y)) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => and_2(W0) ) ) ) ) ).

tff(and_3_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => and_3(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(X,implies(Y,and(X,Y)))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(X,implies(Y,and(X,Y)))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => and_3(W0) ) ) ) ) ).

tff(or_1_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => or_1(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(X,or(X,Y))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(X,or(X,Y))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => or_1(W0) ) ) ) ) ).

tff(or_2_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => or_2(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(Y,or(X,Y))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(Y,or(X,Y))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => or_2(W0) ) ) ) ) ).

tff(or_3_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => or_3(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [Z: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,Z)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(implies(X,Z),implies(implies(Y,Z),implies(or(X,Y),Z)))) ) ) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [Z: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,Z)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(implies(X,Z),implies(implies(Y,Z),implies(or(X,Y),Z)))) ) ) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => or_3(W0) ) ) ) ) ).

tff(equivalence_1_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => equivalence_1(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(equiv(X,Y),implies(X,Y))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(equiv(X,Y),implies(X,Y))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => equivalence_1(W0) ) ) ) ) ).

tff(equivalence_2_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => equivalence_2(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(equiv(X,Y),implies(Y,X))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(equiv(X,Y),implies(Y,X))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => equivalence_2(W0) ) ) ) ) ).

tff(equivalence_3_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => equivalence_3(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(implies(X,Y),implies(implies(Y,X),equiv(X,Y)))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(implies(X,Y),implies(implies(Y,X),equiv(X,Y)))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => equivalence_3(W0) ) ) ) ) ).

tff(kn1_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => kn1(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => is_a_theorem(W1,implies(P,and(P,P))) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => is_a_theorem(W1,implies(P,and(P,P))) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => kn1(W0) ) ) ) ) ).

tff(kn2_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => kn2(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(and(P,Q),P)) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(and(P,Q),P)) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => kn2(W0) ) ) ) ) ).

tff(kn3_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => kn3(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [R: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,R)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(implies(P,Q),implies(not(and(Q,R)),not(and(R,P))))) ) ) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [R: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,R)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(implies(P,Q),implies(not(and(Q,R)),not(and(R,P))))) ) ) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => kn3(W0) ) ) ) ) ).

tff(cn1_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => cn1(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [R: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,R)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(implies(P,Q),implies(implies(Q,R),implies(P,R)))) ) ) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [R: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,R)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(implies(P,Q),implies(implies(Q,R),implies(P,R)))) ) ) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => cn1(W0) ) ) ) ) ).

tff(cn2_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => cn2(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(P,implies(not(P),Q))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(P,implies(not(P),Q))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => cn2(W0) ) ) ) ) ).

tff(cn3_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => cn3(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => is_a_theorem(W1,implies(implies(not(P),P),P)) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => is_a_theorem(W1,implies(implies(not(P),P),P)) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => cn3(W0) ) ) ) ) ).

tff(r1_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => r1(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => is_a_theorem(W1,implies(or(P,P),P)) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => is_a_theorem(W1,implies(or(P,P),P)) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => r1(W0) ) ) ) ) ).

tff(r2_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => r2(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(Q,or(P,Q))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(Q,or(P,Q))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => r2(W0) ) ) ) ) ).

tff(r3_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => r3(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(or(P,Q),or(Q,P))) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => is_a_theorem(W2,implies(or(P,Q),or(Q,P))) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => r3(W0) ) ) ) ) ).

tff(r4_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => r4(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [R: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,R)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(or(P,or(Q,R)),or(Q,or(P,R)))) ) ) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [R: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,R)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(or(P,or(Q,R)),or(Q,or(P,R)))) ) ) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => r4(W0) ) ) ) ) ).

tff(r5_0,axiom,
    ( ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => r5(W0) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [R: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,R)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(implies(Q,R),implies(or(P,Q),or(P,R)))) ) ) ) ) ) ) ) ) )
    & ! [W: '$ki_world'] :
        ( '$ki_accessible'('$ki_local_world',W)
       => ( ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [P: $i] :
                  ( '$ki_exists_in_world_$i'(W0,P)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Q: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Q)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [R: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,R)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => is_a_theorem(W3,implies(implies(Q,R),implies(or(P,Q),or(P,R)))) ) ) ) ) ) ) )
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => r5(W0) ) ) ) ) ).

tff(op_or_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ( ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => op_or(W0) )
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => ! [X: $i] :
                ( '$ki_exists_in_world_$i'(W0,X)
               => ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => ! [Y: $i] :
                        ( '$ki_exists_in_world_$i'(W1,Y)
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,or(X,Y),not(and(not(X),not(Y)))) ) ) ) ) ) ) ) ).

tff(op_and_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ( ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => op_and(W0) )
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => ! [X: $i] :
                ( '$ki_exists_in_world_$i'(W0,X)
               => ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => ! [Y: $i] :
                        ( '$ki_exists_in_world_$i'(W1,Y)
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,and(X,Y),not(or(not(X),not(Y)))) ) ) ) ) ) ) ) ).

tff(op_implies_and_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ( ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => op_implies_and(W0) )
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => ! [X: $i] :
                ( '$ki_exists_in_world_$i'(W0,X)
               => ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => ! [Y: $i] :
                        ( '$ki_exists_in_world_$i'(W1,Y)
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,implies(X,Y),not(and(X,not(Y)))) ) ) ) ) ) ) ) ).

tff(op_implies_or_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ( ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => op_implies_or(W0) )
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => ! [X: $i] :
                ( '$ki_exists_in_world_$i'(W0,X)
               => ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => ! [Y: $i] :
                        ( '$ki_exists_in_world_$i'(W1,Y)
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,implies(X,Y),or(not(X),Y)) ) ) ) ) ) ) ) ).

tff(op_equiv_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ( ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => op_equiv(W0) )
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => ! [X: $i] :
                ( '$ki_exists_in_world_$i'(W0,X)
               => ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => ! [Y: $i] :
                        ( '$ki_exists_in_world_$i'(W1,Y)
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,equiv(X,Y),and(implies(X,Y),implies(Y,X))) ) ) ) ) ) ) ) ).

tff(hilbert_op_or,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => op_or(W) ) ).

tff(hilbert_op_implies_and,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => op_implies_and(W) ) ).

tff(hilbert_op_equiv,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => op_equiv(W) ) ).

tff(hilbert_modus_ponens,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => modus_ponens(W) ) ).

tff(hilbert_modus_tollens,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => modus_tollens(W) ) ).

tff(hilbert_implies_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => implies_1(W) ) ).

tff(hilbert_implies_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => implies_2(W) ) ).

tff(hilbert_implies_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => implies_3(W) ) ).

tff(hilbert_and_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => and_1(W) ) ).

tff(hilbert_and_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => and_2(W) ) ).

tff(hilbert_and_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => and_3(W) ) ).

tff(hilbert_or_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => or_1(W) ) ).

tff(hilbert_or_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => or_2(W) ) ).

tff(hilbert_or_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => or_3(W) ) ).

tff(hilbert_equivalence_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => equivalence_1(W) ) ).

tff(hilbert_equivalence_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => equivalence_2(W) ) ).

tff(hilbert_equivalence_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => equivalence_3(W) ) ).

tff(substitution_of_equivalents_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => substitution_of_equivalents(W) ) ).

tff(luka_op_or,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => op_or(W) ) ).

tff(luka_op_implies,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => op_implies(W) ) ).

tff(luka_op_equiv,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => op_equiv(W) ) ).

tff(verify,conjecture,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => cn1(W) ) ).

%------------------------------------------------------------------------------
