%------------------------------------------------------------------------------
% File     : LCL962_16 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Logic calculi
% Problem  : Proving disprovability
% Version  : [QMLTP] axioms.
% English  : If A can prove that B can prove p whenever it is true, and
%            if A can prove that B cannot prove p if that is true, and
%            if p is not true, then A can prove that p is not true.

% Refs     : [HA97]  Huima & Aura (1997), Using Multimodal Logic to Express
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : MML013+1 [QMLTP]

% Status   : Theorem
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :   15 (   3 unt;   7 typ;   0 def)
%            Number of atoms       :   20 (   0 equ)
%            Maximal formula atoms :    5 (   2 avg)
%            Number of connectives :   16 (   4   ~;   0   |;   2   &)
%                                         (   0 <=>;  10  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    7 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :    4 (   2   >;   2   *;   0   +;   0  <<)
%            Number of predicates  :    2 (   2 usr;   0 prp; 1-3 aty)
%            Number of functors    :    3 (   3 usr;   3 con; 0-0 aty)
%            Number of variables   :   14 (;  14   !;   0   ?;  14   :)
% SPC      : TF0_THM_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_S4, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_index_type',type,
    '$ki_index': $tType ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_index' * '$ki_world' * '$ki_world' ) > $o ).

tff('#idx(a)_decl',type,
    '#idx(a)': '$ki_index' ).

tff('#idx(b)_decl',type,
    '#idx(b)': '$ki_index' ).

tff('mrel_reflexive_#idx(a)',axiom,
    ! [W: '$ki_world'] : '$ki_accessible'('#idx(a)',W,W) ).

tff('mrel_transitive_#idx(a)',axiom,
    ! [W: '$ki_world',V: '$ki_world',U: '$ki_world'] :
      ( ( '$ki_accessible'('#idx(a)',W,V)
        & '$ki_accessible'('#idx(a)',V,U) )
     => '$ki_accessible'('#idx(a)',W,U) ) ).

tff('mrel_reflexive_#idx(b)',axiom,
    ! [W: '$ki_world'] : '$ki_accessible'('#idx(b)',W,W) ).

tff('mrel_transitive_#idx(b)',axiom,
    ! [W: '$ki_world',V: '$ki_world',U: '$ki_world'] :
      ( ( '$ki_accessible'('#idx(b)',W,V)
        & '$ki_accessible'('#idx(b)',V,U) )
     => '$ki_accessible'('#idx(b)',W,U) ) ).

tff(p_decl,type,
    p: '$ki_world' > $o ).

tff(ab_axiom_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(a)','$ki_local_world',W)
     => ( p(W)
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'('#idx(b)',W,W0)
           => p(W0) ) ) ) ).

tff(ab_axiom_2,axiom,
    ( ~ ! [W: '$ki_world'] :
          ( '$ki_accessible'('#idx(b)','$ki_local_world',W)
         => p(W) )
   => ! [W: '$ki_world'] :
        ( '$ki_accessible'('#idx(a)','$ki_local_world',W)
       => ~ ! [W0: '$ki_world'] :
              ( '$ki_accessible'('#idx(b)',W,W0)
             => p(W0) ) ) ) ).

tff(not_a_axiom_1,axiom,
    ~ p('$ki_local_world') ).

tff(verify,conjecture,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('#idx(a)','$ki_local_world',W)
     => ~ p(W) ) ).

%------------------------------------------------------------------------------
