%------------------------------------------------------------------------------
% File     : LCL954_19 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Software Verification
% Problem  : Goedel translation of SWV060+1
% Version  : [QMLTP] axioms.
% English  : 

% Refs     : [Goe69] Goedel (1969), An Interpretation of the Intuitionistic
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : GSV060+1 [QMLTP]
%          : GSV060_1.001_k_constant_rigid.p [QMLTP/4_NX0_SEMs]

% Status   : Theorem
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :  175 (   2 unt;  38 typ;   0 def)
%            Number of atoms       : 1510 (   0 equ)
%            Maximal formula atoms :   77 (  11 avg)
%            Number of connectives : 1378 (   5   ~;  17   |; 107   &)
%                                         (   0 <=>;1249  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   54 (  15 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   58 (  26   >;  32   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   8 usr;   0 prp; 1-3 aty)
%            Number of functors    :   29 (  29 usr;  11 con; 0-4 aty)
%            Number of variables   : 1144 (;1143   !;   1   ?;1144   :)
% SPC      : TF0_THM_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_S4, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_world' * '$ki_world' ) > $o ).

tff(mrel_reflexive,axiom,
    ! [W: '$ki_world'] : '$ki_accessible'(W,W) ).

tff(mrel_transitive,axiom,
    ! [W: '$ki_world',V: '$ki_world',U: '$ki_world'] :
      ( ( '$ki_accessible'(W,V)
        & '$ki_accessible'(V,U) )
     => '$ki_accessible'(W,U) ) ).

tff(typedecl_customqmltpeq,type,
    customqmltpeq: ( '$ki_world' * $i * $i ) > $o ).

tff(true_decl,type,
    true: '$ki_world' > $o ).

tff(def_decl,type,
    def: $i ).

tff(tptp_minus_1_decl,type,
    tptp_minus_1: $i ).

tff(tptp_float_0_0_decl,type,
    tptp_float_0_0: $i ).

tff(n0_decl,type,
    n0: $i ).

tff(n1_decl,type,
    n1: $i ).

tff(n2_decl,type,
    n2: $i ).

tff(n3_decl,type,
    n3: $i ).

tff(n4_decl,type,
    n4: $i ).

tff(use_decl,type,
    use: $i ).

tff(n5_decl,type,
    n5: $i ).

tff(geq_decl,type,
    geq: ( '$ki_world' * $i * $i ) > $o ).

tff(lt_decl,type,
    lt: ( '$ki_world' * $i * $i ) > $o ).

tff(leq_decl,type,
    leq: ( '$ki_world' * $i * $i ) > $o ).

tff(gt_decl,type,
    gt: ( '$ki_world' * $i * $i ) > $o ).

tff(minus_decl,type,
    minus: ( $i * $i ) > $i ).

tff(dim_decl,type,
    dim: ( $i * $i ) > $i ).

tff(sum_decl,type,
    sum: ( $i * $i * $i ) > $i ).

tff(plus_decl,type,
    plus: ( $i * $i ) > $i ).

tff(inv_decl,type,
    inv: $i > $i ).

tff(uniform_int_rnd_decl,type,
    uniform_int_rnd: ( $i * $i ) > $i ).

tff(succ_decl,type,
    succ: $i > $i ).

tff(pred_decl,type,
    pred: $i > $i ).

tff(tptp_update3_decl,type,
    tptp_update3: ( $i * $i * $i * $i ) > $i ).

tff(tptp_update2_decl,type,
    tptp_update2: ( $i * $i * $i ) > $i ).

tff(tptp_const_array1_decl,type,
    tptp_const_array1: ( $i * $i ) > $i ).

tff(tptp_mmul_decl,type,
    tptp_mmul: ( $i * $i ) > $i ).

tff(a_select3_decl,type,
    a_select3: ( $i * $i * $i ) > $i ).

tff(tptp_const_array2_decl,type,
    tptp_const_array2: ( $i * $i * $i ) > $i ).

tff(a_select2_decl,type,
    a_select2: ( $i * $i ) > $i ).

tff(tptp_madd_decl,type,
    tptp_madd: ( $i * $i ) > $i ).

tff(tptp_msub_decl,type,
    tptp_msub: ( $i * $i ) > $i ).

tff(trans_decl,type,
    trans: $i > $i ).

tff('$ki_exists_in_world_$i_decl',type,
    '$ki_exists_in_world_$i': ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_nonempty',axiom,
    ! [W: '$ki_world'] :
    ? [X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff(reflexivity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,X,X) ) ) ) ).

tff(symmetry,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => customqmltpeq(W2,X,Y) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => customqmltpeq(W2,Y,X) ) ) ) ) ) ) ) ).

tff(transitivity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Z: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Z)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,X,Y) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,Y,Z) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,X,Z) ) ) ) ) ) ) ) ) ) ).

tff(a_select2_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,a_select2(A,C),a_select2(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(a_select2_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,a_select2(C,A),a_select2(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(a_select3_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,a_select3(A,C,D),a_select3(B,C,D)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(a_select3_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,a_select3(C,A,D),a_select3(C,B,D)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(a_select3_substitution_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,a_select3(C,D,A),a_select3(C,D,B)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(dim_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,dim(A,C),dim(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(dim_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,dim(C,A),dim(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(inv_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => customqmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => customqmltpeq(W2,inv(A),inv(B)) ) ) ) ) ) ) ) ).

tff(minus_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,minus(A,C),minus(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(minus_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,minus(C,A),minus(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(plus_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,plus(A,C),plus(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(plus_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,plus(C,A),plus(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(pred_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => customqmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => customqmltpeq(W2,pred(A),pred(B)) ) ) ) ) ) ) ) ).

tff(succ_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => customqmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => customqmltpeq(W2,succ(A),succ(B)) ) ) ) ) ) ) ) ).

tff(sum_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,sum(A,C,D),sum(B,C,D)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(sum_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,sum(C,A,D),sum(C,B,D)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(sum_substitution_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,sum(C,D,A),sum(C,D,B)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(tptp_const_array1_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,tptp_const_array1(A,C),tptp_const_array1(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(tptp_const_array1_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,tptp_const_array1(C,A),tptp_const_array1(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(tptp_const_array2_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,tptp_const_array2(A,C,D),tptp_const_array2(B,C,D)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(tptp_const_array2_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,tptp_const_array2(C,A,D),tptp_const_array2(C,B,D)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(tptp_const_array2_substitution_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,tptp_const_array2(C,D,A),tptp_const_array2(C,D,B)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(tptp_madd_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,tptp_madd(A,C),tptp_madd(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(tptp_madd_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,tptp_madd(C,A),tptp_madd(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(tptp_mmul_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,tptp_mmul(A,C),tptp_mmul(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(tptp_mmul_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,tptp_mmul(C,A),tptp_mmul(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(tptp_msub_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,tptp_msub(A,C),tptp_msub(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(tptp_msub_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,tptp_msub(C,A),tptp_msub(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(tptp_update2_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,tptp_update2(A,C,D),tptp_update2(B,C,D)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(tptp_update2_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,tptp_update2(C,A,D),tptp_update2(C,B,D)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(tptp_update2_substitution_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,tptp_update2(C,D,A),tptp_update2(C,D,B)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(tptp_update3_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [E: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,E)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ( ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => customqmltpeq(W5,A,B) )
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => customqmltpeq(W5,tptp_update3(A,C,D,E),tptp_update3(B,C,D,E)) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(tptp_update3_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [E: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,E)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ( ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => customqmltpeq(W5,A,B) )
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => customqmltpeq(W5,tptp_update3(C,A,D,E),tptp_update3(C,B,D,E)) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(tptp_update3_substitution_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [E: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,E)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ( ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => customqmltpeq(W5,A,B) )
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => customqmltpeq(W5,tptp_update3(C,D,A,E),tptp_update3(C,D,B,E)) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(tptp_update3_substitution_4,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [E: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,E)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ( ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => customqmltpeq(W5,A,B) )
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => customqmltpeq(W5,tptp_update3(C,D,E,A),tptp_update3(C,D,E,B)) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(trans_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => customqmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => customqmltpeq(W2,trans(A),trans(B)) ) ) ) ) ) ) ) ).

tff(uniform_int_rnd_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,uniform_int_rnd(A,C),uniform_int_rnd(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(uniform_int_rnd_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,uniform_int_rnd(C,A),uniform_int_rnd(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(geq_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => geq(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => geq(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(geq_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => geq(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => geq(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(gt_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => gt(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => gt(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(gt_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => gt(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => gt(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(leq_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => leq(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => leq(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(leq_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => leq(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => leq(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(lt_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => lt(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => lt(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(lt_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => lt(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => lt(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(totality,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => gt(W1,X,Y) )
                    | ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => gt(W1,Y,X) )
                    | ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => customqmltpeq(W1,X,Y) ) ) ) ) ) ) ).

tff(transitivity_gt,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Z: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Z)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => gt(W3,X,Y) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => gt(W3,Y,Z) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => gt(W3,X,Z) ) ) ) ) ) ) ) ) ) ).

tff(irreflexivity_gt,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ~ ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => gt(W1,X,X) ) ) ) ) ).

tff(reflexivity_leq,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => leq(W0,X,X) ) ) ) ).

tff(transitivity_leq,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Z: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Z)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => leq(W3,X,Y) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => leq(W3,Y,Z) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => leq(W3,X,Z) ) ) ) ) ) ) ) ) ) ).

tff(lt_gt,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => lt(W2,X,Y) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => gt(W2,Y,X) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => gt(W2,Y,X) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => lt(W2,X,Y) ) ) ) ) ) ) ) ) ).

tff(leq_geq,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => geq(W2,X,Y) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,Y,X) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,Y,X) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => geq(W2,X,Y) ) ) ) ) ) ) ) ) ).

tff(leq_gt1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => gt(W2,Y,X) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => leq(W2,X,Y) ) ) ) ) ) ) ) ).

tff(leq_gt2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,X,Y) )
                          & ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ~ ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => customqmltpeq(W3,X,Y) ) ) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => gt(W2,Y,X) ) ) ) ) ) ) ) ).

tff(leq_gt_pred,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,X,pred(Y)) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => gt(W2,Y,X) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => gt(W2,Y,X) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,X,pred(Y)) ) ) ) ) ) ) ) ) ).

tff(gt_succ,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => gt(W0,succ(X),X) ) ) ) ).

tff(leq_succ,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => leq(W2,X,Y) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => leq(W2,X,succ(Y)) ) ) ) ) ) ) ) ).

tff(leq_succ_gt_equiv,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,X,Y) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => gt(W2,succ(Y),X) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => gt(W2,succ(Y),X) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,X,Y) ) ) ) ) ) ) ) ) ).

tff(uniform_int_rand_ranges_hi,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [C: $i] :
                  ( '$ki_exists_in_world_$i'(W0,C)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => leq(W2,n0,X) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => leq(W2,uniform_int_rnd(C,X),X) ) ) ) ) ) ) ) ).

tff(uniform_int_rand_ranges_lo,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [C: $i] :
                  ( '$ki_exists_in_world_$i'(W0,C)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => leq(W2,n0,X) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => leq(W2,n0,uniform_int_rnd(C,X)) ) ) ) ) ) ) ) ).

tff(const_array1_select,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [I: $i] :
          ( '$ki_exists_in_world_$i'(W,I)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [L: $i] :
                  ( '$ki_exists_in_world_$i'(W0,L)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [U: $i] :
                          ( '$ki_exists_in_world_$i'(W1,U)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [Val: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,Val)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => leq(W4,L,I) )
                                          & ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => leq(W4,I,U) ) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,a_select2(tptp_const_array1(dim(L,U),Val),I),Val) ) ) ) ) ) ) ) ) ) ) ) ).

tff(const_array2_select,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [I: $i] :
          ( '$ki_exists_in_world_$i'(W,I)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [L1: $i] :
                  ( '$ki_exists_in_world_$i'(W0,L1)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [U1: $i] :
                          ( '$ki_exists_in_world_$i'(W1,U1)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [J: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,J)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [L2: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,L2)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ! [U2: $i] :
                                                  ( '$ki_exists_in_world_$i'(W4,U2)
                                                 => ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => ! [Val: $i] :
                                                          ( '$ki_exists_in_world_$i'(W5,Val)
                                                         => ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => ( ( ! [W7: '$ki_world'] :
                                                                      ( '$ki_accessible'(W6,W7)
                                                                     => leq(W7,L1,I) )
                                                                  & ! [W7: '$ki_world'] :
                                                                      ( '$ki_accessible'(W6,W7)
                                                                     => leq(W7,I,U1) )
                                                                  & ! [W7: '$ki_world'] :
                                                                      ( '$ki_accessible'(W6,W7)
                                                                     => leq(W7,L2,J) )
                                                                  & ! [W7: '$ki_world'] :
                                                                      ( '$ki_accessible'(W6,W7)
                                                                     => leq(W7,J,U2) ) )
                                                               => ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => customqmltpeq(W7,a_select3(tptp_const_array2(dim(L1,U1),dim(L2,U2),Val),I,J),Val) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(matrix_symm_trans,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [N: $i] :
                  ( '$ki_exists_in_world_$i'(W0,N)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => ! [I: $i] :
                                ( '$ki_exists_in_world_$i'(W2,I)
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => ! [J: $i] :
                                        ( '$ki_exists_in_world_$i'(W3,J)
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ( ( ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,n0,I) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,I,N) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,n0,J) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,J,N) ) )
                                             => ! [W5: '$ki_world'] :
                                                  ( '$ki_accessible'(W4,W5)
                                                 => customqmltpeq(W5,a_select3(A,I,J),a_select3(A,J,I)) ) ) ) ) ) ) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => ! [I: $i] :
                                ( '$ki_exists_in_world_$i'(W2,I)
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => ! [J: $i] :
                                        ( '$ki_exists_in_world_$i'(W3,J)
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ( ( ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,n0,I) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,I,N) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,n0,J) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,J,N) ) )
                                             => ! [W5: '$ki_world'] :
                                                  ( '$ki_accessible'(W4,W5)
                                                 => customqmltpeq(W5,a_select3(trans(A),I,J),a_select3(trans(A),J,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(matrix_symm_inv,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [N: $i] :
                  ( '$ki_exists_in_world_$i'(W0,N)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => ! [I: $i] :
                                ( '$ki_exists_in_world_$i'(W2,I)
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => ! [J: $i] :
                                        ( '$ki_exists_in_world_$i'(W3,J)
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ( ( ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,n0,I) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,I,N) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,n0,J) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,J,N) ) )
                                             => ! [W5: '$ki_world'] :
                                                  ( '$ki_accessible'(W4,W5)
                                                 => customqmltpeq(W5,a_select3(A,I,J),a_select3(A,J,I)) ) ) ) ) ) ) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => ! [I: $i] :
                                ( '$ki_exists_in_world_$i'(W2,I)
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => ! [J: $i] :
                                        ( '$ki_exists_in_world_$i'(W3,J)
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ( ( ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,n0,I) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,I,N) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,n0,J) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,J,N) ) )
                                             => ! [W5: '$ki_world'] :
                                                  ( '$ki_accessible'(W4,W5)
                                                 => customqmltpeq(W5,a_select3(inv(A),I,J),a_select3(inv(A),J,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(matrix_symm_update_diagonal,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [N: $i] :
                  ( '$ki_exists_in_world_$i'(W0,N)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => ! [I: $i] :
                                ( '$ki_exists_in_world_$i'(W2,I)
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => ! [J: $i] :
                                        ( '$ki_exists_in_world_$i'(W3,J)
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ( ( ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,n0,I) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,I,N) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,n0,J) )
                                                & ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => leq(W5,J,N) ) )
                                             => ! [W5: '$ki_world'] :
                                                  ( '$ki_accessible'(W4,W5)
                                                 => customqmltpeq(W5,a_select3(A,I,J),a_select3(A,J,I)) ) ) ) ) ) ) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => ! [I: $i] :
                                ( '$ki_exists_in_world_$i'(W2,I)
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => ! [J: $i] :
                                        ( '$ki_exists_in_world_$i'(W3,J)
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ! [K: $i] :
                                                ( '$ki_exists_in_world_$i'(W4,K)
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => ! [VAL: $i] :
                                                        ( '$ki_exists_in_world_$i'(W5,VAL)
                                                       => ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => ( ( ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,n0,I) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,I,N) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,n0,J) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,J,N) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,n0,K) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,K,N) ) )
                                                             => ! [W7: '$ki_world'] :
                                                                  ( '$ki_accessible'(W6,W7)
                                                                 => customqmltpeq(W7,a_select3(tptp_update3(A,K,K,VAL),I,J),a_select3(tptp_update3(A,K,K,VAL),J,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(matrix_symm_add,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [N: $i] :
                          ( '$ki_exists_in_world_$i'(W1,N)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [I: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,I)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ! [J: $i] :
                                                  ( '$ki_exists_in_world_$i'(W4,J)
                                                 => ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => ( ( ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,I) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,I,N) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,J) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,J,N) ) )
                                                       => ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => customqmltpeq(W6,a_select3(A,I,J),a_select3(A,J,I)) ) ) ) ) ) ) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [I: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,I)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ! [J: $i] :
                                                  ( '$ki_exists_in_world_$i'(W4,J)
                                                 => ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => ( ( ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,I) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,I,N) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,J) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,J,N) ) )
                                                       => ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => customqmltpeq(W6,a_select3(B,I,J),a_select3(B,J,I)) ) ) ) ) ) ) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => ! [I: $i] :
                                        ( '$ki_exists_in_world_$i'(W3,I)
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ! [J: $i] :
                                                ( '$ki_exists_in_world_$i'(W4,J)
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => ( ( ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,n0,I) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,I,N) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,n0,J) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,J,N) ) )
                                                     => ! [W6: '$ki_world'] :
                                                          ( '$ki_accessible'(W5,W6)
                                                         => customqmltpeq(W6,a_select3(tptp_madd(A,B),I,J),a_select3(tptp_madd(A,B),J,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(matrix_symm_sub,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [N: $i] :
                          ( '$ki_exists_in_world_$i'(W1,N)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [I: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,I)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ! [J: $i] :
                                                  ( '$ki_exists_in_world_$i'(W4,J)
                                                 => ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => ( ( ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,I) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,I,N) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,J) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,J,N) ) )
                                                       => ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => customqmltpeq(W6,a_select3(A,I,J),a_select3(A,J,I)) ) ) ) ) ) ) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [I: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,I)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ! [J: $i] :
                                                  ( '$ki_exists_in_world_$i'(W4,J)
                                                 => ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => ( ( ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,I) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,I,N) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,J) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,J,N) ) )
                                                       => ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => customqmltpeq(W6,a_select3(B,I,J),a_select3(B,J,I)) ) ) ) ) ) ) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => ! [I: $i] :
                                        ( '$ki_exists_in_world_$i'(W3,I)
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ! [J: $i] :
                                                ( '$ki_exists_in_world_$i'(W4,J)
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => ( ( ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,n0,I) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,I,N) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,n0,J) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,J,N) ) )
                                                     => ! [W6: '$ki_world'] :
                                                          ( '$ki_accessible'(W5,W6)
                                                         => customqmltpeq(W6,a_select3(tptp_msub(A,B),I,J),a_select3(tptp_msub(A,B),J,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(matrix_symm_aba1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [N: $i] :
                          ( '$ki_exists_in_world_$i'(W1,N)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => ! [I: $i] :
                                        ( '$ki_exists_in_world_$i'(W3,I)
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ! [J: $i] :
                                                ( '$ki_exists_in_world_$i'(W4,J)
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => ( ( ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,n0,I) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,I,N) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,n0,J) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,J,N) ) )
                                                     => ! [W6: '$ki_world'] :
                                                          ( '$ki_accessible'(W5,W6)
                                                         => customqmltpeq(W6,a_select3(B,I,J),a_select3(B,J,I)) ) ) ) ) ) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => ! [I: $i] :
                                        ( '$ki_exists_in_world_$i'(W3,I)
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ! [J: $i] :
                                                ( '$ki_exists_in_world_$i'(W4,J)
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => ( ( ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,n0,I) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,I,N) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,n0,J) )
                                                        & ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => leq(W6,J,N) ) )
                                                     => ! [W6: '$ki_world'] :
                                                          ( '$ki_accessible'(W5,W6)
                                                         => customqmltpeq(W6,a_select3(tptp_mmul(A,tptp_mmul(B,trans(A))),I,J),a_select3(tptp_mmul(A,tptp_mmul(B,trans(A))),J,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(matrix_symm_aba2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [N: $i] :
                          ( '$ki_exists_in_world_$i'(W1,N)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [M: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,M)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ! [I: $i] :
                                                ( '$ki_exists_in_world_$i'(W4,I)
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => ! [J: $i] :
                                                        ( '$ki_exists_in_world_$i'(W5,J)
                                                       => ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => ( ( ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,n0,I) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,I,M) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,n0,J) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,J,M) ) )
                                                             => ! [W7: '$ki_world'] :
                                                                  ( '$ki_accessible'(W6,W7)
                                                                 => customqmltpeq(W7,a_select3(B,I,J),a_select3(B,J,I)) ) ) ) ) ) ) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => ! [I: $i] :
                                                ( '$ki_exists_in_world_$i'(W4,I)
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => ! [J: $i] :
                                                        ( '$ki_exists_in_world_$i'(W5,J)
                                                       => ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => ( ( ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,n0,I) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,I,N) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,n0,J) )
                                                                & ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => leq(W7,J,N) ) )
                                                             => ! [W7: '$ki_world'] :
                                                                  ( '$ki_accessible'(W6,W7)
                                                                 => customqmltpeq(W7,a_select3(tptp_mmul(A,tptp_mmul(B,trans(A))),I,J),a_select3(tptp_mmul(A,tptp_mmul(B,trans(A))),J,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(matrix_symm_joseph_update,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [E: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,E)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ! [F: $i] :
                                                  ( '$ki_exists_in_world_$i'(W4,F)
                                                 => ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => ! [N: $i] :
                                                          ( '$ki_exists_in_world_$i'(W5,N)
                                                         => ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => ! [M: $i] :
                                                                  ( '$ki_exists_in_world_$i'(W6,M)
                                                                 => ! [W7: '$ki_world'] :
                                                                      ( '$ki_accessible'(W6,W7)
                                                                     => ( ( ! [W8: '$ki_world'] :
                                                                              ( '$ki_accessible'(W7,W8)
                                                                             => ! [I: $i] :
                                                                                  ( '$ki_exists_in_world_$i'(W8,I)
                                                                                 => ! [W9: '$ki_world'] :
                                                                                      ( '$ki_accessible'(W8,W9)
                                                                                     => ! [J: $i] :
                                                                                          ( '$ki_exists_in_world_$i'(W9,J)
                                                                                         => ! [W10: '$ki_world'] :
                                                                                              ( '$ki_accessible'(W9,W10)
                                                                                             => ( ( ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,n0,I) )
                                                                                                  & ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,I,M) )
                                                                                                  & ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,n0,J) )
                                                                                                  & ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,J,M) ) )
                                                                                               => ! [W11: '$ki_world'] :
                                                                                                    ( '$ki_accessible'(W10,W11)
                                                                                                   => customqmltpeq(W11,a_select3(D,I,J),a_select3(D,J,I)) ) ) ) ) ) ) )
                                                                          & ! [W8: '$ki_world'] :
                                                                              ( '$ki_accessible'(W7,W8)
                                                                             => ! [I: $i] :
                                                                                  ( '$ki_exists_in_world_$i'(W8,I)
                                                                                 => ! [W9: '$ki_world'] :
                                                                                      ( '$ki_accessible'(W8,W9)
                                                                                     => ! [J: $i] :
                                                                                          ( '$ki_exists_in_world_$i'(W9,J)
                                                                                         => ! [W10: '$ki_world'] :
                                                                                              ( '$ki_accessible'(W9,W10)
                                                                                             => ( ( ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,n0,I) )
                                                                                                  & ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,I,N) )
                                                                                                  & ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,n0,J) )
                                                                                                  & ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,J,N) ) )
                                                                                               => ! [W11: '$ki_world'] :
                                                                                                    ( '$ki_accessible'(W10,W11)
                                                                                                   => customqmltpeq(W11,a_select3(A,I,J),a_select3(A,J,I)) ) ) ) ) ) ) )
                                                                          & ! [W8: '$ki_world'] :
                                                                              ( '$ki_accessible'(W7,W8)
                                                                             => ! [I: $i] :
                                                                                  ( '$ki_exists_in_world_$i'(W8,I)
                                                                                 => ! [W9: '$ki_world'] :
                                                                                      ( '$ki_accessible'(W8,W9)
                                                                                     => ! [J: $i] :
                                                                                          ( '$ki_exists_in_world_$i'(W9,J)
                                                                                         => ! [W10: '$ki_world'] :
                                                                                              ( '$ki_accessible'(W9,W10)
                                                                                             => ( ( ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,n0,I) )
                                                                                                  & ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,I,N) )
                                                                                                  & ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,n0,J) )
                                                                                                  & ! [W11: '$ki_world'] :
                                                                                                      ( '$ki_accessible'(W10,W11)
                                                                                                     => leq(W11,J,N) ) )
                                                                                               => ! [W11: '$ki_world'] :
                                                                                                    ( '$ki_accessible'(W10,W11)
                                                                                                   => customqmltpeq(W11,a_select3(F,I,J),a_select3(F,J,I)) ) ) ) ) ) ) ) )
                                                                       => ! [W8: '$ki_world'] :
                                                                            ( '$ki_accessible'(W7,W8)
                                                                           => ! [I: $i] :
                                                                                ( '$ki_exists_in_world_$i'(W8,I)
                                                                               => ! [W9: '$ki_world'] :
                                                                                    ( '$ki_accessible'(W8,W9)
                                                                                   => ! [J: $i] :
                                                                                        ( '$ki_exists_in_world_$i'(W9,J)
                                                                                       => ! [W10: '$ki_world'] :
                                                                                            ( '$ki_accessible'(W9,W10)
                                                                                           => ( ( ! [W11: '$ki_world'] :
                                                                                                    ( '$ki_accessible'(W10,W11)
                                                                                                   => leq(W11,n0,I) )
                                                                                                & ! [W11: '$ki_world'] :
                                                                                                    ( '$ki_accessible'(W10,W11)
                                                                                                   => leq(W11,I,N) )
                                                                                                & ! [W11: '$ki_world'] :
                                                                                                    ( '$ki_accessible'(W10,W11)
                                                                                                   => leq(W11,n0,J) )
                                                                                                & ! [W11: '$ki_world'] :
                                                                                                    ( '$ki_accessible'(W10,W11)
                                                                                                   => leq(W11,J,N) ) )
                                                                                             => ! [W11: '$ki_world'] :
                                                                                                  ( '$ki_accessible'(W10,W11)
                                                                                                 => customqmltpeq(W11,a_select3(tptp_madd(A,tptp_mmul(B,tptp_mmul(tptp_madd(tptp_mmul(C,tptp_mmul(D,trans(C))),tptp_mmul(E,tptp_mmul(F,trans(E)))),trans(B)))),I,J),a_select3(tptp_madd(A,tptp_mmul(B,tptp_mmul(tptp_madd(tptp_mmul(C,tptp_mmul(D,trans(C))),tptp_mmul(E,tptp_mmul(F,trans(E)))),trans(B)))),J,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(sum_plus_base,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [Body: $i] :
          ( '$ki_exists_in_world_$i'(W,Body)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,sum(n0,tptp_minus_1,Body),n0) ) ) ) ).

tff(sum_plus_base_float,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [Body: $i] :
          ( '$ki_exists_in_world_$i'(W,Body)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,tptp_float_0_0,sum(n0,tptp_minus_1,Body)) ) ) ) ).

tff(succ_tptp_minus_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => customqmltpeq(W,succ(tptp_minus_1),n0) ) ).

tff(succ_plus_1_r,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,plus(X,n1),succ(X)) ) ) ) ).

tff(succ_plus_1_l,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,plus(n1,X),succ(X)) ) ) ) ).

tff(succ_plus_2_r,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,plus(X,n2),succ(succ(X))) ) ) ) ).

tff(succ_plus_2_l,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,plus(n2,X),succ(succ(X))) ) ) ) ).

tff(succ_plus_3_r,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,plus(X,n3),succ(succ(succ(X)))) ) ) ) ).

tff(succ_plus_3_l,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,plus(n3,X),succ(succ(succ(X)))) ) ) ) ).

tff(succ_plus_4_r,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,plus(X,n4),succ(succ(succ(succ(X))))) ) ) ) ).

tff(succ_plus_4_l,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,plus(n4,X),succ(succ(succ(succ(X))))) ) ) ) ).

tff(succ_plus_5_r,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,plus(X,n5),succ(succ(succ(succ(succ(X)))))) ) ) ) ).

tff(succ_plus_5_l,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,plus(n5,X),succ(succ(succ(succ(succ(X)))))) ) ) ) ).

tff(pred_minus_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,minus(X,n1),pred(X)) ) ) ) ).

tff(pred_succ,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,pred(succ(X)),X) ) ) ) ).

tff(succ_pred,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => customqmltpeq(W0,succ(pred(X)),X) ) ) ) ).

tff(leq_succ_succ,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,succ(X),succ(Y)) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,X,Y) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,X,Y) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => leq(W2,succ(X),succ(Y)) ) ) ) ) ) ) ) ) ).

tff(leq_succ_gt,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => leq(W2,succ(X),Y) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => gt(W2,Y,X) ) ) ) ) ) ) ) ).

tff(leq_minus,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => leq(W2,minus(X,Y),X) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => leq(W2,n0,Y) ) ) ) ) ) ) ) ).

tff(sel3_update_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [U: $i] :
                  ( '$ki_exists_in_world_$i'(W0,U)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [V: $i] :
                          ( '$ki_exists_in_world_$i'(W1,V)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [VAL: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,VAL)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => customqmltpeq(W3,a_select3(tptp_update3(X,U,V,VAL),U,V),VAL) ) ) ) ) ) ) ) ) ) ).

tff(sel3_update_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [I: $i] :
          ( '$ki_exists_in_world_$i'(W,I)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [J: $i] :
                  ( '$ki_exists_in_world_$i'(W0,J)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [U: $i] :
                          ( '$ki_exists_in_world_$i'(W1,U)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [V: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,V)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [X: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,X)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ! [VAL: $i] :
                                                  ( '$ki_exists_in_world_$i'(W4,VAL)
                                                 => ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => ! [VAL2: $i] :
                                                          ( '$ki_exists_in_world_$i'(W5,VAL2)
                                                         => ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => ( ( ! [W7: '$ki_world'] :
                                                                      ( '$ki_accessible'(W6,W7)
                                                                     => ~ ! [W8: '$ki_world'] :
                                                                            ( '$ki_accessible'(W7,W8)
                                                                           => customqmltpeq(W8,I,U) ) )
                                                                  & ! [W7: '$ki_world'] :
                                                                      ( '$ki_accessible'(W6,W7)
                                                                     => customqmltpeq(W7,J,V) )
                                                                  & ! [W7: '$ki_world'] :
                                                                      ( '$ki_accessible'(W6,W7)
                                                                     => customqmltpeq(W7,a_select3(X,U,V),VAL) ) )
                                                               => ! [W7: '$ki_world'] :
                                                                    ( '$ki_accessible'(W6,W7)
                                                                   => customqmltpeq(W7,a_select3(tptp_update3(X,I,J,VAL2),U,V),VAL) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(sel3_update_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [I: $i] :
          ( '$ki_exists_in_world_$i'(W,I)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [J: $i] :
                  ( '$ki_exists_in_world_$i'(W0,J)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [U: $i] :
                          ( '$ki_exists_in_world_$i'(W1,U)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [V: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,V)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [X: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,X)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ! [VAL: $i] :
                                                  ( '$ki_exists_in_world_$i'(W4,VAL)
                                                 => ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => ( ( ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => ! [I0: $i] :
                                                                  ( '$ki_exists_in_world_$i'(W6,I0)
                                                                 => ! [W7: '$ki_world'] :
                                                                      ( '$ki_accessible'(W6,W7)
                                                                     => ! [J0: $i] :
                                                                          ( '$ki_exists_in_world_$i'(W7,J0)
                                                                         => ! [W8: '$ki_world'] :
                                                                              ( '$ki_accessible'(W7,W8)
                                                                             => ( ( ! [W9: '$ki_world'] :
                                                                                      ( '$ki_accessible'(W8,W9)
                                                                                     => leq(W9,n0,I0) )
                                                                                  & ! [W9: '$ki_world'] :
                                                                                      ( '$ki_accessible'(W8,W9)
                                                                                     => leq(W9,n0,J0) )
                                                                                  & ! [W9: '$ki_world'] :
                                                                                      ( '$ki_accessible'(W8,W9)
                                                                                     => leq(W9,I0,U) )
                                                                                  & ! [W9: '$ki_world'] :
                                                                                      ( '$ki_accessible'(W8,W9)
                                                                                     => leq(W9,J0,V) ) )
                                                                               => ! [W9: '$ki_world'] :
                                                                                    ( '$ki_accessible'(W8,W9)
                                                                                   => customqmltpeq(W9,a_select3(X,I0,J0),VAL) ) ) ) ) ) ) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,I) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,I,U) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,J) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,J,V) ) )
                                                       => ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => customqmltpeq(W6,a_select3(tptp_update3(X,U,V,VAL),I,J),VAL) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(sel2_update_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [U: $i] :
                  ( '$ki_exists_in_world_$i'(W0,U)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [VAL: $i] :
                          ( '$ki_exists_in_world_$i'(W1,VAL)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => customqmltpeq(W2,a_select2(tptp_update2(X,U,VAL),U),VAL) ) ) ) ) ) ) ) ).

tff(sel2_update_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [I: $i] :
          ( '$ki_exists_in_world_$i'(W,I)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [U: $i] :
                  ( '$ki_exists_in_world_$i'(W0,U)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [X: $i] :
                          ( '$ki_exists_in_world_$i'(W1,X)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [VAL: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,VAL)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ! [VAL2: $i] :
                                          ( '$ki_exists_in_world_$i'(W3,VAL2)
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ( ( ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => ~ ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => customqmltpeq(W6,I,U) ) )
                                                  & ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => customqmltpeq(W5,a_select2(X,U),VAL) ) )
                                               => ! [W5: '$ki_world'] :
                                                    ( '$ki_accessible'(W4,W5)
                                                   => customqmltpeq(W5,a_select2(tptp_update2(X,I,VAL2),U),VAL) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(sel2_update_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [I: $i] :
          ( '$ki_exists_in_world_$i'(W,I)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [U: $i] :
                  ( '$ki_exists_in_world_$i'(W0,U)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [X: $i] :
                          ( '$ki_exists_in_world_$i'(W1,X)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [VAL: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,VAL)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => ! [I0: $i] :
                                                  ( '$ki_exists_in_world_$i'(W4,I0)
                                                 => ! [W5: '$ki_world'] :
                                                      ( '$ki_accessible'(W4,W5)
                                                     => ( ( ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,n0,I0) )
                                                          & ! [W6: '$ki_world'] :
                                                              ( '$ki_accessible'(W5,W6)
                                                             => leq(W6,I0,U) ) )
                                                       => ! [W6: '$ki_world'] :
                                                            ( '$ki_accessible'(W5,W6)
                                                           => customqmltpeq(W6,a_select2(X,I0),VAL) ) ) ) ) )
                                          & ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => leq(W4,n0,I) )
                                          & ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => leq(W4,I,U) ) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => customqmltpeq(W4,a_select2(tptp_update2(X,U,VAL),I),VAL) ) ) ) ) ) ) ) ) ) ) ) ).

tff(ttrue,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => true(W) ) ).

tff(defuse,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ~ ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => customqmltpeq(W0,def,use) ) ) ).

tff(gt_5_4,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n5,n4) ) ).

tff(gt_4_tptp_minus_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n4,tptp_minus_1) ) ).

tff(gt_5_tptp_minus_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n5,tptp_minus_1) ) ).

tff(gt_0_tptp_minus_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n0,tptp_minus_1) ) ).

tff(gt_1_tptp_minus_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n1,tptp_minus_1) ) ).

tff(gt_2_tptp_minus_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n2,tptp_minus_1) ) ).

tff(gt_3_tptp_minus_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n3,tptp_minus_1) ) ).

tff(gt_4_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n4,n0) ) ).

tff(gt_5_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n5,n0) ) ).

tff(gt_1_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n1,n0) ) ).

tff(gt_2_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n2,n0) ) ).

tff(gt_3_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n3,n0) ) ).

tff(gt_4_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n4,n1) ) ).

tff(gt_5_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n5,n1) ) ).

tff(gt_2_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n2,n1) ) ).

tff(gt_3_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n3,n1) ) ).

tff(gt_4_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n4,n2) ) ).

tff(gt_5_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n5,n2) ) ).

tff(gt_3_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n3,n2) ) ).

tff(gt_4_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n4,n3) ) ).

tff(gt_5_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => gt(W,n5,n3) ) ).

tff(finite_domain_4,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ( ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,n0,X) )
                  & ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,X,n4) ) )
               => ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n0) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n1) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n2) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n3) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n4) ) ) ) ) ) ) ).

tff(finite_domain_5,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ( ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,n0,X) )
                  & ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,X,n5) ) )
               => ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n0) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n1) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n2) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n3) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n4) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n5) ) ) ) ) ) ) ).

tff(finite_domain_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ( ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,n0,X) )
                  & ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,X,n0) ) )
               => ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => customqmltpeq(W1,X,n0) ) ) ) ) ) ).

tff(finite_domain_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ( ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,n0,X) )
                  & ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,X,n1) ) )
               => ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n0) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n1) ) ) ) ) ) ) ).

tff(finite_domain_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ( ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,n0,X) )
                  & ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,X,n2) ) )
               => ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n0) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n1) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n2) ) ) ) ) ) ) ).

tff(finite_domain_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ( ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,n0,X) )
                  & ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => leq(W1,X,n3) ) )
               => ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n0) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n1) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n2) )
                  | ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => customqmltpeq(W1,X,n3) ) ) ) ) ) ) ).

tff(successor_4,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => customqmltpeq(W,succ(succ(succ(succ(n0)))),n4) ) ).

tff(successor_5,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => customqmltpeq(W,succ(succ(succ(succ(succ(n0))))),n5) ) ).

tff(successor_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => customqmltpeq(W,succ(n0),n1) ) ).

tff(successor_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => customqmltpeq(W,succ(succ(n0)),n2) ) ).

tff(successor_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => customqmltpeq(W,succ(succ(succ(n0))),n3) ) ).

tff(verify,conjecture,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ( ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => true(W0) )
       => ! [W0: '$ki_world'] :
            ( '$ki_accessible'(W,W0)
           => true(W0) ) ) ) ).

%------------------------------------------------------------------------------
